/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*************************************************************************/
/* PROCEDURE NAME : GplGenerateGammas                                    */
/* AUTHOR         : Tom Spurrier                                         */
/* DATE WRITTEN   : 2/15/95                                              */
/* DESCRIPTION    :  See below                                           */
/*                                                                       */
/*                  Control Flow:                                        */
/*                                                                       */
/* PARAMETERS:      PDITHEREQUEST pReq, float fgamma, int ibase          */
/*                  where                                                */
/*                                                                       */
/* RETURN VALUES:                                                        */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                             */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*************************************************************************/
#define INCL_DOS
#define INCL_DEV
#define INCL_PM
#define INCL_SPL
#define INCL_SPLFSE
#include <os2.h>

#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GRE_COLORTABLE
#define INCL_GRE_BITMAPS
#define INCL_GRE_DEVMISC3
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
#include <pmddi.h>
#include "def.h"
#include "driver.h"
#include "funcs.h"

#if 0
LONG GenerateGammas  (    PRESINFO        pRes,
                          PMEDIAINFO      pMediaInfo,
                          PDEVICEINFO     pDev,
                          PDITHEREQUEST   pReq )
{
  ULONG ulRes;
  pReq->ulRBias  = pRes->ulBias;
  pReq->ulGBias  = pRes->ulBias;
  pReq->ulBBias  = pRes->ulBias;

  ulRes = pReq->ulResolution;

  pReq->ulRGamma = ulRes / 10 - 1;
  pReq->ulGGamma = ulRes / 10 - 1;
  pReq->ulBGamma = ulRes / 10 - 1;

  if( pDev->pInkInfo->ulShape == SQUARE_SPOT )
  {
    pReq->ulRGamma += pReq->ulRGamma/10;
    pReq->ulGGamma += pReq->ulGGamma/10;
    pReq->ulBGamma += pReq->ulBGamma/10;
  }

  if( (pDev->pInkInfo->ulInkType == LIQUID_INK) &&
      (pReq->bReq == CMY_ALL) )
  {
    if( pDev->pInkInfo->ulCLumina == THIN_INK )
    {
      pReq->ulGGamma += pReq->ulGGamma/20;
      pReq->ulBGamma += pReq->ulBGamma/30;
    }

    if( pDev->pInkInfo->ulMLumina == THIN_INK )
    {
      pReq->ulRGamma += pReq->ulRGamma/40;
      pReq->ulBGamma += pReq->ulBGamma/30;
    }
    if( pDev->pInkInfo->ulYLumina == THIN_INK )
    {
      pReq->ulRGamma += pReq->ulRGamma/40;
      pReq->ulGGamma += pReq->ulGGamma/20;
    }

    if( pDev->pInkInfo->ulKLumina == THIN_INK )
    {
      pReq->ulRGamma += pReq->ulRGamma/20;
      pReq->ulGGamma += pReq->ulGGamma/10;
      pReq->ulBGamma += pReq->ulBGamma/15;
    }
  }

  if( pReq->lDitherType == HT_MAGIC_SQUARES || 
      pReq->lDitherType == HT_LEVEL )
  {
    pReq->ulRGamma += pReq->ulRGamma/10;
    pReq->ulGGamma += pReq->ulGGamma/10;
    pReq->ulBGamma += pReq->ulBGamma/10;
  }

  if( pMediaInfo->fColorAdjustRequired ||
      pMediaInfo->ulAbsorptionAdjust == NO_ABSORPTION ||
      ulRes >= 360 )
  {
    if( ulRes < 360 )
    {
      pReq->ulRGamma -= pReq->ulRGamma/6;
      pReq->ulGGamma -= pReq->ulGGamma/6;
      pReq->ulBGamma -= pReq->ulBGamma/6;
    }
    
    if( pReq->bReq == CMYK_ALL && ulRes >= 360 )
    {
      pReq->ulRGamma -= pReq->ulRGamma/4;
      pReq->ulGGamma -= pReq->ulGGamma/4;
      pReq->ulBGamma -= pReq->ulBGamma/4;
    } 
    else if( pReq->bReq == CMY_ALL && ulRes >= 360 )
    {
       pReq->ulRGamma  = (pReq->ulRGamma *  95 ) / 100;
       pReq->ulGGamma  = (pReq->ulGGamma * 125 ) / 100;
       pReq->ulBGamma  = (pReq->ulBGamma * 110 ) / 100;
    }
    else if( pReq->bReq == CMY_ALL && ulRes < 360 )
    {
      pReq->ulRGamma  = (pReq->ulRGamma * 72 ) / 100;
      pReq->ulBGamma  = (pReq->ulBGamma * 85 ) / 100;
    }
  }

}
#endif

