/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#pragma pack(1)

//-------------------------------------
// External Form Information Structures
//-------------------------------------
#define SIZEOF_EXTFORMINFO_1_1                      124  // can't switch sizeof () :(

typedef struct _Extern_FormInfo_1_1 {  // sizeof == 124
   ULONG         ulFormID;
   ULONG         ulFormCap;            // Form capabilities (FORM_CAP_XXX)
   ULONG         ulFormClass;
   ULONG         ulNameID;
   USHORT        usLenCmdSelectForm;
   CHAR          szCmdSelectForm[32];
   BYTE          abPadding[2];         // ***PADDING***
   HCINFO        hcInfo;
   BOOL          bHasBeenSetup;
} EXTFORMINFO_1_1, *PEXTFORMINFO_1_1, **PPEXTFORMINFO_1_1;

#define SIZEOF_EXTFORMINFO_1_5                      128  // can't switch sizeof () :(

typedef struct _Extern_FormInfo_1_5 {  // sizeof == 128
   ULONG         ulFormID;
   ULONG         ulFormCap;            // Form capabilities (FORM_CAP_XXX)
   BYTE          ulDJPid;              // DJP_SJ_PAPERSIZE id
   BYTE          abPadding1[3];        // ***PADDING***
   ULONG         ulFormClass;
   ULONG         ulNameID;
   USHORT        usLenCmdSelectForm;
   CHAR          szCmdSelectForm[32];
   BYTE          abPadding2[2];         // ***PADDING***
   HCINFO        hcInfo;
   BOOL          bHasBeenSetup;
} EXTFORMINFO_1_5, *PEXTFORMINFO_1_5, **PPEXTFORMINFO_1_5;

#define SIZEOF_EXTFORMINFO_1_21                     140  // can't switch sizeof () :(

typedef struct _Extern_FormInfo_1_21 { // sizeof == 140
   ULONG         ulFormID;
   ULONG         ulFormCap;            // Form capabilities (FORM_CAP_XXX)
   BYTE          ulDJPid;              // DJP_SJ_PAPERSIZE id
   BYTE          abPadding1[3];        // ***PADDING***
   ULONG         ulFormClass;
   ULONG         ulNameID;
   USHORT        usLenCmdSelectForm;
   CHAR          szCmdSelectForm[44];
   BYTE          abPadding2[2];        // ***PADDING***
   HCINFO        hcInfo;
   BOOL          bHasBeenSetup;
} EXTFORMINFO_1_21, *PEXTFORMINFO_1_21, **PPEXTFORMINFO_1_21;

// printer property app/keynames
#define KEYNAME_NUM_USER_FORMS          "NumUserDefForms"
#define KEYNAME_USER_FORMS              "UserDefForms"
#define KEYNAME_VERSION_KEY_USER_FORMS  "VersionUserDefForms"
#define KEYNAME_VERSION_DATA_USER_FORMS "1.1"

/* This is the version that we save to the ini file!
*/
typedef struct _Extern_FormInfo_1_1 EXTFORMINFOSAVE, *PEXTFORMINFOSAVE;

typedef struct _FormInfo {
   ULONG         ulSize;
   ULONG         cx;
   ULONG         cy;
   ULONG         ulTop;
   ULONG         ulRight;
   ULONG         ulBottom;
   ULONG         ulLeft;
   FORMINFO2     Form;
   BOOL          bUseInches;
   BOOL          bNoEdit;
   BOOL          bEntryChanging;
   RECTL         rectlWnd;
   RECTL         rectlPage;
   RECTL         rectlClip;
   SIZEL         sizelPage;
} FORMINFO, *PFORMINFO;

#pragma pack()

#define WM_USER_INFO   ( WM_USER + 1 )

#ifdef INCL_WIN
/* Data about the *public* entry field control
** Note, we don't change it. So it should be safe as global data.
*/
extern CLASSINFO   eci;

MRESULT EXPENTRY SubClassedEntryWndProc (HWND, ULONG, MPARAM, MPARAM);
#endif
