/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Omni Driver Enable File                                 */
/* SOURCE NAME    : ENABLE.C                                                */
/* AUTHOR         : Matt Rutkowski & Mark Hamzy                             */
/* DESCRIPTION    : provides entry points for:                              */
/*                    OS2_PM_DRV_ENABLE                                     */
/*                    OS2_PM_DRV_DEVMODE                                    */
/*                    OS2_PM_DRV_DEVICENAMES                                */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @100713 - 10/04/94 - MFR [IBM] - Need to default to A4 for most          */
/*                                  countries but USA, Canada, and Brazil.  */
/*                                  Also default to CM not inches.          */
/* @121186 - 06/15/95 - MFR [IBM] - added fix so apps using the "FORM="     */
/*                                  spooler parameter would receive correct */
/*                                  xPels, yPels values querying driver.    */
/*                                  (This fixes APAR = PJ18337)             */
/* @138997 - 10/02/95 - LMM [IBM] - Remove access to PMWINP.H               */
/* @178797 - 05/22/97 - MJH [IBM] - Need to default to A4 for Brazil        */
/* @195199 - 04-27-98 - MJH [IBM] - Don't create an 8x8 bitmap for PM_Q_STD */
/*                                  Instead, hook out blt and line.         */
/* @3632   - 04/08/98 - UCC [IBMJ]- Add 2 flag for DevFnt sup use.          */
/*                                  fRecoding is for HiRes devfnt print prob*/
/*                                  fOldDevfnt is for backward compatibility*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Expansible job data support             */
/*                                                                          */
/*                                          support                         */
/* @JPN2H99- 08/01/99 - UCC [IBMJ]- Fix duplex printing problem and H/W nup */
/*                                  problems. Added printer properties supp */
/*                                                                          */
/****************************************************************************/

#define INCL_DOS
#define INCL_GPI
#define INCL_DEV
#define INCL_SPL
#define INCL_SPLDOSPRINT
#define INCL_SPLFSE
#define INCL_WINSEI
#define INCL_WINSHELLDATA
#define INCL_GPIERRORS
#define INCL_GPIPRIMITIVES

// @NB
#define INCL_WINMENUS
#define INCL_WINFRAMEMGR  // @NB
#define INCL_WINWINDOWMGR // @NB
#define INCL_WINDIALOGS
#define INCL_WINSTDBOOK   // @NB
#define INCL_WININPUT     // @NB
#define INCL_DOSERRORS

// DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#endif

#include <os2.h>

// @138997 - Remove
//#define INCL_WINP_FSRS
//#include <pmwinp.h>

#define INCL_GREALL
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

#define INCL_GENPLIB_QUERYMEM
#define INCL_GENPLIB_PATTERNS          /* genplib pattern create/del        */
#include <genplib.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <math.h>    // @169465

#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "fonts.h"

// enable defines
#define FILL_LOGICAL                    1
#define FILL_PHYSICAL                   2
                                     /* 3 reserved by display */
#define DISABLE_PHYSICAL                4
#define ENABLE_DC                       5
#define DISABLE_DC                      6
#define SAVE_DC                         7
#define RESTORE_DC                      8
#define RESET_DC                        9
#define COMPLETE_OPEN_DC               10
#define BEGIN_CLOSE_DC                 11
#define QUERY_DEVICE_SURFACE           14
#define DISABLE_LOGICAL                15

// Fill logical device block parameter structures

struct _LDEVPARM1 {
  ULONG   ulGreVersion;         // graphic engine version
  ULONG   ulDispatchTableSize;  // size of dispatch table
};
typedef struct _LDEVPARM1  LDEVPARM1, *PLDEVPARM1;

struct _LDEVPARM2 {
  PUSHORT  pusFlags;           // bits 0,1,2, 7 modified
  PFN *    ppfnDispatchTable;  // pointer to first function pointer in the dispatch table
};
typedef struct _LDEVPARM2  LDEVPARM2, *PLDEVPARM2;

struct _EDEVOPENSTRUC {
   // DEVOPENSTRUC
   PSZ         pszLogAddress;
   PSZ         pszDriverName;
   PDRIVDATA   pdriv;
   PSZ         pszDataType;
   PSZ         pszComment;
   PSZ         pszQueueProcName;
   PSZ         pszQueueProcParams;
   PSZ         pszSpoolerParams;
   PSZ         pszNetworkParams;
   // DENPARMS
   ULONG       ulStateInfo;
   ULONG       ulDCType;
   HDC         hdcCompat;
};
typedef struct _EDEVOPENSTRUC EDEVOPENSTRUC, *PEDEVOPENSTRUC;

/* Function prototypes...
*/
LONG          MetafileBitBlt            (PBITBLTINFO pBBI,
                                         ULONG       ulReserved);
LONG          MetafileLine              (PLINEINFO   pLI,
                                         ULONG       ulReserved);

/****************************************************************************/
/* PROCEDURE NAME : InitStringTable                                         */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 9/23/93                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* @TBD - change 256, 255 to macro constants                                */
/*                                                                          */
/* @TBD - need to load/unload string table based on memory page faults      */
/* on an address range - MFR                                                */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* 181074 - MJH - handled case where string was not defined in the resource */
/*                file                                                      */
/*                                                                          */
/****************************************************************************/
VOID
InitStringTable (ULONG ulTableID)
{
   SHORT       sLen;
   CHAR        szTemp[256];
   ULONG       i;
#ifdef DEBUG
   PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

   DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Enter\n", __FUNCTION__));

   if (ulTableID & STRINGS_BASE)
   {
      if (globals.bBaseStringTableInitialized == FALSE)
      {
         DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Init Base Strings\n", __FUNCTION__));
         DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): From %d to %d = %d\n",
                     __FUNCTION__,
                     0,
                     (STRING_TABLE_MEDIA_END - STRING_TABLE_BASE),
                     (STRING_TABLE_MEDIA_END - STRING_TABLE_BASE)));

         // @TTY - load strings into global shared heap here
         for (i = 0; i < (STRING_TABLE_MEDIA_END - STRING_TABLE_BASE); i++)
         {
            // This is an uninitialised entry,  so fill it in now.
            if ((sLen = WinLoadString ((HAB)NULL,
                                       globals.hModule,
                                       (USHORT)(STRING_TABLE_BASE + i),
                                       255, (PSZ)szTemp)) != 0)
            {
               // WinLoadString successful
               globals.pbStringTable[i] = GplMemoryAlloc (globals.pvSharedHeap, sLen + 1);

               strcpy (globals.pbStringTable[i], szTemp);

               DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Adding string %d: %s\n",
                           __FUNCTION__, STRING_TABLE_BASE+i, szTemp));
            }
            else
            {
               DBPRINTF (("String %d (\"", STRING_TABLE_BASE+i));
#ifdef DEBUG
               DebugPrintDefine (STRING_TABLE_BASE+i);
#endif
               // temporary fix for non translated mri
               
               switch (STRING_TABLE_BASE+i)
               {
               case FORM_STRING_OFUKU_HAGAKI:
                  strcpy (szTemp,"Ofuku-Hagaki");
                  break;
               case FORM_STRING_KAKU_2:
                  strcpy (szTemp,"Japanese Kaku #2");
                  break;
               case FORM_STRING_KAKU_3:
                  strcpy (szTemp,"Japanese Kaku #3");
                  break;
               case FORM_STRING_KAKU_4:
                  strcpy (szTemp,"Japanese Kaku #4");
                  break;
               case FORM_STRING_HP_GREETING_CARD:
                  strcpy (szTemp,"HP Greeting Card");
                  break;
               default:

                  DBPRINTF (("String %d failed to load!\n", STRING_TABLE_BASE+i));
                  assertF (sLen);

                  strcpy (szTemp,"");
                  break;
               }
               globals.pbStringTable[i] = GplMemoryAlloc (globals.pvSharedHeap, strlen(szTemp) + 1);
               strcpy (globals.pbStringTable[i], szTemp);
            }
         }

         globals.bBaseStringTableInitialized = TRUE;
      }
   }

   if (ulTableID & STRINGS_DIALOG)
   {
      if (globals.bDlgStringTableInitialized == FALSE)
      {
         DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Init Dialog Strings\n", __FUNCTION__));
         DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): From %d to %d = %d\n",
                     __FUNCTION__,
                     ((STRING_TABLE_DLG_BASE) - (STRING_TABLE_BASE)),
                     ((STRING_TABLE_END) - (STRING_TABLE_BASE)),
                     ((STRING_TABLE_END) - (STRING_TABLE_BASE)) - ((STRING_TABLE_DLG_BASE) - (STRING_TABLE_BASE))));

         for (i = ((STRING_TABLE_DLG_BASE) - (STRING_TABLE_BASE)); i < ((STRING_TABLE_END) - (STRING_TABLE_BASE)); i++)
         {
            // This is an uninitialised entry,  so fill it in now.
            if ((sLen = WinLoadString ((HAB)NULL,
                                       globals.hModule,
                                       (USHORT)(STRING_TABLE_BASE + i),
                                       255, (PSZ)szTemp)) != 0)
            {
               // WinLoadString successful
               globals.pbStringTable[i] = GplMemoryAlloc (globals.pvSharedHeap, sLen + 1);

               strcpy (globals.pbStringTable[i], szTemp);

               DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Adding string %d: %s\n",
                           __FUNCTION__, STRING_TABLE_BASE+i, szTemp ));
            }
            else
            {
               DBPRINTF (("String %d (\"", STRING_TABLE_BASE+i));
#ifdef DEBUG
               DebugPrintDefine (STRING_TABLE_BASE+i);
#endif
               switch (STRING_TABLE_BASE+i)
               {
               case HALFTONE_STRING_ERR_DIFFUSE6:
                  strcpy (szTemp,"Stucki Diffusion 6 color");
                  break;
               case HALFTONE_STRING_ERR_DIFFUSE5:
                  strcpy (szTemp,"Stucki Diffusion 5 color");
                  break;
               case MSG_STR_TEST:
                  strcpy (szTemp,"This test pattern can be used to verify the correct operation of your printer.");
                  break;
               case MSG_STR_DEMO:
                  strcpy (szTemp,"This test pattern can be used to print a sample document on your printer.");
                  break;
               case MSG_STR_NOZZLE:
                  strcpy (szTemp,"This test pattern can be used to test the operation of the Bubble Jet ink head nozzles.");
                  break;
               case MSG_STR_EXIT:
                  strcpy (szTemp,"Exit...");
                  break;
               case MSG_STR_CLEANING:
                  strcpy (szTemp,"If your printer is not printing clearly, try cleaning the print heads...");
                  break;
               case MSG_STR_MAINTENANCE:
                  strcpy (szTemp,"This page contains Maintenance/Control procedures of your device");
                  break;
               case MSG_STR_ALIGNMENT:
                  strcpy (szTemp,"Executes print head alignment...");
                  break;
               default:

                  DBPRINTF (("\"failed to load!\n"));
                  assertF (sLen);
                  
                  strcpy (szTemp,"");
                  break;
               }
               globals.pbStringTable[i] = GplMemoryAlloc (globals.pvSharedHeap, strlen(szTemp) + 1);
               strcpy (globals.pbStringTable[i], szTemp);
            }
         }

         globals.bDlgStringTableInitialized = TRUE;
      }
   }

   DBPRINTIF ((pDbg->bINITSTRINGTABLE, "%s(): Exit\n", __FUNCTION__));

} /* end InitStringTable */

/****************************************************************************/
/* PROCEDURE NAME : ValidatePointer                                         */
/* AUTHOR         : Mark H                                                  */
/* DATE WRITTEN   : 9/23/93                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
ValidatePointer (PBYTE pbPointer, INT iType, ULONG ulSize)
{
   REGREC       regrec;
   ULONG        ulException;
   CHAR         chRead;
   BOOL         bRC;
   register INT i;

   if (!pbPointer)
      return FALSE;

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
      // clean up here as required

      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }
      // error result
      bRC = FALSE;
      goto depart;
   }

   switch (iType)
   {
   case VALIDATE_TYPE_STRING:
      i = 0;
      while (*pbPointer && i < ulSize)
      {
         pbPointer++;
         i++;
      }
      break;

   case VALIDATE_TYPE_BLOCK:
      i = 0;
      do
      {
         chRead = pbPointer[i];

         i = (i + 0x100) & 0xFFFFF000;
      } while (i < ulSize);

      // next statement is useless for code but helpful to remove
      // compiler warning
      if (chRead) chRead++;
      break;
   }

   bRC = TRUE;

depart:
   UNREGISTERHANDLER (regrec);
   return bRC;
}

/****************************************************************************/
/* PROCEDURE NAME : ResolutionToStyleRatio                                  */
/* AUTHOR         : Mark H                                                  */
/* DATE WRITTEN   : 9/23/93                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BYTE
ResolutionToStyleRatio (ULONG ulRes)
{
   ULONG ulRet;

   /* At 300 dpi, the result should be 40 hex.  At higher dpi, it should
   ** be smaller and vice versa.  Also, the result should divide into 100
   ** hex evenly.
   */
   ulRet = 0x40 * 300 / ulRes;
   if (!ulRet)
      ulRet = 0x40;

   /* Does it divide evenly?
   */
   if (0x100 % ulRet)
   {
      /* Keep moving down until it does...
      */
      while (0x100 % ulRet)
      {
         ulRet--;
      }
   }

   return (BYTE)ulRet;
}

/****************************************************************************/
/* PROCEDURE NAME :                                   */
/* AUTHOR         : Mark H                                                  */
/* DATE WRITTEN   : 3/26/98                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
#ifdef DEBUG
VOID
DebugPrintDCType (BOOL bShow, PDDC pddc, PSZ pszSubFunc)
{
   switch (pddc->pdb->ulType)
   {
   case OD_QUEUED:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_QUEUED)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }

   case OD_DIRECT:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_DIRECT)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }

   case OD_INFO:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_INFO)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }

   case OD_MEMORY:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_MEMORY)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }

   case OD_METAFILE:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_METAFILE)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }

   case OD_METAFILE_NOQUERY:
   {
      DBPRINTIF ((bShow, "%s: DC Type = %d (OD_METAFILE_NOQUERY)\n",
                  pszSubFunc, pddc->pdb->ulType));
      break;
   }
   }
}
#else
#define DebugPrintDCType(a,b,c)
#endif

// @DEVFNT
#ifndef NGreQueryDevFntMetrics
#define NGreQueryDevFntMetrics 0x000060CCL
#endif

/****************************************************************************/
/* PROCEDURE NAME : OS2_PM_DRV_ENABLE                                       */
/* AUTHOR         : Matt Rutkowski & Mark Hamzy                             */
/* DATE WRITTEN   : 10-18-93                                                */
/* DESCRIPTION    : Main entry point into the Omni driver                   */
/*                                                                          */
/*                                                                          */
/* PARAMETERS:      INPUT:                                                  */
/*                  OUTPUT:                                                 */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* @98155  - 09/17/94 - Matt Rutkowski [IBM] - Succeed if Logical address   */
/*                      is NULL during FillPhysical and DRIVDATA is valid.  */
/*                      very common for network printing.                   */
/*                                                                          */
/* @121186 - 06/15/95 - Matt Rutkowski [IBM] - added fix so apps using the  */
/*                      "FORM=" spooler parameter would receive correct     */
/*                      xPels, yPels values when querying driver.           */
/*                      (This fixes APAR = PJ18337)                         */
/* @EXJOB  - 07/13/98 - UCC [IBMJ] - Expansible job data support.           */
/*                      Change code to support H/W COP=n.                   */
/*                                                                          */
/****************************************************************************/
ULONG APIENTRY
OS2_PM_DRV_ENABLE (ULONG ulSubFunc, ULONG p1, ULONG p2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   APIRET             rc;
   BOOL               bRC;
   LONG               lWork;
   PCHAR              pch;
   PCHAR              pch2;
   PDDC               pddc;
   PDEVICEBLOCK       pdb;
   HMCB               hmcbHeap       = NULL;
   PUSHORT            pusFlags;
   REGREC             regrec;
   ULONG              ulException;
   ULONG              ulrc           = -1; // Assume an error condition
   CHAR               szWork[48];
   HRGN               hrgnOld        = 0;
#ifdef DEBUG
   PDEBUGINFO         pDbg           = &globals.DebugInfo;
   BOOL               bShow;
#endif

   /*------------------------------------------------------------------------*/
   /* EXCEPTION HANDLER                                                      */
   /*------------------------------------------------------------------------*/
   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);

   // if we took an exception...
   if (ulException)
   {
      // clean up here as required
      switch (ulSubFunc)
      {
      case FILL_PHYSICAL:
      {
         if (hmcbHeap)
         {
            hmcbHeap = (HMCB)GplMemoryDeleteInstance (hmcbHeap);
            assertT (hmcbHeap);
            hmcbHeap = NULL;
         }
         break;
      }
      }

      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
          DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
          DosExit (EXIT_THREAD, 0);
      }

      // error result
      ulrc = -1;
      goto depart;
   }

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

#ifdef DEBUG
   /*---------------------------------------*/
   /* Initialize debug information          */
   /*---------------------------------------*/
   if (!globals.bDebugInfoInitialized)
   {
      bRC = InitDebugInfo (pDbg, FALSE, FALSE);
      assertF (bRC);
   }

   // set debug information on for correct subfunction
   switch (ulSubFunc)
   {
   case FILL_LOGICAL:
      bShow = pDbg->bENABLE_FILL_LOGICAL;
      break;
   case FILL_PHYSICAL:
      bShow = pDbg->bENABLE_FILL_PHYSICAL;
      break;
   case DISABLE_PHYSICAL:
      bShow = pDbg->bENABLE_DISABLE_PHYSICAL;
      break;
   case ENABLE_DC:
      bShow = pDbg->bENABLE_ENABLE_DC;
      break;
   case DISABLE_DC:
      bShow = pDbg->bENABLE_DISABLE_DC;
      break;
   case COMPLETE_OPEN_DC:
      bShow = pDbg->bENABLE_COMPLETE_OPEN_DC;
      break;
   case BEGIN_CLOSE_DC:
      bShow = pDbg->bENABLE_BEGIN_CLOSE_DC;
      break;
   case RESET_DC:
      bShow = pDbg->bENABLE_RESET_DC;
      break;
   case RESTORE_DC:
      bShow = pDbg->bENABLE_RESTORE_DC;
      break;
   case SAVE_DC:
      bShow = pDbg->bENABLE_SAVE_DC;
      break;
   case QUERY_DEVICE_SURFACE:
      bShow = pDbg->bENABLE_FILL_PHYSICAL;
      break;
   }
#endif

   // The OS/2 driver enable function is called multiple times
   // each time a specific subfunction is requested.  Find out
   // which subfunction is requested for this iteration.
   switch (ulSubFunc)
   {
   case FILL_LOGICAL:
   {
      // p1 points to engine version and dispatch table size
      // p2 points to flags and dispatch table
      // there is no inverse disable step to this subfunction

      assertF (p1);
      assertF (p2);

      // init the globals structure if not already done
      rc = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
      DBPRINTIF ((bShow, "FILL_LOGICAL(1): DosRequestMutexSem: rc=%d, hmtx = %x\n", rc, procdata.hmtxGlobalSem));
      assertT (rc);

      DBPRINTIF ((bShow, "FILL_LOGICAL(1): p1=%x, p2=%x\n", p1, p2));

      if (NULL == globals.ppfnDispatchTableCopy)
      {
         // copy params to global shared space
         globals.ulGreVersion          = ((PLDEVPARM1)p1)->ulGreVersion;
         globals.cDispatchEntries      = ((PLDEVPARM1)p1)->ulDispatchTableSize;
         DBPRINTIF ((bShow, "FILL_LOGICAL(1): Engine version = %X\n", globals.ulGreVersion));

         SetNumberOfPrinters ();

         // compute length required for copy of dispatch table
         lWork = sizeof(PFN)*globals.cDispatchEntries;

         // allocate memory for the copy out of shared space
         DBPRINTIF ((bShow, "FILL_LOGICAL(1): Allocate Dispatch Table; size=%lu; heap=%x\n", lWork, globals.pvSharedHeap));
         globals.ppfnDispatchTableCopy = GplMemoryAlloc (globals.pvSharedHeap, lWork);
         assertF (globals.ppfnDispatchTableCopy);

         // make a copy the table as supplied by the engine
         assertF (((PLDEVPARM2)p2)->ppfnDispatchTable);
         memcpy (globals.ppfnDispatchTableCopy, ((PLDEVPARM2)p2)->ppfnDispatchTable, lWork);

         // change function pointers in the engine's dispatch table
         if (GRE_22 <= globals.ulGreVersion)
         {
            DBPRINTF (("FILL_LOGICAL(1): Raster Graphics Engine 2.2 enabled\n"));
            // 2.2 Engine or above
            // escape
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreEscape                    & 0x00FF ] = (PFN)Escape;
            // query functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryHardcopyCaps         & 0x00FF ] = (PFN)QueryHardcopyCaps;
            // Hokey
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  0x4040                        & 0x00FF ] = (PFN)DevicePalette;
            // @DEVFNT
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryDevFntMetrics        & 0x00FF ] = (PFN)QueryDevFntMetrics;
         }
         else
         {
            DBPRINTF (("FILL_LOGICAL(1): PMPRE32 enabled!\n"));
            // Not the 2.2 Engine
            // attribute functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceSetAttributes       & 0x00FF ] = (PFN)DeviceSetAttributes;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceGetAttributes       & 0x00FF ] = (PFN)DeviceGetAttributes;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceSetGlobalAttribute  & 0x00FF ] = (PFN)DeviceSetGlobalAttribute;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetPairKerningTable       & 0x00FF ] = (PFN)GetPairKerningTable;
            // bitmap functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreBitblt                    & 0x00FF ] = (PFN)Bitblt;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceCreateBitmap        & 0x00FF ] = (PFN)DeviceCreateBitmap;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceDeleteBitmap        & 0x00FF ] = (PFN)DeviceDeleteBitmap;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceSelectBitmap        & 0x00FF ] = (PFN)DeviceSelectBitmap;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDrawBits                  & 0x00FF ] = (PFN)DrawBits;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDrawBorder                & 0x00FF ] = (PFN)DrawBorder;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetBitmapBits             & 0x00FF ] = (PFN)GetBitmapBits;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetPel                    & 0x00FF ] = (PFN)GetPel;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreImageData                 & 0x00FF ] = (PFN)ImageData;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetBitmapBits             & 0x00FF ] = (PFN)SetBitmapBits;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetPel                    & 0x00FF ] = (PFN)SetPel;
            // color table functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreCreateLogColorTable       & 0x00FF ] = (PFN)CreateLogColorTable;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryColorData            & 0x00FF ] = (PFN)QueryColorData;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryColorIndex           & 0x00FF ] = (PFN)QueryColorIndex;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryLogColorTable        & 0x00FF ] = (PFN)QueryLogColorTable;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryNearestColor         & 0x00FF ] = (PFN)QueryNearestColor;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryRealColors           & 0x00FF ] = (PFN)QueryRealColors;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryRGBColor             & 0x00FF ] = (PFN)QueryRGBColor;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreRealizeColorTable         & 0x00FF ] = (PFN)RealizeColorTable;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreUnrealizeColorTable       & 0x00FF ] = (PFN)UnrealizeColorTable;
            // device functions set 2
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceQueryFontAttributes & 0x00FF ] = (PFN)DeviceQueryFontAttributes;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceQueryFonts          & 0x00FF ] = (PFN)DeviceQueryFonts;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreErasePS                   & 0x00FF ] = (PFN)ErasePS;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreNotifyClipChange          & 0x00FF ] = (PFN)NotifyClipChange;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreNotifyTransformChange     & 0x00FF ] = (PFN)NotifyTransformChange;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreRealizeFont               & 0x00FF ] = (PFN)RealizeFont;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreRealizeFont               & 0x00FF ] = (PFN)RealizeFont;
            // device functions set 3
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreAccumulateBounds          & 0x00FF ] = (PFN)AccumulateBounds;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDeviceSetDCOrigin         & 0x00FF ] = (PFN)DeviceSetDCOrigin;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetBoundsData             & 0x00FF ] = (PFN)GetBoundsData;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetCodePage               & 0x00FF ] = (PFN)GetCodePage;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetDCOrigin               & 0x00FF ] = (PFN)GetDCOrigin;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetLineOrigin             & 0x00FF ] = (PFN)GetLineOrigin;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreLockDevice                & 0x00FF ] = (PFN)LockDevice;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreResetBounds               & 0x00FF ] = (PFN)ResetBounds;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetCodePage               & 0x00FF ] = (PFN)SetCodePage;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetLineOrigin             & 0x00FF ] = (PFN)SetLineOrigin;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreUnlockDevice              & 0x00FF ] = (PFN)UnlockDevice;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetStyleRatio             & 0x00FF ] = (PFN)GetStyleRatio;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetStyleRatio             & 0x00FF ] = (PFN)SetStyleRatio;
            // escape
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreEscape                    & 0x00FF ] = (PFN)Escape;
            // lines
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDisjointLines             & 0x00FF ] = (PFN)DisjointLines;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreDrawLinesInPath           & 0x00FF ] = (PFN)DrawLinesInPath;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetCurrentPosition        & 0x00FF ] = (PFN)GetCurrentPosition;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGrePolyLine                  & 0x00FF ] = (PFN)PolyLine;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGrePolyScanline              & 0x00FF ] = (PFN)PolyScanline;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGrePolyShortLine             & 0x00FF ] = (PFN)PolyShortLine;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetCurrentPosition        & 0x00FF ] = (PFN)SetCurrentPosition;
            // markers
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGrePolyMarker                & 0x00FF ] = (PFN)PolyMarker;
            // query functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryDeviceBitmaps        & 0x00FF ] = (PFN)QueryDeviceBitmaps;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryDeviceCaps           & 0x00FF ] = (PFN)QueryDeviceCaps;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryDevResource2         & 0x00FF ] = (PFN)QueryDevResource2;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryHardcopyCaps         & 0x00FF ] = (PFN)QueryHardcopyCaps;
            // text functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreCharString                & 0x00FF ] = (PFN)CharString;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreCharStringPos             & 0x00FF ] = (PFN)CharStringPos;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryCharPositions        & 0x00FF ] = (PFN)QueryCharPositions;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryTextBox              & 0x00FF ] = (PFN)QueryTextBox;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreQueryWidthTable           & 0x00FF ] = (PFN)QueryWidthTable;
            // misc functions
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreGetPickWindow             & 0x00FF ] = (PFN)GetPickWindow;
            ((PLDEVPARM2)p2)->ppfnDispatchTable[  NGreSetPickWindow             & 0x00FF ] = (PFN)SetPickWindow;
         }

         // assign a local copy of the pointer to a WORD of flags
         pusFlags = ((PLDEVPARM2)p2)->pusFlags;
         // set flags; clear bits 0,1,2
         *pusFlags &= 0xFFF8;
         // bit 0: each dc has own physical device block
         // bit 7: mult dispatch tables on fill physical
         *pusFlags |= 0x0081;

         // Initialize strings we may use (Form Names for Spooler Parm matches etc.)
         //@246315:User-Defined Connection additional message. There was incorrect
         //message for Manual feeder because of uninitialised dialogue strings         
         InitStringTable (STRINGS_BASE | STRINGS_DIALOG);
         DBPRINTIF ((bShow, "FILL_LOGICAL: StringTable Initialized, pb[0] = %x\n", globals.pbStringTable[0]));

         // Check GRE version for presence of SoftDraw support.
         // If PM Graphics Engine version is less than 2.2 we can not
         // use their SoftDraw rasterizer and must use a replacement
         // This replacement rasterizer is called PRE32.DLL and is
         // a 256-color SVGA display driver modified from OS/2 DDK
         // for our use (NOTE: also used by OS/2 LaserJet driver)
         if (GRE_22 > globals.ulGreVersion)
         {
            register INT i;

            // Find fully-qualified path for the PRE32.DLL rasterizer
            // relative to where OMNI.DRV is installed
            assertF (globals.hModule);
            rc = DosQueryModuleName (globals.hModule,
                                     sizeof (globals.achPrePath),
                                     globals.achPrePath);
            assertT (rc);

            // Strip name 'OMNI.DRV' from end of fully-qualified path
            for (i = strlen (globals.achPrePath) - 1; i >= 0; i--)
            {
               if ('\\' == globals.achPrePath[i])
               {
                  globals.achPrePath[i+1] = 0;
                  break;
               }
            }

            // Assert if no '\\' found in path (implies earlier error)
            assertT (globals.achPrePath[i+1]);

            // Tack rasterizer name (PRE32.DLL) onto fully-qualified path
            strcat (globals.achPrePath, "PRE32.DLL");
         }
      }

      // Release global semaphore after PRE32 path is built
      rc = DosReleaseMutexSem (procdata.hmtxGlobalSem);
      DBPRINTIF ((bShow, "FILL_LOGICAL(1): DosReleaseMutexSem; rc=%d, hmtx = %x\n", rc, procdata.hmtxGlobalSem));
      assertT (rc);

      // success result
      ulrc = 0;
      break;
   } /* end FILL_LOGICAL */

   case DISABLE_LOGICAL:
   {
      // if p1 = 1, we are freeing ldev.

      DBPRINTIF ((bShow, "DISABLE_LOGICAL(15); p1 = %x\n", p1));

      // success result
      ulrc = 0;
      break;
   } /* end DISABLE_LOGICAL */

   case FILL_PHYSICAL:
   {
      PEDEVOPENSTRUC pEDOS;
      USHORT         usLen;
      BOOL           fFormFound;

      // p1 points to a DEVOPENSTRUC followed by stateinfo, type, and hdc
      // p2 is the per-DC dispatch table
      // inverse is DISABLE_PHYSICAL
      assertF (p1);
      assertF (p2);
      DBPRINTIF ((bShow, "FILL_PHYSICAL(2): p1 = %x p2 = %x\n", p1, p2));

      pEDOS = (PEDEVOPENSTRUC)p1;

      /*---------------------------------------*/
      /* Allocate per DC HEAP                  */
      /*---------------------------------------*/
      hmcbHeap = GplMemoryCreateInstance (LEN_DCHEAP,      // Size
                                          0,               // Extent
                                          0,               // Threshold
                                          PROCESS_MEMORY); // Type
      assertF (hmcbHeap);

      /*---------------------------------------*/
      /* Allocate PDEVICEBLOCK                 */
      /*---------------------------------------*/
      pdb = (PDEVICEBLOCK)GplMemoryAlloc (hmcbHeap, sizeof (DEVICEBLOCK));
      assertF (pdb);

      pdb->ulSig = DB_SIG;

      // Debugging aid...
      GplMemorySetUserID (hmcbHeap, (ULONG)pdb);

      /*---------------------------------------*/
      /* Store DC Heap in DEVICEBLOCK          */
      /*---------------------------------------*/
      pdb->hmcbHeap = hmcbHeap;

      /*---------------------------------------*/
      /* Create DC Semaphore                   */
      /*---------------------------------------*/
      rc = DosCreateMutexSem (NULL, &pdb->hmtxDCSem, 0, 0);
      assertT (rc);

      /*---------------------------------------*/
      /* @TBD - initialize ALL DEVICEBLOCK     */
      /*        variables to defaults          */
      /*---------------------------------------*/

      // fill in the rest of the structure
      pdb->pFormInfo            = (PFORMINFO2)GplMemoryAlloc (hmcbHeap, sizeof (FORMINFO2));
      pdb->pTrayInfo            = (PTRAYINFO)GplMemoryAlloc (hmcbHeap, sizeof (TRAYINFO));
      pdb->pMediaInfo           = (PMEDIAINFO)GplMemoryAlloc (hmcbHeap, sizeof (MEDIAINFO));
      pdb->fStartDocCalled      = FALSE;
      pdb->fRecording           = FALSE;                                        
      pdb->fOldDevfnt           = FALSE;                                        
      pdb->fAbortDocCalled      = FALSE;
      pdb->fRawDataOnPage       = FALSE;
      pdb->fRawOnly             = FALSE;
      pdb->szDocumentName[0]    = 0;
      pdb->ulPage               = 0;
      pdb->hThread              = NULL;
      pdb->bAllocatedPatterns   = FALSE;
      pdb->pszPrinterName       = NULL;
      pdb->pDevice              = NULL;
      pdb->pDriver              = NULL;
      pdb->dop.pszLogAddress    = NULL;
      pdb->dop.pszDriverName    = NULL;
      pdb->dop.pdriv            = NULL;
      pdb->dop.pszDataType      = NULL;
      pdb->dop.pszComment       = NULL;
      pdb->dop.pszQueueProcName = NULL;
      pdb->dop.pszSpoolerParams = NULL;
      pdb->pdfm                 = NULL;     // @DEVFNT
      pdb->pvDeviceCookie       = NULL;
      pdb->pDLLuseage           = NULL;     // Used only by the DLLBLD version
      pdb->SetAbortProc.hdc     = 0;        //@SAP
      pdb->SetAbortProc.pAbortProc = NULL;  //@SAP
      pdb->bNewJobProp          = TRUE;     // Fix DJP problem @JPN2H99
      pdb->pPrnProperties       = NULL;     // PrnProp Support @JPN2H99

      /*************************************************************************/
      /* Initialize Default Device Functions
      /*************************************************************************/
      pdb->pDevFuncs = (PFNSUBCLASS)GplMemoryAlloc (hmcbHeap,
                                                    sizeof (FNSUBCLASS));
      assertF (pdb->pDevFuncs);

      // Assign our default handlers for subclassable functions
      pdb->pDevFuncs->pfnDeviceOpen      = OmniDeviceOpen;
      pdb->pDevFuncs->pfnDeviceClose     = OmniDeviceClose;
      pdb->pDevFuncs->pfnSpoolerOpen     = OmniSpoolerOpen;
      pdb->pDevFuncs->pfnSpoolerStartJob = OmniSpoolerStartJob;
      pdb->pDevFuncs->pfnSpoolerEndJob   = OmniSpoolerEndJob;
      pdb->pDevFuncs->pfnSpoolerClose    = OmniSpoolerClose;

      // Device MUST always write printer-specific data otherwise we NO-OP
      pdb->pDevFuncs->pfnDeviceWrite     = NULL;

      // @100713 - need to get country code to determine what default
      // paper size to get (A4 is default in some countries, Letter
      // in others) also used for CM or Inch measures
      GetCountryInfo (&pdb->ctryCode, &pdb->ctryInfo);

      /*************************************************************************/
      /* Copy DEVOPENSTRUC to DEVICEBLOCK                                      */
      /* parse/validate fields if needed later (below)                         */
      /*************************************************************************/

      /*-----------------------------------------------------------------------*/
      /* Logical Address                                                       */
      /*-----------------------------------------------------------------------*/
      /* can be a filename, port, named pipe, or a queue name (preferred)      */
      /*-----------------------------------------------------------------------*/
      /*                                                                       */
      /* There are 2 tasks to perform at this stage:                           */
      /*                                                                       */
      /* 1) Find a valid set of DRIVDATA to use                                */
      /* 2) Find "Printer Name" that spooler                                   */
      /*                                                                       */
      /* There are several methods for achieving this depending on data        */
      /* caller provided.  These are shown as "Cases"                          */
      /*                                                                       */
      /* NOTE:                                                                 */
      /* It is possible, when a memory device context is opened, to be given   */
      /* no logical address or driver data.  Now we have a dilemma.  How can   */
      /* we initialize ourselves for the proper device?  Well, fortunately,    */
      /* the graphics engine (GE) will give us a compatible HDC.  With this,   */
      /* we can then ask the GE for a pddc for that compatible HDC.  We can    */
      /* now copy all the information that we need from that pddc.             */
      /*                                                                       */
      /*-----------------------------------------------------------------------*/

      bRC = ValidatePointer (pEDOS->pszLogAddress, VALIDATE_TYPE_STRING,
                             sizeof (pEDOS->pszLogAddress));

      /*-----------------------------------------------------------------------*/
      /* Case 1: No Logical Address & Compatible HDC given (memory DC)         */
      /*-----------------------------------------------------------------------*/
      if ((!bRC                        ||     // ValidatePointer failed
           (0 == *pEDOS->pszLogAddress) ) &&  // ValidatePointer succeeded but nothing there
          pEDOS->hdcCompat                 )  // Compatible DC handle given
      {
         PDDC         pDDCCompat;
         PDEVICEBLOCK pdbCompat;

         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): No logical address given but a comp DC was given\r\n"));

         // Ask GRE for pDDC assume hdvCompat is a valid HDC
         pDDCCompat = (PDDC)GetDriverInfo (pEDOS->hdcCompat, 0, pEDOS->hdcCompat);

         // If GRE returns a valid pDDC to us we're in business!
         if (GPI_ALTERROR != (LONG)pDDCCompat)
         {
            DBPRINTIF ((bShow, "FILL_PHYSICAL(2): pDDCCompt = %x\r\n", pDDCCompat));

            // Get PDEVICEBLOCK from compatible pDDC
            pdbCompat = pDDCCompat->pdb;
            DBPRINTIF ((bShow, "FILL_PHYSICAL(2): pdbCompat = %x\r\n", pdbCompat));

            /*-----------------------*/
            /* 1) Find DRIVDATA      */
            /*-----------------------*/

            // Allocate Driver Data for our PDEVICEBLOCK
            pdb->pDrivData = (PDRIVDATA)GplMemoryAlloc (hmcbHeap, DRIVERDATA_SIZE);
            assertF (pdb->pDrivData);

            // if allocation of DRIVDATA failed fail enable...
            if (!pdb->pDrivData)
            {
               DBPRINTIF ((bShow, "FILL_PHYSICAL(2): pdb->pDrivData memory allocation failed\n"));
               DestroyDeviceBlock (pdb);
               break;
            }

            // Copy the DRIVDATA from the compatible DC
            if (pdbCompat->pDrivData)
               memcpy ((PBYTE)pdb->pDrivData, (PBYTE)pdbCompat->pDrivData, DRIVERDATA_SIZE);

            /*-----------------------*/
            /* 2) Find Printer Name  */
            /*-----------------------*/

            // Allocate a copy of the printer name
            if (pdbCompat->pszPrinterName)
               pdb->pszPrinterName = (PSZ)GplMemoryAlloc (hmcbHeap,
                                                          strlen (pdbCompat->pszPrinterName)+1);
            assertF (pdb->pszPrinterName);
            if (!pdb->pszPrinterName)
            {
               DestroyDeviceBlock (pdb);
               break;            // Bomb out...
            }

            // And copy that data
            strcpy (pdb->pszPrinterName, pdbCompat->pszPrinterName);
            assertF (*pdb->pszPrinterName);
            DBPRINTIF(( bShow, "FILL_PHYSICAL(2): PrinterName = %s\n", pdb->pszPrinterName ));

            // Copy other important data...
            strcpy (pdb->szDriverName, pdbCompat->szDriverName);
            assertF (*pdb->szDriverName);

            strcpy (pdb->pDrivData->szDeviceName,
                    pdbCompat->pDrivData->szDeviceName);
            assertF (*pdb->pDrivData->szDeviceName);

  // DLLBLD is defined to build the dll version omni.drv
  #ifdef DLLBLD
            OMNILoadDLL (pdb->pDrivData->szDeviceName,
                         &(pdb->pDevice),
                         &(pdb->pDriver),
                         &(pdb->pDLLuseage));
  #endif
         }
         else
         {
            // GRE could not give us a valid pDDC too use, fail enable...
            assertstring ("FILL_PHYSICAL(2): GetDriverInfo returns ERROR!\n");
            DestroyDeviceBlock (pdb);
            break;
         }
      }
      /*-----------------------------------------------------------------------*/
      /* Case 2: Logical Address provided                                      */
      /*-----------------------------------------------------------------------*/
      else if (bRC && *pEDOS->pszLogAddress)
      {
         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): pszLogAddr = %s\n", pEDOS->pszLogAddress));

         SafeStrNCpy (pdb->szLogAddress,
                      pEDOS->pszLogAddress,
                      sizeof (pdb->szLogAddress));
         pdb->dop.pszLogAddress = pdb->szLogAddress;

         // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
         pszDeviceName = pEDOS->pdriv->szDeviceName;
         OMNILoadDLL (pszDeviceName,
                      &(pdb->pDevice),
                      &(pdb->pDriver),
                      &pDLLuseage);
         pdb->pDLLuseage = pDLLuseage;
#endif

         /*-----------------------*/
         /* 1) Find DRIVDATA      */
         /*-----------------------*/
         pdb->pDrivData = ReturnDriverData (pdb,
                                            (PDLGINSTANCE)NULL,
                                            hmcbHeap,
                                            pEDOS->pdriv,
                                            pdb->szLogAddress,
                                            FALSE,
                                            pdb->pDevice,
                                            pdb->pDriver);
         assertF (pdb->pDrivData);

         /*-----------------------*/
         /* 2) Find Printer Name  */
         /*-----------------------*/
         if (pdb->pszPrinterName == NULL)
         {
            // find printer name based on log address and DC Type
            pdb->pszPrinterName = FindPrinterName (pdb->hmcbHeap,
                                                   pdb->pDrivData->szDeviceName,
                                                   pdb->szLogAddress,
                                                   FALSE);
         }

         assertF (pdb->pszPrinterName);
         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): PrinterName = %s\n", pdb->pszPrinterName));
      }
      else
      {
         DBPRINTF (("FILL_PHYSICAL(2): Logical Address Invalid (%x)!!!! DANGER!!!\n", pEDOS->pszLogAddress));

         DBPRINTF (("FILL_PHYSICAL(2): What we do know:\n"));
         if(pEDOS->pszLogAddress)
            DBPRINTF (("      pszLogAddress = '%s'\n", pEDOS->pszLogAddress));

         if(pEDOS->pszDriverName)
            DBPRINTF (("      pszDriverName = '%s'\n", pEDOS->pszDriverName));

         /*-----------------------------------------------------------------------*/
         /* Case 3: Yes DRIVDATA & No Logical Address & No Compatible HDC         */
         /*-----------------------------------------------------------------------*/
         /* Use szDeviceName in DRIVDATA (if valid)                               */
         /*-----------------------------------------------------------------------*/
         if (  pEDOS->pdriv
            && ValidatePointer (pEDOS->pdriv->szDeviceName, VALIDATE_TYPE_STRING, 0)
            && *pEDOS->pdriv->szDeviceName
            )
         {
            /*-----------------------*/
            /* 1) Find DRIVDATA      */
            /* - Passed In           */
            /*-----------------------*/

            /*-----------------------*/
            /* 2) Find Printer Name  */
            /* - Get Log Addr and    */
            /*   Try later...        */
            /*-----------------------*/

            DBPRINTF (("      pDrivData->szDeviceName = '%s'\n", pEDOS->pdriv->szDeviceName));

            // @98155 : If we have valid DRIVDATA and device name use it when
            // logical address is NULL or invalid (common for network printing)
            bRC = LogAddrFromOmniDevice (pdb->hmcbHeap,
                                         pdb->szLogAddress,
                                         pEDOS->pdriv->szDeviceName,
                                         ((PDENPARAMS)(((PCHAR)p1) + sizeof (DEVOPENSTRUC)))->ulType);
         }
         else
         {
            /*-----------------------------------------------------------------------*/
            /* Case 4: No Logical Address & No Compatible HDC & No DRIVDATA          */
            /*-----------------------------------------------------------------------*/
            /* Else use the logical address from the system default printer          */
            /* only if there is a OMNI device on it!                                 */
            /*-----------------------------------------------------------------------*/

            /*-----------------------*/
            /* 1) Find DRIVDATA      */
            /* - Get Log Addr and    */
            /*   Try later...        */
            /*-----------------------*/

            /*-----------------------*/
            /* 2) Find Printer Name  */
            /* - Get Log Addr and    */
            /*   Try later...        */
            /*-----------------------*/

            // This will get us a Logical address to print to as long as we find
            // our driver's name (i.e. "OMNI") supported in default printer (OD_DIRECT jobs)
            // or in default queue (OD_QUEUED jobs)
            LogAddrFromOmniDefaultPrinter (hmcbHeap,
                                           pdb->szLogAddress,
                                           ((PDENPARAMS)(((PCHAR)p1) + sizeof (DEVOPENSTRUC)))->ulType);

         }

         // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
         pszDeviceName = pEDOS->pdriv->szDeviceName;
         OMNILoadDLL (pszDeviceName,
                      &(pdb->pDevice),
                      &(pdb->pDriver),
                      &pDLLuseage);
         pdb->pDLLuseage = pDLLuseage;
#endif

         /*-----------------------------------------------------------------------*/
         /* Last Chance to find DRIVDATA and Printer Name                         */
         /*-----------------------------------------------------------------------*/
         /* Note: Case 1 : should have yielded valid DRIVDATA, Printer Name       */
         /*       Case 2 : should have yielded valid DRIVDATA, Printer Name       */
         /*       Case 3 : should have valid DRIVDATA, still need Printer Name    */
         /*       Case 4 : still need DRIVDATA and Printer Name                   */
         /*                                                                       */
         /* This is the proverbial "Later" mentioned above...                     */
         /*-----------------------------------------------------------------------*/

         // If we already have DRIVDATA this function should validate it
         // alse it will try to find it
         // @TBD - if "ReturnDriverData" already called should not call again
         pdb->pDrivData = ReturnDriverData (pdb,
                                            (PDLGINSTANCE)NULL,
                                            hmcbHeap,
                                            pEDOS->pdriv,
                                            pdb->szLogAddress,
                                            FALSE,
                                            pdb->pDevice,
                                            pdb->pDriver);
         assertF (pdb->pDrivData);

         // if we have not yet found a printer name (i.e. cases 3 or 4)
         if (pdb->pszPrinterName == NULL)
         {
            // Try to find printer name based on log address and DC Type
            pdb->pszPrinterName = FindPrinterName (pdb->hmcbHeap,
                                                   pdb->pDrivData->szDeviceName,
                                                   pdb->szLogAddress,
                                                   FALSE);
            assertF (pdb->pszPrinterName);
            DBPRINTIF ((bShow, "FILL_PHYSICAL(2): PrinterName = %s\n", pdb->pszPrinterName));
         }

         /*-----------------------------------------------------------------------*/
         /* Could NOT find DRIVDATA, Printer Name, or Logical address             */
         /*-----------------------------------------------------------------------*/
         /* NOTE:                                                                 */
         /* This is the proverbial "Later" mentioned above...                     */
         /*-----------------------------------------------------------------------*/
         if (!pdb->pszPrinterName || !pdb->pDrivData || !*pdb->szLogAddress )
         {
            assertstring ("DANGER!");
            DestroyDeviceBlock (pdb);
            break;            // Bomb out...
         }

         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): PrinterName = %s\n", pdb->pszPrinterName));

         pdb->dop.pszLogAddress = pdb->szLogAddress;
      }

      pdb->dop.pdriv      = (PDRIVDATA)pdb->pDrivData;
      pdb->pJobProperties = (PJOBPROPERTIES)&pdb->pDrivData->abGeneralData;

      /*---------------------------------------*/
      /* Driver Name  (validate/copy)          */
      /*---------------------------------------*/
      if (ValidatePointer (pEDOS->pszDriverName,
                           VALIDATE_TYPE_STRING,
                           sizeof (pdb->szDriverName)))
      {
         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): pszDriverName = %s\n", pEDOS->pszDriverName));

         if (IsItADriverName (pEDOS->pszDriverName))
         {
            SafeStrNCpy (pdb->szDriverName,
                         pEDOS->pszDriverName,
                         sizeof (pdb->szDriverName));
         }
         else
         {
            assertstring ("The driver name is not OMNI!");

            // Destroy DEVICEBLOCK and fail driver enable
            DestroyDeviceBlock (pdb);
            break;
         }
      }
      else
      {
         // Not a valid pointer supply our driver's name (i.e. "OMNI")
         strcpy (pdb->szDriverName, APP_NAME);
      }

      // reset DriverName in DEVOPENSTRUC for good measure
      pdb->dop.pszDriverName = pdb->szDriverName;

      /*-----------------------------------------------------------------------*/
      /* Data Type                                                             */
      /*-----------------------------------------------------------------------*/
      /* Can be PM_Q_RAW or PM_Q_STD or special data type driver defines       */
      /*-----------------------------------------------------------------------*/
      /* NOTE: Lotus 123G does NOT pass in a data type.  We need to default    */
      /* to standard (PM_Q_STD) in that case                                   */
      /*-----------------------------------------------------------------------*/
      if (ValidatePointer (pEDOS->pszDataType, VALIDATE_TYPE_STRING,
                           sizeof (pdb->szDataType)))
      {
         DBPRINTIF(( bShow, "FILL_PHYSICAL(2): pszDataType = %s\n", pEDOS->pszDataType ));

         // Does it begin with a known OS/2 data type (i.e. PM_Q_xxx)
         if (0 == strncmp ("PM_Q_", pEDOS->pszDataType, 5))
         {
            // Data type is most likely PM_Q_RAW or PM_Q_STD, copy it to pdb
            SafeStrNCpy (pdb->szDataType,
                         pEDOS->pszDataType,
                         sizeof (pdb->szDataType));
         }
         else
         {
            // Doesn't start with a valid beginning "PM_Q_"
            // Default to PM_Q_STD (OS/2 default data type)
            strcpy (pdb->szDataType, "PM_Q_STD");
         }
      }
      else
      {
         // No type passed in.  Default to PM_Q_STD (OS/2 defualt)
         strcpy (pdb->szDataType, "PM_Q_STD");
      }

      // reset DataType in DEVOPENSTRUC for good measure
      pdb->dop.pszDataType = pdb->szDataType;

      /*---------------------------------------*/
      /* Comment                               */
      /*---------------------------------------*/
      /* displayed by spooler under job        */
      /* (maximum length is 48 chars long)     */
      /*---------------------------------------*/
      if (ValidatePointer (pEDOS->pszComment,
                           VALIDATE_TYPE_STRING,
                           MAXCOMMENTSZ))
      {
         // Only copy up to 48 chars or error may result
         // as documented in PM Prog. Ref. Vol 3
         // and defined in PMSPL.H as MAXCOMMENTSZ
         DBPRINTIF ((bShow,
                     "FILL_PHYSICAL(2): pszComment = %s\n",
                     pEDOS->pszComment));

         usLen = sizeof (pdb->szComment);

         usLen = min (usLen, MAXCOMMENTSZ - 1);

         SafeStrNCpy (pdb->szComment,
                      pEDOS->pszComment,
                      sizeof (pdb->szComment));

         pdb->dop.pszComment = pdb->szComment;
      }
      else
      {
         strcpy (pdb->szComment, "");
      }

      /*---------------------------------------*/
      /* Queue Processor Name                  */
      /*---------------------------------------*/
      if (ValidatePointer (pEDOS->pszQueueProcName,
                           VALIDATE_TYPE_STRING,
                           sizeof (pdb->szQueueProcName)))
      {
         DBPRINTIF ((bShow,
                     "FILL_PHYSICAL(2): pszQueueProcName = %s\n",
                     pEDOS->pszQueueProcName));

         // Make a local copy
         SafeStrNCpy (pdb->szQueueProcName,
                      pEDOS->pszQueueProcName,
                      sizeof (pdb->szQueueProcName));

         pdb->dop.pszQueueProcName = pdb->szQueueProcName;
      }

      /*---------------------------------------*/
      /* Queue Processor Params                */
      /*---------------------------------------*/
      if (ValidatePointer (pEDOS->pszQueueProcParams,
                           VALIDATE_TYPE_STRING,
                           sizeof (pdb->szQueueProcParams)))
      {
         PSZ   pszParam, pszNextParam;
         PSZ   pszLHS, pszRHS;
         PSZ   pszEqualSign;

         DBPRINTIF ((bShow,
                     "FILL_PHYSICAL(2): pszQueueProcParams = %s\n",
                     pEDOS->pszQueueProcParams ));

         usLen = sizeof (pdb->szQueueProcParams);

         // Make a local copy
         SafeStrNCpy (pdb->szQueueProcParams,
                      pEDOS->pszQueueProcParams,
                      usLen);

         pdb->dop.pszQueueProcParams = pdb->szQueueProcParams;

// begin @EXJOB
         // Plug-In want to do H/W copies
         /*---------------------------------------*/
         /* Queue Proc Parms                      */
         /*---------------------------------------*/
         /* COP=                                  */
         /*---------------------------------------*/
         if (   pdb->pDevice
            
            )
         {
            pch = strstr (pEDOS->pszQueueProcParams, "COP=");
            if (pch)
            {
               ULONG ulCopies;
               pch += strlen ("COP=");

               pch2 = strchr (pch, ' ');
               if (pch2)
                  *pch2 = 0;

               ulCopies = atoi( pch);
               if (ulCopies < 1000)
               {
                  pdb->pJobProperties->ulCopies = ulCopies;
               }
               else
               {
                  pdb->pJobProperties->ulCopies = 1;
               }

               if (ulCopies != 1)
               {
                  *pch++ = '1';
                  while(*pch) *pch++ = 0;
               }
            }
         }
// end @EXJOB

         pszParam = pdb->szQueueProcParams;
         while (pszParam && *pszParam)
         {
            /* Find the next parameter.  If one is found, then split the
            ** current parameter into a separate string.
            */
            pszNextParam = strchr (pszParam, ' ');
            if (pszNextParam)
               *pszNextParam = 0;

            /* Search for an equals sign.
            */
            pszEqualSign = strchr (pszParam, '=');
            if (pszEqualSign)
            {
               /* Split up the parameter into a left and right hand side.
               */
               *pszEqualSign = 0;
               pszLHS = pszParam;
               pszRHS = pszEqualSign+1;

               if ((0 == strcmp (pszLHS, "DATATYPE")) &&
                   (0 == strcmp (pszRHS, "PM_Q_RAW"))  )
               {
                  pdb->fRawOnly = TRUE;
                  DBPRINTIF ((bShow,
                              "FILL_PHYSICAL(2): pszQueueProcParams: Found DATATYPE=PM_Q_RAW!\n"));
               }
            }

            // skip past white space
            pszParam = pszNextParam;
            while (pszParam && ' ' == *pszParam)
               pszParam++;
         }

         // Restore the local copy
         SafeStrNCpy (pdb->szQueueProcParams,
                      pEDOS->pszQueueProcParams,
                      usLen);
      }

      /*---------------------------------------*/
      /* Spooler Parms                         */
      /*---------------------------------------*/
      /* FORM=  or  PRTY=                      */
      /*---------------------------------------*/
      if (ValidatePointer (pEDOS->pszSpoolerParams,
                           VALIDATE_TYPE_STRING,
                           sizeof (pdb->szSpoolerParams)))
      {
         // Just copy string for now we will parse it later
         DBPRINTIF ((bShow,
                     "FILL_PHYSICAL(2): szSpoolerParams = %s\n",
                     pEDOS->pszSpoolerParams ));


         SafeStrNCpy (pdb->szSpoolerParams,
                      pEDOS->pszSpoolerParams,
                      sizeof (pdb->szSpoolerParams));

         pdb->dop.pszSpoolerParams = pdb->szSpoolerParams;
      }

      /*---------------------------------------*/
      /* DENPARAMS (2.0 drivers only)          */
      /*---------------------------------------*/
      /*                                       */
      /*---------------------------------------*/
      // make a PDENPARAMS from p1
      pch = ((PCHAR)p1) + sizeof (DEVOPENSTRUC);

      // copy dem params
      pdb->ulStateInfo = ((PDENPARAMS)pch)->ulStateInfo;   // not used here, according to 2.0 pubs
      pdb->ulType      = ((PDENPARAMS)pch)->ulType;

      /*---------------------------------------*/
      /* Data Type                             */
      /*---------------------------------------*/
      /* interpret string and store data type  */
      /* as a numeric value                    */
      /*---------------------------------------*/

      // interpret string and store data type as a numeric constant
      if (  0 == strcmp (pdb->szDataType, "PM_Q_STD")
         && (pdb->ulType == OD_QUEUED)
         )
      {
         // Data type can only PM_Q_STD if DC is OD_QUEUED
         pdb->ulDataType = PM_Q_STD;
      }
      else
      {
         // otherwise, it will be PM_Q_RAW
         pdb->ulDataType = PM_Q_RAW;
      }

      /*---------------------------------------*/
      /* Network Parms  @TBD                   */
      /*---------------------------------------*/
      /* USER=  or program other depending on  */
      /* network software                      */
      /*---------------------------------------*/

      /*******************************************************************/
      /* VALIDATION SECTION                                              */
      /*******************************************************************/
      /* Parse, interpret, and validate DEVOPENSTRUC data                */
      /* and setup any DEVICEBLOCK derived variables                     */
      /*******************************************************************/

      /*---------------------------------------*/
      /* Driver Name/Device Name               */
      /*---------------------------------------*/
      if (pdb->pDrivData)
      {
         if (  !pdb->pDriver
            || !pdb->pDevice
            )
         {
            // Verify that we have a pdb->pDriver and pdb->pDevice by this time
            rc = FindDeviceNameInDriver (pdb->pDrivData->szDeviceName,
                                         &(pdb->pDriver),
                                         &(pdb->pDevice));
            assertF (rc);
         }
      }

      assertF (pdb->pDriver);
      assertF (pdb->pDevice);

      /*---------------------------------------*/
      /* DRIVDATA                              */
      /*---------------------------------------*/
      if (pdb->pDrivData)
      {
#ifdef DEBUG
         DBPRINTIF ((bShow, "--------------------------\n"));
         DBPRINTIF ((bShow, "cb            = %d\n", pdb->pDrivData->cb));
         DBPRINTIF ((bShow, "lVersion      = %d\n", pdb->pDrivData->lVersion));
         DBPRINTIF ((bShow, "szDevicename  = %s\n", pdb->pDrivData->szDeviceName));
         DebugOutputJobProperties (bShow, NULL, pdb->pJobProperties);
#endif

         /*----------------------------------------------------------------*/
         /* Build APPNAME used in OS2SYS.INI that holds Printer Properties */
         /*----------------------------------------------------------------*/

         // hunt for the right phys. device description given the device name

         // build the INI file Application Name to access OS2SYS.INI
         // to get correct job props
         bRC = BuildAppName (pdb->szAppName,
                             LEN_APPNAME,
                             pdb->pszPrinterName,
                             pdb->szDriverName,
                             pdb->pDrivData->szDeviceName);
         assertF (bRC);
         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): AppName = %s\n", pdb->szAppName));

         // initialize User defined data pointers to NULLs etc.
         InitUserDefinedData (pdb->pDevice->pUserDefData);

         // read in user defined values from INI file to linked list
         // to reset to original state after cancel
         bRC = ReadUserDefinedTrayList (pdb->szAppName, pdb->pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedFormList (pdb->szAppName, pdb->pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedConnectList (pdb->szAppName, pdb->pDevice);
         assertF (bRC);

         bRC = ReadUserDefinedFontList (pdb->szAppName, pdb->pDevice);
         assertF (bRC);

         pdb->pResInfo = GetpResFromResID (pdb->pDriver,
                                           pdb->pDevice,
                                           pdb->pJobProperties);

         pdb->pPrintMode = GetpPrintModeFromID (pdb->pDriver,
                                                pdb->pDevice,
                                                pdb->pJobProperties);
      }
      else
      {
         // @TBD - should not need "else" case PDriverFromDeviceName should always
         //        succeed, perhaps with a default value
         assertstring ("No Driv Data!\n");

         // DLLBLD is defined to build the dll version omni.drv
#ifndef DLLBLD
         // default to the first one
         pdb->pDevice = globals.ppDrivers[0]->pDevices;

         // default to the first one
         pdb->pDriver = globals.ppDrivers[0];
#endif

         // Get a default resolution, needed for FORM processing
         pdb->pResInfo = GetpResFromResID (pdb->pDriver, pdb->pDevice, NULL);

         pdb->pPrintMode = GetpPrintModeFromID (pdb->pDriver, pdb->pDevice, NULL);
      }

      //
      
      // Verify what type of Layout is selected
      //
      if (GplLayoutQuerySelected ((HGJOI)&(pdb->pJobProperties->LayoutCB)) != -1)
      {
         ULONG       ulList[GJFN_QUERY_ALL_NUP_VALUES];

         //
         // Get layout parameters
         //
         if (  (GplLayoutQueryParameters ((HGJOI)&(pdb->pJobProperties->LayoutCB),
                                          ulList,
                                          GJFN_QUERY_NUP_SELECTED,
                                          GJFN_QUERY_ALL_NUP_VALUES) == PMERR_OK)
            && (ulList[GJFN_QUERY_NUP_SELECTED - 1] == 2)
            )
         {
            pdb->pLargeFormInfo = (PFORMINFO2)GplMemoryAlloc (hmcbHeap, sizeof (FORMINFO2));
            pdb->ulNupPages     = ulList[GJFN_QUERY_NUP_SELECTED - 1];

            if ((BOOL)ulList[GJFN_QUERY_BOOKLET_ENABLED - 1])
               pdb->bFlags |= OMNI_BOOKLET_ENABLED;
            if ((BOOL) ulList[GJFN_QUERY_BOOKLET_UPPERTRAY - 1])
               pdb->bFlags |= OMNI_BOOKLET_UPPERTRAY;

            pdb->pszRangeOfPages = (PSZ)ulList[GJFN_QUERY_BOOKLET_RANGE - 1];
         }
      }
      

      /*---------------------------------------*/
      /* Spooler Parms                         */
      /*---------------------------------------*/
      /* FORM=  or  PRTY=                      */
      /*---------------------------------------*/
      DBPRINTIF ((bShow, "FILL_PHYSICAL(2): szSpoolerParams = %s\n",
                  pdb->szSpoolerParams));

      fFormFound = FALSE;

      if (*pdb->szSpoolerParams)
      {
         PSZ  pszStart,
              pszEnd,
              pszCurrentCommand,
              pszNextEquals,
              pszNextCommand;

         // There are multiple commands in this string.
         // They are space separated.
         // Ex:
         // OTHER1=job FORM="A user defined form" OTHER2=boj
         // FORM="A user defined form"
         // FORM=Letter

         pszStart = pdb->szSpoolerParams;
         pszEnd   = pszStart + strlen (pszStart) - 1;
         do
         {
            pszCurrentCommand = strchr (pszStart, '=');
            pszNextEquals     = NULL;
            if (pszCurrentCommand)
               pszNextEquals  = strchr (pszCurrentCommand + 1, '=');
            pszNextCommand    = NULL;
            if (pszNextEquals)
            {
               pszNextCommand = pszNextEquals - 1;
               while (  pszNextCommand > pszStart
                     && ' ' != *pszNextCommand
                     )
                  pszNextCommand--;

               if (' ' == *pszNextCommand)
               {
                  *pszNextCommand = '\0';
                  pszEnd = pszNextCommand - 1;
               }
               else
               {
                  // Error!
                  pszCurrentCommand = NULL;
                  pszNextCommand    = NULL;
               }
            }

            if (pszCurrentCommand)
            {
               /*-------------------------------------*/
               /* FORM="Form Name"                    */
               /*-------------------------------------*/
               if (0 == strncmp (pszStart, "FORM=", 5))
               {
                  CHAR chSave   = '\0';
                  PSZ  pszComma = NULL;

                  pszStart += strlen ("FORM=");

                  // There may be either double quotes around the form
                  // name or single quotes around the form name.
                  if (  (  '"' == *pszStart
                        && '"' == *pszEnd
                        )
                     || (  '\'' == *pszStart
                        && '\'' == *pszEnd
                        )
                     )
                  {
                     pszStart++;
                     chSave = *pszEnd;
                     *pszEnd = '\0';
                     pszEnd--;
                  }

                  // It is allowable to have a statement as the following:
                  // FORM=form1,form2,form3
                  // This tells the driver that there are 3 forms in the
                  // print job.  The first page uses form1 and there
                  // will be DEVESC_NEWFRAME_WPROPs that switch to
                  // pages that use form2 and form3 (and possibly back to
                  // form1) later on in the job.
                  pszComma = strchr (pszStart, ',');
                  if (pszComma)
                     *pszComma = '\0';

                  // make a copy of the form name
                  assertT (strlen (pszStart) >= sizeof (szWork));
                  SafeStrNCpy (szWork, pszStart, sizeof (szWork));

                  if (!FormInfoFromName (pdb->pDriver,
                                         pdb->pDevice,
                                         szWork,
                                         pdb->pFormInfo))
                  {
                     // Now we must determine if the string is in our
                     // stringtable or a it is a string the user defined
                     // in hcInfo structure
                     if (pdb->pDevice->pFORMS[0].ulNameID == FORM_STRING_UNLISTED)
                     {
                        strcpy (szWork,
                                pdb->pDevice->pFORMS[0].hcInfo.szFormname);
                     }
                     else
                     {
                        ULONG ulIdx;

                        ulIdx = pdb->pDevice->pFORMS[0].ulNameID
                              - STRING_TABLE_BASE;

                        assertF (globals.pbStringTable[ulIdx]);

                        SafeStrNCpy (szWork,
                                     globals.pbStringTable[ulIdx],
                                     sizeof (szWork));
                     }

                     if (FormInfoFromName (pdb->pDriver,
                                           pdb->pDevice,
                                           szWork,
                                           pdb->pFormInfo))
                        fFormFound = TRUE;
                  }
                  else
                     fFormFound = TRUE;

                  if (chSave)
                     pszEnd[1] = chSave;

                  if (pszComma)
                     *pszComma = ',';
               }

               /*-------------------------------------*/
               /* PRTY=xx                             */
               /*-------------------------------------*/
            }

            if (pszNextCommand)
            {
               *pszNextCommand = ' ';
               pszStart        = pszNextCommand + 1;
               pszEnd          = pszStart + strlen (pszStart) - 1;
            }

         } while (pszNextCommand);
      }

      if (fFormFound)
      {
         BOOL       bRc;
         ULONG      ulConnID,
                    ulFormID,
                    ulTrayID,
                    ulMediaID;
         PTRAYINFO  pTrayInfoLcl;
         PMEDIAINFO pMediaInfoLcl;

         // @121186 - Added this to setup HCINFO for xPels, yPels reporting
         CalculateFormSize (pdb, pdb->pJobProperties, pdb->pFormInfo);

         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): FORM='%s' spooler parm\n",
                     szWork));

         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): Form ID = %lu\n",
                     pdb->pFormInfo->ulFormID));

         // @169661 - get first logically matching conn ID from form ID
         // See default form connection has a match first...
         
         GetIDsFromConnID (pdb->pDriver,
                           pdb->pDevice,
                           pdb->pJobProperties->ulDefConnID,
                           &ulTrayID,
                           &ulFormID,
                           &ulMediaID);

         //if match default in form size use it.
         //if not, try find an entry from Connection list
         //to match form size specified.
         if (ulFormID != pdb->pFormInfo->ulFormID)
         {
            bRc = Find1stConnFromFormID (pdb->pDriver,
                                         pdb->pDevice,
                                         pdb->pFormInfo->ulFormID,
                                         &ulConnID);
            if (bRc == TRUE)
            {
               GetIDsFromConnID (pdb->pDriver,
                                 pdb->pDevice,
                                 ulConnID,
                                 &ulTrayID,
                                 &ulFormID,
                                 &ulMediaID);
            }
         }

         // Get current tray information for this connection
         TrayInfoFromID (pdb->pDriver,
                         pdb->pDevice,
                         ulTrayID,
                         &pTrayInfoLcl);

         *pdb->pTrayInfo = *pTrayInfoLcl;

         TrayNameFromID (pdb->pDriver,
                         pdb->pDevice,
                         pdb->pTrayInfo->szTrayName,
                         ulTrayID);

         // Get current tray information for this connection
         MediaInfoFromID (pdb->pDriver,
                          pdb->pDevice,
                          ulMediaID,
                          &pMediaInfoLcl);

         *pdb->pMediaInfo = *pMediaInfoLcl;

         MediaNameFromID (pdb->pDriver,
                          pdb->pDevice,
                          pdb->pMediaInfo->szMediaName,
                          ulMediaID);
         
      }
      else
      {
         /*-------------------------------------*/
         /* Default Tray/Form/Media Data        */
         /*-------------------------------------*/
         PTRAYINFO   pTrayInfoLcl;
         PMEDIAINFO  pMediaInfoLcl;
         ULONG       ulDefaultFormID,
                     ulDefaultTrayID,
                     ulDefaultMediaID;

         // We now use a default "Form Connection" which is a combination
         // of Form, Tray and Media type.  Given a connection ID we can retrieve
         // all three of the composite IDs.
         GetIDsFromConnID (pdb->pDriver,
                           pdb->pDevice,
                           pdb->pJobProperties->ulDefConnID,
                           &ulDefaultTrayID,
                           &ulDefaultFormID,
                           &ulDefaultMediaID);

         DBPRINTIF ((bShow, "FILL_PHYSICAL(2): Default Conn ID=%lu, Tray ID=%lu, Form ID=%lu\n",
                     pdb->pJobProperties->ulDefConnID, ulDefaultTrayID, ulDefaultFormID));

         // Get current tray information for this connection
         TrayInfoFromID (pdb->pDriver,
                         pdb->pDevice,
                         ulDefaultTrayID,
                         &pTrayInfoLcl);

         *pdb->pTrayInfo = *pTrayInfoLcl;

         TrayNameFromID (pdb->pDriver,
                         pdb->pDevice,
                         pdb->pTrayInfo->szTrayName,
                         ulDefaultTrayID);

         // Get information for the default form set up in Job Properties
         // since this form was not overridden by FORM= spooler parameter
         // This is call sets HCAPS flags and calculates form dimensions
         // adjusted for current device resolution
         GetDefaultFormInfo (pdb,
                             ulDefaultFormID,
                             pdb->pJobProperties->ulDefResID,
                             pdb->pFormInfo);

         // Get current tray information for this connection
         MediaInfoFromID (pdb->pDriver,
                          pdb->pDevice,
                          ulDefaultMediaID,
                          &pMediaInfoLcl);

         *pdb->pMediaInfo = *pMediaInfoLcl;

         MediaNameFromID (pdb->pDriver,
                          pdb->pDevice,
                          pdb->pMediaInfo->szMediaName,
                          ulDefaultMediaID);
      }

      DBPRINTIF(( bShow, "FILL_PHYSICAL(2): Form Name = '%s' Size.x = %d Size.y = %d\n",
                  pdb->pFormInfo->hcInfo.szFormname,
                  pdb->pFormInfo->hcInfo.xPels,
                  pdb->pFormInfo->hcInfo.yPels));

      DBPRINTIF(( bShow, "FILL_PHYSICAL(2): Tray Name = '%s', Type = %d\n",
                  pdb->pTrayInfo->szTrayName,
                  pdb->pTrayInfo->ulTrayType ));

      /*---------------------------------------*/
      /* DENPARAMS ?????? @TBD - validate      */
      /*---------------------------------------*/
      /*                                       */
      /*---------------------------------------*/

      /*---------------------------------------*/
      /* Network Parms                         */
      /*---------------------------------------*/
      /* USER=  or program other depending on  */
      /* network software                      */
      /*---------------------------------------*/
      // @TBD - need to store away for potential future uses - MFR


      /*---------------------------------------*/
      /* Default Font Data                     */
      /*---------------------------------------*/
      // @TBD - what to do if no font - MFR
      // @DEVFNT - get Font Info frm ID in Job Props

// begin @JPN2H99
      /*---------------------------------------*/
      /* Load Printer Properties Data.         */
      /*---------------------------------------*/
      // Printer properties option page support
      pdb->pPrnProperties = (PPRNPROPERTIES) GplMemoryAlloc (hmcbHeap, sizeof (PRNPROPERTIES));

      // Read in printer properties from INI file
      bRC = ReadPrinterProperties (pdb->szAppName, pdb->pPrnProperties, pdb->pDevice);
      assertF (bRC);
// end @JPN2H99



      DBPRINTIF ((bShow, "FILL_PHYSICAL(2): Exit; ulrc = %x\n",
                  ulrc));

      ulrc = (ULONG)pdb;
      break;
   } /* end FILL_PHYSICAL */

   case DISABLE_PHYSICAL:
   {
      // p1 is pdb
      // inverse of FILL_PHYSICAL
      assertF (p1);
      DBPRINTIF ((bShow, "DISABLE_PHYSICAL(4); pdb = %x\n", p1));

      // cast a copy of pdb
      pdb = (PDEVICEBLOCK)p1;

      if (pdb->hThread)
      {
         /*---------------------------------------*/
         /* Delete the second thread instance     */
         /*---------------------------------------*/
         rc = GplThreadDeleteInstance (&pdb->hThread);
         assertF (rc);
      }

      rc = DosCloseMutexSem (pdb->hmtxDCSem);
      assertT (rc);

      DestroyDeviceBlock (pdb);

      // successful return code for this enable subfunction
      ulrc = 0;
      break;
   } /* end DISABLE_PHYSICAL */

   case ENABLE_DC:
   {
      // p1 is a denparams
      // p2 is not used
      // inverse of DISABLE_DC
      assertF (p1);
      assertF ((ULONG)p2  == 0);
      DBPRINTIF ((bShow, "ENABLE_DC(5); p1=%x\n", p1));

      pdb = (PDEVICEBLOCK)((PDENPARAMS)p1)->ulStateInfo;
      assertF (pdb);

      pddc = (PDDC)GplMemoryAlloc (pdb->hmcbHeap, sizeof( DDC ));
      assertF (pddc);
      pddc->ulSig = DDC_SIG;
      pddc->pdb = pdb;

      // Debugging aid...
      GplMemorySetUserID (hmcbHeap, (ULONG)pddc);

      // store hdc
      pdb->hdc = ((PDENPARAMS)p1)->ulHDC;

      DBPRINTIF ((bShow, "ENABLE_DC(5); pddc = %x; pdb = %x; hdc = %x\n", pddc, pddc->pdb, pddc->pdb->hdc));

      // fill in DDC
      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine
         if (!procdata.hdcDirectShadow)
         {
            DEVOPENSTRUC   dos;

            assertF (*globals.achPrePath);
            dos.pszLogAddress = NULL;
            dos.pszDriverName = globals.achPrePath;

            procdata.hdcDirectShadow = GreOpenDC ((HDC)0,
                                                 OD_DIRECT,
                                                 "*",
                                                 2,
                                                 (PDEVOPENDATA)&dos);
            assertF (procdata.hdcDirectShadow);
         }

         // GreOpenDC a display OD_MEMORY DC to be used as a "shadow" DC
         // for the printer DC.  HDC=0 means obtain a display DC
         pddc->hdcShadow = GreOpenDC ((HDC)procdata.hdcDirectShadow,
                                      OD_MEMORY,
                                      "*",
                                      0,
                                      (PDEVOPENDATA)NULL);
         assertF (pddc->hdcShadow != DEV_ERROR);
         assertF (pddc->hdcShadow);

         DBPRINTIF ((bShow, "ENABLE_DC(5); pddc->hdcShadow=%x\n", pddc->hdcShadow));

         // create an empty region to contain the clipping region for the shadow dc
         // at NotifiyClipChange time, this region will be set to the clipping region
         pddc->hrgnShadow = GreCreateRectRegion (pddc->hdcShadow, (PRECTL) NULL, 0);
         DBPRINTIF ((bShow, "ENABLE_DC(5); pddc->hrgnShadow = %x\n", pddc->hrgnShadow));
         assertF (pddc->hrgnShadow);
      }

      DebugPrintDCType (bShow, pddc, "ENABLE_DC(5)");

      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine
         pddc->pdb->pDeviceSurface = (PVOID)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                                            sizeof (DEVICESURFACE));
         assertF (pddc->pdb->pDeviceSurface);
      }

      if (  (OD_QUEUED == pdb->ulType)
         || (OD_DIRECT == pdb->ulType)
         )
      {
         /*---------------------------------------*/
         /* Create a second thread instance       */
         /*---------------------------------------*/
         bRC = GplThreadCreateInstance (pdb->hmcbHeap,
                                        globals.hModule,
                                        &pdb->hThread,
                                        pddc);             // Debugging aid
         assertF (bRC);
         assertF (pdb->hThread);
      }

      // Initialize StateData
      pddc->StateData.fFoundLogAddress = TRUE;

      // Set return code to PDDC for this subfunction
      ulrc = (ULONG) pddc;
      break;
   } /* end ENABLE_DC */

   case DISABLE_DC:
   {
      // p1 is pointer to DC   pddc
      // inverse of ENABLE_DC
      assertF (p1);
      pddc = (PDDC)p1;

      DBPRINTIF ((bShow, "DISABLE_DC(6); pddc = %x\n", pddc));
      DebugPrintDCType (bShow, pddc, "DISABLE_DC(6)");

      DestroyDrawingContext (pddc);

      // successful return code
      ulrc = 0;
      break;
   } /* end DISABLE_DC */

   case COMPLETE_OPEN_DC:
   {
      // p1 is hdc
      // p2 is pddc

      // inverse of BEGIN_CLOSE_DC
      assertF (p1);
      assertF (p2);
      assertT (((PDDC)p2)->pdb->hdc != (HDC)p1);

      pddc = (PDDC)p2;
      pdb  = pddc->pdb;

      DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10): pddc=%x; pdb = %x; hdc=%x; \n", pddc, pdb, pdb->hdc));

      // Journal instance and Bitmap surface have NOT been created yet
      pddc->StateData.fUseJournaling  = FALSE;
      pddc->StateData.fUseBitmap      = FALSE;

      switch (pddc->pdb->ulType)
      {
      case OD_QUEUED:
      {
         DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10): OD_QUEUED, "));

         switch (pddc->pdb->ulDataType)
         {
         case PM_Q_STD:
         {
            PDEVICESURFACE pds = (PDEVICESURFACE)pddc->pdb->pDeviceSurface;

            // Open a Spool file standard to start recording
            // OS/2 metafile commands
            DBPRINTIF ((bShow, "PM_Q_STD: SplStdOpen()\n"));
            bRC = SplStdOpen (pddc->pdb->hdc);
            assertF (bRC);

            /* Defect 195199
            ** There are two paths here.  If we create a bitmap, it will
            ** be small (8x8).  This was originally done because even though
            ** we turn off drawing (COM_DRAW flag), some code would still try
            ** to draw to the surface.  By creating a small bitmap, the buggy
            ** code would either clip out the drawing or draw inside the bitmap.
            ** However, an application can query the clipping limits and not
            ** draw items.  Because of that, do not set the page size to 8x8.
            ** Just hook out both required drawing function (bitblt and line)
            ** and return OK.
            */
            if (GRE_22 <= globals.ulGreVersion)
            {
               // 2.2 Engine or above
               pds->pfnBitBlt = (PFN)MetafileBitBlt;
               pds->pfnLine   = (PFN)MetafileLine;
            }
            else
            {
               pddc->StateData.fUseBitmap = TRUE;
            }
            break;
         }

         case PM_Q_RAW:
         {
            // Do nothing here but defer to DEVESC_STARTDOC
            // where we will do SplQmOpen();
            DBPRINTIF ((bShow, "PM_Q_RAW: no output files to open!\n"));

            // Journal file needed for RAW format
            // Bitmap Surface needed to draw to
            pddc->StateData.fUseJournaling = TRUE;
            pddc->StateData.fUseBitmap     = TRUE;

            break;
         }
         }
         break;
      }

      case OD_DIRECT:
      {
         DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10); OD_DIRECT, "));

         switch (pddc->pdb->ulDataType)
         {
           case PM_Q_STD:
           {
              // Illegal combination
              DBPRINTF (("PM_Q_STD: Illegal Combination!!! switching to PM_Q_RAW\n"));

              // switch it to PM_Q_RAW in case app made mistake
              pddc->pdb->ulDataType = PM_Q_RAW;

              // Journal file needed for RAW format
              // Bitmap Surface needed to draw to
              pddc->StateData.fUseJournaling = TRUE;
              pddc->StateData.fUseBitmap     = TRUE;
              break;
           }

           case PM_Q_RAW:
           {
              // Do nothing here but defer to DEVESC_STARTDOC
              // where we will do SplQmOpen();
              DBPRINTIF ((bShow, "PM_Q_RAW: no op until STARTDOC\n"));

              // Journal file needed for RAW format
              // Bitmap Surface needed to draw to
              pddc->StateData.fUseJournaling = TRUE;
              pddc->StateData.fUseBitmap     = TRUE;
              break;
           }
         }
         break;
      }

      case OD_INFO:
      {
         DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10); OD_INFO\n"));

         // No Journal file needed for informational DCs
         // Bitmap Surface not needed for informational DCs
         break;
      }

      case OD_MEMORY:
      {
         DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10); OD_MEMORY\n"));

         /* No bitmap surface info is needed for a memory DC case
         ** The application will set an already created bitmap into
         ** the memory DC if it wants to draw into it...
         */
         pddc->StateData.fUseJournaling = FALSE;
         pddc->StateData.fUseBitmap     = FALSE;
         break;
      }

      case OD_METAFILE:
      case OD_METAFILE_NOQUERY:
      default:
      {
         DBPRINTIF ((bShow, "COMPLETE_OPEN_DC(10); DC Type unexpected = (%d)!!!\n", pddc->pdb->ulType));
         // Do not create journal instance or Bitmap surface
         break;
      }
      }

      if (pddc->pdb->fRawOnly)
      {
         /* The PMPRINT.QPR has a special parameter now that tells us that will
         ** will *only* receive RAWDATA calls to us.  Therefore, we do not need
         ** to journal or band...
         */
         pddc->StateData.fUseJournaling = FALSE;
         pddc->StateData.fUseBitmap     = FALSE;
         pddc->StateData.fBanding       = FALSE;
      }

      SetupDeviceSurface (pddc);

      pddc->pdb->hModBandPlugIn        = 0;
      pddc->pdb->ulBandHandle          = 0;
      pddc->pdb->pfnBandPlugInCreate   = NULL;
      pddc->pdb->pfnBandPlugInSendBand = NULL;
      pddc->pdb->pfnBandPlugInDelete   = NULL;

      if (  !pddc->pdb->fRawOnly
         && PM_Q_RAW == pddc->pdb->ulDataType
         && (  OD_QUEUED == pddc->pdb->ulType
            || OD_DIRECT == pddc->pdb->ulType
            )
         )
      {
         CHAR achPlugin[CCHMAXPATH];

         strcpy (achPlugin, globals.szDLLPathName);
         strcat (achPlugin, "BANDVIEW.DLL");

         DBPRINTF (("@@@@@@@@@@@@ achPlugin = '%s'\n", achPlugin));
         rc = DosLoadModule (achPlugin,
                             sizeof (achPlugin),
                             achPlugin,
                             &pddc->pdb->hModBandPlugIn);
         DBPRINTF (("@@@@@@@@@@@@ DosLoadModule rc = %d\n", rc));

         if (NO_ERROR == rc)
         {
            rc = DosQueryProcAddr (pddc->pdb->hModBandPlugIn,
                                   0,
                                   "BANDPLUGINCREATE",
                                   &pddc->pdb->pfnBandPlugInCreate);
            DBPRINTF (("@@@@@@@@@@@@ DosQueryProcAddr (BANDPLUGINCREATE) rc = %d\n", rc));

            if (NO_ERROR == rc)
            {
               rc = DosQueryProcAddr (pddc->pdb->hModBandPlugIn,
                                      0,
                                      "BANDPLUGINSENDBAND",
                                      &pddc->pdb->pfnBandPlugInSendBand);
               DBPRINTF (("@@@@@@@@@@@@ DosQueryProcAddr (BANDPLUGINSENDBAND) rc = %d\n", rc));
            }

            if (NO_ERROR == rc)
            {
               rc = DosQueryProcAddr (pddc->pdb->hModBandPlugIn,
                                      0,
                                      "BANDPLUGINDELETE",
                                      &pddc->pdb->pfnBandPlugInDelete);
               DBPRINTF (("@@@@@@@@@@@@ DosQueryProcAddr (BANDPLUGINDELETE) rc = %d\n", rc));
            }

            if (NO_ERROR == rc)
            {
               pddc->pdb->ulBandHandle = pddc->pdb->pfnBandPlugInCreate ();
               DBPRINTF (("@@@@@@@@@@@@ ulBandHandle = %08X\n", pddc->pdb->ulBandHandle));
            }
            else
            {
               DBPRINTF (("@@@@@@@@@@@@ Error! rc = %d\n"));

               DosFreeModule (pddc->pdb->hModBandPlugIn);

               pddc->pdb->hModBandPlugIn        = 0;
               pddc->pdb->ulBandHandle          = 0;
               pddc->pdb->pfnBandPlugInCreate   = NULL;
               pddc->pdb->pfnBandPlugInSendBand = NULL;
               pddc->pdb->pfnBandPlugInDelete   = NULL;
            }
         }
      }

      // successful return code
      ulrc = 0;
      break;
   } /* end COMPLETE_OPEN_DC */

   case BEGIN_CLOSE_DC:
   {
      // p1 is hdc; p2 is pddc
      // last chance at engine calls and close resources
      // inverse is COMPLETE_OPEN_DC
      assertF (p1);
      assertF (p2);

      DBPRINTIF ((bShow, "BEGIN_CLOSE_DC(11); Enter:  hdc=%x; pddc=%x\n", p1, p2));

      pddc = (PDDC)p2;

      DebugPrintDCType (bShow, pddc, "BEGIN_CLOSE_DC(11)");

      if (pddc->pdb->pfnBandPlugInDelete)
      {
         pddc->pdb->pfnBandPlugInDelete (pddc->pdb->ulBandHandle);
      }

      if (pddc->pdb->hModBandPlugIn)
      {
         DBPRINTF (("@@@@@@@@@@@@ DosFreeModule (%d)\n", pddc->pdb->hModBandPlugIn));
         rc = DosFreeModule (pddc->pdb->hModBandPlugIn);
/////////assertT (rc);
      }

      // End the second thread
      EndTheThread (pddc);

      if (GRE_22 <= globals.ulGreVersion)
      {
         PDEVICESURFACE pds;

         // 2.2 Engine or above
         pds = (PDEVICESURFACE)pddc->pdb->pDeviceSurface;

         DBPRINTF (("BEGIN_CLOSE_DC(11); Freeing pDeviceSurface = %x\n", pds->SurfaceBmapInfo.pBits));

         // Free "device-surface" bitmap
         if (pds->SurfaceBmapInfo.pBits)
         {
            rc = GplMemoryFree (pds->SurfaceBmapInfo.pBits);
            assertT (rc);
         }

         pds->SurfaceBmapInfo.pBits = NULL;

         if (pddc->pmdi)
         {
            rc = GplMemoryFree (pddc->pmdi);
            assertT (rc);
         }
         pddc->pmdi = NULL;
      }

      if (GRE_22 > globals.ulGreVersion)
      {
         //*****************************************
         // SHADOW DC cleanup (if present)
         //*****************************************

         // deselect the clip region for the shadow DC
         DBPRINTIF ((bShow, "BEGIN_CLOSE_DC(11): pddc->hdcShadow=%x, hrgnOld=%x\n", pddc->hdcShadow, hrgnOld));

         lWork = GreSelectClipRegion (pddc->hdcShadow, (HRGN)0, &hrgnOld);
         assertF (lWork != (LONG)RGN_ERROR);
         assertF (hrgnOld ? hrgnOld == pddc->hrgnShadow : TRUE);

         // clean up the clip region
         DBPRINTIF ((bShow, "BEGIN_CLOSE_DC(11): pddc->hdcShadow=%x, pddc->hrgnShadow=%x\n", pddc->hdcShadow, pddc->hrgnShadow));

         bRC = GreDestroyRegion (pddc->hdcShadow, pddc->hrgnShadow);
         assertF (bRC);
         pddc->hrgnShadow = 0;

         // if we created a shadow bitmap
         if (pddc->StateData.fUseBitmap)
            DestroyShadowBitmap (pddc);

         // close the shadow DC in the display
         bRC = GreCloseDC (pddc->hdcShadow);
         assertF (bRC);
         pddc->hdcShadow = 0;
      }


      if (GRE_22 <= globals.ulGreVersion)
      {
         PDEVICESURFACE pds;

         // 2.2 Engine or above
         pds = (PDEVICESURFACE)pddc->pdb->pDeviceSurface;

         DBPRINTF (("BEGIN_CLOSE_DC(11); Freeing Patterns = %x\n", &pds->abmapinfoDefPattern));

         // Note: we only allocate patterns in querydevicesurface if
         // we are running on the PM Graphics Engine v2.2 or higher

         if (GplPatternDeleteBitmaps (pddc->pdb->hmcbHeap,
                                      (PBMAPINFO)&pds->abmapinfoDefPattern,
                                      DEFAULT_PATTERNS_NUMBER))
         {
            pddc->pdb->bAllocatedPatterns = FALSE;
         }
      }

      // successful return code
      ulrc = 0;

      DBPRINTIF ((bShow, "BEGIN_CLOSE_DC(11); Exit\n"));
      break;
   } /* end BEGIN_CLOSE_DC */

   case SAVE_DC:
   {
      DBPRINTIF ((bShow, "SAVE_DC(7); pddc=%x\n", p1));
      pddc = (PDDC)p1;

      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine

         // de-select any current clip region from the shadow DC by setting
         // a null one.  This is because there is one reference to to clip region
         // in the original DC.  The shadow DC should not also be referencing it
         // in save/restore logic.
         ulrc = GreSelectClipRegion (pddc->hdcShadow, (HRGN)0, &hrgnOld);
         assertF (ulrc != RGN_ERROR);

         bRC = GreSaveDC (pddc->hdcShadow);
         assertF (bRC);
      }

      // successful return code
      ulrc = 0;
      break;
   }

   case RESTORE_DC:
   {
      DBPRINTIF ((bShow, "RESTORE_DC(8); pddc=%x  state number=%x\n", p1, p2));
      pddc = (PDDC)p1;

      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine

         // deselect the clip region for the shadow DC
         lWork = GreSelectClipRegion (pddc->hdcShadow, (HRGN)0, &hrgnOld);
         assertF (lWork != (LONG)RGN_ERROR);
         assertF (hrgnOld ? hrgnOld == pddc->hrgnShadow : TRUE);

         bRC = GreRestoreDC (pddc->hdcShadow, (LONG)p2);
         assertF (bRC);

         // select the clip region for the shadow DC
         //lWork = GreSelectClipRegion (pddc->hdcShadow, pddc->hrgnShadow, &hrgnOld);
         //assertF (lWork != (LONG)RGN_ERROR);
         //assertF (hrgnOld == 0);
      }

      // success result
      ulrc = 0;
      break;
   } /* end RESTORE_DC */

   case RESET_DC:
   {
      DBPRINTIF ((bShow, "RESET_DC(9); pddc=%x \n", p1));
      pddc = (PDDC)p1;

      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine

         // deselect the clip region for the shadow DC; otherwise, the engine will delete the region if selected
         lWork = GreSelectClipRegion (pddc->hdcShadow, (HRGN)0, &hrgnOld);
         assertF (lWork != (LONG)RGN_ERROR);
         assertF (hrgnOld ? hrgnOld == pddc->hrgnShadow : TRUE);

         // reset the shadow DC
         bRC = GreResetDC (pddc->hdcShadow, 0);
         assertF (bRC);

         // select the clip region for the shadow DC
         //lWork = GreSelectClipRegion (pddc->hdcShadow, pddc->hrgnShadow, &hrgnOld);
         //assertF (lWork != (LONG)RGN_ERROR);
         //assertF (hrgnOld == 0);
      }

      // successful return code
      ulrc = 0;
      break;
   } /* end RESET_DC */

   case QUERY_DEVICE_SURFACE:
   {
      /* p1 - NULL           - Engine is querying us to see if we support this
      **                       call. return 0 if we do
      **      PDEVICESURFACE - Device Surface
      **
      ** p2 - PDDC
      */

      DBPRINTIF ((bShow, "QUERY_DEVICE_SURFACE(14);  p1=%x; p2=%x\n", p1, p2));
      pddc = (PDDC)p2;

      // Engine is merely asking if we support this call
      if (!p1)
      {
         ulrc = 0;  // We support this function!
      }
      else
      {
         // actual call to query our device surface
         assertF (p2);
         ulrc = QueryDeviceSurface (pddc, (PVOID)p1);
      }
      break;
   } /* end QUERY_DEVICE_SURFACE */

   default:
   {
      assertstring ("Unknown subfunction!\n");
      DBPRINTF (("%s(): Unknown Subfunction = %d\n", __FUNCTION__, ulSubFunc));
      break;
   }
   }

depart:
   UNREGISTERHANDLER (regrec);
   return ulrc;

} /* end OS2_PM_DRV_ENABLE */


/****************************************************************************/
/* PROCEDURE NAME : DestroyDeviceBlock                                      */
/* AUTHOR         : Mark H. and Matt R.                                     */
/* DATE WRITTEN   :                                                         */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID
DestroyDeviceBlock (PDEVICEBLOCK pdb)
{
   HMCB     hmcbHeap = NULL;
   APIRET   bRC;

   assertF (pdb);
   DBPRINTF (("%s() Enter\n", __FUNCTION__ ));

// begin @JPN2H99
   // Free mem alloc'd for printer properties
   if (pdb->pPrnProperties)
   {
      bRC = GplMemoryFree (pdb->pPrnProperties);
      assertF (bRC == NO_ERROR);
   }
// end @JPN2H99

   // Free function table
   if (pdb->pDevFuncs)
   {
      bRC = GplMemoryFree (pdb->pDevFuncs);
      assertF (bRC == NO_ERROR);
   }

   // Free pointers in device block
   if (pdb->pDrivData)
   {
      bRC = GplMemoryFree (pdb->pDrivData);
      assertF (bRC == NO_ERROR);
   }

   if (pdb->pszPrinterName)
   {
      bRC = GplMemoryFree (pdb->pszPrinterName);
      assertF (bRC == NO_ERROR);
   }

   if (pdb->pFormInfo)
   {
      bRC = GplMemoryFree (pdb->pFormInfo);
      assertF (bRC == NO_ERROR);
   }

   if (pdb->pTrayInfo)
   {
      bRC = GplMemoryFree (pdb->pTrayInfo);
      assertF (bRC == NO_ERROR);
   }

   if (pdb->pMediaInfo)
   {
      bRC = GplMemoryFree (pdb->pMediaInfo);
      assertF (bRC == NO_ERROR);
   }

   
   if (pdb->pLargeFormInfo)
   {
      bRC = GplMemoryFree (pdb->pLargeFormInfo);
      assertF (bRC == NO_ERROR);
   }

   if (pdb->pdfm)
   {
      PDEVFONTMETRICS pdfm;
      register INT    i;

      pdfm = pdb->pdfm;

      for (i = 0; i < pdb->ulNumDevFonts; i++)
      {
         if (pdfm->pFoca)
         {
////////////DBPRINTF (("Freeing focametrics for %s@%d at %08X\n",
////////////           pdfm->pFoca->fmMetrics.szFacename,
////////////           pdfm->pFoca->fmMetrics.usNominalPointSize / 10,
////////////           pdfm->pFoca));

            bRC = GplMemoryFree (pdfm->pFoca);
            assertT (bRC);

            pdfm->pFoca = NULL;
         }

         if (GRE_23C > globals.ulGreVersion)
            // Old engine
            pdfm = (PDEVFONTMETRICS)(((POLDDEVFONTMETRICS)pdfm) + 1);
         else
            // New engine
            pdfm++;
      }

//////DBPRINTF (("Freeing DeviceFontMetrics at %08X\n", pdb->pdfm));

      bRC = GplMemoryFree (pdb->pdfm);
      assertT (bRC);

//////#ifdef DEBUG
//////{
//////      // BUG! BUG! - This is a Pete Zannucci famous fix!
//////      //             br e UnLoadDeviceFonts + 8 "E EAX+C 0;G"
//////      pdb->pdfm->achFileName[0] = '\0';
//////}
//////#endif

      pdb->pdfm = NULL;
   }

   pdb->pDrivData      = NULL;
   pdb->pszPrinterName = NULL;
   pdb->pFormInfo      = NULL;
   pdb->pTrayInfo      = NULL;

   // free lists since user cancelled
   FreeUserDefinedFontList (pdb->pDevice);
   FreeUserDefinedTrayList (pdb->pDevice);
   FreeUserDefinedFormList (pdb->pDevice);
   FreeConnectionList (pdb->pDevice);

   // copy heap base pointer to an automatic variable
   hmcbHeap = pdb->hmcbHeap;

// DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   OMNIFreeDLL (pdb->pDLLuseage);
#endif

   // Free the device block
   bRC = GplMemoryFree (pdb);
   assertF (bRC == NO_ERROR);

   // Free the heap
   GplMemoryDeleteInstance (hmcbHeap);

   DBPRINTF (("%s() Exit\n", __FUNCTION__));

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
#endif

} /* end DestroyDeviceBlock */

/****************************************************************************/
/* PROCEDURE NAME : DestroyDeviceCookie                                     */
/* AUTHOR         : Mark H. and Matt R.                                     */
/* DATE WRITTEN   :                                                         */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID
DestroyDeviceCookie (PDDC pddc, PDEVICEBLOCK pdb)
{
   DBPRINTF (("%s() Enter\n", __FUNCTION__));

   if (pdb)
   {
      if (pdb->pvDeviceCookie)
      {
         if (pdb->pDevice)
         {
            PFNSUBCLASS    ppfnDevice;

            ppfnDevice = pdb->pDevice->pSubclassedFunctions;
            assertF (ppfnDevice);

            if (ppfnDevice)
            {
               if (ppfnDevice->pfnDeviceQuery)
               {
                  if (pddc)
                  {
                     ppfnDevice->pfnDeviceQuery (pddc,
                                                 DEVICE_FREE_HANDLE,
                                                 pdb->pvDeviceCookie,
                                                 (BOOL)FALSE);
                  }
               }
            }

            pdb->pvDeviceCookie = NULL;
         }
      }
      else
      {
         DBPRINTF (("%s() No DeviceCookie!\n", __FUNCTION__));
      }
   }
   else
   {
      DBPRINTF (("%s() No pdb!\n", __FUNCTION__));
   }

   DBPRINTF (("%s() Exit\n", __FUNCTION__));

} /* end DestroyDeviceCookie */


/****************************************************************************/
/* PROCEDURE NAME : DestroyDrawingContext                                   */
/* AUTHOR         : Mark H. and Matt R.                                     */
/* DATE WRITTEN   :                                                         */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID
DestroyDrawingContext (PDDC pddc)
{
   BOOL     bRC;
   APIRET   rc;

   assertF (pddc);
   DBPRINTF (("%s() Enter\n", __FUNCTION__ ));

   // Close down anything open
   if (pddc->hrgnShadow)
   {
      // clean up the clip region
      DBPRINTF (("%s() Cleaning up shadow clip region...\n", __FUNCTION__));
      bRC = GreDestroyRegion (pddc->hdcShadow, pddc->hrgnShadow);
      assertF (bRC);
      pddc->hrgnShadow = 0;
   }

   if (pddc->hbmShadow)
      DestroyShadowBitmap (pddc);

   if (pddc->hdcShadow)
   {
      // close the shadow DC in the display
      DBPRINTF (("%s() Cleaning up shadow DC...\n", __FUNCTION__));
      bRC = GreCloseDC (pddc->hdcShadow);
      assertF (bRC);
      pddc->hdcShadow = 0;
   }

   if (pddc->pdb->hspl)
   {
      PFNSUBCLASS ppfnDevice;

      assertstring ("Shouldn't be here??\n");

      ppfnDevice = pddc->pdb->pDevFuncs;
      assertF (ppfnDevice);

      DBPRINTF (("%s() Closing Port: hspl = %x\n", __FUNCTION__, pddc->pdb->hspl));

      if (ppfnDevice->pfnDeviceClose)
      {
         ppfnDevice->pfnDeviceClose (pddc->pdb->pvDeviceCookie,
                                     pddc->pdb->hspl);
      }
      else
      {
         bRC = PrtClose (pddc->pdb->hspl);
      }

      pddc->pdb->hspl = 0;
   }

   // Destroy the "Device Cookie" at this time since we still have both
   // a pddc and a pdb, this should be after ALL pfnSubclass function calls
   DestroyDeviceCookie (pddc, pddc->pdb);

   // Free pointers in drawing context block

   /* Clean up journal handle.  We do this at this point also because if the
   ** application (or us ;) traps, then the engine will close all of the
   ** open DCs.  If we are journalling, then the GplJournalDeleteInstance
   ** function will delete the journal file.
   */
   if (pddc->hJournal)
   {
      PFNSUBCLASS    pfnTbl        = NULL;

      pfnTbl = pddc->pdb->pDevice->pSubclassedFunctions;

      DBPRINTF (("%s() Cleaning up Journal Instance\n", __FUNCTION__ ));

      if (  !pfnTbl->pfnBandingSupport
         || !pfnTbl->pfnBandingSupport (pddc->pdb->pvDeviceCookie,
                                        BANDINGSUPPORT_DELETE,
                                        pddc->hJournal)
         )
      {
         rc = GplJournalDeleteInstance (pddc->hJournal);

         // Driver must free memory!
         rc = GplMemoryFree (pddc->hJournal);
         assertT (rc);

         pddc->hJournal = NULL;
      }
   }

   // Not the 2.2 Engine
   if (GRE_22 > globals.ulGreVersion)
   {
      if (((PDEVICESURFACE)pddc->pdb->pDeviceSurface)->DitherMatrix.pLog2PhysDI)
      {
         DBPRINTF (("%s() Cleaning up dither matrix...\n", __FUNCTION__ ));
         rc = GplMemoryFree (((PDEVICESURFACE)pddc->pdb->pDeviceSurface)->DitherMatrix.pLog2PhysDI);
         assertT (rc);
      }

      DBPRINTF (("%s() Cleaning up device surface...\n", __FUNCTION__ ));
      rc = GplMemoryFree (pddc->pdb->pDeviceSurface);
      assertT (rc);
   }

   // Free the drawing context
   DBPRINTF (("%s() Free PDDC memory\n", __FUNCTION__ ));
   rc = GplMemoryFree (pddc);
   assertT (rc);

   DBPRINTF (("%s() Exit\n", __FUNCTION__ ));

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
   rc++;
#endif

} /* end DestroyDrawingContext */


/****************************************************************************/
/* PROCEDURE NAME : DestroyShadowBitmap                                     */
/* AUTHOR         : Mark H. and Matt R.                                     */
/* DATE WRITTEN   :                                                         */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID
DestroyShadowBitmap (PDDC pddc)
{
   LONG     lWork;

   // de-select the bitmap from the shadow DC
   lWork = GreSelectBitmap (pddc->hdcShadow, 0);
   assertF ((HBITMAP)lWork != HBM_ERROR);

   // destroy the bitmap for the shadow DC
   /* NOTE: This fails if the usage count for this bitmap is not 0.
   **       One reason     this may fail is that the save/restoreDC level
   **       is not 0.  Every time a saveDC is called, the usage count for
   **       the bitmap is bumped up...
   */
   lWork = GreDeleteBitmap (pddc->hbmShadow);
   assertF (lWork);
   pddc->hbmShadow = 0;

#ifndef DEBUG
   lWork++;          // Avoid compiler warnings
#endif
}

/****************************************************************************/
/* PROCEDURE NAME : SetupDeviceSurface                                      */
/* AUTHOR         : Mark H.                                                 */
/* DATE WRITTEN   :                                                         */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID
SetupDeviceSurface (PDDC pddc)
{
   PDEVICEBLOCK   pdb         = pddc->pdb;
   PFNSUBCLASS    pfnTbl      = pdb->pDevice->pSubclassedFunctions;
   ULONG          cBytesPerLine;
   PDEVICESURFACE pds;
   PMDI           pmdi;
   LONG           lWork;
   ULONG          ulIntensity = 30;
   ULONG          ulOptions   = 0;
   BYTE           bRedWt      = 25,
                  bGreenWt    = 60,
                  bBlueWt     = 15;
   APIRET         rc;
   register INT   i;
#ifdef DEBUG
   PDEBUGINFO     pDbg        = &globals.DebugInfo;
#endif

   /* @169465 - Coop says that the intensity should be dependent on
   ** the resolution.  Ex: at 300 dpi = 30 and at 600 dpi = 60
   */
   ulIntensity = FIXEDINT (f_lsqrt ( pddc->pdb->pResInfo->ulXRes
                                   * pddc->pdb->pResInfo->ulYRes ))
                 / 10.0;
   DBPRINTF (("ulIntensity = %d\n", ulIntensity));

   // If it has been determined journaling is required
   if (pddc->StateData.fUseJournaling)
   {
      PFNSUBCLASS ppfnDevice;
      ULONG       ulWant;
      ULONG       ulBandSize;
      BOOL        bOverrideBandSize;

      // Default to handle both portrait and landscape cases...
      ulWant = DEVICE_PORTRAIT_OR_LANDSCAPE;

      // See if Device Query subfunction is hooked out
      ppfnDevice = pddc->pdb->pDevice->pSubclassedFunctions;
      assertF (ppfnDevice);

      if (ppfnDevice->pfnDeviceQuery)
      {
         rc = ppfnDevice->pfnDeviceQuery ((PVOID)pddc,
                                          DEVICE_QUERY_ROTATION_CAPS,
                                          (PVOID)&ulWant);
         if (!rc)
            // Error! Restore value
            ulWant = DEVICE_PORTRAIT_OR_LANDSCAPE;
      }

      if (DEVICE_ALWAYS_PORTRAIT == ulWant)
         pddc->IJournal.bPortrait = TRUE;
      else if (DEVICE_ALWAYS_LANDSCAPE == ulWant)
         pddc->IJournal.bPortrait = FALSE;
      else  //... if (DEVICE_PORTRAIT_OR_LANDSCAPE == ulWant)
      {
         if (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)
            pddc->IJournal.bPortrait = TRUE;
         else
            pddc->IJournal.bPortrait = FALSE;
      }

      
      // if nUp or Booklet are enabled
      //
      if (pddc->pdb->ulNupPages == 2)
      {
         pddc->IJournal.bPortrait = !pddc->IJournal.bPortrait;
      }
      

      if (pfnTbl->pfnBandingSupport)
      {
         // Allocate device handle!!! before calling for data!
         AllocateDeviceHandle (pddc, FALSE);
      }

      // Initialize input for possible journalling
      pddc->pdb->bRasterPortrait      = pddc->IJournal.bPortrait;

      pddc->IJournal.ulSize           = sizeof (pddc->IJournal);
      pddc->IJournal.hdc              = pddc->pdb->hdc;
      pddc->IJournal.hModule          = globals.hModule;
      pddc->IJournal.pfunBandCallback = (PJFUN)NewFrame;
      pddc->IJournal.pfunArg          = (PVOID)pddc;
      pddc->IJournal.usXLength        = pddc->pdb->pFormInfo->hcInfo.xPels;
      pddc->IJournal.usYLength        = pddc->pdb->pFormInfo->hcInfo.yPels;

      bOverrideBandSize = FALSE;
      if (PrfQueryProfileSize (HINI_SYSTEMPROFILE,
                               APPNAME_DEBUGINFO,
                               KEYNAME_BANDSIZE,
                               &ulBandSize))
      {
         CHAR   achString[30];

         if (PrfQueryProfileString (HINI_SYSTEMPROFILE,
                                    APPNAME_DEBUGINFO,
                                    KEYNAME_BANDSIZE,
                                    "",
                                    achString,
                                    sizeof (achString)))
         {
            ulBandSize = atoi (achString);
            if (ulBandSize)
            {
               bOverrideBandSize = TRUE;
               DBPRINTF (("*** New band size in bytes is %d! ***\n", ulBandSize));
            }
         }
      }

      if (!bOverrideBandSize)
      {
         ULONG   ulPhyMem = 8;

         ulBandSize = 512*1024;
         if (GplQueryPhysicalMem (&ulPhyMem))
         {
            DBPRINTF (("GplQueryPhysicalMem returns %d\n", ulPhyMem));

// begin @UCCTmp
            if (64 <= ulPhyMem)
               // 64MB or more                   --   8MB
               ulBandSize = 8000*1024;
            else if (32 <= ulPhyMem)
               // 32MB or more                   --   4MB
               ulBandSize = 4000*1024;
            else if (20 <= ulPhyMem)
               // 20MB or more                   --   2MB
               ulBandSize = 2000*1024;
            else if (12 <= ulPhyMem)
               // between 12MB and 19MB          --   1MB
               ulBandSize = 1000*1024;
            else if (4 < ulPhyMem)
               // between 5MB and 11MB           -- 512KB
               ulBandSize = 512*1024;
            else // if (4 >= ulPhyMem)
               // 4MB or less                    -- 256KB
               ulBandSize = 256*1024;
// end @UCCTmp
         }
      }

      // *NOTE: usDotsPerColumn should NOT be 0 for those devices that
      //        do not have the "column" concept (i.e. dot matrix printhead)
      //        and instead should be 1 (TBD - validate here or in jnl routine)
      pddc->StateData.fBanding = GplJournalCalcBandSize (&pddc->IJournal,
                                               pddc->pdb->pPrintMode->usBitsPerPel,
                                               pddc->pdb->pPrintMode->usNumPlanes,
                                               pddc->pdb->pResInfo->usDotsPerColumn,
                                               ulBandSize);

      if (pfnTbl->pfnBandingSupport)
          pfnTbl->pfnBandingSupport (pdb->pvDeviceCookie,
                                     BANDINGSUPPORT_ENABLE_BANDING,
                                     &pddc->StateData.fBanding);

      /* Delete the journal file if it existed before
      ** We will recreate it (if necessary) after the call to ResetDC2
      */
      if (pddc->hJournal)
      {
         if (!pfnTbl->pfnBandingSupport                        ||
             !pfnTbl->pfnBandingSupport (pdb->pvDeviceCookie,
                                         BANDINGSUPPORT_DELETE,
                                         pddc->hJournal)        )
         {
            GplJournalDeleteInstance (pddc->hJournal);

            // Driver must free memory!
            rc = GplMemoryFree (pddc->hJournal);
            assertT (rc);

            pddc->hJournal = NULL;
         }
      }
   }

   pddc->bmp.cx        = pdb->pFormInfo->hcInfo.xPels;
   pddc->bmp.cy        = pdb->pFormInfo->hcInfo.yPels;
   pddc->bmp.cPlanes   = pdb->pPrintMode->usNumPlanes;
   pddc->bmp.cBitCount = pdb->pPrintMode->usBitsPerPel;

   if (pddc->StateData.fUseBitmap)
   {
      // create a bitmap for the shadow DC
      // DEVICE_SPECIFIC: bitmapinfoheader setup would change for a color printer
      // this bitmapinfoheader assumes a monochrome laser printer
      pddc->bmp.cbFix = sizeof (pddc->bmp);

      if ((OD_QUEUED == pddc->pdb->ulType)    &&
          (PM_Q_STD  == pddc->pdb->ulDataType) )
      {
         // Use a teeny tiny bitmap so that the display driver will not
         // trap if it needs to write to it...
         pddc->bmp.cx = 8;
         pddc->bmp.cy = 8;
      }
      else if (pddc->StateData.fBanding)
      {
         if (pddc->pdb->bRasterPortrait)
         {
            pddc->bmp.cx = pdb->pFormInfo->hcInfo.xPels;
            pddc->bmp.cy = pddc->IJournal.usBandLength;
         }
         else
         {
            pddc->bmp.cx = pddc->IJournal.usBandLength;
            pddc->bmp.cy = pdb->pFormInfo->hcInfo.yPels;
         }
      }
      else
      {
         pddc->bmp.cx = pdb->pFormInfo->hcInfo.xPels;
         pddc->bmp.cy = pdb->pFormInfo->hcInfo.yPels;
      }

      pddc->bmp.cPlanes   = pdb->pPrintMode->usNumPlanes;
      pddc->bmp.cBitCount = pdb->pPrintMode->usBitsPerPel;

      DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); bmp.cx = %d, bmp.cy = %d\n", pddc->bmp.cx, pddc->bmp.cy));
      DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); bmp.cPlanes = %d, bmp.cBitCount = %d\n", pddc->bmp.cPlanes, pddc->bmp.cBitCount));

      if (GRE_22 > globals.ulGreVersion)
      {
         // Not the 2.2 Engine
         if (pddc->hbmShadow)
         {
            // if we created a shadow bitmap
            DestroyShadowBitmap (pddc);
         }

         pddc->hbmShadow = GreCreateBitmap (pddc->hdcShadow,
                                            &pddc->bmp,
                                            0,
                                            NULL,
                                            NULL);
         assertF (pddc->hbmShadow);

         // select this bitmap into the shadow DC
         lWork = GreSelectBitmap (pddc->hdcShadow, pddc->hbmShadow);
         assert (lWork == 0);

         // Initialize memory surface to background color
         lWork = GreErasePS (pddc->hdcShadow) ;
         assert (lWork);
      }
   }
   else
   {
      pddc->hbmShadow = (HBITMAP)NULL;
   }

   // Calculate the # of bits per line
   cBytesPerLine = pddc->bmp.cx*pddc->pdb->pPrintMode->usBitsPerPel;

   // Translate into bytes (double-word aligned)
   cBytesPerLine = (cBytesPerLine + 31)/32*4;

   // Set up the device surface
   pds = (PDEVICESURFACE)pddc->pdb->pDeviceSurface;
   assertF (pds);

   pds->SurfaceBmapInfo.ulLength       = sizeof (BMAPINFO);
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulLength       = %lu\n", pds->SurfaceBmapInfo.ulLength));

   pds->SurfaceBmapInfo.ulType         = 0; // Coop says "don't set anything!"
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulType         = %lu\n", pds->SurfaceBmapInfo.ulType));

   pds->SurfaceBmapInfo.ulWidth        = pddc->bmp.cx;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulWidth        = %lu\n", pds->SurfaceBmapInfo.ulWidth));

   pds->SurfaceBmapInfo.ulHeight       = pddc->bmp.cy;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulHeight       = %lu\n", pds->SurfaceBmapInfo.ulHeight));

   pds->SurfaceBmapInfo.ulBpp          = pddc->pdb->pPrintMode->usBitsPerPel;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulBpp          = %lu\n", pds->SurfaceBmapInfo.ulBpp));

   pds->SurfaceBmapInfo.ulBytesPerLine = cBytesPerLine;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.ulBytesPerLine = %lu\n", pds->SurfaceBmapInfo.ulBytesPerLine));

   pds->SurfaceBmapInfo.pBits          = NULL;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->SurfaceBmapInfo.pBits          = %lu\n", pds->SurfaceBmapInfo.pBits));

   pds->ulReserved[0]                  = (ULONG)pddc;

   /* Check to see if this version of the engine supports the
   ** DS_BOTTOMTOP flag.  If not, we must flip the scan lines ourselves...
   */
   if (GRE_23 <= globals.ulGreVersion)
      pds->ulDSFlgs                    = DS_BOTTOMTOP
                                       | DS_DWORDALIGN;
   else
      pds->ulDSFlgs                    = DS_TOPBOTTOM
                                       | DS_DWORDALIGN;

   // Coop requests we do not set unless really mono
   if (1 == pds->SurfaceBmapInfo.ulBpp)
      pds->ulDSFlgs                   |= DS_MONO_INVERT
                                      | DS_KEEP_EXTFORMAT;

   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->ulDSFlgs                       = %lu\n", pds->ulDSFlgs));

   
   // Disable device fonts if Booklet or Nup is enabled
   //
   if ( pdb->ulNupPages < 2 )
   {
      // @DEVFONT - if device has device fonts defined we want engine simulation/management
      if (0 < ReturnNumberOfDeviceFonts (pdb->pDriver, pdb->pDevice))
      {
         DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC,
                     "COMPLETE_OPEN_DC(10); '%d' Device Fonts, set DS_DEVICE_FONTS (%lu)\n",
                     ReturnNumberOfDeviceFonts (pdb->pDriver, pdb->pDevice),
                     DS_DEVICE_FONTS));

         // Tell GRE we have device fonts we wish them to manage if
         // device file indicates they export fonts
         pds->ulDSFlgs |= DS_DEVICE_FONTS;

         // Set Omni driver default clipping rule for text
         // This means 100% char must be showing or it is entirely clipped
         // We default to this since this is fastest method
         // Device file can shoose to override in DeviceSurface structure
         pds->ulDSFlgs |= DS_CLIP_100_RULE;
      }
   }

   if (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)
       pds->ulStyleRatio = MAKEUSHORT (ResolutionToStyleRatio (pddc->pdb->pResInfo->ulYRes),
                                   ResolutionToStyleRatio (pddc->pdb->pResInfo->ulXRes));
   else
       pds->ulStyleRatio = MAKEUSHORT (ResolutionToStyleRatio (pddc->pdb->pResInfo->ulXRes),
                                   ResolutionToStyleRatio (pddc->pdb->pResInfo->ulYRes));

   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->ulStyleRatio                   = %x:%x\n", HIBYTE (pds->ulStyleRatio), LOBYTE (pds->ulStyleRatio)));

   pds->DitherMatrix.ulLength     = sizeof (DITHERMATRIX);
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->DitherMatrix.ulLength     = %lu\n", pds->DitherMatrix.ulLength));

   /* @169790 - Problems seen when using magic squares dithering from 24 -> 8
   **           and again from 8 -> 1.
   ** @170285 - But only for color!! DOH!
   */
   if (24 == pdb->pPrintMode->usBitsPerPel ||
        8 == pdb->pPrintMode->usBitsPerPel  )
   {
      if (HT_ERR_DIFFUSION       == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_ERR_DIFFUSION6      == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_ERR_DIFFUSION5      == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_ADAPTIVE_DIFFUSION  == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_FAST_DIFFUSION      == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_STEINBERG_DIFFUSION == pddc->pdb->pJobProperties->ulAlgorithm ||
          HT_SMOOTH_DIFFUSION    == pddc->pdb->pJobProperties->ulAlgorithm  )
         // Coop says "It is safe to use magic square!"
         pds->DitherMatrix.fLog2PhysSup = GDM_MATRIX_DITHER;
      else
         // Coop says "Dont double magic square!"
         pds->DitherMatrix.fLog2PhysSup = GDM_NO_DITHER;
   }
   else
      /* Certainly dont map to monochrome!
      ** Coop says "It is safe to use magic square!"
      */
      pds->DitherMatrix.fLog2PhysSup = GDM_MATRIX_DITHER;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->DitherMatrix.fLog2PhysSup = %lu\n", pds->DitherMatrix.fLog2PhysSup));

   //pds->DitherMatrix.fExt2IntSup  = GDM_ERRORDIF_DITHER;
   pds->DitherMatrix.fExt2IntSup  = GDM_NO_DITHER;
   DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "COMPLETE_OPEN_DC(10); pds->DitherMatrix.fExt2IntSup = %lu\n", pds->DitherMatrix.fExt2IntSup));

   /* Look for Triplet Modifiers which effect Hue, Saturation, & Vividness.
   ** This is used for the color plane separation code.
   ** Look for Triplet Modifiers which effect Intensity, & dithering options.
   ** This is specific only to the raster engine.
   */
   if (pddc->pdb->pDevice->pTripletModifiers &&
       pddc->pdb->pDevice->ulNumModifiers     )
   {
      PTRIPLETMODIFIERS  pTripletModifiers;

      pTripletModifiers = pddc->pdb->pDevice->pTripletModifiers;
      for (i = pddc->pdb->pDevice->ulNumModifiers;
           i;
           i--, pTripletModifiers++)
      {
         if (pddc->pdb->pResInfo->ulResID         == pTripletModifiers->ulResID       &&
             pddc->pdb->pPrintMode->ulPrintModeID == pTripletModifiers->ulPrintModeID &&
             pddc->pdb->pMediaInfo->ulMediaID     == pTripletModifiers->ulMediaID      )
         {
            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC,
                        "Triplet modifier found (%d, %d, %d)!\n",
                        pTripletModifiers->ulResID,
                        pTripletModifiers->ulPrintModeID,
                        pTripletModifiers->ulMediaID));

            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "Hue incremented by %d.\n", pTripletModifiers->lHue));
            pddc->pdb->pJobProperties->lHue        += pTripletModifiers->lHue;

            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "Saturation incremented by %d.\n", pTripletModifiers->lSaturation));
            pddc->pdb->pJobProperties->lSaturation += pTripletModifiers->lSaturation;

            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC, "Value incremented by %d.\n", pTripletModifiers->lValue));
            pddc->pdb->pJobProperties->lValue      += pTripletModifiers->lValue;

            ulOptions   = pTripletModifiers->lDarknessOptions;
            ulIntensity = pTripletModifiers->lDarkness;
            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC,
                        "New ulOptions = %d, new ulIntensity = %d\n",
                        ulOptions,
                        ulIntensity));

            bRedWt   = pTripletModifiers->bRedWt;
            bGreenWt = pTripletModifiers->bGreenWt;
            bBlueWt  = pTripletModifiers->bBlueWt;
            DBPRINTIF ((pDbg->bENABLE_COMPLETE_OPEN_DC,
                        "New Red Green Blue weights (%d, %d, %d)\n",
                        bRedWt, bGreenWt, bBlueWt));
            assertT (bRedWt + bGreenWt + bBlueWt != 100);
            break;
         }
      }
   }

   if (GRE_22 > globals.ulGreVersion)
   {
      // Not the 2.2 Engine

      pmdi = (PMDI)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                   sizeof (MATRIXDITHERINFO));
      assertF (pmdi);
      pds->DitherMatrix.pLog2PhysDI = pmdi;

      if (pmdi)
      {
         memset (pmdi, 0, sizeof (MATRIXDITHERINFO));
         pmdi->ulLength    = sizeof (MATRIXDITHERINFO);
         pmdi->ulIntensity = 0;
         pmdi->ulType      = GDM_MATRIX_DITHER;
////////// @TBD - MDI_ORDERED_DOT is not in the h file!
//////////        Pre32 needs to act like the engine!!!
//////////pmdi->fOptions    = MDI_ORDERED_DOT;
         pmdi->fOptions    = 0;
         pmdi->szMatrix.cx = 8;
         pmdi->szMatrix.cy = 8;
      }
   }
   else
   {
      pmdi = (PMDI)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                   sizeof (MATRIXDITHERINFO));
      assertF (pmdi);
      pds->DitherMatrix.pLog2PhysDI = pmdi;

      pmdi->ulLength    = sizeof (MATRIXDITHERINFO);
      pmdi->fOptions    = ulOptions;

      /* @169790 - Problems seen when using magic squares dithering from 24 -> 8
      **           and again from 8 -> 1
      */
      if (24 == pdb->pPrintMode->usBitsPerPel ||
           8 == pdb->pPrintMode->usBitsPerPel  )
      {
         if (HT_ERR_DIFFUSION       == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_ERR_DIFFUSION6      == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_ERR_DIFFUSION5      == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_ADAPTIVE_DIFFUSION  == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_FAST_DIFFUSION      == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_STEINBERG_DIFFUSION == pddc->pdb->pJobProperties->ulAlgorithm ||
             HT_SMOOTH_DIFFUSION    == pddc->pdb->pJobProperties->ulAlgorithm  )
            // Coop says "It is safe to use magic square!"
            pmdi->ulType = GDM_MATRIX_DITHER;
         else
            // Coop says "Dont double magic square!"
            pmdi->ulType = GDM_NO_DITHER;
      }
      else
         /* Certainly dont map to monochrome!
         ** Coop says "It is safe to use magic square!"
         */
         pmdi->ulType = GDM_MATRIX_DITHER;

      // begin @203499
#if 0
//    LONG lValue;
//
//    // need define to deviate from default value of 30 (or device default)
//    lValue = ulIntensity - ( ((float)pddc->pdb->pJobProperties->lDarkness) * 2.56 );
//
//    if (lValue < 0)
//       ulIntensity = 0;
//    else
//       ulIntensity = lValue;
#else
      /* If default value of Intensity is set to 30 (300 dpi), we'll receive:
      **    -50 ...   0: Intensity = 158 ... 30
      **      0 ... +50: Intensity =  30 ...  1
      ** NOTE: a value of 0 will trap!
      */
      if (pddc->pdb->pJobProperties->lDarkness < 0)
         ulIntensity = (ULONG)( ulIntensity
                              - (float)pddc->pdb->pJobProperties->lDarkness * 2.56
                              );
      else
         ulIntensity = (ULONG)( ( (1.0 - (float)ulIntensity)
                                * (float)pddc->pdb->pJobProperties->lDarkness
                                / 50.0
                                )
                              + (float)ulIntensity
                              );
#endif
      // end @203499

      pmdi->ulIntensity = ulIntensity;
      pmdi->bRedWt      = bRedWt;
      pmdi->bGreenWt    = bGreenWt;
      pmdi->bBlueWt     = bBlueWt;

      pddc->pmdi = pmdi;
   }

   for (i = 0; i < CAPS_MAX_CAPS; i++)
      InnerQueryCaps (i, (PLONG)&pds->DevCaps[i], NULL, pdb);
   pds->ulCapsCnt = CAPS_MAX_CAPS;

   if (pddc->pdb->bAllocatedPatterns)
   {
      GplPatternDeleteBitmaps (pddc->pdb->hmcbHeap,
                               (PBMAPINFO)&pds->abmapinfoDefPattern,
                               DEFAULT_PATTERNS_NUMBER);
      pddc->pdb->bAllocatedPatterns = FALSE;
   }

   if (!pddc->pdb->bAllocatedPatterns)
   {
      ULONG ulFlip;

      // Need to invert pattern bitmaps if DS_BOTTOMTOP flag set
      // because GRE 2.3 will not flip them for us - MFR
      if (pds->ulDSFlgs & DS_BOTTOMTOP)
         ulFlip = GPLPAT_INVERT_BITS;
      else
         ulFlip = 0;

      if (ORIENTATION_PORTRAIT == pdb->pJobProperties->ulOrientation)
      {
         if (GplPatternCreateBitmaps (pddc->pdb->hmcbHeap,
                                      pddc->pdb->pResInfo->ulXRes,
                                      pddc->pdb->pResInfo->ulYRes,
                                      64L,
                                      64L,
                                      (PBMAPINFO)&pds->abmapinfoDefPattern,
                                      DEFAULT_PATTERNS_NUMBER,
                                      ulFlip))
            pddc->pdb->bAllocatedPatterns = TRUE;
      }
      else
      {
         if (GplPatternCreateBitmaps (pddc->pdb->hmcbHeap,
                                      pddc->pdb->pResInfo->ulYRes,
                                      pddc->pdb->pResInfo->ulXRes,
                                      64L,
                                      64L,
                                      (PBMAPINFO)&pds->abmapinfoDefPattern,
                                      DEFAULT_PATTERNS_NUMBER,
                                      ulFlip))
            pddc->pdb->bAllocatedPatterns = TRUE;
       }
   }

#ifndef DEBUG
   lWork++;          // Avoid compiler warnings
#endif

} /* end SetupDeviceSurface */

/****************************************************************************/
/* PROCEDURE NAME : OS2_PM_DRV_DEVICENAMES                                  */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 9/21/92                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG APIENTRY
OS2_PM_DRV_DEVICENAMES (PSZ       pszDriverName,
                        PLONG     pcNames,
                        PSZ       pstr32DeviceNames,
                        PSZ       pstr64DeviceDescriptions,
                        PLONG     pcDataTypes,
                        PSZ       pstr16DataTypes,
                        ULONG     ulReserved1,
                        ULONG     ulReserved2)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL DECLARATIONS                                                     */
   /*------------------------------------------------------------------------*/
   LONG           i;
   REGREC         regrec;
   ULONG          ulException;
   LONG           lrc;
#ifdef DEBUG
   PDEBUGINFO     pDbg              = &globals.DebugInfo;
   BOOL           bShow             = pDbg->bOS2_PM_DRV_DEVICENAMES;
   BOOL           bRC;
#endif

   // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   INT            iDriver,
                  iDevice;
   ULONG          ulNumDefined      = 0,
                  ulCount           = 0;
   PDEVICEINFO    pDevice;
   PDRIVERINFO    DriversDLLBLD[1];
   CHAR           LoadError[100];
   HMODULE        ModuleHandle;
   APIRET         apirc;
   PFN            ProcAddress;

   CHAR           DllPath[100];
   LONG           DllPathLength;
   HDIR           FindHandle;
   FILEFINDBUF3   FindBuffer;
   ULONG          FindCount;
   ULONG          NumberOfDevices;
   PULONG         pNumberOfDevices;
#endif

   /*------------------------------------------------------------------------*/
   /* EXCEPTION HANDLER CODE                                                 */
   /*------------------------------------------------------------------------*/

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
      // clean up here
      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }

      // error result
      lrc = 0;
      goto depart;
   }

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/

   // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD

   // Here we will loop thru all dlls in the same subdirectory as the psDriverName

   for (i = strlen(pszDriverName); i != 0; i--)
      if (*(pszDriverName + i) == '\\')
         break;

   for (DllPathLength = 0; DllPathLength <= i; DllPathLength++)
      *(DllPath + DllPathLength) = *(pszDriverName + DllPathLength);

   strcpy (DllPath + DllPathLength, "*.DLL");              // Add *.DLL to path name
   FindHandle = 0x0001;
   FindCount = 1;

   apirc = DosFindFirst (DllPath,
                         &FindHandle,
                         0,
                         (PVOID)&FindBuffer,
                         sizeof (FindBuffer),
                         &FindCount,
                         FIL_STANDARD);
   assertT (apirc);

   strcpy (DllPath + DllPathLength, FindBuffer.achName);   // Get Name for first Dll

   apirc = DosLoadModule (LoadError, sizeof(LoadError), DllPath, &ModuleHandle);
   assertT (apirc);

   apirc = DosQueryProcAddr (ModuleHandle, 0, "PDRIVERDATA", &ProcAddress);
   assertT (apirc);

   DriversDLLBLD[0] = (PDRIVERINFO)ProcAddress;

   apirc = DosQueryProcAddr (ModuleHandle, 0, "NUMBEROFDEVICES",  &ProcAddress);
   assertT (apirc);

   NumberOfDevices = *(PULONG)ProcAddress;

#endif


#ifdef DEBUG
   /*---------------------------------------*/
   /* Initialize debug information          */
   /*---------------------------------------*/
   bRC = InitDebugInfo (pDbg, FALSE, FALSE);
   assertF (bRC);
#endif

   SetNumberOfPrinters ();  // Constant 1 in for now - will be deleted

#ifdef DEBUG
   DBPRINTIF ((bShow, "%s(): Enter\n", __FUNCTION__));
   DBPRINTIF ((bShow, "%s(): *pcNames     requested = %d\n", __FUNCTION__, *pcNames));
   DBPRINTIF ((bShow, "%s(): *pcDataTypes requested = %d\n", __FUNCTION__, *pcDataTypes));
#endif

 // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   iDriver = 0;
   do
   {
      // wants names and descriptions for count passed in
      if (*pcNames)
      {
         ulNumDefined += NumberOfDevices;

         // fill in names/descriptions for all those requested

         for (iDevice = DriversDLLBLD[iDriver]->ulNumDevices,
                    pDevice = DriversDLLBLD[iDriver]->pDevices;
                 iDevice;
                 iDevice--, pDevice++)
         {
            if (ulCount >= *pcNames)
               goto done2;

            strcpy (pstr32DeviceNames,        pDevice->pszDeviceName);
            strcpy (pstr64DeviceDescriptions, pDevice->pszDeviceDesc);

            DBPRINTIF ((bShow, "Returning Device Name = %s\n", pstr32DeviceNames));
            DBPRINTIF ((bShow, "Returning Device Desc = %s\n", pstr64DeviceDescriptions));

            pstr32DeviceNames         += sizeof (STR32);
            pstr64DeviceDescriptions  += sizeof (STR64);

            ulCount++;
         }
      }
      else
      {
         // Wants to find out how many devices we have
         ulNumDefined += NumberOfDevices;
      }

      // free previous dll
      apirc = DosFreeModule (ModuleHandle);
      assertT (apirc);

      // get next dll with driver info in
      apirc = DosFindNext (FindHandle, (PVOID) &FindBuffer, sizeof(FindBuffer), &FindCount );
      if (apirc == ERROR_NO_MORE_FILES)
        goto done;
      assertT (apirc);

      strcpy ( DllPath + DllPathLength, FindBuffer.achName);   // Get Name for first Dll

      apirc = DosLoadModule (LoadError, sizeof(LoadError), DllPath, &ModuleHandle);
      assertT (apirc);

      apirc = DosQueryProcAddr (ModuleHandle, 0, "PDRIVERDATA", &ProcAddress);
      if (apirc != 0)      // dll is not one of ours
          continue;

      DriversDLLBLD[0] = (PDRIVERINFO) ProcAddress;

      apirc = DosQueryProcAddr (ModuleHandle, 0, "NUMBEROFDEVICES", &ProcAddress);

      if (apirc != 0)      // dll is not one of ours
        continue;

      NumberOfDevices = * (PULONG) ProcAddress;

   } while (1);

done:

   *pcNames = ulNumDefined;

#else

   // wants names and descriptions for count passed in
   if (*pcNames)
   {
      register INT iDriver,
                   iDevice;
      ULONG        ulNumDefined,
                   ulCount       = 0;
      PDEVICEINFO  pDevice;

      ulNumDefined = NumberOfDeviceNames ();

      // return all names of devices we have defined or just # requested
      *pcNames = min (ulNumDefined, *pcNames);

      // fill in names/descriptions for all those requested
      for (iDriver = 0; iDriver < globals.ulTotalDrivers; iDriver++)
      {
         for (iDevice = Drivers[iDriver]->ulNumDevices,
                 pDevice = Drivers[iDriver]->pDevices;
              iDevice;
              iDevice--, pDevice++)
         {
            if (ulCount >= *pcNames)
               goto done2;

            strcpy (pstr32DeviceNames,        pDevice->pszDeviceName);
            strcpy (pstr64DeviceDescriptions, pDevice->pszDeviceDesc);

            DBPRINTIF ((bShow, "Returning Device Name = %s\n", pstr32DeviceNames));
            DBPRINTIF ((bShow, "Returning Device Desc = %s\n", pstr64DeviceDescriptions));

            pstr32DeviceNames         += sizeof (STR32);
            pstr64DeviceDescriptions  += sizeof (STR64);

            ulCount++;
         }
      }
   }
   else
   {
      // Wants to find out how many devices we have
      *pcNames = NumberOfDeviceNames ();
   }

#endif

done2:
   // If data types requested
   if (*pcDataTypes)
   {
      // wants data type data
      for (i = 0; i < min (2, *pcDataTypes); i++)
      {
         // we only have 2 data types defined for this driver
         // which are both standard for OS/2
         switch (i)
         {
         case 0:
         {
            strcpy (pstr16DataTypes, "PM_Q_STD");
            break;
         }

         case 1:
         {
            strcpy (pstr16DataTypes, "PM_Q_RAW");
            break;
         }
         }

         DBPRINTIF ((bShow, "%s(): Returning Data Type = %s\n", __FUNCTION__, pstr16DataTypes));

         pstr16DataTypes += 16;
      }
   }

   *pcDataTypes =  2;

   // successful result
   lrc = -1;

depart:

#ifdef DEBUG
   DBPRINTIF ((bShow, "%s(): *pcNames returned     = %d\n", __FUNCTION__, *pcNames));
   DBPRINTIF ((bShow, "%s(): *pcDataTypes returned = %d\n", __FUNCTION__, *pcDataTypes));
   DBPRINTIF ((bShow, "%s(): Exit\n", __FUNCTION__));
#endif

   UNREGISTERHANDLER (regrec);

   return lrc;

} /* end OS2_PM_DRV_DEVICENAMES */

/****************************************************************************/
/* PROCEDURE NAME : OS2_PM_DRV_DEVMODE                                      */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 9/23/92                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @EXJOB  - 07/13/98 - UCC [IBMJ]- Extended job data support               */
/*                                                                          */
/****************************************************************************/
LONG APIENTRY
OS2_PM_DRV_DEVMODE (PDRIVDATA pDrivdata,
                    PSZ       pszDriverName,
                    PSZ       pszDeviceName,
                    PSZ       pszPrinterName,
                    ULONG     ulOption)

{
   BOOL                 bRC;
   LONG                 lrc;
   LONG                 rc;
   PCHAR                pszAppname       = NULL;
   PDLGINSTANCE         pdi              = NULL;
   PDRIVDATA            pDrivData        = NULL;
   REGREC               regrec;
   SHORT                pmerr = 0;
   ULONG                ulException;
   HMCB                 hmcbHeap         = NULL;
   BOOL                 bFreePrinterName = FALSE;
// begin @EXJOB
   PDEVICEINFO          pDevice;
   ULONG                ulPropertySize   = 0;
   ULONG                ulDrivDataSize;
// end @EXJOB

 // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   PDLLUSEAGE           pDLLuseage;
#endif

#ifdef DEBUG
   PDEBUGINFO           pDbg             = &globals.DebugInfo;
   BOOL                 bShow            = pDbg->bOS2_PM_DRV_DEVMODE;
#endif

   /*------------------------------------------------------------------------*/
   /* EXCEPTION HANDLER CODE                                                 */
   /*------------------------------------------------------------------------*/
   assertF (pszDeviceName);
   if (pszDeviceName)
   {
      assertF (strlen (pszDeviceName));
   }

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
      // clean up here
      if (pdi)
      {
         rc = GplMemoryFree (pdi);
         assertT (rc);
         pdi = NULL;
      }

      if (pDrivData)
      {
         rc = GplMemoryFree (pDrivData);
         assertT (rc);
         pDrivData = NULL;
      }
      if (pszAppname)
      {
         rc = GplMemoryFree (pszAppname);
         assertT (rc);
         pszAppname = NULL;
      }
      if (pmerr)
      {
         GplErrSetError (pmerr);
      }

      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }

      // error result
      lrc = DPDM_ERROR;
      goto depart;
   }

// begin @EXJOB
   /*--------------------------------------------------*/
   /* CASE 0: Check if there exist extended job data   */
   /*--------------------------------------------------*/
   if (pszDeviceName && *pszDeviceName)
   {
      pDevice = PDeviceFromDeviceName (pszDeviceName);

      // Query current version JP size and allocate
      ulPropertySize = GetJobpropertiesSize (pDevice, JP_SIZE_ALL);
   }

   if (ulPropertySize < sizeof (JOBPROPERTIES))
   {
      // Don't know how to build pDevice, but something
      // have to set in ulPropertySize for returning!!

      ulPropertySize = sizeof (JOBPROPERTIES);
   }
   ulDrivDataSize = DRIVDATA_HEADER + ulPropertySize;
// end @EXJOB

   /*--------------------------------------------------*/
   /* CASE 1: Caller requests sizeof(DRIVDATA)         */
   /*--------------------------------------------------*/
   if (!pDrivdata)
   {
// begin @EXJOB
      lrc = ulDrivDataSize;
      DBPRINTIF ((TRUE, "%s(): User wants size of drivdata, returning %d\n", __FUNCTION__, lrc));

//    // user wants to know the length of driver data
//    DBPRINTIF ((TRUE, "%s(): User wants size of drivdata, returning %d\n", __FUNCTION__, DRIVERDATA_SIZE));
//    lrc = DRIVERDATA_SIZE;
// end @EXJOB
      goto depart;
   }

   /*--------------------------------------------------*/
   /* CASE 2: Return/display Job/Printer Properties    */
   /*--------------------------------------------------*/

   /*----------------------------*/
   /* Initialize Global Data     */
   /*----------------------------*/

   // Request global data semaphore (needed whenever changing global data)
   rc = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
   DBPRINTIF ((TRUE, "%s(): DosRequestMutexSem: rc=%d, hmtx = %x\n", __FUNCTION__, rc, procdata.hmtxGlobalSem));
   assertT (rc);

#ifdef DEBUG
   /*---------------------------------------*/
   /* Initialize debug information          */
   /*---------------------------------------*/
   bRC = InitDebugInfo (pDbg, FALSE, FALSE);
   assertF (bRC);
#endif

   DBPRINTIF ((bShow, "%s(): Enter\n", __FUNCTION__));

   InitStringTable (STRINGS_BASE | STRINGS_DIALOG);
   DBPRINTIF ((bShow, "%s(): StringTable Initialized, pb[0] = %x\n", __FUNCTION__, globals.pbStringTable[0]));

   // Release global data semaphore (needed whenever changing global data)
   rc = DosReleaseMutexSem (procdata.hmtxGlobalSem);
   DBPRINTIF ((TRUE, "%s(): DosReleaseMutexSem: rc=%d, hmtx = %x\n", __FUNCTION__, rc, procdata.hmtxGlobalSem));
   assertT (rc);

#ifdef DEBUG
   // Conditionally Print parameters passed into us by caller to debugger
   if (pDrivdata)
      DBPRINTIF ((bShow, "%s(): pDrivdata = %x\n", __FUNCTION__, pDrivdata));
   if (pszDriverName)
      DBPRINTIF ((bShow, "%s(): pszDriverName = %s\n", __FUNCTION__, pszDriverName));
   if (pszDeviceName)
      DBPRINTIF ((bShow, "%s(): pszDeviceName = %s\n", __FUNCTION__, pszDeviceName));
   if (pszPrinterName)
      DBPRINTIF ((bShow, "%s(): pszPrinterName = %s\n", __FUNCTION__, pszPrinterName));
#endif

   /*-----------------------------------------------------*/
   /* Error Condition 1:                                  */
   /*-----------------------------------------------------*/
   /* Caller requested "Printer Properties" but did not   */
   /* pass in a pszPrinterName.  This is an exception     */
   /* we will try to recover from.                        */
   /*-----------------------------------------------------*/
   if (!pszPrinterName)
   {
      // If we don't have a printer name, yet user requested
      // Printer Properties, we have a problem...
      if (ulOption == DPDM_CHANGEPROP)
      {
         // invalid combination
         pmerr = PMERR_INV_DRIVER_NAME;
         RAISEEXCEPTION (XCPT_USER);
      }
   }

   /*-----------------------------------------------------*/
   /* Error Condition 2:                                  */
   /*-----------------------------------------------------*/
   /* Caller did not pass in a DeviceName.  This could    */
   /* be serious, so report an exception.                 */
   /*-----------------------------------------------------*/
   if (!pszDeviceName)
   {
      // If user did not give us a device name we have a problem...
      pmerr = PMERR_INV_DEVICE_NAME;
      RAISEEXCEPTION (XCPT_USER);
   }
   else
   {
      /*----------------------------------------------------------------*/
      /* Create a heap                                                  */
      /*----------------------------------------------------------------*/
      hmcbHeap = GplMemoryCreateInstance (LEN_DCHEAP, 0, 0, PROCESS_MEMORY);
      assertF (hmcbHeap);
   }

   /*----------------------------------------------------------------*/
   /* Create Instance Data                                           */
   /*----------------------------------------------------------------*/
   pdi = (PDLGINSTANCE)GplMemoryAlloc (hmcbHeap, sizeof (DLGINSTANCE));
   assertF (pdi);

   // Save process heap handle for later allocations
   pdi->hmcbHeap = hmcbHeap;

   // Initialize StateData
   pdi->StateData.fFoundLogAddress = TRUE;

   /*----------------------------------------------------------------*/
   /* Get Information for Device Name passed in                      */
   /*----------------------------------------------------------------*/
   bRC = FindDeviceNameInDriver (pszDeviceName, &(pdi->pDriver), &(pdi->pDevice));

   // If failed to find driver that has this device raise an error
   if (!bRC)
   {
      pmerr = PMERR_INV_DEVICE_NAME;
      RAISEEXCEPTION (XCPT_USER);
   }
   else
   {
      // Describe 3.0 gives us a null pDrivedata->szDeviceName - mjones
      if (*(PCHAR)pDrivdata->szDeviceName == '\0')
         strcpy (pDrivdata->szDeviceName, pszDeviceName);
   }

   if (!pszPrinterName)
   {
      // NOTE: This is to fix a DESCRIBE bug.  It does not give us a
      //       printer name.  It only gives us a device name.
      // Try to find a spooler printer name from a device name
      pszPrinterName = PrinterNameFromDeviceName (hmcbHeap, pszDeviceName, &(pdi->pszLogAddr) );
      if (!pszPrinterName)
         goto depart;

      bFreePrinterName = TRUE;
   }

   /*----------------------------------------------------------------*/
   /* Create unique APPNAME for OS2SYS.INI Printer Properties        */
   /*----------------------------------------------------------------*/
   pszAppname = GplMemoryAlloc (hmcbHeap, LEN_APPNAME );
   assertF (pszAppname);

   // build the INI file Application name for accessing the INI file for this device
   bRC = BuildAppName (pszAppname, LEN_APPNAME, pszPrinterName, pszDriverName, pszDeviceName);
   assertF (bRC);


 // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   OMNILoadDLL (pszDeviceName, &(pdi->pdevice), &(pdi->pDriver), &pDLLuseage);
#endif

   // Initialize our instance data including NLS country info
   InitDlgInstanceData (pdi, pszAppname, pszDriverName, pszDeviceName, pszPrinterName);

// begin @EXJOB
   pdi->ulJobProperties = ulPropertySize;
   pdi->pJobProperties  = (PJOBPROPERTIES)GplMemoryAlloc (hmcbHeap, ulPropertySize);
   pdi->pJobProperties2 = (PJOBPROPERTIES)GplMemoryAlloc (hmcbHeap, ulPropertySize);
   pdi->pDrivData       = pDrivdata;
   memset (pdi->pJobProperties,  0, ulPropertySize);
   memset (pdi->pJobProperties2, 0, ulPropertySize);
// end @EXJOB
// begin @JPN2H99
   // Read in printer properties from INI file
   bRC = ReadPrinterProperties (pdi->szAppName, &pdi->PrnProperties, pdi->pDevice);
   assertF (bRC);
// end @JPN2H99

   // Create a safe copy of DrivData (i.e. correct memory size, read/write, etc.)
   pDrivData = ReturnDriverData ((PDEVICEBLOCK)NULL,
                                 pdi,
                                 hmcbHeap,
                                 pDrivdata,
                                 pszPrinterName,
                                 TRUE,
                                 pdi->pDevice,
                                 pdi->pDriver);
   assertF (pDrivData);

   // initialize User defined data pointers to NULLs etc.
   InitUserDefinedData (pdi->pDevice->pUserDefData);

   // read in user defined values from INI file to linked list
   // to reset to original state after cancel
   bRC = ReadUserDefinedTrayList (pdi->szAppName, pdi->pDevice);
   assertF (bRC);

   bRC = ReadUserDefinedFormList (pdi->szAppName, pdi->pDevice);
   assertF (bRC);

   bRC = ReadUserDefinedConnectList (pdi->szAppName, pdi->pDevice);
   assertF (bRC);

   bRC = ReadUserDefinedFontList (pdi->szAppName, pdi->pDevice);
   assertF (bRC);

   pdi->pRes = GetpResFromResID (pdi->pDriver,
                                 pdi->pDevice,
                                 (PJOBPROPERTIES)&pDrivData->abGeneralData);

   // If Caller wanted to Query job properties or post job properties
   if ((DPDM_POSTJOBPROP == ulOption) || (DPDM_QUERYJOBPROP == ulOption))
   {
      // Copy in DRIVDATA (job property info) that was passed in
// begin @EXJOB
      //pdi->JobProperties = *(PJOBPROPERTIES)(&pDrivData->abGeneralData);
      memcpy (pdi->pJobProperties,
              &pDrivData->abGeneralData,
              ulPropertySize);
      memcpy (pdi->pJobProperties2,
              &pDrivData->abGeneralData,
              ulPropertySize);
// end @EXJOB
   }
   else
   {
// begin @EXJOB
      ULONG cbRead;
      ULONG ulRead = ulPropertySize;
// end @EXJOB

      // else Caller wanted to display Printer Properties
      DBPRINTIF ((bShow, "%s(): DPDM_CHANGEPROP : Read DRIVDATA from OS2SYS.INI\n", __FUNCTION__));

      // retrieve DRIVDATA from os2sys.ini for this printer
// begin @EXJOB
      //bRC = ReadDefaultJobProperties (pszAppname, (PVOID)&pdi->JobProperties);
      bRC = ReadDefaultJobProperties (pszAppname,
                                      (PVOID)pdi->pJobProperties,
                                      &ulRead);

      cbRead = pdi->pJobProperties->cb;

      if (cbRead != ulPropertySize)
      {
         // different version data found !!
         PBYTE pJobTemp = (PBYTE)GplMemoryAlloc (pdi->hmcbHeap, cbRead);
         if (pJobTemp)
         {
            ulRead = cbRead;
            bRC = ReadDefaultJobProperties (pszAppname, (PVOID)pJobTemp, &ulRead);
            if (TRUE == bRC)
            {
               SafeCopyJobData (pdi->pDevice,
                                (PBYTE)pJobTemp,
                                ulPropertySize,
                                (PBYTE)pdi->pJobProperties);

            }
            GplMemoryFree (pJobTemp);
         }
      }

      memcpy (pdi->pJobProperties2, pdi->pJobProperties, ulPropertySize);
// end @EXJOB
   }

   // Validate DRIVDATA we have at this point as best we can
   // @EXJOB
   // @JPN2H99 if (!ValidateDriverData (pdi->pJobProperties, pdi->pDriver, pdi->pDevice))
   // @JPN2H99 Fix DJP printing problems.
   if (!ValidateDriverData (pdi->pJobProperties, &pdi->PrnProperties, pdi->pDriver, pdi->pDevice))
   {
      DBPRINTIF ((bShow, "%s(): ValidateDriverData failed! Set defaults\n", __FUNCTION__));

      // Validation failed use defaults for this device
      bRC = SetDriverDataDefaults (pdi->pDevice,
                                   pdi->pJobProperties,    // @EXJOB
                                   pszDeviceName,
                                   pdi->ctryInfo.country); // @100713 - added sCountryCode
      assertF (bRC);

// begin @EXJOB
      memcpy (pdi->pJobProperties2, pdi->pJobProperties, ulPropertySize);
// end @EXJOB
   }

   // look at options
   switch (ulOption)
   {
   /*-------------------------------------*/
   /* DISPLAY JOB PROPERTIES              */
   /*-------------------------------------*/
   case DPDM_POSTJOBPROP:
   /*-------------------------------------*/
   /* DISPLAY PRINTER PROPERTIES          */
   /*-------------------------------------*/
   case DPDM_CHANGEPROP:
   {
      // prepare to display a dialog box

#ifdef DEBUG
      // @EXJOB
      DebugOutputJobProperties (bShow, "Final DRIVDATA into dialog", pdi->pJobProperties);
#endif

      if (pdi->pszLogAddr == NULL)
      {
         bRC = FindLogAddress (pdi->hmcbHeap,
                               pdi->pszPrinterName,
                               &pdi->pszLogAddr);
      }

      /*-----------------------------------------------------*/
      /* *NOTE* - at this point Properties has valid DRIVDATA */
      /*-----------------------------------------------------*/
      switch (ulOption)
      {
      case DPDM_POSTJOBPROP:
      {
         pdi->hwndJobProp = WinLoadDlg (HWND_DESKTOP,
                                        WinQueryActiveWindow(HWND_DESKTOP),
                                        (PFNWP)JobPropertiesDlgProc,
                                        globals.hModule,
                                        IDD_JOB_PROPERTIES,
                                        (PVOID)pdi);

         DBPRINTIF ((bShow, "%s(): hwndJobProp = '%x'\n", __FUNCTION__, pdi->hwndJobProp));

         CreateHelpInstance (pdi, FALSE);

         rc = WinProcessDlg (pdi->hwndJobProp);
         DBPRINTIF ((bShow, "%s(): WinProcessDlg( hwndJobProp = %x ); rc= %d\n", __FUNCTION__, pdi->hwndJobProp, rc));

         // We must call WinDestroyWindow() ourselves for WinProcessDlg()
         // does not send it on exit as WinDlgBox() does
         DBPRINTIF ((bShow, "%s(): WinDestroyWindow( hwndJobProp = %x )\n", __FUNCTION__, pdi->hwndJobProp));
         WinDestroyWindow (pdi->hwndJobProp);

         // If user asked to save the new job props out
         if (rc == DID_OK)
         {
// begin @EXJOB
            SafeCopyJobData (pdi->pDevice,
                             (PBYTE)pdi->pJobProperties,
                             ulPropertySize,
                             (PBYTE)&pDrivdata->abGeneralData);

            pDrivdata->cb       = DRIVDATA_HEADER + ulPropertySize;
            pDrivdata->lVersion = DRIVERDATA_VERSION_CURRENT;
//          // Overwrite their data with our good, known data ;)
//          pDrivdata->cb       = DRIVERDATA_SIZE;
//          pDrivdata->lVersion = DRIVERDATA_VERSION;
// end @EXJOB

            if (pszDeviceName)
               strcpy (pDrivdata->szDeviceName, pszDeviceName);

            // Copy the job properties
// @EXJOB   *(PJOBPROPERTIES)(&pDrivdata->abGeneralData) = pdi->JobProperties;

#ifdef DEBUG
            // @EXJOB
            DebugOutputJobProperties (bShow, "DRIVDATA returned from DPDM_POSTJOBPROP", pdi->pJobProperties);
#endif
         }
         break;
      }

      case DPDM_CHANGEPROP:
      {
         pdi->hwndPrnProp =  WinLoadDlg (HWND_DESKTOP,
                                         WinQueryActiveWindow(HWND_DESKTOP),
                                         (PFNWP)PrinterPropertiesDlgProc,
                                         globals.hModule,
                                         IDD_PRINTER_PROPERTIES,
                                         (PVOID)pdi);

         DBPRINTIF ((bShow, "%s(): hwndPrnProp = '%x'\n", __FUNCTION__, pdi->hwndPrnProp));

         CreateHelpInstance (pdi, TRUE);

         rc = WinProcessDlg (pdi->hwndPrnProp);
         DBPRINTIF ((bShow, "%s(): WinProcessDlg( hwndPrnProp = %x ); rc= %d\n", __FUNCTION__, pdi->hwndPrnProp, rc));

         // We must call WinDestroyWindow() ourselves for WinProcessDlg()
         // does not send it on exit as WinDlgBox() does
         DBPRINTIF ((bShow, "%s(): WinDestroyWindow( hwndPrnProp = %x )\n", __FUNCTION__, pdi->hwndPrnProp));
         WinDestroyWindow (pdi->hwndPrnProp);

         // If user asked to save the new printer props out
         if (rc == DID_OK)
         {
// begin @EXJOB
            SafeCopyJobData (pdi->pDevice,
                             (PBYTE)pdi->pJobProperties,
                             ulPropertySize,
                             (PBYTE)&pDrivdata->abGeneralData);

            pDrivdata->cb       = DRIVDATA_HEADER + ulPropertySize;
            pDrivdata->lVersion = DRIVERDATA_VERSION_CURRENT;
//          // Overwrite their data with our good, known data ;)
//          pDrivdata->cb       = DRIVERDATA_SIZE;
//          pDrivdata->lVersion = DRIVERDATA_VERSION;
// end @EXJOB

            if (pszDeviceName)
               strcpy (pDrivdata->szDeviceName, pszDeviceName);

            // Copy the job properties
// @EXJOB   *(PJOBPROPERTIES)(&pDrivdata->abGeneralData) = pdi->JobProperties;

#ifdef DEBUG
            // @EXJOB
            DebugOutputJobProperties (bShow, "DRIVDATA returned from DPDM_CHANGEJOBPROP", pdi->pJobProperties);
#endif
         }
         break;
      }

      default:
      {
         assertstring ("Unknown ulOption!\n");
         break;
      }
      }

      assertF (rc != DID_ERROR);
      break;
   }

   /*-----------------------------*/
   /* QUERY JOB PROPERTIES        */
   /*-----------------------------*/
   case DPDM_QUERYJOBPROP:
   {
      // wants job properties from INI; if none there, return some defaults

      // if memcpy causes trap, set this error
      pmerr = PMERR_INV_DRIVER_DATA;

      // copy results back to user
// begin @EXJOB
      memcpy (pDrivdata, pDrivData, ulDrivDataSize);
//    memcpy (pDrivdata, pDrivData, DRIVERDATA_SIZE);
// end @EXJOB
      break;
   }

   /*-----------------------------*/
   /* UNKNOWN OPTION              */
   /*-----------------------------*/
   default:
   {
      // blow up debug version
      assertstring ("Unknown ulOption!\n");
      break;
   }
   }

   /*-----------------------------*/
   /* Free Memory                 */
   /*-----------------------------*/
   if (pdi)
   {
      if (pdi->pszLogAddr)
      {
         rc = GplMemoryFree (pdi->pszLogAddr);
         assertT (rc);
      }

// begin @EXJOB
      if (pdi->pJobProperties)
      {
         rc = GplMemoryFree (pdi->pJobProperties);
         assertT (rc);
      }

      if (pdi->pJobProperties2)
      {
         rc = GplMemoryFree (pdi->pJobProperties2);
         assertT (rc);
      }
// end @EXJOB

      // Free dialog instance data
      rc = GplMemoryFree (pdi);
      assertT (rc);
      pdi = NULL;
   }

   if (pDrivData)
   {
      // Free DRIVDATA
      rc = GplMemoryFree (pDrivData);
      assertT (rc);
      pDrivData = NULL;
   }

   // if we allocated memory to hold application name so free it now
   if (pszAppname)
   {
      rc = GplMemoryFree (pszAppname);
      assertT (rc);
      pszAppname = NULL;
   }

   lrc = DEV_OK;

 // DLLBLD is defined to build the dll version omni.drv
#ifdef DLLBLD
   OMNIFreeDLL (pDLLuseage);
#endif

depart:
   if (bFreePrinterName)
   {
      rc = GplMemoryFree (pszPrinterName);
      assertT (rc);
   }

   // Free the heap
   if (hmcbHeap)
   {
      rc = GplMemoryDeleteInstance (hmcbHeap);
      assertT (rc);
   }

   UNREGISTERHANDLER (regrec);

   DBPRINTIF ((bShow, "%s(): Exit; lrc=%d\n", __FUNCTION__, lrc));

   return lrc;

} /* end OS2_PM_DRV_DEVMODE */

// --------------------------------------------------------------------------------------------------------------------
// driver is about to be installed or reinstalled
// at this time, migrate old settings in the INI to current driver standards
//
VOID APIENTRY
DrvInstall (VOID)
{
   BOOL               bRC;
   ULONG              ulWork;
   PCHAR              pchAppNames              = NULL;
   PCHAR              pchKeyNames              = NULL;
   PCHAR              pch2;
   PCHAR              pch;
   REGREC             regrec;
   ULONG              ulException;
   CHAR               szModule[16];
   APIRET             rc;

// for defect #214175 DrvInstall() reset printers' settings.
   PDEVICEINFO        pTemp_Device             = (PDEVICEINFO)NULL;
   PSZ                pszDev_Name;
   BOOL               abResult[4];
   INT                i;
   BOOL               bFound = 0;
   PCHAR              apszUserDefinedData[]    = { "Tray",
                                                   "Form",
                                                   "Connect",
                                                   "Font",
                                                   0 };
   PCHAR              *ppszLookUserDefinedData = apszUserDefinedData;

   assertF (globals.pvSharedHeap);

   REGISTERHANDLER (regrec, globals.hModule);
   ulException = setjmp (regrec.jmp);
   if (ulException)
   {
      // clean up here
      if (pchAppNames)
      {
         rc = GplMemoryFree (pchAppNames);
         assertT (rc);
         pchAppNames = NULL;
      }
      if (pchKeyNames)
      {
         rc = GplMemoryFree (pchKeyNames);
         assertT (rc);
         pchKeyNames = NULL;
      }
      // check for the killed-thread case
      switch (ulException)
      {
      case XCPT_PROCESS_TERMINATE:
      case XCPT_ASYNC_PROCESS_TERMINATE:
         DosUnsetExceptionHandler ((PEXCEPTIONREGISTRATIONRECORD)&regrec);
         DosExit (EXIT_THREAD, 0);
      }
      goto depart;
   }

   // Remove the debugging info structure from the system ini file.
   bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE,
                              APPNAME_DEBUGINFO,
                              KEYNAME_DEBUGINFO,
                              NULL,
                              0);

   // get the 8-character module name from the fully-qualified module name in globals
   pch2 = strrchr (globals.szModule, '.');
   assertF (pch2);
   *pch2 = 0;

   pch = strrchr (globals.szModule, '\\');
   assertF (pch);

   assertT (sizeof (szModule) <= strlen (pch+1));
   strcpy (szModule, pch+1);

   // restore globals back
   *pch2 = '.';

   // this pair of nested loops finds all OMNI application and key names in the INI
   // if any are found, this function should migrate the contents to this new version of the driver

   ulWork = 0;
   bRC = PrfQueryProfileSize (HINI_SYSTEMPROFILE, NULL, NULL, &ulWork);
   assertF (bRC);

   pchAppNames = (PCHAR)GplMemoryAlloc (0, ulWork);
   assertF (pchAppNames);

   PrfQueryProfileString (HINI_SYSTEMPROFILE, NULL, NULL, NULL, pchAppNames, ulWork);

   pch = pchAppNames;

   while (*pch)
   {
      if (  strstr (pch, szModule)
         && 0 == strncmp (pch, "PM_DD_", 6)
         )
      {
         // this INI application name has my module name in it; enumerate all keys that go with it
         ulWork = 0;
         bRC = PrfQueryProfileSize (HINI_SYSTEMPROFILE, pch, NULL, &ulWork);
         assertF (bRC);

         pchKeyNames = (PCHAR)GplMemoryAlloc (0, ulWork);
         assertF (pchKeyNames);

         PrfQueryProfileString (HINI_SYSTEMPROFILE, pch, NULL, NULL, pchKeyNames, ulWork);

         // This processing was added for defect #214175 : when we create a new
         // print object and install new omni device, all User Defined Data
         // (Connect List, Form List etc.) is removed from the previous printer
         // object. So now, we read User Defined Data from os2sys.ini for each
         // installed device. If Data is read O.K. (abResult = True) we don't
         // do NULL records in os2sys.ini for corresponding keys (pchKeyNames)
         // (from apszUserDefinedData key list).
         // In future: Old Printer Properties migration 'must' be handled
         // in the ReadUserDefined functions...

         pszDev_Name = strrchr (pch, '.');
         assertF (pszDev_Name);
         pszDev_Name++;

         PDriverFromDeviceName (pszDev_Name, &pTemp_Device);
         assertF (pTemp_Device);

         abResult[0] = ReadUserDefinedTrayList (pch, pTemp_Device);
         assertF (abResult[0]);

         FreeUserDefinedTrayList (pTemp_Device);

         abResult[1] = ReadUserDefinedFormList (pch, pTemp_Device);
         assertF (abResult[1]);

         FreeUserDefinedFormList (pTemp_Device);

         abResult[2] = ReadUserDefinedConnectList (pch, pTemp_Device);
         assertF (abResult[2]);

         FreeConnectionList (pTemp_Device);

         abResult[3] = ReadUserDefinedFontList (pch, pTemp_Device);
         assertF (abResult[3]);

         FreeUserDefinedFontList (pTemp_Device);

         pch2 = pchKeyNames;
         while (*pch2)
         {
            // should migrate the printer properties, driver data here

            for ( i = 0; *ppszLookUserDefinedData; i++ )
            {
               if (strstr(pch2, *ppszLookUserDefinedData))
               {
                  if (!abResult[i])
                  {
                     // For now, delete this app/key combination and start fresh
                     // (UserDefined Data)
                     bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE, pch, pch2, NULL, 0);
                     assertF (bRC);
                  }

                  bFound = TRUE;
                  break;
               }

               ppszLookUserDefinedData++;
            }

            if (!bFound)
            {
               // For now, delete this app/key combination and start fresh
               // (not UserDefined Data)
               bRC = PrfWriteProfileData (HINI_SYSTEMPROFILE, pch, pch2, NULL, 0);
               assertF (bRC);
            }

            bFound = FALSE;
            ppszLookUserDefinedData = apszUserDefinedData;

            // on to next key
            pch2 += (1 + strlen (pch2));
         }

         // return memory to the heap
         rc = GplMemoryFree (pchKeyNames);
         assertT (rc);
         pchKeyNames = NULL;
      }

      // on to next app name
      pch += (1 + strlen (pch));
   }


   // return memory to the heap
   rc = GplMemoryFree (pchAppNames);
   assertT (rc);
   pchAppNames = NULL;

depart:

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
   rc++;
#endif

   UNREGISTERHANDLER (regrec);

} /* end DrvInstall */

/****************************************************************************/
/* PROCEDURE NAME : InitUserDefinedData                                     */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11-18-93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitUserDefinedData (PUSERDEFDATA pUserData)
{
   /*------------------------------------------------------------------------*/
   /* LOCAL VARIABLES                                                        */
   /*------------------------------------------------------------------------*/
   BOOL bSuccess = TRUE;

   /*------------------------------------------------------------------------*/
   /* BEGIN CODE                                                             */
   /*------------------------------------------------------------------------*/
   DBPRINTIF ((TRUE, "InitUserDefinedData(): Enter\n"));

   assertF (pUserData);

   // initialize User defined data
   pUserData->bTraysInit        = FALSE;
   pUserData->usNumTrays        = 0;
   pUserData->pUserTRAYS        = NULL;
   pUserData->pLastUserTRAYS    = NULL;

   pUserData->bFormsInit        = FALSE;
   pUserData->usNumForms        = 0;
   pUserData->pUserFORMS        = NULL;
   pUserData->pLastUserFORMS    = NULL;

   pUserData->bConnsInit        = FALSE;
   pUserData->usNumConnects     = 0;
   pUserData->pUserCONNECTS     = NULL;
   pUserData->pLastUserCONNECTS = NULL;

   pUserData->bFontsInit        = FALSE;
   pUserData->usNumFonts        = 0;
   pUserData->pUserFONTS        = NULL;
   pUserData->pLastUserFONTS    = NULL;

   DBPRINTIF ((TRUE, "InitUserDefinedData(): Exit\n"));

   return bSuccess;

} /* end InitUserDefinedData */

/****************************************************************************/
/* PROCEDURE NAME : InitDlgInstanceData                                     */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 10-28-93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitDlgInstanceData (PDLGINSTANCE pdi,
                     PSZ          pszAppname,
                     PSZ          pszDriverName,
                     PSZ          pszDeviceName,
                     PSZ          pszPrinterName)
{
   BOOL bSuccess = TRUE;
   BOOL bRC      = FALSE;

   DBPRINTIF ((TRUE, "InitDlgInstanceData(): Enter\n"));

   /*-----------------------------*/
   /* Driver Name                 */
   /*-----------------------------*/
   pdi->pszDriverName = pszDriverName;

   /*-----------------------------*/
   /* Device Name                 */
   /*-----------------------------*/
   pdi->pszDeviceName = pszDeviceName;

   /*-----------------------------*/
   /* Printer Name                */
   /*-----------------------------*/
   pdi->pszPrinterName = pszPrinterName;

   /*-----------------------------*/
   /* Application Name            */
   /*-----------------------------*/
   strcpy (pdi->szAppName, pszAppname);

   /*-----------------------------*/
   /* Drivdata Scratch            */
   /*-----------------------------*/
   /* filled in outside this func */
   /*-----------------------------*/

   /*-----------------------------*/
   /* Country Information         */
   /*-----------------------------*/
   GetCountryInfo (&pdi->ctryCode, &pdi->ctryInfo);

   // @100713 - begin A4 default
   if (  pdi->ctryInfo.country == COUNTRYCODE_USA
      || pdi->ctryInfo.country == COUNTRYCODE_CANADA
      )
   {
      pdi->bUseInches = TRUE;
   }
   else
   {
      pdi->bUseInches = FALSE;
   }

#ifdef DEBUG
   /*-----------------------------*/
   /* Debug Info                  */
   /*-----------------------------*/
   bRC = InitDebugInfo (&(pdi->DebugInfo), FALSE, TRUE);
   assertF (bRC);
#endif

   DBPRINTIF ((TRUE, "InitDlgInstanceData(): Exit\n"));

#ifndef DEBUG
   bRC++;          // Avoid compiler warnings
#endif

   return bSuccess;

} /* end InitDlgInstanceData */

/****************************************************************************/
/* PROCEDURE NAME : MetafileBitBlt                                          */
/* AUTHOR         : Mark Hamzy                                              */
/* DATE WRITTEN   : 04-27-98                                                */
/* DESCRIPTION    : This is hooked out for the raster graphics engine.  Its */
/*                  purpose is to discard any drawing that is sent to it    */
/*                  (which should not occur anyways because COM_DRAW is     */
/*                  turned off) and return OK.                              */
/*                  This was created for defect 195199.                     */
/*                                                                          */
/* PARAMETERS:      PBITBLTINFO pBBI - bit blt information structure        */
/*                  ULONG     ulPDDC - our device drawing context structure */
/*                                                                          */
/* RETURN VALUES:   0                - OK                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG
MetafileBitBlt (PBITBLTINFO pBBI, ULONG ulReserved)
{
#ifdef DEBUG
   DBPRINTF (("%s: should not be hit.  Create a defect!\n", __FUNCTION__));
#endif

   return 0;
}

/****************************************************************************/
/* PROCEDURE NAME : MetafileLine                                            */
/* AUTHOR         : Mark Hamzy                                              */
/* DATE WRITTEN   : 04-27-98                                                */
/* DESCRIPTION    : This is hooked out for the raster graphics engine.  Its */
/*                  purpose is to discard any drawing that is sent to it    */
/*                  (which should not occur anyways because COM_DRAW is     */
/*                  turned off) and return OK.                              */
/*                  This was created for defect 195199.                     */
/*                                                                          */
/* PARAMETERS:      PLINEINFO pLI    - line information structure           */
/*                  ULONG     ulPDDC - our device drawing context structure */
/*                                                                          */
/* RETURN VALUES:   0                - OK                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG
MetafileLine (PLINEINFO pLI, ULONG ulPDDC)
{
#ifdef DEBUG
   DBPRINTF (("%s: should not be hit.  Create a defect!\n", __FUNCTION__));
#endif

   return 0;
}
