/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#ifdef DLLBLD

#define INCL_DOS
#define INCL_DEV
#define INCL_PM
#define INCL_SPL
#define INCL_SPLFSE
#define INCL_ERRORS
#define INCL_DOSFILEMGR
#include <os2.h>

#define INCL_VMANDDI
#include <ddi.h>

#define INCL_GRE_COLORTABLE
#define INCL_GRE_BITMAPS
#define INCL_GRE_DEVMISC3
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdarg.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

// only one copy of these data items in a running system
#pragma data_seg(global)

#endif

#define INCL_GENPLIB_THREAD_WRITE
#define INCL_GENPLIB_COMPRESS
//#define INCL_GENPLIB_DBCS
//#define INCL_GENPLIB_STRINGSORT
#define INCL_GENPLIB_FAX
#define INCL_GENPLIB_LAYOUT  
#include <genplib.h>

//****************************************************************************
//*
//*               F E A T U R E    I D   #'s
//*
//****************************************************************************
//*
//*  The following IDs are used to reference specific features
//*  such as:
//*
//*         PRINT MODEL   (e.g. each printer model gets a unique ID)
//*         PRINT QUALITY (e.g. each resolution referenced gets a unique ID)
//*         PRINT MODE    ("")
//*         DEVICE FONT   ("")
//*         PAPER TRAY
//*         FORM SIZE
//*         MEDIA TYPE
//*         FORM CONNECTION
//*
//* !!!!!!!!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//*
//* NOTE: These IDs can NEVER be changed once added and shipped in an
//*       OS/2 product or cross-network printing could fail.
//*
//* !!!!!!!!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//*
//****************************************************************************
#define TIFF_TMP_LEN                   14
#define TIFF_PREFIX                    "TIFF"
#define TIFF_SUFFIX                    ".TMP"

//****************************************************************************
//* PRINT MODEL IDs
//****************************************************************************
//* Assign a new unique internal model ID for every new printer added
//****************************************************************************
#define PRN_ID_TIFF_MONOCHROME         4000
#undef  SAM_DETWEILER
//#define SAM_DETWEILER 1
#ifdef SAM_DETWEILER
#define PRN_ID_TIFF_SAM_D              4001
#endif

//****************************************************************************
//* PRINT QUALITY IDs
//****************************************************************************
//* Assign a new unique internal Print Quality ID for each printer model
//* that comes out with a new resolution/print quality
//****************************************************************************
#define TIFF_RES_ID_FINE               0
#define TIFF_RES_ID_NORMAL             1

//****************************************************************************
//*  PRINT MODES IDs
//****************************************************************************
//* Assign a new unique internal Print Mode ID for each
//* bitmap format supported by output device and rendering s/w
//****************************************************************************
#define TIFF_RES_ID_GROUP_4            0
#define TIFF_RES_ID_GROUP_3            1
#define TIFF_RES_ID_CCITT_1D           2

//****************************************************************************
//* FONTS IDs
//****************************************************************************
#define FONT_ID_COURIER                0

//****************************************************************************
//* TRAYS IDs
//****************************************************************************
#define TIFF_TRAY_ID_NOSELECT          0

//****************************************************************************
//* FORMS IDs
//****************************************************************************
#define TIFF_FORM_ID_LETTER_1          0
#define TIFF_FORM_ID_LEGAL_1           1
#define TIFF_FORM_ID_A4_1              2

//****************************************************************************
//* MEDIA TYPE IDs
//****************************************************************************
#define TIFF_MEDIA_ID_PLAIN            0

//****************************************************************************
//* FORM CONNECTION IDs
//****************************************************************************
#define CONN_ID_1                      0
#define CONN_ID_2                      1
#define CONN_ID_3                      2


/********************************************************************
 *
 *                G P L T I F F    B E G I N
 *
 ********************************************************************/
#define TIFF_SIG                       0x74696666      // 'TIFF'
#define TIFF_BUFFER_SIZE               4096    // 4K Buffer Size for TIFF Algorithm 2

#define TIFF_TAG_COUNT                 18   // Count of Tags output in TiffNewframe(), TiffEndJob()
#define IFD_PAGEOFFSET                 (10 + (TIFF_TAG_COUNT - 1) * 12)
#define IFD_NEXTIFD                    (2 + TIFF_TAG_COUNT * 12)

typedef struct _TIFFINFO {
   HFILE     hFile;                  //
   PSZ       pszfileName;            //
   ULONG     ulOffsetPreviousIFD;    //
   ULONG     ulStripeBytesWritten;   //
   ULONG     ulOffsetStartOfStripe;  //
   ULONG     ulPageCount;            //
} TIFFINFO, * PTIFFINFO;

typedef struct _TIFFHandle {
   ULONG         cb;                 // sizeof the structure
   ULONG         ulSig;              // structure signature

   USHORT        usDeviceID;         //

   HMCB          hmcbHeap;           // Heap handle

   TIFFINFO      TIFFInfo;           //
   INT           iSrcRowPels;        //
   INT           iNumDestRowBytes;   //
   INT           iNumSrcRowBytes32;  //
   ULONG         ulResolution;       //
   INT           iSrcRow;            //

   PBYTE         pbOutput;           // buffer for TIFF algorithms
   ULONG         ulOutputSize;       // size of buffer for TIFF algorithms
   ULONG         ulBitposition;      // bit position count within pbOutput
   PULONG        pulwstartc;         // used by GROUP 4
   PULONG        pulbstartc;         // used by GROUP 4
   PULONG        pulwstartp;         // used by GROUP 4
   PULONG        pulbstartp;         // used by GROUP 4
   ULONG         allocsize;          // size of pulwstartc thru pulbstartp together

   // For Spool Raw jobs we subclass all "Spl" calls and need to save some things
   PDEVOPENSTRUC pdopData;           // Data used for SplQmOpen()
   PSZ           pszDocumentName;    // Document Name used for SplQmStartDoc();
   HSPL          hspl;               // the spooler file handle we'll create
   ULONG         ulSize;             // Length of Spooler directory name
   PSZ           pszSpoolDir;        // Directory where spool files should be placed

   BOOL          fLeaveAlone;        // Passthrough us... do not disturb

   BOOL          fTempFile;          //
   PSZ           pszLogAddress;      //
   HFILE         fFileTemp;          //
} TIFFHANDLE, *PTIFFHANDLE;

DEVICEOPEN   TIFFOpenFile;
DEVICECLOSE  TIFFCloseFile;
DEVICEWRITE  TIFFWriteFile;

SPOOLEROPEN  TIFFSpoolerOpen;
SPOOLERCLOSE TIFFSpoolerClose;
SPOOLERSTART TIFFSpoolerStartJob;
SPOOLEREND   TIFFSpoolerEndJob;

BOOL _System  GplTIFFRasterizeOutput (PBYTE             pbBits,
                                      PBITMAPINFO2      pbmi,
                                      PSIZEL            psizelBuffer,
                                      PSIZEL            psizelPage,
                                      PRECTL            prectlPageLocation,
                                      PVOID             pvHandle,
                                      PVOID             pvDDC);
BOOL GplTIFFputword                  (PTIFFINFO         pTIFFInfo,
                                      int               n);
BOOL GplTIFFputlong                  (PTIFFINFO         pTIFFInfo,
                                      ULONG             n);
BOOL GplTIFFLinkPreviousIFD          (PDDC              pddc,
                                      PTIFFHANDLE       pHandle,
                                      PVOID             pBuf);
BOOL GplTIFFUpdatePageCount          (PDDC              pddc,
                                      PTIFFHANDLE       pHandle);
BOOL GplTIFFWriteFile                (PTIFFINFO         pTIFFInfo,
                                      ULONG             ulOffset,
                                      ULONG             ulLen,
                                      PVOID             pBuf);
BOOL GplTIFFReadFile                 (PTIFFINFO         pTIFFInfo,
                                      ULONG             ulOffset,
                                      ULONG             ulLen,
                                      PVOID             pBuf);

/* TIFF object sizes */
#define TIFFbyte                       1
#define TIFFascii                      2
#define TIFFshort                      3
#define TIFFlong                       4
#define TIFFrational                   5

/* TIFF tag names */
#define NewSubFile                     254
#define SubfileType                    255
#define ImageWidth                     256
#define ImageLength                    257
#define RowsPerStrip                   278
#define StripOffsets                   273
#define StripByteCounts                279
#define SamplesPerPixel                277
#define BitsPerSample                  258
#define Compression                    259
#define PlanarConfiguration            284
#define Group3Options                  292
#define Group4Options                  293
#define FillOrder                      266
#define Threshholding                  263
#define CellWidth                      264
#define CellLength                     265
#define MinSampleValue                 280
#define MaxSampleValue                 281
#define PhotometricInterp              262
#define GrayResponseUnit               290
#define GrayResponseCurve              291
#define ColorResponseUnit              300
#define ColorResponseCurves            301
#define XResolution                    282
#define YResolution                    283
#define ResolutionUnit                 296
#define Orientation                    274
#define DocumentName                   269
#define PageName                       285
#define XPosition                      286
#define YPosition                      287
#define PageNumber                     297
#define ImageDescription               270
#define Make                           271
#define Model                          272
#define FreeOffsets                    288
#define FreeByteCounts                 289
#define ColorMap                       320
#define Artist                         315
#define DateTime                       306
#define HostComputer                   316
#define ImageDescription               270
#define Software                       305

// for the DEBUGWINMESSAGEBOX((pszFormat, ... )) macro
VOID _Optlink DebugWinMessageBox (PSZ pszTitle, PSZ pszFormat, ...);
#ifdef DEBUG
#define DEBUGWINMESSAGEBOX(str) DebugWinMessageBox str
#else
#define DEBUGWINMESSAGEBOX(str)
#endif

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
DebugWinMessageBox (PSZ pszTitle, PSZ pszFormat, ...)
{
#ifdef DEBUG
   CHAR    achMessage[1024];
   va_list list;

   va_start (list, pszFormat);

   vsprintf (achMessage, pszFormat, list);

   va_end (list);

   WinMessageBox (HWND_DESKTOP,
                  HWND_DESKTOP,
                  achMessage,
                  pszTitle,
                  1L,
                  MB_OK | MB_INFORMATION);
#endif
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
TIFFIsACOMPort (PSZ pszDeviceName)
{
   USHORT  usLen;

   if (!pszDeviceName || !*pszDeviceName)
      return FALSE;

   usLen = strlen (pszDeviceName);

   if (  3 >= usLen
      || ('c' != pszDeviceName[0] && 'C' != pszDeviceName[0])
      || ('o' != pszDeviceName[1] && 'O' != pszDeviceName[1])
      || ('m' != pszDeviceName[2] && 'M' != pszDeviceName[2])  )
      return FALSE;

   // The rest have to be only numbers
   pszDeviceName += 3;

   while (*pszDeviceName)
   {
      if ('0' > *pszDeviceName || *pszDeviceName > '9')
         return FALSE;

      pszDeviceName++;
   }

   return TRUE;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
TIFFIsALPTPort (PSZ pszDeviceName)
{
   USHORT  usLen;

   if (!pszDeviceName || !*pszDeviceName)
      return FALSE;

   usLen = strlen (pszDeviceName);

   if (  3 >= usLen
      || ('l' != pszDeviceName[0] && 'L' != pszDeviceName[0])
      || ('p' != pszDeviceName[1] && 'P' != pszDeviceName[1])
      || ('t' != pszDeviceName[2] && 'T' != pszDeviceName[2])  )
      return FALSE;

   // The rest have to be only numbers
   pszDeviceName += 3;

   while (*pszDeviceName)
   {
      if ('0' > *pszDeviceName || *pszDeviceName > '9')
         return FALSE;

      pszDeviceName++;
   }

   return TRUE;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
APIRET
TIFFPreOpenFile (PVOID  pvDDC,
                 PVOID  pvHandle,
                 PVOID  pvLogAddress,
                 PVOID  pvHFile,
                 PVOID  pvAction,
                 ULONG  cbFile,
                 ULONG  ulAttrs,
                 ULONG  ulAction,
                 ULONG  ulAccess,
                 PVOID  pvEAInfo)
{
   PDDC              pddc          = (PDDC)pvDDC;
   PSZ               pszLogAddress = (PSZ)pvLogAddress;
   PTIFFHANDLE       pHandle       = (PTIFFHANDLE)pvHandle;
   HMCB              hmcb          = pHandle->hmcbHeap;

   DEBUG_FUNCTION_ENTER;

   DBPRINTF (("Opening '%s'\n", pszLogAddress));

   if (  TIFFIsACOMPort (pszLogAddress)
      || TIFFIsALPTPort (pszLogAddress) )
   {
      ULONG  ulWork    = 0;
      ULONG  ulFileNum = 0;
      APIRET rc        = ERROR_FILE_EXISTS;
      PSZ    psz;

      pHandle->fTempFile = TRUE;

      pHandle->pszLogAddress = (PSZ)GplMemoryAlloc (hmcb, strlen (pszLogAddress) + 1);
      assertF (pHandle->pszLogAddress);
      if (pHandle->pszLogAddress)
      {
         strcpy (pHandle->pszLogAddress, pszLogAddress);
      }

      psz = (PSZ)GplMemoryAlloc (hmcb, pHandle->ulSize + TIFF_TMP_LEN);
      assertF (psz);

      while (psz && rc == ERROR_FILE_EXISTS && ulFileNum < 299)
      {
         sprintf (psz,
                  "%s\\%s%d%s",
                  pHandle->pszSpoolDir,
                  TIFF_PREFIX,
                  ulFileNum,
                  TIFF_SUFFIX);

         // Call our own routine to open a TIFF file with read/write access
         rc = TIFFOpenFile (pddc,
                            pHandle,
                            psz,
                            (PVOID)&pHandle->TIFFInfo.hFile,
                            &ulWork,
                            0L,
                            0L,
                            0L,
                            0L,
                            NULL);

         ulFileNum++;
      }

      if (psz)
      {
         rc = GplMemoryFree (psz);
         assertT (rc);
      }

      if (NO_ERROR == rc)
      {
         // Success!
         pHandle->TIFFInfo.ulStripeBytesWritten = 0;
         pHandle->TIFFInfo.ulPageCount          = 0;

         DBPRINTF (("Trying to PrtOpen '%s'\n", pHandle->pszLogAddress));

         rc = PrtOpen (pHandle->pszLogAddress,
                       pvHFile,
                       &ulAction,
                       0,
                       FILE_NORMAL,
                       OPEN_ACTION_REPLACE_IF_EXISTS
                       | OPEN_ACTION_CREATE_IF_NEW,
                       OPEN_ACCESS_READWRITE
                       | OPEN_SHARE_DENYNONE,
                       0);
         assertT (rc);
      }

      DEBUG_FUNCTION_EXIT;

      return rc;
   }
   else
   {
      DEBUG_FUNCTION_EXIT;

      return TIFFOpenFile (pvDDC,
                           pvHandle,
                           pvLogAddress,
                           pvHFile,
                           pvAction,
                           cbFile,
                           ulAttrs,
                           ulAction,
                           ulAccess,
                           pvEAInfo);
   }
}

/****************************************************************************/
/* PROCEDURE NAME : TIFFOpenFile                                            */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 1/17/96                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* Control Flow:                                                            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
APIRET
TIFFOpenFile (PVOID  pvDDC,
              PVOID  pvHandle,
              PVOID  pvLogAddress,
              PVOID  pvHFile,
              PVOID  pvAction,
              ULONG  cbFile,
              ULONG  ulAttrs,
              ULONG  ulAction,
              ULONG  ulAccess,
              PVOID  pvEAInfo)
{
   APIRET       bRC;
   PSZ          pszLogAddress = (PSZ)pvLogAddress;
   PTIFFHANDLE  pHandle       = (PTIFFHANDLE)pvHandle;
   PTIFFINFO    pTIFFInfo     = &(pHandle->TIFFInfo);
   HMCB         hmcb          = pHandle->hmcbHeap;

   DEBUG_FUNCTION_ENTER;

   pTIFFInfo->pszfileName = (PSZ)GplMemoryAlloc (hmcb, strlen (pszLogAddress) + 1);
   assertF (pTIFFInfo->pszfileName);
   if (!pTIFFInfo->pszfileName)
      return ERROR_NOT_ENOUGH_MEMORY;

   strcpy (pTIFFInfo->pszfileName, pszLogAddress);

   DBPRINTF (("Opening '%s'\n", pTIFFInfo->pszfileName));

   bRC = DosOpen (pTIFFInfo->pszfileName,
                  (PHFILE)pvHFile,
                  (PULONG)pvAction,
                  0L,
                  0L,
                  OPEN_ACTION_CREATE_IF_NEW
                  | OPEN_ACTION_REPLACE_IF_EXISTS,
                  OPEN_ACCESS_READWRITE
                  | OPEN_SHARE_DENYREADWRITE,
                  NULL);

   // If DosOpen return code was not NO_ERROR display error code
   if (bRC != NO_ERROR)
   {
      DEBUGWINMESSAGEBOX (("DosOpen Info",
                          "rc = %d Opening file '%s'",
                          bRC,
                          pTIFFInfo->pszfileName));

      return ERROR_FILE_EXISTS;     // return error
   }
   else
   {
      pTIFFInfo->hFile = *((PHFILE)pvHFile);
   }

   pTIFFInfo->ulStripeBytesWritten = 0;
   pTIFFInfo->ulPageCount = 0;

   DEBUG_FUNCTION_EXIT;

   return NO_ERROR;

} /* end TIFFOpenFile */

/****************************************************************************/
/* PROCEDURE NAME : TIFFWriteFile                                           */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 1/17/96                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* Control Flow:                                                            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
APIRET
TIFFWriteFile (PVOID  pvHandle,
               HFILE  hDevice,
               PVOID  pvData,
               ULONG  cData,
               PULONG pcWritten)
{
///PTIFFHANDLE pHandle = (PTIFFHANDLE)pvHandle;

   return TRUE;

} /* end TIFFWriteFile */

/****************************************************************************/
/* PROCEDURE NAME : TIFFCloseFile                                           */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 1/27/96                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* Control Flow:                                                            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
APIRET
TIFFCloseFile (PVOID  pvHandle,
               HFILE  hDevice)
{
   PTIFFHANDLE  pHandle   = (PTIFFHANDLE)pvHandle;
   PTIFFINFO    pTIFFInfo = &(pHandle->TIFFInfo);
   HMCB         hmcb      = pHandle->hmcbHeap;
   APIRET       rc;

   if (pHandle->fTempFile)
   {
      ULONG            ulAction;
      ULONG            ulBytesWritten;
      BOOL             bRC;

      rc = DosClose (pTIFFInfo->hFile);
      assertT (rc);

      DBPRINTF (("Opening '%s'\n", pTIFFInfo->pszfileName));

      /* Reopen our temporary file to so that we can copy the completed
      ** TIFF file to the spooler
      */
      rc = DosOpen (pTIFFInfo->pszfileName,
                    &(pTIFFInfo->hFile),
                    (PULONG)&ulAction,
                    0L,
                    0L,
                    OPEN_ACTION_OPEN_IF_EXISTS,
                    OPEN_ACCESS_READONLY
                    | OPEN_SHARE_DENYWRITE,
                    NULL);
      assertT (rc);

      if (rc == NO_ERROR)
      {
         FILEFINDBUF   fib;
         ULONG         ulfib      = sizeof (FILEFINDBUF);
         PBYTE         pBuf;
         // The SplQmWrite call fails if buffer size
         // is greater than 64k so limit our buffer as well
         ULONG         ulLen      = 63000;  // 64k buffer for now
         ULONG         ulOffset   = 0;

         // Allocate buffer for reading in data
         pBuf = (PBYTE)GplMemoryAlloc (hmcb, ulLen + 1);
         assertF (pBuf);

         if (pBuf)
         {
            // Find out how big TIFF file is
            rc = DosQFileInfo (pTIFFInfo->hFile,
                               (USHORT)1,
                               (PBYTE)&fib,
                               ulfib);

            // Read in file if file info retrieved
            if (rc == NO_ERROR)
            {
               while (ulOffset < fib.cbFile)
               {
                  ulLen = min (ulLen, fib.cbFile - ulOffset);

                  rc = GplTIFFReadFile (pTIFFInfo,
                                        ulOffset,
                                        ulLen,
                                        pBuf);

                  if (hDevice)
                     bRC = PrtWrite (hDevice, pBuf, ulLen, &ulBytesWritten);

                  ulOffset += ulBytesWritten;
               }
            }

            rc = GplMemoryFree (pBuf);
            assertT (rc);
         }

         bRC = PrtClose (hDevice);
         assertT (bRC);
      }

      rc = DosClose (pTIFFInfo->hFile);
      assertT (rc != NO_ERROR);

      // Delete temporary file
      rc = DosDelete (pTIFFInfo->pszfileName);
      assertT (rc);

#ifndef DEBUG
      bRC++;       // Get rid of warning
#endif
   }
   else
   {
      rc = DosClose (hDevice);

      if (NO_ERROR != rc)
      {
         DEBUGWINMESSAGEBOX (("DosClose Error",
                             "Closing file '%d', apiret = %d",
                             hDevice,
                             rc));
      }
   }

   return rc;

} /* end TIFFCloseFile */

/****************************************************************************/
/* PROCEDURE NAME : TIFFSpoolerOpen                                         */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 03-24-96                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
HSPL
TIFFSpoolerOpen (PVOID       pvDDC,
                 PVOID       pvHandle,
                 PSZ         pszToken,
                 LONG        lCount,
                 PQMOPENDATA pqmdopData)
{
   PTIFFHANDLE   pHandle = (PTIFFHANDLE)pvHandle;
   PDDC          pddc    = (PDDC)pvDDC;
   HMCB          hmcb    = pHandle->hmcbHeap;
   PDEVOPENSTRUC pdop;

   DEBUG_FUNCTION_ENTER;

   // Attempt to subclass SplQmOpen and instead open a temporary
   // file using "Dos" based calls so we can get read/write access
   // to file which we do not get thru the "Spl" calls

   // Save the QMOPENDATA for use when we'll call SplQmOpen()
   // and place our finished TIFF data into the print queue
   pHandle->pdopData = (PDEVOPENSTRUC)GplMemoryAlloc (hmcb, sizeof (DEVOPENSTRUC));
   assertF (pHandle->pdopData);
   if (!pHandle->pdopData)
      return 0;

   memcpy (pHandle->pdopData, pqmdopData, sizeof (DEVOPENSTRUC));

   // Need to access QMOPENDATA like PDEVOPENDATA since spooler only defines
   // PQMOPENDATA as a PSZ and so compiler does not know how to dereference
   pdop = (PDEVOPENSTRUC)pqmdopData;

   // allocate room for PDRIVDATA
   pHandle->pdopData->pdriv = (PDRIVDATA)GplMemoryAlloc (hmcb, pdop->pdriv->cb);
   assertF (pHandle->pdopData->pdriv);
   if (!pHandle->pdopData->pdriv)
      return 0;

   memcpy (pHandle->pdopData->pdriv, pdop->pdriv, pdop->pdriv->cb);

   {
      HFILE  hFile     = 0;
      ULONG  ulWork    = 0;
      ULONG  ulFileNum = 0;
      APIRET rc        = ERROR_FILE_EXISTS;
      PSZ    psz;

      psz = (PSZ)GplMemoryAlloc (hmcb, pHandle->ulSize + TIFF_TMP_LEN);
      assertF (psz);

      while (psz && rc == ERROR_FILE_EXISTS && ulFileNum < 299)
      {
         sprintf (psz,
                  "%s\\%s%d%s",
                  pHandle->pszSpoolDir,
                  TIFF_PREFIX,
                  ulFileNum,
                  TIFF_SUFFIX);

         // Call our own routine to open a TIFF file with read/write access
         rc = TIFFOpenFile (pddc,
                            pHandle,
                            psz,
                            &hFile,
                            &ulWork,
                            0L,
                            0L,
                            0L,
                            0L,
                            NULL);

         ulFileNum++;
      }

      if (psz)
      {
         rc = GplMemoryFree (psz);
         assertT (rc);
      }
   }

   if (PRN_ID_TIFF_MONOCHROME == pHandle->usDeviceID)
   {
      // Open a fake spooler file so user believes we are spooling data
      // at this time instead we are going to a temporary file
      pHandle->hspl = SplQmOpen (pszToken, lCount, pqmdopData);

      DEBUG_FUNCTION_EXIT;

      return pHandle->hspl;
   }
#ifdef SAM_DETWEILER
   else // if (PRN_ID_TIFF_SAM_D == pHandle->usDeviceID)
   {
      DBPRINTF (("SAM_DETWEILER: TIFFSpoolerOpen called\n"));

      DEBUG_FUNCTION_EXIT;

      /* We have an interesting dilemma here.  For the DEBUG build, we are
      ** out of luck either way we go.  That is, if we return 0 then will
      ** will hit asserts (which should not happen in the normal, working
      ** case) or if we return 1 then we will trap in the spooler (a "safe"
      ** trap in the validate routine) and assert.
      */
      return 1;  // Don't care (but nonzero).  We control all access to HSPL.
   }
#else

   DEBUG_FUNCTION_EXIT;

   return 0;     // Failure!

#endif

} /* end TIFFSpoolerOpen */

/****************************************************************************/
/* PROCEDURE NAME : TIFFSpoolerStart                                        */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 03-24-96                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
TIFFSpoolerStartJob (PVOID pvDDC,
                     PVOID pvHandle,
                     HSPL  hspl,
                     PSZ   pszDocumentName)
{
   PTIFFHANDLE   pHandle = (PTIFFHANDLE)pvHandle;
   HMCB          hmcb    = pHandle->hmcbHeap;
   BOOL          bRC     = SPL_ERROR;

   DEBUG_FUNCTION_ENTER;

   // Save document name for our later use
   pHandle->pszDocumentName = (PSZ)GplMemoryAlloc (hmcb, strlen(pszDocumentName) + 1);
   assertF (pHandle->pszDocumentName);
   if (!pHandle->pszDocumentName)
      return FALSE;

   strcpy (pHandle->pszDocumentName, pszDocumentName);

   if (PRN_ID_TIFF_MONOCHROME == pHandle->usDeviceID)
   {
      if (hspl)
      {
         // start the document in the queue to fool user for now
         bRC = SplQmStartDoc (hspl, pszDocumentName);
         assertF (bRC);
      }
   }
#ifdef SAM_DETWEILER
   else // if (PRN_ID_TIFF_SAM_D == pHandle->usDeviceID)
   {
      DBPRINTF (("SAM_DETWEILER: TIFFSpoolerStartJob called\n"));
      bRC = TRUE;
   }
#endif

   DEBUG_FUNCTION_EXIT;

   return bRC;

} /* end TIFFSpoolerStartJob */

/****************************************************************************/
/* PROCEDURE NAME : TIFFSpoolerEnd                                          */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 03-24-96                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG
TIFFSpoolerEndJob (PVOID pvDDC,
                   PVOID pvHandle,
                   HSPL  hspl)
{
   PTIFFHANDLE   pHandle    = (PTIFFHANDLE)pvHandle;
   LONG          lJobID     = SPL_ERROR;

   DEBUG_FUNCTION_ENTER;

   if (PRN_ID_TIFF_MONOCHROME == pHandle->usDeviceID)
   {
      if (hspl)
      {
         lJobID = (LONG)SplQmEndDoc (hspl);
         assertF (lJobID != SPL_ERROR);
      }
   }

   DEBUG_FUNCTION_EXIT;

   return lJobID;

} /* end TIFFSpoolerEndJob */

/****************************************************************************/
/* PROCEDURE NAME : TIFFSpoolerClose                                        */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 03-24-96                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
TIFFSpoolerClose (PVOID pvDDC,
                  PVOID pvHandle,
                  HSPL  hspl)
{
   PTIFFHANDLE  pHandle   = (PTIFFHANDLE)pvHandle;
   PTIFFINFO    pTIFFInfo = &(pHandle->TIFFInfo);
#ifdef SAM_DETWEILER
   PDDC         pddc      = (PDDC)pvDDC;
#endif
   HMCB         hmcb      = pHandle->hmcbHeap;
   BOOL         bRC       = SPL_ERROR;
   ULONG        ulAction;
   APIRET       rc;

   DEBUG_FUNCTION_ENTER;

   // Close our temporary file
   rc = TIFFCloseFile (pHandle, pTIFFInfo->hFile);

   if (PRN_ID_TIFF_MONOCHROME == pHandle->usDeviceID)
   {
      // if we have a spool file we need to copy TIFF file into it
      if (hspl)
      {
         DBPRINTF (("Opening '%s'\n", pTIFFInfo->pszfileName));

         // Open our temporary file to read in TIFF to copy to spooler
         rc = DosOpen (pTIFFInfo->pszfileName,
                       &(pTIFFInfo->hFile),
                       (PULONG)&ulAction,
                       0L,
                       0L,
                       OPEN_ACTION_OPEN_IF_EXISTS,
                       OPEN_ACCESS_READONLY
                       | OPEN_SHARE_DENYWRITE,
                       NULL);

         if (rc == NO_ERROR)
         {
            FILEFINDBUF   fib;
            ULONG         ulfib      = sizeof (FILEFINDBUF);
            PBYTE         pBuf;
            // The SplQmWrite call fails if buffer size
            // is greater than 64k so limit our buffer as well
            ULONG         ulLen      = 63000;  // 64k buffer for now
            ULONG         ulOffset   = 0;

            // Allocate buffer for reading in data
            pBuf = (PBYTE)GplMemoryAlloc (hmcb, ulLen + 1);
            assertF (pBuf);

            if (pBuf)
            {
               // Find out how big TIFF file is
               rc = DosQFileInfo (pTIFFInfo->hFile,
                                  (USHORT)1,
                                  (PBYTE)&fib,
                                  ulfib);

               // Read in file if file info retrieved
               if (rc == NO_ERROR)
               {
                  while (ulOffset < fib.cbFile)
                  {
                     ulLen = min (ulLen, fib.cbFile - ulOffset);

                     rc = GplTIFFReadFile (pTIFFInfo, ulOffset, ulLen, pBuf);

                     if (hspl)
                        bRC = SplQmWrite (hspl, ulLen, pBuf);

                     ulOffset += ulLen;
                  }
               }

               rc = GplMemoryFree (pBuf);
               assertT (rc);
            }

            rc = DosClose (pTIFFInfo->hFile);
            assertT (rc != NO_ERROR);
         }

         bRC = SplQmClose (hspl);
         assertF (bRC);
      }
   }
#ifdef SAM_DETWEILER
   else // if (PRN_ID_TIFF_SAM_D == pHandle->usDeviceID)
   {
      CHAR   achExitDLL[CCHMAXPATH];
      CHAR   achPortName[CCHMAXPATH];
      PBYTE  pbDevice                 = (PBYTE)NULL;
      ULONG  cbBytes                  = 0;
      ULONG  cbNeeded;

      DBPRINTF (("SAM_DETWEILER: TIFFSpoolerClose called\n"));
      assertF (pddc->pdb->pszPrinterName);
      assertF (*pddc->pdb->pszPrinterName);

      // Start small for now
      cbBytes = 4 * 1024;
      pbDevice = (PBYTE)GplMemoryAlloc (0, cbBytes);
      assertF (pbDevice);
      if (!pbDevice)
         // Error!
         goto done;

      rc = SplQueryDevice ((PSZ)NULL,                   // Computer name
                           pddc->pdb->pszPrinterName,   // Device Name
                           3,                           // Level
                           pbDevice,                    // Buffer
                           cbBytes,                     // is size
                           &cbNeeded);                  // # bytes needed

      DBPRINTF (("SAM_DETWEILER: SplQueryDevice (%s) = %d\n",
                 pddc->pdb->pszPrinterName, rc));
      assertT (ERROR_MORE_DATA  != rc &&
               NERR_BufTooSmall != rc &&
               NO_ERROR         != rc  );

      if (ERROR_MORE_DATA == rc || NERR_BufTooSmall == rc)
      {
         rc = GplMemoryFree (pbDevice);

         cbBytes = cbNeeded;
         pbDevice = (PBYTE)GplMemoryAlloc (0, cbBytes);
         assertF (pbDevice);
         if (!pbDevice)
            // Error!
            goto done;

         rc = SplQueryDevice ((PSZ)NULL,                   // Computer name
                              pddc->pdb->pszPrinterName,   // Device Name
                              3,                           // Level
                              pbDevice,                    // Buffer
                              cbBytes,                     // is size
                              &cbNeeded);                  // # bytes needed

         DBPRINTF (("SAM_DETWEILER: SplQueryDevice (%s) = %d\n",
                    pddc->pdb->pszPrinterName, rc));
         assertT (rc);

         if (rc)
            // Error!
            goto done;
      }

      if (NO_ERROR == rc)
      {
         PPRDINFO3    prd;

         prd = (PPRDINFO3)pbDevice;
         DBPRINTF (("SAM_DETWEILER: port name is %s\n", prd->pszLogAddr));

         strcpy (achPortName, prd->pszLogAddr);
      }
      else
         // Error!
         goto done;

      if (PrfQueryProfileString (HINI_SYSTEMPROFILE,
                                 "OMNITIFF_PORT",
                                 achPortName,
                                 "",
                                 achExitDLL,
                                 sizeof (achExitDLL)))
      {
         CHAR     achError[CCHMAXPATH];
         HMODULE  hModExitDLL;

         DBPRINTF (("SAM_DETWEILER: OMNITIFF_PORT('%s') = '%s'\n", achPortName, achExitDLL));

         rc = DosLoadModule (achError,
                             sizeof (achError),
                             achExitDLL,
                             &hModExitDLL);
         assertT (rc);

         if (NO_ERROR == rc)
         {
            VOID (* APIENTRY pfnCallback) (PSZ pszFileName) = NULL;

            rc = DosQueryProcAddr (hModExitDLL,
                                   1,
                                   "",
                                   (PFN *)&pfnCallback);
            assertT (rc);

            if (NO_ERROR == rc)
            {
               DBPRINTF (("SAM_DETWEILER: calling %08X with '%s'\n",
                          pfnCallback, pHandle->TIFFInfo.pszfileName));

               pfnCallback (pHandle->TIFFInfo.pszfileName);
            }

            rc = DosFreeModule (hModExitDLL);
            assertT (rc);
         }
      }
#ifdef DEBUG
      else
      {
         DBPRINTF (("SAM_DETWEILER: \n"));
      }
#endif

done:
      // Clean up
      if (pbDevice)
      {
         rc = GplMemoryFree (pbDevice);
         assertT (rc);
      }
   }
#endif

   // Delete temporary file
   rc = DosDelete (pTIFFInfo->pszfileName);
   assertT (rc);

   DEBUG_FUNCTION_EXIT;

   return bRC;

} /* end TIFFSpoolerClose */

//////////////////////////////////////////////////////////////////////////////

/****************************************************************************/
/* PROCEDURE NAME : GplTIFFWriteFile                                        */
/* AUTHOR         : Mike Jones                                              */
/* DATE WRITTEN   : 7/17/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* Control Flow:                                                            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFWriteFile (PTIFFINFO pTIFFInfo, ULONG ulOffset, ULONG ulLen, PVOID pBuf)
{
   ULONG ulOffset1,
         ulLen1;

   if (DosSetFilePtr (pTIFFInfo->hFile, ulOffset, FILE_BEGIN, &ulOffset1))
   {
      DosClose (pTIFFInfo->hFile);

      return FALSE;            // return error
   }

   if (DosWrite (pTIFFInfo->hFile, pBuf, ulLen, &ulLen1))
   {
      DosClose (pTIFFInfo->hFile);

      return FALSE;          // return error
   }

   return TRUE;

} /* end GplTIFFWriteFile */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFReadFile (PTIFFINFO pTIFFInfo,
                 ULONG     ulOffset,
                 ULONG     ulLen,
                 PVOID     pBuf)
{
   ULONG  ulOffsetRet, ulLenRet;
   APIRET rc;

   rc = DosSetFilePtr (pTIFFInfo->hFile, ulOffset, FILE_BEGIN, &ulOffsetRet);

   if (rc != NO_ERROR)
   {
      DEBUGWINMESSAGEBOX (("DosSetFilePtr Error",
                          "rc = %d\n",
                          rc));

      DosClose (pTIFFInfo->hFile);

      return FALSE;
   }
   else
   {
      if (ulOffset != ulOffsetRet)
      {
         DEBUGWINMESSAGEBOX (("DosSetFilePtr Error",
                             "Offset requested = %d\nOffset returned = %d",
                             ulOffset,
                             ulOffsetRet));

         return FALSE;     // return error
      }
   }

   rc = DosRead (pTIFFInfo->hFile, pBuf, ulLen, &ulLenRet);

   if (rc != NO_ERROR)
   {
      DEBUGWINMESSAGEBOX (("DosRead Error",
                          "rc returned = %d\n",
                          ulLen,
                          ulLenRet));

      DosClose (pTIFFInfo->hFile);

      return FALSE;          // return error
   }
   else
   {
      if (ulLen != ulLenRet)
      {
         DEBUGWINMESSAGEBOX (("DosRead Error",
                             "Length requested = %d\nLength returned = %d",
                             ulLen,
                             ulLenRet));

         return FALSE;     // return error
      }
   }

   return TRUE;

} /* end GplTIFFReadFile */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFLinkPreviousIFD (PDDC pddc, PTIFFHANDLE pHandle, PVOID pBuf)
{
   ULONG ulOffset1;
   BOOL bRC;

   GplTIFFWriteFile (&(pHandle->TIFFInfo),
                     pHandle->TIFFInfo.ulOffsetPreviousIFD,
                     4L,
                     pBuf);

   bRC = DosSetFilePtr (pHandle->TIFFInfo.hFile, 0L, FILE_END, &ulOffset1);

   // If DosSetFilePtr return code was not NO_ERROR display error code
   if (bRC != NO_ERROR)
   {
      DEBUGWINMESSAGEBOX (("DosSetFilePtr Error",
                          "File Handle = %d\nreturn code = %d",
                          pHandle->TIFFInfo.hFile,
                          bRC));

      return FALSE;     // return error
   }

   return TRUE;

} /* end GplTIFFLinkPreviousIFD */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFUpdatePageCount (PDDC pddc, PTIFFHANDLE pHandle)
{
   ULONG ulOffsetIFD = 4L,
         ulPageCount = 0;
   ULONG ulCurPage   = 0;

   GplTIFFReadFile (&(pHandle->TIFFInfo),
                    ulOffsetIFD,
                    4L,
                    (PVOID)&ulOffsetIFD);

   while (ulOffsetIFD && (ulCurPage < 999))
   {
      GplTIFFReadFile (&(pHandle->TIFFInfo),
                       ulOffsetIFD + IFD_PAGEOFFSET,
                       4L,
                       (PVOID) &ulPageCount);

      ulPageCount |= pHandle->TIFFInfo.ulPageCount << 16 ;

      GplTIFFWriteFile (&(pHandle->TIFFInfo),
                        ulOffsetIFD + IFD_PAGEOFFSET,
                        4L,
                        (PVOID)&ulPageCount);

      GplTIFFReadFile (&(pHandle->TIFFInfo),
                       ulOffsetIFD + IFD_NEXTIFD,
                       4L,
                       (PVOID)&ulOffsetIFD);

      ulCurPage++;
   }

   return TRUE;

} /* end GplTIFFUpdatePageCount */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFputword (PTIFFINFO pTIFFInfo, int n)
{
   ULONG ulLen1;

   if (DosWrite (pTIFFInfo->hFile, &n, 2, &ulLen1))
   {
      DosClose (pTIFFInfo->hFile);

      return FALSE;          // return error
   }

   return TRUE;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFputlong (PTIFFINFO pTIFFInfo, ULONG n)
{
   ULONG ulLen1;

   if (DosWrite (pTIFFInfo->hFile, &n, 4, &ulLen1))
   {
      DosClose (pTIFFInfo->hFile);

      return FALSE;          // return error
   }

   return TRUE;
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
GplTIFFwritetiftag (PTIFFINFO pTIFFInfo, ULONG tag, ULONG type, ULONG count, ULONG offset)
{
   GplTIFFputword (pTIFFInfo, tag);
   GplTIFFputword (pTIFFInfo, type);
   GplTIFFputlong (pTIFFInfo, count);
   GplTIFFputlong (pTIFFInfo, offset);

   return TRUE;
}

/********************************************************************
 *
 *                   G P L T I F F   E N D
 *
 ********************************************************************/

//****************************************************************************
//* SUBCLASSED FUNCTIONS
//****************************************************************************
FNSTD TIFFBeginJob;
FNSTD TIFFEndJob;
FNSTD TIFFNewFrame;

ABORT_FUNC        TIFFAbortJob;
DEVICE_QUERY_FUNC TIFFDeviceQuery;
RASTER_FUNC       TIFFChooseRasterize;

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
TiffFlushBuffer (PVOID pvHandle, PBYTE pbOutput, ULONG ulOutputSize)
{
   PTIFFHANDLE pHandle = (PTIFFHANDLE) pvHandle;
   ULONG       ulLen1;

   if (DosWrite (pHandle->TIFFInfo.hFile, pbOutput, ulOutputSize , &ulLen1))
      DosClose (pHandle->TIFFInfo.hFile);

   pHandle->TIFFInfo.ulStripeBytesWritten += ulOutputSize;

} /* end TIFFFlushBuffer */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL  _System
TiffBeginJob (PVOID pv, PVOID pvHandle)
{
   PDDC            pddc     = (PDDC)pv;
   PTIFFHANDLE     pHandle  = (PTIFFHANDLE)pvHandle;
   INT             iBitsInArray,
                   iDWordBitsInArray,
                   sizetoalloc;

   if (pHandle->fLeaveAlone)
   {
      return TRUE;
   }

   // We have an actual OS/2 job not a DOS/Windows job to send
   if (pddc->pdb->fRawOnly == FALSE)
   {
      // Determine width of a band based on orientation
      if (pddc->pdb->bRasterPortrait)
      {
         iBitsInArray       = BUMP_TO_NEXT_MODULUS (pddc->bmp.cx, 8);
         iDWordBitsInArray  = BUMP_TO_NEXT_MODULUS (pddc->bmp.cx * pddc->bmp.cBitCount, 32);
      }
      else
      {
         iBitsInArray       = BUMP_TO_NEXT_MODULUS (pddc->bmp.cy, 8);
         iDWordBitsInArray  = BUMP_TO_NEXT_MODULUS (pddc->bmp.cy * pddc->bmp.cBitCount, 32);
      }

      pHandle->iSrcRowPels = iBitsInArray;

      // number of bytes in Source, DwordAligned
      pHandle->iNumSrcRowBytes32 = iDWordBitsInArray>>3;

      // Number of bytes in Destination, Byte Aligned
      pHandle->iNumDestRowBytes = iBitsInArray>>3;

      if (pddc->pdb->pResInfo->ulXRes >= pddc->pdb->pResInfo->ulYRes)
         pHandle->ulResolution = pddc->pdb->pResInfo->ulXRes;
      else
         pHandle->ulResolution = pddc->pdb->pResInfo->ulYRes;

      if (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)
         pddc->ptlPrintHead.y = pddc->pdb->pFormInfo->hcInfo.yPels-1;
      else
         pddc->ptlPrintHead.y = pddc->pdb->pFormInfo->hcInfo.xPels-1;

      /* write TIFF header */
      GplTIFFputword (&(pHandle->TIFFInfo),'II');
      GplTIFFputword (&(pHandle->TIFFInfo),42);
      GplTIFFputlong (&(pHandle->TIFFInfo),0L);

      pHandle->TIFFInfo.ulOffsetPreviousIFD   = 4L;
      pHandle->TIFFInfo.ulOffsetStartOfStripe = 8L;

      pHandle->ulOutputSize = TIFF_BUFFER_SIZE;

      switch (pddc->pdb->pPrintMode->ulPrintModeID)
      {
      case TIFF_RES_ID_CCITT_1D:
      {
         GplFaxTIFF2StartBlock (&(pHandle->ulBitposition));
         break;
      }

      case TIFF_RES_ID_GROUP_3:
      {
         GplFaxG3StartBlock (pHandle->pbOutput, &(pHandle->ulBitposition));
         break;
      }

      case TIFF_RES_ID_GROUP_4:
      {
         sizetoalloc = ((iBitsInArray + 31) / 32 + 4) * 4;

         pHandle->pulwstartc = (PULONG)GplMemoryAlloc (pHandle->hmcbHeap,
                                                       4 * sizetoalloc);
         assertF (pHandle->pulwstartc);

         if (pHandle->pulwstartc)
         {
            pHandle->allocsize = 4 * sizetoalloc;

            pHandle->pulbstartc = (PULONG) ((PBYTE)pHandle->pulwstartc + sizetoalloc);
            pHandle->pulwstartp = (PULONG) ((PBYTE)pHandle->pulbstartc + sizetoalloc);
            pHandle->pulbstartp = (PULONG) ((PBYTE)pHandle->pulwstartp + sizetoalloc);
         }
         break;
      }
      }
   }

   return TRUE;

} /* end TIFFBeginJob */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL _System
TIFFEndJob (PVOID pv, PVOID pvHandle)
{
   PDDC        pddc     = (PDDC)pv;
   PTIFFHANDLE pHandle  = (PTIFFHANDLE)pvHandle;
   ULONG       ulOffset, LargeValues;

   if (pHandle->fLeaveAlone)
   {
      return TRUE;
   }

   switch (pddc->pdb->pPrintMode->ulPrintModeID)
   {
   case TIFF_RES_ID_CCITT_1D:
      GplFaxTIFF2EndBlock ((PVOID)pHandle, pHandle->pbOutput,
                           &(pHandle->ulBitposition), TiffFlushBuffer);
      break;

   case TIFF_RES_ID_GROUP_3:
      GplFaxG3EndBlock ((PVOID)pHandle, pHandle->pbOutput,
                        &(pHandle->ulBitposition), TiffFlushBuffer);
      break;

   case TIFF_RES_ID_GROUP_4:
      GplFaxG4EndBlock ((PVOID)pHandle, pHandle->pbOutput, pHandle->ulOutputSize,
                        &(pHandle->ulBitposition), TiffFlushBuffer);
      break;
   }

   DosSetFilePtr (pHandle->TIFFInfo.hFile, 0L, FILE_END, &ulOffset);
   GplTIFFLinkPreviousIFD( pddc, pHandle, (PVOID) &ulOffset);

   GplTIFFputword (&(pHandle->TIFFInfo),TIFF_TAG_COUNT);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), NewSubFile,    TIFFlong,  1L, 2L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), ImageWidth,    TIFFshort, 1L, (long)pHandle->iSrcRowPels);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), ImageLength,   TIFFshort, 1L, (long)pHandle->iSrcRow);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), BitsPerSample, TIFFshort, 1L, 1L);

   switch (pddc->pdb->pPrintMode->ulPrintModeID)
   {
   case TIFF_RES_ID_CCITT_1D:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo), Compression, TIFFshort, 1L, 2L);
      break;

   case TIFF_RES_ID_GROUP_3:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo), Compression, TIFFshort, 1L, 3L);
      break;

   case TIFF_RES_ID_GROUP_4:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo), Compression, TIFFshort, 1L, 4L);
      break;
   }

   GplTIFFwritetiftag (&(pHandle->TIFFInfo), PhotometricInterp, TIFFshort, 1L, 0L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), FillOrder,         TIFFshort, 1L, 1L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), StripOffsets,      TIFFlong,  1L, (long)pHandle->TIFFInfo.ulOffsetStartOfStripe);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), SamplesPerPixel,   TIFFshort, 1L, 1L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), RowsPerStrip,      TIFFshort, 1L, (long)pHandle->iSrcRow);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), StripByteCounts,   TIFFlong,  1L, (long)pHandle->TIFFInfo.ulStripeBytesWritten);

   LargeValues = TIFF_TAG_COUNT * 12 + 6L + ulOffset;  // Start of values longer than 4 bytes

   GplTIFFwritetiftag (&(pHandle->TIFFInfo), XResolution, TIFFrational, 1L, (long)LargeValues);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), YResolution, TIFFrational, 1L, (long)LargeValues + 8L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), PlanarConfiguration, TIFFshort, 1L, 1L);

   GplTIFFwritetiftag (&(pHandle->TIFFInfo), Group3Options, TIFFlong,1L,0L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), Group4Options, TIFFlong,1L,0L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), ResolutionUnit, TIFFshort,1L,2L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo), PageNumber, TIFFshort, 2L, (long)(pHandle->TIFFInfo.ulPageCount));
   pHandle->TIFFInfo.ulPageCount += 1;

   GplTIFFputlong (&(pHandle->TIFFInfo), 0L);

   if (pddc->pdb->pResInfo->ulResID == TIFF_RES_ID_FINE)
   {
      GplTIFFputlong (&(pHandle->TIFFInfo), 204L);     // Fine Resolution
      GplTIFFputlong (&(pHandle->TIFFInfo), 1L);
      GplTIFFputlong (&(pHandle->TIFFInfo), 196L);
      GplTIFFputlong (&(pHandle->TIFFInfo), 1L);
   }
   else
   {
      GplTIFFputlong (&(pHandle->TIFFInfo), 102L);     // Normal Resolution
      GplTIFFputlong (&(pHandle->TIFFInfo), 1L);
      GplTIFFputlong (&(pHandle->TIFFInfo), 98L);
      GplTIFFputlong (&(pHandle->TIFFInfo), 1L);
   }

   GplTIFFUpdatePageCount (pddc, pHandle);

   return TRUE;

} /* end TIFFEndJob */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL _System
TIFFAbortJob (PVOID pv, PABORT_DATA pAbortData, PVOID pvHandle)
{
   return TRUE;

} /* end TIFFAbortJob */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL _System
TIFFNewFrame (PVOID pv, PVOID pvHandle)
{
   PDDC        pddc     = (PDDC)pv;
   PTIFFHANDLE pHandle  = (PTIFFHANDLE)pvHandle;
   ULONG       ulOffset,
               LargeValues;

   if (pHandle->fLeaveAlone)
   {
      return TRUE;
   }

   // Set printer's physical head position in our ddc
   pddc->ptlPrintHead.x = 0;
   if (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)
      pddc->ptlPrintHead.y = pddc->pdb->pFormInfo->hcInfo.yPels - 1;
   else
      pddc->ptlPrintHead.y = pddc->pdb->pFormInfo->hcInfo.xPels - 1;

   switch (pddc->pdb->pPrintMode->ulPrintModeID)
   {
   case TIFF_RES_ID_CCITT_1D:
      GplFaxTIFF2EndBlock ((PVOID)pHandle, pHandle->pbOutput,
                            &(pHandle->ulBitposition), TiffFlushBuffer);
      break;

   case TIFF_RES_ID_GROUP_3:
      GplFaxG3EndBlock ((PVOID)pHandle, pHandle->pbOutput,
                        &(pHandle->ulBitposition), TiffFlushBuffer);
      break;

   case TIFF_RES_ID_GROUP_4:
      GplFaxG4EndBlock ((PVOID)pHandle, pHandle->pbOutput, pHandle->ulOutputSize,
                        &(pHandle->ulBitposition), TiffFlushBuffer);
      break;
   }

   // Update All preceding Page Number Directory entries and increment
   // total number of pages
   DosSetFilePtr (pHandle->TIFFInfo.hFile, 0L, FILE_END, &ulOffset);
   GplTIFFLinkPreviousIFD( pddc, pHandle, (PVOID) &ulOffset );

   GplTIFFputword (&(pHandle->TIFFInfo),TIFF_TAG_COUNT);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),NewSubFile,TIFFlong,1L,2L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),ImageWidth,TIFFshort,1L,(long)pHandle->iSrcRowPels);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),ImageLength,TIFFshort,1L,(long)pHandle->iSrcRow);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),BitsPerSample,TIFFshort,1L,1L);

   switch (pddc->pdb->pPrintMode->ulPrintModeID)
   {
   case TIFF_RES_ID_CCITT_1D:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo),Compression,TIFFshort,1L,2L);
      break;

   case TIFF_RES_ID_GROUP_3:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo),Compression,TIFFshort,1L,3L);
      break;

   case TIFF_RES_ID_GROUP_4:
      GplTIFFwritetiftag (&(pHandle->TIFFInfo),Compression,TIFFshort,1L,4L);
      break;
   }

   GplTIFFwritetiftag (&(pHandle->TIFFInfo),PhotometricInterp,TIFFshort,1L,0L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),FillOrder,TIFFshort,1L,1L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),StripOffsets,TIFFlong,1L,(long)pHandle->TIFFInfo.ulOffsetStartOfStripe);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),SamplesPerPixel,TIFFshort,1L,1L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),RowsPerStrip,TIFFshort,1L,(long)pHandle->iSrcRow);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),StripByteCounts,TIFFlong,1L,(long) pHandle->TIFFInfo.ulStripeBytesWritten);

   LargeValues = TIFF_TAG_COUNT * 12 + 6L + ulOffset;  // Start of values longer than 4 bytes

   GplTIFFwritetiftag (&(pHandle->TIFFInfo),XResolution,TIFFrational,1L,(long)LargeValues);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),YResolution,TIFFrational,1L,(long)LargeValues + 8L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),PlanarConfiguration,TIFFshort,1L,1L);

   GplTIFFwritetiftag (&(pHandle->TIFFInfo),Group3Options,TIFFlong,1L,0L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),Group4Options,TIFFlong,1L,0L);

   GplTIFFwritetiftag (&(pHandle->TIFFInfo),ResolutionUnit,TIFFshort,1L,2L);
   GplTIFFwritetiftag (&(pHandle->TIFFInfo),PageNumber,TIFFshort,2L,(long) (pHandle->TIFFInfo.ulPageCount));

   pHandle->TIFFInfo.ulPageCount += 1;

   DosSetFilePtr (pHandle->TIFFInfo.hFile, 0L, FILE_END, &ulOffset);
   pHandle->TIFFInfo.ulOffsetPreviousIFD = ulOffset;  // used to store linked list entry

   GplTIFFputlong(&(pHandle->TIFFInfo),0L);

   // Start of values longer than 4 bytes
   if (pddc->pdb->pResInfo->ulResID == TIFF_RES_ID_FINE)
   {
      GplTIFFputlong (&(pHandle->TIFFInfo),204L);     // Fine Resolution
      GplTIFFputlong (&(pHandle->TIFFInfo),1L);
      GplTIFFputlong (&(pHandle->TIFFInfo),196L);
      GplTIFFputlong (&(pHandle->TIFFInfo),1L);
   }
   else
   {
      GplTIFFputlong (&(pHandle->TIFFInfo),102L);     // Normal Resolution
      GplTIFFputlong (&(pHandle->TIFFInfo),1L);
      GplTIFFputlong (&(pHandle->TIFFInfo),98L);
      GplTIFFputlong (&(pHandle->TIFFInfo),1L);
   }

   pHandle->TIFFInfo.ulOffsetStartOfStripe = ulOffset + 4 * 5;
   // 4 * 5 is the number of bytes written after ulOffset gotten from above

   pHandle->TIFFInfo.ulStripeBytesWritten = 0;
   pHandle->iSrcRow = 0;

   switch (pddc->pdb->pPrintMode->ulPrintModeID)
   {
   case TIFF_RES_ID_CCITT_1D:
      memset (pHandle->pbOutput, 0, TIFF_BUFFER_SIZE);
      GplFaxTIFF2StartBlock (&(pHandle->ulBitposition));
      break;

   case TIFF_RES_ID_GROUP_3:
      memset (pHandle->pbOutput, 0, TIFF_BUFFER_SIZE);
      GplFaxG3StartBlock ( pHandle->pbOutput, &(pHandle->ulBitposition));
      break;

   case TIFF_RES_ID_GROUP_4:
      memset (pHandle->pbOutput, 0, TIFF_BUFFER_SIZE);
      memset (pHandle->pulwstartc, 0, pHandle->allocsize);
      pHandle->ulBitposition = 0;
      break;
   }

   return TRUE;

} /* end TIFFNewFrame */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL _System
TIFFDeviceQuery (PVOID pv1, ULONG ulType, PVOID pvArg1, ...)
{
   BOOL             rc       = TRUE;
   PDDC             pddc     = (PDDC)pv1;
   PTIFFHANDLE      pHandle;
   va_list          list;

   va_start (list, pvArg1);

   switch (ulType)
   {
   case DEVICE_ALLOC_HANDLE:
   {
      PTIFFHANDLE    pOldHandle = (PTIFFHANDLE)va_arg (list, PTIFFHANDLE);
      HMCB           hmcbHeap;

      hmcbHeap = (HMCB)pvArg1;

      if (!pOldHandle)
      {
         pHandle = (PTIFFHANDLE)GplMemoryAlloc (hmcbHeap,
                                                sizeof (TIFFHANDLE));
         assertF (pHandle);
      }
      else
         pHandle = pOldHandle;

      if (!pHandle)
         break;

      if (!pOldHandle)
         memset (pHandle, 0, sizeof (TIFFHANDLE));

      pHandle->cb       = sizeof (TIFFHANDLE);
      pHandle->ulSig    = TIFF_SIG;
      pHandle->hmcbHeap = hmcbHeap;

      if (!pddc)
      {
         // Cannot go further without a pddc...
         rc = (ULONG)pHandle;
         break;
      }

      pHandle->usDeviceID = pddc->pdb->pDevice->usDeviceID;

      pHandle->pbOutput = (PBYTE)GplMemoryAlloc (pHandle->hmcbHeap,
                                                 TIFF_BUFFER_SIZE);
      assertF (pHandle->pbOutput);

      memset (pHandle->pbOutput, 0, TIFF_BUFFER_SIZE);

      // Find where we can spool our temporary file
      if (PrfQueryProfileSize (HINI_SYSTEMPROFILE,
                               "PM_SPOOLER",
                               "DIR",
                               &(pHandle->ulSize)))
      {
         pHandle->pszSpoolDir = (PSZ)GplMemoryAlloc (pHandle->hmcbHeap,
                                                     pHandle->ulSize + 1);
         assertF (pHandle->pszSpoolDir);

         if (pHandle->pszSpoolDir)
         {
            PrfQueryProfileString (HINI_SYSTEMPROFILE,
                                   "PM_SPOOLER",
                                   "DIR",
                                   "",
                                   pHandle->pszSpoolDir,
                                   pHandle->ulSize);

            pHandle->pszSpoolDir[pHandle->ulSize-2] = '\0';
         }
      }

      rc = (ULONG)pHandle;
      break;
   }

   case DEVICE_FREE_HANDLE:
   {
      BOOL fReAllocate = va_arg (list, BOOL);

      // Grab our handle
      pHandle = (PTIFFHANDLE)pvArg1;
      assertF (pHandle);
      assertT (TIFF_SIG != pHandle->ulSig);

      // Free work buffers we allocated with GplMemoryAlloc()
      if (pHandle)
      {
         // used by GROUP 4
         if (pHandle->pulwstartc)
         {
            rc = GplMemoryFree (pHandle->pulwstartc);
            assertT (rc);
         }

         if (pHandle->pbOutput)
         {
            rc = GplMemoryFree (pHandle->pbOutput);
            assertT (rc);
         }

         if (pHandle->TIFFInfo.pszfileName)
         {
            rc = GplMemoryFree (pHandle->TIFFInfo.pszfileName);
            assertT (rc);
         }

         if (pHandle->pdopData && pHandle->pdopData->pdriv)
         {
            rc = GplMemoryFree (pHandle->pdopData->pdriv);
            assertT (rc);
         }

         if (pHandle->pdopData)
         {
            rc = GplMemoryFree (pHandle->pdopData);
            assertT (rc);
         }

         if (pHandle->pszSpoolDir)
         {
            rc = GplMemoryFree (pHandle->pszSpoolDir);
            assertT (rc);
         }

         if (pHandle->pszDocumentName)
         {
            rc = GplMemoryFree (pHandle->pszDocumentName);
            assertT (rc);
         }

         if (pHandle->pszLogAddress)
         {
            rc = GplMemoryFree (pHandle->pszLogAddress);
            assertT (rc);
         }

         if (!fReAllocate)
         {
            // Free our handle
            rc = GplMemoryFree (pHandle);
            assertT (rc);
         }
      }

      rc = TRUE;
      break;
   }

   case DEVICE_QUERY_FUNCTIONS:
   {
      PFNSUBCLASS pfnSub = (PFNSUBCLASS)pvArg1;
      ULONG       ulODType;
      ULONG       ulDataType;
      BOOL        fOmniGenerated;

      pHandle        = (PTIFFHANDLE)va_arg (list, PTIFFHANDLE);
      ulODType       = (ULONG)va_arg (list, ULONG);
      ulDataType     = (ULONG)va_arg (list, ULONG);
      fOmniGenerated = (BOOL)va_arg (list, BOOL);

#ifdef DEBUG
      switch (ulODType)
      {
      case OD_DIRECT: DBPRINTF (("OD_DIRECT\n")); break;
      case OD_QUEUED: DBPRINTF (("OD_QUEUED\n")); break;
      }
      switch (ulDataType)
      {
      case PM_Q_STD: DBPRINTF (("PM_Q_STD\n")); break;
      case PM_Q_RAW: DBPRINTF (("PM_Q_RAW\n")); break;
      }

      if (fOmniGenerated)
      {
         DBPRINTF (("Omni generated job!\n"));
      }
      else
      {
         DBPRINTF (("Not an Omni generated job!\n"));
      }
#endif

      /* Is this phase #2 of the job and is the job already in device-specific
      ** format?  (That is a TIFF file)
      */
      if (  OD_DIRECT == ulODType
         && fOmniGenerated        )
      {
         pHandle->fLeaveAlone = TRUE;
         break;
      }

      pfnSub->pfnDeviceOpen  = TIFFPreOpenFile;
      pfnSub->pfnDeviceClose = TIFFCloseFile;

      // First, determine if we need to create a device-specific datastream.
      // If so, hook functions that subnclass Spl calls
      if (  !pddc->pdb->fRawOnly
         && ((OD_DIRECT == ulODType)
         || (  (OD_QUEUED == ulODType)
            && (PM_Q_RAW  == ulDataType) ) ) )
      {
         pfnSub->pfnSpoolerOpen     = TIFFSpoolerOpen;
         pfnSub->pfnSpoolerClose    = TIFFSpoolerClose;
         pfnSub->pfnSpoolerStartJob = TIFFSpoolerStartJob;
         pfnSub->pfnSpoolerEndJob   = TIFFSpoolerEndJob;
      }

      rc = TRUE;
      break;
   }

   default:
      rc = FALSE;
      break;
   }

   va_end (list);

   return rc;

} /* end TIFFDeviceQuery */

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
VOID
TiffFillInPDL (PPDL   pPDL,
               ULONG  ulDeviceID)
{
   pPDL->ulPDL                         = PDL_TIFF;
   pPDL->ulPDLLevel                    = PDL_DONTCARE;
   pPDL->ulMajorPDLVersion             = PDL_DONTCARE;
   pPDL->ulMinorPDLVersion             = PDL_DONTCARE;
   pPDL->szMinorCharID[0]              = '\0';
   pPDL->ulReserved                    = 0;
   pPDL->ulFlags                       = PDLCAPS_CURRENT | PDLCAPS_MACROSUPPORT;
   pPDL->szPDLDescription[0]           = '\0';
   pPDL->szTranslatedPDLDescription[0] = '\0';
}

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
BOOL
TiffQueryPDL (ULONG  ulType,
              PPDL   pPDL,
              ULONG  ulDeviceID,
              ...)
{
   va_list          list;

   va_start (list, ulDeviceID);

   switch (ulType)
   {
   case QUERYPDL_QUERY_NUMBER:
   {
      ULONG *pulNumPDLs = va_arg (list, ULONG *);

      *pulNumPDLs = 1;

      return TRUE;
   }

   case QUERYPDL_QUERY_PDL:
   {
//////ULONG ulSubPDL = va_arg (list, ULONG);

      TiffFillInPDL (pPDL, ulDeviceID);

      return TRUE;
   }

   case QUERYPDL_ISOK_PDL:
   {
      PDL   MyPDL;

      TiffFillInPDL (&MyPDL, ulDeviceID);

      if (MyPDL.ulPDL             == pPDL->ulPDL                 &&
          MyPDL.ulMajorPDLVersion == pPDL->ulMajorPDLVersion     &&
          MyPDL.ulMinorPDLVersion == pPDL->ulMinorPDLVersion     &&
          0 == strcmp (MyPDL.szMinorCharID, pPDL->szMinorCharID) &&
          MyPDL.ulReserved        == pPDL->ulReserved            &&
          MyPDL.ulFlags           == pPDL->ulFlags                )
      {
         return TRUE;
      }
      else
      {
         return FALSE;
      }
   }
   }

   va_end (list);

   return FALSE;
}

/****************************************************************************/
/* FUNCTION       : GplTIFFRasterizeOutput()                                */
/* AUTHOR         : WMJ                                                     */
/* DATE WRITTEN   : 07/18/95                                                */
/* DESCRIPTION    : Outputs Bitmap - either shadow DC or Device Surface     */
/*                  to the printer.  Performs compression of data           */
/*                  according to Tiff Algorithnm 6 specifications           */
/*                                                                          */
/* PARAMETERS: pbBits = pointer to bitmap data  (input)                     */
/*             pbmi   = pointer to bitmap info 2 header  (input)            */
/*             psizelBuffer = pointer describes shadow DC or Device Surface */
/*                            dimensions. (input)                           */
/*             pretlPageLocation - describes page dimensions (input)        */
/*             pvDDC = pointer to Device Drawing Context                    */
/*                                                                          */
/* RETURN VALUES:   0 = ok, !0 = error                                      */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL _System
GplTIFFMonoRasterize (PBYTE             pbBits,
                      PBITMAPINFO2      pbmi,
                      PSIZEL            psizelBuffer,
                      PSIZEL            psizelPage,
                      PRECTL            prectlPageLocation,
                      PVOID             pvHandle,
                      PVOID             pvDDC)
{
   static BYTE     bMask[8] = { 0xFF, 0x80, 0xC0, 0xE0,
                                0xF0, 0xF8, 0xFC, 0xFE };
   PDDC            pddc     = (PDDC)pvDDC;
   PTIFFHANDLE     pHandle  = (PTIFFHANDLE)pvHandle;
   PBYTE           pbBuffer, pbZeroBuffer;
   INT             iWorldY;
   INT             iRemainder;
   ULONG           cy, cx;
   INT             iAmount;
   register INT    iCurrentRow;


   if (ORIENTATION_PORTRAIT == pddc->pdb->pJobProperties->ulOrientation)
   {
      cy = min (psizelBuffer->cy, prectlPageLocation->yTop - prectlPageLocation->yBottom + 1);
      cx = min (psizelBuffer->cx, prectlPageLocation->xRight - prectlPageLocation->xLeft + 1);
      iWorldY = prectlPageLocation->yTop;
   }
   else
   {
      cy = min (psizelBuffer->cy, prectlPageLocation->xRight - prectlPageLocation->xLeft + 1);
      cx = min (psizelBuffer->cx, prectlPageLocation->yTop - prectlPageLocation->yBottom + 1);
      iWorldY = prectlPageLocation->xRight;
   }

   // We want to keep iRemainder of the left-most bits of the last
   // byte. (NOTE: 0 <= iRemainder <= 7)
   iRemainder = cx - (pHandle->iNumDestRowBytes - 1) * 8;
   if (8 == iRemainder)
      iRemainder = 0;
   assertF (0 <= iRemainder && iRemainder <= 7);

   // check to see if we need to move for the start of the band
   // iAmount is the amount to move down the page
   iAmount = pddc->ptlPrintHead.y - iWorldY;

   if (iAmount > 0)    // Output BlankLines preceding raster data
   {
      // undate physical print head because we will move here
      pddc->ptlPrintHead.y -= iAmount ;

      // TIFF Output for start of page - mjones

      pbZeroBuffer = (PBYTE)GplMemoryAlloc (pHandle->hmcbHeap,
                                            pHandle->iNumSrcRowBytes32 * 4);
      assertF (pbZeroBuffer);
      if (!pbZeroBuffer)
         return FALSE;

      memset (pbZeroBuffer, 0, pHandle->iNumSrcRowBytes32 * 4);

      pHandle->iSrcRow += iAmount;

      while (iAmount--)
      {
         switch (pddc->pdb->pPrintMode->ulPrintModeID)
         {
         case TIFF_RES_ID_CCITT_1D:
            GplFaxTIFF2EncodeBlock ((PVOID)pHandle,
                                    pHandle->pbOutput,
                                    pHandle->ulOutputSize,
                                    &(pHandle->ulBitposition),
                                    pbZeroBuffer,
                                    pHandle->iSrcRowPels,
                                    1,
                                    TiffFlushBuffer);
            break;

         case TIFF_RES_ID_GROUP_3:
            GplFaxG3EncodeBlock ((PVOID)pHandle,
                                 pHandle->pbOutput,
                                 pHandle->ulOutputSize,
                                 &(pHandle->ulBitposition),
                                 pbZeroBuffer,
                                 pHandle->iSrcRowPels,
                                 1,
                                 TiffFlushBuffer);
            break;

         case TIFF_RES_ID_GROUP_4:
            GplFaxG4EncodeBlock ((PVOID)pHandle,
                                 pHandle->pbOutput,
                                 pHandle->ulOutputSize,
                                 &(pHandle->ulBitposition),
                                 pbZeroBuffer,
                                 pHandle->iSrcRowPels,
                                 1,
                                 TiffFlushBuffer,
                                 pHandle->pulbstartc,
                                 pHandle->pulwstartc,
                                 pHandle->pulbstartp,
                                 pHandle->pulwstartp,
                                 0);
            break;
         }
      }

      GplMemoryFree (pbZeroBuffer);
   }

   for (iCurrentRow = psizelBuffer->cy - 1; iCurrentRow >= (INT)(psizelBuffer->cy - cy); iCurrentRow--)
   {
      // Copy raster bits into our buffer
      pbBuffer = pbBits + iCurrentRow * pHandle->iNumSrcRowBytes32;

      // Make sure that the extraneous bits are set to 0.
      if (iRemainder)
         *(pbBuffer + pHandle->iNumDestRowBytes - 1) &= bMask[iRemainder];

      switch (pddc->pdb->pPrintMode->ulPrintModeID)
      {
      case TIFF_RES_ID_CCITT_1D:
         GplFaxTIFF2EncodeBlock ((PVOID)pHandle,
                                 pHandle->pbOutput,
                                 pHandle->ulOutputSize,
                                 &(pHandle->ulBitposition),
                                 pbBuffer,
                                 pHandle->iSrcRowPels,
                                 1,
                                 TiffFlushBuffer);
         break;

      case TIFF_RES_ID_GROUP_3:
         GplFaxG3EncodeBlock ((PVOID)pHandle,
                              pHandle->pbOutput,
                              pHandle->ulOutputSize,
                              &(pHandle->ulBitposition),
                              pbBuffer,
                              pHandle->iSrcRowPels,
                              1,
                              TiffFlushBuffer);
         break;

      case TIFF_RES_ID_GROUP_4:
         GplFaxG4EncodeBlock ((PVOID)pHandle,
                              pHandle->pbOutput,
                              pHandle->ulOutputSize,
                              &(pHandle->ulBitposition),
                              pbBuffer,
                              pHandle->iSrcRowPels,
                              1,
                              TiffFlushBuffer,
                              pHandle->pulbstartc,
                              pHandle->pulwstartc,
                              pHandle->pulbstartp,
                              pHandle->pulwstartp,
                              0);
         break;
      }
   }

   pHandle->iSrcRow += cy;

   // Update current position by number of scan lines printed
   pddc->ptlPrintHead.y -= cy;  // Update physical print head at end

   return TRUE;

} /* end GplTIFFMonoRasterize */

/****************************************************************************/
/* PROCEDURE NAME : TIFFChooseRasterize                                     */
/* AUTHOR         : Matt Rutkowski & Tom Spurrier                           */
/* DATE WRITTEN   : 8/1/94                                                  */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* 11/11/94 - Matt Rutkowski - rewrote                                      */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
BOOL _System
TIFFChooseRasterize (PBYTE            pbBits,
                     PBITMAPINFO2     pbmi,
                     PSIZEL           psizelBuffer,
                     PSIZEL           psizelPage,
                     PRECTL           prectlPageLocation,
                     PVOID            pvHandle,
                     PVOID            pvDDC)
{
   PDDC pddc = (PDDC) pvDDC;                                       

   GplBookletResetOutput (pddc->pdb->hThread); 

   GplTIFFMonoRasterize (pbBits,
                         pbmi,
                         psizelBuffer,
                         psizelPage,
                         prectlPageLocation,
                         pvHandle,
                         pvDDC);

   return FALSE;

} /* end TIFFChooseRasterize */

// ****************************************************************************
// * MEMORY TABLES
// ****************************************************************************

// Define all Memory types used by all TIFF models
MEMORYINFO TIFFMemory =
{
   MEMORY_FIXED_SIZE,   // ulMemFlags;
   0,                   // ulBase;
   0,                   // ulMaximum;
   0                    // ulIncrement;
};

// ****************************************************************************
// * PRINT QUALITY TABLES
// ****************************************************************************
// @TBD -  use name IDs NOT _STRING_ names

// Define all Print Qualities used by all TIFF models
RESINFO TIFF_pRes[] =
{
   {
      TIFF_RES_ID_FINE,              // ulResID;
      RES_STRING_FINE,               // ulNameID;
      "",                            // szResName[32];
      204,                           // ulXRes;
      196,                           // ulYRes;
      0,                             // usCmdLength;
      _NUL_,                         // szCmdSelectRes[32];
      17,                            // ulGamma
      0,                             // ulBias
      0,                             // usPrintMethod;
      0,                             // usNumPhysicalPins;
      0,                             // bAdjacentDotPrinting;
      1,                             // usDotsPerColumn;
      0,                             // usBytesPerColumn;
      0,                             // usLenLineSpacing;
      _NUL_,                         // szCmdLineSpacing[8];
      0,                             // ulUnitsLineSpacing;
      0,                             // usLenVerticalDensity;
      _NUL_,                         // szCmdVerticalDensity[8];
      0                              // ulUnitsVerticalDensity;
   }
,
   {
      TIFF_RES_ID_NORMAL,            // ulResID;
      RES_STRING_NORMAL,             // ulNameID;
      "",                            // szResName[32];
      102,                           // ulXRes;
       98,                           // ulYRes;
      0,                             // usCmdLength;
      _NUL_,                         // szCmdSelectRes[32];
      25,                            // ulGamma
      0,                             // ulBias
      0,                             // usPrintMethod;
      0,                             // usNumPhysicalPins;
      0,                             // bAdjacentDotPrinting;
      1,                             // usDotsPerColumn;
      0,                             // usBytesPerColumn;
      0,                             // usLenLineSpacing;
      _NUL_,                         // szCmdLineSpacing[8];
      0,                             // ulUnitsLineSpacing;
      0,                             // usLenVerticalDensity;
      _NUL_,                         // szCmdVerticalDensity[8];
      0                              // ulUnitsVerticalDensity;
   }
};

#define TIFF_DEFINED_RESOLUTIONS  (sizeof (TIFF_pRes)/sizeof (TIFF_pRes[0]))

//****************************************************************************
//* PRINT MODE TABLES
//****************************************************************************
PRINTMODE TIFF_pPrintModes[] =
{
   {
      TIFF_RES_ID_GROUP_4,            // ulPrintModeID;
      COLOR_TECH_K,                   // ulColorTech;
      PRINT_MODE_STRING_GROUP_4,      // ulNameID;
      "",                             // szPrintMode[32];
      1,                              // usBitsPerPel;   // Physical bit count
      8,                              // usLogBitCount;  // Logical  bit count
      1,                              // usNumPlanes;    // # color planes (always 1 for OS/2)
      0                               // ulDither;       // default Dither Alg. (e.g. pattern/scatter)
   }
,
   {
      TIFF_RES_ID_GROUP_3,            // ulPrintModeID;
      COLOR_TECH_K,                   // ulColorTech;
      PRINT_MODE_STRING_GROUP_3,      // ulNameID;
      "",                             // szPrintMode[32];
      1,                              // usBitsPerPel;   // Physical bit count
      8,                              // usLogBitCount;  // Logical  bit count
      1,                              // usNumPlanes;    // # color planes (always 1 for OS/2)
      0                               // ulDither;       // default Dither Alg. (e.g. pattern/scatter)
   }
,
   {
      TIFF_RES_ID_CCITT_1D,           // ulPrintModeID;
      COLOR_TECH_K,                   // ulColorTech;
      PRINT_MODE_STRING_CCITT_1D,     // ulNameID;      @181074
      "",                             // szPrintMode[32];
      1,                              // usBitsPerPel;   // Physical bit count
      8,                              // usLogBitCount;  // Logical  bit count
      1,                              // usNumPlanes;    // # color planes (always 1 for OS/2)
      0                               // ulDither;       // default Dither Alg. (e.g. pattern/scatter)
   }
}; /* end Print Modes */

#define TIFF_DEFINED_PRINT_MODES       (sizeof (TIFF_pPrintModes)/sizeof (TIFF_pPrintModes[0]))

//****************************************************************************
//* FONT DEFINITION TABLES
//****************************************************************************

#define TIFF_DEFINED_FONTS             0
#define TIFF_SUPPORTED_FONTS           0

//****************************************************************************
//* TRAY DEFINITION TABLES
//****************************************************************************
// @TBD -  use name IDs NOT _STRING_ names

// Define all Trays used by all TIFF models
TRAYINFO TIFF_pTrays[] =
{
   {
      TIFF_TRAY_ID_NOSELECT,                   // ulTrayID;
      TRAY_NONE,                               // ulTrayCap;
      DJP_TRY_AUTO,                            // ulDJPid;
      TRAY_STRING_NONE,                        // ulNameID;
      "",                                      // pszTrayName;
      TRAY_TYPE_AUTO,                          // ulTrayType
      0,                                       // ulCmdSelectTray;
      "",                                      // szCmdSelectTray;
      0,                                       // ulCompatibleForms;
      (PULONG)NULL                             // pulCompatibleForms;
   }
};

#define TIFF_DEFINED_TRAYS             (sizeof (TIFF_pTrays)/sizeof (TIFF_pTrays[0]))

ULONG TIFF_CLASS_pulTrays[] = {
        TIFF_TRAY_ID_NOSELECT
};
#define TIFF_CLASS_SUPPORTED_TRAYS   (sizeof (TIFF_CLASS_pulTrays)/sizeof (TIFF_CLASS_pulTrays[0]))

FORMINFO2 TIFF_pForms_1[] =
{
   {
      TIFF_FORM_ID_LETTER_1,      // ulFormID;
      FORM_LETTER,                // ulFormCap;
      DJP_PSI_LETTER,             // DJP_SJ_PAPERSIZE id
      FORM_CLASS_OTHER,           // ulFormClass;
      FORM_STRING_LETTER,         // ulNameID;
      0,                          // usLenCmdSelectForm;
      _NUL_,                      // szCmdSelectForm[LEN_CMD];
      {                           // hcInfo
           "",                    // szFormname[32] optional
        21590,                    // cx; (mm)
        27940,                    // cy; (mm)
           38,                    // xLeftClip; (mm)
            6,                    // yBottomClip; (mm)
        21590-37,                 // xRightClip; (mm)
        27940-6,                  // yTopClip; (mm)
            0,                    // xPels; (pels)
            0,                    // yPels; (pels)
            0                     // flAttributes;
      }, /* end logical block */
      FALSE                       // bHasBeenSetup;
   }
,
   {
      TIFF_FORM_ID_LEGAL_1,       // ulFormID;
      FORM_LEGAL,                 // ulFormCap;
      DJP_PSI_LEGAL,              // DJP_SJ_PAPERSIZE id
      FORM_CLASS_OTHER,           // ulFormClass;
      FORM_STRING_LEGAL,          // ulNameID;
      0,                          // usLenCmdSelectForm;
      _NUL_,                      // szCmdSelectForm[LEN_CMD];
      {                           // hcInfo
        "",                       // szFormname[32]
        21590,                    // cx; (mm)
        35560,                    // cy; (mm)
        630,                      // xLeftClip; (mm)
        1440,                     // yBottomClip; (mm)
        21590-630,                // xRightClip; (mm)
        35560-260,                // yTopClip; (mm)
        0,                        // xPels; (pels)
        0,                        // yPels; (pels)
        0                         // flAttributes;
      }, /* end logical block */
      FALSE                       // bHasBeenSetup;
   }
,
   {
      TIFF_FORM_ID_A4_1,          // ulFormID;
      FORM_A4,                    // ulFormCap;
      DJP_PSI_A4,                 // DJP_SJ_PAPERSIZE id
      FORM_CLASS_OTHER,           // ulFormClass;
      FORM_STRING_A4,             // ulNameID;
      0,                          // usLenCmdSelectForm;
      _NUL_,                      // szCmdSelectForm[LEN_CMD];
      {                           // hcInfo
        "",                       // szFormname[32] optional
        21000,                    // cx; (mm)
        29690,                    // cy; (mm)
        310,                      // xLeftClip; (mm)
        1440,                     // yBottomClip; (mm)
        21000-370,                // xRightClip; (mm)
        29690-260,                // yTopClip; (mm)
        0,                        // xPels; (pels)
        0,                        // yPels; (pels)
        0                         // flAttributes;
      },
      FALSE                       // bHasBeenSetup;
   }
};
#define TIFF_DEFINED_FORMS_1    (sizeof (TIFF_pForms_1)/sizeof (TIFF_pForms_1[0]))

//****************************************************************************
//* MEDIA DEFINITION TABLES
//****************************************************************************

MEDIAINFO TIFF_pMedias[] =
{
   {
      TIFF_MEDIA_ID_PLAIN,          // ulMediaID;
      MEDIA_TYPE_PLAIN,             // ulMediaCap;
      DJP_MED_PLAIN,                // DJP_SJ_MEDIA id
      MEDIA_STRING_PLAIN,           // ulNameID;
      "",                           // szMediaName[LEN_MEDIANAME];
      0,                            // ulCmdSelectMedia
      _NUL_,                        // szMediaTypeCmd;
      FALSE,                        // ulColorAdjustRequired
      NO_ABSORPTION                 // ulAbsorptionAdjust
   } /* end Plain */
}; /* end Medias */
#define TIFF_DEFINED_MEDIAS  (sizeof (TIFF_pMedias)/sizeof (TIFF_pMedias[0]))

//****************************************************************************
//* FORM CONNECTION TABLES
//****************************************************************************
FORMCONNECTION TIFF_pConnects[] =
{
   { CONN_ID_1, TIFF_TRAY_ID_NOSELECT, TIFF_FORM_ID_LETTER_1,  TIFF_MEDIA_ID_PLAIN },
   { CONN_ID_2, TIFF_TRAY_ID_NOSELECT, TIFF_FORM_ID_LEGAL_1,   TIFF_MEDIA_ID_PLAIN },
   { CONN_ID_3, TIFF_TRAY_ID_NOSELECT, TIFF_FORM_ID_A4_1,      TIFF_MEDIA_ID_PLAIN }
}; /* end Connects */
#define TIFF_DEFINED_CONNECTIONS     (sizeof (TIFF_pConnects)/sizeof (TIFF_pConnects[0]))

//****************************************************************************
//* FEATURE SUPPORT
//****************************************************************************
FEATUREINFO TIFF_Features =
{
   FALSE,               // bSupUserDefTrays;
   TRUE,                // bSupUserDefForms;
   FALSE,               // bSupUserDefFonts;
   TRUE                 // bSupUserDefConnects;
}; /* end TIFF_Features */

// Subclassed functions for TIFF Driver
FNSUBCLASS TIFF_Sub_Functions =
{
   TIFFBeginJob,           // pfnInitJob;
   TIFFChooseRasterize,    // pfnRasterizeBand;
   TIFFNewFrame,           // pfnNextPage;
   TIFFEndJob,             // pfnTermJob;
   TIFFAbortJob,           // pfnAbortJob;
   TIFFDeviceQuery,        // pfnDeviceQuery;
   NULL,                   // pfnQueryFonts;
   TIFFOpenFile,           // pfnDeviceOpen;
   TIFFCloseFile,          // pfnDeviceClose;
   TIFFWriteFile,          // pfnDeviceWrite;
   TIFFSpoolerOpen,        // pfnSpoolerOpen;
   TIFFSpoolerStartJob,    // pfnSpoolerStartJob;
   TIFFSpoolerEndJob,      // pfnSpoolerEndJob;
   TIFFSpoolerClose,       // pfnSpoolerClose;
   (PFNBANDINGSUPPORT)NULL,// pfnBandingSupport;
   TiffQueryPDL            // pfnQueryPDL;
}; /* end TIFF_Sub_Functions */

//****************************************************************************
//*
//*               S U P P O R T E D      F E A T U R E S
//*
//****************************************************************************
//*
//*  The following arrays contain IDs that reference tables defined above
//*  for the following features:
//*
//*         PRINT QUALITIES (e.g. resolutions)
//*         PRINT MODES     (e.g. color/mono)
//*         DEVICE FONTS
//*         PAPER TRAYS
//*         FORM SIZES
//*         MEDIA TYPES
//*         FORM CONNECTIONS (tray/form size/media type)
//*
//* NOTE: first value in array is default value for device
//****************************************************************************

//****************************************************************************
//* PRINT QUALITIES SUPPORTED (by device)
//****************************************************************************
ULONG TIFF_pulResolutions[] = {
           TIFF_RES_ID_FINE,
           TIFF_RES_ID_NORMAL
};
#define TIFF_SUPPORTED_RESOLUTIONS     (sizeof (TIFF_pulResolutions)/sizeof (TIFF_pulResolutions[0]))

//****************************************************************************
//* PRINT MODES SUPPORTED (by device)
//****************************************************************************

ULONG TIFF_pulPrintModes_K[] = {
          TIFF_RES_ID_GROUP_4,
          TIFF_RES_ID_GROUP_3,
          TIFF_RES_ID_CCITT_1D
};

#define TIFF_SUPPORTED_PRINT_MODES_K (sizeof (TIFF_pulPrintModes_K)/sizeof (TIFF_pulPrintModes_K[0]))

//****************************************************************************
//* MEDIA TYPES SUPPORTED (by device)
//****************************************************************************

ULONG TIFF_pulMedias[] = {
          TIFF_MEDIA_ID_PLAIN
};

#define TIFF_SUPPORTED_MEDIAS (sizeof (TIFF_pulMedias)/sizeof (TIFF_pulMedias[0]))

/**************************************************************************
*                                                                         *
*                        C O N N E C T I O N S                            *
*                                                                         *
**************************************************************************/

ULONG TIFF_pulConnects[] = {
           CONN_ID_1,
           CONN_ID_2,
           CONN_ID_3
};
#define TIFF_SUPPORTED_CONNECTIONS   (sizeof (TIFF_pulConnects)/sizeof (TIFF_pulConnects[0]))

USERDEFDATA TIFF_UserData =
{
   FALSE, // BOOL             bTraysInit;
   0,     // USHORT           usNumTrays;
   NULL,  // PUSERTRAY        pUserTRAYS;
   NULL,  // PUSERTRAY        pLastUserTRAYS;
   FALSE, // BOOL             bFormsInit;
   0,     // USHORT           usNumForms;
   NULL,  // PUSERFORM        pUserFORMS;
   NULL,  // PUSERFORM        pLastUserFORMS;
   FALSE, // BOOL             bConnsInit;
   0,     // USHORT           usNumConnects;
   NULL,  // PUSERCONNECT     pUserCONNECTS;
   NULL,  // PUSERCONNECT     pLastUserCONNECTS;
   FALSE, // BOOL             bFontsInit;
   0,     // USHORT           usNumFonts;
   NULL,  // PUSERFONT        pUserFONTS;
   NULL   // PUSERFONT        pLastUserFONTS;
};

DEVICEINFO TIFF_pDevices[] =
{
   {
      PRN_ID_TIFF_MONOCHROME,
      "TIFF Monochrome",                            // pszDeviceName;
      "TIFF Monochrome",                            // pszDeviceDesc;
      "IBM",                                        // pszDeviceVendor;
      1,                                            // usDeviceMajorVersion;
      0,                                            // usDeviceMinorVersion;
      CAPS_TECH_RASTER_PRINTER,                     // ulOS2DeviceTechnology;
      OMNI_CAP_MONO | OMNI_CAP_MIRROR,              // ulOmniDeviceTechnology;
      DEV_FUNC_RASTER,                              // ulDeviceFunctions;
      RASTER_TOP_TO_BOTTOM,                         // Raster info
      0,                                            // ulDeviceBits
      GPLCOMPRESS_NONE,                             // Compression supported
      &TIFFMemory,                                  // pMemory;
      NULL,                                         // pCommands;
      &TIFF_Sub_Functions,                          // pSubclassedFunctions;
      &TIFF_Features,                               // pFeatures;
      TIFF_SUPPORTED_RESOLUTIONS,                   // usNumRes;
      TIFF_pulResolutions,                          // pulRES;
      TIFF_SUPPORTED_FONTS,                         // usNumFonts;
      NULL,                                         // pFONTS;
      TIFF_CLASS_SUPPORTED_TRAYS,                   // usNumTrays;
      TIFF_CLASS_pulTrays,                          // pTRAYS;
      TIFF_DEFINED_FORMS_1,                         // ulNumForms;
      TIFF_pForms_1,                                // pFORMS;
      TIFF_SUPPORTED_MEDIAS,                        // ulNumMedias;
      TIFF_pulMedias,                               // pulMedias;
      NULL,                                         // pInkInfo;
      TIFF_SUPPORTED_CONNECTIONS,                   // usNumConnects;
      TIFF_pulConnects,                             // pConnects;
      TIFF_SUPPORTED_PRINT_MODES_K,
      TIFF_pulPrintModes_K,
      0,                                            // ulNumModifiers;
      (PTRIPLETMODIFIERS)NULL,                      // pTripletModifiers;
      &TIFF_UserData,
      {
         0,                                         // cb        ***IGNORED***
         {0},                                       // achDriver ***IGNORED***
         0,                                         // ulSig     ***IGNORED***
         ORIENTATION_PORTRAIT,                      // ulOrientation
         1,                                         // cCopies
         CONN_ID_3,                                 // ulDefConnID
         CONN_ID_1,                                 // ulDefNonMetricConnID;
         FONT_ID_COURIER,                           // ulDefFontID
         TIFF_RES_ID_FINE,                          // ulDefResID
         TIFF_RES_ID_GROUP_3,                       // ulDefPrintModeID
         GPLCOMPRESS_NONE,                          // Compression supported
         COLOR_BLACK,                               // usForeground = COLOR_BACK
         COLOR_WHITE,                               // usBackground = COLOR_WHITE
         0,                                         // OR options together
         HT_MAGIC_SQUARES,                          // Half Tone Snap as default
         127,                                       // Default 127 for HT_LEVEL HaftTone Algorithm
         0,                                         // lHue;         // % deviation along circle
         0,                                         // lSaturation;  // % deviation along radius
         0,                                         // lValue;       // % deviation darkness value
         0,                                         // lDarkness;    // % deviation darkness value
         FF_CTL_NONE,                               // bFFControlType
         0,                                         // ulJobPhaseControl
         0,                                         // ulClrGamma;
         0                                          // ulClrBias;
      }
   } /* end Tiff Monochrome Device */
#ifdef SAM_DETWEILER
,
   {
      PRN_ID_TIFF_SAM_D,
      "Sam D's TIFF Monochrome",                    // pszDeviceName;
      "Sam D's TIFF Monochrome",                    // pszDeviceDesc;
      "IBM",                                        // pszDeviceVendor;
      1,                                            // usDeviceMajorVersion;
      0,                                            // usDeviceMinorVersion;
      CAPS_TECH_RASTER_PRINTER,                     // ulOS2DeviceTechnology;
      OMNI_CAP_MONO | OMNI_CAP_MIRROR,              // ulOmniDeviceTechnology;
      DEV_FUNC_RASTER,                              // ulDeviceFunctions;
      RASTER_TOP_TO_BOTTOM,                         // Raster info
      0,                                            // ulDeviceBits
      GPLCOMPRESS_NONE,                             // Compression supported
      &TIFFMemory,                                  // pMemory;
      NULL,                                         // pCommands;
      &TIFF_Sub_Functions,                          // pSubclassedFunctions;
      &TIFF_Features,                               // pFeatures;
      TIFF_SUPPORTED_RESOLUTIONS,                   // usNumRes;
      TIFF_pulResolutions,                          // pulRES;
      TIFF_SUPPORTED_FONTS,                         // usNumFonts;
      NULL,                                         // pFONTS;
      TIFF_CLASS_SUPPORTED_TRAYS,                   // usNumTrays;
      TIFF_CLASS_pulTrays,                          // pTRAYS;
      TIFF_DEFINED_FORMS_1,                         // ulNumForms;
      TIFF_pForms_1,                                // pFORMS;
      TIFF_SUPPORTED_MEDIAS,                        // ulNumMedias;
      TIFF_pulMedias,                               // pulMedias;
      NULL,                                         // pInkInfo;
      TIFF_SUPPORTED_CONNECTIONS,                   // usNumConnects;
      TIFF_pulConnects,                             // pConnects;
      TIFF_SUPPORTED_PRINT_MODES_K,
      TIFF_pulPrintModes_K,
      0,                                            // ulNumModifiers;
      (PTRIPLETMODIFIERS)NULL,                      // pTripletModifiers;
      &TIFF_UserData,
      {
         0,                                         // cb        ***IGNORED***
         {0},                                       // achDriver ***IGNORED***
         0,                                         // ulSig     ***IGNORED***
         ORIENTATION_PORTRAIT,                      // ulOrientation
         1,                                         // cCopies
         CONN_ID_3,                                 // ulDefConnID
         CONN_ID_1,                                 // ulDefNonMetricConnID;
         FONT_ID_COURIER,                           // ulDefFontID
         TIFF_RES_ID_FINE,                          // ulDefResID
         TIFF_RES_ID_GROUP_3,                       // ulDefPrintModeID
         GPLCOMPRESS_NONE,                          // Compression supported
         COLOR_BLACK,                               // usForeground = COLOR_BACK
         COLOR_WHITE,                               // usBackground = COLOR_WHITE
         0,                                         // OR options together
         HT_MAGIC_SQUARES,                          // Half Tone Snap as default
         127,                                       // Default 127 for HT_LEVEL HaftTone Algorithm
         0,                                         // lHue;         // % deviation along circle
         0,                                         // lSaturation;  // % deviation along radius
         0,                                         // lValue;       // % deviation darkness value
         0,                                         // lDarkness;    // % deviation darkness value
         FF_CTL_NONE,                               // bFFControlType
         0,                                         // ulJobPhaseControl
         0,                                         // ulClrGamma;
         0                                          // ulClrBias;
      }
   } /* end Sam D's Tiff Monochrome Device */
#endif
}; /* end TIFF_pDevices block */

#define TIFF_SUPPORTED_DEVICES         (sizeof (TIFF_pDevices)/sizeof (TIFF_pDevices[0]))

#ifndef DLLBLD
   DRIVERINFO pTIFFDriver[] =
#else
   ULONG NumberOfDevices = TIFF_SUPPORTED_DEVICES;
   DRIVERINFO pDRIVERDATA[] =
#endif
{
   {
      "TIFF Driver",                   // pszDriverName;
      "IBM",                           // pszDriverVendor;
      0x0210,                          // usDriverVersion;
      TIFF_DEFINED_RESOLUTIONS,        // usNumRes;
      TIFF_pRes,                       // pRES;
      TIFF_DEFINED_FONTS,              // usNumFonts;
      NULL,                            // pFONTS;
      TIFF_DEFINED_TRAYS,              // usNumTrays;
      TIFF_pTrays,                     // pTRAYS;
      TIFF_DEFINED_FORMS_1,            // usNumForms;
      TIFF_pForms_1,                   // pFORMS;
      TIFF_DEFINED_MEDIAS,             // ulNumMedias;
      TIFF_pMedias,                    // pMEDIAS;
      TIFF_DEFINED_CONNECTIONS,        // usNumConnects;
      TIFF_pConnects,                  // pCONNECTS;
      TIFF_DEFINED_PRINT_MODES,        // usNumPrintModes;
      TIFF_pPrintModes,                // pPrintModes;
      TIFF_SUPPORTED_DEVICES,          // usNumDevices;
      TIFF_pDevices,                   // pDEVICES;
      NULL                             // pGammaTables;
   } /* end logical block */
}; /* end Driver block */
