/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* FILENAME       : DEVICE.H                                                */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/*                  Mark Hamzy                                              */
/* DATE WRITTEN   : 9-16-93                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*--personal to-do list-----------------------------------------------------*/
/* 1) Add a way to allow font defs to have combinations of point/pitch      */
/*    sizes in single font definition record. Currently a separate record   */
/*    has to be created for each permutation of point/pitch                 */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
/* 12-28-94 TomS Cleaned up redundant defines and included <gpldith.h>      */
/*               Also added some strings for more dlg.c                     */
/*                                                                          */
/* @143445 - 11/9/95 - MattR - added new form/tray/medias for new Canon     */
/*                             printer models and DeskJet 340               */
/* @YYYYYY - 4/30/97 - RonE - added new defines for mirror image handling.  */
/*                            Defined the way the Media Capability field is */
/*                            being used.                                   */
/* @181074 - 6/10/97 - RonE - added new defines for NLV translation         */
/* @3677   - 6/24/98 - UCC [IBMJ]                                           */
/*                            added flag to support those printer need to   */
/*                            adjust hardcopy caps when sending in landscape*/
/* @EXJOB  - 7/13/98 - UCC [IBMJ]- Expansible job data support              */
/* @3729   - 7/13/98 - UCC [IBMJ]- Expansible job data support              */
/* jk1115  - november 1998 Janis Kisis - Color enhancement                  */
/*                                          support                         */
/* @HWCOLLATE 07/27/99 - UCC [IBMJ] - H/W collate support                   */
/*                                                                          */
/* @CONSTRAINTS  07/01/00  Add Constraints for Print Qualities, Print Modes */
/*                         and Dither Methods                               */
/****************************************************************************/

//****************************************************************************
// Omni Driver Structure Defines
//****************************************************************************

#define CONNECTION_TOKEN_BEGIN               '<'
#define CONNECTION_TOKEN_END                 '>'

// New Device font flags, we'll define here until they make public headers
// flags to tell GRE what clipping rules to follow for our device fonts
#ifndef DS_CLIP_100_RULE
   #define DS_CLIP_100_RULE                  0x00000000  // draw character if 100% is in clip rect
   #define DS_CLIP_66_RULE                   0x00040000  // draw character if 2/3 is in clip rect
   #define DS_CLIP_PRECISE_RULE              0x00080000  // presice clipping
#endif

// New Device font flags, we'll define here until they make public headers
// flag to tag one font per device as default for that device
#ifndef DEVFONT_DEFAULT
   // options for flOptions of DEVFONTMETRICS
   #define DEVFONT_DEFAULT                   0x00010000
#endif

// font orientation
#define FONT_ORIENT_PORTRAIT                 0
#define FONT_ORIENT_LANDSCAPE                1
#define FONT_ORIENT_BOTH                     2

// font sizing type
#define FONT_TYPE_ID_MASK                    0x0000FFFF   // Mask for the following IDs
#define FONT_TYPE_FIXED                      0
#define FONT_TYPE_PROPORTIONAL               1
#define FONT_TYPE_SCALABLE                   2            // Give to engine as scalable
#define FONT_TYPE_SCALABLE_SPECIAL           3            // Take scalable and make fixed from valPointSizes[]
#define FONT_TYPE_SCALABLE_SPECIAL2          4            // Take scalable and make fixed from ulTypeExtra

#define FONT_TYPE_FLAG_MASK                  0xFFFF0000   // Mask for the following flags
#define FONT_TYPE_DOWNLOADABLE               0x80000000

extern LONG valPointSizes[];

// font weights as defined in FONTMETRCS
#define FONT_WEIGHT_ULTRA_LIGHT              1000
#define FONT_WEIGHT_EXTRA_LIGHT              2000
#define FONT_WEIGHT_LIGHT                    3000
#define FONT_WEIGHT_SEMI_LIGHT               4000
#define FONT_WEIGHT_MEDIUM                   5000
#define FONT_WEIGHT_SEMI_BOLD                6000
#define FONT_WEIGHT_BOLD                     7000
#define FONT_WEIGHT_EXTRA_BOLD               8000
#define FONT_WEIGHT_ULTRA_BOLD               9000

// Font file/memory type
#define FONT_FILE_TYPE_MEMORY                0
#define FONT_FILE_TYPE_FOCAMETRICS           1
#define FONT_FILE_TYPE_TYPE1                 2
#define FONT_FILE_TYPE_TRUETYPE              3
#define FONT_FILE_TYPE_IFI                   4

// TRAY properties
#define TRAY_TYPE_AUTO                       0
#define TRAY_TYPE_MANUAL                     1

#define MAX_USER_DEF_ID                      320000

// Memory properties
#define MEMORY_FIXED_SIZE                    0
#define MEMORY_INSTALLABLE                   1

// Form Label Properties

// TBD:  split this out with other laserjet code...
// TBD: Move to laserjet.c !!!! - private defines
#define PCL4                                 0x80000000
#define PCL5                                 0x40000000
#define MODE1_COMPRESSION                    0x08000000
#define MODE2_COMPRESSION                    0x04000000
#define MODE3_COMPRESSION                    0x02000000
#define MODE5_COMPRESSION                    0x01000000
#define MODEALL_COMPRESSION                  0x0F000000

#define MIN_RGB_VALUE                        0
#define MID_RGB_VALUE                        127
#define MAX_RGB_VALUE                        255

#define MIN_PERCENTAGE                       0
#define MAX_PERCENTAGE                       100
#define MAX_GAMMA                            200

#define BASE_DEVIATION                       0
#define MIN_DEVIATION                       -50
#define MAX_DEVIATION                        50
#define MIN_DEGREE                          -180
#define MAX_DEGREE                           180

#define LEN_TRAYNAME                         32
#define LEN_RESNAME                          32
#define LEN_MEDIANAME                        32
#define LEN_MODENAME                         32
#define LEN_FONTNAME                         32
#define LEN_CMD                              44

// Job Properties: ulImageOption known bit masks
#define IMAGE_OPTION_MIRROR                  0x00000001
#define IMAGE_OPTION_MIRROR_MASK             0xFFFFFFFE
#define IMAGE_OPTION_NOMIRROR                0
#define IMAGE_OPTION_COLLATE                 0x00000002   

// Form Tech Capabilities (FORM_CAP_XXX)
#define FORM_CAP_NORMAL                      0x00000000
#define FORM_CAP_FF_TO_END                   0x80000000
// Reserve 0x000XXX00 for plugin use                      //@JPN2H99
// Some option controls can only be used with             //@JPN2H99
// restricted form size. Plug-ins can use this            //@JPN2H99
// field to check the validations.                        //@JPN2H99

// Standard Paper Sizes in Hundreths of a millimeter (for accuracy)
#define US_LETTER_WIDTH                      21590
#define US_LETTER_HEIGHT                     27940

#define LETTERP_WIDTH                        21590+1250
#define LETTERP_HEIGHT                       27940+5840

#define LEGAL_WIDTH                          21590
#define LEGAL_HEIGHT                         35560

#define EXECUTIVE_WIDTH                      18415
#define EXECUTIVE_HEIGHT                     26670

#define A2_WIDTH                             11110
#define A2_HEIGHT                            14600

#define A3_WIDTH                             29700               
#define A3_HEIGHT                            42000               
                                                                 
#define A3P_WIDTH                            33020               
#define A3P_HEIGHT                           48260               

#define A4_WIDTH                             21000
#define A4_HEIGHT                            29700

#define A4P_WIDTH                            21000+1350
#define A4P_HEIGHT                           29700+5860

#define A5_WIDTH                             14800
#define A5_HEIGHT                            21000

#define A6_WIDTH                             10500
#define A6_HEIGHT                            14800

#define B4_WIDTH                             25700               
#define B4_HEIGHT                            36400               
                                                                 
#define B5_WIDTH                             18200
#define B5_HEIGHT                            25700

// NOTE: Since envelopes feed landscape user need also
// select "landscape" orientation from job properties
// this is application dependent since some apps perform
// their own rotation.

// C5 dimens are based upon "landscape" feeding of envelopes
#define C5_WIDTH                             16200
#define C5_HEIGHT                            22900

// C6 dimens are based upon "landscape" feeding of envelopes
#define C6_WIDTH                             11400
#define C6_HEIGHT                            16200

// C7 dimens are based upon "landscape" feeding of envelopes
#define C7_WIDTH                              9840
#define C7_HEIGHT                            19050

// C9 dimens are based upon "landscape" feeding of envelopes
#define C9_WIDTH                              9840
#define C9_HEIGHT                            22540

// C10 dimens are based upon "landscape" feeding of envelopes
#define C10_WIDTH                            10470
#define C10_HEIGHT                           24130

// D5 dimens are based upon "landscape" feeding of envelopes
#define D5_WIDTH                             17600
#define D5_HEIGHT                            25000

// DL dimens are based upon "landscape" feeding of envelopes
#define DL_WIDTH                             11000
#define DL_HEIGHT                            22000

#define INDEX_3X5_WIDTH                       7620
#define INDEX_3X5_HEIGHT                     12700

#define INDEX_4X6_WIDTH                      10160
#define INDEX_4X6_HEIGHT                     15240

#define INDEX_5X8_WIDTH                      12700
#define INDEX_5X8_HEIGHT                     20320

#define HAGAKI_WIDTH                         10000
#define HAGAKI_HEIGHT                        14800

#define OFUKU_HAGAKI_WIDTH                   (5.83 * 2540)
#define OFUKU_HAGAKI_HEIGHT                  (7.87 * 2540)

#define KAKU_2_WIDTH                         24000
#define KAKU_2_HEIGHT                        33300

#define KAKU_3_WIDTH                         12000
#define KAKU_3_HEIGHT                        23500

#define KAKU_4_WIDTH                          9000
#define KAKU_4_HEIGHT                        20500

#define HP_GREETING_WIDTH                    (4.38 * 2540)
#define HP_GREETING_HEIGHT                   (6 * 2540)

#define CONT_15X11_WIDTH                     35600
#define CONT_15X11_HEIGHT                    27900

#define CONT_10X11_WIDTH                     22900
#define CONT_10X11_HEIGHT                    27900

#define LEDGER_WIDTH                         27940
#define LEDGER_HEIGHT                        43180

#define SUPER_B_WIDTH                        33020
#define SUPER_B_HEIGHT                       48260

#define TABLOID_WIDTH                       (11 * 2540)
#define TABLOID_HEIGHT                      (17 * 2540)

#define USFANFOLD_WIDTH                     (14.875 * 2540)
#define USFANFOLD_HEIGHT                    (11 * 2540)

#define FANFOLD1_WIDTH                      (11 * 2540)
#define FANFOLD1_HEIGHT                     (8.5 * 2540)

#define FANFOLD2_WIDTH                      (12 * 2540)
#define FANFOLD2_HEIGHT                     (8.5 * 2540)

#define FANFOLD3_WIDTH                      (9.5 * 2540)
#define FANFOLD3_HEIGHT                     (11 * 2540)

#define FANFOLD4_WIDTH                      (8.5 * 2540)
#define FANFOLD4_HEIGHT                     (12 * 2540)

#define FANFOLD5_WIDTH                      (8.5 * 2540)
#define FANFOLD5_HEIGHT                     (11 * 2540)

#define FANFOLD6_WIDTH                      (8.5 * 2540)
#define FANFOLD6_HEIGHT                     (13 * 2540)

#define STATEMENT_WIDTH                     (5.5 * 2540) // cx; (mm)
#define STATEMENT_HEIGHT                    (8.5 * 2540) // cy; (mm)

#define FABRIC_SIZE_WIDTH                   (9.488  * 2540) // cx; (mm)
#define FABRIC_SIZE_HEIGHT                  (14.015 * 2540) // cy; (mm)

#define ENV_132_220_WIDTH                   13200
#define ENV_132_220_HEIGHT                  22000

#define PHOTO_4_6_WIDTH                     (4 * 2540)
#define PHOTO_4_6_HEIGHT                    (6 * 2540)

#define PHOTO_100_150_WIDTH                 10000
#define PHOTO_100_150_HEIGHT                15000

#define PHOTO_200_300_WIDTH                 20000
#define PHOTO_200_300_HEIGHT                30000

#define PANORAMIC_WIDTH                     21000
#define PANORAMIC_HEIGHT                    59400

// Tray Tech Capabilities (TRAY_CAP_XXX)

// Media Tech Capabilities (MEDIA_CAP_XXX)       // @YYYYYY
/*  Originally when Mirror Image effects was set it would Mirror Image all
   media. The request to support a media to be imaged, caused the Mirror
   Imaging to change. The Media Capabilities field in MEDIAINFO was defined
   to be a flag field in the upper 24 bits and the bottom 8 bits to be indices
   for media type.

   Each digit has 1 Space

   This field is defined in the follwing format:

        0        1         2         3
        12345678901234567890123456789012
        ________________________________
        | Flag field for       ||Media |
        | defining special     ||Type  |
        | handling of Media    ||Index |
        |______________________||______|

     Example: MEDIA_TYPE_REQUIRES_INVERSE 0x80000000
              MEDIA_TYPE_PLAIN                     2

   The following table is a matrix of settings and appropriate results
   of the Mirror Image bit and the Media Inverse flag:

        __________________________________________________________
        |  Mirror Image Effect  |  Media Inverse |    Result     |
        |-----------------------|----------------|---------------|
        |       ON              |      ON        |  Normal Image |
        |-----------------------|----------------|---------------|
        |       ON              |      OFF       |  Mirror Image |
        |-----------------------|----------------|---------------|
        |       OFF             |      ON        |  Mirror Image |
        |-----------------------|----------------|---------------|
        |       OFF             |      OFF       |  Normal Image |
        |_______________________|________________|_______________|


*/
// Omni Device Technology/Capabilities
#define OMNI_CAP_MONO                        0x0000
#define OMNI_CAP_COLOR                       0x0001
#define OMNI_CAP_MIRROR                      0x0002
#define OMNI_CAP_FGCOLOR                     0x0004
#define OMNI_CAP_DUPLEX_BOOK                 0x0010
#define OMNI_CAP_DUPLEX_FLIP                 0x0020
#define OMNI_CAP_DUPLEX                      ( OMNI_CAP_DUPLEX_BOOK | OMNI_CAP_DUPLEX_FLIP )
// begin @EXJOB
#define OMNI_CAP_COPIES                      0x0100 // Device can do H/W Copies
#define OMNI_CAP_COLLATE_PLUGIN_UI           0x0200 // @HWCOLLATE Device can do H/W Collate
#define OMNI_CAP_COLLATE_DEFAULT_UI          0x0400 
#define OMNI_CAP_COLLATE                     0x0600 // @HWCOLLATE Device can do H/W Collate
#define OMNI_CAP_EXTJOBDATA                  0x1000
// end @EXJOB
#define OMNI_CAP_BOOKLET                     0x0008 
#define OMNI_CAP_ADDITIONAL_DITHER           0x0040 // @CONSTRAINTS

#define DEF_TYPE_DRIVER                      0x00000000
#define DEF_TYPE_DEVICE                      0x00020000
#define DEF_TYPE_USER                        0x00040000


// Function Type of device
#define DEV_FUNC_RASTER                      0
#define DEV_FUNC_TTY                         1
#define DEV_FUNC_HPGL                        2
#define DEV_FUNC_HPGL2                       3
#define DEV_FUNC_POSTSCRIPT                  4
#define DEV_FUNC_OTHER                       5

// Media Absorption
#define HEAVY_ABSORPTION                     0
#define LIGHT_ABSORPTION                     1
#define NO_ABSORPTION                        2

//****************************************************************************
//                         STRINGTABLE defines
//****************************************************************************

//---------------------------------------------------------
// Indexes offsets into OMNI driver's STRINGTABLE
//---------------------------------------------------------
#define ERROR_OFFLINE                        0

// Form ID's
#define FORM_UNLISTED                        0
#define FORM_NONE                            1
#define FORM_LETTER                          2
#define FORM_LEGAL                           3
#define FORM_LEDGER                          4
#define FORM_EXECUTIVE                       5
#define FORM_A3                              6
#define FORM_A4                              7
#define FORM_A5                              8
#define FORM_B4                              9
#define FORM_B5                              10
#define FORM_B5_ENV                          11
#define FORM_C5_ENV                          12
#define FORM_C9_ENV                          13
#define FORM_C10_ENV                         14
#define FORM_DL_ENV                          15
#define FORM_MONARCH                         16
#define FORM_TEST                            17
#define FORM_WIDE                            18
#define FORM_C6_ENV                          19  // @117138
#define FORM_CONT_LETTER                     20  // @117138
#define FORM_3x5_CARD                        21  // @WIN150
#define FORM_4x6_CARD                        22  // @DJ660c
#define FORM_5x8_CARD                        23  // @DJ660c
#define FORM_A6_CARD                         24  // @DJ660c
#define FORM_HAGAKI_CARD                     25  // @DJ660c
#define FORM_A2_ENV                          26  // @DJ660c
#define FORM_A2                              27  // @143445
#define FORM_C                               28  // @143445
#define FORM_TABLOID                         29  // @143445
#define FORM_FOOLSCAP                        30  // @143445
#define FORM_US_STANDARD                     31  // @143445
#define FORM_FANFOLD                         32  // @143445
#define FORM_TRACTOR                         33  // @143445
#define FORM_LETTER_WIDE                     34  // @143445
#define FORM_LEGAL_WIDE                      35  // @143445
#define FORM_A3_WIDE                         36  // @143445
#define FORM_A4_WIDE                         37  // @143445
#define FORM_A5_WIDE                         38  // @143445
#define FORM_B4_WIDE                         39  // @143445
#define FORM_B5_WIDE                         40  // @143445
#define FORM_TABLOID_WIDE                    41  // @143445
#define FORM_FOOLSCAP_WIDE                   42  // @143445
#define FORM_UNIVERSAL                       43  // QMS CCITT
#define FORM_FULL_11_X_17                    44  // QMS CCITT
#define FORM_INDEX_CARD                      45  // @WIN150
#define FORM_POSTCARD                        46  // QMS CCITT
#define FORM_B6                              47  // QMS CCITT
#define FORM_D5_ENV                          48  // @WIN150
#define FORM_C7_ENV                          49  // @WIN150
#define FORM_12_X_19                         50  // QMS CCITT
#define FORM_US_FANFOLD                      51  // @181074
#define FORM_FANFOLD1                        52  // @181074
#define FORM_FANFOLD2                        53  // @181074
#define FORM_FANFOLD3                        54  // @181074
#define FORM_FANFOLD4                        55  // @181074
#define FORM_FANFOLD5                        56  // @181074
#define FORM_STANDARD_LABELS_WHITE           57  // @181074
#define FORM_STANDARD_LABELS_CLEAR           58  // @181074
#define FORM_SHIPPING_LABELS                 59  // @181074
#define FORM_DISK_LABELS                     60  // @181074
#define FORM_EURO_LABELS                     61  // @181074
#define FORM_15_X_11                         62  // @181074
#define FORM_10_X_11                         63  // @181074
#define FORM_SIZE_A                          64  // @181074
#define FORM_SIZE_B                          65  // @181074
#define FORM_SIZE_C                          66  // @181074
#define FORM_SIZE_D                          67  // @181074
#define FORM_SIZE_E                          68  // @181074
#define FORM_SIZE_A4                         69  // @181074
#define FORM_SIZE_A3                         70  // @181074
#define FORM_SIZE_A2                         71  // @181074
#define FORM_SIZE_A1                         72  // @181074
#define FORM_SIZE_A0                         73  // @181074
#define FORM_SIZE_AB                         74  // @181074
#define FORM_SIZE_AC                         75  // @181074
#define FORM_SIZE_AD                         76  // @181074
#define FORM_SIZE_AE                         77  // @181074
#define FORM_SIZE_HALF_LETTER                78  // @181074
#define FORM_8x10_CARD                       79  // @181074
#define FORM_B3                              80  // @181074
#define FORM_SUPER_A3_B                      81  // @181074
#define FORM_US_C_ARCHITECTURAL              82  // @181074
#define FORM_US_D_ARCHITECTURAL              83  // @181074
#define FORM_US_E_ARCHITECTURAL              84  // @181074
#define FORM_SUPER_B                         85
#define FORM_ENV_6_1_2                       86
#define FORM_CARD_148                        87
#define FORM_STATEMENT                       88
#define FORM_FANFOLD6                        89  // @181074
#define FORM_FABRIC_SIZE                     90
#define FORM_ENV_132_220                     91
#define FORM_PHOTO_4_6                       92
#define FORM_PHOTO_100_150                   93
#define FORM_PHOTO_200_300                   94
#define FORM_PANORAMIC                       95
#define FORM_OFUKU_HAGAKI                    96
#define FORM_KAKU_2                          97 
#define FORM_KAKU_3                          98
#define FORM_KAKU_4                          99
#define FORM_HP_GREETING_CARD                100

// Tray IDs
#define TRAY_UNLISTED                        0
#define TRAY_NONE                            1
#define TRAY_TRAY                            2
#define TRAY_UPPER_TRAY                      3
#define TRAY_LOWER_TRAY                      4
#define TRAY_MULTI_TRAY                      5
#define TRAY_CASSETTE                        6
#define TRAY_UPPER_CASSETTE                  7
#define TRAY_LOWER_CASSETTE                  8
#define TRAY_MULTI_CASSETTE                  9
#define TRAY_MANUAL_FEED                     10
#define TRAY_MANUAL_ENV                      11
#define TRAY_PAPER_FEED                      12
#define TRAY_ENV_FEED                        13
#define TRAY_CSF                             14
#define TRAY_FRONT_CONTINUOUS                15
#define TRAY_REAR_CONTINUOUS                 16
#define TRAY_SINGLE_SHEET                    17
#define TRAY_SHEET_FEEDER                    18
#define TRAY_BIN_1                           19
#define TRAY_BIN_2                           20
#define TRAY_AUTO_FEEDER                     21
#define TRAY_MANUAL_FEEDER                   22
#define TRAY_PORTABLE_SHEET                  23     // @143445
#define TRAY_TRAY_1                          24
#define TRAY_TRAY_2                          25
#define TRAY_TRAY_3                          26
#define TRAY_CASSTTE1                        27
#define TRAY_CASSTTE2                        28
#define TRAY_AUTOSWITCH                      29
#define TRAY_END                             29

#if JPNBLD || TWNBLD
#define TRAY_CASSTTE3                        TRAY_END+1    
#define TRAY_CASSTTE4                        TRAY_END+2    
#define TRAY_CASSTTE5                        TRAY_END+3    
#define TRAY_CASSTTE1_O                      TRAY_END+4    
#define TRAY_CASSTTE2_O                      TRAY_END+5    
#define TRAY_CASSTTE3_O                      TRAY_END+6    
#define TRAY_CASSTTE4_O                      TRAY_END+7    
#define TRAY_CASSTTE5_O                      TRAY_END+8   
#define TRAY_FRONT_TRAY                      TRAY_END+9   
#define TRAY_UPPER_CASSETTE_O                TRAY_END+10   
#define TRAY_LOWER_CASSETTE_O                TRAY_END+11   
#define TRAY_MANUAL_TRAY                     TRAY_END+12   
#define TRAY_OPTION_CASSETTE                 TRAY_END+13   
#define TRAY_DEPEND_ON_PANEL                 TRAY_END+14   
#define TRAY_OPTION_MULTI_SF                 TRAY_END+15   
#define TRAY_J_TRAY4                         TRAY_END+16   //0j-MO971119
#define TRAY_J_TRAY5                         TRAY_END+17   //0j-MO971119
#define TRAY_J_TRAY1_O                       TRAY_END+18   //0j-MO971119
#define TRAY_J_TRAY2_O                       TRAY_END+19   //0j-MO971119
#define TRAY_J_TRAY3_O                       TRAY_END+20   //0j-MO971119
#define TRAY_J_TRAY4_O                       TRAY_END+21   //0j-MO971119
#define TRAY_J_TRAY5_O                       TRAY_END+22   //0j-MO971119
#define TRAY_J_MULTI_FEEDER                  TRAY_END+23   //0j-MO971119
#define TRAY_J_MULTI_FEEDER_O                TRAY_END+24   //0j-MO971119
#define TRAY_J_PAPER_DECK_O                  TRAY_END+25   //0j-MO971119
#define TRAY_J_TRACTOR_UNIT                  TRAY_END+26   //0j-MO971119
#define TRAY_J_AUTO_SELECT                   TRAY_END+27   //0j-MO971119
#endif 

// Res IDs
#define RES_UNLISTED                         0
#define RES_NONE                             1
#define RES_DRAFT                            2
#define RES_NORMAL                           3
#define RES_PRESENTATION                     4
#define RES_LOW                              5
#define RES_MEDIUM                           6
#define RES_HIGH                             7
#define RES_PHOTO_QUALITY                    8      // @143445
#define RES_90_X_90                          9      // @143445
#define RES_180_X_180                        10     // @143445
#define RES_360_X_360                        11     // @143445
#define RES_720_X_360                        12     // @143445
#define RES_720_X_720                        13     // @143445
#define RES_75_X_75                          14     // @143445
#define RES_60_X_72_8_PINS                   24     // @181074
#define RES_150_X_150                        15     // @143445
#define RES_300_X_300                        16     // @143445
#define RES_600_X_300                        17     // @143445
#define RES_600_X_600                        18     // @143445
#define RES_GROUP_3                          19     // CCITTDEVICE
#define RES_GROUP_4                          20     // CCITTDEVICE
#define RES_FINE                             21     // TIFFDEVICE
#define RES_240_X_240                        22     // @181074
#define RES_100_X_100                        23     // @181074
#define RES_60_X_72_8_PINS                   24     // @181074
#define RES_120_X_72_8_PINS                  25     // @181074
#define RES_60_X_60_24_PINS                  26     // @181074
#define RES_80_X_60_24_PINS                  27     // @181074
#define RES_90_X_60_24_PINS                  28     // @181074
#define RES_120_X_60_24_PINS                 29     // @181074
#define RES_240_X_60_24_PINS                 30     // @181074
#define RES_72_X_72_8_PINS                   31     // @181074
#define RES_80_X_72_8_PINS                   32     // @181074
#define RES_90_X_72_8_PINS                   33     // @181074
#define RES_144_X_72_8_PINS                  34     // @181074
#define RES_240_X_72_8_PINS                  35     // @181074
#define RES_60_X_180_24_PINS                 36     // @181074
#define RES_90_X_180_24_PINS                 37     // @181074
#define RES_120_X_180_24_PINS                38     // @181074
#define RES_180_X_180_24_PINS                39     // @181074
#define RES_360_X_180_24_PINS                40     // @181074
#define RES_60_X_360_48_PINS                 41     // @181074
#define RES_90_X_360_48_PINS                 42     // @181074
#define RES_120_X_360_48_PINS                43     // @181074
#define RES_180_X_360_48_PINS                44     // @181074
#define RES_360_X_360_48_PINS                45     // @181074
#define RES_360_X_180                        46     // @181074
#define RES_360_X_720                        47     // @181074
#define RES_360_X_360_24_PINS                48     // @181074
#define RES_1440_X_720                       49     // @181074 [missing]
#define RES_120_X_144_8_PINS                 50     // @181074
#define RES_240_X_144_8_PINS                 51     // @181074

// Print Modes
#define PRINT_MODE_UNLISTED                  0
#define PRINT_MODE_NONE                      1
#define PRINT_MODE_COLOR                     2
#define PRINT_MODE_MONOCHROME                3
#define PRINT_MODE_K                         4
#define PRINT_MODE_CMY                       5
#define PRINT_MODE_CMYK                      6
#define PRINT_MODE_BLACK                     7
#define PRINT_MODE_BLACK_ONLY                8
#define PRINT_MODE_COLOR_ONLY                9
#define PRINT_MODE_BLACK_COLOR               10
#define PRINT_MODE_1BIT                      11
#define PRINT_MODE_4BIT                      12
#define PRINT_MODE_8BIT                      13
#define PRINT_MODE_16BIT                     14
#define PRINT_MODE_24BIT                     15
#define PRINT_MODE_24_CLR                    16 // @100713 - new strings
#define PRINT_MODE_24_BLK_CLR                17 // @100713 - new strings
#define PRINT_MODE_MONO_DRAFT                18 // @117138
#define PRINT_MODE_MONO_ECON                 19 // @117138
#define PRINT_MODE_MONO_LQ                   20 // @117138
#define PRINT_MODE_MONO_PRES                 21 // @117138
#define PRINT_MODE_CLR_DRAFT                 22 // @117138
#define PRINT_MODE_CLR_ECON                  23 // @117138
#define PRINT_MODE_CLR_LQ                    24 // @117138
#define PRINT_MODE_CLR_PRES                  25 // @117138
#define PRINT_MODE_GRAYSCALE                 26 // @117138
#define PRINT_MODE_8_CLR                     27
#define PRINT_MODE_8_BLK_CLR                 28
#define PRINT_MODE_GROUP_3                   29 // CCITTDEVICE
#define PRINT_MODE_GROUP_4                   30 // CCITTDEVICE
#define PRINT_MODE_CCITT_1D                  31 // TIFFDEVICE
#define PRINT_MODE_LIGHTEST                  32 // @181074
#define PRINT_MODE_MED_LIGHT                 33 // @181074
#define PRINT_MODE_NORMAL                    34 // @181074
#define PRINT_MODE_MED_DARK                  35 // @181074
#define PRINT_MODE_DARKEST                   36 // @181074
#define PRINT_MODE_24_CLR_5                  37
#define PRINT_MODE_24_BLK_CLR_5              38
#define PRINT_MODE_24_CLR_6                  39
#define PRINT_MODE_24_BLK_CLR_6              40

// Form Classes
#define FORM_CLASS_SHEET_PAPER               0
#define FORM_CLASS_CONT_PAPER                1
#define FORM_CLASS_ENVELOPE                  2
#define FORM_CLASS_POSTCARD                  3
#define FORM_CLASS_LABEL                     4
#define FORM_CLASS_OTHER                     5

// Media Types
#define MEDIA_TYPE_INDICE_MASK      0x000000FF  //Mask for using indice field  @YYYYYY
#define MEDIA_TYPE_UNLISTED                  0
#define MEDIA_TYPE_NONE                      1
#define MEDIA_TYPE_PLAIN                     2
#define MEDIA_TYPE_TRANSPARENCY              3
#define MEDIA_TYPE_GLOSSY                    4
#define MEDIA_TYPE_SPECIAL                   5
#define MEDIA_TYPE_COATED                    6
#define MEDIA_TYPE_BACKPRINT                 7
#define MEDIA_TYPE_CLOTH                     8
#define MEDIA_TYPE_THICK                     9
#define MEDIA_TYPE_OTHER                     10
#define MEDIA_TYPE_HIGH_GLOSS_FILM           11
#define MEDIA_TYPE_HIGH_RESOLUTION           12
#define MEDIA_TYPE_SPECIAL_360               13
#define MEDIA_TYPE_SPECIAL_720               14
#define MEDIA_TYPE_PLAIN_ENHANCED            15
#define MEDIA_TYPE_IRON_ON                   16
#define MEDIA_TYPE_LABECA                    17
#define MEDIA_TYPE_THERMAL                   18
#define MEDIA_TYPE_CD_MASTER                 19
#define MEDIA_TYPE_CARDBOARD                 20
#define MEDIA_TYPE_POSTCARD                  21
#define MEDIA_TYPE_PHOTOGRAPHIC_PAPER        22
#define MEDIA_TYPE_PHOTOGRAPHIC_LABEL        23
#define MEDIA_TYPE_HP_PREMIUM_PAPER          24
#define MEDIA_TYPE_HP_PHOTOGRAPHIC_PAPER     25
#define MEDIA_TYPE_ENVELOPE                  26

#define MEDIA_TYPE_FLAG_MASK         0xFFFFFF00  //Mask for using flag field                     @YYYYYY
#define MEDIA_TYPE_REQUIRES_INVERSE  0x80000000  //Inverse of the mirror image of the media type @YYYYYY

// Notebook Tab strings
#define DIALOG_COMMANDS                      0
#define DIALOG_FORMS                         1
#define DIALOG_TRAYS                         2
#define DIALOG_PAPER                         3
#define DIALOG_FONTS                         4
#define DIALOG_DEBUG                         5
#define DIALOG_DATA                          6
#define DIALOG_COMMON                        7
#define DIALOG_COLOR                         8
#define DIALOG_MONOCHROME                    9
#define DIALOG_HSV                           10
#define DIALOG_TEXT_SAVE                     11
#define DIALOG_TEXT_CANCEL                   12
#define DIALOG_TEXT_DEFAULTS                 13
#define DIALOG_TEXT_HELP                     14
#define DIALOG_TEXT_ADD                      15
#define DIALOG_TEXT_MODIFY                   16
#define DIALOG_TEXT_DELETE                   17
#define DIALOG_CONN_ID                       18
#define DIALOG_CONN_USERID                   19
#define DIALOG_FORM_ID                       20
#define DIALOG_FORM_USERID                   21
#define DIALOG_TRAY_ID                       22
#define DIALOG_TRAY_USERID                   23
#define DIALOG_DEV_DEFAULTS                  24
#define DIALOG_PRINTER_PROPS                 25
#define DIALOG_JOB_PROPS                     26
#define DIALOG_DEV_MEMORY                    27
#define DIALOG_DEV_VERSION                   28
#define DIALOG_ON                            29
#define DIALOG_OFF                           30
#define DIALOG_NORMAL                        31
#define DIALOG_RESOLUTION                    32
#define DIALOG_DEF_TRAYS                     33
#define DIALOG_TRAY_NAME                     34
#define DIALOG_TRAY_TYPE                     35
#define DIALOG_AUTOMATIC                     36
#define DIALOG_MANUAL                        37
#define DIALOG_COMPRESSION                   38
#define DIALOG_DEGREES                       39
#define DIALOG_FONT_NLQ                      40
#define DIALOG_FONT_DRAFT                    41
#define DIALOG_FONT_SIZE                     42
#define DIALOG_CONDITIONAL                   43
#define DIALOG_COMPULSORY                    44
#define DIALOG_DRY_TIMER                     45
#define DIALOG_DEFAULT_FONT                  46
#define DIALOG_NONE_AVAILABLE                47
#define DIALOG_FONT_TYPE                     48
#define DIALOG_PROPORTIONAL                  49
#define DIALOG_FIXED                         50
#define DIALOG_SCALABLE                      51
#define DIALOG_HUE                           52
#define DIALOG_SATURATION                    53
#define DIALOG_DARKNESS                      54
#define DIALOG_PAPER_REQUEST                 55
#define DIALOG_INSERT_MANUAL                 56
#define DIALOG_GAMMA                         57
#define DIALOG_MAINTENANCE                   58

#define COLOR_BLACK                           0
#define COLOR_BLUE                            1
#define COLOR_GREEN                           2
#define COLOR_CYAN                            3
#define COLOR_RED                             4
#define COLOR_PINK                            5
#define COLOR_YELLOW                          6
#define COLOR_WHITE                           7
#define COLOR_BROWN                           8
#define COLOR_DARK_GRAY                       9
#define COLOR_DARK_BLUE                      10
#define COLOR_DARK_RED                       11
#define COLOR_DARK_GREEN                     12
#define COLOR_DARK_CYAN                      13
#define COLOR_DARK_PINK                      14
#define COLOR_PALE_GRAY                      15
#define COLOR_MAGENTA                        16   //jk1115


#define COMPRESS_RLL                         0
#define COMPRESS_TIFF                        1
#define COMPRESS_DELTAROW                    2
#define COMPRESS_RLLDELTAROW                 3

/* Note: when adding new dithering algorithms here, update
**       abDitherTable[][] in common.c and OMNI_DITHERS[]
**       in dlg.c as well!
*/
#define DITHER_LEVEL                         0
#define DITHER_DITHER_4x4                    1
#define DITHER_DITHER_8x8                    2
#define DITHER_ERR_DIFFUSION                 3
#define DITHER_MAGIC_SQUARES                 4
#define DITHER_ORDERED_SQUARES               5
#define DITHER_ADAPTIVE_DIFFUSION            6
#define DITHER_FAST_DIFFUSION                7
#define DITHER_STEINBERG_DIFFUSION           8
#define DITHER_SMOOTH_DIFFUSION              9
#define DITHER_HSV_DIFFUSION                 10
#define DITHER_HSV_BIDIFFUSION               11
#define DITHER_CMYK_DIFFUSION                12
#define DITHER_VOID_CLUSTER_DIFFUSION        13  // jk1115
#define DITHER_JANIS_STUCKI_DIFFUSION        14  // jk1115
#define DITHER_ERR_DIFFUSION6                15
#define DITHER_ERR_DIFFUSION5                16

#define WARNING_ADD_FORM                     0
#define WARNING_ADD_FONT                     1
#define WARNING_ADD_TRAY                     2
#define WARNING_ADD_CONNECT                  3
#define WARNING_DELETE_FORM                  4
#define WARNING_DELETE_FONT                  5
#define WARNING_DELETE_TRAY                  6
#define WARNING_DELETE_CONNECT               7
#define WARNING_MODIFY_FORM                  8
#define WARNING_MODIFY_FONT                  9
#define WARNING_MODIFY_TRAY                  10
#define WARNING_ADD_MSG_FORM                 11
#define WARNING_ADD_MSG_FONT                 12
#define WARNING_ADD_MSG_TRAY                 13
#define WARNING_ADD_MSG_CONNECT              14
#define WARNING_DELETE_MSG_FORM              15
#define WARNING_DELETE_MSG_FONT              16
#define WARNING_DELETE_MSG_TRAY              17
#define WARNING_DELETE_MSG_CONNECT           18
#define WARNING_SELECT_MSG_FORM              19
#define WARNING_SELECT_MSG_FONT              20
#define WARNING_SELECT_MSG_TRAY              21
#define WARNING_SELECT_MSG_CONNECT           22
#define WARNING_MODIFY_MSG_FORM              23
#define WARNING_MODIFY_MSG_FONT              24
#define WARNING_MODIFY_MSG_TRAY              25
#define WARNING_MODIFY_MSG_CONNECT           26
#define WARNING_FORM_IN_USE                  27
#define WARNING_STRING_CHANGES_LOST          28

#define MSG_CTX_HELP                         0  // Context help entryfield
#define MSG_ADD_SIZE_BUTTON                  1  // "Add" button
#define MSG_DEL_SIZE_BUTTON                  2  // "Delete" button
#define MSG_MOD_SIZE_BUTTON                  3  // "Modify" button
#define MSG_ADD_TRAY_BUTTON                  4  // "Add" button
#define MSG_DEL_TRAY_BUTTON                  5  // "Delete" button
#define MSG_MOD_TRAY_BUTTON                  6  // "Modify" button
#define MSG_JOB_NOTEBOOK                     7  // Job Props Notebook
#define MSG_JOB_OK                           8  // Job Props "OK" button
#define MSG_JOB_CANCEL                       9  // Job Props "Cancel" button
#define MSG_JOB_HELP                         10 // Job Props "Help" button
#define MSG_JOB_UNDO                         11 // Job Props "Undo" button
#define MSG_JOB_DEFAULTS                     12 // Job Props "Defaults" button
#define MSG_PRN_NOTEBOOK                     13 // Printer Props Notebook
#define MSG_PRN_OK                           14 // Printer Props "OK" button
#define MSG_PRN_CANCEL                       15 // Printer Props "Cancel" button
#define MSG_PRN_HELP                         16 // Printer Props "Help" button
#define MSG_PRN_DEV_DEFS                     17 // Printer Props "Device Defaults"
#define MSG_PRN_UNDO                         18 // Printer Props "Undo" button
#define MSG_PRN_DEFAULTS                     19 // Printer Props "Defaults" button
#define MSG_COMMON_PAGE                      20 // Common: Notebook Page
#define MSG_COMMON_FORM                      21 // Common: Form
#define MSG_COMMON_RESOLUTIONS               22 // Common: Resolutions
#define MSG_COMMON_PRINT_MODE                23 // Common: Print Mode
#define MSG_COMMON_CONDITIONAL               24 // Common: FF Conditional
#define MSG_COMMON_NONE                      25 // Common: FF None
#define MSG_COMMON_COMPULSORY                26 // Common: FF Compulsory
#define MSG_COMMON_ORIENTATION               27 // Common: Orientation Icon
#define MSG_COMMON_PORTRAIT                  28 // Common: Portrait
#define MSG_COMMON_LANDSCAPE                 29 // Common: Landscape
#define MSG_COMMON_DUPLEX                    30 // Common: Duplec Icon
#define MSG_COMMON_ONE                       31 // Common: Duplex Single
#define MSG_COMMON_FLIP                      32 // Common: Duplex Flip
#define MSG_COMMON_BOOK                      33 // Common: Duplex Book
#define MSG_COMMON_MIRROR                    34 // Common: Mirror Image Option
#define MSG_MONO_PAGE                        35 // Monochrome Notebook Page
#define MSG_MONO_DARKNESS                    36 // Mono: "Darkness" slider
#define MSG_MONO_FG_CLR                      37 // Mono: "Foreground" color
#define MSG_MONO_BG_CLR                      38 // Mono: "Background" color
#define MSG_COLOR_PAGE                       39 // Color Notebook Page
#define MSG_CLR_DITHER_ALGO                  40 // Color: Dither Algorithm List
#define MSG_CLR_DITHER_LVL                   41 // Color: Dither Level field
#define MSG_CLR_GAMMA_RED                    42 // Color: Red Gamma adjustment
#define MSG_CLR_GAMMA_GREEN                  43 // Color: Green Gamma adjustment
#define MSG_CLR_GAMMA_BLUE                   44 // Color: Blue Gamma adjustment
#define MSG_CLR_GAMMA_BLACK                  45 // Color: Black Gamma adjustment
#define MSG_CLR_BIAS_RED                     46 // Color: Red bias adjustment
#define MSG_CLR_BIAS_GREEN                   47 // Color: Green bias adjustment
#define MSG_CLR_BIAS_BLUE                    48 // Color: Blue bias adjustment
#define MSG_HSV_PAGE                         49 // HSV Notebook Page
#define MSG_HSV_HUE                          50 // HSV: Hue slider
#define MSG_HSV_SATURATION                   51 // HSV: Saturation slider
#define MSG_HSV_DARKNESS                     52 // HSV: Darkness slider
#define MSG_CONNECT_PAGE                     53 // Connection: Notebook Page
#define MSG_CONNECT_TRAY                     54 // Connection: Tray List
#define MSG_CONNECT_SIZE                     55 // Connection: Size List
#define MSG_CONNECT_MEDIA                    56 // Connection: Media Type List
#define MSG_CONNECT_CONNECT                  57 // Connection: Connection List
#define MSG_CONNECT_ADD                      58 // Connection: Add Connection
#define MSG_CONNECT_REMOVE                   59 // Connection: Remove Connection
#define MSG_FORM_PAGE                        60 // Define Form: Notebook Page
#define MSG_FORM_LIST                        61 // Form: Defined Form list
#define MSG_FORM_NAME                        62 // Form: Current Form Name
#define MSG_FORM_CMD                         63 // Form: Select Form Escape
#define MSG_FORM_WIDTH                       64 // Form: Current Form Width
#define MSG_FORM_HEIGHT                      65 // Form: Current Form Height
#define MSG_FORM_LEFT_CLIP                   66 // Form: Current Form Left Clip
#define MSG_FORM_RIGHT_CLIP                  67 // Form: Current Form Right Clip
#define MSG_FORM_TOP_CLIP                    68 // Form: Current Form Top Clip
#define MSG_FORM_BOT_CLIP                    69 // Form: Current Form Bottom Clip
#define MSG_FORM_INCHES                      70 // Form: Display in Inches
#define MSG_FORM_CENTIMETERS                 71 // Form: Display in Centimeters
#define MSG_FORM_CLASS                       72 // Form: Form Type (e.g. envelope)
#define MSG_FORM_TYPE_TITLE                  73 // Form: Form Type (Title)
#define MSG_FORM_TYPE_VALUE                  74 // Form: Form Type (Value)
#define MSG_TRAY_PAGE                        75 // Tray Notebook Page
#define MSG_TRAY_LIST                        76 // Tray: Defined Tray List
#define MSG_TRAY_NAME                        77 // Tray: Current Tray Name
#define MSG_TRAY_CMD                         78 // Tray: Select Tray Escape
#define MSG_TRAY_AUTOMATIC                   79 // Tray: type Automatic feed
#define MSG_TRAY_MANUAL                      80 // Tray: type Manual feed
#define MSG_COMMAND_PAGE                     81 // Cmd Notebook Page (Passthru)
#define MSG_COMMAND_CMD_INIT                 82 // Cmd Init Cmd (Passthru)
#define MSG_COMMAND_FILE_INIT                83 // Cmd Init Cmd (Passthru)
#define MSG_COMMAND_CMD_TERM                 84 // Cmd Term Cmd (Passthru)
#define MSG_COMMAND_FILE_TERM                85 // Cmd Term Cmd (Passthru)
#define MSG_COMMAND_CMD_FF                   86 // Cmd FF Cmd (Passthru)
#define MSG_COMMAND_FILE_FF                  87 // Cmd FF Cmd (Passthru)
#define MSG_COMMAND_CMD_ABORT                88 // Cmd Abort Cmd (Passthru)
#define MSG_COMMAND_FILE_ABORT               89 // Cmd Abort Cmd (Passthru)
#define MSG_CLR_BIAS_BLACK                   90 // Color: Black bias adjustment  //jk1115
#define MSG_COPIES_NUMBER                    91 
#define MSG_COLLATE                          92 
#define MSG_TEST                             93 //@MAINTENANCE
#define MSG_DEMO                             94 //@MAINTENANCE
#define MSG_NOZZLE                           95 //@MAINTENANCE
#define MSG_EXIT                             96 //@MAINTENANCE
#define MSG_CLEANING                         97 //@MAINTENANCE
#define MSG_MAINTENANCE                      98 //@MAINTENANCE
#define MSG_ALIGNMENT                        99 //@MAINTENANCE

#ifdef DEBUG
#define FUNC_ADDDEFINEDFORM                  0
#define FUNC_ADDUSERDEFINEDFORMENTRY         1
#define FUNC_ADDUSERDEFINEDTRAYENTRY         2
#define FUNC_ATTRIBUTEBUNDLESLINE            3
#define FUNC_ATTRIBUTEBUNDLESAREA            4
#define FUNC_ATTRIBUTEBUNDLESCHAR            5
#define FUNC_ATTRIBUTEBUNDLESIMAGE           6
#define FUNC_ATTRIBUTEBUNDLESMARKER          7
#define FUNC_BUILDAPPNAME                    8
#define FUNC_CALCULATEFONTMETRICS            9
#define FUNC_CHECKLOGICALADDRESS             10
#define FUNC_CREATEUNIQUEFORMID              11
#define FUNC_CREATEUNIQUETRAYID              12
#define FUNC_DEBUGOUTPUT                     13
#define FUNC_DELETEUSERDEFINEDFORMENTRY      14
#define FUNC_DELETEUSERDEFINEDTRAYENTRY      15
#define FUNC_DEVICEQUERYFONTS                16
#define FUNC_DEVICEQUERYFONTATTRIBUTES       17
#define FUNC_DRVINSTALL                      18
#define FUNC_ENABLE_BEGIN_CLOSE_DC           19
#define FUNC_ENABLE_COMPLETE_OPEN_DC         20
#define FUNC_ENABLE_DISABLE_DC               21
#define FUNC_ENABLE_DISABLE_PHYSICAL         22
#define FUNC_ENABLE_ENABLE_DC                23
#define FUNC_ENABLE_FILL_LOGICAL             24
#define FUNC_ENABLE_FILL_PHYSICAL            25
#define FUNC_ENABLE_RESET_DC                 26
#define FUNC_ENABLE_RESTORE_DC               27
#define FUNC_ENABLE_SAVE_DC                  28
#define FUNC_FILLFONTLIST                    29
#define FUNC_FILLFORMLIST                    30
#define FUNC_FILLMEDIALIST                   31
#define FUNC_FILLPRINTMODELIST               32
#define FUNC_FILLRESOLUTIONLIST              33
#define FUNC_FILLTRAYLIST                    34
#define FUNC_FINDPRINTERNAME                 35
#define FUNC_FORMIDFROMNAME                  36
#define FUNC_FORMINFOFROMID                  37
#define FUNC_FORMINFOFROMNAME                38
#define FUNC_FORMNAMEFROMID                  39
#define FUNC_FREESTRINGTABLE                 40
#define FUNC_FREEUSERDEFINEDFORMLIST         41
#define FUNC_FREEUSERDEFINEDTRAYLIST         42
#define FUNC_CREATENOTEBOOKPAGES             43
#define FUNC_GETDEFAULTFONTINFO              44
#define FUNC_GETDEFAULTFORMINFO              45
#define FUNC_GETIDSFROMCONNID                46
#define FUNC_INITSTRINGTABLE                 47
#define FUNC_ISFORMNAMEUNIQUE                48
#define FUNC_MEDIANAMEFROMID                 49
#define FUNC_OMNICREATEHELPINSTANCE          50
#define FUNC_OMNIDESTROYHELPINSTANCE         51
#define FUNC_OS2_PM_DRV_DEVICENAMES          52
#define FUNC_OS2_PM_DRV_DEVMODE              53
#define FUNC_PDRIVERFROMDEVICENAME           54
#define FUNC_PDEVICEFROMDEVICENAME           55
#define FUNC_QUERYDEVICEBITMAPS              56
#define FUNC_QUERYDEVICECAPS                 57
#define FUNC_QUERYDEVRESOURCE2               58
#define FUNC_QUERYHARDCOPYCAPS               59
#define FUNC_READUSERDEFINEDFORMLIST         60
#define FUNC_READUSERDEFINEDTRAYLIST         61
#define FUNC_SAVEUSERDEFINEDFORMLIST         62
#define FUNC_SETDRIVERDATADEFAULTS           63
#define FUNC_SUBINITJOB                      64
#define FUNC_SUBRASTER                       65
#define FUNC_SUBNEWPAGE                      66
#define FUNC_SUBTERMJOB                      67
#define FUNC_SUBABORTJOB                     68
#define FUNC_SUBRASTERQUERY                  69
#define FUNC_TRAYNAMEFROMID                  70
#define FUNC_CHARSTRING                      71
#define FUNC_REALIZEFONT                     72
#define FUNC_DEVICEPALETTE                   73
#define FUNC_DEVESC_STARTDOC                 74
#define FUNC_DEVESC_RAWDATA                  75
#define FUNC_DEVESC_ENDDOC                   76
#define FUNC_DEVESC_NEWFRAME                 77
#define FUNC_DEVESC_ABORTDOC                 78
#define FUNC_DEVESC_QUERYHALFTONESUPPORT     79
#define FUNC_DEVESC_QUERYPATTERN             80
#define FUNC_DEVESC_QUERYESCSUPPORT          81
#define FUNC_DEVESC_GETSCALINGFACTOR         82
#define FUNC_DEVESC_QUERYVIOCELLSIZES        83
#define FUNC_DEVESC_QUERYACTUALRESOLUTION    84
#define FUNC_DEVESC_GETCP                    85
#define FUNC_DEVESC_NEXTBAND                 86
#define FUNC_DEVESC_DRAFTMODE                87
#define FUNC_DEVESC_FLUSHOUTPUT              88
#define FUNC_DEVESC_CHAR_EXTRA               89
#define FUNC_DEVESC_BREAK_EXTRA              90
#define FUNC_DEVESC_SETMODE                  91
#define FUNC_DEVESC_DBE_FIRST                92
#define FUNC_DEVESC_DBE_LAST                 93
#define FUNC_DEVESC_STD_JOURNAL              94
#endif

//---------------------------------------------------------
// Omni Driver's STRINGTABLE defines
// NOTE: Uses offsets defined above
//---------------------------------------------------------

// over string table starting point
#define STRING_TABLE_BASE                  200

#define STRING_TABLE_ERROR_BASE                  STRING_TABLE_BASE
#define ERROR_STRING_OFFLINE                     STRING_TABLE_ERROR_BASE+ERROR_OFFLINE
#define STRING_TABLE_ERROR_END                   STRING_TABLE_ERROR_BASE+ERROR_OFFLINE+1

// Form String ID's
#define STRING_TABLE_FORM_BASE                   STRING_TABLE_ERROR_END
#define FORM_STRING_UNLISTED                     STRING_TABLE_FORM_BASE+FORM_UNLISTED
#define FORM_STRING_NONE                         STRING_TABLE_FORM_BASE+FORM_NONE
#define FORM_STRING_LETTER                       STRING_TABLE_FORM_BASE+FORM_LETTER
#define FORM_STRING_LEGAL                        STRING_TABLE_FORM_BASE+FORM_LEGAL
#define FORM_STRING_LEDGER                       STRING_TABLE_FORM_BASE+FORM_LEDGER
#define FORM_STRING_EXECUTIVE                    STRING_TABLE_FORM_BASE+FORM_EXECUTIVE
#define FORM_STRING_A3                           STRING_TABLE_FORM_BASE+FORM_A3
#define FORM_STRING_A4                           STRING_TABLE_FORM_BASE+FORM_A4
#define FORM_STRING_A5                           STRING_TABLE_FORM_BASE+FORM_A5
#define FORM_STRING_B4                           STRING_TABLE_FORM_BASE+FORM_B4
#define FORM_STRING_B5                           STRING_TABLE_FORM_BASE+FORM_B5
#define FORM_STRING_B5_ENV                       STRING_TABLE_FORM_BASE+FORM_B5_ENV
#define FORM_STRING_C5_ENV                       STRING_TABLE_FORM_BASE+FORM_C5_ENV
#define FORM_STRING_C9_ENV                       STRING_TABLE_FORM_BASE+FORM_C9_ENV
#define FORM_STRING_C10_ENV                      STRING_TABLE_FORM_BASE+FORM_C10_ENV
#define FORM_STRING_DL_ENV                       STRING_TABLE_FORM_BASE+FORM_DL_ENV
#define FORM_STRING_MONARCH                      STRING_TABLE_FORM_BASE+FORM_MONARCH
#define FORM_STRING_TEST                         STRING_TABLE_FORM_BASE+FORM_TEST
#define FORM_STRING_WIDE                         STRING_TABLE_FORM_BASE+FORM_WIDE
#define FORM_STRING_C6_ENV                       STRING_TABLE_FORM_BASE+FORM_C6_ENV         // @117138
#define FORM_STRING_CONT_LETTER                  STRING_TABLE_FORM_BASE+FORM_CONT_LETTER    // @117138
#define FORM_STRING_3x5_CARD                     STRING_TABLE_FORM_BASE+FORM_3x5_CARD       // @WIN150
#define FORM_STRING_4x6_CARD                     STRING_TABLE_FORM_BASE+FORM_4x6_CARD       // @DJ660c
#define FORM_STRING_5x8_CARD                     STRING_TABLE_FORM_BASE+FORM_5x8_CARD       // @DJ660c
#define FORM_STRING_A6_CARD                      STRING_TABLE_FORM_BASE+FORM_A6_CARD        // @DJ660c
#define FORM_STRING_HAGAKI_CARD                  STRING_TABLE_FORM_BASE+FORM_HAGAKI_CARD    // @DJ660c
#define FORM_STRING_A2_ENV                       STRING_TABLE_FORM_BASE+FORM_A2_ENV         // @DJ660c
#define FORM_STRING_A2                           STRING_TABLE_FORM_BASE+FORM_A2             // @143445
#define FORM_STRING_C                            STRING_TABLE_FORM_BASE+FORM_C              // @143445
#define FORM_STRING_TABLOID                      STRING_TABLE_FORM_BASE+FORM_TABLOID        // @143445
#define FORM_STRING_FOOLSCAP                     STRING_TABLE_FORM_BASE+FORM_FOOLSCAP       // @143445
#define FORM_STRING_US_STANDARD                  STRING_TABLE_FORM_BASE+FORM_US_STANDARD    // @143445
#define FORM_STRING_FANFOLD                      STRING_TABLE_FORM_BASE+FORM_FANFOLD        // @143445
#define FORM_STRING_TRACTOR                      STRING_TABLE_FORM_BASE+FORM_TRACTOR        // @143445
#define FORM_STRING_LETTER_WIDE                  STRING_TABLE_FORM_BASE+FORM_LETTER_WIDE    // @143445
#define FORM_STRING_LEGAL_WIDE                   STRING_TABLE_FORM_BASE+FORM_LEGAL_WIDE     // @143445
#define FORM_STRING_A3_WIDE                      STRING_TABLE_FORM_BASE+FORM_A3_WIDE        // @143445
#define FORM_STRING_A4_WIDE                      STRING_TABLE_FORM_BASE+FORM_A4_WIDE        // @143445
#define FORM_STRING_A5_WIDE                      STRING_TABLE_FORM_BASE+FORM_A5_WIDE        // @143445
#define FORM_STRING_B4_WIDE                      STRING_TABLE_FORM_BASE+FORM_B4_WIDE        // @143445
#define FORM_STRING_B5_WIDE                      STRING_TABLE_FORM_BASE+FORM_B5_WIDE        // @143445
#define FORM_STRING_TABLOID_WIDE                 STRING_TABLE_FORM_BASE+FORM_TABLOID_WIDE   // @143445
#define FORM_STRING_FOOLSCAP_WIDE                STRING_TABLE_FORM_BASE+FORM_FOOLSCAP_WIDE  // @143445
#define FORM_STRING_UNIVERSAL                    STRING_TABLE_FORM_BASE+FORM_UNIVERSAL      // QMS CCITT
#define FORM_STRING_FULL_11_X_17                 STRING_TABLE_FORM_BASE+FORM_FULL_11_X_17   // QMS CCITT
#define FORM_STRING_INDEX_CARD                   STRING_TABLE_FORM_BASE+FORM_INDEX_CARD     // @WIN150
#define FORM_STRING_POSTCARD                     STRING_TABLE_FORM_BASE+FORM_POSTCARD       // QMS CCITT
#define FORM_STRING_B6                           STRING_TABLE_FORM_BASE+FORM_B6             // QMS CCITT
#define FORM_STRING_D5_ENV                       STRING_TABLE_FORM_BASE+FORM_D5_ENV         // @WIN150
#define FORM_STRING_C7_ENV                       STRING_TABLE_FORM_BASE+FORM_C7_ENV         // @WIN150
#define FORM_STRING_12_X_19                      STRING_TABLE_FORM_BASE+FORM_12_X_19        // QMS CCITT
#define FORM_STRING_US_FANFOLD                   STRING_TABLE_FORM_BASE+FORM_US_FANFOLD     // @181074
#define FORM_STRING_FANFOLD1                     STRING_TABLE_FORM_BASE+FORM_FANFOLD1       // @181074
#define FORM_STRING_FANFOLD2                     STRING_TABLE_FORM_BASE+FORM_FANFOLD2       // @181074
#define FORM_STRING_FANFOLD3                     STRING_TABLE_FORM_BASE+FORM_FANFOLD3       // @181074
#define FORM_STRING_FANFOLD4                     STRING_TABLE_FORM_BASE+FORM_FANFOLD4       // @181074
#define FORM_STRING_FANFOLD5                     STRING_TABLE_FORM_BASE+FORM_FANFOLD5       // @181074
#define FORM_STRING_STANDARD_LABELS_WHITE        STRING_TABLE_FORM_BASE+FORM_STANDARD_LABELS_WHITE //@181074
#define FORM_STRING_STANDARD_LABELS_CLEAR        STRING_TABLE_FORM_BASE+FORM_STANDARD_LABELS_CLEAR //@181074
#define FORM_STRING_SHIPPING_LABELS              STRING_TABLE_FORM_BASE+FORM_SHIPPING_LABELS //@181074
#define FORM_STRING_DISK_LABELS                  STRING_TABLE_FORM_BASE+FORM_DISK_LABELS    //@181074
#define FORM_STRING_EURO_LABELS                  STRING_TABLE_FORM_BASE+FORM_EURO_LABELS    //@181074
#define FORM_STRING_15_X_11                      STRING_TABLE_FORM_BASE+FORM_15_X_11        //@181074
#define FORM_STRING_10_X_11                      STRING_TABLE_FORM_BASE+FORM_10_X_11        //@181074
#define FORM_STRING_SIZE_A                       STRING_TABLE_FORM_BASE+FORM_SIZE_A         //@181074
#define FORM_STRING_SIZE_B                       STRING_TABLE_FORM_BASE+FORM_SIZE_B         //@181074
#define FORM_STRING_SIZE_C                       STRING_TABLE_FORM_BASE+FORM_SIZE_C         //@181074
#define FORM_STRING_SIZE_D                       STRING_TABLE_FORM_BASE+FORM_SIZE_D         //@181074
#define FORM_STRING_SIZE_E                       STRING_TABLE_FORM_BASE+FORM_SIZE_E         //@181074
#define FORM_STRING_SIZE_A4                      STRING_TABLE_FORM_BASE+FORM_SIZE_A4        //@181074
#define FORM_STRING_SIZE_A3                      STRING_TABLE_FORM_BASE+FORM_SIZE_A3        //@181074
#define FORM_STRING_SIZE_A2                      STRING_TABLE_FORM_BASE+FORM_SIZE_A2        //@181074
#define FORM_STRING_SIZE_A1                      STRING_TABLE_FORM_BASE+FORM_SIZE_A1        //@181074
#define FORM_STRING_SIZE_A0                      STRING_TABLE_FORM_BASE+FORM_SIZE_A0        //@181074
#define FORM_STRING_SIZE_AB                      STRING_TABLE_FORM_BASE+FORM_SIZE_AB        //@181074
#define FORM_STRING_SIZE_AC                      STRING_TABLE_FORM_BASE+FORM_SIZE_AC        //@181074
#define FORM_STRING_SIZE_AD                      STRING_TABLE_FORM_BASE+FORM_SIZE_AD        //@181074
#define FORM_STRING_SIZE_AE                      STRING_TABLE_FORM_BASE+FORM_SIZE_AE        //@181074
#define FORM_STRING_SIZE_HALF_LETTER             STRING_TABLE_FORM_BASE+FORM_SIZE_HALF_LETTER //@181074
#define FORM_STRING_8x10_CARD                    STRING_TABLE_FORM_BASE+FORM_8x10_CARD      //@181074
#define FORM_STRING_B3                           STRING_TABLE_FORM_BASE+FORM_B3             //@181074
#define FORM_STRING_SUPER_A3_B                   STRING_TABLE_FORM_BASE+FORM_SUPER_A3_B     //@181074
#define FORM_STRING_US_C_ARCHITECTURAL           STRING_TABLE_FORM_BASE+FORM_US_C_ARCHITECTURAL //@181074
#define FORM_STRING_US_D_ARCHITECTURAL           STRING_TABLE_FORM_BASE+FORM_US_D_ARCHITECTURAL //@181074
#define FORM_STRING_US_E_ARCHITECTURAL           STRING_TABLE_FORM_BASE+FORM_US_E_ARCHITECTURAL //@181074
#define FORM_STRING_SUPER_B                      STRING_TABLE_FORM_BASE+FORM_SUPER_B
#define FORM_STRING_ENV_6_1_2                    STRING_TABLE_FORM_BASE+FORM_ENV_6_1_2
#define FORM_STRING_CARD_148                     STRING_TABLE_FORM_BASE+FORM_CARD_148
#define FORM_STRING_STATEMENT                    STRING_TABLE_FORM_BASE+FORM_STATEMENT
#define FORM_STRING_FANFOLD6                     STRING_TABLE_FORM_BASE+FORM_FANFOLD6       // @181074
#define FORM_STRING_FABRIC_SIZE                  STRING_TABLE_FORM_BASE+FORM_FABRIC_SIZE
#define FORM_STRING_ENV_132_220                  STRING_TABLE_FORM_BASE+FORM_ENV_132_220
#define FORM_STRING_PHOTO_4_6                    STRING_TABLE_FORM_BASE+FORM_PHOTO_4_6
#define FORM_STRING_PHOTO_100_150                STRING_TABLE_FORM_BASE+FORM_PHOTO_100_150
#define FORM_STRING_PHOTO_200_300                STRING_TABLE_FORM_BASE+FORM_PHOTO_200_300
#define FORM_STRING_PANORAMIC                    STRING_TABLE_FORM_BASE+FORM_PANORAMIC
#define FORM_STRING_OFUKU_HAGAKI                 STRING_TABLE_FORM_BASE+FORM_OFUKU_HAGAKI
#define FORM_STRING_KAKU_2                       STRING_TABLE_FORM_BASE+FORM_KAKU_2
#define FORM_STRING_KAKU_3                       STRING_TABLE_FORM_BASE+FORM_KAKU_3
#define FORM_STRING_KAKU_4                       STRING_TABLE_FORM_BASE+FORM_KAKU_4
#define FORM_STRING_HP_GREETING_CARD             STRING_TABLE_FORM_BASE+FORM_HP_GREETING_CARD
#define STRING_TABLE_FORM_END                    STRING_TABLE_FORM_BASE+FORM_HP_GREETING_CARD+1

#define STRING_TABLE_TRAY_BASE                   STRING_TABLE_FORM_END
#define TRAY_STRING_UNLISTED                     STRING_TABLE_TRAY_BASE+TRAY_UNLISTED
#define TRAY_STRING_NONE                         STRING_TABLE_TRAY_BASE+TRAY_NONE
#define TRAY_STRING_TRAY                         STRING_TABLE_TRAY_BASE+TRAY_TRAY
#define TRAY_STRING_UPPER_TRAY                   STRING_TABLE_TRAY_BASE+TRAY_UPPER_TRAY
#define TRAY_STRING_LOWER_TRAY                   STRING_TABLE_TRAY_BASE+TRAY_LOWER_TRAY
#define TRAY_STRING_MULTI_TRAY                   STRING_TABLE_TRAY_BASE+TRAY_MULTI_TRAY
#define TRAY_STRING_CASSETTE                     STRING_TABLE_TRAY_BASE+TRAY_CASSETTE
#define TRAY_STRING_UPPER_CASSETTE               STRING_TABLE_TRAY_BASE+TRAY_UPPER_CASSETTE
#define TRAY_STRING_LOWER_CASSETTE               STRING_TABLE_TRAY_BASE+TRAY_LOWER_CASSETTE
#define TRAY_STRING_MULTI_CASSETTE               STRING_TABLE_TRAY_BASE+TRAY_MULTI_CASSETTE
#define TRAY_STRING_MANUAL_FEED                  STRING_TABLE_TRAY_BASE+TRAY_MANUAL_FEED
#define TRAY_STRING_MANUAL_ENV                   STRING_TABLE_TRAY_BASE+TRAY_MANUAL_ENV
#define TRAY_STRING_PAPER_FEED                   STRING_TABLE_TRAY_BASE+TRAY_PAPER_FEED
#define TRAY_STRING_ENV_FEED                     STRING_TABLE_TRAY_BASE+TRAY_ENV_FEED
#define TRAY_STRING_CSF                          STRING_TABLE_TRAY_BASE+TRAY_CSF
#define TRAY_STRING_F_CONTINUOUS                 STRING_TABLE_TRAY_BASE+TRAY_FRONT_CONTINUOUS
#define TRAY_STRING_R_CONTINUOUS                 STRING_TABLE_TRAY_BASE+TRAY_REAR_CONTINUOUS
#define TRAY_STRING_SINGLE_SHEET                 STRING_TABLE_TRAY_BASE+TRAY_SINGLE_SHEET
#define TRAY_STRING_SHEET_FEEDER                 STRING_TABLE_TRAY_BASE+TRAY_SHEET_FEEDER
#define TRAY_STRING_BIN_1                        STRING_TABLE_TRAY_BASE+TRAY_BIN_1
#define TRAY_STRING_BIN_2                        STRING_TABLE_TRAY_BASE+TRAY_BIN_2
#define TRAY_STRING_AUTO_FEEDER                  STRING_TABLE_TRAY_BASE+TRAY_AUTO_FEEDER
#define TRAY_STRING_MANUAL_FEEDER                STRING_TABLE_TRAY_BASE+TRAY_MANUAL_FEEDER
#define TRAY_STRING_PORTABLE_SHEET               STRING_TABLE_TRAY_BASE+TRAY_PORTABLE_SHEET
#define TRAY_STRING_TRAY_1                       STRING_TABLE_TRAY_BASE+TRAY_TRAY_1
#define TRAY_STRING_TRAY_2                       STRING_TABLE_TRAY_BASE+TRAY_TRAY_2
#define TRAY_STRING_TRAY_3                       STRING_TABLE_TRAY_BASE+TRAY_TRAY_3
#define TRAY_STRING_CASSETTE1                    STRING_TABLE_TRAY_BASE+TRAY_CASSTTE1           
#define TRAY_STRING_CASSETTE2                    STRING_TABLE_TRAY_BASE+TRAY_CASSTTE2           
#define TRAY_STRING_AUTOSWITCH                   STRING_TABLE_TRAY_BASE+TRAY_AUTOSWITCH         

#if JPNBLD || TWNBLD                                                                            
#define TRAY_STRING_CASSETTE3                    STRING_TABLE_TRAY_BASE+TRAY_CASSTTE3           
#define TRAY_STRING_CASSETTE4                    STRING_TABLE_TRAY_BASE+TRAY_CASSTTE4           
#define TRAY_STRING_CASSETTE5                    STRING_TABLE_TRAY_BASE+TRAY_CASSTTE5           
#define TRAY_STRING_CASSETTE1_O                  STRING_TABLE_TRAY_BASE+TRAY_CASSTTE1_O         
#define TRAY_STRING_CASSETTE2_O                  STRING_TABLE_TRAY_BASE+TRAY_CASSTTE2_O         
#define TRAY_STRING_CASSETTE3_O                  STRING_TABLE_TRAY_BASE+TRAY_CASSTTE3_O         
#define TRAY_STRING_CASSETTE4_O                  STRING_TABLE_TRAY_BASE+TRAY_CASSTTE4_O         
#define TRAY_STRING_CASSETTE5_O                  STRING_TABLE_TRAY_BASE+TRAY_CASSTTE5_O         
#define TRAY_STRING_FRONT_TRAY                   STRING_TABLE_TRAY_BASE+TRAY_FRONT_TRAY         
#define TRAY_STRING_UPPER_CASSETTE_O             STRING_TABLE_TRAY_BASE+TRAY_UPPER_CASSETTE_O   
#define TRAY_STRING_LOWER_CASSETTE_O             STRING_TABLE_TRAY_BASE+TRAY_LOWER_CASSETTE_O   
#define TRAY_STRING_MANUAL_TRAY                  STRING_TABLE_TRAY_BASE+TRAY_MANUAL_TRAY        
#define TRAY_STRING_OPTION_CASSETTE              STRING_TABLE_TRAY_BASE+TRAY_OPTION_CASSETTE    
#define TRAY_STRING_DEPEND_ON_PANEL              STRING_TABLE_TRAY_BASE+TRAY_DEPEND_ON_PANEL    
#define TRAY_STRING_OPTION_MULTI_SF              STRING_TABLE_TRAY_BASE+TRAY_OPTION_MULTI_SF    
#define TRAY_STRING_J_TRAY1                      TRAY_STRING_TRAY_1                             // they
#define TRAY_STRING_J_TRAY2                      TRAY_STRING_TRAY_2                             // are
#define TRAY_STRING_J_TRAY3                      TRAY_STRING_TRAY_3                             // the same
#define TRAY_STRING_J_TRAY4                      STRING_TABLE_TRAY_BASE+TRAY_J_TRAY4            //0j-MO971119
#define TRAY_STRING_J_TRAY5                      STRING_TABLE_TRAY_BASE+TRAY_J_TRAY5            //0j-MO971119
#define TRAY_STRING_J_TRAY1_O                    STRING_TABLE_TRAY_BASE+TRAY_J_TRAY1_O          //0j-MO971119
#define TRAY_STRING_J_TRAY2_O                    STRING_TABLE_TRAY_BASE+TRAY_J_TRAY2_O          //0j-MO971119
#define TRAY_STRING_J_TRAY3_O                    STRING_TABLE_TRAY_BASE+TRAY_J_TRAY3_O          //0j-MO971119
#define TRAY_STRING_J_TRAY4_O                    STRING_TABLE_TRAY_BASE+TRAY_J_TRAY4_O          //0j-MO971119
#define TRAY_STRING_J_TRAY5_O                    STRING_TABLE_TRAY_BASE+TRAY_J_TRAY5_O          //0j-MO971119
#define TRAY_STRING_J_MULTI_FEEDER               STRING_TABLE_TRAY_BASE+TRAY_J_MULTI_FEEDER     //0j-MO971119
#define TRAY_STRING_J_MULTI_FEEDER_O             STRING_TABLE_TRAY_BASE+TRAY_J_MULTI_FEEDER_O   //0j-MO971119
#define TRAY_STRING_J_PAPER_DECK_O               STRING_TABLE_TRAY_BASE+TRAY_J_PAPER_DECK_O     //0j-MO971119
#define TRAY_STRING_J_TRACTOR_UNIT               STRING_TABLE_TRAY_BASE+TRAY_J_TRACTOR_UNIT     //0j-MO971119
#define TRAY_STRING_J_AUTO_SELECT                STRING_TABLE_TRAY_BASE+TRAY_J_AUTO_SELECT      //0j-MO971119
#define STRING_TABLE_TRAY_END                    STRING_TABLE_TRAY_BASE+TRAY_J_AUTO_SELECT+1    //0j-MO971119
#else  
#define STRING_TABLE_TRAY_END                    STRING_TABLE_TRAY_BASE+TRAY_AUTOSWITCH+1
#endif 

#define STRING_TABLE_RES_BASE                    STRING_TABLE_TRAY_END
#define RES_STRING_UNLISTED                      STRING_TABLE_RES_BASE+RES_UNLISTED
#define RES_STRING_NONE                          STRING_TABLE_RES_BASE+RES_NONE
#define RES_STRING_DRAFT                         STRING_TABLE_RES_BASE+RES_DRAFT
#define RES_STRING_NORMAL                        STRING_TABLE_RES_BASE+RES_NORMAL
#define RES_STRING_PRESENTATION                  STRING_TABLE_RES_BASE+RES_PRESENTATION
#define RES_STRING_LOW                           STRING_TABLE_RES_BASE+RES_LOW
#define RES_STRING_MEDIUM                        STRING_TABLE_RES_BASE+RES_MEDIUM
#define RES_STRING_HIGH                          STRING_TABLE_RES_BASE+RES_HIGH
#define RES_STRING_PHOTO_QUALITY                 STRING_TABLE_RES_BASE+RES_PHOTO_QUALITY
#define RES_STRING_90_X_90                       STRING_TABLE_RES_BASE+RES_90_X_90
#define RES_STRING_180_X_180                     STRING_TABLE_RES_BASE+RES_180_X_180
#define RES_STRING_360_X_360                     STRING_TABLE_RES_BASE+RES_360_X_360
#define RES_STRING_720_X_360                     STRING_TABLE_RES_BASE+RES_720_X_360
#define RES_STRING_720_X_720                     STRING_TABLE_RES_BASE+RES_720_X_720
#define RES_STRING_75_X_75                       STRING_TABLE_RES_BASE+RES_75_X_75
#define RES_STRING_150_X_150                     STRING_TABLE_RES_BASE+RES_150_X_150
#define RES_STRING_300_X_300                     STRING_TABLE_RES_BASE+RES_300_X_300
#define RES_STRING_600_X_300                     STRING_TABLE_RES_BASE+RES_600_X_300
#define RES_STRING_600_X_600                     STRING_TABLE_RES_BASE+RES_600_X_600
#define RES_STRING_GROUP_3                       STRING_TABLE_RES_BASE+RES_GROUP_3   // TIFFDEVICE
#define RES_STRING_GROUP_4                       STRING_TABLE_RES_BASE+RES_GROUP_4   // TIFFDEVICE
#define RES_STRING_FINE                          STRING_TABLE_RES_BASE+RES_FINE      // TIFFDEVICE
#define RES_STRING_240_X_240                     STRING_TABLE_RES_BASE+RES_240_X_240         // @181074
#define RES_STRING_100_X_100                     STRING_TABLE_RES_BASE+RES_100_X_100         // @181074
#define RES_STRING_60_X_72_8_PINS                STRING_TABLE_RES_BASE+RES_60_X_72_8_PINS    // @181074
#define RES_STRING_120_X_72_8_PINS               STRING_TABLE_RES_BASE+RES_120_X_72_8_PINS   // @181074
#define RES_STRING_60_X_60_24_PINS               STRING_TABLE_RES_BASE+RES_60_X_60_24_PINS   // @181074
#define RES_STRING_80_X_60_24_PINS               STRING_TABLE_RES_BASE+RES_80_X_60_24_PINS   // @181074
#define RES_STRING_90_X_60_24_PINS               STRING_TABLE_RES_BASE+RES_90_X_60_24_PINS   // @181074
#define RES_STRING_120_X_60_24_PINS              STRING_TABLE_RES_BASE+RES_120_X_60_24_PINS  // @181074
#define RES_STRING_240_X_60_24_PINS              STRING_TABLE_RES_BASE+RES_240_X_60_24_PINS  // @181074
#define RES_STRING_72_X_72_8_PINS                STRING_TABLE_RES_BASE+RES_72_X_72_8_PINS    // @181074
#define RES_STRING_80_X_72_8_PINS                STRING_TABLE_RES_BASE+RES_80_X_72_8_PINS    // @181074
#define RES_STRING_90_X_72_8_PINS                STRING_TABLE_RES_BASE+RES_90_X_72_8_PINS    // @181074
#define RES_STRING_144_X_72_8_PINS               STRING_TABLE_RES_BASE+RES_144_X_72_8_PINS   // @181074
#define RES_STRING_240_X_72_8_PINS               STRING_TABLE_RES_BASE+RES_240_X_72_8_PINS   // @181074
#define RES_STRING_60_X_180_24_PINS              STRING_TABLE_RES_BASE+RES_60_X_180_24_PINS  // @181074
#define RES_STRING_90_X_180_24_PINS              STRING_TABLE_RES_BASE+RES_90_X_180_24_PINS  // @181074
#define RES_STRING_120_X_180_24_PINS             STRING_TABLE_RES_BASE+RES_120_X_180_24_PINS // @181074
#define RES_STRING_180_X_180_24_PINS             STRING_TABLE_RES_BASE+RES_180_X_180_24_PINS // @181074
#define RES_STRING_360_X_180_24_PINS             STRING_TABLE_RES_BASE+RES_360_X_180_24_PINS // @181074
#define RES_STRING_60_X_360_48_PINS              STRING_TABLE_RES_BASE+RES_60_X_360_48_PINS  // @181074
#define RES_STRING_90_X_360_48_PINS              STRING_TABLE_RES_BASE+RES_90_X_360_48_PINS  // @181074
#define RES_STRING_120_X_360_48_PINS             STRING_TABLE_RES_BASE+RES_120_X_360_48_PINS // @181074
#define RES_STRING_180_X_360_48_PINS             STRING_TABLE_RES_BASE+RES_180_X_360_48_PINS // @181074
#define RES_STRING_360_X_360_48_PINS             STRING_TABLE_RES_BASE+RES_360_X_360_48_PINS // @181074
#define RES_STRING_360_X_180                     STRING_TABLE_RES_BASE+RES_360_X_180         // @181074
#define RES_STRING_360_X_720                     STRING_TABLE_RES_BASE+RES_360_X_720         // @181074
#define RES_STRING_360_X_360_24_PINS             STRING_TABLE_RES_BASE+RES_360_X_360_24_PINS // @181074
#define RES_STRING_1440_X_720                    STRING_TABLE_RES_BASE+RES_1440_X_720        // @181074 [missing]
#define RES_STRING_120_X_144_8_PINS              STRING_TABLE_RES_BASE+RES_120_X_144_8_PINS  // @181074
#define RES_STRING_240_X_144_8_PINS              STRING_TABLE_RES_BASE+RES_240_X_144_8_PINS  // @181074
#define STRING_TABLE_RES_END                     STRING_TABLE_RES_BASE+RES_240_X_144_8_PINS+1


#define STRING_TABLE_PRINT_MODE_BASE             STRING_TABLE_RES_END
#define PRINT_MODE_STRING_UNLISTED               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_UNLISTED
#define PRINT_MODE_STRING_NONE                   STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_NONE
#define PRINT_MODE_STRING_COLOR                  STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_COLOR
#define PRINT_MODE_STRING_MONOCHROME             STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MONOCHROME
#define PRINT_MODE_STRING_K                      STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_K
#define PRINT_MODE_STRING_CMY                    STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CMY
#define PRINT_MODE_STRING_CMYK                   STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CMYK
#define PRINT_MODE_STRING_BLACK                  STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_BLACK
#define PRINT_MODE_STRING_BLACK_ONLY             STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_BLACK_ONLY
#define PRINT_MODE_STRING_COLOR_ONLY             STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_COLOR_ONLY
#define PRINT_MODE_STRING_BLACK_COLOR            STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_BLACK_COLOR
#define PRINT_MODE_STRING_1BIT                   STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_1BIT
#define PRINT_MODE_STRING_4BIT                   STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_4BIT
#define PRINT_MODE_STRING_8BIT                   STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_8BIT
#define PRINT_MODE_STRING_16BIT                  STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_16BIT
#define PRINT_MODE_STRING_24BIT                  STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24BIT
#define PRINT_MODE_STRING_24_CLR                 STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_CLR
#define PRINT_MODE_STRING_24_BLK_CLR             STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_BLK_CLR
#define PRINT_MODE_STRING_MONO_DRAFT             STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MONO_DRAFT   // @117138
#define PRINT_MODE_STRING_MONO_ECON              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MONO_ECON    // @117138
#define PRINT_MODE_STRING_MONO_LQ                STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MONO_LQ      // @117138
#define PRINT_MODE_STRING_MONO_PRES              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MONO_PRES    // @117138
#define PRINT_MODE_STRING_CLR_DRAFT              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CLR_DRAFT    // @117138
#define PRINT_MODE_STRING_CLR_ECON               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CLR_ECON     // @117138
#define PRINT_MODE_STRING_CLR_LQ                 STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CLR_LQ       // @117138
#define PRINT_MODE_STRING_CLR_PRES               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CLR_PRES     // @117138
#define PRINT_MODE_STRING_GRAYSCALE              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_GRAYSCALE    // @117138
#define PRINT_MODE_STRING_8_CLR                  STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_8_CLR
#define PRINT_MODE_STRING_8_BLK_CLR              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_8_BLK_CLR
#define PRINT_MODE_STRING_GROUP_3                STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_GROUP_3   // TIFFDEVICE
#define PRINT_MODE_STRING_GROUP_4                STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_GROUP_4   // TIFFDEVICE
#define PRINT_MODE_STRING_CCITT_1D               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_CCITT_1D  // TIFFDEVICE
#define PRINT_MODE_STRING_LIGHTEST               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_LIGHTEST  // @181074
#define PRINT_MODE_STRING_MED_LIGHT              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MED_LIGHT // @181074
#define PRINT_MODE_STRING_NORMAL                 STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_NORMAL    // @181074
#define PRINT_MODE_STRING_MED_DARK               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_MED_DARK  // @181074
#define PRINT_MODE_STRING_DARKEST                STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_DARKEST   // @181074
#define PRINT_MODE_STRING_24_CLR_5               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_CLR_5
#define PRINT_MODE_STRING_24_BLK_CLR_5           STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_BLK_CLR_5
#define PRINT_MODE_STRING_24_CLR_6               STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_CLR_6
#define PRINT_MODE_STRING_24_BLK_CLR_6           STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_BLK_CLR_6
#define STRING_TABLE_PRINT_MODE_END              STRING_TABLE_PRINT_MODE_BASE+PRINT_MODE_24_BLK_CLR_6+1

#define STRING_TABLE_FORM_CLASS_BASE             STRING_TABLE_PRINT_MODE_END
#define FORM_CLASS_STRING_SHEET_PAPAR            STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_SHEET_PAPER
#define FORM_CLASS_STRING_CONT_PAPAR             STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_CONT_PAPER
#define FORM_CLASS_STRING_ENVELOPE               STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_ENVELOPE
#define FORM_CLASS_STRING_POSTCARD               STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_POSTCARD
#define FORM_CLASS_STRING_LABEL                  STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_LABEL
#define FORM_CLASS_STRING_OTHER                  STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_OTHER
#define STRING_TABLE_FORM_CLASS_END              STRING_TABLE_FORM_CLASS_BASE+FORM_CLASS_OTHER+1

#define STRING_TABLE_MEDIA_BASE                  STRING_TABLE_FORM_CLASS_END
#define MEDIA_STRING_UNLISTED                    STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_UNLISTED
#define MEDIA_STRING_NONE                        STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_NONE
#define MEDIA_STRING_PLAIN                       STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_PLAIN
#define MEDIA_STRING_TRANSPARENCY                STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_TRANSPARENCY
#define MEDIA_STRING_GLOSSY                      STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_GLOSSY
#define MEDIA_STRING_SPECIAL                     STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_SPECIAL
#define MEDIA_STRING_COATED                      STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_COATED
#define MEDIA_STRING_BACKPRINT                   STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_BACKPRINT
#define MEDIA_STRING_CLOTH                       STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_CLOTH
#define MEDIA_STRING_THICK                       STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_THICK
#define MEDIA_STRING_OTHER                       STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_OTHER              // @143445
#define MEDIA_STRING_HIGH_GLOSS_FILM             STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_HIGH_GLOSS_FILM    // @143445
#define MEDIA_STRING_HIGH_RESOLUTION             STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_HIGH_RESOLUTION    // @143445
#define MEDIA_STRING_SPECIAL_360                 STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_SPECIAL_360        // @181074
#define MEDIA_STRING_SPECIAL_720                 STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_SPECIAL_720        // @181074
#define MEDIA_STRING_PLAIN_ENHANCED              STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_PLAIN_ENHANCED
#define MEDIA_STRING_IRON_ON                     STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_IRON_ON
#define MEDIA_STRING_LABECA                      STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_LABECA
#define MEDIA_STRING_THERMAL                     STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_THERMAL
#define MEDIA_STRING_CD_MASTER                   STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_CD_MASTER
#define MEDIA_STRING_CARDBOARD                   STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_CARDBOARD
#define MEDIA_STRING_POSTCARD                    STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_POSTCARD
#define MEDIA_STRING_PHOTOGRAPHIC_PAPER          STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_PHOTOGRAPHIC_PAPER
#define MEDIA_STRING_PHOTOGRAPHIC_LABEL          STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_PHOTOGRAPHIC_LABEL
#define MEDIA_STRING_HP_PREMIUM_PAPER            STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_HP_PREMIUM_PAPER
#define MEDIA_STRING_HP_PHOTOGRAPHIC_PAPER       STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_HP_PHOTOGRAPHIC_PAPER
#define MEDIA_STRING_ENVELOPE                    STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_ENVELOPE
#define STRING_TABLE_MEDIA_END                   STRING_TABLE_MEDIA_BASE+MEDIA_TYPE_ENVELOPE+1


#define STRING_TABLE_DLG_BASE                    STRING_TABLE_MEDIA_END
#define DIALOG_STRING_COMMANDS                   STRING_TABLE_DLG_BASE+DIALOG_COMMANDS
#define DIALOG_STRING_FORMS                      STRING_TABLE_DLG_BASE+DIALOG_FORMS
#define DIALOG_STRING_TRAYS                      STRING_TABLE_DLG_BASE+DIALOG_TRAYS
#define DIALOG_STRING_PAPER                      STRING_TABLE_DLG_BASE+DIALOG_PAPER
#define DIALOG_STRING_FONTS                      STRING_TABLE_DLG_BASE+DIALOG_FONTS
#define DIALOG_STRING_DEBUG                      STRING_TABLE_DLG_BASE+DIALOG_DEBUG
#define DIALOG_STRING_DATA                       STRING_TABLE_DLG_BASE+DIALOG_DATA
#define DIALOG_STRING_COMMON                     STRING_TABLE_DLG_BASE+DIALOG_COMMON
#define DIALOG_STRING_COLOR                      STRING_TABLE_DLG_BASE+DIALOG_COLOR
#define DIALOG_STRING_MONOCHROME                 STRING_TABLE_DLG_BASE+DIALOG_MONOCHROME
#define DIALOG_STRING_HSV                        STRING_TABLE_DLG_BASE+DIALOG_HSV
#define DIALOG_STRING_TEXT_SAVE                  STRING_TABLE_DLG_BASE+DIALOG_TEXT_SAVE
#define DIALOG_STRING_TEXT_CANCEL                STRING_TABLE_DLG_BASE+DIALOG_TEXT_CANCEL
#define DIALOG_STRING_TEXT_DEFAULTS              STRING_TABLE_DLG_BASE+DIALOG_TEXT_DEFAULTS
#define DIALOG_STRING_TEXT_HELP                  STRING_TABLE_DLG_BASE+DIALOG_TEXT_HELP
#define DIALOG_STRING_TEXT_ADD                   STRING_TABLE_DLG_BASE+DIALOG_TEXT_ADD
#define DIALOG_STRING_TEXT_MODIFY                STRING_TABLE_DLG_BASE+DIALOG_TEXT_MODIFY
#define DIALOG_STRING_TEXT_DELETE                STRING_TABLE_DLG_BASE+DIALOG_TEXT_DELETE
#define DIALOG_STRING_CONN_ID                    STRING_TABLE_DLG_BASE+DIALOG_CONN_ID
#define DIALOG_STRING_CONN_USERID                STRING_TABLE_DLG_BASE+DIALOG_CONN_USERID
#define DIALOG_STRING_FORM_ID                    STRING_TABLE_DLG_BASE+DIALOG_FORM_ID
#define DIALOG_STRING_FORM_USERID                STRING_TABLE_DLG_BASE+DIALOG_FORM_USERID
#define DIALOG_STRING_TRAY_ID                    STRING_TABLE_DLG_BASE+DIALOG_TRAY_ID
#define DIALOG_STRING_TRAY_USERID                STRING_TABLE_DLG_BASE+DIALOG_TRAY_USERID
#define DIALOG_STRING_DEV_DEFAULTS               STRING_TABLE_DLG_BASE+DIALOG_DEV_DEFAULTS
#define DIALOG_STRING_PRINTER_PROPS              STRING_TABLE_DLG_BASE+DIALOG_PRINTER_PROPS
#define DIALOG_STRING_JOB_PROPS                  STRING_TABLE_DLG_BASE+DIALOG_JOB_PROPS
#define DIALOG_STRING_DEV_MEMORY                 STRING_TABLE_DLG_BASE+DIALOG_DEV_MEMORY
#define DIALOG_STRING_DEV_VERSION                STRING_TABLE_DLG_BASE+DIALOG_DEV_VERSION
#define DIALOG_STRING_ON                         STRING_TABLE_DLG_BASE+DIALOG_ON
#define DIALOG_STRING_OFF                        STRING_TABLE_DLG_BASE+DIALOG_OFF
#define DIALOG_STRING_NORMAL                     STRING_TABLE_DLG_BASE+DIALOG_NORMAL
#define DIALOG_STRING_RESOLUTION                 STRING_TABLE_DLG_BASE+DIALOG_RESOLUTION
#define DIALOG_STRING_DEF_TRAYS                  STRING_TABLE_DLG_BASE+DIALOG_DEF_TRAYS
#define DIALOG_STRING_TRAY_NAME                  STRING_TABLE_DLG_BASE+DIALOG_TRAY_NAME
#define DIALOG_STRING_TRAY_TYPE                  STRING_TABLE_DLG_BASE+DIALOG_TRAY_TYPE
#define DIALOG_STRING_AUTOMATIC                  STRING_TABLE_DLG_BASE+DIALOG_AUTOMATIC
#define DIALOG_STRING_MANUAL                     STRING_TABLE_DLG_BASE+DIALOG_MANUAL
#define DIALOG_STRING_COMPRESSION                STRING_TABLE_DLG_BASE+DIALOG_COMPRESSION
#define DIALOG_STRING_DEGREES                    STRING_TABLE_DLG_BASE+DIALOG_DEGREES
#define DIALOG_STRING_FONT_NLQ                   STRING_TABLE_DLG_BASE+DIALOG_FONT_NLQ
#define DIALOG_STRING_FONT_DRAFT                 STRING_TABLE_DLG_BASE+DIALOG_FONT_DRAFT
#define DIALOG_STRING_FONT_SIZE                  STRING_TABLE_DLG_BASE+DIALOG_FONT_SIZE
#define DIALOG_STRING_CONDITIONAL                STRING_TABLE_DLG_BASE+DIALOG_CONDITIONAL
#define DIALOG_STRING_COMPULSORY                 STRING_TABLE_DLG_BASE+DIALOG_COMPULSORY
#define DIALOG_STRING_DRY_TIMER                  STRING_TABLE_DLG_BASE+DIALOG_DRY_TIMER
#define DIALOG_STRING_DEFAULT_FONT               STRING_TABLE_DLG_BASE+DIALOG_DEFAULT_FONT
#define DIALOG_STRING_NONE_AVAILABLE             STRING_TABLE_DLG_BASE+DIALOG_NONE_AVAILABLE
#define DIALOG_STRING_FONT_TYPE                  STRING_TABLE_DLG_BASE+DIALOG_FONT_TYPE
#define DIALOG_STRING_PROPORTIONAL               STRING_TABLE_DLG_BASE+DIALOG_PROPORTIONAL
#define DIALOG_STRING_FIXED                      STRING_TABLE_DLG_BASE+DIALOG_FIXED
#define DIALOG_STRING_SCALABLE                   STRING_TABLE_DLG_BASE+DIALOG_SCALABLE
#define DIALOG_STRING_HUE                        STRING_TABLE_DLG_BASE+DIALOG_HUE
#define DIALOG_STRING_SATURATION                 STRING_TABLE_DLG_BASE+DIALOG_SATURATION
#define DIALOG_STRING_DARKNESS                   STRING_TABLE_DLG_BASE+DIALOG_DARKNESS
#define DIALOG_STRING_PAPER_REQUEST              STRING_TABLE_DLG_BASE+DIALOG_PAPER_REQUEST
#define DIALOG_STRING_INSERT_MANUAL              STRING_TABLE_DLG_BASE+DIALOG_INSERT_MANUAL
#define DIALOG_STRING_GAMMA                      STRING_TABLE_DLG_BASE+DIALOG_GAMMA
#define DIALOG_STRING_MAINTENANCE                STRING_TABLE_DLG_BASE+DIALOG_MAINTENANCE
#define STRING_TABLE_DLG_END                     STRING_TABLE_DLG_BASE+DIALOG_MAINTENANCE+1

#define STRING_TABLE_CLR_BASE                    STRING_TABLE_DLG_END
#define COLOR_STRING_BLACK                       STRING_TABLE_CLR_BASE+COLOR_BLACK
#define COLOR_STRING_BLUE                        STRING_TABLE_CLR_BASE+COLOR_BLUE
#define COLOR_STRING_GREEN                       STRING_TABLE_CLR_BASE+COLOR_GREEN
#define COLOR_STRING_CYAN                        STRING_TABLE_CLR_BASE+COLOR_CYAN
#define COLOR_STRING_RED                         STRING_TABLE_CLR_BASE+COLOR_RED
#define COLOR_STRING_PINK                        STRING_TABLE_CLR_BASE+COLOR_PINK
#define COLOR_STRING_YELLOW                      STRING_TABLE_CLR_BASE+COLOR_YELLOW
#define COLOR_STRING_WHITE                       STRING_TABLE_CLR_BASE+COLOR_WHITE
#define COLOR_STRING_BROWN                       STRING_TABLE_CLR_BASE+COLOR_BROWN
#define COLOR_STRING_DARK_GRAY                   STRING_TABLE_CLR_BASE+COLOR_DARK_GRAY
#define COLOR_STRING_DARK_BLUE                   STRING_TABLE_CLR_BASE+COLOR_DARK_BLUE
#define COLOR_STRING_DARK_RED                    STRING_TABLE_CLR_BASE+COLOR_DARK_RED
#define COLOR_STRING_DARK_GREEN                  STRING_TABLE_CLR_BASE+COLOR_DARK_GREEN
#define COLOR_STRING_DARK_CYAN                   STRING_TABLE_CLR_BASE+COLOR_DARK_CYAN
#define COLOR_STRING_DARK_PINK                   STRING_TABLE_CLR_BASE+COLOR_DARK_PINK
#define COLOR_STRING_PALE_GRAY                   STRING_TABLE_CLR_BASE+COLOR_PALE_GRAY
#define COLOR_STRING_MAGENTA                     STRING_TABLE_CLR_BASE+COLOR_MAGENTA         //jk1115
#define STRING_TABLE_CLR_END                     STRING_TABLE_CLR_BASE+COLOR_MAGENTA+1       //jk1115

#define STRING_TABLE_COMPRESS_BASE               STRING_TABLE_CLR_END
#define COMPRESS_STRING_RLL                      STRING_TABLE_COMPRESS_BASE+COMPRESS_RLL
#define COMPRESS_STRING_TIFF                     STRING_TABLE_COMPRESS_BASE+COMPRESS_TIFF
#define COMPRESS_STRING_DELTAROW                 STRING_TABLE_COMPRESS_BASE+COMPRESS_DELTAROW
#define COMPRESS_STRING_RLLDELTAROW              STRING_TABLE_COMPRESS_BASE+COMPRESS_RLLDELTAROW
#define STRING_TABLE_COMPRESS_END                STRING_TABLE_COMPRESS_BASE+COMPRESS_RLLDELTAROW+1

#define STRING_TABLE_HALFTONE_BASE               STRING_TABLE_COMPRESS_END
#define HALFTONE_STRING_LEVEL                    STRING_TABLE_HALFTONE_BASE+DITHER_LEVEL
#define HALFTONE_STRING_DITHER_4x4               STRING_TABLE_HALFTONE_BASE+DITHER_DITHER_4x4
#define HALFTONE_STRING_DITHER_8x8               STRING_TABLE_HALFTONE_BASE+DITHER_DITHER_8x8
#define HALFTONE_STRING_ERR_DIFFUSE              STRING_TABLE_HALFTONE_BASE+DITHER_ERR_DIFFUSION
#define HALFTONE_STRING_MAGIC_SQUARES            STRING_TABLE_HALFTONE_BASE+DITHER_MAGIC_SQUARES
#define HALFTONE_STRING_ORDERED_SQUARES          STRING_TABLE_HALFTONE_BASE+DITHER_ORDERED_SQUARES
#define HALFTONE_STRING_ADAPTIVE_DIFFUSE         STRING_TABLE_HALFTONE_BASE+DITHER_ADAPTIVE_DIFFUSION
#define HALFTONE_STRING_FAST_DIFFUSE             STRING_TABLE_HALFTONE_BASE+DITHER_FAST_DIFFUSION
#define HALFTONE_STRING_STEINBERG_DIFFUSE        STRING_TABLE_HALFTONE_BASE+DITHER_STEINBERG_DIFFUSION
#define HALFTONE_STRING_SMOOTH_DIFFUSION         STRING_TABLE_HALFTONE_BASE+DITHER_SMOOTH_DIFFUSION
#define HALFTONE_STRING_HSV_DIFFUSION            STRING_TABLE_HALFTONE_BASE+DITHER_HSV_DIFFUSION
#define HALFTONE_STRING_HSV_BIDIFFUSION          STRING_TABLE_HALFTONE_BASE+DITHER_HSV_BIDIFFUSION
#define HALFTONE_STRING_CMYK_DIFFUSION           STRING_TABLE_HALFTONE_BASE+DITHER_CMYK_DIFFUSION
#define HALFTONE_STRING_VOID_CLUSTER_DIFFUSION   STRING_TABLE_HALFTONE_BASE+DITHER_VOID_CLUSTER_DIFFUSION    // jk1115
#define HALFTONE_STRING_JANIS_STUCKI_DIFFUSION   STRING_TABLE_HALFTONE_BASE+DITHER_JANIS_STUCKI_DIFFUSION    // jk1115
#define HALFTONE_STRING_ERR_DIFFUSE6             STRING_TABLE_HALFTONE_BASE+DITHER_ERR_DIFFUSION6
#define HALFTONE_STRING_ERR_DIFFUSE5             STRING_TABLE_HALFTONE_BASE+DITHER_ERR_DIFFUSION5
#define STRING_TABLE_HALFTONE_END                STRING_TABLE_HALFTONE_BASE+DITHER_ERR_DIFFUSION5+1

//#define STRING_TABLE_MAINTENANCE_BASE            STRING_TABLE_HALFTONE_END
//#define MAINTENANCE_STRING_STRING_OK             STRING_TABLE_MAINTENANCE_BASE+MAINTENANCE_OK
//#define MAINTENANCE_STRING_STRING_CANCEL         STRING_TABLE_MAINTENANCE_BASE+MAINTENANCE_CANCEL
//#define MAINTENANCE_STRING_STRING_ENTRY          STRING_TABLE_MAINTENANCE_BASE+MAINTENANCE_ENTRY
//#define STRING_TABLE_MAINTENANCE_END             STRING_TABLE_MAINTENANCE_BASE+MAINTENANCE_ENTRY+1

//#define STRING_TABLE_WARN_BASE                   STRING_TABLE_MAINTENANCE_END
#define STRING_TABLE_WARN_BASE                   STRING_TABLE_HALFTONE_END
#define WARN_STRING_ADD_FORM                     STRING_TABLE_WARN_BASE+WARNING_ADD_FORM
#define WARN_STRING_ADD_FONT                     STRING_TABLE_WARN_BASE+WARNING_ADD_FONT
#define WARN_STRING_ADD_TRAY                     STRING_TABLE_WARN_BASE+WARNING_ADD_TRAY
#define WARN_STRING_ADD_CONNECT                  STRING_TABLE_WARN_BASE+WARNING_ADD_CONNECT
#define WARN_STRING_DELETE_FORM                  STRING_TABLE_WARN_BASE+WARNING_DELETE_FORM
#define WARN_STRING_DELETE_FONT                  STRING_TABLE_WARN_BASE+WARNING_DELETE_FONT
#define WARN_STRING_DELETE_TRAY                  STRING_TABLE_WARN_BASE+WARNING_DELETE_TRAY
#define WARN_STRING_DELETE_CONNECT               STRING_TABLE_WARN_BASE+WARNING_DELETE_CONNECT
#define WARN_STRING_MODIFY_FORM                  STRING_TABLE_WARN_BASE+WARNING_MODIFY_FORM
#define WARN_STRING_MODIFY_FONT                  STRING_TABLE_WARN_BASE+WARNING_MODIFY_FONT
#define WARN_STRING_MODIFY_TRAY                  STRING_TABLE_WARN_BASE+WARNING_MODIFY_TRAY
#define WARN_STRING_ADD_MSG_FORM                 STRING_TABLE_WARN_BASE+WARNING_ADD_MSG_FORM
#define WARN_STRING_ADD_MSG_FONT                 STRING_TABLE_WARN_BASE+WARNING_ADD_MSG_FONT
#define WARN_STRING_ADD_MSG_TRAY                 STRING_TABLE_WARN_BASE+WARNING_ADD_MSG_TRAY
#define WARN_STRING_ADD_MSG_CONNECT              STRING_TABLE_WARN_BASE+WARNING_ADD_MSG_CONNECT
#define WARN_STRING_DELETE_MSG_FORM              STRING_TABLE_WARN_BASE+WARNING_DELETE_MSG_FORM
#define WARN_STRING_DELETE_MSG_FONT              STRING_TABLE_WARN_BASE+WARNING_DELETE_MSG_FONT
#define WARN_STRING_DELETE_MSG_TRAY              STRING_TABLE_WARN_BASE+WARNING_DELETE_MSG_TRAY
#define WARN_STRING_DELETE_MSG_CONNECT           STRING_TABLE_WARN_BASE+WARNING_DELETE_MSG_CONNECT
#define WARN_STRING_SELECT_MSG_FORM              STRING_TABLE_WARN_BASE+WARNING_SELECT_MSG_FORM
#define WARN_STRING_SELECT_MSG_FONT              STRING_TABLE_WARN_BASE+WARNING_SELECT_MSG_FONT
#define WARN_STRING_SELECT_MSG_TRAY              STRING_TABLE_WARN_BASE+WARNING_SELECT_MSG_TRAY
#define WARN_STRING_SELECT_MSG_CONNECT           STRING_TABLE_WARN_BASE+WARNING_SELECT_MSG_CONNECT
#define WARN_STRING_MODIFY_MSG_FORM              STRING_TABLE_WARN_BASE+WARNING_MODIFY_MSG_FORM
#define WARN_STRING_MODIFY_MSG_FONT              STRING_TABLE_WARN_BASE+WARNING_MODIFY_MSG_FONT
#define WARN_STRING_MODIFY_MSG_TRAY              STRING_TABLE_WARN_BASE+WARNING_MODIFY_MSG_TRAY
#define WARN_STRING_MODIFY_MSG_CONNECT           STRING_TABLE_WARN_BASE+WARNING_MODIFY_MSG_CONNECT
#define WARN_STRING_FORM_IN_USE                  STRING_TABLE_WARN_BASE+WARNING_FORM_IN_USE
#define WARN_STRING_CHANGES_LOST                 STRING_TABLE_WARN_BASE+WARNING_STRING_CHANGES_LOST
#define STRING_TABLE_WARN_END                    STRING_TABLE_WARN_BASE+WARNING_STRING_CHANGES_LOST+1

#define STRING_TABLE_MSG_BASE                    STRING_TABLE_WARN_END
#define MSG_STR_CTX_HELP                         STRING_TABLE_MSG_BASE+MSG_CTX_HELP
#define MSG_STR_ADD_SIZE_BUTTON                  STRING_TABLE_MSG_BASE+MSG_ADD_SIZE_BUTTON
#define MSG_STR_DEL_SIZE_BUTTON                  STRING_TABLE_MSG_BASE+MSG_DEL_SIZE_BUTTON
#define MSG_STR_MOD_SIZE_BUTTON                  STRING_TABLE_MSG_BASE+MSG_MOD_SIZE_BUTTON
#define MSG_STR_ADD_TRAY_BUTTON                  STRING_TABLE_MSG_BASE+MSG_ADD_TRAY_BUTTON
#define MSG_STR_DEL_TRAY_BUTTON                  STRING_TABLE_MSG_BASE+MSG_DEL_TRAY_BUTTON
#define MSG_STR_MOD_TRAY_BUTTON                  STRING_TABLE_MSG_BASE+MSG_MOD_TRAY_BUTTON
#define MSG_STR_JOB_NOTEBOOK                     STRING_TABLE_MSG_BASE+MSG_JOB_NOTEBOOK
#define MSG_STR_JOB_OK                           STRING_TABLE_MSG_BASE+MSG_JOB_OK
#define MSG_STR_JOB_CANCEL                       STRING_TABLE_MSG_BASE+MSG_JOB_CANCEL
#define MSG_STR_JOB_HELP                         STRING_TABLE_MSG_BASE+MSG_JOB_HELP
#define MSG_STR_JOB_UNDO                         STRING_TABLE_MSG_BASE+MSG_JOB_UNDO
#define MSG_STR_JOB_DEFAULTS                     STRING_TABLE_MSG_BASE+MSG_JOB_DEFAULTS
#define MSG_STR_PRN_NOTEBOOK                     STRING_TABLE_MSG_BASE+MSG_PRN_NOTEBOOK
#define MSG_STR_PRN_OK                           STRING_TABLE_MSG_BASE+MSG_PRN_OK
#define MSG_STR_PRN_CANCEL                       STRING_TABLE_MSG_BASE+MSG_PRN_CANCEL
#define MSG_STR_PRN_HELP                         STRING_TABLE_MSG_BASE+MSG_PRN_HELP
#define MSG_STR_PRN_DEV_DEFS                     STRING_TABLE_MSG_BASE+MSG_PRN_DEV_DEFS
#define MSG_STR_PRN_UNDO                         STRING_TABLE_MSG_BASE+MSG_PRN_UNDO
#define MSG_STR_PRN_DEFAULTS                     STRING_TABLE_MSG_BASE+MSG_PRN_DEFAULTS
#define MSG_STR_MONO_PAGE                        STRING_TABLE_MSG_BASE+MSG_MONO_PAGE
#define MSG_STR_MONO_DARKNESS                    STRING_TABLE_MSG_BASE+MSG_MONO_DARKNESS
#define MSG_STR_MONO_FG_CLR                      STRING_TABLE_MSG_BASE+MSG_MONO_FG_CLR
#define MSG_STR_MONO_BG_CLR                      STRING_TABLE_MSG_BASE+MSG_MONO_BG_CLR
#define MSG_STR_COMMON_PAGE                      STRING_TABLE_MSG_BASE+MSG_COMMON_PAGE
#define MSG_STR_COMMON_FORM                      STRING_TABLE_MSG_BASE+MSG_COMMON_FORM
#define MSG_STR_COMMON_RESOLUTIONS               STRING_TABLE_MSG_BASE+MSG_COMMON_RESOLUTIONS
#define MSG_STR_COMMON_PRINT_MODE                STRING_TABLE_MSG_BASE+MSG_COMMON_PRINT_MODE
#define MSG_STR_COMMON_CONDITIONAL               STRING_TABLE_MSG_BASE+MSG_COMMON_CONDITIONAL
#define MSG_STR_COMMON_NONE                      STRING_TABLE_MSG_BASE+MSG_COMMON_NONE
#define MSG_STR_COMMON_COMPULSORY                STRING_TABLE_MSG_BASE+MSG_COMMON_COMPULSORY
#define MSG_STR_COMMON_ORIENTATION               STRING_TABLE_MSG_BASE+MSG_COMMON_ORIENTATION
#define MSG_STR_COMMON_PORTRAIT                  STRING_TABLE_MSG_BASE+MSG_COMMON_PORTRAIT
#define MSG_STR_COMMON_LANDSCAPE                 STRING_TABLE_MSG_BASE+MSG_COMMON_LANDSCAPE
#define MSG_STR_COMMON_DUPLEX                    STRING_TABLE_MSG_BASE+MSG_COMMON_DUPLEX
#define MSG_STR_COMMON_ONE                       STRING_TABLE_MSG_BASE+MSG_COMMON_ONE
#define MSG_STR_COMMON_FLIP                      STRING_TABLE_MSG_BASE+MSG_COMMON_FLIP
#define MSG_STR_COMMON_BOOK                      STRING_TABLE_MSG_BASE+MSG_COMMON_BOOK
#define MSG_STR_COMMON_MIRROR                    STRING_TABLE_MSG_BASE+MSG_COMMON_MIRROR
#define MSG_STR_COLOR_PAGE                       STRING_TABLE_MSG_BASE+MSG_COLOR_PAGE
#define MSG_STR_CLR_DITHER_ALGO                  STRING_TABLE_MSG_BASE+MSG_CLR_DITHER_ALGO
#define MSG_STR_CLR_DITHER_LVL                   STRING_TABLE_MSG_BASE+MSG_CLR_DITHER_LVL
#define MSG_STR_CLR_GAMMA_RED                    STRING_TABLE_MSG_BASE+MSG_CLR_GAMMA_RED
#define MSG_STR_CLR_GAMMA_GREEN                  STRING_TABLE_MSG_BASE+MSG_CLR_GAMMA_GREEN
#define MSG_STR_CLR_GAMMA_BLUE                   STRING_TABLE_MSG_BASE+MSG_CLR_GAMMA_BLUE
#define MSG_STR_CLR_GAMMA_BLACK                  STRING_TABLE_MSG_BASE+MSG_CLR_GAMMA_BLACK
#define MSG_STR_CLR_BIAS_RED                     STRING_TABLE_MSG_BASE+MSG_CLR_BIAS_RED
#define MSG_STR_CLR_BIAS_GREEN                   STRING_TABLE_MSG_BASE+MSG_CLR_BIAS_GREEN
#define MSG_STR_CLR_BIAS_BLUE                    STRING_TABLE_MSG_BASE+MSG_CLR_BIAS_BLUE
#define MSG_STR_HSV_PAGE                         STRING_TABLE_MSG_BASE+MSG_HSV_PAGE
#define MSG_STR_HSV_HUE                          STRING_TABLE_MSG_BASE+MSG_HSV_HUE
#define MSG_STR_HSV_SATURATION                   STRING_TABLE_MSG_BASE+MSG_HSV_SATURATION
#define MSG_STR_HSV_DARKNESS                     STRING_TABLE_MSG_BASE+MSG_HSV_DARKNESS
#define MSG_STR_CONNECT_PAGE                     STRING_TABLE_MSG_BASE+MSG_CONNECT_PAGE
#define MSG_STR_CONNECT_TRAY                     STRING_TABLE_MSG_BASE+MSG_CONNECT_TRAY
#define MSG_STR_CONNECT_SIZE                     STRING_TABLE_MSG_BASE+MSG_CONNECT_SIZE
#define MSG_STR_CONNECT_MEDIA                    STRING_TABLE_MSG_BASE+MSG_CONNECT_MEDIA
#define MSG_STR_CONNECT_CONNECT                  STRING_TABLE_MSG_BASE+MSG_CONNECT_CONNECT
#define MSG_STR_CONNECT_ADD                      STRING_TABLE_MSG_BASE+MSG_CONNECT_ADD
#define MSG_STR_CONNECT_REMOVE                   STRING_TABLE_MSG_BASE+MSG_CONNECT_REMOVE
#define MSG_STR_FORM_PAGE                        STRING_TABLE_MSG_BASE+MSG_FORM_PAGE
#define MSG_STR_FORM_LIST                        STRING_TABLE_MSG_BASE+MSG_FORM_LIST
#define MSG_STR_FORM_NAME                        STRING_TABLE_MSG_BASE+MSG_FORM_NAME
#define MSG_STR_FORM_CMD                         STRING_TABLE_MSG_BASE+MSG_FORM_CMD
#define MSG_STR_FORM_WIDTH                       STRING_TABLE_MSG_BASE+MSG_FORM_WIDTH
#define MSG_STR_FORM_HEIGHT                      STRING_TABLE_MSG_BASE+MSG_FORM_HEIGHT
#define MSG_STR_FORM_LEFT_CLIP                   STRING_TABLE_MSG_BASE+MSG_FORM_LEFT_CLIP
#define MSG_STR_FORM_RIGHT_CLIP                  STRING_TABLE_MSG_BASE+MSG_FORM_RIGHT_CLIP
#define MSG_STR_FORM_TOP_CLIP                    STRING_TABLE_MSG_BASE+MSG_FORM_TOP_CLIP
#define MSG_STR_FORM_BOT_CLIP                    STRING_TABLE_MSG_BASE+MSG_FORM_BOT_CLIP
#define MSG_STR_FORM_INCHES                      STRING_TABLE_MSG_BASE+MSG_FORM_INCHES
#define MSG_STR_FORM_CENTIMETERS                 STRING_TABLE_MSG_BASE+MSG_FORM_CENTIMETERS
#define MSG_STR_FORM_CLASS                       STRING_TABLE_MSG_BASE+MSG_FORM_CLASS
#define MSG_STR_FORM_TYPE_TITLE                  STRING_TABLE_MSG_BASE+MSG_FORM_TYPE_TITLE
#define MSG_STR_FORM_TYPE_VALUE                  STRING_TABLE_MSG_BASE+MSG_FORM_TYPE_VALUE
#define MSG_STR_TRAY_PAGE                        STRING_TABLE_MSG_BASE+MSG_TRAY_PAGE
#define MSG_STR_TRAY_LIST                        STRING_TABLE_MSG_BASE+MSG_TRAY_LIST
#define MSG_STR_TRAY_NAME                        STRING_TABLE_MSG_BASE+MSG_TRAY_NAME
#define MSG_STR_TRAY_CMD                         STRING_TABLE_MSG_BASE+MSG_TRAY_CMD
#define MSG_STR_TRAY_AUTOMATIC                   STRING_TABLE_MSG_BASE+MSG_TRAY_AUTOMATIC
#define MSG_STR_TRAY_MANUAL                      STRING_TABLE_MSG_BASE+MSG_TRAY_MANUAL
#define MSG_STR_COMMAND_PAGE                     STRING_TABLE_MSG_BASE+MSG_COMMAND_PAGE
#define MSG_STR_COMMAND_CMD_INIT                 STRING_TABLE_MSG_BASE+MSG_COMMAND_CMD_INIT
#define MSG_STR_COMMAND_FILE_INIT                STRING_TABLE_MSG_BASE+MSG_COMMAND_FILE_INIT
#define MSG_STR_COMMAND_CMD_TERM                 STRING_TABLE_MSG_BASE+MSG_COMMAND_CMD_TERM
#define MSG_STR_COMMAND_FILE_TERM                STRING_TABLE_MSG_BASE+MSG_COMMAND_FILE_TERM
#define MSG_STR_COMMAND_CMD_FF                   STRING_TABLE_MSG_BASE+MSG_COMMAND_CMD_FF
#define MSG_STR_COMMAND_FILE_FF                  STRING_TABLE_MSG_BASE+MSG_COMMAND_FILE_FF
#define MSG_STR_COMMAND_CMD_ABORT                STRING_TABLE_MSG_BASE+MSG_COMMAND_CMD_ABORT
#define MSG_STR_COMMAND_FILE_ABORT               STRING_TABLE_MSG_BASE+MSG_COMMAND_FILE_ABORT
#define MSG_STR_CLR_BIAS_BLACK                   STRING_TABLE_MSG_BASE+MSG_CLR_BIAS_BLACK           //jk1115
#define MSG_STR_COPIES_NUMBER                    STRING_TABLE_MSG_BASE+MSG_COPIES_NUMBER            
#define MSG_STR_COLLATE                          STRING_TABLE_MSG_BASE+MSG_COLLATE                  
#define MSG_STR_TEST                             STRING_TABLE_MSG_BASE+MSG_TEST                     //@Maintenance
#define MSG_STR_DEMO                             STRING_TABLE_MSG_BASE+MSG_DEMO                     //@Maintenance
#define MSG_STR_NOZZLE                           STRING_TABLE_MSG_BASE+MSG_NOZZLE                   //@Maintenance
#define MSG_STR_EXIT                             STRING_TABLE_MSG_BASE+MSG_EXIT                     //@Maintenance
#define MSG_STR_CLEANING                         STRING_TABLE_MSG_BASE+MSG_CLEANING                 //@Maintenance
#define MSG_STR_MAINTENANCE                      STRING_TABLE_MSG_BASE+MSG_MAINTENANCE              //@Maintenance
#define MSG_STR_ALIGNMENT                        STRING_TABLE_MSG_BASE+MSG_ALIGNMENT                //@Maintenance
#define STRING_TABLE_MSG_END                     STRING_TABLE_MSG_BASE+MSG_ALIGNMENT+1              //sx

#ifdef DEBUG
#define STRING_TABLE_FUNC_BASE                   STRING_TABLE_MSG_END
#define FUNC_STRING_ADDDEFINEDFORM               STRING_TABLE_FUNC_BASE+FUNC_ADDDEFINEDFORM
#define FUNC_STRING_ADDUSERDEFINEDFORMENTRY      STRING_TABLE_FUNC_BASE+FUNC_ADDUSERDEFINEDFORMENTRY
#define FUNC_STRING_ADDUSERDEFINEDTRAYENTRY      STRING_TABLE_FUNC_BASE+FUNC_ADDUSERDEFINEDTRAYENTRY
#define FUNC_STRING_ATTRIBUTEBUNDLESLINE         STRING_TABLE_FUNC_BASE+FUNC_ATTRIBUTEBUNDLESLINE
#define FUNC_STRING_ATTRIBUTEBUNDLESAREA         STRING_TABLE_FUNC_BASE+FUNC_ATTRIBUTEBUNDLESAREA
#define FUNC_STRING_ATTRIBUTEBUNDLESCHAR         STRING_TABLE_FUNC_BASE+FUNC_ATTRIBUTEBUNDLESCHAR
#define FUNC_STRING_ATTRIBUTEBUNDLESIMAGE        STRING_TABLE_FUNC_BASE+FUNC_ATTRIBUTEBUNDLESIMAGE
#define FUNC_STRING_ATTRIBUTEBUNDLESMARKER       STRING_TABLE_FUNC_BASE+FUNC_ATTRIBUTEBUNDLESMARKER
#define FUNC_STRING_BUILDAPPNAME                 STRING_TABLE_FUNC_BASE+FUNC_BUILDAPPNAME
#define FUNC_STRING_CALCULATEFONTMETRICS         STRING_TABLE_FUNC_BASE+FUNC_CALCULATEFONTMETRICS
#define FUNC_STRING_CHECKLOGICALADDRESS          STRING_TABLE_FUNC_BASE+FUNC_CHECKLOGICALADDRESS
#define FUNC_STRING_CREATEUNIQUEFORMID           STRING_TABLE_FUNC_BASE+FUNC_CREATEUNIQUEFORMID
#define FUNC_STRING_CREATEUNIQUETRAYID           STRING_TABLE_FUNC_BASE+FUNC_CREATEUNIQUETRAYID
#define FUNC_STRING_DEBUGOUTPUT                  STRING_TABLE_FUNC_BASE+FUNC_DEBUGOUTPUT
#define FUNC_STRING_DELETEUSERDEFINEDFORMENTRY   STRING_TABLE_FUNC_BASE+FUNC_DELETEUSERDEFINEDFORMENTRY
#define FUNC_STRING_DELETEUSERDEFINEDTRAYENTRY   STRING_TABLE_FUNC_BASE+FUNC_DELETEUSERDEFINEDTRAYENTRY
#define FUNC_STRING_DEVICEQUERYFONTS             STRING_TABLE_FUNC_BASE+FUNC_DEVICEQUERYFONTS
#define FUNC_STRING_DEVICEQUERYFONTATTRIBUTES    STRING_TABLE_FUNC_BASE+FUNC_DEVICEQUERYFONTATTRIBUTES
#define FUNC_STRING_DRVINSTALL                   STRING_TABLE_FUNC_BASE+FUNC_DRVINSTALL
#define FUNC_STRING_ENABLE_BEGIN_CLOSE_DC        STRING_TABLE_FUNC_BASE+FUNC_ENABLE_BEGIN_CLOSE_DC
#define FUNC_STRING_ENABLE_COMPLETE_OPEN_DC      STRING_TABLE_FUNC_BASE+FUNC_ENABLE_COMPLETE_OPEN_DC
#define FUNC_STRING_ENABLE_DISABLE_DC            STRING_TABLE_FUNC_BASE+FUNC_ENABLE_DISABLE_DC
#define FUNC_STRING_ENABLE_DISABLE_PHYSICAL      STRING_TABLE_FUNC_BASE+FUNC_ENABLE_DISABLE_PHYSICAL
#define FUNC_STRING_ENABLE_ENABLE_DC             STRING_TABLE_FUNC_BASE+FUNC_ENABLE_ENABLE_DC
#define FUNC_STRING_ENABLE_FILL_LOGICAL          STRING_TABLE_FUNC_BASE+FUNC_ENABLE_FILL_LOGICAL
#define FUNC_STRING_ENABLE_FILL_PHYSICAL         STRING_TABLE_FUNC_BASE+FUNC_ENABLE_FILL_PHYSICAL
#define FUNC_STRING_ENABLE_RESET_DC              STRING_TABLE_FUNC_BASE+FUNC_ENABLE_RESET_DC
#define FUNC_STRING_ENABLE_RESTORE_DC            STRING_TABLE_FUNC_BASE+FUNC_ENABLE_RESTORE_DC
#define FUNC_STRING_ENABLE_SAVE_DC               STRING_TABLE_FUNC_BASE+FUNC_ENABLE_SAVE_DC
#define FUNC_STRING_FILLFONTLIST                 STRING_TABLE_FUNC_BASE+FUNC_FILLFONTLIST
#define FUNC_STRING_FILLFORMLIST                 STRING_TABLE_FUNC_BASE+FUNC_FILLFORMLIST
#define FUNC_STRING_FILLMEDIALIST                STRING_TABLE_FUNC_BASE+FUNC_FILLMEDIALIST
#define FUNC_STRING_FILLPRINTMODELIST            STRING_TABLE_FUNC_BASE+FUNC_FILLPRINTMODELIST
#define FUNC_STRING_FILLRESOLUTIONLIST           STRING_TABLE_FUNC_BASE+FUNC_FILLRESOLUTIONLIST
#define FUNC_STRING_FILLTRAYLIST                 STRING_TABLE_FUNC_BASE+FUNC_FILLTRAYLIST
#define FUNC_STRING_FINDPRINTERNAME              STRING_TABLE_FUNC_BASE+FUNC_FINDPRINTERNAME
#define FUNC_STRING_FORMIDFROMNAME               STRING_TABLE_FUNC_BASE+FUNC_FORMIDFROMNAME
#define FUNC_STRING_FORMINFOFROMID               STRING_TABLE_FUNC_BASE+FUNC_FORMINFOFROMID
#define FUNC_STRING_FORMINFOFROMNAME             STRING_TABLE_FUNC_BASE+FUNC_FORMINFOFROMNAME
#define FUNC_STRING_FORMNAMEFROMID               STRING_TABLE_FUNC_BASE+FUNC_FORMNAMEFROMID
#define FUNC_STRING_FREESTRINGTABLE              STRING_TABLE_FUNC_BASE+FUNC_FREESTRINGTABLE
#define FUNC_STRING_FREEUSERDEFINEDFORMLIST      STRING_TABLE_FUNC_BASE+FUNC_FREEUSERDEFINEDFORMLIST
#define FUNC_STRING_FREEUSERDEFINEDTRAYLIST      STRING_TABLE_FUNC_BASE+FUNC_FREEUSERDEFINEDTRAYLIST
#define FUNC_STRING_CREATENOTEBOOKPAGES          STRING_TABLE_FUNC_BASE+FUNC_CREATENOTEBOOKPAGES
#define FUNC_STRING_GETDEFAULTFONTINFO           STRING_TABLE_FUNC_BASE+FUNC_GETDEFAULTFONTINFO
#define FUNC_STRING_GETDEFAULTFORMINFO           STRING_TABLE_FUNC_BASE+FUNC_GETDEFAULTFORMINFO
#define FUNC_STRING_GETIDSFROMCONNID             STRING_TABLE_FUNC_BASE+FUNC_GETIDSFROMCONNID
#define FUNC_STRING_INITSTRINGTABLE              STRING_TABLE_FUNC_BASE+FUNC_INITSTRINGTABLE
#define FUNC_STRING_ISFORMNAMEUNIQUE             STRING_TABLE_FUNC_BASE+FUNC_ISFORMNAMEUNIQUE
#define FUNC_STRING_MEDIANAMEFROMID              STRING_TABLE_FUNC_BASE+FUNC_MEDIANAMEFROMID
#define FUNC_STRING_OMNICREATEHELPINSTANCE       STRING_TABLE_FUNC_BASE+FUNC_OMNICREATEHELPINSTANCE
#define FUNC_STRING_OMNIDESTROYHELPINSTANCE      STRING_TABLE_FUNC_BASE+FUNC_OMNIDESTROYHELPINSTANCE
#define FUNC_STRING_OS2_PM_DRV_DEVICENAMES       STRING_TABLE_FUNC_BASE+FUNC_OS2_PM_DRV_DEVICENAMES
#define FUNC_STRING_OS2_PM_DRV_DEVMODE           STRING_TABLE_FUNC_BASE+FUNC_OS2_PM_DRV_DEVMODE
#define FUNC_STRING_PDRIVERFROMDEVICENAME        STRING_TABLE_FUNC_BASE+FUNC_PDRIVERFROMDEVICENAME
#define FUNC_STRING_PDEVICEFROMDEVICENAME        STRING_TABLE_FUNC_BASE+FUNC_PDEVICEFROMDEVICENAME
#define FUNC_STRING_QUERYDEVICEBITMAPS           STRING_TABLE_FUNC_BASE+FUNC_QUERYDEVICEBITMAPS
#define FUNC_STRING_QUERYDEVICECAPS              STRING_TABLE_FUNC_BASE+FUNC_QUERYDEVICECAPS
#define FUNC_STRING_QUERYDEVRESOURCE2            STRING_TABLE_FUNC_BASE+FUNC_QUERYDEVRESOURCE2
#define FUNC_STRING_QUERYHARDCOPYCAPS            STRING_TABLE_FUNC_BASE+FUNC_QUERYHARDCOPYCAPS
#define FUNC_STRING_READUSERDEFINEDFORMLIST      STRING_TABLE_FUNC_BASE+FUNC_READUSERDEFINEDFORMLIST
#define FUNC_STRING_READUSERDEFINEDTRAYLIST      STRING_TABLE_FUNC_BASE+FUNC_READUSERDEFINEDTRAYLIST
#define FUNC_STRING_SAVEUSERDEFINEDFORMLIST      STRING_TABLE_FUNC_BASE+FUNC_SAVEUSERDEFINEDFORMLIST
#define FUNC_STRING_SETDRIVERDATADEFAULTS        STRING_TABLE_FUNC_BASE+FUNC_SETDRIVERDATADEFAULTS
#define FUNC_STRING_SUBINITJOB                   STRING_TABLE_FUNC_BASE+FUNC_SUBINITJOB
#define FUNC_STRING_SUBRASTER                    STRING_TABLE_FUNC_BASE+FUNC_SUBRASTER
#define FUNC_STRING_SUBNEWPAGE                   STRING_TABLE_FUNC_BASE+FUNC_SUBNEWPAGE
#define FUNC_STRING_SUBTERMJOB                   STRING_TABLE_FUNC_BASE+FUNC_SUBTERMJOB
#define FUNC_STRING_SUBABORTJOB                  STRING_TABLE_FUNC_BASE+FUNC_SUBABORTJOB
#define FUNC_STRING_SUBRASTERQUERY               STRING_TABLE_FUNC_BASE+FUNC_SUBRASTERQUERY
#define FUNC_STRING_TRAYNAMEFROMID               STRING_TABLE_FUNC_BASE+FUNC_TRAYNAMEFROMID
#define FUNC_STRING_CHARSTRING                   STRING_TABLE_FUNC_BASE+FUNC_CHARSTRING
#define FUNC_STRING_REALIZEFONT                  STRING_TABLE_FUNC_BASE+FUNC_REALIZEFONT
#define FUNC_STRING_DEVICEPALETTE                STRING_TABLE_FUNC_BASE+FUNC_DEVICEPALETTE
#define FUNC_STRING_DEVESC_STARTDOC              STRING_TABLE_FUNC_BASE+FUNC_DEVESC_STARTDOC
#define FUNC_STRING_DEVESC_RAWDATA               STRING_TABLE_FUNC_BASE+FUNC_DEVESC_RAWDATA
#define FUNC_STRING_DEVESC_ENDDOC                STRING_TABLE_FUNC_BASE+FUNC_DEVESC_ENDDOC
#define FUNC_STRING_DEVESC_NEWFRAME              STRING_TABLE_FUNC_BASE+FUNC_DEVESC_NEWFRAME
#define FUNC_STRING_DEVESC_ABORTDOC              STRING_TABLE_FUNC_BASE+FUNC_DEVESC_ABORTDOC
#define FUNC_STRING_DEVESC_QUERYHALFTONESUPPORT  STRING_TABLE_FUNC_BASE+FUNC_DEVESC_QUERYHALFTONESUPPORT
#define FUNC_STRING_DEVESC_QUERYPATTERN          STRING_TABLE_FUNC_BASE+FUNC_DEVESC_QUERYPATTERN
#define FUNC_STRING_DEVESC_QUERYESCSUPPORT       STRING_TABLE_FUNC_BASE+FUNC_DEVESC_QUERYESCSUPPORT
#define FUNC_STRING_DEVESC_GETSCALINGFACTOR      STRING_TABLE_FUNC_BASE+FUNC_DEVESC_GETSCALINGFACTOR
#define FUNC_STRING_DEVESC_QUERYVIOCELLSIZES     STRING_TABLE_FUNC_BASE+FUNC_DEVESC_QUERYVIOCELLSIZES
#define FUNC_STRING_DEVESC_QUERYACTUALRESOLUTION STRING_TABLE_FUNC_BASE+FUNC_DEVESC_QUERYACTUALRESOLUTION
#define FUNC_STRING_DEVESC_GETCP                 STRING_TABLE_FUNC_BASE+FUNC_DEVESC_GETCP
#define FUNC_STRING_DEVESC_NEXTBAND              STRING_TABLE_FUNC_BASE+FUNC_DEVESC_NEXTBAND
#define FUNC_STRING_DEVESC_DRAFTMODE             STRING_TABLE_FUNC_BASE+FUNC_DEVESC_DRAFTMODE
#define FUNC_STRING_DEVESC_FLUSHOUTPUT           STRING_TABLE_FUNC_BASE+FUNC_DEVESC_FLUSHOUTPUT
#define FUNC_STRING_DEVESC_CHAR_EXTRA            STRING_TABLE_FUNC_BASE+FUNC_DEVESC_CHAR_EXTRA
#define FUNC_STRING_DEVESC_BREAK_EXTRA           STRING_TABLE_FUNC_BASE+FUNC_DEVESC_BREAK_EXTRA
#define FUNC_STRING_DEVESC_SETMODE               STRING_TABLE_FUNC_BASE+FUNC_DEVESC_SETMODE
#define FUNC_STRING_DEVESC_DBE_FIRST             STRING_TABLE_FUNC_BASE+FUNC_DEVESC_DBE_FIRST
#define FUNC_STRING_DEVESC_DBE_LAST              STRING_TABLE_FUNC_BASE+FUNC_DEVESC_DBE_LAST
#define FUNC_STRING_DEVESC_STD_JOURNAL           STRING_TABLE_FUNC_BASE+FUNC_DEVESC_STD_JOURNAL
#define STRING_TABLE_FUNC_END                    STRING_TABLE_FUNC_BASE+FUNC_DEVESC_STD_JOURNAL+1
#endif

#ifdef DEBUG
#define STRING_TABLE_END                         STRING_TABLE_FUNC_END
#else
#define STRING_TABLE_END                         STRING_TABLE_MSG_END
#endif

#define HEX2(h,l)                  HEX(h) HEX(l)
#define HEX2S(h,l)                 HEX2(l,h)

//****************************************************************************
//                         Structures
//****************************************************************************

//--------------------------------
// Feature Support Structure
//--------------------------------
typedef struct _FEATUREINFO {
   BOOL  bSupUserDefTrays;
   BOOL  bSupUserDefForms;
   BOOL  bSupUserDefFonts;
   BOOL  bSupUserDefConnects;
} FEATUREINFO;
typedef FEATUREINFO FAR *PFEATUREINFO;


//--------------------------------
// External Subclassed Functions
//--------------------------------

#define DEVICE_ALLOC_HANDLE                  1
#define DEVICE_FREE_HANDLE                   2

#define DEVICE_QUERY_ORIGIN                  3
   #define DEVICE_BOTTOM_ORIGIN              0x0001
   #define DEVICE_TOP_ORIGIN                 0x0002

#define DEVICE_QUERY_ROTATION_CAPS           4
   #define DEVICE_PORTRAIT_OR_LANDSCAPE      0x0001
   #define DEVICE_ALWAYS_PORTRAIT            0x0002
   #define DEVICE_ALWAYS_LANDSCAPE           0x0003

#define DEVICE_QUERY_PRN_DIALOGS             5  // Printer property dialogs
#define DEVICE_QUERY_JOB_DIALOGS             6  // Job property dialogs
#define DEVICE_QUERY_FUNCTIONS               7

// New for adjusting Hardcopy Caps,
// some device need this in landscape
#define DEVICE_QUERY_HCINFO                  8

// begin @EXJOB
#define DEVICE_QUERY_EXTJOBDATA              9
   #define DEVICE_EXTJOBDATA_CURRENT_SIZE    1
   #define DEVICE_EXTJOBDATA_DATA_VALID      2
   #define DEVICE_EXTJOBDATA_SET_DEFAULT     3
// end @EXJOB

/****************************************************************************/
/* current band rectangle location.  This is done in two steps since C      */
/* compilers can't always handle the entire thing at once.                  */
/* TBD - change pddc param to smaller subset of necessary fields - MFR      */
/****************************************************************************/
typedef BOOL (_System FNSTD) (PVOID pVoid,       // PDDC
                              PVOID pvHandle);   // Ptr Device's Handle
typedef FNSTD *PFNSTD;

typedef BOOL (_System RASTER_FUNC) (PBYTE             pbBits,  // From GetBitmapBits
                                    PBITMAPINFO2      pbmi,    // Bitmap info
                                    PSIZEL            pSizelB, // Band size
                                    PSIZEL            pSizelP, // Page size
                                    PRECTL            pRectl,  // Location on page
                                    PVOID             pvHandle,// Device handle
                                    PVOID             pVoid);  // PDDC
typedef RASTER_FUNC *PRASTER_FUNC;

typedef ULONG (_System DEVICE_QUERY_FUNC) (PVOID  pVoid,       // PDDC
                                           ULONG  ulType,      // Type of query
                                           PVOID  pvArg1,
                                           ...);
typedef DEVICE_QUERY_FUNC *PDEVICE_QUERY_FUNC;

struct _AbortData {
       HMCB       hmcbHeap;            // Heap handle

       BOOL       bSendString;         // Send an abort string?
       PSZ        pszAbortString;      // Abort string

       BOOL       bSendRepeatBlock;    // Send an abort byte & count of bytes?
       UCHAR      uchAbortChar;        // Abort byte
       ULONG      ulAbortRepeatCount;  // Abort count of bytes

       BOOL       bSendBlock;          // Send an abort block
       PBYTE      pbAbortBlock;        // Abort block of data
       ULONG      ulAbortBlockSize;    // Length of abort block
};
typedef struct _AbortData ABORT_DATA, *PABORT_DATA;

typedef BOOL (_System ABORT_FUNC) (PVOID       pVoid,          // PDDC
                                   PABORT_DATA pAbortData,     // Abort data
                                   PVOID       pvHandle);      // Device handle
typedef ABORT_FUNC *PABORT_FUNC;

//@SCALABLEFONT - begin
#define DFQF_ALLOCFONTS 0x0001
#define DFQF_FREEFONTS  0x0002
#define DFQF_QUERYCAPS  0x0003
//@SCALABLEFONT - end

typedef ULONG (_System QUERYFONT_FUNC) (PVOID pVoid,        // PDDC
                                        PVOID pDevFonts,    // PFONTINFO2
                                        ULONG ulOptions);
typedef QUERYFONT_FUNC *PQUERYFONT_FUNC;

typedef APIRET (_System DEVICEOPEN) (PVOID  pvDDC,
                                     PVOID  pvHandle,
                                     PVOID  pvLogAddress,
                                     PVOID  pvHFile,
                                     PVOID  pvAction,
                                     ULONG  cbFile,
                                     ULONG  ulAttrs,
                                     ULONG  ulAction,
                                     ULONG  ulAccess,
                                     PVOID  pvEAInfo);
typedef DEVICEOPEN *PDEVOPEN;

typedef APIRET (_System DEVICEWRITE) (PVOID  pvHandle,
                                      HFILE  hDevice,
                                      PVOID  pvData,
                                      ULONG  cbData,
                                      PULONG pcbWritten);
typedef DEVICEWRITE *PDEVWRITE;

typedef APIRET (_System DEVICECLOSE) (PVOID  pvHandle,
                                      HFILE  hDevice);
typedef DEVICECLOSE *PDEVCLOSE;

typedef HSPL (_System SPOOLEROPEN) (PVOID       pvDDC,
                                    PVOID       pvHandle,
                                    PSZ         pszToken,
                                    LONG        lCount,
                                    PQMOPENDATA pqmdopData);
typedef SPOOLEROPEN *PSPLOPEN;

typedef BOOL (_System SPOOLERSTART) (PVOID  pvDDC,
                                     PVOID  pvHandle,
                                     HSPL   hspl,
                                     PSZ    pszDocumentName);
typedef SPOOLERSTART *PSPLSTART;

typedef LONG (_System SPOOLEREND) (PVOID  pvDDC,
                                   PVOID  pvHandle,
                                   HSPL   hspl);
typedef SPOOLEREND *PSPLEND;

typedef BOOL (_System SPOOLERCLOSE) (PVOID  pvDDC,
                                     PVOID  pvHandle,
                                     HSPL   hspl);
typedef SPOOLERCLOSE *PSPLCLOSE;

#define BANDINGSUPPORT_ENABLE_BANDING        1L
#define BANDINGSUPPORT_CREATE                2L
#define BANDINGSUPPORT_DELETE                3L
#define BANDINGSUPPORT_PLAY                  4L
#define BANDINGSUPPORT_ABORT                 5L

typedef BOOL (_System fnBANDINGSUPPORT) (PVOID  pvHandle,
                                         ULONG  ulType,
                                         ...);
typedef fnBANDINGSUPPORT *PFNBANDINGSUPPORT;

#define QUERYPDL_QUERY_NUMBER                1L
#define QUERYPDL_QUERY_PDL                   2L
#define QUERYPDL_ISOK_PDL                    3L
typedef BOOL (_System fnQUERYPDL) (ULONG  ulType,
                                   PPDL   pPDL,
                                   ULONG  ulDeviceID,
                                   ...);
typedef fnQUERYPDL *PFNQUERYPDL;

struct _ResInfo; // Create a forward reference
typedef struct _ResInfo *PRESINFO, **PPRESINFO;
struct _PrintMode; // Create a forward reference
typedef struct _PrintMode FAR *PPRINTMODE, FAR **PPPRINTMODE;

typedef PRESINFO (_System fnQUERYRESINFO) (ULONG          ulDeviceID,
                                           PJOBPROPERTIES pJobProperties);
typedef fnQUERYRESINFO *PFNQUERYRESINFO;

typedef PPRINTMODE (_System fnQUERYPRINTMODE) (ULONG          ulDeviceID,
                                               PJOBPROPERTIES pJobProperties);
typedef fnQUERYPRINTMODE *PFNQUERYPRINTMODE;

#define NInitJob                             0x00000001
#define NRasterizeBand                       0x00000002
#define NNextPage                            0x00000003
#define NTermJob                             0x00000004
#define NAbortJob                            0x00000005
#define NDeviceQuery                         0x00000006
#define NQueryFonts                          0x00000007
#define NDeviceOpen                          0x00000008
#define NDeviceClose                         0x00000009
#define NDeviceWrite                         0x0000000A
#define NSpoolerOpen                         0x0000000B
#define NSpoolerStartJob                     0x0000000C
#define NSpoolerEndJob                       0x0000000D
#define NSpoolerClose                        0x0000000E
#define NBandingSupport                      0x0000000F
#define NQueryPDL                            0x00000010
#define NQueryResInfo                        0x00000011
#define NQueryPrintMode                      0x00000012
#define NPreRawData                          0x00000013     // @JPN2H99
#define NPostRawData                         0x00000014     // @JPN2H99

// @CONSTRAINTS begin

//
// Indicates end of constraints' list
// We can't use 0 because some ID's have this value
//
#define CONSTR_END         -1

//
// Constraints list for concrete printer
// If lMasterItem in lMasterControl has focus, lSlaveItem 
// should be removed from lSlaveControl.
//
typedef struct _DEVCONSTRAINTS {
   LONG                    lMasterControl; // Combo box ID
   LONG                    lMasterItem;    // Item ID in Combo box
   LONG                    lSlaveControl;  // Combo box ID
   LONG                    lSlaveItem;     // Item ID in Combo box
} DEVCONSTRAINTS;

typedef DEVCONSTRAINTS *PDEVCONSTRAINTS, **PPDEVCONSTRAINTS;

//
// Constraints list for all printers
//
typedef struct _DRVCONSTRAINTS {
   LONG                    lDeviceID;      // Printer's ID
   PDEVCONSTRAINTS         pConstraints;   // List of constraints
} DRVCONSTRAINTS;

typedef DRVCONSTRAINTS *PDRVCONSTRAINTS, **PPDRVCONSTRAINTS;

// @CONSTRAINTS end


typedef struct _FNSUBCLASS {
   PFNSTD                  pfnInitJob;
   PRASTER_FUNC            pfnRasterizeBand;
   PFNSTD                  pfnNextPage;
   PFNSTD                  pfnTermJob;
   PABORT_FUNC             pfnAbortJob;
   PDEVICE_QUERY_FUNC      pfnDeviceQuery;
   PQUERYFONT_FUNC         pfnQueryFonts;
   PDEVOPEN                pfnDeviceOpen;
   PDEVCLOSE               pfnDeviceClose;
   PDEVWRITE               pfnDeviceWrite;
   PSPLOPEN                pfnSpoolerOpen;
   PSPLSTART               pfnSpoolerStartJob;
   PSPLEND                 pfnSpoolerEndJob;
   PSPLCLOSE               pfnSpoolerClose;
   PFNBANDINGSUPPORT       pfnBandingSupport;
   PFNQUERYPDL             pfnQueryPDL;
   PFNQUERYRESINFO         pfnQueryResInfo;
   PFNQUERYPRINTMODE       pfnQueryPrintMode;
   PFNSTD                  pfnPreRawData;                   // @JPN2H99
   PFNSTD                  pfnPostRawData;                  // @JPN2H99
} FNSUBCLASS;
typedef FNSUBCLASS *PFNSUBCLASS;

//--------------------------------
// Command Information Structure
//--------------------------------
typedef struct CMDINFO {
   ULONG ulCmdInit;                          // length of Cmd used to Init printer
   PSZ   pszCmdInit;                         // Cmd used to Init printer
   ULONG ulCmdTerm;                          // length of cmd used to Term printer
   PSZ   pszCmdTerm;                         // cmd used to Term printer
   ULONG ulCmdReset;                         // length of cmd used to Reset printer
   PSZ   pszCmdReset;                        // cmd used to Reset printer
   ULONG ulCmdAbort;                         // length of cmd used to abort the printer
   PSZ   pszCmdAbort;                        // cmd used to abort the printer
   ULONG ulCmdPageEject;                     // length of cmd used to Eject a page
   PSZ   pszCmdPageEject;                    // cmd used to Eject a page
   ULONG ulCmdPortrait;                      // length of cmd used to Set Portrait
   PSZ   pszCmdPortrait;                     // cmd used to Set Portrait
   ULONG ulCmdLandscape;                     // length of cmd used to Set Landscape
   PSZ   pszCmdLandscape;                    // cmd used to Set Landscape
   ULONG ulCmdSetXYPos;                      // length of cmd used to Set X Y pos on page
   PSZ   pszCmdSetXYPos;                     // cmd used to Set X Y pos on page
   ULONG ulCmdSetXPos;                       // length of cmd used to Set X pos on page
   PSZ   pszCmdSetXPos;                      // cmd used to Set X pos on page
   ULONG ulCmdSetYPos;                       // length of cmd used to Set Y pos on page
   PSZ   pszCmdSetYPos;                      // cmd used to Set Y pos on page
   ULONG ulCmdSelfTest;                      // length of cmd used to Test Printer
   PSZ   pszCmdSelfTest;                     // cmd used to Test Printer
   ULONG ulCmdEOLWrapOn;                     // length of cmd used to Set wordrap ON
   PSZ   pszCmdEOLWrapOn;                    // cmd used to Set wordrap ON
   ULONG ulCmdEOLWrapOff;                    // length of cmd used to Set wordwrap OFF
   PSZ   pszCmdEOLWrapOff;                   // cmd used to Set wordwrap OFF
   ULONG ulCmdLineTerm;                      // length of cmd used to End a Line
   PSZ   pszCmdLineTerm;                     // cmd used to End a Line
   ULONG ulCmdTextLtoR;                      // length of cmd used to Set Left-to-right Text
   PSZ   pszCmdTextLtoR;                     // cmd used to Set Left-to-right Text
   ULONG ulCmdBidi;                          // length of cmd used to Set Bidi Text/Graphics Mode
   PSZ   pszCmdBidi;                         // cmd used to Set Bidi Text/Graphics Mode
   ULONG ulCmdTextScaleOn;                   // length of cmd used to Set Text Scaling ON
   PSZ   pszCmdTextScaleOn;                  // cmd used to Set Text Scaling ON
   ULONG ulCmdTextScaleOff;                  // length of cmd used to Set Text Scaling OFF
   PSZ   pszCmdTextScaleOff;                 // cmd used to Set Text Scaling OFF
   ULONG ulCmdBeginRasterGraphics;           // length of cmd used to Begin Raster Graphics Transfer Mode
   PSZ   pszCmdBeginRasterGraphics;          // cmd used to Begin Raster Graphics Transfer Mode
   ULONG ulCmdEndRasterGraphicsLine;         // length of cmd used to End a Raster Graphics Line
   PSZ   pszCmdEndRasterGraphicsLine;        // cmd used to End a Raster Graphics Line
   ULONG ulCmdMoveToNextRasterGraphicsLine;  // length of cmd used to End a Raster Graphics Line
   PSZ   pszCmdMoveToNextRasterGraphicsLine; // cmd used to End a Raster Graphics Line
   ULONG ulCmdEndRasterGraphics;             // length of cmd used to End Raster Graphics Transfer Mode
   PSZ   pszCmdEndRasterGraphics;            // cmd used to End Raster Graphics Transfer Mode
   ULONG ulCmdSetResolution;                 //
   PSZ   pszCmdSetResolution;                //
   ULONG ulCmdSetCompression;                //
   PSZ   pszCmdSetCompression;               //
   ULONG ulCmdTransferRasterBlock;           //
   PSZ   pszCmdTransferRasterBlock;          //
   ULONG ulCmdSetTopMargin;                  //
   PSZ   pszCmdSetTopMargin;                 //
   ULONG ulCmdTransferRasterPlane;
   PSZ   pszCmdTransferRasterPlane;
} CMDINFO;
typedef CMDINFO FAR *PCMDINFO;


// @Control
typedef struct _PRINTCTLVALUE {
   ULONG           ulID;
   ULONG           ulType;
   PSZ             pszName;
   ULONG           ulDataLen;
   PBYTE           pbData;
};
typedef struct _PRINTCTLVALUE PRINTCTLVALUE, *PPRINTCTLVALUE;

typedef struct _PRINTCTLFUNC {
   ULONG           ulID;
   ULONG           ulType;
   PSZ             pszName;
   ULONG           ulDataLen;
   PBYTE           pbData;
   ULONG           ulNumValues;
   PPRINTCTLVALUE  pValues;
};
typedef struct _PRINTCTLFUNC PRINTCTLFUNC, *PPRINTCTLFUNC;

//--------------------------------
// Resolution Information Structure
//--------------------------------
typedef struct _ResInfo {
   ULONG         ulResID;
   ULONG         ulNameID;
   CHAR          szResName[LEN_RESNAME];
   ULONG         ulXRes;
   ULONG         ulYRes;
   USHORT        usCmdLength;             // Length of following
   CHAR          szCmdSelectRes[LEN_CMD]; // Can be binary data
   ULONG         ulCapabilities;          // Holds "device-dependent" capability lists
   ULONG         ulDJPInfo;               // DJP DJP_SJ_PRINTQUALITY type
   // Dot Matrix Specific Info below - leave here for now
   // until better method found - MFR
   USHORT        usPrintMethod;           // Which method to use?
   USHORT        usNumPhysicalPins;       // Physical firing pins for this resolution
   BOOL          bAdjacentDotPrinting;    // Can printer print adjacent dots?
   USHORT        usDotsPerColumn;         // Used for column transfer method
   USHORT        usBytesPerColumn;        //   "                         "
   USHORT        usLenLineSpacing;        // Length of following
   CHAR          szCmdLineSpacing[8];     // Binary data
   ULONG         ulUnitsLineSpacing;      // Units of previous command
   USHORT        usLenVerticalDensity;    // Length of following
   CHAR          szCmdVerticalDensity[8]; // Binary data
   ULONG         ulUnitsVerticalDensity;  // Units of previous command
} RESINFO;

//--------------------------------
//
// Warning: This structure is saved out to the ini file as printer
//          properties.  Understand the repercussions before
//          modifing!
//
//--------------------------------
typedef struct _FontInfo {
   ULONG           ulFontID;                 // unique ID (Internal)
   LONG            lDevMatch;                // Neg. unique Font Match ID (External)
   ULONG           ulType;                   // Fixed, Prop, Scalable, Downloadable
   ULONG           ulTypeExtra;              // Extra info based on type
   ULONG           ulOrientation;            // Portrait/Landscape/Both
   ULONG           ulMiscCaps;               // Misc Caps
   ULONG           ulFileType;               // Memory, FOCA, IFI, Type 1 etc.
   CHAR            szFileName[32];
   CHAR            szFaceName[32];
   CHAR            szFamilyName[32];
   CHAR            szGlyphListName[32];
   ULONG           ulCmdLen;
   CHAR            szCmdSelectFont[LEN_CMD*4];

   ULONG           ulFontCharSet;            // Added For DBCS Fonts
   ULONG           ulFontCharEncoding;       // Added For DBCS Fonts
   ULONG           ulFontCharSetExtension;   // Added For DBCS Fonts
   ULONG           ulCmdModeInLen;           // DBCS Mode start cmd length
   CHAR            szCmdModeIn[LEN_CMD];     // DBCS Mode start command
   ULONG           ulCmdModeOutLen;          // DBCS Mode end cmd length
   CHAR            szCmdModeOut[LEN_CMD];    // DBCS Mode end command

   PVOID           pvUGLToSymbolSet;         // UGL -> Symbol Set mapping
   CHAR            szBackupFontName[32];     // FaceName of system backup font

   PFOCAFONT       vpGlobalFocaFont;         // Do not fill in... reserved by OMNI
   ULONG           cbGlobalFocaFont;         // Do not fill in... reserved by OMNI
} FONTINFO2;
typedef FONTINFO2 FAR *PFONTINFO2, FAR **PPFONTINFO2;

struct _USERFONT {
   FONTINFO2         fiUser;
   struct _USERFONT *pNextFont;
};
typedef struct _USERFONT USERFONT, FAR *PUSERFONT, FAR **PPUSERFONT;

//@SCALABLEFONT - begin
// Device font definition block
//
#define PDEVFNT_BOLD_SUPPORT                 0x00000001
#define PDEVFNT_ITALIC_SUPPORT               0x00000002
#define PDEVFNT_SHEAL_SUPPORT                0x00000004
#define PDEVFNT_ANGLE_SUPPORT                0x00000008
#define PDEVFNT_OUTLINE_SUPPORT              0x00000010
#define PDEVFNT_UNDERSCORE_SUPPORT           0x00000020
#define PDEVFNT_STRIKEOUT_SUPPORT            0x00000040

typedef struct _DEVFONTATTRIBUTES {
   ULONG  fAttributes;
   ULONG  ulFonttype;
   ULONG  ulSpacing;
   ULONG  ulHalfWidth;                       
   ULONG  ulFullWidth;                       
   ULONG  ulHeight;
   POINTL ptlAngle;
   POINTL ptlSheal;
   ULONG  ulDirection;
   ULONG  ulFGColor;
   ULONG  ulBGColor;
   ULONG  ulMixMode;
   ULONG  ulBackMixMode;
} DEVFONTATTRIBUTES, *PDEVFONTATTRIBUTES;

#define DFSFO_ENABLE                         1
#define DFSFO_DISABLE                        0

#define FAF_FONTTYPE                         0x00000001
#define FAF_SPACING                          0x00000002
#define FAF_WIDTH                            0x00000004
#define FAF_HEIGHT                           0x00000008
#define FAF_STYLE                            0x00000010
#define FAF_WEIGHT                           0x00000020
#define FAF_ANGLE                            0x00000040
#define FAF_SHEAL                            0x00000080
#define FAF_OUTLINE                          0x00000100
#define FAF_UNDERSCORE                       0x00000200
#define FAF_STRIKEOUT                        0x00000400
#define FAF_DIRECTION                        0x00000800
#define FAF_FGCOLOR                          0x00001000
#define FAF_BGCOLOR                          0x00002000
#define FAF_MIXMODE                          0x00004000
#define FAF_BACKMIXMODE                      0x00008000
// Next line is set for last signiture
// it should be dynamically change if
// above configuration is changed!!!!!
#define FAF_LAST                             0x00010000
#define FAF_ONOFF                           (FAF_STYLE      | \
                                             FAF_WEIGHT     | \
                                             FAF_OUTLINE    | \
                                             FAF_UNDERSCORE | \
                                             FAF_STRIKEOUT  )

typedef struct _DEVFONTCTLBLOCK {
   ULONG               ulSig;
   PDEVFONTATTRIBUTES  pFirst;
   PDEVFONTATTRIBUTES  pNext;
   ULONG               ulIndex;
   ULONG               ulNumBlk;
   PDEVFONTATTRIBUTES *AttrBlk;
} DEVFONTCTLBLOCK, *PDEVFONTCTLBLOCK;

#define DEVFONTATTRSIG 0x43414644       //'D' 'F' 'A' 'C'

typedef BOOL (_System FNATTR) (PVOID pVoid,       // PDDC
                               ULONG ulAttr);     // Attribute value
typedef FNATTR *PFNATTR;

typedef BOOL (_System FNATT2) (PVOID pVoid,       // PDDC
                               PVOID pVoid2,      // PSTRINOUT
                               ULONG ulAttr);     // Attribute value
typedef FNATT2 *PFNATT2;

typedef BOOL (_System FNATT3) (PVOID pVoid,       // PDDC
                               PVOID pVoid2,      // PSTRINOUT
                               ULONG ulAttr1,
                               ULONG ulAttr2);    // Attribute value
typedef FNATT3 *PFNATT3;

typedef BOOL (_System FNATTO) (PVOID pVoid,       // PDDC
                               ULONG ulOption);   // Option( enable or disable)
typedef FNATTO *PFNATTO;

typedef BOOL (_System FNATTP) (PVOID  pVoid,      // PDDC
                               POINTL ptlAttr);   // Option( enable or disable)
typedef FNATTP *PFNATTP;

typedef struct _DEVFONTATTRCMDS {
   ULONG   ulFonttypeCmd;
   PSZ     pszFonttypeCmd;
   PFNATTR pfnFonttype;
   ULONG   ulSpacingCmd;
   PSZ     pszSpacingCmd;
   PFNATTR pfnSpacing;
   ULONG   ulWidthCmd;
   PSZ     pszWidthCmd;
   PFNATT3 pfnWidth;                         
   ULONG   ulHeightCmd;
   PSZ     pszHeightCmd;
   PFNATT2 pfnHeight;
   ULONG   ulStyleCmd;
   PSZ     pszStyleCmd;
   ULONG   ulStyleEnable;
   ULONG   ulStyleDisable;
   PFNATTO pfnStyle;
   ULONG   ulWeightCmd;
   PSZ     pszWeightCmd;
   ULONG   ulWeightEnable;
   ULONG   ulWeightDisable;
   PFNATTO pfnWeight;
   ULONG   ulAngleCmd;
   PSZ     pszAngleCmd;
   PFNATTP pfnAngle;
   ULONG   ulShealCmd;
   PSZ     pszShealCmd;
   PFNATTP pfnSheal;
   ULONG   ulDirectionCmd;
   PSZ     pszDirectionCmd;
   PFNATTR pfnDirection;
   ULONG   ulFGColorCmd;
   PSZ     pszFGColorCmd;
   PFNATTR pfnFGColor;
   ULONG   ulBGColorCmd;
   PSZ     pszBGColorCmd;
   PFNATTR pfnBGColor;
   ULONG   ulMixModeCmd;
   PSZ     pszMixModeCmd;
   PFNATTR pfnMixMode;
   ULONG   ulBackMixModeCmd;
   PSZ     pszBackMixModeCmd;
   PFNATTR pfnBackMixMode;
   ULONG   ulUnderscoreCmd;
   PSZ     pszUnderscoreCmd;
   ULONG   ulUnderscoreEnable;
   ULONG   ulUnderscoreDisable;
   PFNATTO pfnUnderscore;
   ULONG   ulStrikeoutCmd;
   PSZ     pszStrikeoutCmd;
   ULONG   ulStrikeoutEnable;
   ULONG   ulStrikeoutDisable;
   PFNATTO pfnStrikeout;
   ULONG   ulOutlineCmd;
   PSZ     pszOutlineCmd;
   ULONG   ulOutlineEnable;
   ULONG   ulOutlineDisable;
   PFNATTO pfnOutline;
} DEVFONTATTRCMDS, *PDEVFONTATTRCMDS;
//@SCALABLEFONT - end

//--------------------------------
// Tray Information Structure
//
// Warning: This structure is saved out to the ini file as printer
//          properties after being mapped to the structure in the
//          "tray.h" header file.  Understand the repercussions before
//          modifing either!
//--------------------------------
typedef struct TRAYINFO {
   ULONG         ulTrayID;                 //
   ULONG         ulTrayCap;                // Tray Capabilities (auto-sensing,
                                           //    optional) TRAY_CAP_XXX
   BYTE          ulDJPid;                  // DJP_SJ_TRAYTYPE id
                                           // (NOTE: this should be ULONG but is
                                           //        BYTE for smaller size)
   ULONG         ulNameID;                 //
   CHAR          szTrayName[LEN_TRAYNAME]; //
   ULONG         ulTrayType;               //
   ULONG         ulCmdSelectTray;          // Length of following
   CHAR          szCmdSelectTray[LEN_CMD]; // Printer tray command
   ULONG         ulCompatibleForms;        // # of forms tray supports
   PULONG        pulCompatibleForms;       // array of forms this tray can hold
} TRAYINFO;
typedef TRAYINFO FAR *PTRAYINFO, FAR **PPTRAYINFO;

struct _USERTRAY {
   TRAYINFO          tiUser;
   struct _USERTRAY *pNextTray;
};
typedef struct _USERTRAY USERTRAY, FAR *PUSERTRAY, FAR **PPUSERTRAY;

/*---------------------------------*/
/* MEDIA TYPES                     */
/*---------------------------------*/

typedef struct _MEDIAINFO {
   ULONG     ulMediaID;
   ULONG     ulMediaCap;                // Media Capabilities (MEDIA_CAP_XXX)
   BYTE      ulDJPid;                   // DJP_SJ_MEDIA id
                                        // (NOTE: this should be ULONG but is
                                        //        BYTE for smaller size)
   ULONG     ulNameID;
   CHAR      szMediaName[LEN_MEDIANAME];
   ULONG     ulCmdSelectMedia;          // Length of following
   CHAR      szMediaTypeCmd[LEN_CMD];
   BOOL      fColorAdjustRequired;
   ULONG     ulAbsorptionAdjust;
} MEDIAINFO;

typedef MEDIAINFO FAR *PMEDIAINFO, FAR **PPMEDIAINFO;

//---------------------------------------
// PRINT MODE (color/mono) Info Structure
//---------------------------------------
typedef struct _PrintMode {
   ULONG         ulPrintModeID;
   ULONG         ulColorTech;
   ULONG         ulNameID;
   CHAR          szPrintMode[LEN_MODENAME];
   USHORT        usBitsPerPel;   // Physical bit count
   USHORT        usLogBitCount;  // Logical  bit count
   USHORT        usNumPlanes;    // # color planes (always 1 for OS/2)
   ULONG         ulDither;       // default Dither Alg. (e.g. pattern/scatter)
} PRINTMODE;

// lDarknessOptions:
#define SNAP_TO_BLACK_OFF 0x0001

// Given a triplet (resolution, print mode, media type)
//  apply modifiers to the color generating components
struct _TRIPLETMODIFIERS {
   ULONG         ulResID;             // Resolution
   ULONG         ulPrintModeID;       // Print mode
   ULONG         ulMediaID;           // Media type
   LONG          lHue;                // Modifiers follow...
   LONG          lSaturation;
   LONG          lValue;
   LONG          lDarkness;
   ULONG         lDarknessOptions;
   BYTE          bRedWt;              // Good values are 25
   BYTE          bGreenWt;            //                 60
   BYTE          bBlueWt;             //                 15
};
typedef struct _TRIPLETMODIFIERS     TRIPLETMODIFIERS,
                             FAR   *PTRIPLETMODIFIERS,
                             FAR **PPTRIPLETMODIFIERS;

//--------------------------------
// Form Information Structure
//
// Warning: This structure is saved out to the ini file as printer
//          properties after being mapped to the structure in the
//          "forms.h" header file.  Understand the repercussions before
//          modifing either!
//--------------------------------
struct _FORMINFO2 {
   ULONG         ulFormID;
   ULONG         ulFormCap;          // Form capabilities (FORM_CAP_XXX)
   BYTE          ulDJPid;            // DJP_SJ_PAPERSIZE id
                                     // (NOTE: this should be ULONG but is
                                     //        BYTE for smaller size)
   ULONG         ulFormClass;
   ULONG         ulNameID;
   USHORT        usLenCmdSelectForm;
   CHAR          szCmdSelectForm[LEN_CMD];
   HCINFO        hcInfo;
   BOOL          bHasBeenSetup;
};
typedef struct _FORMINFO2 FORMINFO2, FAR *PFORMINFO2, FAR **PPFORMINFO2;

struct _USERFORM {
   FORMINFO2        fiUser;
   struct _USERFORM *pNextForm;
};
typedef struct _USERFORM USERFORM, FAR *PUSERFORM, FAR **PPUSERFORM;

//--------------------------------
// Form Connection Structure
//
// Warning: This structure is saved out to the ini file as printer
//          properties.  Understand the repercussions before
//          modifing!
//--------------------------------
typedef struct FORMCONNECTION {
   ULONG            ulConnID;
   ULONG            ulTrayID;
   ULONG            ulFormID;
   ULONG            ulMediaID;
} FORMCONNECTION;
typedef FORMCONNECTION FAR *PFORMCONNECTION;

struct _USERCONNECT {
   FORMCONNECTION      fcUser;
   struct _USERCONNECT *pNextConnect;
};
typedef struct _USERCONNECT USERCONNECT, FAR *PUSERCONNECT;

//--------------------------------
// Form Connection Structure
//--------------------------------
typedef struct _MEMORYINFO {
   ULONG            ulMemFlags;
   ULONG            ulBase;
   ULONG            ulMaximum;
   ULONG            ulIncrement;
} MEMORYINFO;
typedef MEMORYINFO FAR *PMEMORYINFO;


//--------------------------------
// All User Data in one struct
//--------------------------------
typedef struct _USERDEFDATA {
   BOOL             bTraysInit;
   USHORT           usNumTrays;
   PUSERTRAY        pUserTRAYS;
   PUSERTRAY        pLastUserTRAYS;

   BOOL             bFormsInit;
   USHORT           usNumForms;
   PUSERFORM        pUserFORMS;
   PUSERFORM        pLastUserFORMS;

   BOOL             bConnsInit;
   USHORT           usNumConnects;
   PUSERCONNECT     pUserCONNECTS;
   PUSERCONNECT     pLastUserCONNECTS;

   BOOL             bFontsInit;
   USHORT           usNumFonts;
   PUSERFONT        pUserFONTS;
   PUSERFONT        pLastUserFONTS;
} USERDEFDATA;
typedef USERDEFDATA FAR *PUSERDEFDATA;

/* How the printer expects the raster data sent to it...
*/
#define RASTER_TOP_TO_BOTTOM                 0x01
#define RASTER_BOTTOM_TO_TOP                 0x02

// *****************************************************
// Ink and Spot Information Structure
// *****************************************************
//
//  Spot Shapes
//
#define ROUND_SPOT                           0
#define SQUARE_SPOT                          1
#define OVAL_SPOT                            2
//
// Ink Types
//
#define LIQUID_INK                           0
#define TONER_INK                            1
#define WAX_INK                              2
#define RIBBON_INK                           3
//
// Lumina Types
//
#define NORMAL_INK                           0
#define LIGNT_INK                            1
#define THIN_INK                             2
#define THICK_INK                            3

typedef struct  _INKINFO {
   ULONG    ulInkType;       // LIQUID_INK, TONER_INK, WAX_INK
   ULONG    ulCLumina;       // Cyan LIGHT_INK, THIN_INK, NORMAL_INK
   ULONG    ulMLumina;       // Magenta LIGHT_INK, THIN_INK, NORMAL_INK
   ULONG    ulYLumina;       // Yellow LIGHT_INK, THIN_INK, NORMAL_INK
   ULONG    ulKLumina;       // Black LIGHT_INK, THIN_INK, NORMAL_INK
   ULONG    ulSize;          // dot size in micrometers (um), widest part
   ULONG    ulShape;         // shape is ROUND_SPOT SQUARE_SPOT OVAL_SPOT
} INKINFO, *PINKINFO;

typedef struct _GammaTableStruct {
   ULONG ulFamily;
   ULONG ulRes;
   ULONG ulMedia;
   ULONG ulMode;
   ULONG ulDither;
   SHORT bCGamma;
   SHORT bMGamma;
   SHORT bYGamma;
   SHORT bKGamma;
   BYTE  bBias;
} GAMMA_STRUCT, *PGAMMA_STRUCT;


typedef struct _GAMMAINFOSTRUCT {
   PULONG         pFamily;
   PULONG         pRes;
   PULONG         pMedia;
   PULONG         pMode;
   PGAMMA_STRUCT  pSelect;
} GAMMAINFO, *PGAMMAINFO;

#ifdef DEBUG
//--------------------------------
// Graph Information Structure
//--------------------------------
typedef struct _GRAPHINFO {
   ULONG  cb;
   BOOL   bInitialized;
   HMCB   hmcb;
   RECTL  rclGraph;
   POINTL ptlOrigin;
   POINTL ptlGraph;

   // X Text
   ULONG  ulTextX;
   PSZ    pszTextX;
   RECTL  rclTextX;
   // Y Text
   ULONG  ulTextY;
   PSZ    pszTextY;
   RECTL  rclTextY;
   FONTMETRICS fm;

   POINTL aptlGamma[256];
   PBYTE  pbRGamma;
   PBYTE  pbGGamma;
   PBYTE  pbBGamma;
   PBYTE  pbKGamma;
} GRAPHINFO, FAR *PGRAPHINFO, FAR **PPGRAPHINFO2;
#endif

//--------------------------------
// Device Information Structure
//--------------------------------
typedef struct _DeviceInfo {
   USHORT             usDeviceID;
   PSZ                pszDeviceName;
   PSZ                pszDeviceDesc;
   PSZ                pszDeviceVendor;
   USHORT             usDeviceMajorVersion;
   USHORT             usDeviceMinorVersion;
   ULONG              ulOS2DeviceTechnology;  // OS/2 defs for technology
   ULONG              ulOmniDeviceTechnology; // Internal defs for technology
   ULONG              ulDeviceFunctions;      // TTY, HPGL, HPGL2, RASTER etc
   ULONG              ulRasterInfo;           // Raster info
   ULONG              ulDeviceBits;           // Flags specific to each driver/device
   ULONG              ulCompressModes;        // Compression supported
   PMEMORYINFO        pMemory;
   PCMDINFO           pCmds;
   PFNSUBCLASS        pSubclassedFunctions;   // init/term/render
   PFEATUREINFO       pFeatures;
   USHORT             usNumRes;
   PULONG             pulRES;
   USHORT             usNumFonts;
   PULONG             pulFONTS;
   USHORT             usNumTrays;
   PULONG             pulTRAYS;
   ULONG              ulNumForms;
   PFORMINFO2         pFORMS;
   ULONG              ulNumMedias;
   PULONG             pulMEDIAS;
   PINKINFO           pInkInfo;
   USHORT             usNumConnects;
   PULONG             pulCONNECTS;
   USHORT             usNumPrintModes;
   PULONG             pulPrintModes;
   ULONG              ulNumModifiers;
   PTRIPLETMODIFIERS  pTripletModifiers;
   PUSERDEFDATA       pUserDefData;
   JOBPROPERTIES      DeviceDefaults;
} DEVICEINFO, FAR *PDEVICEINFO;

//--------------------------------
// Driver Information Structure
//--------------------------------
typedef struct _DRIVERINFO {
   PSZ              pszDriverName;
   PSZ              pszDriverVendor;
   ULONG            ulDriverVersion;
   ULONG            ulNumRes;
   PRESINFO         pRES;
   ULONG            ulNumFonts;
   PFONTINFO2       pFONTS;
   ULONG            ulNumTrays;
   PTRAYINFO        pTRAYS;
   ULONG            ulNumForms;
   PFORMINFO2       pFORMS;
   ULONG            ulNumMedias;
   PMEDIAINFO       pMEDIAS;
   ULONG            ulNumConnects;
   PFORMCONNECTION  pCONNECTS;
   ULONG            ulNumPrintModes;
   PPRINTMODE       pPrintModes;
   ULONG            ulNumDevices;
   PDEVICEINFO      pDevices;
   PGAMMAINFO       pGammas;
   PDRVCONSTRAINTS  pDrvConstr;    // @CONSTRAINTS
} DRIVERINFO, FAR *PDRIVERINFO, FAR **PPDRIVERINFO;

extern PDRIVERINFO Drivers[];

// begin @JPN2H99
#define LEN_ICONNAME                16

typedef struct OUTPUTBININFO {
   ULONG         ulID;                      //
   ULONG         ulIconID;                  //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME*2];    //
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} OUTPUTBININFO;
typedef OUTPUTBININFO FAR *POUTPUTBININFO, FAR **PPOUTPUTBININFO;

typedef struct SORTINFO {
   ULONG         ulID;                      //
   ULONG         ulIconID;                  //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME];      // Icon text
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} SORTINFO;
typedef SORTINFO FAR *PSORTINFO, FAR **PPSORTINFO;

typedef struct STAPLEINFO {
   ULONG         ulID;                      //
   ULONG         ulIconID;                  //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME];      //
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} STAPLEINFO;
typedef STAPLEINFO FAR *PSTAPLEINFO, FAR **PPSTAPLEINFO;

typedef struct PUNCHINFO {
   ULONG         ulID;                      //
   ULONG         ulIconID;                  //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME];      //
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} PUNCHINFO;
typedef PUNCHINFO FAR *PPUNCHINFO, FAR **PPPUNCHINFO;

typedef struct NUPINFO {
   ULONG         ulID;                      //
   ULONG         ulIconID;                  //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME];      //
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} NUPINFO;
typedef NUPINFO FAR *PNUPINFO, FAR **PPNUPINFO;

typedef struct SCALEINFO {
   ULONG         ulID;                      //
   ULONG         ulNameID;                  //
   CHAR          szName[LEN_ICONNAME];      //
   ULONG         ulCmd;                     //
   CHAR          szCmd[LEN_CMD];            //
} SCALEINFO;
typedef SCALEINFO FAR *PSCALEINFO, FAR **PPSCALEINFO;
// end @JPN2H99

/* A special thanks goes out to Pat "Mr. C" Davis for making the following
** work with the C compiler instead of:
**
** #define HEX(h)    STRINGIZE(\x##h)
*/
#define STRINGIZE(s)                         #s
#define HEX1(h)                              STRINGIZE(h)
#define HEX(h)                               HEX1(\x##h)
#define ASCII(a)                             #a
#define OCT1(o)                              STRINGIZE(o)
#define OCT(o)                               OCT1(\0##o)

/* The following are
** ASCII definitions
*/
#define _NUL_                                HEX(00)
#define _LF_                                 HEX(0A)
#define _FF_                                 HEX(0C)
#define _CR_                                 HEX(0D)
#define _CAN_                                HEX(18)
#define _EM_                                 HEX(19)
#define _ESC_                                HEX(1B)
#define _FS_                                 HEX(1C)
