/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

// ---- defines to get around dialog editor replacement -----------------

#ifndef DID_OK
#define DID_OK 1
#endif

#ifndef DID_CANCEL
#define DID_CANCEL 2
#endif

#ifndef BKS_TABBEDDIALOG
#define BKS_TABBEDDIALOG         0x00000800
#endif

// define the accepted ID for static fields
#define DID_STATIC  65535

// ---- dialog IDs ------------------------------------------------------

// Common Pushbuttons
#define DID_ADD                     275
#define DID_DELETE                  276
#define DID_MODIFY                  277
#define DID_HELP                    278
#define DID_DEFAULTS                279
#define DID_DEV_DEFAULTS            280
#define DID_UNDO                    281
#define DID_CLEAN                   282
#define DID_CALIBRATE               283

// Common IDs to Job and Printer Properties

// Dialog ICON IDs
#define ICON_PORTRAIT               290
#define ICON_LANDSCAPE              291
#define ICON_DUPLEX_ONE             292
#define ICON_DUPLEX_FLIP            293
#define ICON_DUPLEX_BOOK            294

#define BITMAP_GAMMA                295

// Job Properties dialog IDs
#define IDD_JOB_PROPERTIES          500
#define IDD_JOB_PROPERTIES_NB       501
#define IDD_CONTEXT_HELP            502

// printer properties
#define IDD_PRINTER_PROPERTIES      505
#define IDD_PRINTER_PROPERTIES_NB   506

// "Common" Job Properties dialog page IDs
#define IDD_COMMON_JOB_PROPERTIES   550
#define IDD_DEFAULT_FORM            551
#define IDD_DEFAULT_FONT            552
#define IDD_DEFAULT_PRINT_MODE      553
#define IDC_PORTRAIT                554
#define IDC_LANDSCAPE               555
#define IDI_ORIENTATION             556
#define IDT_COPYCOUNT               557
#define IDT_DEFAULT_FONT            558
#define IDI_DUPLEX                  559
#define IDR_DUPLEX_ONE              560
#define IDR_DUPLEX_FLIP             561
#define IDR_DUPLEX_BOOK             562
#define IDG_DUPLEX                  563
#define IDD_MIRROR                  564
#define IDD_RESOLUTIONS             565
#define IDD_COPIES_NUMBER           566 
#define IDD_COLLATE                 567 
#define IDD_COPIES_NUMBER_TEXT      568 

// "Font" Printer Properties dialog page IDs
#define IDD_FONT_DLG                600
#define IDD_FONT_LIST               601
#define IDD_FOCAMETRICS             602

// Form Connection Dialog
#define IDD_FORM_CONNECTIONS        700
#define IDL_FORM_CONN               701
#define IDP_ADD_CONN                702
#define IDP_REMOVE_CONN             703
#define IDL_FORM_SOURCE             704
#define IDL_FORMS                   705
#define IDL_FORM_MEDIAS             706
#define IDD_CONN_TYPE               707

// Define Tray Dialog
#define IDD_DEFINE_TRAY             900
#define IDT_DEF_TRAY_NAME           901
#define IDE_DEF_TRAY_NAME           902
#define IDT_DEF_TRAY_SELECT_CMD     903
#define IDE_DEF_TRAY_SELECT_CMD     904
#define IDG_DEF_TRAY_TYPE           905
#define IDR_DEF_TRAY_TYPE_AUTO      906
#define IDR_DEF_TRAY_TYPE_MANUAL    907
#define IDL_DEF_TRAYS               908
#define IDT_TRAY_ID                 909
#define IDE_TRAY_ID                 910

// Form Information
#define IDD_DEFINE_FORM             1000
#define IDE_DEF_FORM_NAME           1001
#define IDE_DEF_FORM_CMD            1002
#define IDD_DEF_FORM_WIDTH          1003
#define IDD_DEF_FORM_HEIGHT         1004
#define IDD_DEF_FORM_LEFT_CLIP      1005
#define IDD_DEF_FORM_RIGHT_CLIP     1006
#define IDD_DEF_FORM_TOP_CLIP       1007
#define IDD_DEF_FORM_BOT_CLIP       1008
#define IDD_DEF_FORM_ID             1009
#define IDD_DEF_FORM_INCHES         1010
#define IDD_DEF_FORM_CENTIMETERS    1011
#define IDL_DEF_FORM_LIST           1012
#define IDD_CLIPPING_WINDOW         1013
#define IDT_DEF_FORM_TYPE           1014
#define IDD_DEF_FORM_TYPE           1015
#define IDD_FORM_CLASS              1016

// Font Information
#define IDD_FONT_PROPERTIES         1200
#define IDT_DEVICE_FONTS            1201
#define IDL_DEVICE_FONTS            1202
#define IDP_DEFINE_FONT             1203
#define IDP_REMOVE_FONT             1204
#define IDP_FONT_INFORMATION        1205
#define IDD_FONT_TYPE               1206
#define IDD_FONT_ORIENTATION        1207
#define IDD_FONT_FACENAME           1208
#define IDD_FONT_FAMILYNAME         1209
#define IDD_FONT_CMD                1210
#define IDD_FONT_ATTRIBUTES         1211
#define IDT_CHAR_HEIGHT             1212
#define IDT_CHAR_WIDTH              1213
#define IDT_FONT_WEIGHT             1214
#define IDT_FONT_DIRECTION          1215

// Memory features
#define IDT_DEVICE_MEMORY           1300
#define IDD_INSTALLED_MEMORY        1301
#define IDT_FIXED_MEMORY            1302

// debug information
#define IDD_OPTIONS_DEBUG           1400
#define IDL_OPTIONS_DEBUG           1401
#define IDT_OPTIONS_DEBUG           1402

// Data Page (currently not shown)
#define IDD_JOB_PROPERTIES_DATA     1600
#define IDL_DATA_COMPRESS           1601
#define IDT_DATA_COMPRESS           1602

// Color Image page
#define IDD_IMAGE_OPTIONS_COLOR     1700
//#define IDG_COLOR_DITHER            1701
#define IDD_ALGORITHMS              1702
//#define IDD_LEVEL                   1703
#define IDT_CLR_BIAS_RED            1704
#define IDD_CLR_BIAS_RED            1705
#define IDT_CLR_BIAS_GREEN          1706
#define IDD_CLR_BIAS_GREEN          1707
#define IDT_CLR_BIAS_BLUE           1708
#define IDD_CLR_BIAS_BLUE           1709
#define IDT_CLR_BIAS_BLACK          1710
#define IDD_CLR_BIAS_BLACK          1711
#define IDT_RED_GAMMA               1712
#define IDD_RED_GAMMA               1713
#define IDT_GREEN_GAMMA             1714
#define IDD_GREEN_GAMMA             1715
#define IDT_BLUE_GAMMA              1716
#define IDD_BLUE_GAMMA              1717
#define IDT_BLACK_GAMMA             1718
#define IDD_BLACK_GAMMA             1719
#define IDD_GAMMA_VIEW              1720
#define IDT_ALGORITHMS              1721

#ifdef DEBUG
#define IDD_GAMMA                   1722
#define IDL_GAMMA                   1723
#define IDD_GRAPH                   1724
#define IDT_CYAN                    1725
#define IDT_MAGENTA                 1726
#define IDT_YELLOW                  1727
#define IDT_BLACK                   1728
#endif

// HSV Adjustment page
#define IDD_HSV                     1750
#define IDG_COLOR_ADJUST            1751
#define IDT_HUE                     1752
#define IDD_HUE                     1753
#define IDT_SATURATION              1754
#define IDD_SATURATION              1755
#define IDT_CLR_DARKNESS            1756
#define IDD_CLR_DARKNESS            1757

// Monochrome Image page
#define IDD_IMAGE_OPTIONS_MONO      1800
#define IDD_DARKNESS                1801
#define IDD_FOREGROUND              1802
#define IDD_BACKGROUND              1803
#define IDT_DARKNESS                1804

// Passthru Printer Props (init/term strings)
#define IDD_PASSTHRU_DIALOG         1900
#define IDR_SEND_BEGIN_CMD          1901
#define IDR_SEND_BEGIN_FILE         1902
#define IDR_SEND_NEWFRAME_CMD       1903
#define IDR_SEND_NEWFRAME_FILE      1904
#define IDR_SEND_END_CMD            1905
#define IDR_SEND_END_FILE           1906
#define IDR_SEND_ABORT_CMD          1907
#define IDR_SEND_ABORT_FILE         1908
#define IDD_BEGIN_STRING            1909
#define IDD_END_STRING              1910
#define IDD_NEWFRAME_STRING         1911
#define IDD_ABORT_STRING            1912
#define IDD_BEGIN_FILE              1913
#define IDD_NEWFRAME_FILE           1914
#define IDD_END_FILE                1915
#define IDD_ABORT_FILE              1916
#define IDT_BEGIN                   1917
#define IDT_END                     1918
#define IDT_NEWFRAME                1919
#define IDT_ABORT                   1920

#define IDT_FF_CONTROL              2005
#define IDR_FF_CONDITIONAL          2006
#define IDR_FF_NONE                 2007
#define IDR_FF_COMPULSORY           2008

#define IDD_REMOTE_CONTROL          2015
#define IDD_REMOTE_CMD              2016
#define IDD_REMOTE_CMD_VALUE        2017
#define IDD_SEND_COMMAND            2018

#if 0
// Epson Job Properties
#define IDD_EPSON_JOB_PROPERTIES    2000
#define IDG_RAW_DATA_OPT            2001
#define IDT_ASCII_PRINT_MODE        2002
#define IDR_ASCII_ON                2003
#define IDR_ASCII_OFF               2004
#define IDT_FONT_SIZE               2009
#define IDR_DEF_FONT_10             2010
#define IDR_DEF_FONT_12             2011
#define IDR_DEF_FONT_15             2012
#endif

//-------------------
// Help Panels
//-------------------

// --- HELP PANELS ------------------------------------------------------

#ifdef DEBUG
#define SHOW_HELP_PANEL_IDS   CMIC_SHOW_PANEL_ID
#else
#define SHOW_HELP_PANEL_IDS   CMIC_HIDE_PANEL_ID
#endif


// --- PRINTER PROPERTY HELP PANEL --------------------------------------

#define PRINTER_PROPERTIES_HELPTABLE     15000

#define PRINTER_PROPERTIES_SUBTABLE      15001

#define PANEL_PRINTER_PROPERTIES         15010
#define PANEL_PP_SAVE                    15011
#define PANEL_PP_CANCEL                  15012
#define PANEL_PP_DEV_DEF                 15013
#define PANEL_PP_HELP                    15014
#define PANEL_CONNECTIONS                15015
#define PANEL_TRAYS                      15016
#define PANEL_PAPER_SIZES                15017

#define PANEL_PP_CONNECT_DEFINED         15020
#define PANEL_PP_CONNECT_ATTRS           15021
#define PANEL_PP_CONNECT_TRAYS           15022
#define PANEL_PP_CONNECT_SIZES           15023
#define PANEL_PP_CONNECT_MEDIAS          15024
#define PANEL_PP_CONNECT_ADD             15025
#define PANEL_PP_CONNECT_DELETE          15026

#define PANEL_PP_TRAY_DEFINED            15030
#define PANEL_PP_TRAY_ATTRS              15031
#define PANEL_PP_TRAY_NAME               15032
#define PANEL_PP_TRAY_COMMAND            15033
#define PANEL_PP_TRAY_FEEDTYPE           15034
#define PANEL_PP_TRAY_MANUAL             15035
#define PANEL_PP_TRAY_AUTOMATIC          15036
#define PANEL_PP_TRAY_ADD                15037
#define PANEL_PP_TRAY_DELETE             15038
#define PANEL_PP_TRAY_MODIFY             15039

#define PANEL_PP_SIZE_DEFINED            15040
#define PANEL_PP_SIZE_ATTRS              15041
#define PANEL_PP_SIZE_NAME               15042
#define PANEL_PP_SIZE_CLASS              15043
#define PANEL_PP_SIZE_COMMAND            15044
#define PANEL_PP_SIZE_WIDTH              15045
#define PANEL_PP_SIZE_HEIGHT             15046
#define PANEL_PP_SIZE_LM                 15047
#define PANEL_PP_SIZE_RM                 15048
#define PANEL_PP_SIZE_TM                 15049
#define PANEL_PP_SIZE_BM                 15050
#define PANEL_PP_SIZE_UNITS              15051
#define PANEL_PP_SIZE_CM                 15052
#define PANEL_PP_SIZE_INCH               15053
#define PANEL_PP_SIZE_ADD                15054
#define PANEL_PP_SIZE_DELETE             15055
#define PANEL_PP_SIZE_MODIFY             15056

#define PNEL_PP_BUILTIN                  15060
#define PNEL_PP_USERDEFINED              15061

// --- JOB PROPERTIES HELP PANELS ---------------------------------------

#define PANEL_JOB_PROPERTIES             16000
#define PANEL_JP_SAVE                    16001
#define PANEL_JP_CANCEL                  16002
#define PANEL_JP_HELP                    16003
#define PANEL_COMMON                     16004
#define PANEL_MONO                       16005
#define PANEL_COLOR                      16006
#define PANEL_HSV                        16007

#define PANEL_JP_COMMON_FORM             16010
#define PANEL_JP_COMMON_PQ               16011
#define PANEL_JP_COMMON_PM               16012
#define PANEL_JP_COMMON_ORIENT           16013
#define PANEL_JP_COMMON_DUPLEX           16014
#define PANEL_JP_COMMON_FONT             16015
#define PANEL_JP_COMMON_EFFECT           16016
#define PANEL_JP_COMMON_FF               16017

#define PANEL_JP_MONO_COLORS             16020
#define PANEL_JP_MONO_ADJUST             16021
#define PANEL_JP_MONO_FG                 16022
#define PANEL_JP_MONO_BG                 16023
#define PANEL_JP_MONO_DARKNESS           16024

#define PANEL_JP_COLOR_DITHER            16030
#define PANEL_JP_COLOR_ADJUST            16031
#define PANEL_JP_COLOR_ALGO              16032
//#define PANEL_JP_COLOR_LEVEL             16033
//#define PANEL_JP_COLOR_GAMMA             16034
#define PANEL_JP_COLOR_TONE              16035
#define PANEL_JP_COLOR_RED               16036
#define PANEL_JP_COLOR_GREEN             16037
#define PANEL_JP_COLOR_BLUE              16038
#define PANEL_JP_COLOR_BLACK             16039

#define PANEL_JP_DITHER_MAGIC            16040
//#define PANEL_JP_DITHER_LEVEL            16041
#define PANEL_JP_DITHER_4X4              16042
#define PANEL_JP_DITHER_8X8              16043
#define PANEL_JP_DITHER_STEINBERG        16044
#define PANEL_JP_DITHER_STUCKI           16045
#define PANEL_JP_DITHER_ORDERED          16046
#define PANEL_JP_DITHER_FAST             16047

#define PANEL_JP_HSV_ADJUST              16050
#define PANEL_JP_HSV_HUE                 16051
#define PANEL_JP_HSV_SATURATION          16052
#define PANEL_JP_HSV_DARKNESS            16053

// Defines for application defined controls

#define FORM_INFO_CLASS              "FORMINFOCLASS"
#define ENTRYFIELD_SUBCLASS          "Subclassed Entry"
#define HEX_ENTRY_CLASS              "Hex Entry"
#define BITMAP_CLASS                 "Bitmap Class"
#define GRAPH_CLASS                  "Graph Class"

#define DLG_TAB_SPACE                28
#define WIDTH_SPACE                  8     // Tabs need added width so all letters show-up

#define SMALL_TICKSIZE               4
#define LARGE_TICKSIZE               8

#define TICK_PEL_SPACE               2

#define NUM_TICKS                    101
#define HALF_TICKS                   50
#define LARGE_TICKSPACE              5

#define NUM_PERC_TICKS               91
#define HALF_PERC_TICKS              45
#define LARGE_PERC_TICKSPACE         10

// begin @JPN2H99
// Move ids from ricoh to this file for common use.
// Icon resource IDs

// Sort control
#define ICON_SORT01                 5301
#define ICON_SORT02                 5302
#define ICON_SORT03                 5303

// Staple control
#define ICON_STAPLE01               5320
#define ICON_STAPLE02               5321
#define ICON_STAPLE03               5322
#define ICON_STAPLE04               5323
#define ICON_STAPLE05               5324
#define ICON_STAPLE06               5325
#define ICON_STAPLE07               5326
#define ICON_STAPLE08               5327
#define ICON_STAPLE09               5328
#define ICON_STAPLE10               5329
#define ICON_STAPLE11               5330
#define ICON_STAPLE12               5331
#define ICON_STAPLE13               5332
#define ICON_STAPLE14               5333
#define ICON_STAPLE15               5334
#define ICON_STAPLE16               5335

// Punch control
#define ICON_PUNCH01                5340
#define ICON_PUNCH02                5341
#define ICON_PUNCH03                5342

// H/W N-up control
// 1.LEFT TO RIGHT     2.RIGHT TO LEFT
//   *------+            +------*
//        /               \
//      /                   \
//    /                       \
//   +------>            <------+
//
// 3.LEFTTOP TO BOTTOM 4.RIGHTTOP TO BOTTOM
//   *      +            +      *
//   |    / |            |\     |
//   |  /   |            |  \   |
//   |/     |            |    \ |
//   +      V            V      +
//
#define ICON_NUP1                   5360    // 1
#define ICON_NUP21                  5361    // 2 - 1
#define ICON_NUP22                  5362    // 2 - 2
#define ICON_NUP41                  5363    // 4 - 1
#define ICON_NUP42                  5364    // 4 - 2
#define ICON_NUP43                  5365    // 4 - 3
#define ICON_NUP44                  5366    // 4 - 4
#define ICON_NUP61                  5367    // 6 - 1
#define ICON_NUP62                  5368    // 6 - 2
#define ICON_NUP63                  5369    // 6 - 3
#define ICON_NUP64                  5370    // 6 - 4
#define ICON_NUP81                  5371    // 8 - 1
#define ICON_NUP82                  5372    // 8 - 2
#define ICON_NUP83                  5373    // 8 - 3
#define ICON_NUP84                  5374    // 8 - 4
#define ICON_NUP91                  5375    // 9 - 1
#define ICON_NUP92                  5376    // 9 - 2
#define ICON_NUP93                  5377    // 9 - 3
#define ICON_NUP94                  5378    // 9 - 4
#define ICON_NUP161                 5379    // 16 - 1
#define ICON_NUP162                 5380    // 16 - 2
#define ICON_NUP163                 5381    // 16 - 3
#define ICON_NUP164                 5382    // 16 - 4
// end @JPN2H99

#ifdef POWERPC
#define __FUNCTION__  __FILE__
#endif
