/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/* MODULE NAME    : Debug Functions                                         */
/* SOURCE NAME    : DEBUG.C                                                 */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11/17/93                                                */
/* DESCRIPTION    : All Debug functions                                     */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* jk0998 - September 1998, Janis Kisis, SWHT								       */
/*  new debug define for Void and Cluster method							       */
/****************************************************************************/

// os2 includes
#define INCL_DOS
#define INCL_PM
#include <os2.h>

#define INCL_GRE_BITMAPS
#define INCL_GRE_COLORTABLE
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

//#include "debug.h"
#include "def.h"
#include "driver.h"
#include "funcs.h"
#include "builtin.h"

/****************************************************************************/
/* Private Functions                                                        */
/****************************************************************************/


#ifdef DEBUG

#define DEBUG_HIGHLITE_CHECK    0
#define DEBUG_HIGHLITE_ALL_OFF  1
#define DEBUG_HIGHLITE_ALL_ON   2


/****************************************************************************/
/* PROCEDURE NAME : InitDebugInfo                                           */
/* AUTHOR         : MattR                                                   */
/* DATE WRITTEN   : 11-08-93                                                */
/* DESCRIPTION    : Read in debug info if in INI                            */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*                                                                          */
/* NOTE: This routine modifies global data and must be called only after    */
/*       the drivers global semaphore has been obtained.                    */
/*                                                                          */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
InitDebugInfo (PDEBUGINFO pDbgInfo, BOOL bResetDefault, BOOL bRereadFromDisk)
{
   BOOL    bSuccess = TRUE;
   ULONG   ul;
   BOOL    bRC;

   if (!globals.bDebugInfoInitialized || bResetDefault || bRereadFromDisk)
   {
      assertF (pDbgInfo);

      bRC = DosRequestMutexSem (procdata.hmtxGlobalSem, SEM_INDEFINITE_WAIT);
      assertT (bRC);
      DBPRINTF (("%s(): DosRequestMutexSem( ); bRC=%d; hmtx=%x\n", __FUNCTION__, bRC, procdata.hmtxGlobalSem));

      ul = sizeof (*pDbgInfo);

      // read a copy of "Device Default" DRIVDATA to OS2SYS.INI
      DBPRINTF (("InitDebugInfo(): PrfQueryProfileData()\n"));

      bRC = PrfQueryProfileData (HINI_SYSTEMPROFILE,
                                 APPNAME_DEBUGINFO,
                                 KEYNAME_DEBUGINFO,
                                 pDbgInfo,
                                 &ul);

      // no data to read in init table
      if (!bRC || (ul < sizeof (*pDbgInfo)) || bResetDefault)
      {
         if (bResetDefault)
         {
            DBPRINTF (("%s(): Resetting debug data to defaults\n", __FUNCTION__));
         }
         else
         {
            if (!bRC)
            {
               DBPRINTF (("%s(): PrfQueryProfileData() failed; ul = %d; using defaults\n", __FUNCTION__, ul));
            }
            else
            {
               DBPRINTF (("%s(): data in INI file is invalid size; using defaults\n", __FUNCTION__));
            }
         }

         pDbgInfo->bADDDEFINEDFORM                = FALSE;
         pDbgInfo->bADDUSERDEFINEDFORMENTRY       = FALSE;
         pDbgInfo->bADDUSERDEFINEDTRAYENTRY       = FALSE;

         pDbgInfo->bATTRIBUTEBUNDLESAREA          = FALSE;
         pDbgInfo->bATTRIBUTEBUNDLESCHAR          = FALSE;
         pDbgInfo->bATTRIBUTEBUNDLESIMAGE         = FALSE;
         pDbgInfo->bATTRIBUTEBUNDLESLINE          = FALSE;
         pDbgInfo->bATTRIBUTEBUNDLESMARKER        = FALSE;

         pDbgInfo->bBUILDAPPNAME                  = FALSE;
         pDbgInfo->bCALCULATEFONTMETRICS          = FALSE;
         pDbgInfo->bCHARSTRING                    = FALSE;
         pDbgInfo->bCHECKLOGICALADDRESS           = FALSE;
         pDbgInfo->bCREATENOTEBOOKPAGES           = FALSE;
         pDbgInfo->bCREATEUNIQUEFORMID            = FALSE;
         pDbgInfo->bCREATEUNIQUETRAYID            = FALSE;
         pDbgInfo->bDEBUGOUTPUT                   = FALSE;
         pDbgInfo->bDELETEUSERDEFINEDFORMENTRY    = FALSE;
         pDbgInfo->bDELETEUSERDEFINEDTRAYENTRY    = FALSE;

         pDbgInfo->bDEVESC_ABORTDOC               = FALSE;
         pDbgInfo->bDEVESC_BREAK_EXTRA            = FALSE;
         pDbgInfo->bDEVESC_CHAR_EXTRA             = FALSE;
         pDbgInfo->bDEVESC_DBE_FIRST              = FALSE;
         pDbgInfo->bDEVESC_DBE_LAST               = FALSE;
         pDbgInfo->bDEVESC_DRAFTMODE              = FALSE;
         pDbgInfo->bDEVESC_ENDDOC                 = FALSE;
         pDbgInfo->bDEVESC_FLUSHOUTPUT            = FALSE;
         pDbgInfo->bDEVESC_GETCP                  = FALSE;
         pDbgInfo->bDEVESC_GETSCALINGFACTOR       = FALSE;
         pDbgInfo->bDEVESC_NEWFRAME               = FALSE;
         pDbgInfo->bDEVESC_NEXTBAND               = FALSE;
         pDbgInfo->bDEVESC_QUERYACTUALRESOLUTION  = FALSE;
         pDbgInfo->bDEVESC_QUERYESCSUPPORT        = FALSE;
         pDbgInfo->bDEVESC_QUERYHALFTONESUPPORT   = FALSE;
         pDbgInfo->bDEVESC_QUERYPATTERN           = FALSE;
         pDbgInfo->bDEVESC_QUERYVIOCELLSIZES      = FALSE;
         pDbgInfo->bDEVESC_RAWDATA                = FALSE;
         pDbgInfo->bDEVESC_SETMODE                = FALSE;
         pDbgInfo->bDEVESC_STARTDOC               = FALSE;
         pDbgInfo->bDEVESC_STD_JOURNAL            = FALSE;

         pDbgInfo->bDEVICEPALETTE                 = FALSE;
         pDbgInfo->bDEVICEQUERYFONTATTRIBUTES     = FALSE;
         pDbgInfo->bDEVICEQUERYFONTS              = FALSE;
         pDbgInfo->bDRVINSTALL                    = FALSE;

         pDbgInfo->bENABLE_BEGIN_CLOSE_DC         = TRUE;
         pDbgInfo->bENABLE_COMPLETE_OPEN_DC       = TRUE;
         pDbgInfo->bENABLE_DISABLE_DC             = TRUE;
         pDbgInfo->bENABLE_DISABLE_PHYSICAL       = TRUE;
         pDbgInfo->bENABLE_ENABLE_DC              = TRUE;
         pDbgInfo->bENABLE_FILL_LOGICAL           = TRUE;
         pDbgInfo->bENABLE_FILL_PHYSICAL          = TRUE;
         pDbgInfo->bENABLE_RESET_DC               = TRUE;
         pDbgInfo->bENABLE_RESTORE_DC             = TRUE;
         pDbgInfo->bENABLE_SAVE_DC                = TRUE;

         pDbgInfo->bFILLFONTLIST                  = FALSE;
         pDbgInfo->bFILLFORMLIST                  = FALSE;
         pDbgInfo->bFILLMEDIALIST                 = FALSE;
         pDbgInfo->bFILLPRINTMODELIST             = FALSE;
         pDbgInfo->bFILLRESOLUTIONLIST            = FALSE;
         pDbgInfo->bFILLTRAYLIST                  = FALSE;
         pDbgInfo->bFINDPRINTERNAME               = FALSE;
         pDbgInfo->bFORMIDFROMNAME                = FALSE;
         pDbgInfo->bFORMINFOFROMID                = FALSE;
         pDbgInfo->bFORMINFOFROMNAME              = FALSE;
         pDbgInfo->bFORMNAMEFROMID                = FALSE;
         pDbgInfo->bFREESTRINGTABLE               = FALSE;
         pDbgInfo->bFREEUSERDEFINEDFORMLIST       = FALSE;
         pDbgInfo->bFREEUSERDEFINEDTRAYLIST       = FALSE;
         pDbgInfo->bGETDEFAULTFONTINFO            = FALSE;
         pDbgInfo->bGETDEFAULTFORMINFO            = FALSE;
         pDbgInfo->bGETIDSFROMCONNID              = FALSE;
         pDbgInfo->bINITSTRINGTABLE               = FALSE;
         pDbgInfo->bISFORMNAMEUNIQUE              = FALSE;
         pDbgInfo->bMEDIANAMEFROMID               = FALSE;
         pDbgInfo->bOMNICREATEHELPINSTANCE        = FALSE;
         pDbgInfo->bOMNIDESTROYHELPINSTANCE       = FALSE;
         pDbgInfo->bOS2_PM_DRV_DEVICENAMES        = TRUE;
         pDbgInfo->bOS2_PM_DRV_DEVMODE            = TRUE;
         pDbgInfo->bPDEVICEFROMDEVICENAME         = FALSE;
         pDbgInfo->bPDRIVERFROMDEVICENAME         = FALSE;
         pDbgInfo->bQUERYDEVICEBITMAPS            = FALSE;
         pDbgInfo->bQUERYDEVICECAPS               = FALSE;
         pDbgInfo->bQUERYDEVRESOURCE2             = FALSE;
         pDbgInfo->bQUERYHARDCOPYCAPS             = FALSE;
         pDbgInfo->bREADUSERDEFINEDFORMLIST       = FALSE;
         pDbgInfo->bREADUSERDEFINEDTRAYLIST       = FALSE;
         pDbgInfo->bREALIZEFONT                   = FALSE;
         pDbgInfo->bSAVEUSERDEFINEDFORMLIST       = FALSE;
         pDbgInfo->bSETDRIVERDATADEFAULTS         = FALSE;
         pDbgInfo->bSUBABORTJOB                   = FALSE;
         pDbgInfo->bSUBINITJOB                    = FALSE;
         pDbgInfo->bSUBNEWPAGE                    = FALSE;
         pDbgInfo->bSUBRASTER                     = FALSE;
         pDbgInfo->bSUBRASTERQUERY                = FALSE;
         pDbgInfo->bSUBTERMJOB                    = FALSE;
         pDbgInfo->bTRAYNAMEFROMID                = FALSE;
      }
      else
      {
         DBPRINTF(( "%s(): Successful DebugInfo read in\n", __FUNCTION__ ));

         // @TBD if ul != correct length ...
      }

      globals.bDebugInfoInitialized = TRUE;
      DBPRINTF (("%s(): globals.bDebugInfoInitialized = %d\n", __FUNCTION__, globals.bDebugInfoInitialized));

      bRC = DosReleaseMutexSem (procdata.hmtxGlobalSem);
      assertT (bRC);

      DBPRINTF (("%s(): DosReleaseMutexSem( ); bRC=%d; hmtx=%x\n", __FUNCTION__, bRC, procdata.hmtxGlobalSem));
   }

   return bSuccess;

} /* end InitDebugInfo */

/****************************************************************************/
/* PROCEDURE NAME : IsDebugOptionSelected                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11/17/93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
IsDebugOptionSelected (PDEBUGINFO pDbgInfo, ULONG ulFuncID)
{
   BOOL        bRC;
#ifdef DEBUG
   PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

///DBPRINTIF ((pDbg->bDEBUGOUTPUT, "IsDebugOptionSelected(): Function ID = %d\n", ulFuncID));

   switch (ulFuncID)
   {
// case  :
// {
//    bRC = pDbgInfo->b;
//    break;
// }

   case FUNC_ADDDEFINEDFORM:
   {
      bRC = pDbgInfo->bADDDEFINEDFORM;
      break;
   }

   case FUNC_ADDUSERDEFINEDFORMENTRY:
   {
      bRC = pDbgInfo->bADDUSERDEFINEDFORMENTRY;
      break;
   }

   case FUNC_ADDUSERDEFINEDTRAYENTRY:
   {
      bRC = pDbgInfo->bADDUSERDEFINEDTRAYENTRY;
      break;
   }

   case FUNC_BUILDAPPNAME:
   {
      bRC = pDbgInfo->bBUILDAPPNAME;
      break;
   }

   case FUNC_CALCULATEFONTMETRICS:
   {
      bRC = pDbgInfo->bCALCULATEFONTMETRICS;
      break;
   }

   case FUNC_CHARSTRING:
   {
      bRC = pDbgInfo->bCHARSTRING;
      break;
   }

   case FUNC_CHECKLOGICALADDRESS:
   {
      bRC = pDbgInfo->bCHECKLOGICALADDRESS;
      break;
   }

   case FUNC_CREATENOTEBOOKPAGES:
   {
      bRC = pDbgInfo->bCREATENOTEBOOKPAGES;
      break;
   }

   case FUNC_CREATEUNIQUEFORMID:
   {
      bRC = pDbgInfo->bCREATEUNIQUEFORMID;
      break;
   }

   case FUNC_CREATEUNIQUETRAYID:
   {
      bRC = pDbgInfo->bCREATEUNIQUETRAYID;
      break;
   }

   case FUNC_DEBUGOUTPUT:
   {
      bRC = pDbgInfo->bDEBUGOUTPUT;
      break;
   }

   case FUNC_DELETEUSERDEFINEDFORMENTRY:
   {
      bRC = pDbgInfo->bDELETEUSERDEFINEDFORMENTRY;
      break;
   }

   case FUNC_DELETEUSERDEFINEDTRAYENTRY:
   {
      bRC = pDbgInfo->bDELETEUSERDEFINEDTRAYENTRY;
      break;
   }

   case FUNC_DEVICEQUERYFONTS:
   {
      bRC = pDbgInfo->bDEVICEQUERYFONTS;
      break;
   }

   case FUNC_DEVICEQUERYFONTATTRIBUTES:
   {
      bRC = pDbgInfo->bDEVICEQUERYFONTATTRIBUTES;
      break;
   }

   case FUNC_DEVESC_STARTDOC:
   {
      bRC = pDbgInfo->bDEVESC_STARTDOC;
      break;
   }

   case FUNC_DEVESC_RAWDATA:
   {
      bRC = pDbgInfo->bDEVESC_RAWDATA;
      break;
   }

   case FUNC_DEVESC_ENDDOC:
   {
      bRC = pDbgInfo->bDEVESC_ENDDOC;
      break;
   }

   case FUNC_DEVESC_NEWFRAME:
   {
      bRC = pDbgInfo->bDEVESC_NEWFRAME;
      break;
   }

   case FUNC_DEVESC_ABORTDOC:
   {
      bRC = pDbgInfo->bDEVESC_ABORTDOC;
      break;
   }

   case FUNC_DEVESC_QUERYHALFTONESUPPORT:
   {
      bRC = pDbgInfo->bDEVESC_QUERYHALFTONESUPPORT;
      break;
   }

   case FUNC_DEVESC_QUERYPATTERN:
   {
      bRC = pDbgInfo->bDEVESC_QUERYPATTERN;
      break;
   }

   case FUNC_DEVESC_QUERYESCSUPPORT:
   {
      bRC = pDbgInfo->bDEVESC_QUERYESCSUPPORT;
      break;
   }

   case FUNC_DEVESC_GETSCALINGFACTOR:
   {
      bRC = pDbgInfo->bDEVESC_GETSCALINGFACTOR;
      break;
   }

   case FUNC_DEVESC_QUERYVIOCELLSIZES:
   {
      bRC = pDbgInfo->bDEVESC_QUERYVIOCELLSIZES;
      break;
   }

   case FUNC_DEVESC_QUERYACTUALRESOLUTION:
   {
      bRC = pDbgInfo->bDEVESC_QUERYACTUALRESOLUTION;
      break;
   }

   case FUNC_DEVESC_GETCP:
   {
      bRC = pDbgInfo->bDEVESC_GETCP;
      break;
   }

   case FUNC_DEVESC_NEXTBAND:
   {
      bRC = pDbgInfo->bDEVESC_NEXTBAND;
      break;
   }

   case FUNC_DEVESC_DRAFTMODE:
   {
      bRC = pDbgInfo->bDEVESC_DRAFTMODE;
      break;
   }

   case FUNC_DEVESC_FLUSHOUTPUT:
   {
      bRC = pDbgInfo->bDEVESC_FLUSHOUTPUT;
      break;
   }

   case FUNC_DEVESC_CHAR_EXTRA:
   {
      bRC = pDbgInfo->bDEVESC_CHAR_EXTRA;
      break;
   }

   case FUNC_DEVESC_BREAK_EXTRA:
   {
      bRC = pDbgInfo->bDEVESC_BREAK_EXTRA;
      break;
   }

   case FUNC_DEVESC_SETMODE:
   {
      bRC = pDbgInfo->bDEVESC_SETMODE;
      break;
   }

   case FUNC_DEVESC_DBE_FIRST:
   {
      bRC = pDbgInfo->bDEVESC_DBE_FIRST;
      break;
   }

   case FUNC_DEVESC_DBE_LAST:
   {
      bRC = pDbgInfo->bDEVESC_DBE_LAST;
      break;
   }

   case FUNC_DEVESC_STD_JOURNAL:
   {
      bRC = pDbgInfo->bDEVESC_STD_JOURNAL;
      break;
   }

   case FUNC_DEVICEPALETTE:
   {
      bRC = pDbgInfo->bDEVICEPALETTE;
      break;
   }

   case FUNC_DRVINSTALL:
   {
      bRC = pDbgInfo->bDRVINSTALL;
      break;
   }

   case FUNC_ENABLE_FILL_LOGICAL :
   {
      bRC = pDbgInfo->bENABLE_FILL_LOGICAL;
      break;
   }

   case FUNC_ENABLE_FILL_PHYSICAL:
   {
      bRC = pDbgInfo->bENABLE_FILL_PHYSICAL;
      break;
   }

   case FUNC_ENABLE_DISABLE_PHYSICAL:
   {
      bRC = pDbgInfo->bENABLE_DISABLE_PHYSICAL;
      break;
   }

   case FUNC_ENABLE_ENABLE_DC:
   {
      bRC = pDbgInfo->bENABLE_ENABLE_DC;
      break;
   }

   case FUNC_ENABLE_DISABLE_DC:
   {
      bRC = pDbgInfo->bENABLE_DISABLE_DC;
      break;
   }

   case FUNC_ENABLE_SAVE_DC:
   {
      bRC = pDbgInfo->bENABLE_SAVE_DC;
      break;
   }

   case FUNC_ENABLE_RESTORE_DC:
   {
      bRC = pDbgInfo->bENABLE_RESTORE_DC;
      break;
   }

   case FUNC_ENABLE_RESET_DC:
   {
      bRC = pDbgInfo->bENABLE_RESET_DC;
      break;
   }

   case FUNC_ENABLE_COMPLETE_OPEN_DC:
   {
      bRC = pDbgInfo->bENABLE_COMPLETE_OPEN_DC;
      break;
   }

   case FUNC_ENABLE_BEGIN_CLOSE_DC:
   {
      bRC = pDbgInfo->bENABLE_BEGIN_CLOSE_DC;
      break;
   }

   case FUNC_INITSTRINGTABLE:
   {
      bRC = pDbgInfo->bINITSTRINGTABLE;
      break;
   }

   case FUNC_FINDPRINTERNAME:
   {
      bRC = pDbgInfo->bFINDPRINTERNAME;
      break;
   }

   case FUNC_FILLFONTLIST:
   {
      bRC = pDbgInfo->bFILLFONTLIST;
      break;
   }

   case FUNC_FILLFORMLIST:
   {
      bRC = pDbgInfo->bFILLFORMLIST;
      break;
   }

   case FUNC_FILLMEDIALIST:
   {
      bRC = pDbgInfo->bFILLMEDIALIST;
      break;
   }

   case FUNC_FILLPRINTMODELIST:
   {
      bRC = pDbgInfo->bFILLPRINTMODELIST;
      break;
   }

   case FUNC_FILLRESOLUTIONLIST:
   {
      bRC = pDbgInfo->bFILLRESOLUTIONLIST;
      break;
   }

   case FUNC_FILLTRAYLIST:
   {
      bRC = pDbgInfo->bFILLTRAYLIST;
      break;
   }

   case FUNC_FORMNAMEFROMID:
   {
      bRC = pDbgInfo->bFORMNAMEFROMID;
      break;
   }

   case FUNC_FORMIDFROMNAME:
   {
      bRC = pDbgInfo->bFORMIDFROMNAME;
      break;
   }

   case FUNC_FORMINFOFROMID:
   {
      bRC = pDbgInfo->bFORMINFOFROMID;
      break;
   }

   case FUNC_FORMINFOFROMNAME:
   {
      bRC = pDbgInfo->bFORMINFOFROMNAME;
      break;
   }

   case FUNC_FREEUSERDEFINEDFORMLIST:
   {
      bRC = pDbgInfo->bFREEUSERDEFINEDFORMLIST;
      break;
   }

   case FUNC_FREEUSERDEFINEDTRAYLIST:
   {
      bRC = pDbgInfo->bFREEUSERDEFINEDTRAYLIST;
      break;
   }

   case FUNC_FREESTRINGTABLE:
   {
      bRC = pDbgInfo->bFREESTRINGTABLE;
      break;
   }

   case FUNC_GETIDSFROMCONNID:
   {
      bRC = pDbgInfo->bGETIDSFROMCONNID;
      break;
   }

   case FUNC_GETDEFAULTFONTINFO:
   {
      bRC = pDbgInfo->bGETDEFAULTFONTINFO;
      break;
   }

   case FUNC_GETDEFAULTFORMINFO:
   {
      bRC = pDbgInfo->bGETDEFAULTFORMINFO;
      break;
   }

   case FUNC_ISFORMNAMEUNIQUE:
   {
      bRC = pDbgInfo->bISFORMNAMEUNIQUE;
      break;
   }

   case FUNC_MEDIANAMEFROMID:
   {
      bRC = pDbgInfo->bMEDIANAMEFROMID;
      break;
   }

   case FUNC_OMNICREATEHELPINSTANCE:
   {
      bRC = pDbgInfo->bOMNICREATEHELPINSTANCE;
      break;
   }

   case FUNC_OMNIDESTROYHELPINSTANCE:
   {
      bRC = pDbgInfo->bOMNIDESTROYHELPINSTANCE;
      break;
   }

   case FUNC_OS2_PM_DRV_DEVMODE:
   {
      bRC = pDbgInfo->bOS2_PM_DRV_DEVMODE;
      break;
   }

   case FUNC_OS2_PM_DRV_DEVICENAMES:
   {
      bRC = pDbgInfo->bOS2_PM_DRV_DEVICENAMES;
      break;
   }

   case FUNC_PDEVICEFROMDEVICENAME:
   {
      bRC = pDbgInfo->bPDEVICEFROMDEVICENAME;
      break;
   }

   case FUNC_PDRIVERFROMDEVICENAME:
   {
      bRC = pDbgInfo->bPDRIVERFROMDEVICENAME;
      break;
   }

   case FUNC_QUERYDEVICEBITMAPS:
   {
      bRC = pDbgInfo->bQUERYDEVICEBITMAPS;
      break;
   }

   case FUNC_QUERYDEVICECAPS :
   {
      bRC = pDbgInfo->bQUERYDEVICECAPS;
      break;
   }

   case FUNC_QUERYDEVRESOURCE2 :
   {
      bRC = pDbgInfo->bQUERYDEVRESOURCE2;
      break;
   }

   case FUNC_QUERYHARDCOPYCAPS :
   {
      bRC = pDbgInfo->bQUERYHARDCOPYCAPS;
      break;
   }

   case FUNC_READUSERDEFINEDFORMLIST:
   {
      bRC = pDbgInfo->bREADUSERDEFINEDFORMLIST;
      break;
   }

   case FUNC_READUSERDEFINEDTRAYLIST:
   {
      bRC = pDbgInfo->bREADUSERDEFINEDTRAYLIST;
      break;
   }

   case FUNC_SETDRIVERDATADEFAULTS:
   {
      bRC = pDbgInfo->bSETDRIVERDATADEFAULTS;
      break;
   }

   case FUNC_SAVEUSERDEFINEDFORMLIST:
   {
      bRC = pDbgInfo->bSAVEUSERDEFINEDFORMLIST;
      break;
   }

   case FUNC_SUBINITJOB:
   {
      bRC = pDbgInfo->bSUBINITJOB;
      break;
   }

   case FUNC_SUBRASTER:
   {
      bRC = pDbgInfo->bSUBRASTER;
      break;
   }

   case FUNC_SUBNEWPAGE:
   {
      bRC = pDbgInfo->bSUBNEWPAGE;
      break;
   }

   case FUNC_SUBTERMJOB:
   {
      bRC = pDbgInfo->bSUBTERMJOB;
      break;
   }

   case FUNC_SUBABORTJOB:
   {
      bRC = pDbgInfo->bSUBABORTJOB;
      break;
   }

   case FUNC_SUBRASTERQUERY:
   {
      bRC = pDbgInfo->bSUBRASTERQUERY;
      break;
   }

   case FUNC_TRAYNAMEFROMID:
   {
      bRC = pDbgInfo->bTRAYNAMEFROMID;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESLINE:
   {
      bRC = pDbgInfo->bATTRIBUTEBUNDLESLINE;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESAREA:
   {
      bRC = pDbgInfo->bATTRIBUTEBUNDLESAREA;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESCHAR:
   {
      bRC = pDbgInfo->bATTRIBUTEBUNDLESCHAR;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESIMAGE:
   {
      bRC = pDbgInfo->bATTRIBUTEBUNDLESIMAGE;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESMARKER:
   {
      bRC = pDbgInfo->bATTRIBUTEBUNDLESMARKER;
      break;
   }

   case FUNC_REALIZEFONT:
   {
      bRC = pDbgInfo->bREALIZEFONT;
      break;
   }

   default:
   {
      assertstring ("Unrecognized Function ID");
      DBPRINTIF ((pDbg->bDEBUGOUTPUT, "Unrecognized Function ID = %d\n", ulFuncID));
      bRC = FALSE;
      break;
   }
   }

///DBPRINTIF ((pDbg->bDEBUGOUTPUT, "IsDebugOptionSelected(): bRC = %d\n", bRC));

   return bRC;

} /* end IsDebugOptionSelected */

/****************************************************************************/
/* PROCEDURE NAME : SelectDebugOption                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11/17/93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
SelectDebugOption (PDEBUGINFO pDbgInfo, ULONG ulFuncID, BOOL bSelect)
{
   BOOL        bRC = TRUE;
#ifdef DEBUG
   PDEBUGINFO  pDbg = &globals.DebugInfo;
#endif

   DBPRINTIF ((pDbg->bDEBUGOUTPUT, "SelectDebugOption(): ulFuncID = %d; bSelect = %d\n",
               ulFuncID, bSelect));

   switch (ulFuncID)
   {
   case FUNC_ADDDEFINEDFORM:
   {
      pDbgInfo->bADDDEFINEDFORM = bSelect;
      break;
   }

   case FUNC_ADDUSERDEFINEDFORMENTRY:
   {
      pDbgInfo->bADDUSERDEFINEDFORMENTRY = bSelect;
      break;
   }

   case FUNC_DEBUGOUTPUT :
   {
      pDbgInfo->bDEBUGOUTPUT = bSelect;
      break;
   }

   case FUNC_ADDUSERDEFINEDTRAYENTRY:
   {
      pDbgInfo->bADDUSERDEFINEDTRAYENTRY = bSelect;
      break;
   }

   case FUNC_CALCULATEFONTMETRICS:
   {
      pDbgInfo->bCALCULATEFONTMETRICS = bSelect;
      break;
   }

   case FUNC_CREATENOTEBOOKPAGES:
   {
      pDbgInfo->bCREATENOTEBOOKPAGES = bSelect;
      break;
   }

   case FUNC_QUERYDEVICEBITMAPS:
   {
      pDbgInfo->bQUERYDEVICEBITMAPS = bSelect;
      break;
   }

   case FUNC_QUERYDEVICECAPS :
   {
      pDbgInfo->bQUERYDEVICECAPS = bSelect;
      break;
   }

   case FUNC_QUERYDEVRESOURCE2 :
   {
      pDbgInfo->bQUERYDEVRESOURCE2 = bSelect;
      break;
   }

   case FUNC_QUERYHARDCOPYCAPS :
   {
      pDbgInfo->bQUERYHARDCOPYCAPS = bSelect;
      break;
   }

   case FUNC_DEVICEQUERYFONTS:
   {
      pDbgInfo->bDEVICEQUERYFONTS = bSelect;
      break;
   }

   case FUNC_DEVICEQUERYFONTATTRIBUTES:
   {
      pDbgInfo->bDEVICEQUERYFONTATTRIBUTES = bSelect;
      break;
   }

   case FUNC_ENABLE_FILL_LOGICAL :
   {
      pDbgInfo->bENABLE_FILL_LOGICAL = bSelect;
      break;
   }

   case FUNC_ENABLE_FILL_PHYSICAL:
   {
      pDbgInfo->bENABLE_FILL_PHYSICAL = bSelect;
      break;
   }

   case FUNC_ENABLE_DISABLE_PHYSICAL:
   {
      pDbgInfo->bENABLE_DISABLE_PHYSICAL = bSelect;
      break;
   }

   case FUNC_ENABLE_ENABLE_DC:
   {
      pDbgInfo->bENABLE_ENABLE_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_DISABLE_DC:
   {
      pDbgInfo->bENABLE_DISABLE_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_SAVE_DC:
   {
      pDbgInfo->bENABLE_SAVE_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_RESTORE_DC:
   {
      pDbgInfo->bENABLE_RESTORE_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_RESET_DC:
   {
      pDbgInfo->bENABLE_RESET_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_COMPLETE_OPEN_DC:
   {
      pDbgInfo->bENABLE_COMPLETE_OPEN_DC = bSelect;
      break;
   }

   case FUNC_ENABLE_BEGIN_CLOSE_DC:
   {
      pDbgInfo->bENABLE_BEGIN_CLOSE_DC = bSelect;
      break;
   }

   case FUNC_MEDIANAMEFROMID:
   {
      pDbgInfo->bMEDIANAMEFROMID = bSelect;
      break;
   }

   case FUNC_OMNICREATEHELPINSTANCE:
   {
      pDbgInfo->bOMNICREATEHELPINSTANCE = bSelect;
      break;
   }

   case FUNC_OMNIDESTROYHELPINSTANCE:
   {
      pDbgInfo->bOMNIDESTROYHELPINSTANCE = bSelect;
      break;
   }

   case FUNC_OS2_PM_DRV_DEVMODE:
   {
      pDbgInfo->bOS2_PM_DRV_DEVMODE = bSelect;
      break;
   }

   case FUNC_OS2_PM_DRV_DEVICENAMES:
   {
      pDbgInfo->bOS2_PM_DRV_DEVICENAMES = bSelect;
      break;
   }

   case FUNC_DRVINSTALL:
   {
      pDbgInfo->bDRVINSTALL = bSelect;
      break;
   }

   case FUNC_INITSTRINGTABLE:
   {
      pDbgInfo->bINITSTRINGTABLE = bSelect;
      break;
   }

   case FUNC_ISFORMNAMEUNIQUE:
   {
      pDbgInfo->bISFORMNAMEUNIQUE = bSelect;
      break;
   }

   case FUNC_FREESTRINGTABLE:
   {
      pDbgInfo->bFREESTRINGTABLE = bSelect;
      break;
   }

   case FUNC_BUILDAPPNAME:
   {
      pDbgInfo->bBUILDAPPNAME = bSelect;
      break;
   }

   case FUNC_FINDPRINTERNAME:
   {
      pDbgInfo->bFINDPRINTERNAME = bSelect;
      break;
   }

   case FUNC_SETDRIVERDATADEFAULTS:
   {
      pDbgInfo->bSETDRIVERDATADEFAULTS = bSelect;
      break;
   }

   case FUNC_PDRIVERFROMDEVICENAME:
   {
      pDbgInfo->bPDRIVERFROMDEVICENAME = bSelect;
      break;
   }

   case FUNC_PDEVICEFROMDEVICENAME:
   {
      pDbgInfo->bPDEVICEFROMDEVICENAME = bSelect;
      break;
   }

   case FUNC_CHECKLOGICALADDRESS:
   {
      pDbgInfo->bCHECKLOGICALADDRESS = bSelect;
      break;
   }

   case FUNC_CREATEUNIQUEFORMID:
   {
      pDbgInfo->bCREATEUNIQUEFORMID = bSelect;
      break;
   }

   case FUNC_CREATEUNIQUETRAYID:
   {
      pDbgInfo->bCREATEUNIQUETRAYID = bSelect;
      break;
   }

   case FUNC_DELETEUSERDEFINEDFORMENTRY:
   {
      pDbgInfo->bDELETEUSERDEFINEDFORMENTRY = bSelect;
      break;
   }

   case FUNC_DELETEUSERDEFINEDTRAYENTRY:
   {
      pDbgInfo->bDELETEUSERDEFINEDTRAYENTRY = bSelect;
      break;
   }

   case FUNC_FORMNAMEFROMID:
   {
      pDbgInfo->bFORMNAMEFROMID = bSelect;
      break;
   }

   case FUNC_FORMIDFROMNAME:
   {
      pDbgInfo->bFORMNAMEFROMID = bSelect;
      break;
   }

   case FUNC_FILLFONTLIST:
   {
      pDbgInfo->bFILLFONTLIST = bSelect;
      break;
   }

   case FUNC_FILLFORMLIST:
   {
      pDbgInfo->bFILLFORMLIST = bSelect;
      break;
   }

   case FUNC_FILLMEDIALIST:
   {
      pDbgInfo->bFILLMEDIALIST = bSelect;
      break;
   }

   case FUNC_FILLPRINTMODELIST:
   {
      pDbgInfo->bFILLPRINTMODELIST = bSelect;
      break;
   }

   case FUNC_FILLRESOLUTIONLIST:
   {
      pDbgInfo->bFILLRESOLUTIONLIST = bSelect;
      break;
   }

   case FUNC_FILLTRAYLIST:
   {
      pDbgInfo->bFILLTRAYLIST = bSelect;
      break;
   }

   case FUNC_FREEUSERDEFINEDFORMLIST:
   {
      pDbgInfo->bFREEUSERDEFINEDFORMLIST = bSelect;
      break;
   }

   case FUNC_FREEUSERDEFINEDTRAYLIST:
   {
      pDbgInfo->bFREEUSERDEFINEDTRAYLIST = bSelect;
      break;
   }

   case FUNC_FORMINFOFROMID:
   {
      pDbgInfo->bFORMINFOFROMID = bSelect;
      break;
   }

   case FUNC_READUSERDEFINEDFORMLIST:
   {
      pDbgInfo->bREADUSERDEFINEDFORMLIST = bSelect;
      break;
   }

   case FUNC_READUSERDEFINEDTRAYLIST:
   {
      pDbgInfo->bREADUSERDEFINEDTRAYLIST = bSelect;
      break;
   }

   case FUNC_SAVEUSERDEFINEDFORMLIST:
   {
      pDbgInfo->bSAVEUSERDEFINEDFORMLIST = bSelect;
      break;
   }

   case FUNC_SUBINITJOB:
   {
      pDbgInfo->bSUBINITJOB = bSelect;
      break;
   }

   case FUNC_SUBRASTER:
   {
      pDbgInfo->bSUBRASTER = bSelect;
      break;
   }

   case FUNC_SUBNEWPAGE:
   {
      pDbgInfo->bSUBNEWPAGE = bSelect;
      break;
   }

   case FUNC_SUBTERMJOB:
   {
      pDbgInfo->bSUBTERMJOB = bSelect;
      break;
   }

   case FUNC_SUBABORTJOB:
   {
      pDbgInfo->bSUBABORTJOB = bSelect;
      break;
   }

   case FUNC_SUBRASTERQUERY:
   {
      pDbgInfo->bSUBRASTERQUERY = bSelect;
      break;
   }

   case FUNC_TRAYNAMEFROMID:
   {
      pDbgInfo->bTRAYNAMEFROMID = bSelect;
      break;
   }

   case FUNC_GETIDSFROMCONNID:
   {
      pDbgInfo->bGETIDSFROMCONNID = bSelect;
      break;
   }

   case FUNC_GETDEFAULTFONTINFO:
   {
      pDbgInfo->bGETDEFAULTFONTINFO = bSelect;
      break;
   }

   case FUNC_GETDEFAULTFORMINFO:
   {
      pDbgInfo->bGETDEFAULTFORMINFO = bSelect;
      break;
   }

   case FUNC_FORMINFOFROMNAME:
   {
      pDbgInfo->bFORMINFOFROMNAME = bSelect;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESLINE:
   {
      pDbgInfo->bATTRIBUTEBUNDLESLINE = bSelect;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESAREA:
   {
      pDbgInfo->bATTRIBUTEBUNDLESAREA = bSelect;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESCHAR:
   {
      pDbgInfo->bATTRIBUTEBUNDLESCHAR = bSelect;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESIMAGE:
   {
      pDbgInfo->bATTRIBUTEBUNDLESIMAGE = bSelect;
      break;
   }

   case FUNC_ATTRIBUTEBUNDLESMARKER:
   {
      pDbgInfo->bATTRIBUTEBUNDLESMARKER = bSelect;
      break;
   }

   case FUNC_CHARSTRING:
   {
      pDbgInfo->bCHARSTRING = bSelect;
      break;
   }

   case FUNC_REALIZEFONT:
   {
      pDbgInfo->bREALIZEFONT = bSelect;
      break;
   }

   case FUNC_DEVICEPALETTE:
   {
      pDbgInfo->bDEVICEPALETTE = bSelect;
      break;
   }

   case FUNC_DEVESC_STARTDOC:
   {
      pDbgInfo->bDEVESC_STARTDOC = bSelect;
      break;
   }

   case FUNC_DEVESC_RAWDATA:
   {
      pDbgInfo->bDEVESC_RAWDATA = bSelect;
      break;
   }

   case FUNC_DEVESC_ENDDOC:
   {
      pDbgInfo->bDEVESC_ENDDOC = bSelect;
      break;
   }

   case FUNC_DEVESC_NEWFRAME:
   {
      pDbgInfo->bDEVESC_NEWFRAME = bSelect;
      break;
   }

   case FUNC_DEVESC_ABORTDOC:
   {
      pDbgInfo->bDEVESC_ABORTDOC = bSelect;
      break;
   }

   case FUNC_DEVESC_QUERYHALFTONESUPPORT:
   {
      pDbgInfo->bDEVESC_QUERYHALFTONESUPPORT = bSelect;
      break;
   }

   case FUNC_DEVESC_QUERYPATTERN:
   {
      pDbgInfo->bDEVESC_QUERYPATTERN = bSelect;
      break;
   }

   case FUNC_DEVESC_QUERYESCSUPPORT:
   {
     pDbgInfo->bDEVESC_QUERYESCSUPPORT = bSelect;
     break;
   }

   case FUNC_DEVESC_GETSCALINGFACTOR:
   {
      pDbgInfo->bDEVESC_GETSCALINGFACTOR = bSelect;
      break;
   }

   case FUNC_DEVESC_QUERYVIOCELLSIZES:
   {
      pDbgInfo->bDEVESC_QUERYVIOCELLSIZES = bSelect;
      break;
   }

   case FUNC_DEVESC_QUERYACTUALRESOLUTION:
   {
      pDbgInfo->bDEVESC_QUERYACTUALRESOLUTION = bSelect;
      break;
   }

   case FUNC_DEVESC_GETCP:
   {
      pDbgInfo->bDEVESC_GETCP = bSelect;
      break;
   }

   case FUNC_DEVESC_NEXTBAND:
   {
      pDbgInfo->bDEVESC_NEXTBAND = bSelect;
      break;
   }

   case FUNC_DEVESC_DRAFTMODE:
   {
      pDbgInfo->bDEVESC_DRAFTMODE = bSelect;
      break;
   }

   case FUNC_DEVESC_FLUSHOUTPUT:
   {
      pDbgInfo->bDEVESC_FLUSHOUTPUT = bSelect;
      break;
   }

   case FUNC_DEVESC_CHAR_EXTRA:
   {
     pDbgInfo->bDEVESC_CHAR_EXTRA = bSelect;
     break;
   }

   case FUNC_DEVESC_BREAK_EXTRA:
   {
      pDbgInfo->bDEVESC_BREAK_EXTRA = bSelect;
      break;
   }

   case FUNC_DEVESC_SETMODE:
   {
      pDbgInfo->bDEVESC_SETMODE  = bSelect;
      break;
   }

   case FUNC_DEVESC_DBE_FIRST:
   {
      pDbgInfo->bDEVESC_DBE_FIRST = bSelect;
      break;
   }

   case FUNC_DEVESC_DBE_LAST:
   {
      pDbgInfo->bDEVESC_DBE_LAST = bSelect;
      break;
   }

   case FUNC_DEVESC_STD_JOURNAL:
   {
      pDbgInfo->bDEVESC_STD_JOURNAL = bSelect;
      break;
   }

   default:
   {
      assertstring ("Unrecognized Function ID");
      DBPRINTIF ((pDbg->bDEBUGOUTPUT, "Unrecognized Function ID = %d\n", ulFuncID));
      bRC = FALSE;
      break;
   }
   }

   DBPRINTIF ((pDbg->bDEBUGOUTPUT, "SelectDebugOption: exit\n"));

  return bRC;

} /* end SelectDebugOption */

/****************************************************************************/
/* PROCEDURE NAME : SaveDebugFunctionList                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 06/14/94                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
SaveDebugFunctionList (HWND hwnd, PDLGINSTANCE pdi)
{
   BOOL        bSuccess = TRUE;
   SHORT       sIdx;
   ULONG       ul;

   DBPRINTF (("SaveDebugFunctionList(): Enter\n"));

   // clear out all old vals for new ones
   memset (&pdi->DebugInfo, 0, sizeof (DEBUGINFO));

   sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                           IDL_OPTIONS_DEBUG,
                                           LM_QUERYSELECTION,
                                           MPFROMSHORT (LIT_FIRST),
                                           MPVOID));

   // while items are still selected in listbox
   while (sIdx != LIT_NONE)
   {
      // Get Item Handle (Func ID)
      ul = (ULONG)WinSendDlgItemMsg (hwnd,
                                     IDL_OPTIONS_DEBUG,
                                     LM_QUERYITEMHANDLE,
                                     MPFROMSHORT (sIdx),
                                     MPVOID);

      SelectDebugOption (&pdi->DebugInfo, ul, TRUE);

      // Query listbox for next highlighted item
      sIdx = SHORT1FROMMR (WinSendDlgItemMsg (hwnd,
                                              IDL_OPTIONS_DEBUG,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT (sIdx),
                                              MPVOID));
   }

   // save a copy of "Debug info" to OS2SYS.INI
   bSuccess = PrfWriteProfileData (HINI_SYSTEMPROFILE,
                                   APPNAME_DEBUGINFO,
                                   KEYNAME_DEBUGINFO,
                                   &pdi->DebugInfo,
                                   sizeof (pdi->DebugInfo));
   assertF (bSuccess);

   DBPRINTF (("SaveDebugFunctionList(): PrfWriteProfileData(DebugInfo): Done\n"));

   /*---------------------------------------*/
   /* Re-Initialize debug information       */
   /*---------------------------------------*/
   InitDebugInfo (&globals.DebugInfo, FALSE, TRUE);

   DBPRINTF (("SaveDebugFunctionList(): Exit\n"));

   return bSuccess;

} /* end SaveDebugFunctionList */

/****************************************************************************/
/* PROCEDURE NAME : FillDebugFunctionList                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 06/14/94                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
FillDebugFunctionList (HWND hwnd, PDLGINSTANCE pdi, ULONG ulOption)
{
   BOOL     bSuccess = TRUE;
   ULONG    ul, ulIdx;
   SHORT    sIdx;
   BOOL     bHighlite;

   DBPRINTIF ((TRUE, "FillDebugFunctionList(): Enter; pbStringTbale = %x\n", globals.pbStringTable ));

   // free existing list
   WinSendDlgItemMsg (hwnd,
                      IDL_OPTIONS_DEBUG,
                      LM_DELETEALL,
                      MPVOID,
                      MPVOID);

   if (ulOption == DEBUG_HIGHLITE_ALL_OFF)
   {
      bHighlite = FALSE;
   }
   else
   {
      if (ulOption == DEBUG_HIGHLITE_ALL_ON)
        bHighlite = TRUE;

   }

   for (ul = STRING_TABLE_FUNC_BASE; ul < STRING_TABLE_FUNC_END; ul++)
   {
//////if (ul == STRING_TABLE_FUNC_BASE || ul == STRING_TABLE_FUNC_END)
//////{
//////}
      ulIdx = ul - STRING_TABLE_BASE;

      assertF (globals.pbStringTable[ulIdx]);

      if (!globals.pbStringTable[ulIdx])
      {
         DBPRINTIF ((TRUE,"FillDebugFunctionList(): String Table Entry at Index = '%d' is missing\n", ulIdx));
      }

      sIdx = (SHORT)WinSendDlgItemMsg (hwnd,
                                       IDL_OPTIONS_DEBUG,
                                       LM_INSERTITEM,
                                       MPFROM2SHORT (LIT_END, 0),
                                       MPFROMP (globals.pbStringTable[ulIdx]));

      ulIdx = ul - (ULONG)(STRING_TABLE_FUNC_BASE);

      WinSendDlgItemMsg (hwnd,
                         IDL_OPTIONS_DEBUG,
                         LM_SETITEMHANDLE,
                         MPFROMSHORT (sIdx),
                         MPFROMLONG (ulIdx));

      if (ulOption == DEBUG_HIGHLITE_CHECK)
         bHighlite = IsDebugOptionSelected (&pdi->DebugInfo, ulIdx);

      WinSendDlgItemMsg (hwnd,
                         IDL_OPTIONS_DEBUG,
                         LM_SELECTITEM,
                         MPFROMSHORT (sIdx),
                         MPFROMSHORT ((SHORT)bHighlite));
   }

   DBPRINTF (("FillDebugFunctionList(): Exit\n"));

   return bSuccess;

} /* end FillDebugFunctionList */

/****************************************************************************/
/* PROCEDURE NAME : DebugDlgProc                                            */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 11/06/93                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
DebugDlgProc (HWND hwnd, ULONG  msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE  pdi;
   BOOL          bRC;

   switch (msg)
   {
   case WM_INITDLG:
   {
      pdi = (PDLGINSTANCE)mp2;

      pdi->hwndDebugDlg = hwnd;

      // store the pointer to instance data
      bRC = WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      if (bRC)
      {
         FillDebugFunctionList (hwnd, pdi, DEBUG_HIGHLITE_CHECK);
      }

      // return since we handled init
      return 0;
   }

   case WM_COMMAND:
   {
      // get instance data
      pdi = (PDLGINSTANCE)WinQueryWindowULong (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_DEFAULTS:
      {
         InitDebugInfo (&pdi->DebugInfo, TRUE, FALSE);
         FillDebugFunctionList (hwnd, pdi, DEBUG_HIGHLITE_CHECK);

         return 0;
      }

      case DID_ADD:
      {
         FillDebugFunctionList (hwnd, pdi, DEBUG_HIGHLITE_ALL_ON);

         return 0;
      }

      case DID_DELETE:
      {
         FillDebugFunctionList (hwnd, pdi, DEBUG_HIGHLITE_ALL_OFF);

         return 0;
      }
      }

      return 0;
   }
   }

   // default for most cases
   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end DebugDlgProc */

/****************************************************************************/
/* PROCEDURE NAME : DebugInterpretSplMsgRC                                  */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 06/12/96                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL
DebugInterpretSplMsgRC (ULONG ulResponse, PSZ pszCode)
{
   BOOL fRet = TRUE;

   switch (ulResponse)
   {
   case MBID_IGNORE: strcpy (pszCode, "MBID_IGNORE");  break;
   case MBID_RETRY:  strcpy (pszCode, "MBID_RETRY");   break;
   case MBID_ABORT:  strcpy (pszCode, "MBID_ABORT");   break;
   case MBID_CANCEL: strcpy (pszCode, "MBID_CANCEL?"); break;
   case MBID_OK:     strcpy (pszCode, "MBID_OK?");     break;
   case MBID_ENTER : strcpy (pszCode, "MBID_ENTER?");  break;
   case MBID_YES:    strcpy (pszCode, "MBID_YES?");    break;
   case MBID_NO:     strcpy (pszCode, "MBID_NO?");     break;
   case MBID_ERROR:  strcpy (pszCode, "MBID_ERROR?");  break;
   default:
      strcpy (pszCode, "Unknown return code!");
      fRet = FALSE;
      break;
   }

  return fRet;

} /* end DebugInterpretSplMsgRC */

/****************************************************************************/
/* PROCEDURE NAME : DebugOutputJobProperties                                */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 8/01/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DebugOutputJobProperties (BOOL bShow, PSZ pszMsg, PJOBPROPERTIES pJobProp)
{
   if (bShow)
   {
      if (pszMsg)
      {
         DBPRINTF (("--------------------------\n"));
         DBPRINTF (("%s\n", pszMsg));
      }

      DBPRINTF (("--------------------------\n"));
      DBPRINTF (("cb                   = %d\n", pJobProp->cb));
      DBPRINTF (("achDriver            = %s\n", pJobProp->achDriver));
      DBPRINTF (("ulSig                = "));
      DBPRINTF (("%c", *((PCHAR)&pJobProp->ulSig)    ));
      DBPRINTF (("%c", *(((PCHAR)&pJobProp->ulSig)+1)));
      DBPRINTF (("%c", *(((PCHAR)&pJobProp->ulSig)+2)));
      DBPRINTF (("%c", *(((PCHAR)&pJobProp->ulSig)+3)));
      DBPRINTF (("\nulOrientation        = %lu\n",  pJobProp->ulOrientation));
      DBPRINTF (("ulCopies             = %lu\n",  pJobProp->ulCopies));
      DBPRINTF (("ulDefConnID          = %lu\n",  pJobProp->ulDefConnID));
      DBPRINTF (("ulDefNonMetricConnID = %lu\n",  pJobProp->ulDefNonMetricConnID));
      DBPRINTF (("ulDefFontID          = %lu\n",  pJobProp->ulDefFontID));
      DBPRINTF (("ulDefResID           = %lu\n",  pJobProp->ulDefResID));
      DBPRINTF (("ulDefPrintModeID     = %lu\n",  pJobProp->ulDefPrintModeID));
      DBPRINTF (("ulCompressModes      = %lu\n",  pJobProp->ulCompressModes));
      DBPRINTF (("usForeground         = %lu\n",  pJobProp->usForeground));
      DBPRINTF (("usBackground         = %lu\n",  pJobProp->usBackground));
      DBPRINTF (("ulImageoption        = %lu\n",  pJobProp->ulImageoption));
      DBPRINTF (("ulAlgorithm          = %lu\n",  pJobProp->ulAlgorithm));
      DBPRINTF (("ulLevel              = %lu\n",  pJobProp->ulLevel));
      DBPRINTF (("lHue                 = %d\n",   pJobProp->lHue));
      DBPRINTF (("lSaturation          = %d\n",   pJobProp->lSaturation));
      DBPRINTF (("lValue               = %d\n",   pJobProp->lValue));
      DBPRINTF (("lDarkness            = %d\n",   pJobProp->lDarkness));
      DBPRINTF (("bFFControlType       = %d\n",   pJobProp->bFFControlType));
      DBPRINTF (("ulJobPhaseControl    = %08X\n", pJobProp->ulJobPhaseControl));
      DBPRINTF (("lRedAdjust           = %d\n",   pJobProp->lRedAdjust));
      DBPRINTF (("lGreenAdjust         = %d\n",   pJobProp->lGreenAdjust));
      DBPRINTF (("lBlueAdjust          = %d\n",   pJobProp->lBlueAdjust));
      DBPRINTF (("lRedBias             = %d\n",   pJobProp->lRedBias));
      DBPRINTF (("lGreenBias           = %d\n",   pJobProp->lGreenBias));
      DBPRINTF (("lBlueBias            = %d\n",   pJobProp->lBlueBias));
      DBPRINTF (("ulDuplexOptions      = %d\n",   pJobProp->ulDuplexOptions));
      DBPRINTF (("sBlackAdjust         = %d\n",   pJobProp->sBlackAdjust));
      DBPRINTF (("bBlackBias           = %d\n",   pJobProp->bBlackBias));

      DBPRINTF (("--------------------------\n"));
   }
} /* end DebugOutputJobProperties */

/****************************************************************************/
/* PROCEDURE NAME : DebugOutputFormInfo                                     */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 8/03/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DebugOutputFormInfo (BOOL bShow, PSZ pszMsg, PFORMINFO pfi)
{
   if (bShow)
   {
      if (pszMsg)
      {
         DBPRINTF (("--------------------------\n"));
         DBPRINTF (("%s\n", pszMsg));
      }

      DBPRINTF (("--------------------------\n"));
      DBPRINTF (("  pfi->Form.ulFormID          = '%lu'\n", pfi->Form.ulFormID));
      DBPRINTF (("  pfi->Form.hcInfo.szFormname = '%s'\n",  pfi->Form.hcInfo.szFormname));
      DBPRINTF (("  pfi->cx       = '%lu'\n", pfi->cx      ));
      DBPRINTF (("  pfi->cy       = '%lu'\n", pfi->cy      ));
      DBPRINTF (("  pfi->ulLeft   = '%lu'\n", pfi->ulLeft  ));
      DBPRINTF (("  pfi->ulBottom = '%lu'\n", pfi->ulBottom));
      DBPRINTF (("  pfi->ulRight  = '%lu'\n", pfi->ulRight ));
      DBPRINTF (("  pfi->ulTop    = '%lu'\n", pfi->ulTop   ));
      DBPRINTF (("--------------------------\n"));
   }
} /* end DebugOutputFormInfo */

/****************************************************************************/
/* PROCEDURE NAME : DebugBitmap                                             */
/* AUTHOR         : Mark Hamzy                                              */
/* DATE WRITTEN   : 8/15/94                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DebugBitmap (PBYTE pbBits,
             INT   cx,
             INT   cy,
             INT   iBitCount,
             BOOL  fDWordAligned,
             INT   iStartX,
             INT   iEndX)
{
   static CHAR  achTemp[255];
   static BYTE  flMask[8] = {
                0x80,
                0x40,
                0x20,
                0x10,
                0x08,
                0x04,
                0x02,
                0x01
   };
   INT          iBitsInArray,
                iBytesInArray,
                iBumpTo;
   register INT x, y;

   if (fDWordAligned)
      iBumpTo = 32;
   else
      iBumpTo = 8;

   iBitsInArray  = BUMP_TO_NEXT_MODULUS (cx * iBitCount, iBumpTo);
   iBytesInArray = iBitsInArray/8;

   for (y = cy - 1; y >= 0; y--)
   {
      for (x = iStartX; x < iEndX; x++)
      {
         if (1 == iBitCount)
         {
            if (pbBits[y * iBytesInArray + x / 8] & flMask[x % 8])
               achTemp[x - iStartX] = '*';
            else
               achTemp[x - iStartX] = '.';
         }
         else if (8 == iBitCount)
         {
            if (0xFF != pbBits[y * iBytesInArray + x])
               achTemp[x - iStartX] = '*';
            else
               achTemp[x - iStartX] = '.';
         }
      }

      achTemp[x - iStartX] = 0;

      DBPRINTF (("%s\n", achTemp));
   }
}

#if 0
VOID
TestCompress (PBYTE pbBuffer, PBYTE pbCompress)
{
   // Test compression method by decompressing and comparing

   BOOL            bGood = TRUE;
   unsigned char   uch, *puchBuffer;
   INT             dups;
   register INT    i, j;

   puchBuffer = pbBuffer;
   for (i = 0; i < iCompressed && bGood; )
   {
      uch = pbCompress[i++];
      if (uch & 0x80)
      {
         // NEGATIVE -- Repeat counter : Data byte
         dups = 256 - uch + 1;
         for (j = 0; j < dups && bGood; j++)
            bGood = pbCompress[i] == *(puchBuffer++);
         i++;
      }
      else
      {
         // POSITIVE -- Data block count : Data block
         dups = uch + 1;
         for (j = 0; j < dups && bGood; j++)
            bGood = pbCompress[i++] == *(puchBuffer++);
      }
   }
   assertF (bGood);
   assertF ((INT)(puchBuffer - pbBuffer - 1) == iBytesInCX);
}
#endif

VOID
ShowBitmap (PDDC pddc, PCHAR pchRet, PBITMAPINFO2 pbmi)
{
   // this is debugging code: show the DC bitmap on the screen
   LONG              lrc;
   LONG              cColors;
   HDC               hdc;
   DEVOPENSTRUC      dos = {NULL, "DISPLAY"};
   HPS               hps;
   POINTL            aptl[4];
   HBITMAP           hbm;
   RECTL             rectl;
   BOOL              bRC;
   BITMAPINFOHEADER  bmihx;
   PBITMAPINFOHEADER pbmihx = &bmihx;
   PBITMAPINFO       pbmix = NULL;

   cColors = Power(2, pbmi->cBitCount);

   *pbmihx = pddc->bmp;

   // use regular heap alloc for bitmapinfo2 struct
   pbmix = (PBITMAPINFO)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                        sizeof (BITMAPINFO)
                                        + cColors * sizeof (RGB2));


   if (!pddc->pdb->bRasterPortrait)        // if landscape
      SWAP (pbmihx->cx, pbmihx->cy);

   pbmix->cbFix     = sizeof (BITMAPINFOHEADER);
   pbmix->cx        = pbmihx->cx;
   pbmix->cy        = pbmihx->cy;
   pbmix->cPlanes   = pbmihx->cPlanes;
   pbmix->cBitCount = pbmihx->cBitCount;

   if (GRE_22 > globals.ulGreVersion)   // Not 2.2 Engine
      GreQueryLogColorTable (pddc->hdcShadow,0,0,256,(PLONG)&pbmix->argbColor[0]);
   else
      memcpy ((PRGB2)pbmix->argbColor, (PRGB2)pbmi->argbColor, cColors * sizeof (RGB2));

   // open a screen DC
   hdc = DevOpenDC (WinQueryAnchorBlock (HWND_DESKTOP),
                    OD_MEMORY,
                    "*",
                    2,
                    (PDEVOPENDATA)&dos,
                    0);
   assertF (hdc);

   // Get the screen PS
   hps = WinGetScreenPS (HWND_DESKTOP);
   DBPRINTIF ((TRUE, "Screen PS = %x\n", hps));
   assertF (hps);

   // get size of screen
   WinQueryWindowRect (HWND_DESKTOP, &rectl);

   // Go into RGB mode
   bRC = GpiCreateLogColorTable (hps, LCOL_RESET, LCOLF_RGB, 0, 0, (PLONG)NULL);
   assertF (bRC);

   // flood screen with white
   bRC = WinFillRect (hps, &rectl, 0xFFFFFF);
   assertF (bRC);

   DBPRINTIF ((TRUE, "pbmihx->cbFix = %d", pbmihx->cbFix));
   DBPRINTIF ((TRUE, "pbmihx->cx = %d", pbmihx->cx));
   DBPRINTIF ((TRUE, "pbmihx->cy = %d", pbmihx->cy));
   DBPRINTIF ((TRUE, "pbmihx->cPlanes = %d", pbmihx->cPlanes));
   DBPRINTIF ((TRUE, "pbmihx->cBitCount = %d", pbmihx->cBitCount));

   // Create a temporary bitmap to bitblt to the screen...
   hbm = GreCreateBitmap (hdc,
                          pbmihx,
                          CBM_INIT,
                          pchRet,
                          pbmix);
   assertF (hbm);

#if 1
   // 1:1 blt: blt lower left part of shadow DC bitmap; this will be fast,
   // but can't see it all on screen
   // target points
   aptl[0].x = 0;
   aptl[0].y = 0;
   aptl[1].x = min (rectl.xRight, pbmi->cx) - 1;
   aptl[1].y = min (rectl.yTop,   pbmi->cy) - 1;
   // source points
   aptl[2].x = 0;
   aptl[2].y = 0;
   aptl[3].x = min (rectl.xRight, pbmi->cx);
   aptl[3].y = min (rectl.yTop,   pbmi->cy);

   // Bump the target diagonally up and right...
   aptl[0].x += 10;
   aptl[0].y += 10;
   aptl[1].x += 10;
   aptl[1].y += 10;
#else
   // stretch blt -- can be slow
   // preserve aspect ratio of bitmap, provided display has square pixels
   // like VGA target points
   aptl[0].x = 0;
   aptl[0].y = 0;

   if (pbmi->cx > pbmi->cy)
   {
      // X length is larger.  Set X to screen size
      // Scale Y with aspect ratio
      aptl[1].x = rectl.xRight - 1;
      aptl[1].y = rectl.xRight * pbmi->cy / pbmi->cx - 1;
   }
   else
   {
      // Y length is larger.  Set Y to screen size
      // Scale X with aspect ratio
      aptl[1].x = rectl.yTop * pbmi->cx / pbmi->cy - 1;
      aptl[1].y = rectl.yTop - 1;
   }
   // source points
   aptl[2].x = 0;
   aptl[2].y = 0;
   aptl[3].x = pbmi->cx;
   aptl[3].y = pbmi->cy;
#endif

   if (1 == pbmi->cBitCount)
      // MONOCHROME - invert the bits on the blt: NOTSRC
      lrc = GpiWCBitBlt (hps, hbm, 4, aptl, ROP_NOTSRCCOPY, BBO_OR);
   else
      // COLOR - straight copy
      lrc = GpiWCBitBlt (hps, hbm, 4, aptl, ROP_SRCCOPY, BBO_AND);
   assertF (lrc != GPI_ERROR);

#if  defined(DEBUG) && DEBUG
   // stop on an int 3 at debug terminal
   DBPRINTIF ((TRUE, "Done with 1:1 bitblt. Enter G to go.\n"));
   DebugPause ();
#else
   WinMessageBox (HWND_DESKTOP,
                  NULLHANDLE,
                  (PSZ)"Hit Button to resume",
                  (PSZ)"NewFrame",
                  1L,
                  MB_OK);
#endif

   // Clean up ...
   GreDeleteBitmap (hbm);

   // return ps to cache
   lrc = (LONG)WinReleasePS (hps);
   assertF (lrc);

   DevCloseDC (hdc);

   if (pbmix)
      GplMemoryFree (pbmix);

} /* end ShowBitmap */

BOOL
ShowTrueGamma (HWND           hwndGamma,
               PDLGINSTANCE   pdi,
               PJOBPROPERTIES pJobProps,
               BOOL           bInitializing)
{
   PDRIVERINFO   pDriver        = pdi->pDriver;
   PDEVICEINFO   pDevice        = pdi->pDevice;
   ULONG         ulTrayID,
                 ulFormID,
                 ulMediaID;
   LONG          lRedGamma,
                 lGreenGamma,
                 lBlueGamma,
                 lBlackGamma;
   INT           i;
   CHAR          szTemp[32];

#if 0
   // @TBD - This loads the Job Props structure from the dialog.  This
   //        seems slightly hokey since we probably only need to read
   //        the slider controls in the gamma correction page.
   if (!bInitializing)
      SaveJobProperties (pdi, pJobProps);
#else
   if (pdi->fAfterInitialization)
      ReadGammaControls (pJobProps, pdi->pNBI->PageInfoImageClr.hwndPage);
   else
      return FALSE;
#endif

   //-----------------------------------------------------
   // Retrieve correct gamma values to insert in controls
   //-----------------------------------------------------

   // Get dialog visable gamma values for setup
   if (pDriver != NULL && pDevice != NULL)
   {
      ULONG   ulConnectionID;
      APIRET  rc;

      if (pdi->ctryInfo.country == COUNTRYCODE_USA    ||
          pdi->ctryInfo.country == COUNTRYCODE_CANADA  )
         ulConnectionID = pJobProps->ulDefNonMetricConnID;
      else
         ulConnectionID = pJobProps->ulDefConnID;

      rc = GetIDsFromConnID (pDriver,
                             pDevice,
                             ulConnectionID,
                             &ulTrayID,
                             &ulFormID,
                             &ulMediaID);
      assertF (rc);

      i = FindGamma (pDriver->pGammas->pSelect,
                     pDriver->pGammas->pFamily,
                     pDevice->usDeviceID,
                     pDriver->pGammas->pRes,
                     pJobProps->ulDefResID,
                     pDriver->pGammas->pMedia,
                     ulMediaID,
                     pDriver->pGammas->pMode,
                     pJobProps->ulDefPrintModeID,
                     pJobProps->ulAlgorithm);
      DBPRINTF (("%s(): FindGamma returns %d\n", __FUNCTION__, i));

      lRedGamma   = (ULONG)(pDriver->pGammas->pSelect+i)->bCGamma;
      lGreenGamma = (ULONG)(pDriver->pGammas->pSelect+i)->bMGamma;
      lBlueGamma  = (ULONG)(pDriver->pGammas->pSelect+i)->bYGamma;
      lBlackGamma = (ULONG)(pDriver->pGammas->pSelect+i)->bKGamma;

#ifndef DEBUG
      rc++;        // Avoid compiler warnings
#endif
   }

   //-------------------------------------
   // Report TRUE base gammas
   //-------------------------------------
   sprintf (szTemp, "%2.1f%+2.1f", ((float)lRedGamma) / 10.0,
            (float)pJobProps->lRedAdjust / 10.0);

   WinSetDlgItemText (hwndGamma, IDT_RED_GAMMA, szTemp);

   sprintf (szTemp, "%2.1f%+2.1f", ((float)lGreenGamma) / 10.0,
            (float)pJobProps->lGreenAdjust / 10.0);

   WinSetDlgItemText( hwndGamma, IDT_GREEN_GAMMA, szTemp );

   sprintf (szTemp, "%2.1f%+2.1f", ((float)lBlueGamma) / 10.0,
            (float)pJobProps->lBlueAdjust / 10.0);

   WinSetDlgItemText (hwndGamma, IDT_BLUE_GAMMA, szTemp);

   sprintf (szTemp, "%2.1f%+2.1f", ((float)lBlackGamma) / 10.0,
            (float)pJobProps->sBlackAdjust / 10.0);

   WinSetDlgItemText (hwndGamma, IDT_BLACK_GAMMA, szTemp);

   return TRUE;

} /* end ShowTrueGamma */

/****************************************************************************/
/* PROCEDURE NAME : GammaDlgProc                                            */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 2/3/96                                                  */
/* DESCRIPTION    :                                                         */
/* PARAMETERS:                                                              */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @204332 - changed all occurances of GplDitherQueryGamma (pvDitherHandle  */
/*           to GplDitherQueryGamma (&pvDitherHandle                        */
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY
GammaDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PDLGINSTANCE  pdi;
   PVOID         pvDitherHandle;

   switch(msg)
   {
   case WM_INITDLG:
   {
      CHAR           szMsg[256];
      ULONG          ulTemp;
      INT            i;
      PBYTE          pbGamma;
      HWND           hwndLB      = WinWindowFromID (hwnd, IDL_GAMMA);
      PDRIVERINFO    pDriver;
      PDEVICEINFO    pDevice;
      ULONG          ulTrayID,
                     ulFormID,
                     ulMediaID;
      LONG           lRedGamma,
                     lGreenGamma,
                     lBlueGamma,
                     lBlackGamma;
      LONG           lCGamma,
                     lMGamma,
                     lYGamma;
      PJOBPROPERTIES pJobProps;
      PDITHEREQUEST  pdRequest;
      PDITHERESULT   pdResult;
      PGRAPHINFO     pgi;

      // Get program data from mp2 which is set by caller
      pdi = (PDLGINSTANCE)mp2;
      assertF (pdi);

      // store the pointer to instance data
      WinSetWindowULong (hwnd, QWL_USER, (ULONG)pdi);

      pgi = &(pdi->gi);

      pgi->bInitialized = FALSE;

      pJobProps = (PJOBPROPERTIES)GplMemoryAlloc (pdi->hmcbHeap, sizeof (JOBPROPERTIES));
      pdRequest = (PDITHEREQUEST)GplMemoryAlloc (pdi->hmcbHeap, sizeof (DITHEREQUEST));
      pdResult  = (PDITHERESULT)GplMemoryAlloc (pdi->hmcbHeap, sizeof (DITHERESULT));

      pDriver = pdi->pDriver;
      pDevice = pdi->pDevice;

      SaveJobProperties (pdi, pJobProps);

      if (!pJobProps->ulDefNonMetricConnID)
         pJobProps->ulDefNonMetricConnID = pdi->pJobProperties->ulDefNonMetricConnID;

      //-----------------------------------------------------
      // Retrieve correct gamma values to insert in controls
      //-----------------------------------------------------

      // Get dialog visable gamma values for setup
      if (pDriver != NULL && pDevice != NULL)
      {
         ULONG   ulConnectionID;
         APIRET  rc;

         if (pdi->ctryInfo.country == COUNTRYCODE_USA    ||
             pdi->ctryInfo.country == COUNTRYCODE_CANADA  )
            ulConnectionID = pJobProps->ulDefNonMetricConnID;
         else
            ulConnectionID = pJobProps->ulDefConnID;

         rc = GetIDsFromConnID (pDriver,
                                pDevice,
                                ulConnectionID,
                                &ulTrayID,
                                &ulFormID,
                                &ulMediaID);
         assertF (rc);

         i = FindGamma (pDriver->pGammas->pSelect,
                        pDriver->pGammas->pFamily,
                        pDevice->usDeviceID,
                        pDriver->pGammas->pRes,
                        pJobProps->ulDefResID,
                        pDriver->pGammas->pMedia,
                        ulMediaID,
                        pDriver->pGammas->pMode,
                        pJobProps->ulDefPrintModeID,
                        pJobProps->ulAlgorithm);
         DBPRINTF (("%s(): FindGamma returns %d\n", __FUNCTION__, i));

         lRedGamma   = (ULONG)(pDriver->pGammas->pSelect+i)->bCGamma;
         lGreenGamma = (ULONG)(pDriver->pGammas->pSelect+i)->bMGamma;
         lBlueGamma  = (ULONG)(pDriver->pGammas->pSelect+i)->bYGamma;
         lBlackGamma = (ULONG)(pDriver->pGammas->pSelect+i)->bKGamma;

#ifndef DEBUG
      rc++;        // Avoid compiler warnings
#endif
      }

      GplGammaConvertRGBtoCMY (pJobProps->lRedAdjust,
                               pJobProps->lGreenAdjust,
                               pJobProps->lBlueAdjust,
                               &lCGamma,
                               &lMGamma,
                               &lYGamma);

      pdRequest->lRGamma = lRedGamma   + lCGamma;
      pdRequest->lGGamma = lGreenGamma + lMGamma;
      pdRequest->lBGamma = lBlueGamma  + lYGamma;
      pdRequest->lKGamma = lBlackGamma + pJobProps->sBlackAdjust;

      pdRequest->ulGBias     = pJobProps->lGreenBias;
      pdRequest->ulRBias     = pJobProps->lRedBias;
      pdRequest->ulKBias     = pJobProps->bBlackBias;
      pdRequest->ulBBias     = pJobProps->lBlueBias;
      pdRequest->lDitherType = pJobProps->ulAlgorithm;

      // Set dialog text values
      sprintf (szMsg, "%s = %2.1f %+2.1f = %2.1f",
               globals.pbStringTable[COLOR_STRING_CYAN-STRING_TABLE_BASE],
               (float)lRedGamma/10.0,
               (float)lCGamma/10.0,
               (float)pdRequest->lRGamma/10.0);

      WinSetDlgItemText (hwnd, IDT_CYAN, szMsg);

      sprintf (szMsg, "%s = %2.1f %+2.1f = %2.1f",
//             globals.pbStringTable[COLOR_STRING_MAGENTA-STRING_TABLE_BASE],
               "Magenta",
               (float)lGreenGamma/10.0,
               (float)lMGamma/10.0,
               (float)pdRequest->lGGamma/10.0);

      WinSetDlgItemText (hwnd, IDT_MAGENTA, szMsg);

      sprintf (szMsg, "%s = %2.1f %+2.1f = %2.1f",
               globals.pbStringTable[COLOR_STRING_YELLOW-STRING_TABLE_BASE],
               (float)lBlueGamma/10.0,
               (float)lYGamma/10.0,
               (float)pdRequest->lBGamma/10.0);

      WinSetDlgItemText (hwnd, IDT_YELLOW, szMsg);

      sprintf (szMsg, "%s = %2.1f %+2.1f = %2.1f",
               globals.pbStringTable[COLOR_STRING_BLACK-STRING_TABLE_BASE],
               (float)lBlackGamma/10.0,
               (float)pJobProps->sBlackAdjust/10.0,
               (float)pdRequest->lKGamma/10.0);

      WinSetDlgItemText (hwnd, IDT_BLACK, szMsg);

      pvDitherHandle = NULL;
      GplDitherCreateInstance ((PPVOID)&pvDitherHandle,
                               pdi->hmcbHeap,
                               pdRequest,
                               pdResult);
      assertF (pvDitherHandle);

      //-------------------------------------
      // Report TRUE base gammas
      //-------------------------------------
      sprintf (szMsg, "Cyan =   %2.1f %+2.1f = %+2.1f",
               ((float)lRedGamma)/10.0,
               (float)lCGamma/10.0,
               (float)pdRequest->lRGamma/10.0);

      WinInsertLboxItem (hwndLB, LIT_END, szMsg);

      sprintf (szMsg, "Magenta = %2.1f %+2.1f = %+2.1f",
               ((float)lGreenGamma)/10.0,
               (float)lMGamma/10.0,
               (float)pdRequest->lGGamma/10.0);

      WinInsertLboxItem (hwndLB, LIT_END, szMsg);

      sprintf (szMsg, "Yellow =  %2.1f %+2.1f = %+2.1f",
               ((float)lBlueGamma)/10.0,
               (float)lYGamma/10.0,
               (float)pdRequest->lBGamma/10.0);

      WinInsertLboxItem (hwndLB, LIT_END, szMsg);

      sprintf (szMsg, "Black = %2.1f %+2.1f = %+2.1f",
               ((float)lBlackGamma)/10.0,
               (float)pJobProps->sBlackAdjust/10.0,
               (float)pdRequest->lKGamma/10.0);

      WinInsertLboxItem (hwndLB, LIT_END, szMsg);

      sprintf (szMsg, "------------------------------------");
      WinInsertLboxItem (hwndLB, LIT_END, szMsg);

      // RED
      pbGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_RED);

      for (i = 0; i < NUM_RGB_VALUES; i++)
      {
         ulTemp = pbGamma[i];

         sprintf (szMsg, "Input Red '%3d' = Output Cyan '%3d'", i, ulTemp);
         WinInsertLboxItem (hwndLB, LIT_END, szMsg);
      }

      // GREEN
      pbGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_GREEN);

      for (i = 0; i < NUM_RGB_VALUES; i++)
      {
         ulTemp = pbGamma[i];

         sprintf (szMsg, "Input Green '%3d' = Output Magenta '%3d'", i, ulTemp);
         WinInsertLboxItem (hwndLB, LIT_END, szMsg);
      }

      // BLUE
      pbGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_BLUE);

      for (i = 0; i < NUM_RGB_VALUES; i++)
      {
         ulTemp = pbGamma[i];

         sprintf (szMsg, "Input Blue '%3d' = Output Yellow '%3d'", i, ulTemp);
         WinInsertLboxItem (hwndLB, LIT_END, szMsg);
      }

      // BLACK
      pbGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_BLACK);

      for (i = 0; i < NUM_RGB_VALUES; i++)
      {
         ulTemp = pbGamma[i];

         sprintf (szMsg, "Input Black '%3d' = Output Black '%3d'", i, ulTemp);
         WinInsertLboxItem (hwndLB, LIT_END, szMsg);
      }

      // create a window to plot points in
      {
         // setup gamma curves
         pgi->pbRGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_RED);
         pgi->pbGGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_GREEN);
         pgi->pbBGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_BLUE);
         pgi->pbKGamma = GplDitherQueryGamma (&pvDitherHandle, DITHER_GAMMA_BLACK);

         // give controlout heap to alloc from
         pgi->hmcb = pdi->hmcbHeap;

         // Notify the graph window of the current gammas
         WinSendMsg (WinWindowFromID (hwnd, IDD_GRAPH),
                     WM_USER_INFO,
                     MPFROMP (pgi),
                     (MPARAM)0);

         pdi->pv1 = (PVOID)pvDitherHandle;
      }

      if (pJobProps)
         GplMemoryFree (pJobProps);
      if (pdRequest)
         GplMemoryFree (pdRequest);
      if (pdResult)
         GplMemoryFree (pdResult);

      return 0;
   }

   case WM_DESTROY:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowPtr (hwnd, QWL_USER);
      pvDitherHandle = (PVOID)pdi->pv1;

      GplDitherDeleteInstance (pvDitherHandle);
      break;
   }

   case WM_COMMAND:
   {
      pdi = (PDLGINSTANCE)WinQueryWindowPtr (hwnd, QWL_USER);

      switch (SHORT1FROMMP (mp1))
      {
      case DID_OK:
      {
         WinDismissDlg (hwnd, TRUE);
         return 0;
      }
      }

      break;
   }
   }

   return WinDefDlgProc (hwnd, msg, mp1, mp2);

} /* end GammaDlgProc */

typedef struct _DebugDefines {
   ULONG     ulDefineNumber;
   PSZ       pszDefineName;
} DEBUGDEFINES, *PDEBUGDEFINES;

#define CREATE_DEBUG_DEFINE_FROM(x) {x, #x}

#define dimof(a) (sizeof (a)/sizeof (a[0]))

#define INSTANTIATE(f,t) VOID f (ULONG ul)                                        \
                         {                                                        \
                            register INT i;                                       \
                                                                                  \
                            for (i = 0; i < dimof (t); i++)                       \
                            {                                                     \
                               if (ul == t[i].ulDefineNumber)                     \
                               {                                                  \
                                  DBPRINTF (("%s\n", t[i].pszDefineName));        \
                                  return;                                         \
                               }                                                  \
                            }                                                     \
                            DBPRINTF (("%s: Unknown id %d\n", __FUNCTION__, ul)); \
                         }

#undef DEBUG_INCLUDE_PRINT_STRING_TABLE_DEFINE
#define DEBUG_INCLUDE_PRINT_STRING_TABLE_DEFINE 1

#ifdef DEBUG_INCLUDE_PRINT_STRING_TABLE_DEFINE
/* This if for making a debug.lst file and figuring out which define goes with what number
*/
DEBUGDEFINES aStringTableDefines[] = {
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_ERROR_BASE),
   CREATE_DEBUG_DEFINE_FROM (ERROR_STRING_OFFLINE),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_ERROR_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FORM_BASE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_UNLISTED),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_NONE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_LETTER),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_LEGAL),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_LEDGER),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_EXECUTIVE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A3),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A4),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A5),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B4),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B5),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B5_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C5_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C9_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C10_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_DL_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_MONARCH),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_TEST),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C6_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_CONT_LETTER),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_3x5_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_4x6_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_5x8_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A6_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_HAGAKI_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A2_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A2),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_TABLOID),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FOOLSCAP),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_US_STANDARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_TRACTOR),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_LETTER_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_LEGAL_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A3_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A4_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_A5_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B4_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B5_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_TABLOID_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FOOLSCAP_WIDE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_UNIVERSAL),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FULL_11_X_17),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_INDEX_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_POSTCARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B6),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_D5_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_C7_ENV),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_12_X_19),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_US_FANFOLD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD1),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD2),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD3),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD4),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD5),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FANFOLD6),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_ENV_132_220),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_PHOTO_4_6),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_PHOTO_100_150),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_PHOTO_200_300),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_PANORAMIC),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_STANDARD_LABELS_WHITE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_STANDARD_LABELS_CLEAR),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SHIPPING_LABELS),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_DISK_LABELS),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_EURO_LABELS),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_15_X_11),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_10_X_11),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_B),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_C),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_D),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_E),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A4),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A3),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A2),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A1),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_A0),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_AB),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_AC),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_AD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_AE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SIZE_HALF_LETTER),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_8x10_CARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_B3),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SUPER_A3_B),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_US_C_ARCHITECTURAL),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_US_D_ARCHITECTURAL),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_US_E_ARCHITECTURAL),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_SUPER_B),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_FABRIC_SIZE),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_OFUKU_HAGAKI),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_KAKU_2),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_KAKU_3),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_KAKU_4),
   CREATE_DEBUG_DEFINE_FROM (FORM_STRING_HP_GREETING_CARD),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FORM_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_TRAY_BASE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_UNLISTED),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_NONE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_UPPER_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_LOWER_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MULTI_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_UPPER_CASSETTE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_LOWER_CASSETTE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MULTI_CASSETTE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MANUAL_FEED),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MANUAL_ENV),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_PAPER_FEED),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_ENV_FEED),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CSF),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_F_CONTINUOUS),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_R_CONTINUOUS),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_SINGLE_SHEET),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_SHEET_FEEDER),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_BIN_1),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_BIN_2),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_AUTO_FEEDER),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MANUAL_FEEDER),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_PORTABLE_SHEET),
#if JPNBLD || TWNBLD
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE1),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE2),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE3),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE4),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE5),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE1_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE2_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE3_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE4_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_CASSETTE5_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_FRONT_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_UPPER_CASSETTE_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_LOWER_CASSETTE_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_MANUAL_TRAY),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_OPTION_CASSETTE),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_DEPEND_ON_PANEL),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_OPTION_MULTI_SF),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY1),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY2),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY3),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY4),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY5),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY1_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY2_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY3_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY4_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRAY5_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_MULTI_FEEDER),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_MULTI_FEEDER_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_PAPER_DECK_O),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_TRACTOR_UNIT),
   CREATE_DEBUG_DEFINE_FROM (TRAY_STRING_J_AUTO_SELECT),
#endif
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_TRAY_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_RES_BASE),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_UNLISTED),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_NONE),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_DRAFT),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_NORMAL),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_PRESENTATION),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_LOW),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_MEDIUM),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_HIGH),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_PHOTO_QUALITY),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_90_X_90),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_180_X_180),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_360),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_720_X_360),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_720_X_720),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_75_X_75),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_150_X_150),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_300_X_300),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_600_X_300),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_600_X_600),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_GROUP_3),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_GROUP_4),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_FINE),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_240_X_240),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_100_X_100),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_60_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_120_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_60_X_60_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_80_X_60_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_90_X_60_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_120_X_60_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_240_X_60_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_72_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_80_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_90_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_144_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_240_X_72_8_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_60_X_180_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_90_X_180_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_120_X_180_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_180_X_180_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_180_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_60_X_360_48_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_90_X_360_48_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_120_X_360_48_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_180_X_360_48_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_360_48_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_180),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_720),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_360_X_360_24_PINS),
   CREATE_DEBUG_DEFINE_FROM (RES_STRING_1440_X_720),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_RES_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_PRINT_MODE_BASE),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_UNLISTED),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_NONE),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_COLOR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MONOCHROME),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_K),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CMY),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CMYK),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_BLACK),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_BLACK_ONLY),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_COLOR_ONLY),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_BLACK_COLOR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_1BIT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_4BIT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_8BIT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_16BIT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_24BIT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_24_CLR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_24_BLK_CLR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MONO_DRAFT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MONO_ECON),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MONO_LQ),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MONO_PRES),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CLR_DRAFT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CLR_ECON),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CLR_LQ),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CLR_PRES),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_GRAYSCALE),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_8_CLR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_8_BLK_CLR),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_GROUP_3),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_GROUP_4),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_CCITT_1D),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_LIGHTEST),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MED_LIGHT),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_NORMAL),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_MED_DARK),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_DARKEST),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_24_CLR_5),
   CREATE_DEBUG_DEFINE_FROM (PRINT_MODE_STRING_24_BLK_CLR_5),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_PRINT_MODE_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FORM_CLASS_BASE),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_SHEET_PAPAR),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_CONT_PAPAR),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_ENVELOPE),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_POSTCARD),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_LABEL),
   CREATE_DEBUG_DEFINE_FROM (FORM_CLASS_STRING_OTHER),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FORM_CLASS_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_MEDIA_BASE),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_UNLISTED),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_NONE),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_PLAIN),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_TRANSPARENCY),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_GLOSSY),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_SPECIAL),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_COATED),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_BACKPRINT),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_CLOTH),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_THICK),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_OTHER),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_HIGH_GLOSS_FILM),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_HIGH_RESOLUTION),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_SPECIAL_360),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_SPECIAL_720),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_HP_PREMIUM_PAPER),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_STRING_HP_PHOTOGRAPHIC_PAPER),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_MEDIA_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_DLG_BASE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_COMMANDS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FORMS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TRAYS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_PAPER),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FONTS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEBUG),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DATA),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_COMMON),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_COLOR),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_MONOCHROME),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_HSV),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_SAVE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_CANCEL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_DEFAULTS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_HELP),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_ADD),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_MODIFY),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TEXT_DELETE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_CONN_ID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_CONN_USERID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FORM_ID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FORM_USERID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TRAY_ID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TRAY_USERID),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEV_DEFAULTS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_PRINTER_PROPS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_JOB_PROPS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEV_MEMORY),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEV_VERSION),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_ON),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_OFF),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_NORMAL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_RESOLUTION),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEF_TRAYS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TRAY_NAME),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_TRAY_TYPE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_AUTOMATIC),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_MANUAL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_COMPRESSION),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEGREES),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FONT_NLQ),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FONT_DRAFT),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FONT_SIZE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_CONDITIONAL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_COMPULSORY),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DRY_TIMER),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DEFAULT_FONT),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_NONE_AVAILABLE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FONT_TYPE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_PROPORTIONAL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_FIXED),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_SCALABLE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_HUE),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_SATURATION),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_DARKNESS),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_PAPER_REQUEST),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_INSERT_MANUAL),
   CREATE_DEBUG_DEFINE_FROM (DIALOG_STRING_GAMMA),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_DLG_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_CLR_BASE),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_BLACK),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_BLUE),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_GREEN),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_CYAN),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_RED),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_PINK),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_YELLOW),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_WHITE),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_BROWN),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_GRAY),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_BLUE),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_RED),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_GREEN),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_CYAN),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_DARK_PINK),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_PALE_GRAY),
   CREATE_DEBUG_DEFINE_FROM (COLOR_STRING_MAGENTA),  //jk1115
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_CLR_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_COMPRESS_BASE),
   CREATE_DEBUG_DEFINE_FROM (COMPRESS_STRING_RLL),
   CREATE_DEBUG_DEFINE_FROM (COMPRESS_STRING_TIFF),
   CREATE_DEBUG_DEFINE_FROM (COMPRESS_STRING_DELTAROW),
   CREATE_DEBUG_DEFINE_FROM (COMPRESS_STRING_RLLDELTAROW),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_COMPRESS_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_HALFTONE_BASE),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_LEVEL),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_DITHER_4x4),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_DITHER_8x8),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_ERR_DIFFUSE),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_MAGIC_SQUARES),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_ORDERED_SQUARES),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_ADAPTIVE_DIFFUSE),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_FAST_DIFFUSE),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_STEINBERG_DIFFUSE),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_SMOOTH_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_HSV_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_HSV_BIDIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_CMYK_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (HALFTONE_STRING_VOID_CLUSTER_DIFFUSION),  //jk0998
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_HALFTONE_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_WARN_BASE),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_MSG_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_MSG_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_MSG_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_ADD_MSG_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_MSG_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_MSG_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_MSG_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_DELETE_MSG_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_SELECT_MSG_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_SELECT_MSG_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_SELECT_MSG_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_SELECT_MSG_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_MSG_FORM),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_MSG_FONT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_MSG_TRAY),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_MODIFY_MSG_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_FORM_IN_USE),
   CREATE_DEBUG_DEFINE_FROM (WARN_STRING_CHANGES_LOST),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_WARN_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_MSG_BASE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CTX_HELP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_ADD_SIZE_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_DEL_SIZE_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MOD_SIZE_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_ADD_TRAY_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_DEL_TRAY_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MOD_TRAY_BUTTON),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_NOTEBOOK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_OK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_CANCEL),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_HELP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_UNDO),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_JOB_DEFAULTS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_NOTEBOOK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_OK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_CANCEL),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_HELP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_DEV_DEFS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_UNDO),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_PRN_DEFAULTS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MONO_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MONO_DARKNESS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MONO_FG_CLR),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_MONO_BG_CLR),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_FORM),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_RESOLUTIONS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_PRINT_MODE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_CONDITIONAL),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_NONE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_COMPULSORY),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_ORIENTATION),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_PORTRAIT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_LANDSCAPE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_DUPLEX),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_ONE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_FLIP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_BOOK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMON_MIRROR),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COLOR_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_DITHER_ALGO),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_DITHER_LVL),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_GAMMA_RED),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_GAMMA_GREEN),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_GAMMA_BLUE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_GAMMA_BLACK),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_BIAS_RED),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_BIAS_GREEN),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CLR_BIAS_BLUE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_HSV_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_HSV_HUE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_HSV_SATURATION),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_HSV_DARKNESS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_TRAY),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_SIZE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_MEDIA),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_CONNECT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_ADD),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_CONNECT_REMOVE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_LIST),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_NAME),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_CMD),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_WIDTH),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_HEIGHT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_LEFT_CLIP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_RIGHT_CLIP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_TOP_CLIP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_BOT_CLIP),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_INCHES),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_CENTIMETERS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_CLASS),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_TYPE_TITLE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_FORM_TYPE_VALUE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_LIST),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_NAME),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_CMD),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_AUTOMATIC),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_TRAY_MANUAL),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_PAGE),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_CMD_INIT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_FILE_INIT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_CMD_TERM),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_FILE_TERM),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_CMD_FF),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_FILE_FF),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_CMD_ABORT),
   CREATE_DEBUG_DEFINE_FROM (MSG_STR_COMMAND_FILE_ABORT),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_MSG_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FUNC_BASE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ADDDEFINEDFORM),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ADDUSERDEFINEDFORMENTRY),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ADDUSERDEFINEDTRAYENTRY),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ATTRIBUTEBUNDLESLINE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ATTRIBUTEBUNDLESAREA),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ATTRIBUTEBUNDLESCHAR),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ATTRIBUTEBUNDLESIMAGE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ATTRIBUTEBUNDLESMARKER),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_BUILDAPPNAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CALCULATEFONTMETRICS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CHECKLOGICALADDRESS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CREATEUNIQUEFORMID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CREATEUNIQUETRAYID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEBUGOUTPUT),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DELETEUSERDEFINEDFORMENTRY),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DELETEUSERDEFINEDTRAYENTRY),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVICEQUERYFONTS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVICEQUERYFONTATTRIBUTES),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DRVINSTALL),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_BEGIN_CLOSE_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_COMPLETE_OPEN_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_DISABLE_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_DISABLE_PHYSICAL),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_ENABLE_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_FILL_LOGICAL),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_FILL_PHYSICAL),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_RESET_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_RESTORE_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ENABLE_SAVE_DC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLFONTLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLFORMLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLMEDIALIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLPRINTMODELIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLRESOLUTIONLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FILLTRAYLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FINDPRINTERNAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FORMIDFROMNAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FORMINFOFROMID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FORMINFOFROMNAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FORMNAMEFROMID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FREESTRINGTABLE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FREEUSERDEFINEDFORMLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_FREEUSERDEFINEDTRAYLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CREATENOTEBOOKPAGES),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_GETDEFAULTFONTINFO),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_GETDEFAULTFORMINFO),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_GETIDSFROMCONNID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_INITSTRINGTABLE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_ISFORMNAMEUNIQUE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_MEDIANAMEFROMID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_OMNICREATEHELPINSTANCE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_OMNIDESTROYHELPINSTANCE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_OS2_PM_DRV_DEVICENAMES),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_OS2_PM_DRV_DEVMODE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_PDRIVERFROMDEVICENAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_PDEVICEFROMDEVICENAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_QUERYDEVICEBITMAPS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_QUERYDEVICECAPS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_QUERYDEVRESOURCE2),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_QUERYHARDCOPYCAPS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_READUSERDEFINEDFORMLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_READUSERDEFINEDTRAYLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SAVEUSERDEFINEDFORMLIST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SETDRIVERDATADEFAULTS),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBINITJOB),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBRASTER),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBNEWPAGE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBTERMJOB),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBABORTJOB),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_SUBRASTERQUERY),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_TRAYNAMEFROMID),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_CHARSTRING),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_REALIZEFONT),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVICEPALETTE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_STARTDOC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_RAWDATA),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_ENDDOC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_NEWFRAME),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_ABORTDOC),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_QUERYHALFTONESUPPORT),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_QUERYPATTERN),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_QUERYESCSUPPORT),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_GETSCALINGFACTOR),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_QUERYVIOCELLSIZES),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_QUERYACTUALRESOLUTION),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_GETCP),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_NEXTBAND),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_DRAFTMODE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_FLUSHOUTPUT),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_CHAR_EXTRA),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_BREAK_EXTRA),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_SETMODE),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_DBE_FIRST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_DBE_LAST),
   CREATE_DEBUG_DEFINE_FROM (FUNC_STRING_DEVESC_STD_JOURNAL),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_FUNC_END),
   CREATE_DEBUG_DEFINE_FROM (STRING_TABLE_END)
};

INSTANTIATE (DebugPrintDefine, aStringTableDefines)

#else

VOID
DebugPrintDefine (ULONG ulDefine)
{
}

#endif

DEBUGDEFINES aResTableDefines[] = {
   CREATE_DEBUG_DEFINE_FROM (RES_ID_75),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_90),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_100),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_120),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_150),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_180),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_240),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_300),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_360),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_400),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_500),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_600),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_720),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_800),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_900),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_1000),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_1100),
   CREATE_DEBUG_DEFINE_FROM (RES_ID_1200)
};

DEBUGDEFINES aMediaTableDefines[] = {
   CREATE_DEBUG_DEFINE_FROM (MEDIA_ID_PLAIN),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_ID_1_SPECIAL),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_ID_2_SPECIAL),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_ID_GLOSSY),
   CREATE_DEBUG_DEFINE_FROM (MEDIA_ID_TRANS)
};

DEBUGDEFINES aDitherTableDefines[] = {
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_MATRIX),
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_HSV_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_CMYK_DIFFUSION),
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_VOID_CLUSTER),    //jk1115
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_NEW_DIFFUSION),   //jk1115
   CREATE_DEBUG_DEFINE_FROM (DITHER_ID_NEW_MATRIX)       //sx
};

DEBUGDEFINES aModeTableDefines[] = {
   CREATE_DEBUG_DEFINE_FROM (MODE_ID_BLK_COLOR),
   CREATE_DEBUG_DEFINE_FROM (MODE_ID_COLOR)
};

INSTANTIATE (DebugPrintResIDDefine,    aResTableDefines)
INSTANTIATE (DebugPrintMediaIDDefine,  aMediaTableDefines)
INSTANTIATE (DebugPrintDitherIDDefine, aDitherTableDefines)
INSTANTIATE (DebugPrintModeIDDefine,   aModeTableDefines)

#endif
