/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// DLLwork begin

// #define ADD_GRAY_BALANCE
#define INCL_DOS
#define INCL_DEV
#define INCL_PM
#define INCL_SPL
#define INCL_SPLFSE
#define INCL_ERRORS
#include <os2.h>

#define INCL_GENPLIB_THREAD_WRITE
#define INCL_GENPLIB_COMPRESS

#define BLACK_RESOLUTION_CUTOFF 1200
#define BLACK_DAMPEN_LEVEL       600

#define INCL_GRE_COLORTABLE
#define INCL_GRE_BITMAPS
#define INCL_DDIBUNDLES
#define INCL_GRE_FONTS
#define INCL_GRE_DEVMISC3
#define INCL_GRE_DEVSUPPORT
#define INCL_DDIMISC
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>


// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdarg.h>

#include "def.h"
#include "driver.h"
#include "funcs.h"

//@SCALBALEFONT - begin
#define MAXATTRBLKS 100                                                         
#define NUMINABLK   10                                                          
#define OnToOff( a, b)  (a & ( a ^ b))                                          
#define OffToOn( a, b)  (b & ( a ^ b))                                          
//@SCALABLEFONT - end

/************************************************************************/
/* PROCEDURE NAME : Power                                                */
/*                                                                       */
/*                  Control Flow:                                        */
/*                                                                       */
/* PARAMETERS:                                                           */
/*                                                                       */
/*                                                                       */
/* RETURN VALUES:                                                        */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                             */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*************************************************************************/
ULONG APIENTRY
Power (USHORT x, USHORT y)
{
   ULONG ulRet;

   if (2 == x)
   {
      ulRet = 1 << y;
   }
   else
   {
      ulRet = x;

      while ((USHORT)(--y))
      {
         ulRet *= x;
      }
   }

   return ulRet;

} /* end Power */


/****************************************************************************/
/* FUNCTION       : CompressRasterPlane()                                   */
/* AUTHOR         : mjones                                                  */
/* DATE WRITTEN   : 08/08/94                                                */
/* DESCRIPTION    : Calls compress routine and then GplThreadWriteBlock()   */
/*                                                                          */
/* PARAMETERS: pbBuffer = pointer to bytes to compress (Input)              */
/*             iPrinterBytesInArray = count of bytes to compress (Input)    */
/*             LastPlane = TRUE if last plane (Input)                       */
/*             pbLastLine = pointer to bytes in previous scanline (Input)   */
/*             pbCompress = pointer to contain compress output (Output)     */
/*             currentcompressmode = pointer to current compress mode in    */
/*                                   effect.                                */
/*             pvDDC = pointer to Drawing Device Context.                   */
/*             pDelta = pointer to array of pointers to difference          */
/*                      fragments.                                          */
/*                                                                          */
/* RETURN VALUES:                                                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
BOOL APIENTRY
CompressRasterPlane (PBYTE   pbBuffer,
                     INT     iPrinterBytesInArray,
                     BOOL    LastPlane,
                     PBYTE   pbLastLine,
                     PBYTE   pbCompress,
                     PINT    currentcompressmode,
                     ULONG   compressmodesupported,
                     PVOID   pvDDC,
                     PUSHORT pDelta)
{
   PDDC   pddc          = (PDDC)pvDDC;
   INT    compressmode,
          iCompressed;

   if (compressmodesupported != 0)
      compressmode = GplCompressChooseMode (pbBuffer,
                                            pbLastLine,
                                            iPrinterBytesInArray,
                                            compressmodesupported,
                                            pDelta);
   else
      compressmode = 0;

   if (*currentcompressmode != compressmode)
   {
      GplThreadWriteCommandWithPrintf (pddc->pdb->hThread,
                                       pddc->pdb->pDevice->pCmds->ulCmdSetCompression,
                                       pddc->pdb->pDevice->pCmds->pszCmdSetCompression,
                                       compressmode);

      *currentcompressmode = compressmode;
   }

   switch (compressmode)
   {
   case 0:           // no compression
   {
      iCompressed = iPrinterBytesInArray;
      memcpy (pbCompress, pbBuffer, iPrinterBytesInArray);
      if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
         memcpy (pbLastLine, pbBuffer, iPrinterBytesInArray);
      break;
   }

   case 1:           // mode 1 = RLL compression
   {
      iCompressed = GplCompressRLL (pbBuffer,
                                    iPrinterBytesInArray,
                                    pbCompress,
                                    2 * iPrinterBytesInArray);
      assertT (iCompressed == -1 );
      if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
         memcpy (pbLastLine, pbBuffer, iPrinterBytesInArray);
      break;
   }

   case 2:           // mode 2 = TIFF compression
   {
      iCompressed = GplCompressTIFF (pbBuffer,
                                     iPrinterBytesInArray,
                                     pbCompress,
                                     2 * iPrinterBytesInArray);
      assertT (iCompressed == -1 );
      if (compressmodesupported >= GPLCOMPRESS_DELTAROW)
         memcpy (pbLastLine, pbBuffer, iPrinterBytesInArray);
      break;
   }

   case 3:           // mode 3 = Delta Row compression
   {
      iCompressed = GplCompressDeltaRow (iPrinterBytesInArray,
                                         pbBuffer,
                                         pbLastLine,
                                         2 * iPrinterBytesInArray,
                                         pbCompress,
                                         pDelta);
      assertT(iCompressed == -1);
      if (iCompressed != 0)        // current and last line are different
         memcpy (pbLastLine, pbBuffer, iPrinterBytesInArray);
      break;
   }

   case 9:           // mode 9 = Enhanced Delta Row compression
   {
      iCompressed = GplCompressRLLDeltaRow (iPrinterBytesInArray,
                                            pbBuffer,
                                            pbLastLine,
                                            2 * iPrinterBytesInArray,
                                            pbCompress,
                                            pDelta);
      if (iCompressed != 0)     // current and last line are different
         memcpy (pbLastLine, pbBuffer, iPrinterBytesInArray);
      break;
   }

   default:
   {
      assertstring("Bad compression type");    // should never execute
      break;
   }
   }

   // Write raster data transfer header

   if (LastPlane)
      GplThreadWriteCommandWithPrintf (pddc->pdb->hThread,
                                       pddc->pdb->pDevice->pCmds->ulCmdTransferRasterBlock,
                                       pddc->pdb->pDevice->pCmds->pszCmdTransferRasterBlock,
                                       iCompressed);
   else
      GplThreadWriteCommandWithPrintf (pddc->pdb->hThread,
                                       pddc->pdb->pDevice->pCmds->ulCmdTransferRasterPlane,
                                       pddc->pdb->pDevice->pCmds->pszCmdTransferRasterPlane,
                                       iCompressed);

   // Send a scanline
   if (iCompressed != 0)
      GplThreadWriteBlock (pddc->pdb->hThread, pbCompress, iCompressed);

   return FALSE;

} /* end CompressRasterPlane */

static ULONG abDitherTable[][2] = {
   DITHER_ID_MATRIX,         HT_LEVEL,
//   DITHER_ID_MATRIX,         HT_DITHER_4x4,
//   DITHER_ID_MATRIX,         HT_DITHER_8x8,
   DITHER_ID_MATRIX,         HT_MAGIC_SQUARES,
   DITHER_ID_MATRIX,         HT_ORDERED_SQUARES,
   DITHER_ID_NEW_MATRIX,     HT_DITHER_4x4,
   DITHER_ID_NEW_MATRIX,     HT_DITHER_8x8,
   DITHER_ID_NEW_DIFFUSION,  HT_ERR_DIFFUSION,
   DITHER_ID_NEW_DIFFUSION,  HT_ERR_DIFFUSION6,
   DITHER_ID_NEW_DIFFUSION,  HT_ERR_DIFFUSION5,
   DITHER_ID_DIFFUSION,      HT_ADAPTIVE_DIFFUSION,
   DITHER_ID_DIFFUSION,      HT_FAST_DIFFUSION,
   DITHER_ID_NEW_DIFFUSION,  HT_STEINBERG_DIFFUSION,
   DITHER_ID_DIFFUSION,      HT_SMOOTH_DIFFUSION,
   DITHER_ID_HSV_DIFFUSION,  HT_HSV_DIFFUSION,
   DITHER_ID_HSV_DIFFUSION,  HT_HSV_BIDIFFUSION,
   DITHER_ID_CMYK_DIFFUSION, HT_CMYK_DIFFUSION,
   DITHER_ID_VOID_CLUSTER,   HT_VOID_CLUSTER,
   DITHER_ID_NEW_DIFFUSION,  HT_JANIS_STUCKI,
   0,                        0
};

ULONG ulMatchID (PULONG pTable, ULONG  ulid);

/*************************************************************************/
/* PROCEDURE NAME : FindGamma                                            */
/* AUTHOR         : Tom Spurrier                                         */
/* DATE WRITTEN   : 9/10/95                                              */
/* DESCRIPTION    :  See below                                           */
/*                                                                       */
/* Control Flow:    This utility searches 4 double entry user specific   */
/*                  ID tables, a global ID table, and with the specific  */
/*                  global ID's, it searches the user specific gamma     */
/*                  determination table and returns an index into the    */
/*                  users gamma table.  If no match is found then, zero  */
/*                  index is returned which should contain the user      */
/*                  defaults, normally 10 for all gammas and 0 for base. */
/*                                                                       */
/* PARAMETERS:                                                           */
/*                    PGAMMA_STRUCT pGammaTable - determination table    */
/*                    PULONG pFamilyTable       -                        */
/*                    ULONG  ulFamilyId         -                        */
/*                    PULONG pResTable          -                        */
/*                    ULONG  ulResId            -                        */
/*                    PULONG pMediaTable        -                        */
/*                    ULONG  ulMediaId          -                        */
/*                    PULONG pModeTable         -                        */
/*                    ULONG  ulModeId           -                        */
/*                    ULONG  ulDitherId         -                        */
/*                                                                       */
/* RETURN VALUES:  ULONG index into the user specific pGammaTable        */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                             */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*************************************************************************/
INT APIENTRY
FindGamma (PGAMMA_STRUCT pGammaTable,
           PULONG        pFamilyTable,
           ULONG         ulFamilyId,
           PULONG        pResTable,
           ULONG         ulResId,
           PULONG        pMediaTable,
           ULONG         ulMediaId,
           PULONG        pModeTable,
           ULONG         ulModeId,
           ULONG         ulDitherId)
{
   ULONG i = 1;

   ULONG ulGlobalFamilyId,
         ulGlobalResId,
         ulGlobalMediaId,
         ulGlobalModeId,
         ulGlobalDitherId;

   ulGlobalFamilyId  = ulMatchID (pFamilyTable,           ulFamilyId);
   ulGlobalResId     = ulMatchID (pResTable,              ulResId);
   ulGlobalMediaId   = ulMatchID (pMediaTable,            ulMediaId);
   ulGlobalModeId    = ulMatchID (pModeTable,             ulModeId);
   ulGlobalDitherId  = ulMatchID ((PULONG)&abDitherTable, ulDitherId);

#ifdef DEBUG
   DebugPrintResIDDefine    (ulGlobalResId);
   DebugPrintMediaIDDefine  (ulGlobalMediaId);
   DebugPrintModeIDDefine   (ulGlobalModeId);
   DebugPrintDitherIDDefine (ulGlobalDitherId);
#endif

   pGammaTable++;
   while (pGammaTable->ulRes != 0)
   {
      if (pGammaTable->ulFamily  == ulGlobalFamilyId &&
          pGammaTable->ulRes     == ulGlobalResId    &&
          pGammaTable->ulMedia   == ulGlobalMediaId  &&
          pGammaTable->ulMode    == ulGlobalModeId   &&
          pGammaTable->ulDither  == ulGlobalDitherId  )
      {
         return i;
      }

      i++;
      pGammaTable++;
   }

   return 0;
}

/*************************************************************************/
/* PROCEDURE NAME : ulMatchID                                            */
/* AUTHOR         : Tom Spurrier                                         */
/* DATE WRITTEN   : 9/10/95                                              */
/* DESCRIPTION    : See below                                            */
/*                                                                       */
/* Control Flow:    This is simply a utilty table scan for GplGammaFind  */
/*                  It is used to match a user specific ID of some kind  */
/*                  to the current ID and return a global ID number that */
/*                  can be used to match in the gammatable.              */
/*-----------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                             */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*************************************************************************/
ULONG
ulMatchID (PULONG pTable,
           ULONG  ulid)
{
   while (*pTable != 0)
   {
      if (*(pTable + 1) == ulid)
         return *pTable;

      pTable += 2;
   }

   return 0;
}

//@SCALABLEFONT - begin
//
// Design Strategy:
//
//    DEVFONTCTLBLOCK                           DEVFONTATTRIBUTES(0)
//   Ŀ                        Ŀ
//    Signiture       Control Block Sig  > fAttributes      
//   Ĵ                       Ĵ
//    pFirst          First Entry Pointer    ulFonttype       
//   Ĵ                       Ĵ
//    pNext           Next Pointer avail     ulSpacing        
//   Ĵ                       Ĵ
//    ulIndex         Current AttrBlk        .                
//   Ĵ index                 Ĵ
//    ulNumBlk        Number of alloc blk    .                
//   Ĵ                       Ĵ
//    AttrBlk[0]         .                
//   Ĵ                        
//    AttrBlk[1]     Ŀ                   DEVFONTATTRIBUTES(1)
//                          Ŀ
//     .                    > fAttributes      
//     .                                       Ĵ
//     .                                        ulFonttype       
//                                             Ĵ
//                                              ulSpacing        
//                                             Ĵ
//                                              .                
//                                             Ĵ
//                                              .                
//                                             Ĵ
//                                              .                
//                                             
//
/****************************************************************************/  
/* PROCEDURE NAME : AllocFontAttrsCB                                        */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/09/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES: NULL  ==> Failed to allocate control block                */  
/*                else  ==> Control block handle                            */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
PDEVFONTCTLBLOCK
AllocFontAttrsCB (PDDC pddc)
{
   PDEVFONTCTLBLOCK    pDevFntCB;
   PDEVFONTATTRIBUTES *ppAttrBlk;

   // Allocate DevFnt Control block first
   pDevFntCB = (PDEVFONTCTLBLOCK) GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                                  sizeof (DEVFONTCTLBLOCK));

   // Allocate array buffer to save pointers
   ppAttrBlk = (PDEVFONTATTRIBUTES*)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                                    MAXATTRBLKS
                                                    * sizeof (PDEVFONTATTRIBUTES));

   pDevFntCB->AttrBlk = ppAttrBlk;
   *ppAttrBlk = (PDEVFONTATTRIBUTES)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                                    NUMINABLK
                                                    * sizeof (DEVFONTATTRIBUTES));

   if (pDevFntCB && ppAttrBlk && *ppAttrBlk)
   {
      // Initialize first structure array by making up with null
      memset (pDevFntCB->AttrBlk[0], 0, NUMINABLK*sizeof(DEVFONTATTRIBUTES));
      pDevFntCB->ulIndex  = 0;
      pDevFntCB->ulNumBlk = 1;
      pDevFntCB->ulSig    = DEVFONTATTRSIG;
      pDevFntCB->pNext    = pDevFntCB->AttrBlk[0];
   }
   else
   {
      // Failed, free alloc'd memory!
      if (ppAttrBlk)
      {
         if (*ppAttrBlk)
         {
            GplMemoryFree (*ppAttrBlk);
            *ppAttrBlk = NULL;
         }

         GplMemoryFree (ppAttrBlk);
         ppAttrBlk = NULL;
      }

      if (pDevFntCB)
      {
         GplMemoryFree (pDevFntCB);
         pDevFntCB = NULL;
      }
   }

   return pDevFntCB;
}

/****************************************************************************/  
/* PROCEDURE NAME : ExpandFontAttrsCB                                       */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/09/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
BOOL
ExpandFontAttrs (PDDC pddc, PDEVFONTCTLBLOCK pDevFntCB)
{
   ULONG i;
   BOOL  rc = FALSE;

   if (  pDevFntCB
      && (pDevFntCB->ulSig == DEVFONTATTRSIG)
      && (pDevFntCB->ulNumBlk < MAXATTRBLKS)
      )
   {
      i = pDevFntCB->ulNumBlk++;
      pDevFntCB->AttrBlk[i] = (PDEVFONTATTRIBUTES)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                                                  NUMINABLK
                                                                  * sizeof (DEVFONTATTRIBUTES));

      if (pDevFntCB->AttrBlk[i])
      {
         // Clear alloc'd DEVFONTATTRIBUTES buffer with null char
         memset (pDevFntCB->AttrBlk[i], 0, NUMINABLK*sizeof(DEVFONTATTRIBUTES));

         // Setup pNext to the first pointer to the allocated array
         pDevFntCB->pNext = pDevFntCB->AttrBlk[i];
         pDevFntCB->ulIndex  = 0;

         // Set return code to indicate success.
         rc = TRUE;
      }
      else
      {
         // Couldn't allocated memery...
         pDevFntCB->pNext = NULL;
      }
   }
   return rc;
}
/****************************************************************************/  
/* PROCEDURE NAME : FreeFontAttrsCB                                         */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/09/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
BOOL
FreeFontAttrsCB (PDEVFONTCTLBLOCK pDevFntCB)
{
   ULONG i;
   BOOL  rc = FALSE;

   if (pDevFntCB)
   {
      // Control bloack is allocated.....
      for (i = pDevFntCB->ulNumBlk; i > 0; i--)
      {
         GplMemoryFree (pDevFntCB->AttrBlk[i-1]);
      }

      GplMemoryFree (pDevFntCB->AttrBlk);
      GplMemoryFree (pDevFntCB);

      pDevFntCB = NULL;
      rc = TRUE;
   }
   return rc;
}
/****************************************************************************/  
/* PROCEDURE NAME : FindSameFontAttrs                                       */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/09/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
PDEVFONTATTRIBUTES
FindSameFontAttrs (PDEVFONTCTLBLOCK pDevFontCB, PDEVFONTATTRIBUTES pAttrs)
{
   ULONG              i,
                      j;
   PDEVFONTATTRIBUTES pDevFontAttrs;
   PDEVFONTATTRIBUTES rc = NULL;


   if (pDevFontCB)
   {
      for (j = 0; j < pDevFontCB->ulNumBlk; j++)
      {
         pDevFontAttrs = pDevFontCB->AttrBlk[j];

         for (i=0; i<NUMINABLK; i++)
         {
            if (  (pAttrs->fAttributes == pDevFontAttrs->fAttributes)
               && !memcmp (pAttrs, pDevFontAttrs, sizeof (DEVFONTATTRIBUTES))
               )
            {
               rc = pDevFontAttrs;
            }
            else
            {
               pDevFontAttrs++;
            }
         }
      }
   }
   return rc;
}

/****************************************************************************/  
/* PROCEDURE NAME : InsertFontAttrs                                         */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/09/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
PDEVFONTATTRIBUTES
InsertFontAttrs (PDDC pddc, PDEVFONTCTLBLOCK pDevFntCB, PDEVFONTATTRIBUTES pAttrs)
{
   PDEVFONTATTRIBUTES pNext;
   PDEVFONTATTRIBUTES rc = NULL;

   // Check if it is our control block
   if (pDevFntCB && (pDevFntCB->ulSig == DEVFONTATTRSIG))
   {
      // Try to find if same attribute attr already exist.
      pNext = FindSameFontAttrs (pDevFntCB, pAttrs);
      if (pNext)
      {
         // Return address of found attr
         rc = pNext;
      }
      else
      {
         pNext = pDevFntCB->pNext;
         // We can only do mem operation when it's alloc'd
         if (pNext)
         {
            // Setup return code to return to caller with
            // pNext that makes up with current attributes
            rc = pNext;

            // Copy attributes passed from caller to CB area.
            memcpy (pNext, pAttrs, sizeof (DEVFONTATTRIBUTES));

            // Check if we need to allocate more NUMINBLK block
            // for next operation.
            if (++pDevFntCB->ulIndex > (NUMINABLK-1))
            {
               // Allocate next frame for next time insert operation
               ExpandFontAttrs (pddc, pDevFntCB);
               //if (ExpandFontAttrs (pddc, pDevFntCB) == FALSE)
               //{
               //   // Nothing to do even if it fails...
               //   // ExpandFontAttrs will return an null pNext
               //   // so that next insert would not cause access violation.
               //}
            }
            else
            {
               // Increment to point to next pointer
               pDevFntCB->pNext++;
            }
         }
      }
   }
   return rc;
}
/****************************************************************************/  
/* PROCEDURE NAME : DevFntSetFontAttrs                                      */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/15/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/* @3729   - 09/22/98 - UCC [IBMJ]  Add fullwidth to solve charpitch        */
/*                                  deference problem.                      */
/*                                                                          */  
/****************************************************************************/  
VOID
DevFntSetFontAttrs (PDDC               pddc,
                    PSTRINOUT          pStrInOut,
                    PDEVFONTATTRIBUTES pDevFntAttrs,
                    PDEVFONTATTRCMDS   pCmd,
                    ULONG              ulOption)
{
   CHAR  szTemp[32];
   PSZ   pszCmd      = szTemp;
   PSZ   pszSrc;
   ULONG ulCmd;
   ULONG fAttributes = pDevFntAttrs->fAttributes;
   ULONG ulAttrs     = 0x00000001;
   ULONG ulValue     = 0;

   do
   {
      // End the loop if fAttributes's bits all turned to be 0
      if (!fAttributes)
      {
         return;
      }

      // Set pszSrc to NULL to prevent sending
      // invalid data out
      pszSrc = NULL;
      ulCmd  = 0;

      switch (ulAttrs & fAttributes)
      {
      case FAF_FONTTYPE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnFonttype)
         {
            pCmd->pfnFonttype (pddc, pDevFntAttrs->ulFonttype);
         }
         else if (pStrInOut && pCmd->pszFonttypeCmd)
         {
            ulCmd   = pCmd->ulFonttypeCmd;

            SetDevFntInfo (pddc, pStrInOut, pDevFntAttrs->ulFonttype);
         }
         else if ( pCmd->pszFonttypeCmd)
         {
            ulCmd   = pCmd->ulFonttypeCmd;
            pszSrc  = pCmd->pszFonttypeCmd;
            ulValue = pDevFntAttrs->ulFonttype;
         }

         fAttributes &= ~FAF_FONTTYPE;
         break;
      }

      case FAF_SPACING:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnSpacing)
         {
            pCmd->pfnSpacing (pddc, pDevFntAttrs->ulSpacing);
         }
         else if (pCmd->pszSpacingCmd)
         {
            ulCmd   = pCmd->ulSpacingCmd;
            pszSrc  = pCmd->pszSpacingCmd;
            ulValue = pDevFntAttrs->ulSpacing;
         }

         fAttributes &= ~FAF_SPACING;
         break;
      }

      case FAF_WIDTH:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnWidth)
         {
            
            pCmd->pfnWidth (pddc,
                            pStrInOut,
                            pDevFntAttrs->ulHalfWidth,
                            pDevFntAttrs->ulFullWidth);
         }
         else if (pCmd->pszWidthCmd)
         {
            ulCmd   = pCmd->ulWidthCmd;
            pszSrc  = pCmd->pszWidthCmd;
            
            ulValue = pDevFntAttrs->ulHalfWidth;
         }

         fAttributes &= ~FAF_WIDTH;
         break;
      }

      case FAF_HEIGHT:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnHeight)
         {
            pCmd->pfnHeight (pddc, pStrInOut, pDevFntAttrs->ulHeight);
         }
         else if (pCmd->pszHeightCmd)
         {
            ulCmd   = pCmd->ulHeightCmd;
            pszSrc  = pCmd->pszHeightCmd;
            ulValue = pDevFntAttrs->ulHeight;
         }

         fAttributes &= ~FAF_HEIGHT;
         break;
      }

      case FAF_STYLE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnStyle)
         {
            pCmd->pfnStyle (pddc, ulOption);
         }
         else if (pCmd->pszStyleCmd)
         {
            ulCmd  = pCmd->ulStyleCmd;
            pszSrc = pCmd->pszStyleCmd;

            if (ulOption == DFSFO_ENABLE)
            {
               ulValue = pCmd->ulStyleEnable;
            }
            else
            {
               ulValue = pCmd->ulStyleDisable;
            }
         }

         fAttributes &= ~FAF_STYLE;
         break;
      }

      case FAF_WEIGHT:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnWeight)
         {
            pCmd->pfnWeight (pddc, ulOption);
         }
         else if (pCmd->pszWeightCmd)
         {
            ulCmd  = pCmd->ulWeightCmd;
            pszSrc = pCmd->pszWeightCmd;

            if (ulOption == DFSFO_ENABLE)
            {
               ulValue = pCmd->ulWeightEnable;
            }
            else
            {
               ulValue = pCmd->ulWeightDisable;
            }
         }

         fAttributes &= ~FAF_WEIGHT;
         break;
      }

      case FAF_ANGLE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnAngle)
         {
            pCmd->pfnAngle (pddc, pDevFntAttrs->ptlAngle);
         }
         else if (pCmd->pszAngleCmd)
         {
            ulCmd  = pCmd->ulAngleCmd;
            pszSrc = pCmd->pszAngleCmd;
            //ulValue = pDevFntAttrs->ptlAngle.x;
         }

         fAttributes &= ~FAF_ANGLE;
         break;
      }

      case FAF_SHEAL:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnSheal)
         {
            pCmd->pfnSheal (pddc, pDevFntAttrs->ptlSheal);
         }
         else if (pCmd->pszShealCmd)
         {
            ulCmd  = pCmd->ulShealCmd;
            pszSrc = pCmd->pszShealCmd;
            //ulValue = pDevFntAttrs->ptlSheal.x;
         }

         fAttributes &= ~FAF_SHEAL;
         break;
      }

      case FAF_DIRECTION:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnDirection)
         {
            pCmd->pfnDirection (pddc, pDevFntAttrs->ulDirection);
         }
         else if (pCmd->pszDirectionCmd)
         {
            ulCmd   = pCmd->ulDirectionCmd;
            pszSrc  = pCmd->pszDirectionCmd;
            ulValue = pDevFntAttrs->ulDirection;
         }

         fAttributes &= ~FAF_DIRECTION;
         break;
      }

      case FAF_FGCOLOR:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnFGColor)
         {
            pCmd->pfnFGColor (pddc, pDevFntAttrs->ulFGColor);
         }
         else if (pCmd->pszFGColorCmd)
         {
            ulCmd   = pCmd->ulFGColorCmd;
            pszSrc  = pCmd->pszFGColorCmd;
            ulValue = pDevFntAttrs->ulFGColor;
         }

         fAttributes &= ~FAF_FGCOLOR;
         break;
      }

      case FAF_BGCOLOR:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnBGColor)
         {
            pCmd->pfnBGColor (pddc, pDevFntAttrs->ulBGColor);
         }
         else if (pCmd->pszBGColorCmd)
         {
            ulCmd   = pCmd->ulBGColorCmd;
            pszSrc  = pCmd->pszBGColorCmd;
            ulValue = pDevFntAttrs->ulBGColor;
         }

         fAttributes &= ~FAF_BGCOLOR;
         break;
      }

      case FAF_MIXMODE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnMixMode)
         {
            pCmd->pfnMixMode (pddc, pDevFntAttrs->ulMixMode);
         }
         else if (pCmd->pszMixModeCmd)
         {
            ulCmd   = pCmd->ulMixModeCmd;
            pszSrc  = pCmd->pszMixModeCmd;
            ulValue = pDevFntAttrs->ulMixMode;
         }

         fAttributes &= ~FAF_MIXMODE;
         break;
      }

      case FAF_BACKMIXMODE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnBackMixMode)
         {
            pCmd->pfnBackMixMode (pddc, pDevFntAttrs->ulBackMixMode);
         }
         else if (pCmd->pszBackMixModeCmd)
         {
            ulCmd   = pCmd->ulBackMixModeCmd;
            pszSrc  = pCmd->pszBackMixModeCmd;
            ulValue = pDevFntAttrs->ulBackMixMode;
         }

         fAttributes &= ~FAF_BACKMIXMODE;
         break;
      }

      case FAF_UNDERSCORE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnUnderscore)
         {
            pCmd->pfnUnderscore (pddc, ulOption);
         }
         else if (pCmd->pszUnderscoreCmd)
         {
            ulCmd   = pCmd->ulUnderscoreCmd;
            pszSrc  = pCmd->pszUnderscoreCmd;

            if (ulOption == DFSFO_ENABLE)
            {
               ulValue = pCmd->ulUnderscoreEnable;
            }
            else
            {
               ulValue = pCmd->ulUnderscoreDisable;
            }
         }

         fAttributes &= ~FAF_UNDERSCORE;
         break;
      }

      case FAF_STRIKEOUT:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnStrikeout)
         {
            pCmd->pfnStrikeout (pddc, ulOption);
         }
         else if (pCmd->pszStrikeoutCmd)
         {
            ulCmd   = pCmd->ulStrikeoutCmd;
            pszSrc  = pCmd->pszStrikeoutCmd;

            if (ulOption == DFSFO_ENABLE)
            {
               ulValue = pCmd->ulStrikeoutEnable;
            }
            else
            {
               ulValue = pCmd->ulStrikeoutDisable;
            }
         }

         fAttributes &= ~FAF_STRIKEOUT;
         break;
      }

      case FAF_OUTLINE:
      {
         // If plug-in want to do himself let him do.
         // Else check if we can do it for him.
         if (pCmd->pfnOutline)
         {
            pCmd->pfnOutline (pddc, ulOption);
         }
         else if (pCmd->pszOutlineCmd)
         {
            ulCmd   = pCmd->ulOutlineCmd;
            pszSrc  = pCmd->pszOutlineCmd;

            if (ulOption == DFSFO_ENABLE)
            {
               ulValue = pCmd->ulOutlineEnable;
            }
            else
            {
               ulValue = pCmd->ulOutlineDisable;
            }
         }

         fAttributes &= ~FAF_OUTLINE;
         break;
      }
      }

      if (pszSrc)
      {
         ULONG ulLength = sprintf (pszCmd, pszSrc, ulValue);

         if (!ulCmd)
         {
            ulCmd = ulLength;
         }

         GplThreadWriteBlock (pddc->pdb->hThread, pszCmd, ulCmd);
      }
   } while ((ulAttrs <<= 1) < FAF_LAST);

   return;
}

/****************************************************************************/  
/* PROCEDURE NAME : DevFntSetFontAttrs                                      */  
/* AUTHOR         : Yu-Chih,Shih                                            */  
/* DATE WRITTEN   : 10/16/97                                                */  
/* DESCRIPTION    :                                                         */  
/*                                                                          */  
/*                                                                          */  
/* PARAMETERS:                                                              */  
/*                                                                          */  
/* RETURN VALUES:                                                           */  
/*                                                                          */  
/*--------------------------------------------------------------------------*/  
/* CHANGE/MODIFICATION LOG :                                                */  
/*--------------------------------------------------------------------------*/  
/*                                                                          */  
/****************************************************************************/  
VOID
DevFntUpdateAttrs (PDDC               pddc,
                   PSTRINOUT          pStrInOut,
                   PDEVFONTATTRCMDS   pCmd,
                   PDEVFONTATTRIBUTES pCurrAttrs,
                   PDEVFONTATTRIBUTES pNextAttrs)
{
   ULONG ulCurrAttrs;
   ULONG ulNextAttrs = pNextAttrs->fAttributes;

   if (pCurrAttrs)
   {
      ulCurrAttrs = pCurrAttrs->fAttributes & FAF_ONOFF;
   }
   else
   {
      ulCurrAttrs = 0;
   }

   // ON --> OFF first
   if (ulCurrAttrs)
   {
      pNextAttrs->fAttributes = OnToOff (ulCurrAttrs, ulNextAttrs) & FAF_ONOFF;

      if (pNextAttrs->fAttributes)
      {
         DevFntSetFontAttrs (pddc, pStrInOut, pNextAttrs, pCmd, DFSFO_DISABLE);
      }

      // Try to turn off flags not necessary here.

      // OFF --> ON then
      pNextAttrs->fAttributes = OffToOn (ulCurrAttrs, ulNextAttrs);

      if (pNextAttrs->fAttributes)
      {
         if (pNextAttrs->ulFonttype == pCurrAttrs->ulFonttype)
         {
            pNextAttrs->fAttributes &= ~FAF_FONTTYPE;
         }

         if (pNextAttrs->ulHeight == pCurrAttrs->ulHeight)
         {
            pNextAttrs->fAttributes &= ~FAF_HEIGHT;
         }

         
         if (pNextAttrs->ulHalfWidth == pCurrAttrs->ulHalfWidth)
         {
            pNextAttrs->fAttributes &= ~FAF_WIDTH;
         }

         DevFntSetFontAttrs (pddc, pStrInOut, pNextAttrs, pCmd, DFSFO_ENABLE);
      }
   }
   else if (ulNextAttrs)
   {
      DevFntSetFontAttrs (pddc, pStrInOut, pNextAttrs, pCmd, DFSFO_ENABLE);
   }
// else
// {
//     Nothing to do with this case
// }

   // Restore flags
   pNextAttrs->fAttributes = ulNextAttrs;
}
//@SCALABLEFONT - end

/****************************************************************************/
/* PROCEDURE NAME : GetFontinfo                                             */
/* AUTHOR         : Yu-Chih,Shih                                            */
/* DATE WRITTEN   : 06/09/1998                                              */
/* DESCRIPTION    : Search and return fontinfo associated with lmatch.      */
/*                                                                          */
/* PARAMETERS:      pDriver: Currect pDriver associated with pFont          */
/*                  lMatch : pFont's lmatch to look up                      */
/* RETURN VALUES:   None                                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
PFONTINFO2
GetFontinfo (PDRIVERINFO pDriver, LONG lMatch)
{
   ULONG      i;
   PFONTINFO2 pFont;
   ULONG      ulMaxFonts = pDriver->ulNumFonts;

   for (i = 0; i < ulMaxFonts; i++)
   {
      pFont = &pDriver->pFONTS[i];

      if (lMatch == pFont->lDevMatch)
      {
         return pFont;
      }
   }

   return NULL;
}

/****************************************************************************/
/* PROCEDURE NAME : GetFocafont                                             */
/* AUTHOR         : Yu-Chih,Shih                                            */
/* DATE WRITTEN   : 06/09/1998                                              */
/* DESCRIPTION    : Search and return pFocafont associated with lMatch      */
/*                                                                          */
/* PARAMETERS:      pdb   : Device pDeviceBlock for looking up              */
/*                  lMatch: lMatch value                                    */
/* RETURN VALUES:   None                                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
#if 1  //UCCTmp
PFOCAFONT
GetFocafont (PDEVICEBLOCK pdb, LONG lMatch)
{
   ULONG      i;
   PFONTINFO2 pFont;
   ULONG      ulMaxFonts = pdb->pDriver->ulNumFonts;

   for (i = 0; i < ulMaxFonts; i++)
   {
      pFont = &pdb->pDriver->pFONTS[i];

      if (lMatch == pFont->lDevMatch)
      {
         return pFont->vpGlobalFocaFont;
      }
   }

   return NULL;
}
#else
PFOCAFONT
GetFocafont (PDEVICEBLOCK pdb, LONG lMatch)
{
   ULONG           ulMaxFonts = pdb->ulNumDevFonts;
   PDEVFONTMETRICS pdfm       = pdb->pdfm;
   ULONG           i;

   for (i = 0; i < ulMaxFonts; i++)
   {
      if (lMatch == pdfm[i].lDevMatch)
      {
         return (PFOCAFONT)pdfm[i].pFoca;
      }
   }

   return NULL;
}
#endif

/****************************************************************************/
/* PROCEDURE NAME : SetDevFntInfo                                           */
/* AUTHOR         : Yu-Chih,Shih                                            */
/* DATE WRITTEN   : 3/14/96                                                 */
/* DESCRIPTION    : Send font select command and CPI commands & initilize   */
/*                  informations relate to font information                 */
/*                  This is only be called when hStrInOut handle is allocted*/
/*                                                                          */
/*                  Control Flow:                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None                                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* 06/09/98 UCC [IBMJ] Rewrote to prevent trap in notes printing            */
/****************************************************************************/
VOID
SetDevFntInfo (PDDC pddc, PSTRINOUT pStrInOut, LONG lMatch)
{
   PFOCAFONT  pFoca;
   PFONTINFO2 pFont = GetFontinfo (pddc->pdb->pDriver, lMatch);

   // Check pointer validation
   if (pStrInOut && pFont)
   {
      GplThreadWriteBlock (pddc->pdb->hThread,
                           pFont->szCmdSelectFont,
                           pFont->ulCmdLen);

      // @TBD - shouldnt these be memcpys? for binary data
      pStrInOut->ulModeInLen            = pFont->ulCmdModeInLen;
      assertT (pStrInOut->ulModeInLen > sizeof (pStrInOut->abModeIn) - 1);
      SafeStrNCpy (pStrInOut->abModeIn,
                   pFont->szCmdModeIn,
                   sizeof (pStrInOut->abModeIn));

      pStrInOut->ulModeOutLen           = pFont->ulCmdModeOutLen;
      assertT (pStrInOut->ulModeOutLen > sizeof (pStrInOut->abModeOut) - 1);
      SafeStrNCpy (pStrInOut->abModeOut,
                   pFont->szCmdModeOut,
                   sizeof (pStrInOut->abModeOut));

      pStrInOut->ulOutCharSet          = pFont->ulFontCharSet;
      pStrInOut->ulOutCharSetExtension = pFont->ulFontCharSetExtension;
      pStrInOut->ulOutCharEncoding     = pFont->ulFontCharEncoding;

      pFoca = GetFocafont (pddc->pdb, lMatch);

      if (  pFoca
         && (pStrInOut->ulCodePage != (ULONG) pFoca->fmMetrics.usCodePage)
         )
      {
         pStrInOut->ulCodePage = (ULONG)pFoca->fmMetrics.usCodePage;
         GplDBCSGetDBCSRange (pddc->pdb->ctryInfo.country,
                              pStrInOut->ulCodePage,
                              sizeof (pStrInOut->abDBCSEnv),
                              pStrInOut->abDBCSEnv,
                              sizeof (pStrInOut->abUSEREnv),
                              pStrInOut->abUSEREnv);
      }
   }

} /* end SetDevFntInfo */

/****************************************************************************/
/* PROCEDURE NAME : DevfntTextBlt                                           */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 9/21/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/*    typedef struct _TEXTBLTINFO {              // textbltinfo             */
/*            ULONG               ulLength;                                 */
/*            ULONG               flOptions;                                */
/*            ULONG               lGlyphCnt;                                */
/*            PLONG               pGlyphIndicies;                           */
/*            ULONG               ulFGMix;                                  */
/*            ULONG               ulBGMix;                                  */
/*            ULONG               ulFGColor;                                */
/*            ULONG               ulBGColor;                                */
/*            PBMAPINFO           pDstBmapInfo;                             */
/*            PDEVFONTINFO        pDevFntInfo;                              */
/*            ULONG               ulClpCnt;                                 */
/*            PRECTL              abrClipRects;                             */
/*            PPOINTL             aptlSrcOrg;                               */
/*            PBLTRECT            abrDst;                                   */
/*    } TEXTBLTINFO;                                                        */
/*    typedef TEXTBLTINFO *PTEXTBLTINFO;                                    */
/*                                                                          */
/*                                                                          */
/*    typedef struct _BLTRECT {         // bltrect                          */
/*       ULONG  ulXOrg;                                                     */
/*       ULONG  ulYOrg;                                                     */
/*       ULONG  ulXExt;                                                     */
/*       ULONG  ulYExt;                                                     */
/*    } BLTRECT;                                                            */
/*    typedef BLTRECT  *PBLTRECT;                                           */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @3632   - 04/08/98 - UCC [IBMJ]- Add 2 flag for DevFnt sup use.          */
/*                                  fRecoding is for HiRes devfnt print prob*/
/* @3677   - 06/24/98 - UCC [IBMJ]  Change to send printer landscape code.  */
/*                                  And correct to be able to handle vector.*/
/*                                                                          */
/****************************************************************************/
LONG APIENTRY
DevfntTextBlt (PDDC         pddc,
               PTEXTBLTINFO ptbi,
               PHSORTER     phSort,
               PBYTE        pbStringBuf,
               PSZ          pszGlyphs)
{
   PULONG pulChar;
   LONG   lNumChars = ptbi->lGlyphCnt;
   ULONG  i            = 0,
          j            = 0,
          fOneByOne    = 0,
          ulIndex,
          ulCharWidth;
   RECTL  rclTextBox;
   APIRET Rc;
#if JPNBLD
   ULONG  ulSystemCharSet;

   GplNLSQuerySystemCharSetID (pddc->pdb->ctryCode.country, // @MATTR
                               &ulSystemCharSet);
#endif //JPNBLD

   if( pddc->pdb->fRecording == FALSE)                                          
   {                                                                            
      return RC_SUCCESS;                                                        
   }                                                                            

   /**************************************************/
   /* Maybe we can move SorterCreateInstance and     */
   /* SorterDeleteInstance to EpsonDeviceQuery()     */
   /**************************************************/
   // Create string sorter if not already found
   if (!*phSort)
   {
      Rc = GplStringSorterCreateInstance ((HDC)pddc,
                                          phSort,
                                          0L,
                                          0L);

      if (NO_ERROR != Rc)
         return RC_ERROR;
   }

   /***************************************************/
   /* For performance reason, we check number of bytes*/
   /* we need for making up a string here and select  */
   /* static buffer or dynamic buffer for handling    */
   /* string.                                         */
   /***************************************************/
   if ((ptbi->lGlyphCnt * 2 + 1) > LOCALBUFSIZE)
   {
      pszGlyphs = (PSZ)GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                       (ptbi->lGlyphCnt * 2 + 1));
      assertF (pszGlyphs);
      if (!pszGlyphs)
         return RC_ERROR;
   }

   /***************************************************/
   /* For safty reason, we make our string pointer to */
   /* the pointer already allocated. But remember its */
   /* size is LOCALBUFSIZE only. We have to trick some*/
   /* here.                                           */
   /***************************************************/
   if (!pszGlyphs)
   {
      pszGlyphs = pbStringBuf;

      if (ptbi->lGlyphCnt > LOCALBUFSIZE-1)
          ptbi->lGlyphCnt = LOCALBUFSIZE-1;
   }

#ifdef DEBUG
   if (ptbi->pDevFntInfo->fFontInfo & DFI_FIXED_FONT)
       DBPRINTF (("DevFntTextBlt(): Fixed Width Font\n"));

   if (ptbi->pDevFntInfo->fFontInfo & DFI_DBCS_FONT)
       DBPRINTF (("DevFntTextBlt(): DBCS Font\n"));
#endif

   pulChar = (PULONG)ptbi->pGlyphIndices;

   if( lNumChars > 1)
   {
      ULONG ulWidth;

      ulCharWidth = ptbi->abrDst[1].ulXOrg - ptbi->abrDst[0].ulXOrg;

      if( *pulChar < 0x0400)
      {
         // To prevent rounding error,
         // convert to DBCS width here for late calc
         ulCharWidth *= 2;
      }

      for( i=2; i<lNumChars; i++)
      {
         ulWidth = ptbi->abrDst[i].ulXOrg - ptbi->abrDst[i-1].ulXOrg;

         if( *(pulChar + i - 1) < 0x0400)
         {
            // To prevent rounding error,
            // convert to DBCS width here for late calc
            ulWidth *= 2;
         }

         if( ulWidth != ulCharWidth)
         {
            fOneByOne  = 1;
            break;
         }
      }
   }

   // X
   rclTextBox.xLeft   = ptbi->abrDst->ulXOrg;
   rclTextBox.xRight  = rclTextBox.xLeft + ptbi->abrDst->ulXExt;

   // Y Pos will never change in the string passed from GRE
   rclTextBox.yBottom = ptbi->abrDst->ulYOrg;
   rclTextBox.yTop    = rclTextBox.yBottom + ptbi->abrDst->ulYExt;

   for ( i = 0; i < lNumChars; i++ )
   {
      ulIndex = pulChar[i];

      /* Specification ***************************/
      /* GlyphIndex indicates it's SBCS when it's*/
      /* below 0x400.                            */
      /*******************************************/
      if ( ulIndex < 0x400 )
      {
         if(fOneByOne)
            *(pszGlyphs+j)   = (CHAR)ulIndex;
         else
            *(pszGlyphs+i+j) = (CHAR)ulIndex;
      }
      else
      {
#if JPNBLD
         LONG  lFontID  = (LONG)ptbi->pDevFntInfo->ulUniqueFntID;
         FONTINFO2 pFont= pddc->pdb->pDriver->pFONTS[-(lFontID+1)];

         // Convert JIS code point before making a string here
         // if it's shift-JIS shift-JIS conversion.
         // This code is added for those case not need
         // DBCSconvert case.
         if (pFont.ulFontCharEncoding == CHAR_ENCODING_SHIFT_JIS)
         {
            if ( (ulSystemCharSet     != pFont.ulFontCharSet)
              && ((ulSystemCharSet    == CHAR_SET_JIS_C_6226_1978)
              || (pFont.ulFontCharSet == CHAR_SET_JIS_C_6226_1978)))
            {
               ulIndex = GplDBCSJpnJisSwap( ulIndex);
            }
         }
#endif //JPNBLD
         DBPRINTF (("DevFntTextBlt: DBCS has passed in!\n"));

         if( fOneByOne)
         {
            *(pszGlyphs+j++) = (CHAR) (ulIndex >> 8);
            *(pszGlyphs+j)   = (CHAR)  ulIndex;
         }
         else
         {
            *(pszGlyphs+i+j++) = (CHAR) (ulIndex >> 8);
            *(pszGlyphs+i+j)   = (CHAR)  ulIndex;
         }
      }

      if( fOneByOne)
      {
         *(pszGlyphs + ++j) = 0;
         rclTextBox.xLeft   = ptbi->abrDst[i].ulXOrg;
         rclTextBox.xRight  = rclTextBox.xLeft + ptbi->abrDst[i].ulXExt;

         /*******************************************************/
         /* We insert textblted string here with text box and   */
         /* font information.                                   */
         /*******************************************************/
         Rc = GplStringSorterInsertString (*phSort,
                                           pszGlyphs,
                                           strlen (pszGlyphs) + 1,
                                           rclTextBox,
                                           (PVOID)ptbi->pDevFntInfo->ulUniqueFntID,
                                           NULL );
         j = 0;
      }
   }

   if( !fOneByOne)
   {
      *(pszGlyphs + i + j) = 0;

      /*******************************************************/
      /* We insert textblted string here with text box and   */
      /* font information.                                   */
      /*******************************************************/
      Rc = GplStringSorterInsertString (*phSort,
                                        pszGlyphs,
                                        strlen (pszGlyphs) + 1,
                                        rclTextBox,
                                        (PVOID)ptbi->pDevFntInfo->ulUniqueFntID,
                                        NULL );
   }

   if (pszGlyphs && (pszGlyphs != pbStringBuf ))
   {
      GplMemoryFree (pszGlyphs);
   }

   return Rc;
}

//@SCALABLEFONT - begin
/****************************************************************************/
/* PROCEDURE NAME : DevfntTextBlt2                                          */
/* AUTHOR         : Matt Rutkowski                                          */
/* DATE WRITTEN   : 9/21/95                                                 */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/* @3632   - 04/08/98 - UCC [IBMJ]- Add 2 flag for DevFnt sup use.          */
/*                                  fRecoding is for HiRes devfnt print prob*/
/* @3677   - 06/24/98 - UCC [IBMJ]  Change to send printer landscape code.  */
/*                                  And correct to be able to handle vector.*/
/* @3687   - 06/29/98 - UCC [IBMJ]  Remove optimized code to handle fixed   */
/*                                  pitch string.                           */
/* @3729   - 09/22/98 - UCC [IBMJ]  Add fullwidth to solve charpitch        */
/*                                  deference problem.                      */
/*                                                                          */
/****************************************************************************/
LONG APIENTRY
DevfntTextBlt2 (PDDC                pddc,
                PTEXTBLTINFO        ptbi,
                PHSORTER            phSort,
                PBYTE               pbStringBuf,
                PDEVFONTCTLBLOCK    pDevFntCB,
                PSZ                 pszGlyphs)
{
   PULONG pulChar;
   LONG   lNumChars = ptbi->lGlyphCnt;
   ULONG  i            = 0,
          j            = 0,
          fOneByOne    = 0,
          ulIndex,
          ulLeftMost,
          ulRightMost,
          ulCharWidth,
          ulHalfWidth,
//        ulSpacing,
          ulNumHalfChars;
   RECTL  rclTextBox;
   APIRET Rc;
   DEVFONTATTRIBUTES  DevFntAttrs;
   PDEVFONTATTRIBUTES pDevFntAttrs;
#if JPNBLD
   ULONG  ulSystemCharSet;

   GplNLSQuerySystemCharSetID (pddc->pdb->ctryCode.country,
                               &ulSystemCharSet);
#endif //JPNBLD

   if (pddc->pdb->fRecording == FALSE)                                           
   {                                                                             
      return RC_SUCCESS;                                                        
   }                                                                             

   /**************************************************/
   /* Maybe we can move SorterCreateInstance and     */
   /* SorterDeleteInstance to EpsonDeviceQuery()     */
   /**************************************************/
   // Create string sorter if not already found
   if (!*phSort )
   {
      Rc = GplStringSorterCreateInstance ((HDC)pddc, phSort, 0L, 0L );

      if (NO_ERROR != Rc)
      {
         return RC_ERROR;
      }
   }
   /***************************************************/
   /* For performance reason, we check number of bytes*/
   /* we need for making up a string here and select  */
   /* static buffer or dynamic buffer for handling    */
   /* string.                                         */
   /***************************************************/
   if ((lNumChars * 2 + 1) > LOCALBUFSIZE)
   {
      pszGlyphs = (PSZ) GplMemoryAlloc (pddc->pdb->hmcbHeap,
                                       (lNumChars * 2 + 1));
      assertF (pszGlyphs);
      if (!pszGlyphs)
      {
         return RC_ERROR;
      }
   }
   /***************************************************/
   /* For safty reason, we make our string pointer to */
   /* the pointer already allocated. But remember its */
   /* size is LOCALBUFSIZE only. We have to trick some*/
   /* here.                                           */
   /***************************************************/
   if (!pszGlyphs)
   {
      pszGlyphs = pbStringBuf;
      if (lNumChars > LOCALBUFSIZE-1)
      {
         lNumChars = LOCALBUFSIZE-1;
      }
   }

#ifdef DEBUG
   if (ptbi->pDevFntInfo->fFontInfo & DFI_FIXED_FONT )
   {
      DBPRINTF (("DevFntTextBlt(): Fixed Width Font\n" ));
   }

   if (ptbi->pDevFntInfo->fFontInfo & DFI_DBCS_FONT )
   {
      DBPRINTF (("DevFntTextBlt(): DBCS Font\n" ));
   }
#endif

   pulChar = (PULONG)ptbi->pGlyphIndices;

   // Calculate width in half sized char
   ulNumHalfChars = (ULONG) lNumChars;
   if( lNumChars > 1)
   {
      ULONG ulWidth;
      ULONG fSamePitch = 1;

      ulCharWidth = ptbi->abrDst[1].ulXOrg - ptbi->abrDst[0].ulXOrg;

      if( *pulChar < 0x0400)
      {
         // To prevent rounding error,
         // convert to DBCS width here for late calc
         ulCharWidth *= 2;
      }
      else
      {
         // DBCS is double SBCS
         ulNumHalfChars++;
      }

      for( i=2; i<lNumChars; i++)
      {
         ulWidth = ptbi->abrDst[i].ulXOrg - ptbi->abrDst[i-1].ulXOrg;

         if( *(pulChar + i - 1) < 0x0400)
         {
            // To prevent rounding error,
            // convert to DBCS width here for late calc
            ulWidth *= 2;
         }
         else
         {
            // DBCS is double SBCS width
            ulNumHalfChars++;
         }

         if( ulWidth != ulCharWidth)
         {
            fOneByOne  = 1;
            fSamePitch = 0;
            break;
         }
      }

      //If Same pitch, check if there is spacing specified.
      if( fSamePitch)
      {
         ulLeftMost   = ptbi->abrDst[0].ulXOrg;
         ulRightMost  = ptbi->abrDst[lNumChars-1].ulXOrg
                      + ptbi->abrDst[lNumChars-1].ulXExt;

         // Chech if there exist spacing value.
         ulHalfWidth  = (ulRightMost - ulLeftMost) / ulNumHalfChars;

         if( ulHalfWidth == ptbi->pDevFntInfo->ulHalfWidth)
         {
//          if( ulHalfWidth != ptbi->pDevFntInfo->ulHalfWidth)
//          {
//             ulSpacing = ulHalfWidth - ptbi->pDevFntInfo->ulHalfWidth;
//          }
//          else
//          {
            // No vector or spacing is specified.
            // Setup just one half char box for reference
            rclTextBox.xLeft   = ptbi->abrDst->ulXOrg;
            rclTextBox.xRight  = rclTextBox.xLeft + ptbi->pDevFntInfo->ulHalfWidth;
//          }
         }
         else
         {
            //Spacing is minus!! Try one by one!
//          ulSpacing = 0;
            fOneByOne = 1;
         }
      }
   }
   else
   {
      // No vector or spacing is need for just 1 char.
      rclTextBox.xLeft   = ptbi->abrDst->ulXOrg;
      rclTextBox.xRight  = rclTextBox.xLeft + ptbi->abrDst->ulXExt;
   }

   // Y Pos will never change in the string passed from GRE
   rclTextBox.yBottom = ptbi->abrDst->ulYOrg;
   rclTextBox.yTop    = rclTextBox.yBottom + ptbi->abrDst->ulYExt;

//ptbi->flOptions
//Next definitions have to be removed if we move them
//to pmxxx.h in the future.
#define OPT_CHAR_ITALIC     0x00000010
#define OPT_CHAR_BOLD       0x00000020
#define OPT_CHAR_ANGLE      0x00000040
#define OPT_CHAR_SHEAR      0x00000080
#define OPT_CHAR_OUTLINE    0x00000100
#define OPT_CHAR_UNDERLINE  0x00000200
#define OPT_CHAR_STRIKEOUT  0x00000400
#define OPT_CHAR_DIRECTION  0x00000800

   DevFntAttrs.fAttributes   = ptbi->flOptions |
                               FAF_FONTTYPE    |
                               FAF_WIDTH       |
                               FAF_HEIGHT      ;
   DevFntAttrs.ulFonttype    = ptbi->pDevFntInfo->ulUniqueFntID;

   DevFntAttrs.ulSpacing     = 0;
// DevFntAttrs.ulSpacing     = ulSpacing;
// if( ulSpacing)
// {
//    DevFntAttrs.fAttributes |= FAF_SPACING;
// }

   // !!!Always set half width here, DBCS spec!!!
   
   DevFntAttrs.ulHalfWidth   = ptbi->pDevFntInfo->ulHalfWidth;
   DevFntAttrs.ulFullWidth   = ptbi->pDevFntInfo->ulMaxWidth;
   DevFntAttrs.ulHeight      = ptbi->pDevFntInfo->ulMaxHeight;

   // Set common attributes
   DevFntAttrs.ulFGColor     = ptbi->ulFGColor;
   DevFntAttrs.ulBGColor     = ptbi->ulBGColor;
   DevFntAttrs.ulMixMode     = ptbi->ulFGMix;
   DevFntAttrs.ulBackMixMode = ptbi->ulBGMix;

   // Have to define interface to pass Angle Sheal Direction
   // attributes from GRE to drivers
   DevFntAttrs.ptlAngle.x    = 0;
   DevFntAttrs.ptlAngle.y    = 0;
   DevFntAttrs.ptlSheal.x    = 0;
   DevFntAttrs.ptlSheal.y    = 0;
   DevFntAttrs.ulDirection   = 0;

   for ( i = 0; i < lNumChars; i++ )
   {
      ulIndex = pulChar[i];

      /* Specification ***************************/
      /* GlyphIndex indicates it's SBCS when it's*/
      /* below 0x400.                            */
      /*******************************************/
      if ( ulIndex < 0x400 )
      {
         if(fOneByOne)
            *(pszGlyphs+j)   = (CHAR)ulIndex;
         else
            *(pszGlyphs+i+j) = (CHAR)ulIndex;
      }
      else
      {
#if JPNBLD
         LONG  lFontID  = (LONG)ptbi->pDevFntInfo->ulUniqueFntID;
         FONTINFO2 pFont= pddc->pdb->pDriver->pFONTS[-(lFontID+1)];

         // Convert JIS code point before making a string here
         // if it's shift-JIS shift-JIS conversion.
         // This code is added for those case not need
         // DBCSconvert case.
         if (pFont.ulFontCharEncoding == CHAR_ENCODING_SHIFT_JIS)
         {
            if ( (ulSystemCharSet     != pFont.ulFontCharSet)
              && ((ulSystemCharSet    == CHAR_SET_JIS_C_6226_1978)
              || (pFont.ulFontCharSet == CHAR_SET_JIS_C_6226_1978)))
            {
               ulIndex = GplDBCSJpnJisSwap( ulIndex);
            }
         }
#endif //JPNBLD
         DBPRINTF (("DevFntTextBlt: DBCS has passed in!\n"));

         if( fOneByOne)
         {
            *(pszGlyphs+j++) = (CHAR) (ulIndex >> 8);
            *(pszGlyphs+j)   = (CHAR)  ulIndex;
         }
         else
         {
            *(pszGlyphs+i+j++) = (CHAR) (ulIndex >> 8);
            *(pszGlyphs+i+j)   = (CHAR)  ulIndex;
         }
      }

      if( fOneByOne)
      {
         *(pszGlyphs + ++j) = 0;
         rclTextBox.xLeft   = ptbi->abrDst[i].ulXOrg;
         rclTextBox.xRight  = rclTextBox.xLeft + ptbi->abrDst[i].ulXExt;
         pDevFntAttrs = InsertFontAttrs (pddc, pDevFntCB, &DevFntAttrs);

         /*******************************************************/
         /* We insert textblted string here with text box and   */
         /* font information.                                   */
         /*******************************************************/
         Rc = GplStringSorterInsertString (*phSort,
                                           pszGlyphs,
                                           strlen (pszGlyphs) + 1,
                                           rclTextBox,
                                           (PVOID)pDevFntAttrs,
                                           NULL );
         j = 0;
      }
   }

   if( !fOneByOne)
   {
      *(pszGlyphs + i + j) = 0;
      pDevFntAttrs = InsertFontAttrs (pddc, pDevFntCB, &DevFntAttrs);

      /*******************************************************/
      /* We insert textblted string here with text box and   */
      /* font information.                                   */
      /*******************************************************/
      Rc = GplStringSorterInsertString (*phSort,
                                        pszGlyphs,
                                        strlen (pszGlyphs) + 1,
                                        rclTextBox,
                                        (PVOID)pDevFntAttrs,
                                        NULL );
   }

   if (pszGlyphs && (pszGlyphs != pbStringBuf ))
   {
      GplMemoryFree (pszGlyphs);
   }

   return Rc;
}
//@SCALABLEFONT - end

/****************************************************************************/
/* PROCEDURE NAME : CommonCompress                                          */
/* AUTHOR         : Yu-Chih, Shih                                           */
/* DATE WRITTEN   : 05/20/96                                                */
/* DESCRIPTION    : Compression Logic For ESC/Page                          */
/*                  Compress data with ESC/Page method, but if compressed   */
/*                  data is larger than original length, return error.      */
/*                  The compress logic is RLL type of logic, just differnet */
/*                  in encoding.                                            */
/*                  We encoding with Mode 3 as our implemetation.           */
/*                                                                          */
/* PARAMETERS:      cbDataIn                                                */
/*                  *pbDataIn                                               */
/*                  cbDataOut                                               */
/*                  *pbDataOut                                              */
/*                                                                          */
/*                                                                          */
/* RETURN VALUES:   GPLCOMPRESS_ERROR   Did not compressed                  */
/*                  OHTER               Compressed bytes will be returned   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
LONG APIENTRY
CommonCompress (INT   cbDataIn,
                BYTE *pbDataIn,
                INT   cbDataOut,
                BYTE *pbDataOut)
{
   LONG              i, j, dups;
   unsigned char     data;
   LONG              rcResult;

   i = j = 0;

   cbDataOut -= 2;

   while (i < cbDataIn && j < cbDataOut)
   {
      dups = 0;                     // initial count of dups
      data = *(pbDataIn + i++);     // seed start point

      while ((i < cbDataIn)               &&
             (data == *(pbDataIn + i))    &&
             (dups < 255))
      {
         dups++;
         i++;
      }

      if (dups)
      {
         *(pbDataOut + j++) = data;
         *(pbDataOut + j++) = data;
         *(pbDataOut + j++) = dups - 1;      // ESC/Page Mode3;Lips Mode9
      }
      else
         *(pbDataOut + j++) = data;
   }

   rcResult = (j < cbDataOut) ? j : GPLCOMPRESS_ERROR;

   return rcResult;
}

/****************************************************************************/
/* PROCEDURE NAME : DeviceAddDialogPage                                     */
/* AUTHOR         : Mark H.                                                 */
/* DATE WRITTEN   : 03/23/98                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   VOID                Nothing                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID
DeviceAddDialogPage (PDLGINSTANCE  pdi,
                     ULONG         ulType,
                     ULONG         ulDlgID,
                     PFNWP         pfnDlg,
                     PSZ           pszTabText)
{
   PPNBPAGEINFO ppNew = NULL;
   PNBPAGEINFO  pElm  = NULL;

   DBPRINTF (("%s:Enter ulType = %d\n", __FUNCTION__, ulType));

   // Find a free slot
   if (DEVICE_QUERY_PRN_DIALOGS == ulType)
      ppNew = &pdi->pNBI->pPageInfoPrinterDevice;
   else if (DEVICE_QUERY_JOB_DIALOGS == ulType)
      ppNew = &pdi->pNBI->pPageInfoJobDevice;
   else
   {
      assertstring ("Unknown Type!\n");
      ppNew = NULL;
   }

   while (  *ppNew            // If there is an element
         && (*ppNew)->pfnDlg  // then is it available?
         )
   {
      // No.  Move to the next slot
      ppNew = &(*ppNew)->pNext;
   }

   // Do we need to allocate an element?
   if (!*ppNew)
   {
      pElm = (PNBPAGEINFO)GplMemoryAlloc (pdi->hmcbHeap,
                                          sizeof (NBPAGEINFO));
      assertF (pElm);

      if (pElm)
      {
         memset (pElm, 0, sizeof (NBPAGEINFO));
         *ppNew = pElm;
      }
   }

   // If we have an element now
   if (*ppNew)
   {
      pElm = *ppNew;
      memset (pElm, 0, sizeof (*pElm));

      pElm->ulDlgID    = ulDlgID;
      pElm->pfnDlg     = pfnDlg;
      pElm->pszTabText = pszTabText;
   }

   DBPRINTF (("%s:Exit\n", __FUNCTION__));
}

typedef struct _UGLToUnicode {
   USHORT   usUnicode;
   USHORT   usUGL;
} UGLTOUNICODE, *PUGLTOUNICODE;

static UGLTOUNICODE vaUGLToUnicode[] = {
   {0x263A, 0x0001}, // # 001 ss000000  SS000000
   {0x263B, 0x0002}, // # 002 ss010000  SS010000
   {0x2665, 0x0003}, // # 003 ss020000  heart
   {0x2666, 0x0004}, // # 004 ss030000  diamond
   {0x2663, 0x0005}, // # 005 ss040000  club
   {0x2660, 0x0006}, // # 006 ss050000  spade
   {0x2022, 0x0007}, // # 007 sm570000  bullet
   {0x25D8, 0x0008}, // # 008 sm570001  SM570001
   {0x25CB, 0x0009}, // # 009 sm750000  SM750000
   {0x25D9, 0x000A}, // # 010 sm750002  SM750002
   {0x2642, 0x000B}, // # 011 sm280000  male
   {0x2640, 0x000C}, // # 012 sm290000  female
   {0x266A, 0x000D}, // # 013 sm930000  musicalnote
   {0x266B, 0x000E}, // # 014 sm910000  musicalnotedbl
   {0x263C, 0x000F}, // # 015 sm690000  SM690000
   {0x25BA, 0x0010}, // # 016 sm590000  SM590000
   {0x25C4, 0x0011}, // # 017 sm630000  SM630000
   {0x2195, 0x0012}, // # 018 sm760000  SM760000
   {0x203C, 0x0013}, // # 019 sp330000  exclamdbl
   {0x00B6, 0x0014}, // # 020 sm250000  paragraph
   {0x00A7, 0x0015}, // # 021 sm240000  section
   {0x25AC, 0x0016}, // # 022 sm700000  SM700000
   {0x21A8, 0x0017}, // # 023 sm770000  SM770000
   {0x2191, 0x0018}, // # 024 sm320000  arrowup
   {0x2193, 0x0019}, // # 025 sm330000  arrowdown
   {0x2192, 0x001A}, // # 026 sm310000  arrowright
   {0x2190, 0x001B}, // # 027 sm300000  arrowleft
   {0x221F, 0x001C}, // # 028 sa420000  rightangle
   {0x2194, 0x001D}, // # 029 sm780000  arrowboth
   {0x25B2, 0x001E}, // # 030 sm600000  SM600000
   {0x25BC, 0x001F}, // # 031 sv040000  SV040000
   {0x0020, 0x0020}, // # 032 sp010000  space
   {0x0021, 0x0021}, // # 033 sp020000  exclam
   {0x0022, 0x0022}, // # 034 sp040000  quotedbl
   {0x0023, 0x0023}, // # 035 sm010000  numbersign
   {0x0024, 0x0024}, // # 036 sc030000  dollar
   {0x0025, 0x0025}, // # 037 sm020000  percent
   {0x0026, 0x0026}, // # 038 sm030000  ampersand
   {0x0027, 0x0027}, // # 039 sp050000  quotesingle
   {0x0028, 0x0028}, // # 040 sp060000  parenleft
   {0x0029, 0x0029}, // # 041 sp070000  parenright
   {0x002A, 0x002A}, // # 042 sm040000  asterisk
   {0x002B, 0x002B}, // # 043 sa010000  plus
   {0x002C, 0x002C}, // # 044 sp080000  comma
   {0x002D, 0x002D}, // # 045 sp100000  hyphen
   {0x002E, 0x002E}, // # 046 sp110000  period
   {0x002F, 0x002F}, // # 047 sp120000  slash
   {0x0030, 0x0030}, // # 048 nd100000  zero
   {0x0031, 0x0031}, // # 049 nd010000  one
   {0x0032, 0x0032}, // # 050 nd020000  two
   {0x0033, 0x0033}, // # 051 nd030000  three
   {0x0034, 0x0034}, // # 052 nd040000  four
   {0x0035, 0x0035}, // # 053 nd050000  five
   {0x0036, 0x0036}, // # 054 nd060000  six
   {0x0037, 0x0037}, // # 055 nd070000  seven
   {0x0038, 0x0038}, // # 056 nd080000  eight
   {0x0039, 0x0039}, // # 057 nd090000  nine
   {0x003A, 0x003A}, // # 058 sp130000  colon
   {0x003B, 0x003B}, // # 059 sp140000  semicolon
   {0x003C, 0x003C}, // # 060 sa030000  less
   {0x003D, 0x003D}, // # 061 sa040000  equal
   {0x003E, 0x003E}, // # 062 sa050000  greater
   {0x003F, 0x003F}, // # 063 sp150000  question
   {0x0040, 0x0040}, // # 064 sm050000  at
   {0x0041, 0x0041}, // # 065 la020000  A
   {0x0042, 0x0042}, // # 066 lb020000  B
   {0x0043, 0x0043}, // # 067 lc020000  C
   {0x0044, 0x0044}, // # 068 ld020000  D
   {0x0045, 0x0045}, // # 069 le020000  E
   {0x0046, 0x0046}, // # 070 lf020000  F
   {0x0047, 0x0047}, // # 071 lg020000  G
   {0x0048, 0x0048}, // # 072 lh020000  H
   {0x0049, 0x0049}, // # 073 li020000  I
   {0x004A, 0x004A}, // # 074 lj020000  J
   {0x004B, 0x004B}, // # 075 lk020000  K
   {0x004C, 0x004C}, // # 076 ll020000  L
   {0x004D, 0x004D}, // # 077 lm020000  M
   {0x004E, 0x004E}, // # 078 ln020000  N
   {0x004F, 0x004F}, // # 079 lo020000  O
   {0x0050, 0x0050}, // # 080 lp020000  P
   {0x0051, 0x0051}, // # 081 lq020000  Q
   {0x0052, 0x0052}, // # 082 lr020000  R
   {0x0053, 0x0053}, // # 083 ls020000  S
   {0x0054, 0x0054}, // # 084 lt020000  T
   {0x0055, 0x0055}, // # 085 lu020000  U
   {0x0056, 0x0056}, // # 086 lv020000  V
   {0x0057, 0x0057}, // # 087 lw020000  W
   {0x0058, 0x0058}, // # 088 lx020000  X
   {0x0059, 0x0059}, // # 089 ly020000  Y
   {0x005A, 0x005A}, // # 090 lz020000  Z
   {0x005B, 0x005B}, // # 091 sm060000  bracketleft
   {0x005C, 0x005C}, // # 092 sm070000  backslash
   {0x005D, 0x005D}, // # 093 sm080000  bracketright
   {0x005E, 0x005E}, // # 094 sd150000  circumflex
   {0x005F, 0x005F}, // # 095 sp090000  underscore
   {0x0060, 0x0060}, // # 096 sd130000  grave
   {0x0061, 0x0061}, // # 097 la010000  a
   {0x0062, 0x0062}, // # 098 lb010000  b
   {0x0063, 0x0063}, // # 099 lc010000  c
   {0x0064, 0x0064}, // # 100 ld010000  d
   {0x0065, 0x0065}, // # 101 le010000  e
   {0x0066, 0x0066}, // # 102 lf010000  f
   {0x0067, 0x0067}, // # 103 lg010000  g
   {0x0068, 0x0068}, // # 104 lh010000  h
   {0x0069, 0x0069}, // # 105 li010000  i
   {0x006A, 0x006A}, // # 106 lj010000  j
   {0x006B, 0x006B}, // # 107 lk010000  k
   {0x006C, 0x006C}, // # 108 ll010000  l
   {0x006D, 0x006D}, // # 109 lm010000  m
   {0x006E, 0x006E}, // # 110 ln010000  n
   {0x006F, 0x006F}, // # 111 lo010000  o
   {0x0070, 0x0070}, // # 112 lp010000  p
   {0x0071, 0x0071}, // # 113 lq010000  q
   {0x0072, 0x0072}, // # 114 lr010000  r
   {0x0073, 0x0073}, // # 115 ls010000  s
   {0x0074, 0x0074}, // # 116 lt010000  t
   {0x0075, 0x0075}, // # 117 lu010000  u
   {0x0076, 0x0076}, // # 118 lv010000  v
   {0x0077, 0x0077}, // # 119 lw010000  w
   {0x0078, 0x0078}, // # 120 lx010000  x
   {0x0079, 0x0079}, // # 121 ly010000  y
   {0x007A, 0x007A}, // # 122 lz010000  z
   {0x007B, 0x007B}, // # 123 sm110000  braceleft
   {0x007C, 0x007C}, // # 124 sm130000  bar
   {0x007D, 0x007D}, // # 125 sm140000  braceright
   {0x007E, 0x007E}, // # 126 sd190000  tilde
   {0x2302, 0x007F}, // # 127 sm790000  SM790000
   {0x00C7, 0x0080}, // # 128 lc420000  Ccedilla
   {0x00FC, 0x0081}, // # 129 lu170000  udieresis
   {0x00E9, 0x0082}, // # 130 le110000  eacute
   {0x00E2, 0x0083}, // # 131 la150000  acircumflex
   {0x00E4, 0x0084}, // # 132 la170000  adieresis
   {0x00E0, 0x0085}, // # 133 la130000  agrave
   {0x00E5, 0x0086}, // # 134 la270000  aring
   {0x00E7, 0x0087}, // # 135 lc410000  ccedilla
   {0x00EA, 0x0088}, // # 136 le150000  ecircumflex
   {0x00EB, 0x0089}, // # 137 le170000  edieresis
   {0x00E8, 0x008A}, // # 138 le130000  egrave
   {0x00EF, 0x008B}, // # 139 li170000  idieresis
   {0x00EE, 0x008C}, // # 140 li150000  icircumflex
   {0x00EC, 0x008D}, // # 141 li130000  igrave
   {0x00C4, 0x008E}, // # 142 la180000  Adieresis
   {0x00C5, 0x008F}, // # 143 la280000  Aring
   {0x00C9, 0x0090}, // # 144 le120000  Eacute
   {0x00E6, 0x0091}, // # 145 la510000  ae
   {0x00C6, 0x0092}, // # 146 la520000  AE
   {0x00F4, 0x0093}, // # 147 lo150000  ocircumflex
   {0x00F6, 0x0094}, // # 148 lo170000  odieresis
   {0x00F2, 0x0095}, // # 149 lo130000  ograve
   {0x00FB, 0x0096}, // # 150 lu150000  ucircumflex
   {0x00F9, 0x0097}, // # 151 lu130000  ugrave
   {0x00FF, 0x0098}, // # 152 ly170000  ydieresis
   {0x00D6, 0x0099}, // # 153 lo180000  Odieresis
   {0x00DC, 0x009A}, // # 154 lu180000  Udieresis
   {0x00F8, 0x009B}, // # 155 lo610000  oslash
   {0x00A3, 0x009C}, // # 156 sc020000  sterling
   {0x00D8, 0x009D}, // # 157 lo620000  Oslash
   {0x00D7, 0x009E}, // # 158 sa070000  multiply
   {0x0192, 0x009F}, // # 159 sc070000  florin
   {0x00E1, 0x00A0}, // # 160 la110000  aacute
   {0x00ED, 0x00A1}, // # 161 li110000  iacute
   {0x00F3, 0x00A2}, // # 162 lo110000  oacute
   {0x00FA, 0x00A3}, // # 163 lu110000  uacute
   {0x00F1, 0x00A4}, // # 164 ln190000  ntilde
   {0x00D1, 0x00A5}, // # 165 ln200000  Ntilde
   {0x00AA, 0x00A6}, // # 166 sm210000  ordfeminine
   {0x00BA, 0x00A7}, // # 167 sm200000  ordmasculine
   {0x00BF, 0x00A8}, // # 168 sp160000  questiondown
   {0x00AE, 0x00A9}, // # 169 sm530000  registered
   {0x00AC, 0x00AA}, // # 170 sm660000  logicalnot
   {0x00BD, 0x00AB}, // # 171 nf010000  onehalf
   {0x00BC, 0x00AC}, // # 172 nf040000  onequarter
   {0x00A1, 0x00AD}, // # 173 sp030000  exclamdown
   {0x00AB, 0x00AE}, // # 174 sp170000  guillemotleft
   {0x00BB, 0x00AF}, // # 175 sp180000  guillemotright
   {0x2591, 0x00B0}, // # 176 sf140000  SF140000
   {0x2592, 0x00B1}, // # 177 sf150000  SF150000
   {0x2593, 0x00B2}, // # 178 sf160000  SF160000
   {0x2502, 0x00B3}, // # 179 sf110000  SF110000
   {0x2524, 0x00B4}, // # 180 sf090000  SF090000
   {0x00C1, 0x00B5}, // # 181 la120000  Aacute
   {0x00C2, 0x00B6}, // # 182 la160000  Acircumflex
   {0x00C0, 0x00B7}, // # 183 la140000  Agrave
   {0x00A9, 0x00B8}, // # 184 sm520000  copyright
   {0x2563, 0x00B9}, // # 185 sf230000  SF230000
   {0x2551, 0x00BA}, // # 186 sf240000  SF240000
   {0x2557, 0x00BB}, // # 187 sf250000  SF250000
   {0x255D, 0x00BC}, // # 188 sf260000  SF260000
   {0x00A2, 0x00BD}, // # 189 sc040000  cent
   {0x00A5, 0x00BE}, // # 190 sc050000  yen
   {0x2510, 0x00BF}, // # 191 sf030000  SF030000
   {0x2514, 0x00C0}, // # 192 sf020000  SF020000
   {0x2534, 0x00C1}, // # 193 sf070000  SF070000
   {0x252C, 0x00C2}, // # 194 sf060000  SF060000
   {0x251C, 0x00C3}, // # 195 sf080000  SF080000
   {0x2500, 0x00C4}, // # 196 sf100000  SF100000
   {0x253C, 0x00C5}, // # 197 sf050000  SF050000
   {0x00E3, 0x00C6}, // # 198 la190000  atilde
   {0x00C3, 0x00C7}, // # 199 la200000  Atilde
   {0x255A, 0x00C8}, // # 200 sf380000  SF380000
   {0x2554, 0x00C9}, // # 201 sf390000  SF390000
   {0x2569, 0x00CA}, // # 202 sf400000  SF400000
   {0x2566, 0x00CB}, // # 203 sf410000  SF410000
   {0x2560, 0x00CC}, // # 204 sf420000  SF420000
   {0x2550, 0x00CD}, // # 205 sf430000  SF430000
   {0x256C, 0x00CE}, // # 206 sf440000  SF440000
   {0x00A4, 0x00CF}, // # 207 sc010000  currency
   {0x00F0, 0x00D0}, // # 208 ld630000  eth
   {0x00D0, 0x00D1}, // # 209 ld620000  Eth
   {0x00CA, 0x00D2}, // # 210 le160000  Ecircumflex
   {0x00CB, 0x00D3}, // # 211 le180000  Edieresis
   {0x00C8, 0x00D4}, // # 212 le140000  Egrave
   {0x20AC, 0x00D5}, // # 213 sc200000  euro
   {0x00CD, 0x00D6}, // # 214 li120000  Iacute
   {0x00CE, 0x00D7}, // # 215 li160000  Icircumflex
   {0x00CF, 0x00D8}, // # 216 li180000  Idieresis
   {0x2518, 0x00D9}, // # 217 sf040000  SF040000
   {0x250C, 0x00DA}, // # 218 sf010000  SF010000
   {0x2588, 0x00DB}, // # 219 sf610000  SF610000
   {0x2584, 0x00DC}, // # 220 sf570000  SF570000
   {0x00A6, 0x00DD}, // # 221 sm650000  brokenbar
   {0x00CC, 0x00DE}, // # 222 li140000  Igrave
   {0x2580, 0x00DF}, // # 223 sf600000  SF600000
   {0x00D3, 0x00E0}, // # 224 lo120000  Oacute
   {0x00DF, 0x00E1}, // # 225 ls610000  germandbls
   {0x00D4, 0x00E2}, // # 226 lo160000  Ocircumflex
   {0x00D2, 0x00E3}, // # 227 lo140000  Ograve
   {0x00F5, 0x00E4}, // # 228 lo190000  otilde
   {0x00D5, 0x00E5}, // # 229 lo200000  Otilde
   {0x00B5, 0x00E6}, // # 230 sm170000  mu
   {0x00FE, 0x00E7}, // # 231 lt630000  thorn
   {0x00DE, 0x00E8}, // # 232 lt640000  Thorn
   {0x00DA, 0x00E9}, // # 233 lu120000  Uacute
   {0x00DB, 0x00EA}, // # 234 lu160000  Ucircumflex
   {0x00D9, 0x00EB}, // # 235 lu140000  Ugrave
   {0x00FD, 0x00EC}, // # 236 ly110000  yacute
   {0x00DD, 0x00ED}, // # 237 ly120000  Yacute
   {0x00AF, 0x00EE}, // # 238 sm150000  overline
   {0x00B4, 0x00EF}, // # 239 sd110000  acute
   {0x00AD, 0x00F0}, // # 240 sp320000  hyphen           (syllable)
   {0x00B1, 0x00F1}, // # 241 sa020000  plusminus
   {0x2017, 0x00F2}, // # 242 sm100000  underscoredbl
   {0x00BE, 0x00F3}, // # 243 nf050000  threequarters
   {0x00B6, 0x00F4}, // # 244 sm250000  paragraph
   {0x00A7, 0x00F5}, // # 245 sm240000  section
   {0x00F7, 0x00F6}, // # 246 sa060000  divide
   {0x00B8, 0x00F7}, // # 247 sd410000  cedilla
   {0x00B0, 0x00F8}, // # 248 sm190000  degree
   {0x00A8, 0x00F9}, // # 249 sd170000  dieresis
   {0x00B7, 0x00FA}, // # 250 sd630000  periodcentered
   {0x00B9, 0x00FB}, // # 251 nd011000  onesuperior
   {0x00B3, 0x00FC}, // # 252 nd031000  threesuperior
   {0x00B2, 0x00FD}, // # 253 nd021000  twosuperior
   {0x25A0, 0x00FE}, // # 254 sm470000  filledbox
   {0x00A0, 0x00FF}, // # 255 sp300000  reqspace
   {0x20A7, 0x0100}, // # 256 sc060000  Pts
   {0x2310, 0x0101}, // # 257 sm680000  SM680000
   {0x2561, 0x0102}, // # 258 sf190000  SF190000
   {0x2562, 0x0103}, // # 259 sf200000  SF200000
   {0x2556, 0x0104}, // # 260 sf210000  SF210000
   {0x2555, 0x0105}, // # 261 sf220000  SF220000
   {0x255C, 0x0106}, // # 262 sf270000  SF270000
   {0x255B, 0x0107}, // # 263 sf280000  SF280000
   {0x255E, 0x0108}, // # 264 sf360000  SF360000
   {0x255F, 0x0109}, // # 265 sf370000  SF370000
   {0x2567, 0x010A}, // # 266 sf450000  SF450000
   {0x2568, 0x010B}, // # 267 sf460000  SF460000
   {0x2564, 0x010C}, // # 268 sf470000  SF470000
   {0x2565, 0x010D}, // # 269 sf480000  SF480000
   {0x2559, 0x010E}, // # 270 sf490000  SF490000
   {0x2558, 0x010F}, // # 271 sf500000  SF500000
   {0x2552, 0x0110}, // # 272 sf510000  SF510000
   {0x2553, 0x0111}, // # 273 sf520000  SF520000
   {0x256B, 0x0112}, // # 274 sf530000  SF530000
   {0x256A, 0x0113}, // # 275 sf540000  SF540000
   {0x258C, 0x0114}, // # 276 sf580000  SF580000
   {0x2590, 0x0115}, // # 277 sf590000  SF590000
   {0x03B1, 0x0116}, // # 278 ga010000  alpha
   {0x0393, 0x0117}, // # 279 gg020000  Gamma
   {0x03C0, 0x0118}, // # 280 gp010000  pi
   {0x03A3, 0x0119}, // # 281 gs020000  Sigma
   {0x03C3, 0x011A}, // # 282 gs010000  sigma
   {0x03C4, 0x011B}, // # 283 gt010000  tau
   {0x03A6, 0x011C}, // # 284 gf020000  Phi
   {0x0398, 0x011D}, // # 285 gt620000  Theta
   {0x03A9, 0x011E}, // # 286 go320000  Omega
   {0x03B4, 0x011F}, // # 287 gd010000  delta
   {0x221E, 0x0120}, // # 288 sa450000  infinity
   {0x03C6, 0x0121}, // # 289 gf010000  phi
   {0x03B5, 0x0122}, // # 290 ge010000  epsilon
   {0x2229, 0x0123}, // # 291 sa380000  intersection
   {0x2261, 0x0124}, // # 292 sa480000  equivalence
   {0x2265, 0x0125}, // # 293 sa530000  greaterequal
   {0x2264, 0x0126}, // # 294 sa520000  lessequal
   {0x2320, 0x0127}, // # 295 ss260000  SS260000
   {0x2321, 0x0128}, // # 296 ss270000  SS260000
   {0x2248, 0x0129}, // # 297 sa700000  approxequal
   {0x2219, 0x012A}, // # 298 sa790000  productdot       (dotmath)
   {0x221A, 0x012B}, // # 299 sa800000  radical
   {0x207F, 0x012C}, // # 300 ln011000  nsuperior
   {0x02C9, 0x012D}, // # 301 sd310000  macron
   {0x02D8, 0x012E}, // # 302 sd230000  breve
   {0x02D9, 0x012F}, // # 303 sd290000  dotaccent
   {0x02DA, 0x0130}, // # 304 sd270000  ring
   {0x02DD, 0x0131}, // # 305 sd250000  hungarumlaut
   {0x02DB, 0x0132}, // # 306 sd430000  ogonek
   {0x02C7, 0x0133}, // # 307 sd210000  caron
   {0x2018, 0x0134}, // # 308 sp190000  quoteleft
   {0x2019, 0x0135}, // # 309 sp200000  quoteright
   {0x201C, 0x0136}, // # 310 sp210000  quotedblleft
   {0x201D, 0x0137}, // # 311 sp220000  quotedblright
   {0x2013, 0x0138}, // # 312 ss680000  endash
   {0x2014, 0x0139}, // # 313 sm900000  emdash
   {0xFFE5, 0x013A}, // # 314 sc120000  yuan
   {0x0131, 0x013B}, // # 315 li610000  dotlessi
   {0x201A, 0x013C}, // # 316 sp260000  quotesinglbase
   {0x201E, 0x013D}, // # 317 sp230000  quotedblbase
   {0x2026, 0x013E}, // # 318 sv520000  ellipsis
   {0x2020, 0x013F}, // # 319 sm340000  dagger
   {0x2021, 0x0140}, // # 320 sm350000  daggerdbl
   {0x02C6, 0x0141}, // # 321 sd150300  circumflex
   {0x2030, 0x0142}, // # 322 sm560000  perthousand
   {0x0160, 0x0143}, // # 323 ls220000  Scaron
   {0x2039, 0x0144}, // # 324 sp270000  guilsinglleft
   {0x0152, 0x0145}, // # 325 lo520000  OE
   {0x02DC, 0x0146}, // # 326 sd190100  tilde
   {0x2122, 0x0147}, // # 327 sm540000  trademark
   {0x0161, 0x0148}, // # 328 ls210000  scaron
   {0x203A, 0x0149}, // # 329 sp280000  guilsinglright
   {0x0153, 0x014A}, // # 330 lo510000  oe
   {0x0178, 0x014B}, // # 331 ly180000  Ydieresis
   {0x011F, 0x014C}, // # 332 lg230000  gbreve
   {0x011E, 0x014D}, // # 333 lg240000  Gbreve
   {0x0130, 0x014E}, // # 334 li300000  Idotaccent
   {0x015F, 0x014F}, // # 335 ls410000  scedilla
   {0x015E, 0x0150}, // # 336 ls420000  Scedilla
   {0x0103, 0x0151}, // # 337 la230000  abreve
   {0x0102, 0x0152}, // # 338 la240000  Abreve
   {0x0105, 0x0153}, // # 339 la430000  aogonek
   {0x0104, 0x0154}, // # 340 la440000  Aogonek
   {0x0107, 0x0155}, // # 341 lc110000  cacute
   {0x0106, 0x0156}, // # 342 lc120000  Cacute
   {0x010D, 0x0157}, // # 343 lc210000  ccaron
   {0x010C, 0x0158}, // # 344 lc220000  Ccaron
   {0x010F, 0x0159}, // # 345 ld210000  dcaron
   {0x010E, 0x015A}, // # 346 ld220000  Dcaron
   {0x0111, 0x015B}, // # 347 ld610000  dbar
   {0x011B, 0x015C}, // # 348 le210000  ecaron
   {0x011A, 0x015D}, // # 349 le220000  Ecaron
   {0x0119, 0x015E}, // # 350 le430000  eogonek
   {0x0118, 0x015F}, // # 351 le440000  Eogonek
   {0x013A, 0x0160}, // # 352 ll110000  lacute
   {0x0139, 0x0161}, // # 353 ll120000  Lacute
   {0x013E, 0x0162}, // # 354 ll210000  lcaron
   {0x013D, 0x0163}, // # 355 ll220000  Lcaron
   {0x0142, 0x0164}, // # 356 ll610000  lslash
   {0x0141, 0x0165}, // # 357 ll620000  Lslash
   {0x0144, 0x0166}, // # 358 ln110000  nacute
   {0x0143, 0x0167}, // # 359 ln120000  Nacute
   {0x0148, 0x0168}, // # 360 ln210000  ncaron
   {0x0147, 0x0169}, // # 361 ln220000  Ncaron
   {0x0151, 0x016A}, // # 362 lo250000  ohungarumlaut
   {0x0150, 0x016B}, // # 363 lo260000  Ohungarumlaut
   {0x0155, 0x016C}, // # 364 lr110000  racute
   {0x0154, 0x016D}, // # 365 lr120000  Racute
   {0x0159, 0x016E}, // # 366 lr210000  rcaron
   {0x0158, 0x016F}, // # 367 lr220000  Rcaron
   {0x015B, 0x0170}, // # 368 ls110000  sacute
   {0x015A, 0x0171}, // # 369 ls120000  Sacute
   {0x0165, 0x0172}, // # 370 lt210000  tcaron
   {0x0164, 0x0173}, // # 371 lt220000  Tcaron
   {0x0163, 0x0174}, // # 372 lt410000  tcedilla
   {0x0162, 0x0175}, // # 373 lt420000  Tcedilla
   {0x0171, 0x0176}, // # 374 lu250000  uhungarumlaut
   {0x0170, 0x0177}, // # 375 lu260000  Uhungarumlaut
   {0x016F, 0x0178}, // # 376 lu270000  uring
   {0x016E, 0x0179}, // # 377 lu280000  Uring
   {0x017A, 0x017A}, // # 378 lz110000  zacute
   {0x0179, 0x017B}, // # 379 lz120000  Zacute
   {0x017E, 0x017C}, // # 380 lz210000  zcaron
   {0x017D, 0x017D}, // # 381 lz220000  Zcaron
   {0x017C, 0x017E}, // # 382 lz290000  zdotaccent
   {0x017B, 0x017F}, // # 383 lz300000  Zdotaccent
   {0x0401, 0x0180}, // # 384 ke180000  afii10023   Cyrillic Io
   {0x0402, 0x0181}, // # 385 kd620000  afii10051   Cyrillic Dje (Serb)
   {0x0403, 0x0182}, // # 386 kg120000  afii10052   Cyrillic Gje
   {0x0404, 0x0183}, // # 387 ke160000  afii10053   Cyrillic Ukraine
   {0x0405, 0x0184}, // # 388 kz160000  afii10054   Cyrillic Dze
   {0x0406, 0x0185}, // # 389 ki120000  afii10055   Cyrillic Belorus
   {0x0407, 0x0186}, // # 390 ki180000  afii10056   Cyrillic Yi (Ukraine)
   {0x0408, 0x0187}, // # 391 kj020000  afii10057   Cyrillic Je
   {0x0409, 0x0188}, // # 392 kl420000  afii10058   Cyrillic Lje
   {0x040a, 0x0189}, // # 393 kn120000  afii10059   Cyrillic Nje
   {0x040b, 0x018a}, // # 394 kc120000  afii10060   Cyrillic Tshe (Serb)
   {0x040c, 0x018b}, // # 395 kk120000  afii10061   Cyrillic Kje
   {0x040e, 0x018c}, // # 396 ku240000  afii10062   Cyrillic Short u
   {0x040f, 0x018d}, // # 397 kg220000  afii10145   Cyrillic Dzhe
   {0x0410, 0x018e}, // # 398 ka020000  afii10017   Cyrillic A
   {0x0411, 0x018f}, // # 399 kb020000  afii10018   Cyrillic Be
   {0x0412, 0x0190}, // # 400 kv020000  afii10019   Cyrillic Ve
   {0x0413, 0x0191}, // # 401 kg020000  afii10020   Cyrillic Ghe
   {0x0414, 0x0192}, // # 402 kd020000  afii10021   Cyrillic De
   {0x0415, 0x0193}, // # 403 ke020000  afii10022   Cyrillic Ie
   {0x0416, 0x0194}, // # 404 kz220000  afii10024   Cyrillic Zhe
   {0x0417, 0x0195}, // # 405 kz020000  afii10025   Cyrillic Ze
   {0x0418, 0x0196}, // # 406 ki020000  afii10026   Cyrillic I
   {0x0419, 0x0197}, // # 407 kj120000  afii10027   Cyrillic Short i
   {0x041a, 0x0198}, // # 408 kk020000  afii10028   Cyrillic Ka
   {0x041b, 0x0199}, // # 409 kl020000  afii10029   Cyrillic El
   {0x041c, 0x019a}, // # 410 km020000  afii10030   Cyrillic Em
   {0x041d, 0x019b}, // # 411 kn020000  afii10031   Cyrillic En
   {0x041e, 0x019c}, // # 412 ko020000  afii10032   Cyrillic O
   {0x041f, 0x019d}, // # 413 kp020000  afii10033   Cyrillic Pe
   {0x0420, 0x019e}, // # 414 kr020000  afii10034   Cyrillic Er
   {0x0421, 0x019f}, // # 415 ks020000  afii10035   Cyrillic Es
   {0x0422, 0x01a0}, // # 416 kt020000  afii10036   Cyrillic Te
   {0x0423, 0x01a1}, // # 417 ku020000  afii10037   Cyrillic U
   {0x0424, 0x01a2}, // # 418 kf020000  afii10038   Cyrillic Ef
   {0x0425, 0x01a3}, // # 419 kh020000  afii10039   Cyrillic Ha
   {0x0426, 0x01a4}, // # 420 kc020000  afii10040   Cyrillic Tse
   {0x0427, 0x01a5}, // # 421 kc220000  afii10041   Cyrillic Che
   {0x0428, 0x01a6}, // # 422 ks220000  afii10042   Cyrillic Sha
   {0x0429, 0x01a7}, // # 423 ks160000  afii10043   Cyrillic Shcha
   {0x042a, 0x01a8}, // # 424 ku220000  afii10044   Cyrillic Hard sign
   {0x042b, 0x01a9}, // # 425 ky020000  afii10045   Cyrillic Yeru
   {0x042c, 0x01aa}, // # 426 kx120000  afii10046   Cyrillic Soft sign
   {0x042d, 0x01ab}, // # 427 ke140000  afii10047   Cyrillic E
   {0x042e, 0x01ac}, // # 428 ku160000  afii10048   Cyrillic Yu
   {0x042f, 0x01ad}, // # 429 ka160000  afii10049   Cyrillic Ya
   {0x0430, 0x01ae}, // # 430 ka010000  afii10065   Cyrillic a
   {0x0431, 0x01af}, // # 431 kb010000  afii10066   Cyrillic be
   {0x0432, 0x01b0}, // # 432 kv010000  afii10067   Cyrillic ve
   {0x0433, 0x01b1}, // # 433 kg010000  afii10068   Cyrillic ghe
   {0x0434, 0x01b2}, // # 434 kd010000  afii10069   Cyrillic de
   {0x0435, 0x01b3}, // # 435 ke010000  afii10070   Cyrillic ie
   {0x0436, 0x01b4}, // # 436 kz210000  afii10072   Cyrillic zhe
   {0x0437, 0x01b5}, // # 437 kz010000  afii10073   Cyrillic ze
   {0x0438, 0x01b6}, // # 438 ki010000  afii10074   Cyrillic i
   {0x0439, 0x01b7}, // # 439 kj110000  afii10075   Cyrillic short i
   {0x043a, 0x01b8}, // # 440 kk010000  afii10076   Cyrillic ka
   {0x043b, 0x01b9}, // # 441 kl010000  afii10077   Cyrillic el
   {0x043c, 0x01ba}, // # 442 km010000  afii10078   Cyrillic em
   {0x043d, 0x01bb}, // # 443 kn010000  afii10079   Cyrillic en
   {0x043e, 0x01bc}, // # 444 ko010000  afii10080   Cyrillic o
   {0x043f, 0x01bd}, // # 445 kp010000  afii10081   Cyrillic pe
   {0x0440, 0x01be}, // # 446 kr010000  afii10082   Cyrillic er
   {0x0441, 0x01bf}, // # 447 ks010000  afii10083   Cyrillic es
   {0x0442, 0x01c0}, // # 448 kt010000  afii10084   Cyrillic te
   {0x0443, 0x01c1}, // # 449 ku010000  afii10085   Cyrillic u
   {0x0444, 0x01c2}, // # 450 kf010000  afii10086   Cyrillic ef
   {0x0445, 0x01c3}, // # 451 kh010000  afii10087   Cyrillic ha
   {0x0446, 0x01c4}, // # 452 kc010000  afii10088   Cyrillic tse
   {0x0447, 0x01c5}, // # 453 kc210000  afii10089   Cyrillic che
   {0x0448, 0x01c6}, // # 454 ks210000  afii10090   Cyrillic sha
   {0x0449, 0x01c7}, // # 455 ks150000  afii10091   Cyrillic shcha
   {0x044a, 0x01c8}, // # 456 ku210000  afii10092   Cyrillic hard sign
   {0x044b, 0x01c9}, // # 457 ky010000  afii10093   Cyrillic yeru
   {0x044c, 0x01ca}, // # 458 kx110000  afii10094   Cyrillic soft sign
   {0x044d, 0x01cb}, // # 459 ke130000  afii10095   Cyrillic e
   {0x044e, 0x01cc}, // # 460 ku150000  afii10096   Cyrillic yu
   {0x044f, 0x01cd}, // # 461 ka150000  afii10097   Cyrillic ya
   {0x2116, 0x01ce}, // # 462 sm000000  afii61352   No
   {0x0451, 0x01cf}, // # 463 ke170000  afii10071   Cyrillic io
   {0x0452, 0x01d0}, // # 464 kd610000  afii10099   Cyrillic dje (Serb)
   {0x0453, 0x01d1}, // # 465 kg110000  afii10100   Cyrillic gje
   {0x0454, 0x01d2}, // # 466 ke150000  afii10101   Cyrillic Ukrainian ie
   {0x0455, 0x01d3}, // # 467 kz150000  afii10102   Cyrillic dze
   {0x0456, 0x01d4}, // # 468 ki110000  afii10103   Cyrillic Belorus-Ukraine i
   {0x0457, 0x01d5}, // # 469 ki170000  afii10104   Cyrillic yi (Ukrainian)
   {0x0458, 0x01d6}, // # 470 kj010000  afii10105   Cyrillic je
   {0x0459, 0x01d7}, // # 471 kl410000  afii10106   Cyrillic lje
   {0x045a, 0x01d9}, // # 472 kn110000  afii10107   Cyrillic nje
   {0x045b, 0x01da}, // # 473 kc110000  afii10108   Cyrillic tshe (Serb)
   {0x045c, 0x01db}, // # 474 kk110000  afii10109   Cyrillic kje
   {0x045e, 0x01dc}, // # 475 ku230000  afii10110   Cyrillic short u (Belorus)
   {0x045f, 0x01dc}, // # 476 kg210000  afii10193   Cyrillic dzhe
   {0x0490, 0x01dd}, // # 477 kg300000  afii10050   Cyrillic Ghe with upturn
   {0x0491, 0x01de}, // # 478 kg290000  afii10098   Cyrillic ghe with uptupe
   {0x0156, 0x01df}, // # 479 lr420000  Rcedilla
   {0x012e, 0x01e0}, // # 480 li440000  Iogonek
   {0x0100, 0x01e1}, // # 481 la320000  Amacron
   {0x0112, 0x01e2}, // # 482 le320000  Emacron
   {0x0116, 0x01e3}, // # 483 le300000  Edotaccent
   {0x0122, 0x01e4}, // # 484 lg420000  Gcedilla
   {0x0136, 0x01e5}, // # 485 lk420000  Kcedilla
   {0x012a, 0x01e6}, // # 486 li320000  Imacron
   {0x01eb, 0x01e7}, // # 487 ll420000  Lcedilla
   {0x0145, 0x01e8}, // # 488 ln420000  Ncedilla
   {0x014c, 0x01e9}, // # 489 lo320000  Omacron
   {0x0172, 0x01ea}, // # 490 lu440000  Uogonek
   {0x016a, 0x01eb}, // # 491 lu320000  Umacron
   {0x0157, 0x01ec}, // # 492 lr410000  rcedilla
   {0x012f, 0x01ed}, // # 493 li430000  iogonek
   {0x0101, 0x01ee}, // # 494 la310000  amacron
   {0x0113, 0x01ef}, // # 495 le310000  emacron
   {0x0117, 0x01f0}, // # 496 le290000  edotaccent
   {0x0123, 0x01f1}, // # 497 lg410000  gcedilla
   {0x0137, 0x01f2}, // # 498 lk410000  kcedilla
   {0x012b, 0x01f3}, // # 499 li310000  imacron
   {0x013c, 0x01f4}, // # 500 ll410000  lcedilla
   {0x0146, 0x01f5}, // # 501 ln410000  ncedilla
   {0x014d, 0x01f6}, // # 502 lo310000  omacron
   {0x0173, 0x01f7}, // # 503 lu430000  uogonek
   {0x016b, 0x01f8}, // # 504 lu310000  umacron
   {0x303F, 0x0300}, // # 768 sp500000  SP500000
   {0x21B5, 0x0301}, // # 769 sm720000  carriagereturn
   {0x3002, 0x0302}, // # 770 jq700080  periodjapan
   {0x300C, 0x0303}, // # 771 jq730080  leftquotejapan
   {0x300D, 0x0304}, // # 772 jq730080  rightquotejapan
   {0x3001, 0x0305}, // # 773 jq730080  commajapan
   {0x30F2, 0x0307}, // # 775 jw500080  Wokana
   {0x30A1, 0x0308}, // # 776 ja010080  Akanasmall
   {0x30A3, 0x0309}, // # 777 ji010080  Ikanasmall
   {0x30A5, 0x030A}, // # 778 ju010080  Ukanasmall
   {0x30A7, 0x030B}, // # 779 je010080  Ekanasmall
   {0x30A9, 0x030C}, // # 780 jo010080  Okanasmall
   {0x30E3, 0x030D}, // # 781 jy110080  Yakanasmall
   {0x30E5, 0x030E}, // # 782 jy310080  Yukanasmall
   {0x30E7, 0x030F}, // # 783 jy510080  Yokanasmall
   {0x30C3, 0x0310}, // # 784 jt310080  Tukanasmall
   {0x30FC, 0x0311}, // # 785 jx700080  Longsoundkana
   {0x30A2, 0x0312}, // # 786 ja000080  Akana
   {0x30A4, 0x0313}, // # 787 ji000080  Ikana
   {0x30A6, 0x0314}, // # 788 ju000080  Ukana
   {0x30A8, 0x0315}, // # 789 je000080  Ekana
   {0x30AA, 0x0316}, // # 790 jo000080  Okana
   {0x30AB, 0x0317}, // # 791 jk100080  Kakana
   {0x30AD, 0x0318}, // # 792 jk200080  Kikana
   {0x30AF, 0x0319}, // # 793 jk300080  Kukana
   {0x30B1, 0x031A}, // # 794 jk400080  Kekana
   {0x30B3, 0x031B}, // # 795 jk500080  Kokana
   {0x30B5, 0x031C}, // # 796 js100080  Sakana
   {0x30B7, 0x031D}, // # 797 js200080  Sikana
   {0x30B9, 0x031E}, // # 798 js300080  Sukana
   {0x30BB, 0x031F}, // # 799 js400080  Sekana
   {0x30BD, 0x0320}, // # 800 js500080  Sokana
   {0x30BF, 0x0321}, // # 801 jt100080  Takana
   {0x30C1, 0x0322}, // # 802 jt200080  Tikana
   {0x30C4, 0x0323}, // # 803 jt300080  Tukana
   {0x30C6, 0x0324}, // # 804 jt400080  Tekana
   {0x30C8, 0x0325}, // # 805 jt500080  Tokana
   {0x30CA, 0x0326}, // # 806 jn100080  Nakana
   {0x30CB, 0x0327}, // # 807 jn200080  Nikana
   {0x30CC, 0x0328}, // # 808 jn300080  Nukana
   {0x30CD, 0x0329}, // # 809 jn400080  Nekana
   {0x30CE, 0x032A}, // # 810 jn500080  Nokana
   {0x30CF, 0x032B}, // # 811 jh100080  Hakana
   {0x30D2, 0x032C}, // # 812 jh200080  Hikana
   {0x30D5, 0x032D}, // # 813 jh300080  Hukana
   {0x30D8, 0x032E}, // # 814 jh400080  Hekana
   {0x30DB, 0x032F}, // # 815 jh500080  Hokana
   {0x30DE, 0x0330}, // # 816 jm100080  Makana
   {0x30DF, 0x0331}, // # 817 jm200080  Mikana
   {0x30E0, 0x0332}, // # 818 jm300080  Mukana
   {0x30E1, 0x0333}, // # 819 jm400080  Mekana
   {0x30E2, 0x0334}, // # 820 jm500080  Mokana
   {0x30E4, 0x0335}, // # 821 jy100080  Yakana
   {0x30E6, 0x0336}, // # 822 jy300080  Yukana
   {0x30E8, 0x0337}, // # 823 jy500080  Yokana
   {0x30E9, 0x0338}, // # 824 jr100080  Rakana
   {0x30EA, 0x0339}, // # 825 jr200080  Rikana
   {0x30EB, 0x033A}, // # 826 jr300080  Rukana
   {0x30EC, 0x033B}, // # 827 jr400080  Rekana
   {0x30ED, 0x033C}, // # 828 jr500080  Rokana
   {0x30EF, 0x033D}, // # 829 jw100080  Wakana
   {0x30F3, 0x033E}, // # 830 jn000080  Nkana
   {0x309B, 0x033F}, // # 831 jx710080  Voicedjapan
   {0x309C, 0x0340}, // # 832 jx720080  Semivoicedjapan
   {0x3041, 0x0341}, // # 833 ra010000  ahiraganasmall
   {0x3043, 0x0342}, // # 834 ri010000  ihiraganasmall
   {0x3045, 0x0343}, // # 835 ru010000  uhiraganasmall
   {0x3047, 0x0344}, // # 836 re010000  ehiraganasmall
   {0x3049, 0x0345}, // # 837 ro010000  ohiraganasmall
   {0x3083, 0x0346}, // # 838 ry110000  yahiraganasmall
   {0x3085, 0x0347}, // # 839 ry310000  yuhiraganasmall
   {0x3049, 0x0348}, // # 840 ro010000  ohiraganasmall
   {0x3063, 0x0349}, // # 841 rt310000  tuhiraganasmall
   {0x3042, 0x034A}, // # 842 ra000000  ahiragana
   {0x3044, 0x034B}, // # 843 ri000000  ihiragana
   {0x3046, 0x034C}, // # 844 ru000000  uhiragana
   {0x3048, 0x034D}, // # 845 re000000  ehiragana
   {0x304A, 0x034E}, // # 846 ro000000  ohiragana
   {0x304B, 0x034F}, // # 847 rk100000  kahiragana
   {0x304D, 0x0350}, // # 848 rk200000  kihiragana
   {0x304F, 0x0351}, // # 849 rk300000  kuhiragana
   {0x3051, 0x0352}, // # 850 rk400000  kehiragana
   {0x3053, 0x0353}, // # 851 rk500000  kohiragana
   {0x3055, 0x0354}, // # 852 rs100000  sahiragana
   {0x3057, 0x0355}, // # 853 rs200000  sihiragana
   {0x3059, 0x0356}, // # 854 rs300000  suhiragana
   {0x305B, 0x0357}, // # 855 rs400000  sehiragana
   {0x305D, 0x0358}, // # 856 rs500000  sohiragana
   {0x305F, 0x0359}, // # 857 rt100000  tahiragana
   {0x3061, 0x035A}, // # 858 rt200000  tihiragana
   {0x3064, 0x035B}, // # 859 rt300000  tuhiragana
   {0x3066, 0x035C}, // # 860 rt400000  tehiragana
   {0x3068, 0x035D}, // # 861 rt500000  tohiragana
   {0x306A, 0x035E}, // # 862 rn100000  nahiragana
   {0x306B, 0x035F}, // # 863 rn200000  nihiragana
   {0x306C, 0x0360}, // # 864 rn300000  nuhiragana
   {0x306D, 0x0361}, // # 865 rn400000  nehiragana
   {0x306E, 0x0362}, // # 866 rn500000  nohiragana
   {0x306F, 0x0363}, // # 867 rh100000  hahiragana
   {0x3072, 0x0364}, // # 868 rh200000  hihiragana
   {0x3075, 0x0365}, // # 869 rh300000  huhiragana
   {0x3078, 0x0366}, // # 870 rh400000  hehiragana
   {0x307B, 0x0367}, // # 871 rh500000  hohiragana
   {0x307E, 0x0368}, // # 872 rm100000  mahiragana
   {0x307F, 0x0369}, // # 873 rm200000  mihiragana
   {0x3080, 0x036A}, // # 874 rm300000  muhiragana
   {0x3081, 0x036B}, // # 875 rm400000  mehiragana
   {0x3082, 0x036C}, // # 876 rm500000  mohiragana
   {0x3084, 0x036D}, // # 877 ry100000  yahiragana
   {0x3086, 0x036E}, // # 878 ry300000  yuhiragana
   {0x3088, 0x036F}, // # 879 ry500000  yohiragana
   {0x3089, 0x0370}, // # 880 rr100000  rahiragana
   {0x308A, 0x0371}, // # 881 rr200000  rihiragana
   {0x308B, 0x0372}, // # 882 rr300000  ruhiragana
   {0x308C, 0x0373}, // # 883 rr400000  rehiragana
   {0x308D, 0x0374}, // # 884 rr500000  rohiragana
   {0x308F, 0x0375}, // # 885 rw100000  wahiragana
   {0x3092, 0x0376}, // # 886 rw500000  wohiragana
   {0x3093, 0x0377}, // # 887 rn000000  nhiragana
   {0x300E, 0x0378}, // # 888 jq710001  leftquoteopenjapan
   {0x300F, 0x0379}, // # 889 jq720001  rightquoteopenjapan
   {0x30F6, 0x037A}, // # 890 jk410000  kekanasmall
   {0x3005, 0x037B}, // # 891 ss770000  iterate
   {0x3131, 0x0380}, // # 896 og000080  Giyeog
   {0x3132, 0x0381}, // # 897 og100080  Ssanggiyeog
   {0x3133, 0x0382}, // # 898 og200080  Giyeogsios
   {0x3134, 0x0383}, // # 899 on000080  Nieun
   {0x3135, 0x0384}, // # 900 on150080  Nieunjieuj
   {0x3136, 0x0385}, // # 901 on100080  Nieunhieuh
   {0x3137, 0x0386}, // # 902 od000080  Digeud
   {0x3138, 0x0387}, // # 903 od100080  Ssangdigeud
   {0x3139, 0x0388}, // # 904 ol000080  Lieul
   {0x313A, 0x0389}, // # 905 ol200080  Lieulgiyeog
   {0x313B, 0x038A}, // # 906 ol400080  Lieulmieum
   {0x313C, 0x038B}, // # 907 ol100080  Lieulbieub
   {0x313D, 0x038C}, // # 908 ol600080  Lieulsios
   {0x313E, 0x038D}, // # 909 ol700080  Lieultieut
   {0x313F, 0x038E}, // # 910 ol500080  Lieulpieup
   {0x3140, 0x038F}, // # 911 ol300080  Lieulhieuh
   {0x3141, 0x0390}, // # 912 om000080  Mieum
   {0x3142, 0x0391}, // # 913 ob000080  Bieub
   {0x3143, 0x0392}, // # 914 ob100080  Ssangbieub
   {0x3144, 0x0393}, // # 915 ob200080  Bieubsios
   {0x3145, 0x0394}, // # 916 os000080  Sios
   {0x3146, 0x0395}, // # 917 os100080  Ssangsios
   {0x3147, 0x0396}, // # 918 on200080  Ieung
   {0x3148, 0x0397}, // # 919 oj000080  Jieuj
   {0x3149, 0x0398}, // # 920 oj100080  Ssangjieuj
   {0x314A, 0x0399}, // # 921 oc200080  Cieuc
   {0x314B, 0x039A}, // # 922 ok000080  Kiyeok
   {0x314C, 0x039B}, // # 923 ot000080  Tieut
   {0x314D, 0x039C}, // # 924 op000080  Pieup
   {0x314E, 0x039D}, // # 925 oh000080  Hieuh
   {0x314F, 0x039E}, // # 926 oa000080  Ahangul
   {0x3150, 0x039F}, // # 927 oa200080  Aehangul
   {0x3151, 0x03A0}, // # 928 oy200080  Yahangul
   {0x3152, 0x03A1}, // # 929 oy250080  Yaehangul
   {0x3153, 0x03A2}, // # 930 oe200080  Eohangul
   {0x3154, 0x03A3}, // # 931 oe000080  Ehangul
   {0x3155, 0x03A4}, // # 932 oy400080  Yeohangul
   {0x3156, 0x03A5}, // # 933 oy300080  Yehangul
   {0x3157, 0x03A6}, // # 934 oo000080  Ohangul
   {0x3158, 0x03A7}, // # 935 oo100080  Wahangul
   {0x3159, 0x03A8}, // # 936 oo200080  Waehangul
   {0x315A, 0x03A9}, // # 937 oo300080  Oehangul
   {0x315B, 0x03AA}, // # 938 oy500080  Yohangul
   {0x315C, 0x03AB}, // # 939 ou000080  Uhangul
   {0x315D, 0x03AC}, // # 940 ou300080  Weohangul
   {0x315E, 0x03AD}, // # 941 ou200080  Wehangul
   {0x315F, 0x03AE}, // # 942 ou400080  Wihangul
   {0x3160, 0x03AF}, // # 943 oy600080  Yuhangul
   {0x3161, 0x03B0}, // # 944 oe300080  Euhangul
   {0x3162, 0x03B1}, // # 945 oe400080  Yihangul
   {0x3163, 0x03B2}, // # 946 oi000080  Ihangul
   {0x20A9, 0x03B3}, // # 947 sc140000  Won
   {0x3164, 0x03B5}  // # 949 sp490080  Caeomhangul
};

USHORT
UGLToUnicode (USHORT usUGL)
{
   INT iLow  = 0;
   INT iMid  = dimof (vaUGLToUnicode) / 2;
   INT iHigh = dimof (vaUGLToUnicode) - 1;

   while (iLow <= iHigh)
   {
      if (usUGL == vaUGLToUnicode[iMid].usUGL)
      {
         return vaUGLToUnicode[iMid].usUnicode;
      }
      else if (usUGL < vaUGLToUnicode[iMid].usUGL)
      {
         iHigh = iMid - 1;
         iMid  = iLow + (iHigh - iLow) / 2;
      }
      else // (usUGL > vaUGLToUnicode[iMid].usUGL)
      {
         iLow  = iMid + 1;
         iMid  = iLow + (iHigh - iLow) / 2;
      }
   }

   return 0xFFFF; // Error!
}

/***********************************************************************
 *
 * FUNCTION NAME = OmniBookletEnabled()
 *
 *
 * DESCRIPTION   = Checks the booklet printing is enabled
 *
 *
 * INPUT         = HTHREAD hThread   Second output thread handle
 *
 * OUTPUT        = TRUE if booklet is enabled, else FALSE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **********************************************************************/

BOOL OmniBookletEnabled( PDDC pddc )

{
  BOOL   bEnabled;

  if (bEnabled = ((pddc->pdb->ulNupPages == 2) &&
                  GplBookletEnabled(pddc->pdb->hThread)))
  {
     //
     // LargeFormInfo has incorrect data after QueryHardcopyCaps() calling
     //
     if (pddc->pdb->pLargeFormInfo->ulFormID != pddc->pdb->pFormInfo->ulFormID)
     {
         GetDefaultFormInfo (pddc->pdb,
                             pddc->pdb->pFormInfo->ulFormID,
                             pddc->pdb->pJobProperties->ulDefResID,
                             pddc->pdb->pFormInfo);
     }
  }

  return bEnabled;
}

// begin @JPN2H99
/****************************************************************************/
/* PROCEDURE NAME : DrawIcon                                                */
/* AUTHOR         : Y.Shih                                                  */
/* DATE WRITTEN   : 07/13/98                                                */
/* DESCRIPTION    :                                                         */
/*                                                                          */
/* PARAMETERS:                                                              */
/*                                                                          */
/* RETURN VALUES:   None.                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID DrawIcon( HWND hwnd, HPOINTER hptrIcon, ULONG ulTargetId, ULONG ulIconId)
{
   if( hptrIcon)
   {
      // Release Icon resource
      WinDestroyPointer( hptrIcon);
   }

   hptrIcon = WinLoadPointer( HWND_DESKTOP, globals.hModule, ulIconId);
   SetIconInDialog( hwnd, hptrIcon, ulTargetId);
}
// end @JPN2H99
