/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// clrtable.c

#define INCL_DOS
#define INCL_PM
#define INCL_GPI
#include <os2.h>

#define INCL_DDICOMFLAGS
#define INCL_DDIMISC
#define INCL_GRE_COLORTABLE
// @DBCS
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

// c includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define INCL_INNER_GRE
#include "def.h"
#include "driver.h"
#include "funcs.h"

// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY CreateLogColorTable(      HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lFormat,
                                        LONG           lStart,
                                        LONG           cCount,
                                        PLONG          pData,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  assertT (flOptions & LCOL_SYSCOLORS);

  if (LCOLF_RGB == lFormat)
     pddc->bLCTFormat = LCTF_RGB;
  else if (LCOLF_CONSECRGB == lFormat)
     pddc->bLCTFormat = LCTF_CONSECRGB;
  else
     pddc->bLCTFormat = LCTF_INDRGB;

  pddc->ulLCTOptions = 0;
  if (flOptions & LCOL_REALIZABLE)
     pddc->ulLCTOptions |= LCTO_REALIZABLE;

  if (flOptions & LCOL_PURECOLOR)
     pddc->ulLCTOptions |= LCTO_PURECOLOR;

  lrc = InnerGreCreateLogColorTable( pddc->hdcShadow, flOptions, lFormat, lStart, cCount, pData, ulFunction );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryColorData(           HDC            hdc,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = GreQueryColorData( pddc->hdcShadow, cArray, pArray );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}




// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryColorIndex(          HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           rgbColor,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ALTERROR;
    goto depart;
  }
  ENTERDDC( pddc );


  lrc = InnerGreQueryColorIndex( pddc->hdcShadow, flOptions, rgbColor, ulFunction );
  assert( lrc != GPI_ALTERROR );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}





// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryLogColorTable(       HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lStart,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = GreQueryLogColorTable( pddc->hdcShadow, flOptions, lStart, cArray, pArray );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}





// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryNearestColor(        HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           rgbColorin,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ALTERROR;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = InnerGreQueryNearestColor( pddc->hdcShadow, flOptions, rgbColorin, ulFunction );
  assert( lrc != GPI_ALTERROR );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}






// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryRealColors(          HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lStart,
                                        LONG           cArray,
                                        PLONG          pArray,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ALTERROR;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = InnerGreQueryRealColors( pddc->hdcShadow, flOptions, lStart, cArray, pArray, ulFunction );
  assert( lrc != GPI_ALTERROR );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY QueryRGBColor(            HDC            hdc,
                                        ULONG          flOptions,
                                        LONG           lColor,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = GPI_ALTERROR;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = InnerGreQueryRGBColor( pddc->hdcShadow, flOptions, lColor, ulFunction );
  assert( lrc != GPI_ALTERROR );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY RealizeColorTable(        HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = InnerGreRealizeColorTable( pddc->hdcShadow, ulFunction );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}



// ------------------------------------------------------------------------------------------------------------------
LONG ENGENTRY UnrealizeColorTable(      HDC            hdc,
                                        PDDC           pddc,
                                        ULONG          ulFunction )
{
  REGREC      regrec;
  ULONG       ulException;
  LONG        lrc;


  REGISTERHANDLER (regrec, globals.hModule);
  ulException = setjmp( regrec.jmp );
  if( ulException ) {
    // clean up here
    assertstring ("Exception occured!\n");
    CheckForTermination( &regrec, ulException, pddc );
    // error result
    lrc = FALSE;
    goto depart;
  }
  ENTERDDC( pddc );

  lrc = InnerGreUnrealizeColorTable( pddc->hdcShadow, ulFunction );
  assert( lrc );

depart:
  EXITDDC( pddc );
  UNREGISTERHANDLER( regrec );
  return lrc;
}

