/* REXX: BandView host_name[:port_number]
*/

szApp = "BandView"
szKey = "Place"

call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'

if length( arg( 1 ) ) = 0 then
   signal usage;

parse arg szArg .

if szArg == "DELETE:" then
   szVal = 'DELETE:'
else
   szVal = szArg || '00'x

call SysIni 'SYSTEM', szApp, szKey, szVal

say "Result = " '"'Result'"'

exit

usage:

say "Usage: BandView hostName[:port_number]  Ex: BandSize ibm.com:4321"
say ""
say "       A value of DELETE: will delete the ini file entry."

/* Query the current value */
szValue =  SysIni( 'SYSTEM', szApp, szKey )

/* get rid of the terminating null character */
szValue = strip( translate( szValue, ' ', '0'x ) )

if szValue == '' | szValue == "ERROR:" then
   szResult = "nothing!"
else
   szResult = szValue

say
say "The current band size is set to" szResult
exit
