/* REXX: Assert [ON | OFF]
*/

call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
call SysIni 'SYSTEM', szApp, szKey, szVal

if length( arg( 1 ) ) = 0 then
   signal usage

parse arg szParm1 .

szParm1 = translate( szParm1 )

if szParm1 \= "ON"     &  ,
   szParm1 \= "OFF"    &  ,
   szParm1 \= "DELETE" then
   signal usage;

if szParm1 = "ON" then
   szVal = "1" || '00'x /**/ || '00'x || '00'x /**/

if szParm1 = "OFF" then
   szVal = "0" || '00'x /**/ || '00'x || '00'x /**/

if szParm1 = "DELETE" then
   szVal = "DELETE:"

szApp = "OMNIDriver"
szKey = "Assert"

szValue =  SysIni( 'SYSTEM', szApp, szKey, szVal )
say "Result = " '"'Result'"'

results:

/* Query the current value */
szApp   = "OMNIDriver"
szKey   = "Assert"
szValue = SysIni( 'SYSTEM', szApp, szKey )

/* get rid of the terminating null character */
szValue = strip( translate( szValue, ' ', '0'x ) )

if      szValue = "0" then szValue = "OFF"
else if szValue = "1" then szValue = "ON"
else if szValue = ""  then szValue = "<does not exist>"

say "Assert is currently" szValue

exit

usage:

say "Usage: Assert [ON | OFF | DELETE]"
say

signal results
