/* setea.cmd: sets extended attributes on the DRV file */

parse upper arg szBaseName .

if length( szBaseName ) = 0 then do
  say 'Expected driver path and file name on command line but'
  say 'without the extension.'
  exit 3
end

if 0 < pos( '.', szBaseName ) then do
  say 'Give driver path and name, but do not give extension.'
  exit 3
end

szDriver  = right( szBaseName, length( szBaseName ) - lastpos('\', szBaseName ))
szDRVName = szBaseName'.DRV'

'ea -e REQUIREDDRIVERFILES='szDriver'.DRV'     szDRVName
'ea -e OPTIONALDRIVERFILES='szDriver'.SYM'     szDRVName


/* DRVNAMES loads the driver and calls OS2_PM_DEVICENAMES to get the names
of all the devices supported by the driver. Then it takes the list of names
and attaches them as an extended attribute, .EXPAND,  to the DRV file. */

'drvnames' szBaseName
if rc > 0 then do
  say 'RC' rc 'from DRVNAMES utility. Please copy DRVNAMES.EXE into your path.'
  exit 3
end

exit 0
