/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* PROGRAM NAME   : Font Tester Paint routine                               */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* FILENAME       : PAINT.C (new 32-bit version)                            */
/* DATE WRITTEN   : 8-04-92                                                 */
/* DESCRIPTION    : Font Tester uses this routine to paint the client       */
/*                  window in response to WM_PAINT message.                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* @DBCS    -          - DBCS enabling Tag                                  */
/*                                                                          */
/* @MAXLINE - 11/02/93 - Matt Rutkowski [IBM] - Allows browse and print of  */
/*                       huge files where previously files upto 6000 lines  */
/*                       were only allowed.                                 */
/*                                                                          */
/*                       Added 2 new special keys:                          */
/*                       CTRL-PAGEUP   - Browse top of file                 */
/*                       CTRL-PAGEDOWN - Browse bottom of file              */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#define INCL_DEV
#define INCL_GPI
#include <os2.h>
#include <stdlib.h>
#include "ft32.h"

/*------------------------------------------------------*/
/* external globals                                     */
/*------------------------------------------------------*/
// DBCS enable
extern ULONG      CodePage;
extern CHAR       DbcsEnv[256];
// DBCS enable

/*------------------------------------------------------*/
/* prototypes                                           */
/*------------------------------------------------------*/
VOID   PaintClientWindow ( HPS, LONG, HWND, PRECTL );

/****************************************************************************/
/* PROCEDURE NAME : PaintClientWindow                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 8/4/92                                                  */
/* DESCRIPTION    :                                                         */
/* This function performs the drawing of text lines for Fontest.            */
/* It firsts sets the specified text color and then calculates which        */
/* lines fall within the invalid rectangle passed as a parameter.           */
/*                                                                          */
/*                  Control Flow:                                           */
/*                  (a) WinQueryWindowRect(); to get client window size     */
/*                  (b) Move to starting position of first text line to     */
/*                      display in client window                            */
/*                  (c) Adjust scrollbars to make sure we don't             */
/*                      draw beyond end of the text file                    */
/*                  (d) GpiSetColor(); for the text color                   */
/*                  (e) loop through all lines of text file that will       */
/*                      be used to paint the client window                  */
/*                  (f) GpiCharStringAt(); aech of the text lines           */
/*                                                                          */
/*                                                                          */
/* PARAMETERS:      (HPS)    hps   - Presentation Space handle where we are */
/*                                   drawing to.                            */
/*                  (LONG)   color - color to make test                     */
/*                  (HWND)   hwnd  - caller's window handle                 */
/*                  (PRECTL) rc    - client window rectangle (invalidated)  */
/*                                                                          */
/* RETURN VALUES:   None                                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/****************************************************************************/
VOID PaintClientWindow ( HPS hps, LONG color, HWND hwnd, PRECTL rc )
{
  USHORT     length;         /* length of current line */
  CHAR FAR  *temp;           /* temporary pointer */
  CHAR FAR  *str;            /*  "           "    */
  USHORT     i;
  CHAR       str1 [MAX_CHAR_PER_LINE+1];     /* we make copy of each line */
  POINTL     ptPaint;
  RECTL      rcWin;          // describes window rectangle
  LONG       lTopline;       // index of top paint line
  LONG       lBottomline;    // index of bottom paint line

  // retrieve the size of the entire window and use the top left
  // corner less the font height for our initial paint coordinates
  WinQueryWindowRect ( hwnd, &rcWin );

  ptPaint.x = rcWin.xLeft - (lHscrollPos*cxChar);
  ptPaint.y = (rcWin.yTop - cyChar) + cyDesc;

  // calculate the index of the top text line in the invalid rectangle
  // rcWin covers entire window, rc covers invalid rectangle
  lTopline =  rcWin.yTop - rc->yTop;  // @MAXLINE
  lTopline /= cyChar;
  lTopline += lVscrollPos;

  // Make sure scrollbars never go negative
  if ( lTopline < 0 )
  { lTopline = 0;
    lVscrollPos = 0;
  } /* end if */

  // calculate the index of the bottom line in the invalid rectangle
  // increment the result to account for rounding error
  lBottomline = rc->yTop - rc->yBottom;  // @MAXLINE
  lBottomline /= cyChar;
  lBottomline += lTopline + 1;

  // Make sure scrollbars never go negative or less than top
  if ( lBottomline < 1 )
  { lBottomline = 1;
  } /* end if */

  // @MAXLINES
  if ( lBottomline > ulTotalLines )
  {
    lBottomline = ulTotalLines-1;
  } /* end if */

  // adjust the bottom line if the invalid rectangle holds more
  // lines than we have to display
  lBottomline = min ( lBottomline, ulTotalLines-1L );

  // calculate the y-pixel coordinate of the first line
  // in the invalid rectangle
  ptPaint.y -= (lTopline-lVscrollPos) * cyChar;

  // Set the foreground (text) color
  GpiSetColor( hps, color );

  // loop through and display all of the lines in invalid rectangle
  for ( ; lTopline <= lBottomline; lTopline++ )
  {
    temp = pLinePtrs [lTopline];
    str = str1;
    *str = '\0';

// DBCS enable
    /* replace tab characters with eight spaces */
    for ( length = 0 ;
          (*temp != '\n') && ( length <= MAX_CHAR_PER_LINE );
          temp += CHARSIZE(*temp) )
    {
      if ( *temp == '\t' )
      {
        for ( i=0 ; i < 8 ; i ++ )
            *str ++ = ' ';
        length += 7;

      } /* end if */
      else
      {
        if (CHARSIZE(*temp) == SIZEDBCS)
        {
           *((PUSHORT)str) = *(PUSHORT)temp;
           str += SIZEDBCS;
           length++;

        } /* end if */
        else
           *str ++ = *temp;
      } /* end else */

      length ++;

    } /* end for */
// DBCS enable

    // remove line-end characters
    if ( *(str-1) == 0xd )
       length --;

    // display the current line and move to the next row
    GpiCharStringAt ( hps, &ptPaint, (LONG)length , (PSZ) str1 );
    ptPaint.y -= cyChar;

  } /* end for */

} /* end PaintClientWindow */

