/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : FTHELP.H                                                */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 03-07-95                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used for Font Test IPF help.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

#ifdef DEBUG
// Show panel IDs for debug version
#define SHOW_HELP_PANEL_IDS   CMIC_SHOW_PANEL_ID
#else
// Hide panel IDs for retail version
#define SHOW_HELP_PANEL_IDS   CMIC_HIDE_PANEL_ID
#endif

/*************************************/
/* IPF Help Subtables IDs            */
/*************************************/

#define SUBTABLE_FONTEST          2000

/*************************************/
/*    Menu/SubMenu Panels IDs        */
/*************************************/

// "File" submenu help panels
#define PANEL_MENU_FILE           2100
#define PANEL_MENU_FILE_OPEN      2101
#define PANEL_MENU_FILE_SETTINGS  2102
#define PANEL_MENU_FILE_DEFAULTS  2103
#define PANEL_MENU_FILE_PRINT     2104

// "Query" submenu help panels
#define PANEL_MENU_QUERY          2150
#define PANEL_MENU_QUERY_CAPS     2151
#define PANEL_MENU_QUERY_HCCAPS   2152
#define PANEL_MENU_QUERY_METRICS  2153
#define PANEL_MENU_QUERY_FNTWDTH  2154
#define PANEL_MENU_QUERY_FNTKERN  2155

// "Search" submenu help panels
#define PANEL_MENU_SEARCH         2200
#define PANEL_MENU_SEARCH_TEXT    2201

// "Help" submenu help panels
#define PANEL_MENU_HELP           2250
#define PANEL_MENU_USING_HELP     2251
#define PANEL_MENU_HELP_INDEX     2252
#define PANEL_MENU_EXT_HELP       2253
#define PANEL_MENU_KEYS_HELP      2254
#define PANEL_MENU_HELP_ABOUT     2255

/*************************************/
/*   Dialogs/Controls Panels IDs     */
/*************************************/

// Font Test main help panel (extended Help)
#define PANEL_FONTEST_HELP        2300
#define PANEL_FONTEST_EXAMPLES    2301

// "File Open" dialog and controls
#define PANEL_DLG_FILE            2400
#define PANEL_DLG_FILE_NAME       2401
#define PANEL_DLG_FILE_OPEN       2402
#define PANEL_DLG_FILE_CANCEL     2403

// "Program Settings" dialog and controls
#define PANEL_DLG_SETTINGS        2500
#define PANEL_DLG_SETTINGS_OK     2501
#define PANEL_DLG_SETTINGS_SAVE   2502
#define PANEL_DLG_SETTINGS_CANCEL 2503

// "Print Queue" dialog and controls
#define PANEL_DLG_QUEUE           2600
#define PANEL_DLG_QUEUE_LIST      2601
#define PANEL_DLG_QUEUE_JOB_PROP  2602
#define PANEL_DLG_QUEUE_OTHER     2603
#define PANEL_DLG_QUEUE_DRIVER    2604
#define PANEL_DLG_QUEUE_DEVICE    2605

// "Other Destination" dialog
#define PANEL_DLG_OTHER           2650
#define PANEL_DLG_OTHER_NAME      2651
#define PANEL_DLG_OTHER_OK        2652
#define PANEL_DLG_OTHER_CANCEL    2653

// "Font" dialog and controls
#define PANEL_DLG_FONT            2700
#define PANEL_DLG_FONT_LIST       2701
#define PANEL_DLG_FONT_ATTRIB     2702
#define PANEL_DLG_FONT_ITALIC     2703
#define PANEL_DLG_FONT_UNDERLINE  2704
#define PANEL_DLG_FONT_STRIKEOUT  2705
#define PANEL_DLG_FONT_BOLD       2706
#define PANEL_DLG_FONT_METRICS    2707
#define PANEL_DLG_FONT_POINTSIZE  2708
#define PANEL_DLG_FONT_SCALABLE   2709
#define PANEL_DLG_FONT_FIXED      2710
#define PANEL_DLG_FONT_TYPE       2711
#define PANEL_DLG_FONT_SAMPLE     2712

// "Colors" notebook page dialog and controls
#define PANEL_DLG_COLORS          2800
#define PANEL_DLG_COLORS_ITEMS    2801
#define PANEL_DLG_COLORS_PALETTE  2802

// "Format" notebook page dialog and controls
#define PANEL_DLG_FORMAT          2900
#define PANEL_DLG_FORMAT_LIST     2901
#define PANEL_DLG_FORMAT_CHARBOX  2902
#define PANEL_DLG_FORMAT_DATE     2903
#define PANEL_DLG_FORMAT_TIME     2904
#define PANEL_DLG_FORMAT_2UP      2905
#define PANEL_DLG_FORMAT_FILENAME 2906
#define PANEL_DLG_FORMAT_PAGENUM  2907
#define PANEL_DLG_FORMAT_BORDER   2908
#define PANEL_DLG_FORMAT_LINE     2909  // @74644
#define PANEL_DLG_FORMAT_TITLE    2910  // @TTTTT
#define PANEL_DLG_FORMAT_TTEXT    2911
#define PANEL_DLG_FORMAT_ALIGN    2912

// "DevQueryCaps" results dialog
#define PANEL_DLG_CAPS            3000
#define PANEL_DLG_CAPS_DONE       3001

// "DevQueryHardcopyCaps" results dialog
#define PANEL_DLG_HARDCOPY        3100
#define PANEL_DLG_HARDCOPY_DONE   3101

// "GpiQueryFontmetrics" results dialog
#define PANEL_DLG_FNTMETRIC       3200
#define PANEL_DLG_FNTMETRIC_DONE  3201

// "GpiQueryWidthTable" results dialog
#define PANEL_DLG_FNTWDTH         3300
#define PANEL_DLG_FNTWDTH_DONE    3301

// "GpiQueryKerningPairs" results dialog
#define PANEL_DLG_FNTKERN         3400
#define PANEL_DLG_FNTKERN_DONE    3401

// "Search for Text" dialog
#define PANEL_DLG_SEARCH          3500
#define PANEL_DLG_SEARCH_STRING   3501
#define PANEL_DLG_SEARCH_CASE     3502
#define PANEL_DLG_SEARCH_CANCEL   3503
#define PANEL_DLG_SEARCH_SEARCH   3504

// "Confirm Print Information" dialog
#define PANEL_DLG_CONFIRM         3600
#define PANEL_DLG_CONFIRM_FILE    3601
#define PANEL_DLG_CONFIRM_QDESC   3602
#define PANEL_DLG_CONFIRM_QNAME   3603
#define PANEL_DLG_CONFIRM_DRIVER  3604
#define PANEL_DLG_CONFIRM_DEVICE  3605
#define PANEL_DLG_CONFIRM_FONT    3606
#define PANEL_DLG_CONFIRM_PSIZE   3607
#define PANEL_DLG_CONFIRM_REVIEW  3608
#define PANEL_DLG_CONFIRM_OK      3609
#define PANEL_DLG_CONFIRM_CANCEL  3610

// "Help" dialogs
#define PANEL_HELP_USING          3800
#define PANEL_HELP_EXTENDED       3801
#define PANEL_HELP_KEYS           3802
#define PANEL_HELP_JOB_PROPERTIES 3803

