/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* PROGRAM NAME   : Font Test Font Query/Dialog Functions                   */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* FILENAME       : FTFONT.C                                                */
/* DATE WRITTEN   : 02-29-95                                                */
/* DESCRIPTION    : This module contains functions that help access         */
/*                  OS/2 Fonts (system and Device) and query/show           */
/*                  their characteristics.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

#define INCL_DEV
#define INCL_DOSFILEMGR
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_ERRORS
#define INCL_GPI
#define INCL_GPIERRORS
#define INCL_SPL
#define INCL_SPLDOSPRINT
#define INCL_WIN

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>

#include "ft32.h"
#include "ftdlg.h"

BOOL   FillFaceNameListBox( HWND, PPGMDATA, PFONTDATA );
VOID   FillFontMetricsListBox( HWND, ULONG, PFONTMETRICS, SHORT *, SHORT * );

/****************************************************************************/
/* PROCEDURE NAME : FillFaceNameListBox                                     */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 7/8/91                                                  */
/* DESCRIPTION    : Uses font info already returned from GpiQueryFonts      */
/*                  to enumerate all public font facenames known in the     */
/*                  system in a listbox.                                    */
/*                  This procedure attempts to interpret the fontmetrics    */
/*                  data for the user so they don't have to look it up in   */
/*                  an OS/2 programming reference book.                     */
/*                                                                          */
/*                  Control Flow:                                           */
/*                  (a) Loop THROUGH each entry in the (FONTMETRICS) list   */
/*                      returned from GpiQueryFonts(); and insert each      */
/*                      font's facename into a listbox.                     */
/*                                                                          */
/*                  (b) compare each facename/lMatch value against one      */
/*                      selected by user and passed in and if found return  */
/*                      the index into the (FONTMETRICS) list.              */
/*                                                                          */
/*                                                                          */
/* PARAMETERS:      (HWND)    hwnd          - caller's window handle        */
/*                  (LONG)    lMatchIn      - Font lMatch selected by user  */
/*                  (PSZ)     pszFaceNameIn - Font FaceName selected by user*/
/*                  (PUSHORT) pusMatchIndex - Index of selected font in     */
/*                                            the (FONTMETRICS) list.       */
/*                  (LONG)    lTotalFonts   - Number of fonts in            */
/*                                            (FONTMETRICS) list.           */
/*                                                                          */
/* RETURN VALUES:   (BOOL)    bMatchFound  == TRUE  - matching font found   */
/*                                            FALSE - no match found        */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* @LBOX - 11/09/93 - Matt [IBM] - used listbox item handles to hold lMatch */
/*                                                                          */
/****************************************************************************/
BOOL FillFaceNameListBox( HWND     hwnd,
                          PPGMDATA ppd,
                          PFONTDATA pfd )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  LONG   i;                       // Loop control for enum. fonts
  BOOL   bMatchFound = FALSE;     // Indicate if match is found
  SHORT  sIdx;                    // @LBOX
  BOOL   bDefaultlMatch = FALSE;  // @LBOX

  PFONTMETRICS  pfm;
  PPRINTERDATA  prd;
  HWND   hwndLB = WinWindowFromID( hwnd, IDL_FACENAME );
  USHORT usMatchIndex;

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  // Reset facename listbox
  WinSendDlgItemMsg( hwnd, IDL_FACENAME, LM_DELETEALL, NULL, NULL );

  prd = &(ppd->PrinterData);
  pfm = prd->pFontMetrics;

  if( pfd->fm.lMatch == FT_DEFAULT_LMATCH )
  {
    bDefaultlMatch = TRUE;

  } /* end if */

  // set default facename index to first in list
  usMatchIndex = 0;

  // While we still have fonts
  for( i = 0; i < prd->lNumFonts; i++ )
  {
    // Display font facenames in listbox
    sIdx = (SHORT)WinInsertLboxItem( hwndLB, LIT_END, pfm[i].szFacename );

    // @LBOX - Set Item Handle to be a pointer to its fontmetrics struc
    WinSendDlgItemMsg( hwnd,
                       IDL_FACENAME,
                       LM_SETITEMHANDLE,
                       MPFROMSHORT( sIdx ),
                       MPFROMP ( &pfm[i] ) );

    // we have not yet found a matching font to highlite
    if( !bMatchFound )
    {
       //----------------------------------------
       // lMatch - Passed 1st match criteria
       //----------------------------------------
       if( pfd->fm.lMatch == pfm[i].lMatch || bDefaultlMatch )
       {
         //----------------------------------------
         // FaceName - Passed 2nd match criteria
         //----------------------------------------
         if( strcmp( pfd->fm.szFacename, pfm[i].szFacename ) == 0 )
         {
           // Remember listbox index of font Facename we matched
           // for later highlite
           usMatchIndex = sIdx;
           bMatchFound    = TRUE;

           // @TBD - make assert if default lMatch and default font name

         } /* end if */

       } /* end if */

    } /* end if */

  } /* end for */

  // Tell ourselves to change font
  WinSendDlgItemMsg( hwnd,
                     IDL_FACENAME,
                     LM_SELECTITEM,
                     MPFROMSHORT( usMatchIndex ),
                     MPFROMSHORT((SHORT)TRUE));

  return( bMatchFound );

} /* end FillFaceNameListBox */


/****************************************************************************/
/* PROCEDURE NAME : FillFontMetricsListBox                                  */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 7/8/91                                                  */
/* DESCRIPTION    : Uses font info already returned from GpiQueryFonts      */
/*                  to display fontmetric for a selected font in a listbox. */
/*                                                                          */
/*                  Control Flow:                                           */
/*                  (a) Clear out font metric information listbox           */
/*                  (b) Interpret each field of the (FONTMETRIC) structure  */
/*                      at index 'i' of the list returned by                */
/*                      GpiQueryFonts(); an insert interpreted data into    */
/*                      a listbox.                                          */
/*                                                                          */
/* PARAMETERS:      (HWND)    hwnd         - caller's window handle         */
/*                  (USHORT)  i            - Index into (FONTMETRICS) list  */
/*                                           for font whose metrics this    */
/*                                           function will display          */
/*                  (SHORT *) MinPointSize - Minimum point size of indexed  */
/*                                           font.                          */
/*                  (SHORT *) MaxPointSize - Maximum point size of indexed  */
/*                                           font.                          */
/*                                                                          */
/* RETURN VALUES:   None                                                    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
VOID FillFontMetricsListBox( HWND   hwnd,
                             ULONG  ulLBoxID,
                             PFONTMETRICS pfm,
                             SHORT *MinPointSize,
                             SHORT *MaxPointSize )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  CHAR szBuffer[MAXSTR];
  HWND hwndLB = WinWindowFromID( hwnd, ulLBoxID );

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/
  WinSendDlgItemMsg( hwnd, ulLBoxID, LM_DELETEALL, NULL, NULL );

  /*------------------------------------------------------*/
  /* Facename                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "Facename = %s", pfm->szFacename );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Familyname                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "Familyname = %s", pfm->szFamilyname );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Match                                                */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lMatchID = %d", pfm->lMatch );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Registry ID                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "Registry ID = %d", pfm->idRegistry );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* CodePage                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "usCodePage = %d", pfm->usCodePage );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* XDeviceRes                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sXDeviceRes = %d", pfm->sXDeviceRes );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* YDeviceRes                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sYDeviceRes = %d", pfm->sYDeviceRes );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Defn                                                 */
  /*------------------------------------------------------*/
  /* FM_DEFN_OUTLINE         0x0001                       */
  /* FM_DEFN_IFI             0x0002                       */
  /* FM_DEFN_WIN             0x0004                       */
  /* FM_DEFN_GENERIC         0x8000                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "fsDefn = 0x%x", pfm->fsDefn );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->fsDefn & FM_DEFN_OUTLINE )
  {
    sprintf( szBuffer, "      FM_DEFN_OUTLINE (0x%x)", FM_DEFN_OUTLINE );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */
  else
  {
    sprintf( szBuffer, "      BITMAP FONT" );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end else */

  if( pfm->fsDefn & FM_DEFN_IFI )
  {
    sprintf( szBuffer, "      FM_DEFN_IFI (0x%x)", FM_DEFN_IFI );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsDefn & FM_DEFN_WIN )
  {
    sprintf( szBuffer, "      FM_DEFN_WIN (0x%x)", FM_DEFN_WIN );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsDefn & FM_DEFN_GENERIC )
  {
    sprintf( szBuffer, "      FM_DEFN_GENERIC (0x%x)", FM_DEFN_GENERIC );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  /*------------------------------------------------------*/
  /* Type                                                 */
  /*------------------------------------------------------*/
  /* FM_TYPE_FIXED           0x0001                       */
  /* FM_TYPE_LICENSED        0x0002                       */
  /* FM_TYPE_KERNING         0x0004                       */
  /* FM_TYPE_DBCS            0x0010                       */
  /* FM_TYPE_MBCS            0x0018                       */
  /* FM_TYPE_64K             0x8000                       */
  /* FM_TYPE_ATOMS           0x4000                       */
  /* FM_TYPE_FAMTRUNC        0x2000                       */
  /* FM_TYPE_FACETRUNC       0x1000                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "fsType = 0x%x", pfm->fsType );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->fsType & FM_TYPE_FIXED )
  {
    sprintf( szBuffer, "      FM_TYPE_FIXED (0x%x)", FM_TYPE_FIXED );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_LICENSED )
  {
    sprintf( szBuffer, "      FM_TYPE_LICENSED (0x%x)", FM_TYPE_LICENSED );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_KERNING )
  {
    sprintf( szBuffer, "      FM_TYPE_KERNING (0x%x)", FM_TYPE_KERNING );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_DBCS )
  {
    sprintf( szBuffer, "      FM_TYPE_DBCS (0x%x)", FM_TYPE_DBCS );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_MBCS )
  {
    sprintf( szBuffer, "      FM_TYPE_MBCS (0x%x)", FM_TYPE_MBCS );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_64K )
  {
    sprintf( szBuffer, "      FM_TYPE_64K (0x%x)", FM_TYPE_64K );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_ATOMS )
  {
    sprintf( szBuffer, "      FM_TYPE_ATOMS (0x%x)", FM_TYPE_ATOMS );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_FAMTRUNC )
  {
    sprintf( szBuffer, "      FM_TYPE_FAMTRUNC (0x%x)", FM_TYPE_FAMTRUNC );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsType & FM_TYPE_FACETRUNC )
  {
    sprintf( szBuffer, "      FM_TYPE_FACETRUNC (0x%x)", FM_TYPE_FACETRUNC );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  /*------------------------------------------------------*/
  /* Selection                                            */
  /*------------------------------------------------------*/
  /* FM_SEL_ITALIC           0x0001                       */
  /* FM_SEL_UNDERSCORE       0x0002                       */
  /* FM_SEL_NEGATIVE         0x0004                       */
  /* FM_SEL_OUTLINE          0x0008                       */
  /* FM_SEL_STRIKEOUT        0x0010                       */
  /* FM_SEL_BOLD             0x0020                       */
  /* FM_SEL_ISO9241_TESTED   0x0040                       */
  /*------------------------------------------------------*/

  sprintf( szBuffer, "fsSelection = 0x%x", pfm->fsSelection );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->fsSelection & FM_SEL_OUTLINE )
  {
    sprintf( szBuffer, "      FM_SEL_OUTLINE (0x%x)", FM_SEL_OUTLINE );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_ITALIC )
  {
    sprintf( szBuffer, "      FM_SEL_ITALIC (0x%x)", FM_SEL_ITALIC );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_UNDERSCORE )
  {
    sprintf( szBuffer, "      FM_SEL_UNDERSCORE (0x%x)", FM_SEL_UNDERSCORE );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_NEGATIVE )
  {
    sprintf( szBuffer, "      FM_SEL_NEGATIVE (0x%x)", FM_SEL_NEGATIVE );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_STRIKEOUT )
  {
    sprintf( szBuffer, "      FM_SEL_STRIKEOUT (0x%x)", FM_SEL_STRIKEOUT );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_BOLD )
  {
    sprintf( szBuffer, "      FM_SEL_BOLD (0x%x)", FM_SEL_BOLD );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->fsSelection & FM_SEL_ISO9241_TESTED )
  {
    sprintf( szBuffer, "      FM_SEL_ISO9241_TESTED (0x%x)", FM_SEL_ISO9241_TESTED );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  /*------------------------------------------------------*/
  /* Capabilities                                         */
  /*------------------------------------------------------*/
  /* FM_CAP_NOMIX            0x0001                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "fsCapabilities = 0x%x", pfm->fsCapabilities );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->fsCapabilities & FM_CAP_NOMIX )
  {
    sprintf( szBuffer, "      FM_CAP_NOMIX (0x%x)", FM_CAP_NOMIX );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  /*------------------------------------------------------*/
  /* MaxBaselineExt                                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lMaxBaselineExt = %d", pfm->lMaxBaselineExt );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* AveCharWidth                                         */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lAveCharWidth = %d", pfm->lAveCharWidth );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* NominalPointSize                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sNominalPointSize = %d", pfm->sNominalPointSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* MinimumPointSize                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sMinimumPointSize = %d", pfm->sMinimumPointSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  // Store value for dialog use
  *MinPointSize = pfm->sMinimumPointSize;

  /*------------------------------------------------------*/
  /* MaximumPointSize                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sMaximumPointSize = %d", pfm->sMaximumPointSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  // Store value for dialog use
  *MaxPointSize = pfm->sMaximumPointSize;

  /*------------------------------------------------------*/
  /* EmHeight                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lEmHeight = %d", pfm->lEmHeight );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* XHeight                                              */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lXHeight = %d", pfm->lXHeight );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* MaxAscender                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lMaxAscender = %d", pfm->lMaxAscender );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* MaxDescender                                         */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lMaxDescender = %d", pfm->lMaxDescender );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* LowerCaseAscent                                      */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lLowerCaseAscent = %d", pfm->lLowerCaseAscent );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* LowerCaseDescent                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lLowerCaseDescent = %d", pfm->lLowerCaseDescent );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* InternalLeading                                      */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lInternalLeading = %d", pfm->lInternalLeading );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* ExternalLeading                                      */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lExternalLeading = %d", pfm->lExternalLeading );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* MaxCharInc                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lMaxCharInc = %d", pfm->lMaxCharInc );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* EmInc                                                */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lEmInc = %d", pfm->lEmInc );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* sCharSlope                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sCharSlope = %d", pfm->sCharSlope );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* InLineDir                                            */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sInlineDir = %d", pfm->sInlineDir );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* CharRot                                              */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sCharRot = %d", pfm->sCharRot );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* FirstChar                                            */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sFirstChar = %d", pfm->sFirstChar );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* LastChar                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sLastChar = %d", pfm->sLastChar );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* DefaultChar                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sDefaultChar = %d", pfm->sDefaultChar );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* BreakChar                                            */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sBreakChar = %d", pfm->sBreakChar );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* KerningPairs                                         */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sKerningPairs = %d", pfm->sKerningPairs );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* FamilyClass                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "sFamilyClass = %d", pfm->sFamilyClass );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* WeightClass                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "usWeightClass = %d", pfm->usWeightClass );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* WidthClass                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "usWidthClass = %d", pfm->usWidthClass );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SubscriptXSize                                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSubscriptXSize = %d", pfm->lSubscriptXSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SubscriptYSize                                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSubscriptYSize = %d", pfm->lSubscriptYSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SubscriptXOffset                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSubscriptXOffset = %d", pfm->lSubscriptXOffset );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SubscriptYOffset                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSubscriptYOffset = %d", pfm->lSubscriptYOffset );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SuperscriptXSize                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSuperscriptXSize = %d", pfm->lSuperscriptXSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SuperscriptYSize                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSuperscriptYSize = %d", pfm->lSuperscriptYSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SuperscriptXOffset                                   */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSuperscriptXOffset = %d", pfm->lSuperscriptXOffset );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* SuperscriptYOffset                                   */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lSuperscriptYOffset = %d", pfm->lSuperscriptYOffset );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* UnderscoreSize                                       */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lUnderscoreSize = %d", pfm->lUnderscoreSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* UnderscorePosition                                   */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lUnderscorePosition = %d", pfm->lUnderscorePosition );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* StrikeoutSize                                        */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lStrikeoutSize = %d", pfm->lStrikeoutSize );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* StrikeoutPosition                                    */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "lStrikeoutPosition = %d", pfm->lStrikeoutPosition );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Family Name Atom                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "FamilyNameAtom = 0x%x", pfm->FamilyNameAtom );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Facename Atom                                        */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "FaceNameAtom = 0x%x", pfm->FaceNameAtom );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* PANOSE                                               */
  /*------------------------------------------------------*/
  WinInsertLboxItem( hwndLB, LIT_END, "Panose:" );

  /*------------------------------------------------------*/
  /* Family Type                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bFamilyType = %d", pfm->panose.bFamilyType );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Serif Style                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bSerifStyle = %d", pfm->panose.bSerifStyle );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Weight                                               */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bWeight = %d", pfm->panose.bWeight );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Proportion                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bProportion = %d", pfm->panose.bProportion );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Contrast                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bContrast = %d", pfm->panose.bContrast );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Stroke Variation                                     */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bStrokeVariation = %d", pfm->panose.bStrokeVariation );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Arm Style                                            */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bArmStyle = %d", pfm->panose.bArmStyle );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Letter Form                                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bLetterform = %d", pfm->panose.bLetterform );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Midline                                              */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bMidline = %d", pfm->panose.bMidline );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* X Height                                             */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  bXHeight = %d", pfm->panose.bXHeight );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  /*------------------------------------------------------*/
  /* Passed ISO                                           */
  /*------------------------------------------------------*/
  /* FM_ISO_9518_640        0x01                          */
  /* FM_ISO_9515_640        0x02                          */
  /* FM_ISO_9515_1024       0x04                          */
  /* FM_ISO_9517_640        0x08                          */
  /* FM_ISO_9517_1024       0x10                          */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  fbPassedISO = 0x%x", pfm->panose.fbPassedISO );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->panose.fbPassedISO & FM_ISO_9518_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9518_640 (0x%x)", FM_ISO_9518_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbPassedISO & FM_ISO_9515_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9515_640 (0x%x)", FM_ISO_9515_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbPassedISO & FM_ISO_9515_1024 )
  {
    sprintf( szBuffer, "      FM_ISO_9515_1024 (0x%x)", FM_ISO_9515_1024 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbPassedISO & FM_ISO_9517_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9517_640 (0x%x)", FM_ISO_9517_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbPassedISO & FM_ISO_9517_1024 )
  {
    sprintf( szBuffer, "      FM_ISO_9517_1024 (0x%x)", FM_ISO_9517_1024 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  /*------------------------------------------------------*/
  /* Failed ISO                                           */
  /*------------------------------------------------------*/
  sprintf( szBuffer, "  fbFailedISO = 0x%x", pfm->panose.fbFailedISO );
  WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  if( pfm->panose.fbFailedISO & FM_ISO_9518_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9518_640 (0x%x)", FM_ISO_9518_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbFailedISO & FM_ISO_9515_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9515_640 (0x%x)", FM_ISO_9515_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbFailedISO & FM_ISO_9515_1024 )
  {
    sprintf( szBuffer, "      FM_ISO_9515_1024 (0x%x)", FM_ISO_9515_1024 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbFailedISO & FM_ISO_9517_640 )
  {
    sprintf( szBuffer, "      FM_ISO_9517_640 (0x%x)", FM_ISO_9517_640 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

  if( pfm->panose.fbFailedISO & FM_ISO_9517_1024 )
  {
    sprintf( szBuffer, "      FM_ISO_9517_1024 (0x%x)", FM_ISO_9517_1024 );
    WinInsertLboxItem( hwndLB, LIT_END, szBuffer );

  } /* end if */

} /* end FillFontMetricsListBox */

