/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : FTDLG.H                                                 */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 03-14-95                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used for dialog controls.         */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/

// Helps avoid dlg editor replacement
#ifndef DID_OK
#define DID_OK 1
#endif

#ifndef DID_CANCEL
#define DID_CANCEL 2
#endif

// ---- STRING TABLE ----------------------------------------------------

#define STRID_FORMAT_BASE        800
#define STRID_FORMAT_CHARBOX     STRID_FORMAT_BASE
#define STRID_FORMAT_DATE        STRID_FORMAT_BASE + 1
#define STRID_FORMAT_TIME        STRID_FORMAT_BASE + 2
#define STRID_FORMAT_DUAL        STRID_FORMAT_BASE + 3
#define STRID_FORMAT_FILE        STRID_FORMAT_BASE + 4
#define STRID_FORMAT_PAGENUM     STRID_FORMAT_BASE + 5
#define STRID_FORMAT_BORDER      STRID_FORMAT_BASE + 6
#define STRID_FORMAT_LINENUM     STRID_FORMAT_BASE + 7  // @74644
#define STRID_FORMAT_TITLETEXT   STRID_FORMAT_BASE + 8  // @TTTTT
#define STRID_END                STRID_FORMAT_BASE + 9

#define STRID_CLR_ITEM_BASE      850
#define STRID_CLR_ITEM_TEXT      STRID_CLR_ITEM_BASE
#define STRID_CLR_ITEM_BACKTEXT  STRID_CLR_ITEM_BASE + 1
#define STRID_CLR_ITEM_PTEXT     STRID_CLR_ITEM_BASE + 2
#define STRID_CLR_ITEM_PBACKTEXT STRID_CLR_ITEM_BASE + 3
#define STRID_CLR_ITEM_BORDER    STRID_CLR_ITEM_BASE + 4
#define STRID_CLR_ITEM_TRAILER   STRID_CLR_ITEM_BASE + 5
#define STRID_CLR_ITEM_TITLETEXT STRID_CLR_ITEM_BASE + 6  // @TTTTT
#define STRID_CLR_ITEM_SEARCH    STRID_CLR_ITEM_BASE + 7
#define STRID_CLR_ITEM_END       STRID_CLR_ITEM_BASE + 8

// ---- COMMON BUTTON IDs -----------------------------------------------
#define DID_HELP                 256
#define DID_SAVE                 257
#define DID_DEFAULT              258

// ---- PROGRAM ID ------------------------------------------------------
#define ID_FONTEST               350

// ---- BITMAPS IDs------------------------------------------------------

// Menu Bitmaps
#define ID_FOLDER                351
#define ID_QUERY                 352
#define ID_SEARCH                353
#define ID_HELP                  354
#define ID_OPENFLDR              355
#define ID_PRINTER               356
#define ID_FONT                  357
#define ID_SELCOLOR              358
#define ID_SELFMT                359
#define ID_DEFOPTS               360
#define ID_PRNTFILE              361
#define ID_PAPER                 362
#define ID_SRCHTEXT              363
#define ID_KEYBOARD              364
#define ID_REDCROSS              365
#define ID_BOOK                  366
#define ID_LITEBULB              367
#define ID_HELPPLUS              368
#define ID_SETTINGS              369

#define ID_FONTATM               370
#define ID_FONTBMP               371
#define ID_FONTSYS               372
#define ID_FONTPRN               373
#define ID_FONTDSP               374

// ---- MENU IDs --------------------------------------------------------

#define IDM_FILE_MENU            375 // ID Menu : "File"
#define IDM_OPEN_FILE            376 //    ID Menu Item : Open Text File...
#define IDM_SETTINGS             377 //    ID Menu Item : Program Settings...
#define IDM_DEFAULT_OPTIONS      378 //    ID Menu Item : default all settings
#define IDM_SELECT_QUEUE         379 //    ID Menu Item : Print Text File...
#define IDM_PRINT                380 //    ID Menu Item : Print Text File...
#define IDM_EXIT                 381 //    ID Menu Item : Exit Font Test

#define IDM_QUERY_MENU           385 // ID Menu : "Query Options"
#define IDM_QUERY_CAPS           386 //    ID Menu Item : DevQueryCaps
#define IDM_QUERY_HCCAPS         387 //    ID Menu Item : DevQueryHardcopyCaps
#define IDM_QUERY_METRICS        388 //    ID Menu Item : GpiQueryFontMetrics
#define IDM_QUERY_FNTWDTH        389 //    ID Menu Item : GpiQueryWidthTable
#define IDM_QUERY_FNTKERN        390 //    ID Menu Item : GpiQueryKerningPairs

#define IDM_SEARCH_MENU          395 // ID Menu : "Search Options"
#define IDM_SEARCH_TEXT          396 //    ID Menu Item : Search for Text...
#define IDM_SEARCH_NEXT          397 //    ID Menu Item : find next occurrence

#define IDM_HELP_MENU            400 // ID Menu : "Help"
#define IDM_HELP_HELP            401 //    ID Menu Item : Using Help..
#define IDM_EXT_HELP             402 //    ID Menu Item : Extended Help...
#define IDM_KEYS_HELP            403 //    ID Menu Item : Defined Keys...
#define IDM_HELP_INDEX           404 //    ID Menu Item : Help Index...
#define IDM_ABOUT                405 //    ID Menu Item : About Font Tester...

#define IDM_SELECT_FONT          411 //    ID Notebook Tab : Select Font Page
#define IDM_SELECT_FORMAT        412 //    ID Notebook Tab : Select Format Page
#define IDM_SELECT_COLORS        413 //    ID Notebook Tab : Select Colors Page

// ---- MESSAGES IDs ---------------------------------------------------------

#define IDM_PAGEUP               415 // @MAXLINE - Msg to Page Up window text
#define IDM_PAGEDOWN             416 // @MAXLINE - Msg to Page Down window text
#define IDM_OPEN_QUIET           417 // Message for command line print

// ---- DIALOG IDs -----------------------------------------------------------

#define IDD_PROGRAM_SETTINGS     420 // ID Dialog : "Program Settings"
#define IDD_SETTINGS_NOTEBOOK    421 //     ID Notebook: "Program Settings"

#define IDD_SELECT_QUEUE         450 // Notebook Dialog: "Select Printer"
#define IDCB_PRINT_QUEUES        451 //    ID Listbox : "Available Queue Names"
#define IDP_JOB_PROPERTIES       452 //    ID Pushbutton : "Job Properties..."
#define IDP_OTHER_DESTINATION    453 //    ID Pushbutton : "Other Destinations..."
#define IDT_PRINTER_DRIVER       454 //    ID Text : Printer Driver
#define IDT_PRINTER_DESCRIPTION  455 //    ID Text : Printer Description
#define IDD_OTHER_DESTINATION    456 // ID Dialog : "Unlisted Queues"
#define IDE_OTHER_DESTINATION    457 //    ID Entryfield : holds Queue name

#define IDD_FONT                 470 // ID Dialog : "Select Font..."
#define IDL_FACENAME             471 //    ID Listbox : displays Font Facenames
#define IDL_FONTMETRICS          472 //    ID Listbox : displays Font Attributes
#define IDE_FONTTYPE             473 //    ID Entryfield : device/system font
#define IDE_OUTLINE              474 //    ID Entryfield : scalable/fixed font
#define IDE_POINTSIZE            475 //    ID Spinbutton : show/slect Pointsize
#define IDC_FONT_SAVE            476 //    ID Checkbox : Save Font  to ini file
#define IDML_FONTSAMP            477 //    ID Multiline editor : font sample
#define IDG_FONT_OPTIONS         478 //    ID Groupbox : Options
#define IDC_FONT_ITALIC          479 //    ID Checkbox : Italic
#define IDC_FONT_UNDERSCORE      480 //    ID Checkbox : Underscore
#define IDC_FONT_STRIKEOUT       481 //    ID Checkbox : Strikeout
#define IDC_FONT_BOLD            482 //    ID Checkbox : Bold
#define IDG_FONTTYPE             483 //    ID Groupbox: Font Type
#define IDD_FONTTYPE_OWNER       484 //    ID Button: Font Owner
#define IDD_FONTTYPE_STYLE       485 //    ID Button: Font Style

#define IDD_SEARCH               490 // ID Dialog : "Search for Text..."
#define IDE_SEARCH               491 //    ID Entryfield : search string
#define IDC_SRCH_CASE_SENSE      492 //    ID Checkbox   : Case sensative/not

#define IDD_DISPLAYCAPS          500 // ID Dialog : "DevQueryCaps..."
#define IDL_CAPSLIST             501 //    ID Listbox : Device Capabilities

#define IDD_DISPLAYHCCAPS        515 // ID Dialog : "DevQueryHCCaps..."
#define IDL_HCCAPSLIST           516 //    ID Listbox : Device HC Capabilities
#define IDL_FORMSLIST            517 //    ID Listbox : Forms Supported

#define IDD_METRICS              600 // ID Dialog : "GpiQueryFontMetrics..."
#define IDL_PRN_FONTMETRICS      601 //    ID Listbox : Printer Fontmetrics
#define IDL_DSP_FONTMETRICS      602 //    ID Listbox : Display Fontmetrics

#define IDD_FONT_WIDTHS          610 // ID Dialog : "GpiQueryWidthTable..."
#define IDL_FONT_WIDTHS          611 //    ID Listbox : Font Width Table

#define IDD_FONT_KERN_PAIRS      615 // ID Dialog : "GpiQueryWidthTable..."
#define IDL_FONT_KERN_PAIRS      616 //    ID Listbox : Font Width Table

#define IDD_MAIN_PRINT           620 // ID Dialog : "Print file..."
#define IDE_QUEUE                621 //     ID Entryfield : display Selected Queue
#define IDE_QUEUE_DESC           622 //     ID Entryfield : display Queue Description
#define IDE_FONT                 623 //     ID Entryfield : display Selected Font
#define IDE_PRNTFILE             624 //     ID Entryfield : display Selected File
#define IDE_DRIVER               626 //     ID Entryfield : display Selected Driver
#define IDE_DEVICE               627 //     ID Entryfield : display Selected Device
#define IDE_PTSIZE               628 //     ID Entryfield : display Font's pointsize
#define IDP_SETTINGS             629 //     ID Pushbutton : display Program Settings

#define IDD_FORMAT_OPTIONS       700 // ID Dialog : "Select Text Format..."
#define IDL_FORMAT_OPTIONS       701 //     ID Listbox  : Format options
#define IDE_TEXT_TITLE           704 //     ID static box
#define IDR_TITLE_LEFT           705 //     ID Radio btn : Left Justify Title
#define IDR_TITLE_CENTER         706 //     ID Radio btn : Center Justify Title
#define IDR_TITLE_RIGHT          707 //     ID Radio btn : Right Justify Title
#define IDG_TEXT_OPTIONS         708 //     ID Groupbox  : Surround buttons

#define IDD_SELECT_COLORS        710 // ID Dialog : "Select Colors..."
#define IDL_COLOR_ITEMS          711 //     ID Listbox  : Colorable items
#define IDV_AVAIL_COLORS         712 //     ID Valueset : Available colors

#define IDD_ABOUT                750 // ID Dialog : "About Font Test..."
#define IDI_ID_FONTEST           751 //    ID Icon : Program Icon

