/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#define INCL_DEV
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_ERRORS
#define INCL_GPI
#define INCL_GPIERRORS
#define INCL_SPL
#define INCL_SPLDOSPRINT
#define INCL_WIN

#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "ft32.h"
#include "ftdlg.h"
#include "fthelp.h"

/*------------------------------------------------------------------------*/
/* Function Prototypes (Window Procedures)                                */
/*------------------------------------------------------------------------*/
FNWP DisplayCapsDlgProc;
FNWP DisplayHCCapsDlgProc;

/*------------------------------------------------------------------------*/
/* Function Prototypes (Internal)                                         */
/*------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/* Function Prototypes (External)                                         */
/*------------------------------------------------------------------------*/
ERRORID DisplayDeviceFormCaps( HAB, HDC, HWND, PPRINTERDATA, ULONG );
ERRORID DisplayDeviceCaps( HAB, HDC, HWND, PPRINTERDATA, ULONG );

/*------------------------------------------------------------------------*/
/* GLOBALS                                                                */
/*------------------------------------------------------------------------*/
extern PGMDATA PgmData;
extern HWND    hwndHelp;

/****************************************************************************/
/* PROCEDURE NAME : DisplayDeviceCaps                                       */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 05/12/95                                                */
/* DESCRIPTION    : */
/*                                                                          */
/* PARAMETERS:      */
/*                  */
/*                                                                          */
/* RETURN VALUES:   */
/*                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
ERRORID DisplayDeviceCaps( HAB hab, HDC hdc, HWND hwnd, PPRINTERDATA prd, ULONG ulRequest )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  LONG Caps[CAPS_END];   // Holds all DevQueryCaps values
  BOOL bRC;
  ERRORID ErrorID;

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  bRC = DevQueryCaps( hdc, CAPS_START, CAPS_END, Caps );

  ErrorID = AssertPM( !bRC, hab, (PSZ)ERR_DEVQUERYCAPS );

  if( ErrorID == NO_ERROR )
  {
    // If no error has occurred display capabilities
    WinDlgBox( HWND_DESKTOP,
               hwnd,
               (PFNWP)DisplayCapsDlgProc,
               (HMODULE)NULL,
               (ULONG)IDD_DISPLAYCAPS,
               (PVOID)&Caps );
  } /* end if */

  return( ErrorID );

} /* end DisplayDeviceCaps */

/****************************************************************************/
/* PROCEDURE NAME : DisplayDeviceFormCaps                                   */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 05/12/95                                                */
/* DESCRIPTION    : */
/*                                                                          */
/* PARAMETERS:      */
/*                  */
/*                                                                          */
/* RETURN VALUES:   */
/*                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
ERRORID DisplayDeviceFormCaps( HAB hab, HDC hdc, HWND hwnd, PPRINTERDATA prd, ULONG ulRequest )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  LONG    lFormsReturned;  // Forms returned by DevQueryHCCaps
  ERRORID ErrorID;
  ULONG   ul;

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/

  // Query device about all form sizes available for output
  lFormsReturned = DevQueryHardcopyCaps( hdc, 0L, 0L,(PHCINFO)NULL );

  ErrorID = AssertPM( lFormsReturned==DQHC_ERROR, hab, ERR_DEVQHCCAPS );
  ErrorID = AssertPM( lFormsReturned==0, hab, ERR_NO_FORMS );

  /*-----------------------------------------------------*/
  /* lFormsReturned valid                                */
  /*-----------------------------------------------------*/
  if( ErrorID == NO_ERROR )
  {
    /*---------------------------------------------------*/
    /* Retrieve hardcopy (HCINFO) for device             */
    /*---------------------------------------------------*/

    // free old hardcopy (form) data we may have allocated
    if( prd->pHcInfo )
      DosFreeMem( prd->pHcInfo );

    // Allocate new memory for new hardcopy data
    ErrorID = DosAllocMem( (PPVOID)&(prd->pHcInfo),
                           lFormsReturned*sizeof(HCINFO),
                           PAG_READ | PAG_WRITE | PAG_COMMIT );

    AssertPM( ErrorID!=NO_ERROR, hab, ERR_DOSALLOCMEM );

    // hardcopy memory successfully allocated
    if( ErrorID == NO_ERROR )
    {
      LONG lReturn;

      lReturn = DevQueryHardcopyCaps( hdc, 0L,
                                      lFormsReturned,
                                      prd->pHcInfo );

      ErrorID = AssertPM( lReturn==DQHC_ERROR, hab, ERR_DEVQHCCAPS );
      ErrorID = AssertPM( lReturn==0, hab, ERR_NO_FORMS );

    } /* end if */

    /*---------------------------------------------------*/
    /* Hardcopy information retrieved successfully       */
    /* now retrieve current form selected in printer     */
    /*---------------------------------------------------*/
    if( ErrorID == NO_ERROR )
    {
      // Initialize loop comtrol variable
      ul = 0;

      // Loop through all Hardcopy structs looking for current form
      while( !( prd->pHcInfo[ul].flAttributes & HCAPS_CURRENT) &&
             ((LONG)ul < lFormsReturned) )
      { ul++; } /* end while */

      // If no form marked "current" by printer driver use default
      if( ul >= lFormsReturned )
      { ul = 0; } /* end if */

      // Get the imageable area in pels of the current page (paper)
      prd->szlPage.cx = prd->pHcInfo[ul].xPels;
      prd->szlPage.cy = prd->pHcInfo[ul].yPels;

      /***************************************************/
      /* REQUEST_QUERY_HCCAPS                            */
      /***************************************************/
      if( ulRequest & REQUEST_QUERY_HCCAPS )
      {
        WinDlgBox( HWND_DESKTOP,
                   hwnd,
                   (PFNWP)DisplayHCCapsDlgProc,
                   (HMODULE)NULL,
                   (ULONG)IDD_DISPLAYHCCAPS,
                   (PVOID)&lFormsReturned );
      } /* end if */

    } /* end if */

  } /* end if */

  return( ErrorID );

} /* end DisplayDeviceFormCaps */


/****************************************************************************/
/* PROCEDURE NAME : DisplayCapsDlgProc                                      */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 7/3/91                                                  */
/* DESCRIPTION    : Controls Device Capabilities dialog by responding to    */
/*                  all window messages.                                    */
/*                                                                          */
/*                  Control Flow:                                           */
/*                  (a) Process message passed in using a switch statement  */
/*                                                                          */
/* PARAMETERS:      (HWND)   hwnd                                           */
/*                  (ULONG)  msg                                            */
/*                  (MPARAM) mp1                                            */
/*                  (MPARAM) mp2                                            */
/*                                                                          */
/* RETURN VALUES:   (MRESULT)                                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY DisplayCapsDlgProc ( HWND   hwnd,
                                      ULONG  msg,
                                      MPARAM mp1,
                                      MPARAM mp2 )
{
  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/
  switch(msg)
  {
    case WM_INITDLG:
    {
       FillCapsListBox( hwnd, (PLONG)PVOIDFROMMP( mp2 ) );
       return(0);

    } /* end case */
    break;

    case WM_COMMAND:
    {
      switch( SHORT1FROMMP(mp1) )
      {
        case DID_OK:
        {
          WinDismissDlg( hwnd, DID_OK );
          return(0);

        } /* end case */
        break;

      } /* end switch */

    } /* end case */
    break;

    case WM_HELP:
    {
      if( PgmData.StateData.bHelpAvailable )
         WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
                     MPFROMSHORT( PANEL_DLG_CAPS ),
                     MPFROMSHORT( HM_RESOURCEID ));
      else
         AssertPM( TRUE, PgmData.habPgm, ERR_NO_HELP );

    } /* end case */
    break;

  } /* end switch */

  return WinDefDlgProc( hwnd, msg, mp1, mp2 );

} /* end DisplayCapsDlgProc */



/****************************************************************************/
/* PROCEDURE NAME : DisplayHCCapsDlgProc                                    */
/* AUTHOR         : MFR                                                     */
/* DATE WRITTEN   : 7/3/91                                                  */
/* DESCRIPTION    : Controls Device Hardcopy Capabilities dialog by         */
/*                  responding to all window messages.                      */
/*                                                                          */
/*                  Control Flow:                                           */
/*                  (a) Process message passed in using a switch statement  */
/*                                                                          */
/* PARAMETERS:      (HWND)   hwnd                                           */
/*                  (ULONG)  msg                                            */
/*                  (MPARAM) mp1                                            */
/*                  (MPARAM) mp2                                            */
/*                                                                          */
/* RETURN VALUES:   (MRESULT)                                               */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* CHANGE/MODIFICATION LOG :                                                */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/****************************************************************************/
MRESULT EXPENTRY DisplayHCCapsDlgProc ( HWND hwnd, ULONG msg, MPARAM mp1,
                                        MPARAM mp2 )
{
  /*------------------------------------------------------------------------*/
  /* LOCAL VARIABLES                                                        */
  /*------------------------------------------------------------------------*/
  static  CHAR szBuffer[80];
  static  LONG lFormsReturned;

  USHORT  CurrentIndex;
  BOOL    FormMatch = FALSE;
  USHORT  i=0;
  MRESULT mr;
  PLONG   plFormsReturned;
  SHORT   sSelect;

  /*------------------------------------------------------------------------*/
  /* BEGIN CODE                                                             */
  /*------------------------------------------------------------------------*/
  switch(msg)
  {
    case WM_INITDLG:
    {
      // retrieve a pointer to the # forms supported by printer
      plFormsReturned = (PLONG)PVOIDFROMMP(mp2);
      lFormsReturned  = *plFormsReturned;

      // Fill list box with names of all forms supported
      CurrentIndex = FillFormsListBox( PgmData.habPgm, hwnd, lFormsReturned );

      // hilite/select form name of HCCAPS_CURRENT form
      WinSendDlgItemMsg( hwnd,
                         IDL_FORMSLIST,
                         LM_SELECTITEM,
                         MPFROMSHORT((SHORT)CurrentIndex),
                         MPFROMSHORT((SHORT)TRUE));
      return(0);

    } /* end case */
    break;

    case WM_CONTROL:
    {
      // if someone clicked on a form name in the listbox
      if(SHORT1FROMMP(mp1) == IDL_FORMSLIST )
      {
        mr = WinSendDlgItemMsg( hwnd, SHORT1FROMMP(mp1),
                                LM_QUERYSELECTION, 0L, 0L );

        sSelect = SHORT1FROMMR( mr );

        // get text of form name of form selected
        WinSendDlgItemMsg( hwnd,
                           SHORT1FROMMP(mp1),
                           LM_QUERYITEMTEXT,
                           MPFROM2SHORT(sSelect, sizeof(szBuffer)),
                           MPFROMP(szBuffer) );

        // traverse list of all forms (names) supported by printer
        // to get correct Hardcopy Capabilities
        while( (FormMatch == FALSE) && ((LONG)i < lFormsReturned) )
        {
          if( strcmp( szBuffer, PgmData.PrinterData.pHcInfo[i].szFormname ) == 0 )
          {
             // display Hardcopy Capabilities for form we matched
             FillHCCapsListBox( hwnd, i );
             FormMatch = TRUE;
          } /* end if */
          else
          {
             i++;
          } /* end else */
        } /* end while */

      }  /* end if */

    } /* end case */
    break;


    case WM_COMMAND:
    {
      switch( SHORT1FROMMP(mp1) )
      {
        case DID_OK:
             WinDismissDlg( hwnd, DID_OK );
             return(0);
        break;

      } /* end switch */

    } /* end case */
    break;

    case WM_HELP:
    {
      if( PgmData.StateData.bHelpAvailable )
         WinSendMsg( hwndHelp, HM_DISPLAY_HELP,
                     MPFROMSHORT( PANEL_DLG_HARDCOPY ),
                     MPFROMSHORT( HM_RESOURCEID ));
      else
         AssertPM( TRUE, PgmData.habPgm, ERR_NO_HELP );

    } /* end case */
    break;

  } /* end switch */

  return WinDefDlgProc( hwnd, msg, mp1, mp2 );

} /* end DisplayHCCapsDlgProc */

