/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* FILENAME       : FT32.H                                                  */
/* AUTHOR         : Matthew F. Rutkowski                                    */
/* DATE WRITTEN   : 08-04-92                                                */
/* DESCRIPTION    : This module contains all MACROS, IDs, constants and     */
/*                  data type definitions used by Font Test.                */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Modification/Change log                                                  */
/*--------------------------------------------------------------------------*/
/* TAG - DATE - [COMPANY] - AUTHOR - DESCRIPTION                            */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* @DBCS    -          - DBCS enabling Tag                                  */
/*                                                                          */
/* @MAXLINE - 11/02/93 - Matt Rutkowski [IBM] - Allows browse and print of  */
/*                       huge files where previously files upto 6000 lines  */
/*                       were only allowed.                                 */
/*                                                                          */
/*                       Added 2 new special keys:                          */
/*                       CTRL-PAGEUP   - Browse top of file                 */
/*                       CTRL-PAGEDOWN - Browse bottom of file              */
/*                                                                          */
/* @74644   - 11/03/93 - Matt Rutkowski [IBM] - New text format option      */
/*                       "Print Line Numbers" added as a suggestion that    */
/*                       was logged as a defect.                            */
/*                                                                          */
/* @TTTTT   - 05/12/94 - Matt Rutkowski [IBM] - Add "Title text" option     */
/*                                                                          */
/* @100698  - 09/28/94 - Matt Rutkowski [IBM] - recalculate char box size   */
/*                       when user selects a new printer resolution.        */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

// include constanst defines for dialogs and their controls
#include "ftdlg.h"

// Application title ( NLS please translate the following string )
#define PROGRAM_TITLE_CNST       "Font Test 32-bit"

// Help filename to load ( NLS DO NOT TRANSLATE this string!!! )
#define PROGRAM_HELP_FILE        "FT32.HLP"

// Std File Dialog "Open" button text
// ( NLS please translate the following string )
#define OPEN_TITLE_CNST          "Open"

// Keys used to store permanent fontest data in OS2.INI
// ( NLS DO NOT TRANSLATE these strings!!! )
#define FT_APPNAME               "FONTEST32"
#define FT_KEYNAME_VERSION       "VERSION"
#define FT_KEYNAME_COLOR         "COLOR"
#define FT_KEYNAME_FONT          "FONT"
#define FT_KEYNAME_QUEUE         "QUEUE"
#define FT_KEYNAME_FORMAT        "FORMAT"
#define FT_KEYNAME_TITLE         "TITLE"
#define FT_KEYNAME_JOBPROPSIZE   "JOBPROPSIZE"
#define FT_KEYNAME_JOBPROP       "JOBPROP"

#define FT_MAJOR_VERSION         1

// @74644 - had to add check for older versions with new FmtData size
#define FT_MINOR_VERSION_1       1
#define FT_MINOR_VERSION_2       2
#define FT_MINOR_VERSION_3       3
#define FT_MINOR_VERSION_4       4
#define FT_MINOR_VERSION_5       5

// always set to current minor version
#define FT_MINOR_VERSION         FT_MINOR_VERSION_5

// Keys used to store permanent fontest data in OS2.INI
#define FT_KEYID_ALL              0x003f
#define FT_KEYID_VERSION          0x0001
#define FT_KEYID_COLOR            0x0002
#define FT_KEYID_QUEUE            0x0004
#define FT_KEYID_FONT             0x0008
#define FT_KEYID_FORMAT           0x0010
#define FT_KEYID_TITLE            0x0020

// Device Types
#define DEV_TYPE_PRINTER          0x0000
#define DEV_TYPE_DISPLAY          0x0001

// possible action codes for AccessDevice()
#define REQUEST_NONE              0x0000
#define REQUEST_PRINT_FILE        0x0001
#define REQUEST_PRINT_FILE_NO_PM  0x0002
#define REQUEST_QUERY_FONTS       0x0004
#define REQUEST_QUERY_CAPS        0x0008
#define REQUEST_QUERY_HCCAPS      0x0010
#define REQUEST_QUERY_FORM_INFO   0x0020
#define REQUEST_QUERY_METRICS     0x0040
#define REQUEST_QUERY_WIDTHS      0x0080
#define REQUEST_QUERY_KERN        0x0100

// our largest string length
#define MAXSTR                   256

// client window maximums
#define MAXLINES                 32768 // @MAXLINES - to display
#define MAX_CHAR_PER_LINE        255L

// THREAD values
#define STACKSIZE                16000

// Font conversion constant
#define TWIPS_CNST               72.0

// Screen resolution constant
#define DPI_96                   96.0

// Fontest internal messages
#define WM_PRINTDOC              WM_USER
#define WM_SEARCH_FAILED         WM_USER+1
#define WM_DISPLAY_FONTS         WM_USER+2
#define WM_PRINT_THREAD_READY    WM_USER+3
#define WM_CHANGE_FONT           WM_USER+4
#define WM_SET_CURRENT_LINE      WM_USER+5  // @75474

// FONT IDS
#define LCID_LOCAL               2L
#define LCID_PRINTER             3L
#define LCID_WYSIWYG             4L
#define LCID_FONT                5L

// Default font info  ( NLS DO NOT TRANSLATE these strings!!! )
#define POINTSIZE_LENGTH         5
#define FT_DEFAULT_POINTSIZE     8
#define FT_DEFAULT_FONT          "Courier"
#define FT_DEFAULT_LMATCH        0

// Trailer string info ( NLS please translate the following string )
#define TRAILER_PAGE_CNST        "Page"
#define TRAILER_DATE_SEP_CNST    "/"
#define TRAILER_TIME_SEP_CNST    ":"
#define TRAILER_SPACE_CNST       " "

// Queue name tokens ( NLS DO NOT TRANSLATE these strings!!! )
#define QUENAME_LENGTH           33
#define MAX_SEARCH_LEN           33
#define LEAD_QUEUE_TOKEN         '['
#define TRAIL_QUEUE_TOKEN        ']'
#define CR                       '\x0a'
#define LF                       '\x0d'
#define EOS                      '\0'

// Number of device capabilities to display
#define CAPS_START               0L
#define CAPS_END                 42L

// Maximum # of characters possible in an SBCS font
#define MAX_SBCS_CHARS           0x400

// Select Color... Information
#define CLR_TBL_ROWS             4
#define CLR_TBL_COLUMNS          4
#define MAX_COLORS               16

// Text Justification
#define TEXT_JUSTIFY_LEFT        0
#define TEXT_JUSTIFY_CENTER      1
#define TEXT_JUSTIFY_RIGHT       2

/*------------------------------------------------------*/
/* EXTERALIZED GLOBALS                                  */
/*------------------------------------------------------*/
extern ULONG  cxChar;         // Current display font's width
extern ULONG  cyChar;         // Current display font's height
extern ULONG  cyDesc;         // Current display font's max. descender
extern LONG   Caps[CAPS_END+1];  // Current Printer's DevQueryCaps()
extern LONG   lHscrollPos;    // current client window Horz scroll position
extern LONG   lVscrollPos;    // current client window Horz scroll position
extern PSZ *  pLinePtrs;      // @MAXLINE - was static array
extern ULONG  ulTotalLines;   // total lines in current text file

// Structure for programs color data
typedef struct COLORDATA{
  LONG WinTextColor;          // Color of Client window text
  LONG WinBackColor;          // Color of Client window background
  LONG PrnTextColor;          // Color of printed text
  LONG PrnBackColor;          // Color of printed background
  LONG TextBorderColor;       // color of printed text border
  LONG TextTrailerColor;      // color of printed trailer (filename, date etc)
  LONG TextTitleColor;        // color of printed title
  LONG SearchHighliteColor;   // color to circle search matches
} COLORDATA;
typedef COLORDATA *PCOLORDATA;

// Structure for programs font data
typedef struct FONTDATA{
  FONTMETRICS fm;             // fontmetrics of font selected
  ULONG  PointSize;           // point size of font (varies for scalable fonts)
  BOOL   FontScalable;        // flag indicating bitmap or scalable font
  ULONG  Options;             // options to apply to font (e.g. italic, bold etc.)
  PFONTMETRICS pfmCurrent;
} FONTDATA;
typedef FONTDATA *PFONTDATA;

// Structure for programs queue data
typedef struct QUEUEDATA{
  CHAR   QueueName[MAXSTR];   // name of queue to print to (physical name)
  CHAR   QueueDesc[MAXSTR];   // description of queue to print to (logical name)
  PDRIVDATA pDrivData;
} QUEUEDATA;
typedef QUEUEDATA *PQUEUEDATA;

typedef struct FORMATDATA{
  BOOL   bPrintCharBoxes;     // Print character boxes
  BOOL   bPrintDualColumn;    // Print Dual Columns
  BOOL   bPrintFileName;      // Print filename as part of trailer line
  BOOL   bPrintTime;          // Print time as part of trailer line
  BOOL   bPrintDate;          // Print date as part of trailer line
  BOOL   bPrintPageNumbers;   // Print page # as part of trailer line
  BOOL   bPrintTextBorder;    // Print a border around each logical text page
  BOOL   bPrintLineNumbers;   // @74644 - print line number in front of each line
  BOOL   bPrintTitleText;     // @TTTTT - print title at top of page
} FORMATDATA;
typedef FORMATDATA *PFORMATDATA;

typedef struct TEXTDATA{
  CHAR   pszText[256];        // ASCII text string
  USHORT usTextJust;          // justification of string (left, right, center)
  LONG   lTextColor;          // color of string
} TEXTDATA;
typedef TEXTDATA *PTEXTDATA;

typedef struct STATEDATA{
  BOOL   bCmdLinePrint;       // Command line print file
  BOOL   bCmdLineBrowse;      // command line browse file
  BOOL   bCmdLineFileName;    // Command Line filename
  BOOL   bCaseSensitive;
  BOOL   bFileOpen;
  BOOL   bPrinting;
  BOOL   bHelpAvailable;
} STATEDATA;
typedef STATEDATA *PSTATEDATA;

typedef struct DISPLAYDATA{
  HDC     hdcMem;
  HPS     hpsMem;
  FONTMETRICS fm;
  FATTRS  fattrsDefault;
  LONG    lHorzRes;           // CAPS_HORIZONTAL_RESOLUTION (8L) (pels/meter)
  LONG    lVertRes;           // CAPS_VERTICAL_RESOLUTION   (9L)
  LONG    lHorzFontRes;       // CAPS_HORIZONTAL_FONT_RES   (37L) (pels/meter)
  LONG    lVertFontRes;       // CAPS_VERTICAL_FONT_RES     (38L)
  float   fHorzDPI;
  float   fVertDPI;
} DISPLAYDATA;
typedef DISPLAYDATA *PDISPLAYDATA;

typedef struct PRINTERDATA{
  HAB           habPrn;
  HMQ           hmqPrn;
  HDC           hdcPrn;
  HPS           hpsPrn;
  CHAR          szDriverName[MAXSTR];  // Printer Driver Name
  CHAR          szDeviceName[MAXSTR];  // Printer Device Description
  CHAR          szPrinterName[MAXSTR]; // Printer Name
  LONG          lNumForms;             // # HCINFO structs in pHcInfo
  PHCINFO       pHcInfo;               // pointer to hardcopy info structs
  LONG          lNumFonts;             // # FONTMETRICS structs in pFontMetrics
  PFONTMETRICS  pFontMetrics;          // ptr to all fontmetrics structs
  PLONG         pFontWidthTable;       // ptr to current font's width table
  PKERNINGPAIRS pFontKernPairs;        // ptr to current font's kerning pairs
  LONG          lCaps[CAPS_END+1];
  SIZEL         szlPage;
  POINTL        ptlPage;
} PRINTERDATA;
typedef PRINTERDATA *PPRINTERDATA;


struct _NBPageInfo
{
  ULONG ulPageID;
  HWND  hwndPage;
  ULONG ulDlgID;
  PFNWP pfnDlg;
  PSZ   pszStatusLine;
  ULONG ulTabID;
  PVOID pvPageData;
}; /* end _NBPageInfo */
typedef struct _NBPageInfo NBPAGEINFO, *PNBPAGEINFO;

struct _NoteBookInfo
{
  HWND        hwndNB;
  ULONG       ulNBID;
  PNBPAGEINFO pLastPageAdded;
  PNBPAGEINFO pPageShowing;
  NBPAGEINFO  PageInfoPrinter;
  NBPAGEINFO  PageInfoFont;
  NBPAGEINFO  PageInfoColors;
  NBPAGEINFO  PageInfoFormat;
}; /* end _NoteBookInfo */
typedef struct _NoteBookInfo NOTEBOOKINFO, *PNOTEBOOKINFO;

// Main program data structure
typedef struct PGMDATA{
  HAB          habPgm;           // Program Handle to Anchor Block
  HMQ          hmqPgm;
  HWND         hwndMain;
  DISPLAYDATA  DisplayData;
  PRINTERDATA  PrinterData;
  QUEUEDATA    QueueData;
  COLORDATA    ColorData;
  FONTDATA     FontData;
  FORMATDATA   FmtData;
  TEXTDATA     TxtTitle;
  STATEDATA    StateData;
  NOTEBOOKINFO nbi;
} PGMDATA;
typedef PGMDATA *PPGMDATA;

// DBCS enable
#define  SIZEDBCS        2
#define  CHARSIZE(a)     DbcsEnv[a]
// DBCS enable

// API error messages ( NLS please translate the following strings )
#define ERR_DEVCLOSEDC           "DevCloseDC failed"
#define ERR_DEVESCENDDOC         "DevEscape failed\nCode = DEVESC_ENDDOC"
#define ERR_DEVESCNEWFRAME       "DevEscape failed\nCode = DEVESC_NEWFRAME"
#define ERR_DEVESCSTARTDOC       "DevEscape failed\nCode = DEVESC_STARTDOC"
#define ERR_DEVOPENDC            "DevOpenDC failed"
#define ERR_DEVQUERYCAPS         "DevQueryCaps failed"
#define ERR_DEVQHCCAPS           "DevQueryHardcopyCaps failed"
#define ERR_DOSALLOCMEM          "DosAllocMem failed"
#define ERR_DOSOPEN              "DosOpen of file failed"
#define ERR_DOSREAD              "DosRead of file failed"
#define ERR_DOSQFILEINFO         "DosQFIleInfo failed"
#define ERR_GPIASSOCIATE         "GpiAssociate failed"
#define ERR_GPIBITBLT            "GpiBitBlt failed"
#define ERR_GPICHARSTRAT         "GpiCharStringAt failed"
#define ERR_GPICREATELOGFONT     "GpiCreateLogFont failed"
#define ERR_GPICREATEPS          "GpiCreatePS failed"
#define ERR_GPICREATEREGION      "GpiCreateRegion failed"
#define ERR_GPIDELETESETID       "GpiDeleteSetID failed"
#define ERR_GPIDESTROYPS         "GpiDestroyPS failed"
#define ERR_GPILOADBITMAP        "GpiLoadBitmap failed"
#define ERR_GPIOFFSETCLIPREGION  "GpiOffsetClipRegion failed"
#define ERR_GPIQBMPPARMS         "GpiQueryBitmapParameters failed"
#define ERR_GPIQCHARSTRINGPOS    "GpiQueryCharStringPos failed"
#define ERR_GPIQFONTMETRICS      "GpiQueryFontMetrics failed"
#define ERR_GPIQTEXTBOX          "GpiQueryTextBox failed"
#define ERR_GPIQWIDTHTABLE       "GpiQueryWidthTable failed"
#define ERR_GPIQUERYFONTS        "GpiQueryFonts failed"
#define ERR_GPISETATTRS          "GpiSetAttrs failed"
#define ERR_GPISETBITMAP         "GpiSetBitmap failed"
#define ERR_GPISETCHARSET        "GpiSetCharSet failed"
#define ERR_GPISETCHARBOX        "GpiSetCharBox failed"
#define ERR_GPISETCLIPREGION     "GpiSetClipRegion"
#define ERR_GPISETCOLOR          "GpiSetColor failed"
#define ERR_PRFQRYSTRING_PRINTER "PrfQueryProfileString failed\nPM_SPOOLER,PRINTER"
#define ERR_PRFQRYSTRING_QUEUE   "PrfQueryProfileString failed\nPM_SPOOLER,QUEUE"
#define ERR_WINSETWINDOWTEXT     "WinSetWindowText failed"
#define ERR_WINASSOCHLPINST      "WinAssociateHelpInstance failed"
#define ERR_WINCREATEHLPINST     "WinCreateHelpInstance failed"
#define ERR_WINDESTHLPINST       "WinDestroyHelpInstance failed"
#define ERR_WINDRAWTEXT          "WinDrawText failed - not all characters drawn"
#define ERR_SPLENUMQUEUE         "SplEnumQueue has more data than\nthe space allocated to receive it."
#define ERR_SPLQUERYQUEUE        "SplQueryQueue failed"

// menu errors ( NLS please translate the following strings )
#define ERR_UNABLE_CREATE_HEAP   "Unable to create a heap to allocate memory from."
#define ERR_UNABLE_FREE_HEAP     "Unable to free heap"
#define ERR_UNABLE_ALLOC_MEM     "Unable to allocate memory from heap"
#define ERR_UNABLE_FREE_MEM      "Unable to free memory from heap"

// General error messages ( NLS please translate the following strings )
#define ERR_CHAR_HEIGHT          "Font has invalid character height (height is zero)."
#define ERR_AVE_CHAR_WIDTH       "Printer Driver did not update fontmetrics\nfor scalable font.\nAveCharWidth = 0"
#define ERR_FONT_TOO_LARGE       "The font selected is so large that a single line's height is larger than the page size."
#define ERR_JOB_ABORTED          "Print job was aborted"
#define ERR_MAX_BASELINE_EXT     "Printer Driver did not update fontmetrics\nfor scalable font.\nMaxBaselineExt = 0"
#define ERR_NO_FORMS             "Printer driver has no forms defined."
#define ERR_NO_FONTS             "Printer driver reports no public fonts installed in system."
#define ERR_NO_CURRENT_FORM      "Printer driver has not defined a form as current."
#define ERR_NO_FILE_SELECTED     "Please open a file before printing."
#define ERR_NO_HELP              "'Help' is not available\nThe file FT32.HLP was not found in program's directory or HELP path."
#define ERR_NO_QUEUES            "There are no printer queues currently installed on this system. Install one and try again."
#define ERR_NO_DEFAULT_QUEUE     "No Queue selected for program and no system default queue defined"
#define ERR_NO_QUEUE_TO_QUERY    "No Printer was found on system to query.\nInstall one and try again"
#define ERR_UNABLE_TO_PRINT      "This program was unable to print the file selected.\nFix any other errors displayed and check settings"
#define ERR_NO_SEARCH_STRING     "Please enter a string to search for."
#define ERR_NO_TITLE             "Can not print Title; not enough lines available; decrease font size"
#define ERR_NO_TRAILER           "Can not print Trailer; not enough lines available; decrease font size"
#define ERR_POINTSIZE            "Point size selected for scaling\nis outside allowable values"
#define ERR_SAME_COLOR           "Text and background colors are same."
#define ERR_TYPE_FONTMATCH       "GpiCreateLogFont\nFont Requirements not matched,\nusing the default font."
#define ERR_TRUNCATE             "The file will be truncated for viewing only\ndue to it's size.\nHowever, the entire file will be printed\n"
#define ERR_UNABLE_FIND_STRING   "Unable to find search string\nin this file."
#define ERR_UNABLE_CREATE_HEAP   "Unable to create a heap to allocate memory from."
#define ERR_UNABLE_FREE_MEM      "Unable to free memory from heap"
#define ERR_UNABLE_FREE_HEAP     "Unable to free heap"
#define ERR_UNABLE_ALLOC_MEM     "Unable to allocate memory from heap"
#define ERR_FONT_NO_KERN_PAIRS   "This font has no kerning pairs defined"

// ERROR TYPE ( NLS please translate the following strings )
#define ERROR_TYPE_TRYAGAIN      "Try Again"
#define ERROR_TYPE_SYNTAX        "How to start Font Test"
#define ERROR_TYPE_VERIFY        "Confirm Request"

// Information saved messages ( NLS please translate the following strings )
#define MSG_COLORS_SAVED         "The selected color information has been saved as this program's default colors."
#define MSG_FONT_SAVED           "The selected font information has been saved as this program's default font information."
#define MSG_FORMAT_SAVED         "The selected format options have been saved as this program's default format information."
#define MSG_QUEUE_SAVED          "Print queue and Job Properties to be used have been saved as program's defaults"
#define MSG_VERIFY_DEFAULT       "Do you really want to reset all\nQueue, Color, Font and Text Format\nselections to defaults?"
#define MSG_SYNTAX_HELP          "To browse : 'FT32 <filename>'\nTo print :     'FT32 <filename> /p'"

// Font dialog messages ( NLS please translate the following strings )
#define NONE_AVAILABLE           "None Available"
#define NONE_SELECTED            "None Selected"
#define FIXED_MSG                "Fixed Pointsize"
#define SCALABLE_MSG             "Scalable Pointsize"
#define DEVICE_FONT_MSG          "Device Font"
#define SYSTEM_FONT_MSG          "System Font"

