/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDTSUBR
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdt_SetOpaqueRect
 *             prdt_ChainTextBand
 *             prdt_GetStartPos
 *             prdt_GetStringWidth
 *             prdt_GetStrikeoutRect
 *             prdt_FillRectangle
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_32                     /* CON3201 */
#define INCL_DOSPROCESS             /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS              /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#define INCL_GRE_XFORMS
#include <pmddi.h>
#undef INCL_DDICOMFLAGS
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC
#undef INCL_GRE_XFORMS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                      /* CON3201 */

#include <prdconse.h>
#include <prdbcone.h>
#include <prddcone.h>
#include <prdtcone.h>

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdcextf.h>
#include <prdgextf.h>
#include <prdiextf.h>
#include <prdtextf.h>
#include <prduextf.h>

/******************************************************************************/
/*  Set up access to engine convert function                                  */
/******************************************************************************/
extern PFNL  da_Convert;
extern PFNL  da_ConvertWithMatrix;

/******************************************************************************/
/*  FUNCTION: prdt_ChainTextBand                                              */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  lpGTBEntry  lpNewEntry;                                                   */
/*  lpDCI       DCIData;                                                      */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  Inserts a graphics text band entry into the chain of graphics text band   */
/*  entries which is anchored in the DC Instance data.  The order of the      */
/*  entries in the graphics text band is from top left to bottom right.       */
/******************************************************************************/
/* CON3201
VOID prdt_ChainTextBand(lpNewEntry, DCIData)

lpGTBEntry  lpNewEntry;
lpDCI       DCIData;
*/

VOID prdt_ChainTextBand(lpGTBEntry  lpNewEntry,
                        lpDCI       DCIData)

{
#define TFUNC "prdt_ChnTxtBand"

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    lpGTBEntry  *  lplpGTBEntry;    /* Pointer to the pointer to a GTB     */
                                       /* entry                               */

    /**************************************************************************/
    /*  Step through each entry in the graphics text band list.  This loop    */
    /*  will exit from the middle when a new entry is inserted into the chain.*/
    /*  Note that it cannot step beyond the end of the list because a FNULL   */
    /*  pointer in the GTBNextEntry is detected indside the loop.             */
    /**************************************************************************/
    for (lplpGTBEntry = (lpGTBEntry  *)&(DCIData->DCICurrBand.BDTextBand); ;
         lplpGTBEntry = (lpGTBEntry  *)&((*lplpGTBEntry)->GTBNextEntry))
    {
        if (*lplpGTBEntry == FNULL)
        {
            /******************************************************************/
            /*  There are no more entries in the graphics text band so add the*/
            /*  new entry at the end of the list.                             */
            /******************************************************************/
            *lplpGTBEntry = lpNewEntry;
            break;
        }

        /**********************************************************************/
        /*  Test whether the new entry should come next.  For the new entry to*/
        /*  come next its y position must be strictly greater than the current*/
        /*  entry's y position or else it must have the same y position as the*/
        /*  current entry and its x position must be strictly less than the   */
        /*  current entry's x position.                                       */
        /**********************************************************************/
        if ((lpNewEntry->GTBTxtPos.y > (*lplpGTBEntry)->GTBTxtPos.y) ||
            ((lpNewEntry->GTBTxtPos.y == (*lplpGTBEntry)->GTBTxtPos.y) &&
             (lpNewEntry->GTBTxtPos.x < (*lplpGTBEntry)->GTBTxtPos.x)))
        {
            /******************************************************************/
            /*  The new entry should be inserted before the current entry so  */
            /*  swap pointers to do this (*lplpGTBEntry will access either the*/
            /*  pointer in the DC Instance data to the first entry in the text*/
            /*  band or it will access the GTBNextEntry field of a graphics   */
            /*  text band)                                                    */
            /******************************************************************/
            lpNewEntry->GTBNextEntry = *lplpGTBEntry;
            *lplpGTBEntry = lpNewEntry;
            break;
        }
    }
}
#undef TFUNC


/******************************************************************************/
/*  FUNCTION: prdt_SetOpaqueRect                                              */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  HDC     DcH;            DC handle                                         */
/*  PRECTL  ArgOpaqueRect;  Given opaque rectangle                            */
/*  USHORT  Color;          Color to set rectangle to                         */
/*  USHORT  Command;        Command word                                      */
/*  lpDCI   DCIData;        Pointer to DC Instance data                       */
/*  PBYTE   GS_PatternPtr;  Pointer to GreyScale Pattern. NULL if no greyscale*/
/*                            (PD00076)                                       */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function produces an opaque rectangle.  It handles clipping and      */
/*  bounds accumulation.  Note that all the rectangles used are EXCLUSIVE     */
/*  except for the bounds rectangle which is INCLUSIVE.                       */
/******************************************************************************/
/*CON3201
USHORT  prdt_SetOpaqueRect(DcH, ArgOpaqueRect, Color, Command,
                                 DCIData, GS_PatternPtr)

HDC     DcH;
PRECTL  ArgOpaqueRect;
USHORT  Color;
USHORT  Command;
lpDCI   DCIData;
PBYTE   GS_PatternPtr;
*/

USHORT  prdt_SetOpaqueRect(HDC     DcH,
                           PRECTL  ArgOpaqueRect,
                           USHORT  Color,
                           ULONG   Command,         /* CON3201 */
                           lpDCI   DCIData,
                           PBYTE   GS_PatternPtr)

{
#define TFUNC "prdt_SetOpqRect"

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    USHORT        i, x, y;             /* Loop control variables              */
    pBMListEntry  ListEntry;           /* Pointer to bitmap list entry        */
    DevRect       lcClipReg;           /* Current clip rectangle              */
    DevRect       OpaqueRect;          /* Opaque rect in device coords        */
    RECTL         BoundsRectL;
    USHORT        Mask;                /* Mask for the greyscale pattern byte */
    USHORT        RowCount;
    PBYTE         pPatternRow;

    /**************************************************************************/
    /*  Set up OpaqueRect in device coords - this function always works in    */
    /*  device coords.                                                        */
    /**************************************************************************/
    if (prdg_Convert((PULONG)ArgOpaqueRect, (PULONG)OpaqueRect, COORD_WORLD,
                     COORD_DEVICE_WORD, 2L, (hanDC)DcH, Command) != OK)
        return(ERROR_ZERO);

    /**************************************************************************/
    /*  Do main processing only if the COM_DRAW bit is set.                   */
    /**************************************************************************/
    if (Command & COM_DRAW)
    {

        /**********************************************************************/
        /*  Find the current bitmap                                           */
        /**********************************************************************/
        ListEntry = (pBMListEntry)DCIData->DCISelBitmap;

        /**********************************************************************/
        /*  PD00267 : Pick up the bounding rectangle for the image and pass it*/
        /*  to prdi_GetNextClip().                                            */
        /**********************************************************************/
        BoundsRectL.xLeft   = (ULONG)OpaqueRect[0].X;
        BoundsRectL.yBottom = (ULONG)OpaqueRect[0].Y;
        BoundsRectL.xRight  = (ULONG)OpaqueRect[1].X + 2; /* PD00308...       */
        BoundsRectL.yTop    = (ULONG)OpaqueRect[1].Y + 2; /* PD00308...       */

        /**********************************************************************/
        /*  For every valid clip rectangle prdi_GetNextClip returns..         */
        /**********************************************************************/
        for (i = 1; prdi_GetNextClip(DCIData, i, (DevRect  *)lcClipReg,
                                     &BoundsRectL); i++)
        {

            /******************************************************************/
            /*  Intersect with band - if empty try next clip rect.            */
            /******************************************************************/
            if (!prdi_ClipIntSect((DevRect  *)DCIData->DCICurrBand.BDCoords,
                                  (DevRect  *)lcClipReg))
                continue;

            /******************************************************************/
            /*  Intersect with the opaque region - if empty try next clip     */
            /*  rect.                                                         */
            /******************************************************************/
            if (!prdi_ClipIntSect((DevRect  *)OpaqueRect,
                                  (DevRect  *)lcClipReg))
                continue;

            if (GS_PatternPtr)                        /*  PD00076     */
            {
               pPatternRow = GS_PatternPtr;
               RowCount = GS_PATTERN_HEIGHT;
               /************************************************************/
               /*  Opaque the rectangle off using prdb_MixPel - always use */
               /*  overpaint regardless of text bundle settings.           */
               /*  for cause the code coverage tool to break.              */
               /************************************************************/
               for (y = lcClipReg[0].Y; y < lcClipReg[1].Y; y++)
               {
                 Mask = 0x80;

                 if ( ++RowCount < GS_PATTERN_HEIGHT )
                  {
                     pPatternRow++;
                  }
                  else
                  {
                     pPatternRow = GS_PatternPtr;
                     RowCount = 0;
                  }
                  for (x = lcClipReg[0].X; x < lcClipReg[1].X; x++)
                  {
                     if (*pPatternRow & Mask)
                     {
                        (VOID)prdb_MixPel(ListEntry, x, y, (BYTE)Color,
                                          FM_ONE);
                     }
                     else
                     {
                         (VOID)prdb_MixPel(ListEntry, x, y, (BYTE)Color,
                                           FM_ZERO);
                     }
                     /****************************************************/
                     /*  Advance the mask to the next position,          */
                     /****************************************************/
                     Mask >>= 1;
                     if (Mask == 0)
                        Mask = 0x80;
                  }

               }
            }
            else
            {
               /*************************************************************/
               /*  Opaque the rectangle off using prdb_MixPel - always use  */
               /*  overpaint regardless of text bundle settings.            */
               /*  for cause the code coverage tool to break.               */
               /*************************************************************/
               for (y = lcClipReg[0].Y; y < lcClipReg[1].Y; y++)
               {
                   for (x = lcClipReg[0].X; x < lcClipReg[1].X; x++)
                   {
                       (VOID)prdb_MixPel(ListEntry, x, y, (BYTE)Color,
                                         FM_OVERPAINT);
                   }
               }
            }

            /******************************************************************/
            /*  Set the device text only flag to FALSE since weve just drawn  */
            /*  into the band.                                                */
            /******************************************************************/
            DCIData->TextOnlyDC = FALSE;
        }
    }

    /**************************************************************************/
    /*  Accumulate bounds if necessary - any clipping is ignored when         */
    /*  calculating the bounds.                                               */
    /**************************************************************************/
    if (Command & COM_BOUND)
    {
        OpaqueRect[1].X--;
        OpaqueRect[1].Y--;
        (VOID)prdg_AddBounds((DevRect *)OpaqueRect, DCIData);
    }
    return (OK);
}
#undef TFUNC


/******************************************************************************/
/*  FUNCTION: prdt_GetStartPos                                                */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function gets the start position from either ArgStart or from the    */
/*  DCIData and returns them in the required coords - ReqdCoords should be set*/
/*  to COORD_WORLD, COORD_DEVICE or COORD_FONT.  The coords are always        */
/*  returned in ULONGs.                                                       */
/******************************************************************************/
/*CON3201
USHORT prdt_GetStartPos(DcH, ArgStart, ArgOptions, pReqdCoords, ReqdType,
                               Command, DCIData)

HDC      DcH;
PPOINTL  ArgStart;
ULONG    ArgOptions;
PPOINTL  pReqdCoords;
USHORT   ReqdType;
USHORT   Command;
lpDCI    DCIData;
                  */

USHORT prdt_GetStartPos(HDC      DcH,
                        PPOINTL  ArgStart,
                        ULONG    ArgOptions,
                        PPOINTL  pReqdCoords,
                        USHORT   ReqdType,
                        ULONG    Command,     /* CON3201 */
                        lpDCI    DCIData)

{

    /**************************************************************************/
    /*  Local Variables.                                                      */
    /**************************************************************************/
    POINTL   LongCoords;
    PPOINTL  pGivenCoords;
    USHORT   GivenType;
    XFORM    xfm;

    /**************************************************************************/
    /*  Ensure any COORD_WORD bit flag is off leaving just the coord type.    */
    /**************************************************************************/
    ReqdType &= COORD_TYPE_MASK;
    if (ArgOptions & CHS_START_XY)
    {

        /**********************************************************************/
        /*  Given start coords are in ArgStart.                               */
        /**********************************************************************/
        if ((Command & COM_TRANSFORM) && (ReqdType == COORD_FONT))
        {

            /******************************************************************/
            /*  If given in world and reqd in font need to get xform matrix to*/
            /*  retain maximum accuracy possible.                             */
            /******************************************************************/
            if (prdg_GetXformMatrix(DcH, WORLD_TO_FONT | KEEP_ORIGIN_SHIFT,
                                    (PXFORM)&xfm, DCIData) != OK)
                return(ERROR_ZERO);
            LongCoords = *ArgStart;
            if (!da_ConvertWithMatrix(DcH, (PPOINTL)&LongCoords, 1L,
                                      (PXFORM)&xfm, 0L, NGreConvertWithMatrix))
                return(ERROR_ZERO);
            pGivenCoords = &LongCoords;
            GivenType    = COORD_FONT;
        }
        else
        {
            pGivenCoords = ArgStart;
            GivenType = (Command & COM_TRANSFORM) ? COORD_WORLD : COORD_DEVICE;
        }
    }
    else
    {

        /**********************************************************************/
        /*  Pick up from the DCIData.                                         */
        /**********************************************************************/
        if (ReqdType == COORD_WORLD)
        {
            pGivenCoords = (PPOINTL)&DCIData->DCICurrPosWcs;
            GivenType    = COORD_WORLD;
        }
        else if (ReqdType == COORD_DEVICE)
        {
            pGivenCoords = (PPOINTL)&DCIData->DCICurrPosDev;
            GivenType    = COORD_DEVICE_WORD;
        }
        else                           /* ReqdType == COORD_FONT              */
        {
            if (DCIData->DCIStateFlags & FONT_COORDS_VALID)
            {
                pGivenCoords = (PPOINTL)&DCIData->DCICurrPosFont;
                GivenType    = COORD_FONT_WORD;
            }
            else
            {
                pGivenCoords = (PPOINTL)&DCIData->DCICurrPosDev;
                GivenType    = COORD_DEVICE_WORD;
            }
        }
    }

    /**************************************************************************/
    /*  Ensure given coords are now in ULONGs.  LongCoords will not have been */
    /*  used above if COORD_WORD set so no conflict in usage here.            */
    /**************************************************************************/
    if (GivenType & COORD_WORD)
    {
        LongCoords.x = (LONG)((PPOINTS)pGivenCoords)->x;
        LongCoords.y = (LONG)((PPOINTS)pGivenCoords)->y;
        pGivenCoords = &LongCoords;
        GivenType   &= ~COORD_WORD;
    }
    if (GivenType == ReqdType)
    {
        *pReqdCoords = *pGivenCoords;
    }
    else
    {
        if (ReqdType != COORD_FONT)
        {

            /******************************************************************/
            /*  Need to convert between Device and World.                     */
            /******************************************************************/
            if (prdg_Convert((PULONG)pGivenCoords, (PULONG)pReqdCoords,
                             GivenType, ReqdType, 1L, (hanDC)DcH,
                             COM_TRANSFORM) != OK)
                return(ERROR_ZERO);
        }
        else
        {

            /******************************************************************/
            /*  Must be Device -> Font.                                       */
            /******************************************************************/
            /******************************************************************/
            /* PD00550 : Cast return value to SHORT in both calls below to    */
            /* force the sign to extend to high word when converted to LONG.  */
            /******************************************************************/
            pReqdCoords->x = (LONG)(SHORT)prdt_XformFontValue(
                                                       (USHORT)pGivenCoords->x,
                                                       DEVICE_TO_FONT |
                                                       CONV_X_VALUE,
                                                       &DCIData->DCIFontData);
            pReqdCoords->y = (LONG)(SHORT)prdt_XformFontValue(
                                                       (USHORT)pGivenCoords->y,
                                                       DEVICE_TO_FONT |
                                                       CONV_Y_VALUE,
                                                       &DCIData->DCIFontData);
        }
    }
    return (OK);
}

/******************************************************************************/
/*  FUNCTION: prdt_GetStringWidth                                             */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function returns the string width either in world coords (if outline */
/*  or in mode 2 or position vectors are supplied) or in font coords.  It     */
/*  should only be used for device fonts.                                     */
/******************************************************************************/
/*CON3201
LONG  prdt_GetStringWidth(ArgCharNum, ArgCodePoints, PosVector, DCIData)

LONG   ArgCharNum;
PCH    ArgCodePoints;
PLONG  PosVector;
lpDCI  DCIData;
*/

LONG  prdt_GetStringWidth(LONG   ArgCharNum,
                          PCH    ArgCodePoints,
                          PLONG  PosVector,
                          lpDCI  DCIData)

{

    /**************************************************************************/
    /*  Local Variables.                                                      */
    /**************************************************************************/
    USHORT          i;
    ULONG           StringWidth;
    ULONG           CharWidth;
    lpFontDataType  pFontData;
    lpFontInfoType  pFontInfo;

    /**************************************************************************/
    /*  Set up local pointers.                                                */
    /**************************************************************************/
    pFontData = &DCIData->DCIFontData;
    pFontInfo = &pFontData->Info;
    StringWidth = 0L;
    if (PosVector)
    {
        for (i = 0; i < (USHORT)ArgCharNum; i++)
            StringWidth += PosVector[i];
    }
    else
    {
        if ((pFontInfo->pFont->WidthFlag & FMF_WIDTH_MASK) != 0)
        {

            /******************************************************************/
            /*  Fixed pitch font...                                           */
            /******************************************************************/
            StringWidth = ArgCharNum * pFontData->CPtInfo.WidthInWorkCoords;
        }
        else
        {

            /******************************************************************/
            /*  Proportional font...                                          */
            /******************************************************************/
            for (i = 0; i < (USHORT)ArgCharNum; i++)
            {
                prdt_NextCodePoint((USHORT)ArgCodePoints[i], pFontData,
                                   DCIData);
                StringWidth += pFontData->CPtInfo.WidthInWorkCoords;
            }
        }
    }
    return(StringWidth);
}

/******************************************************************************/
/* PD00076 : Moved prdt_GetstrikeoutRect from prdtsub1.c to this file since   */
/* it is now called for all three drivers.                                    */
/******************************************************************************/
/******************************************************************************/
/* FUNCTION: prdt_GetStrikeoutRect                                            */
/*                                                                            */
/*                                                                            */
/* PARAMETERS:                                                                */
/*                                                                            */
/* USHORT Position character baseline                                         */
/* USHORT Angle 0 to 360 deg                                                  */
/* USHORT Shear 0 to 360 deg                                                  */
/* USHORT StrikeBottom offset to bottom of strikeout rect                     */
/* USHORT StrikeTop offset to top of strikeout rect                           */
/*                                                                            */
/* PFOURPOINTL PFourPt four points of the rect                                */
/*                                                                            */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*                                                                            */
/* This function sets up the four corners of the strikeout rectangle taking   */
/* into account the angle and shear of the character.                         */
/*                                                                            */
/******************************************************************************/
/*
VOID prdt_GetStrikeoutRect (
                                   Position,
                                   Angle,
                                   Shear,
                                   StrikeBottom,
                                   StrikeTop,
                                   Width,
                                   pFourPt)
POINTL          Position;
USHORT          Angle;
USHORT          Shear;
LONG            StrikeBottom;
LONG            StrikeTop;
USHORT          Width;
PFOURPOINTL     pFourPt;
*/

VOID prdt_GetStrikeoutRect (POINTL          Position,
                            USHORT          Angle,
                            USHORT          Shear,
                            LONG            StrikeBottom,
                            LONG            StrikeTop,
                            USHORT          Width,
                            PFOURPOINTL     pFourPt)

{
#define TFUNC "prdt_GetStrikeoutRect"

    /**************************************************************************/
    /* Local variables                                                        */
    /**************************************************************************/

    /**************************************************************************/
    /* Ignore the values calculated in GetStringInfo.  Use the current        */
    /* position and offsets, which allow for -ve CharBox, etc.                */
    /**************************************************************************/

    /**************************************************************************/
    /* There are four possible orientations of the character cell, depending  */
    /* on the PrintedAngle - this must be reflected in the strikeout          */
    /* rectangle, which may be horizontal or vertical.                        */
    /*                                                                        */
    /* NOTE no correction is made here for shearing, which should shift the   */
    /* strikeout rectangle horizontally.  The correction is: delta =          */
    /* StrikeBottom * tan( PrintedShear ) for upright characters (Ignoring    */
    /* possible shearing of the actual rectangle...)                          */
    /*                                                                        */
    /* NOTE in device coordinates (not font coordinates).                     */
    /**************************************************************************/
    pFourPt->BottomLeft  = Position;
    pFourPt->BottomRight = Position;
    pFourPt->TopLeft     = Position;
    pFourPt->TopRight    = Position;

    switch ( ((Angle + 45) / 90) % 4)
    {
        /**********************************************************************/
        /* Note: the four corners are correctly labelled 'TopRight' etc.  with*/
        /* the following asignments.                                          */
        /**********************************************************************/
        case 0:                                 /* 315 to  45 degrees */
            pFourPt->BottomLeft.y  += StrikeBottom;
            pFourPt->BottomRight.y += StrikeBottom;
            pFourPt->TopLeft.y     += StrikeTop;
            pFourPt->TopRight.y    += StrikeTop;

            pFourPt->BottomRight.x += Width;
            pFourPt->TopRight.x    += Width;
            /******************************************************************/
            /* Shear : add delta to all x coordinates.                        */
            /******************************************************************/
            break;

        case 1:                                 /*  45 to 135 degrees */
            pFourPt->TopLeft.y     += Width;
            pFourPt->TopRight.y    += Width;

            pFourPt->BottomLeft.x  -= StrikeTop;
            pFourPt->TopLeft.x     -= StrikeTop;
            pFourPt->BottomRight.x -= StrikeBottom;
            pFourPt->TopRight.x    -= StrikeBottom;
            /******************************************************************/
            /* Shear add delta to all y coordinates.                          */
            /******************************************************************/
            break;

        case 2:                                 /* 135 to 225 degrees */
            pFourPt->BottomLeft.y  -= StrikeTop;
            pFourPt->BottomRight.y -= StrikeTop;
            pFourPt->TopLeft.y     -= StrikeBottom;
            pFourPt->TopRight.y    -= StrikeBottom;

            pFourPt->BottomLeft.x -= Width;
            pFourPt->TopLeft.x    -= Width;
            /******************************************************************/
            /* Shear subtract delta from all x-coordinates.                   */
            /******************************************************************/
            break;

        case 3:                                 /* 225 to 315 degrees */
            pFourPt->BottomLeft.y  -= Width;
            pFourPt->BottomRight.y -= Width;

            pFourPt->BottomLeft.x  += StrikeBottom;
            pFourPt->TopLeft.x     += StrikeBottom;
            pFourPt->BottomRight.x += StrikeTop;
            pFourPt->TopRight.x    += StrikeTop;
            /******************************************************************/
            /* Shear subtract delta from all y-coordinates.                   */
            /******************************************************************/
            break;

    }
}
#undef TFUNC

/******************************************************************************/
/* PD00076 : Moved prdt_FillRectangle from prdtsub1.c to this file since      */
/* it is now called for all three drivers.                                    */
/******************************************************************************/

/******************************************************************************/
/*  FUNCTION: prdt_FillRectangle                             PD00073          */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  HDC     DcH;            DC handle                                         */
/*  PRECTL  ArgOpaqueRect;  Given rectangle to fill                           */
/*  USHORT  Color;          Color to set rectangle to                         */
/*  USHORT  Command;        Command word                                      */
/*  lpDCI   DCIData;        Pointer to DC Instance data                       */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function draws into the bitmap a solid rectangle. No clipping or     */
/*  bounding is done on the rectangle. The rectangle passed in is in          */
/*  device coordinates.                                                       */
/*                                                                            */
/******************************************************************************/
/*CON3201
USHORT  prdt_FillRectangle(DcH, pFillRect, Color, Command, DCIData)

HDC     DcH;
DevRect  * pFillRect;
BYTE    Color;
USHORT  Command;
lpDCI   DCIData;
*/

USHORT  prdt_FillRectangle(HDC     DcH,
                           DevRect  * pFillRect,
                           BYTE    Color,
                           ULONG   Command,     /* CON3201 */
                           lpDCI   DCIData)

{
#define TFUNC "prdt_FillRectangle"

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    SHORT         x, y;                /* Loop control variables              */
    pBMListEntry  ListEntry;           /* Pointer to bitmap list entry        */


    /**************************************************************************/
    /*  Do main processing only if the COM_DRAW bit is set.                   */
    /**************************************************************************/
    if (Command & COM_DRAW)
    {
        /**********************************************************************/
        /*  Find the current bitmap                                           */
        /**********************************************************************/
        ListEntry = (pBMListEntry)DCIData->DCISelBitmap;

        /**********************************************************************/
        /* Fill the rectangle off using prdb_MixPel - always use overpaint    */
        /* regardless of text bundle settings.                                */
        /**********************************************************************/
        for (y = (*pFillRect)[0].Y; y < (*pFillRect)[1].Y; y++)
        {
           for (x = (*pFillRect)[0].X; x < (*pFillRect)[1].X; x++)
           {
              prdb_MixPel(ListEntry, x, y, (BYTE)Color,
                                      FM_OVERPAINT);
           }
        }

        /**********************************************************************/
        /* Set the device text only flag to FALSE since weve just drawn into  */
        /* the band.                                                          */
        /**********************************************************************/
        DCIData->TextOnlyDC = FALSE;
    }
    return (OK);
}
#undef TFUNC

