/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDPPREP
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS    prdn_PrepareNewDocument
 *              prdn_PrepareNextPage
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                        /* CON3201 */
#define INCL_DOSPROCESS                /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSFILEMGR
#define INCL_SPL
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                 /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSFILEMGR
#undef INCL_SPL
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_GRE_JOURNALING
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_GRE_JOURNALING

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#include <prdconse.h>

#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef INCL_32                         /* CON3201 */

#include <prdaextf.h>
#include <prdeextf.h>
#include <prdjextf.h>
#include <prdiextf.h>
#include <prdgextf.h>
#include <prdpextf.h>
#include <prdyextf.h>
#include <prdnextf.h>
#include <prdncone.h>

extern USHORT               OutlineCodepageEntries;

/******************************************************************************/
/*  FUNCTION   prdn_PrepareNewDocument                                        */
/*                                                                            */
/*  PARAMETERS                                                                */
/*                                                                            */
/*  lpDCI  DCIData                                                            */
/*                                                                            */
/*  DESCRIPTION                                                               */
/*                                                                            */
/*  Starts metafiling if required.  Calls PrepareNextPage to setup a page     */
/*  ready for drawing.                                                        */
/******************************************************************************/
USHORT prdn_PrepareNewDocument(lpDCI DCIData)


{
    if (DCIData->Flags & QUEUED_STD)
    {

        /**********************************************************************/
        /*  Start metafiling.                                                 */
        /**********************************************************************/
        if (SplStdStart((HDC)DCIData->DcH) != OK)
        {
            return(ERROR_NEG);
        }
    }

    /**************************************************************************/
    /*  Now get first page ready.                                             */
    /**************************************************************************/
    if (prdn_PrepareNextPage(DCIData) != OK)
    {
        return(ERROR_NEG);             /* e.g. insufficient memory            */
    }
    return(OK);
}

/******************************************************************************/
/*  FUNCTION   prdn_PrepareNextPage                                           */
/*                                                                            */
/*  PARAMETERS                                                                */
/*                                                                            */
/*  lpDCI  DCIData                                                            */
/*                                                                            */
/*  DESCRIPTION                                                               */
/*                                                                            */
/*  Called from PrepareNewDocument, NewFrame.  Sets up a band, and resets the */
/*  Drawn flag.                                                               */
/******************************************************************************/
USHORT prdn_PrepareNextPage(lpDCI DCIData)


{
    lpPDBI     PDBI;                   /* Pointer to PDB Data                 */
    lpDDTType  pDDT;                   /* Pointer to the DDT                  */
    USHORT     i;
    ULONG      DResult;

    PDBI = DCIData->DCIPdbInstance;
    pDDT = &PDBI->DDT;
    if (DCIData->DCIPageNumber == 2 && PDBI->NumberOfForms == 2)
    {

        /**********************************************************************/
        /*  Setup the second form information - clips, margins etc.  This was */
        /*  not done in the old code.                                         */
        /**********************************************************************/
        prde_GetFormDimensions(PDBI, 1);

        /**********************************************************************/
        /* PD00663 : Reset number of clips and force call to prdi_DefaultClip */
        /* routine below to update DCIData->DciClipRects with clips for       */
        /* the second page of a dual form job.                                */
        /**********************************************************************/
        DCIData->DCIClipNum = 0;
    }

    /**************************************************************************/
    /*  Initialise band coords.                                               */
    /**************************************************************************/
    if (PDBI->Orientation == PORTRAIT)
    {
        DCIData->DCIBandLowY  = PDBI->PageDepthPels;
        DCIData->DCIJournLowY = 0;
    }
    else
    {
        DCIData->DCIBandLowY  = 0;
        DCIData->DCIJournLowY = PDBI->PageDepthPels;
    }

    /**************************************************************************/
    /*  Get memory for the band                                               */
    /**************************************************************************/
    if ( prdj_MakeBand( DCIData, &DCIData->DCICurrBand ) != OK )
    {
        return( ERROR_NEG );  /* insufficient memory? */
    }

    /**************************************************************************/
    /*  Call GetClipRects to get a new set of clip rectangles for the new band*/
    /*  and return an error if this fails.  Allow for the possibility of the  */
    /*  default clip rectangle.                                               */
    /*                                                                        */
    /*  PD00018 : Call prdi_DefaultClip() directly if requesting the default  */
    /*  clips rather than calling prdi_GetClipRects() with ArgComplexity of 0.*/
    /*  Also, changed parm list for prdi_GetClipRects().                      */
    /*                                                                        */
    /*  PD00305 : No longer need to call prdi_GetClipRects() since we cache   */
    /*  the clips and process on the fly.                                     */
    /**************************************************************************/
    if (DCIData->DCIClipNum == 0)      /* PD00305 : No clips - use defaults   */
    {
        (VOID)prdi_DefaultClip(DCIData);
    }

    /**************************************************************************/
    /*  Reset the drawn flag.                                                 */
    /**************************************************************************/
    DCIData->Flags &= ~DRAWN_INTO;

    /**************************************************************************/
    /*  Set number of used cards and the indices to zero.  This was done in   */
    /*  NewFrame (old code), and ensures that card prompting works.           */
    /**************************************************************************/
    DCIData->DCICardCount = 0;

    for (i = 0; i < MAX_NO_OF_CARD_SLOTS; i++)
        DCIData->DCICardIndx[i] = 0;

    /**************************************************************************/
    /*  Reset the flags for download fonts to reflect that all temporary      */
    /*  downloaded fonts on the printer have been deleted (due to a SIC kicked*/
    /*  off by NewFrame).                                                     */
    /*                                                                        */
    /*  Note that the flags for permanent fonts are not used - space is       */
    /*  allocated for them to make cycling through the download fonts easier. */
    /*                                                                        */
    /*  The temporary download fonts are handled on a per page basis.         */
    /*                                                                        */
    /*  Note: Do not reset FontLoaded flags, as no inter-page SIC is issued.  */
    /*  These are kept through an entire job.                                 */
    /**************************************************************************/
    for (i = 0; i < DCIData->DCINoOfDownFonts; i++)
    {
        DCIData->DCIDownFontFlags[i].Used = FALSE;
    }

    /**************************************************************************/
    /*  Reset the download codepage Used flags at the start of each page for  */
    /*  all entries in the global codepage table for MultiCp outline fonts.   */
    /*  The Used flag for a codepage is set in prdt_TextOutDevFont if the font*/
    /*  used is a MultiCp one with that codepage (detected from cp field in   */
    /*  MatchNo).                                                             */
    /**************************************************************************/
    for (i = 0; i < OutlineCodepageEntries; i++)
    {
        DCIData->DCIDownCpFlags[i].Used = FALSE;
    }

    /**************************************************************************/
    /*  If device context is Direct and there is more than one band or if     */
    /*  device context is Queued and the data type is Raw and there is more   */
    /*  than one band.                                                        */
    /**************************************************************************/
#ifdef DDT_BANDING
    if ((pDDT->DDTBandsPerPage != 1) &&
        (DCIData->Flags & (DIRECT | QUEUED_RAW)))
    {

        /**********************************************************************/
        /*  Direct DC in IBM_Q_STD or IBM_Q_RAW format, or Queued DC in       */
        /*  IBM_Q_RAW format.  Create a temporary GRE Journal, for use for    */
        /*  Banding or Spooling.                                              */
        /**********************************************************************/

        /**********************************************************************/
        /*  Call GreCreateJournalFile.  JNL_TEMP_FILE indicates that we want  */
        /*  to create a temporary file.  JNL_DRAW_OPTIMIZATION means the draw */
        /*  bit will be left on whilst accumulating the journal.              */
        /*  JNL_BOUNDS_OPTIMIZATION means that bounding will be turned off on */
        /*  playback of the journal.                                          */
        /**********************************************************************/
        DCIData->DCIJournHandle = GreCreateJournalFile( FNULL,
                                      (ULONG)(JNL_TEMP_FILE |
                                      JNL_DRAW_OPTIMIZATION |
                                      JNL_BOUNDS_OPTIMIZATION), (ULONG)0);

        /**********************************************************************/
        /*  Check that we have managed to create a journal and return an error*/
        /*  if it has failed.                                                 */
        /**********************************************************************/
        if (DCIData->DCIJournHandle == FNULL)
        {
            TRACE4(TFUNC, "Fail CreateJournal", FNULL, 0);
            return((USHORT)ERROR_NEG);
        }
        TRACE4(TFUNC, "Journal Handle", &DCIData->DCIJournHandle, 1);
        TRACE4(TFUNC, "Start Journal", &DCIData->DCIJournHandle,1);

        /**********************************************************************/
        /*  Start the journal file we have created.                           */
        /**********************************************************************/
        DResult = GreStartJournalFile(DCIData->DcH, DCIData->DCIJournHandle);
        if (DResult != OK)
        {
            TRACE4(TFUNC, "Fail StartJournal", FNULL, 0);
            return((USHORT)ERROR_NEG);
        }
        TRACE4(TFUNC, "Journal Started OK", FNULL, 0);
    }
#endif /* def DDT_BANDING */
    return(OK);
}
