/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDPINIT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdn_InitialisePrinter
 *             prdn_InitPrinterPage1
 *             prdn_InitPrinterAllPages
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_32                        /* CON3201 */
#define INCL_DOSPROCESS                /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSPROCESS
#define INCL_SPL
#include <os2.h>
#undef INCL_DOSPROCESS                 /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSPROCESS
#undef INCL_SPL

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                            /* CON3201 */

#include <prdconse.h>
#include <prddcone.h>
#include <prdmcone.h>
#include <prdpcone.h>
#include <prdtcone.h>

#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL

#include <prdeextf.h>
#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdgextf.h>
#include <prdpextf.h>
#include <prdyextf.h>
#include <prdnextf.h>
#include <prduextf.h>
#include <prdncone.h>
#include <prdztrcf.h>


extern HMODULE              prdd_ModHandle;
extern USHORT               DRIVER_TYPE;





/******************************************************************************/
/* The comment below is from PrintStart and explains the ordering             */
/* of the init codes.                                                         */
/*                                                                            */
/* The initialise branch does the following:                                  */
/*                                                                            */
/* - prompts the user to insert cards if necessary                            */
/* - does an initialising SIC/set of escape sequences                         */
/* - downloads any initial code page and initial download fonts               */
/* - sends escape sequences to set up page length, aspect ratio,              */
/*   line spacing, etc..                                                      */
/* - does a PPM and prompts the user to insert forms if necessary             */
/* - downloads dynamic download fonts                                         */
/*                                                                            */
/* This order is IMPORTANT:                                                   */
/*                                                                            */
/* - cards cannot be changed after a SIC else the card fonts                  */
/*   wont be recognised by the printer (this certainly true for               */
/*   the 4019; keep the architecture the same here).                          */
/*                                                                            */
/* - the PPM command must come after any SICs (else the SIC will              */
/*   muck up the printers concept of which form it is using);                 */
/*   note that downloading the initial code page may be done                  */
/*   with a SIC.                                                              */
/*                                                                            */
/* - the page settings (e.g. page length, line spacing) must be               */
/*   done after initialising sequences or SICs as the latter may              */
/*   affect these settings.                                                   */
/*                                                                            */
/* - the function which downloads initial fonts deletes all                   */
/*   the temporary (or dynamic) fonts; hence this function must               */
/*   be called before the dynamic fonts are downloaded.                       */
/*                                                                            */
/* The function prde_InitialiseDownFonts sets up the initial                  */
/* code page for a job and so only needs to be called for the                 */
/* first page.  Since it also initialises CPCurrent or CPJob                  */
/* the function should ONLY be called for the first page.                     */
/*                                                                            */
/* The initialising sequences/SICs are also sent out for the                  */
/* first page only.  Note that these dont affect the download                 */
/* area due to the choice of the init parameter (see PRDDEST.C).              */
/*                                                                            */
/* Prompting is only done for a Direct DC - we cant "store up" a              */
/* prompt in a raw spooler file.                                              */
/*                                                                            */
/******************************************************************************/

SHORT prdn_InitialisePrinter( lpDCI DCIData )   /* CON3203 */
{

    USHORT      return_value;


    /**************************************************************************/
    /* Init stuff.  (Note: must be in this order!)                            */
    /*                                                                        */
    /* a. SIC/Init codes: only for start of 1st page.                         */
    /*                                                                        */
    /* b. SetVerticalUnits, PPM (prompt for forms if direct), etc:            */
    /*    between every page, Raw or normal.                                  */
    /*                                                                        */
    /**************************************************************************/

    if ( DCIData->DCIPageNumber == 1)
    {
        /**********************************************************************/
        /* do InitPrinter codes                                               */
        /**********************************************************************/
        if ( (return_value = prdn_InitPrinterPage1( DCIData )) != OK )
        {
            return( return_value );
        }
    }

    /**************************************************************************/
    /* Do SetVertUnits, PPM (form prompt if necc) etc Note: done              */
    /* between two Raw pages - still need to prompt for second form           */
    /* of dual form job (if manual).  If RawData has done formfeeds           */
    /* .....tough.                                                            */
    /**************************************************************************/
    if ( (return_value = prdn_InitPrinterAllPages( DCIData )) != OK )
    {
        return( return_value );
    }

}

/**********************************************************************/
/* FUNCTION: prdn_InitPrinterPage1                                    */
/*                                                                    */
/* PARAMETERS:                                                        */
/*                                                                    */
/* lpDCI        DCIData                                               */
/*                                                                    */
/* DESCRIPTION                                                        */
/*                                                                    */
/*    This does the initial SIC or escape codes; only done at the     */
/* start of the first page of a document.                             */
/* (Old code: PrintStart)                                             */
/*                                                                    */
/**********************************************************************/
USHORT prdn_InitPrinterPage1(lpDCI DCIData )

{

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT      return_value;
    lpPDBI      pPDB;
    lpDDTType   pDDT;          /* Pointer to the DDT                  */
    BYTE        Byte;

    /******************************************************************/
    /* Get some local pointers                                        */
    /******************************************************************/
    pPDB  = DCIData->DCIPdbInstance;
    pDDT  = &pPDB->DDT;

    /******************************************************************/
    /* The spooler tends to swallow the first few bytes sent to the   */
    /* printer if the printer is off when the job starts.  In order   */
    /* to avoid the effects of this we send down a few nul codes as a */
    /* sacrifice before we send down anything else.                   */
    /******************************************************************/
    if ( (return_value = prdp_PrintSimple(
                           DCIData,
                           USE_GLOBAL_TABLE,
                           EST_NUL_SACRIFICE,
                           FNULL )) != OK )
    {
        return( return_value );
    }

    /******************************************************************/
    /* Send the three printer initialisation Escape sequences.        */
    /* May return ERR_ABORT/ERR_PURGE (or ERROR?)                     */
    /******************************************************************/

    /**************************************************************/
    /* PD00314 : Don't send the initial SICs for Nile/Tiber/4226  */
    /* when QUEUED_RAW.                                           */
    /**************************************************************/
    if ( !( (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
            (DCIData->DCIPdbInstance->PrinterType > IBM_4224_MONO) &&
            (DCIData->Flags & QUEUED_RAW)
          )
       )
    {
        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_PRINTER_TABLE,
                               DCT_PRINTER_INIT_1,
                               FNULL) ) != OK )
        {
            return( return_value );
        }

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_PRINTER_TABLE,
                               DCT_PRINTER_INIT_2,
                               FNULL) ) != OK )
        {
            return( return_value );
        }

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_PRINTER_TABLE,
                               DCT_PRINTER_INIT_3,
                               FNULL) ) != OK )
        {
            return( return_value );
        }
    }

    /******************************************************************/
    /* Initialise the printer download area.  If required download    */
    /* all initial download fonts and the initial code page.  Note    */
    /* must be done before the PPM, as a SIC may be issued within     */
    /* this function.                                                 */
    /******************************************************************/
    if ( (return_value = prde_InitialiseDownFonts(DCIData)) != OK )
        return( return_value );

    return( OK );

}


/**********************************************************************/
/*                                                                    */
/* FUNCTION: prdn_InitPrinterAllPages                                 */
/*                                                                    */
/* PARAMETERS:                                                        */
/*                                                                    */
/* lpDCI        DCIData                                               */
/*                                                                    */
/* DESCRIPTION                                                        */
/*                                                                    */
/*  This does any SICs or whatever that must be done between every    */
/* page (except between two RawData pages). Set Vertical Units,       */
/* PPM (with form prompt if necessary), etc. done here. See PrintStart*/
/* for code.                                                          */
/*                                                                    */
/*                                                                    */
/* D. Howell - 5/1/91 - Change to use OK/CANCEL                       */
/**********************************************************************/
SHORT prdn_InitPrinterAllPages(lpDCI DCIData )   /* CON3203 */



{

    /******************************************************************/
    /*  Local Variables                                               */
    /******************************************************************/
    USHORT      return_value;
    USHORT      Result;        /* Function return code                */
    lpPDBI      PDBIData;      /* Pointer to PDB Data                 */
    lpDDTType   pDDT;          /* Pointer to the DDT                  */
    BYTE        DCTParms[4];   /* Parameter block used to set paper   */
                               /* source, text spacing, etc..         */
    PBYTE       StrPtr;
    BYTE        UserPrompt[SLEN_BOX_MESSAGE];
                               /* To prompt user to insert the card   */
                               /* or form                             */
    USHORT      FormNo;        /* First or second form                */
    USHORT      MessageId;
    USHORT      VerticalUnits;
    USHORT      AspectRatio;
    PSZ         FormName;
    BYTE        szCaption[40];
    USHORT      MaxRetLen;
    lpPrtDataEntry     PrinterData;
    lpDfltFontInfoType   pDfltFontInfo;
    PFOCAMETRICS         pMetrics;


    TRACE4(TFUNC, "Entry", FNULL, 0);

    /******************************************************************/
    /* Set up pointers.                                               */
    /******************************************************************/
    PDBIData    = DCIData->DCIPdbInstance;
    pDDT        = &PDBIData->DDT;
    PrinterData = PDBIData->PrinterData;
    pDfltFontInfo = &PDBIData->DfltDeviceFont;
    pMetrics=&pDfltFontInfo->Info.pFont->Metrics;


    /******************************************************************/
    /* Load printer family type into szCaption for use in prompts.    */
    /******************************************************************/
    Result = WinLoadString (hab,
                            prdd_ModHandle,
                            IDS_SMB_CAPTION,
                            40,
                            (PSZ)szCaption );

    /******************************************************************/
    /* Select the form size and the source.  If we have dual forms    */
    /* and this is not the first page then use the second form;       */
    /* otherwise use the first.                                       */
    /******************************************************************/
    if ( (PDBIData->NumberOfForms == 2) &&
         (DCIData->DCIPageNumber > 1) )
    {
        FormNo = 1;
    }
    else
    {
        FormNo = 0;
    }

    TRACE4(TFUNC, "0th or 1st form", &FormNo, 1);
    TRACE4(TFUNC, "Form info", &PDBIData->PPMInfo[FormNo], 2);


    /******************************************************************/
    /* PD00743: move to before manual message prompt                  */
    /******************************************************************/
    /* Set up the vertical units for text (t) and graphics (g)        */
    /* spacing - this command is not available on the 9-wire          */
    /* ProPrinters and the 4224s.                                     */
    /*                                                                */
    /* The text spacing units is always set to 1/72", i.e.            */
    /* t = 72, and in fact cannot be changed from this value on       */
    /* the 24-wire Pros.  The text spacing is used in setting         */
    /* the text line spacing - i.e. the number of lines per inch      */
    /* used for a raw text stream - and also in setting the page      */
    /* length.  Both of these are done using Esc A n.                 */
    /*                                                                */
    /* The graphics spacing units is used to set the graphics line    */
    /* spacing (with Esc 3 n) and the variable line spacing (with Esc */
    /* J n).                                                          */
    /*                                                                */
    /* Note that the graphics vertical units (and later on the        */
    /* aspect ratio) are set to the current resolution setting        */
    /* regardless of whether this is a raw data job or a band         */
    /* print.                                                         */
    /******************************************************************/
    if ( pDDT->DDTInitFlags & DDT_INIT_VERTICAL_UNITS )
    {
        /******************************************************************/
        /*  PD00222 : Nile/Tiber/4226 use a different ESC [ \ command     */
        /******************************************************************/
        if ( (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
             (PrinterData->PrinterType >  IBM_4224_MONO) )
        {
            if ( return_value = prdp_PrintSimple(
                                   DCIData,
                                   USE_GLOBAL_TABLE,
                                   EST_SET_NT_VERTICAL_UNITS,
                                   (PBYTE)&pDDT->DDTRasterMode->
                                                 VerticalUnits ) != OK )
                {
                    return( return_value );
                }

        }
        else
        {
            if ( return_value = prdp_PrintSimple(
                                   DCIData,
                                   USE_GLOBAL_TABLE,
                                   EST_SET_VERTICAL_UNITS,
                                   (PBYTE)&pDDT->DDTRasterMode->
                                                 VerticalUnits ) != OK )
                {
                   return( return_value );
                }
        }
    }


    /******************************************************************/
    /* PD00743: move to before manual message prompt                  */
    /* PD00743: not if queued raw                                     */
    /******************************************************************/
    /* Set the page length by : - setting the text spacing ..  n/t    */
    /* lines per inch - setting the number of lines per page. These   */
    /* values are set in prde_FillPDB and depend on the height of the */
    /* current form.                                                  */
    /******************************************************************/
    /**************************************************************************/
    /* PD00792 : Set Page Length on all printers except IBM_PRONTO (4070)     */
    /**************************************************************************/
    if ( ( pDDT->DDTInitFlags & DDT_INIT_PAGE_LENGTH          ) &&
         ( !( (DCIData->Flags & QUEUED_RAW           ) &&
              (pDDT->DDTDriverType == DDT_IBM42XX_DRV) &&
              (PrinterData->PrinterType == IBM_PRONTO)    ) ||
           (DCIData->DCIPageNumber > 1                    )   )    )
    {
        if ( (return_value = prdp_PrintSimple(
                                DCIData,
                                USE_GLOBAL_TABLE,
                                EST_SET_T_LINE_SPACING,
                                (PBYTE)&PDBIData->TextSpacing) ) != OK )
        {
           return( return_value );
        }

        if ( (return_value = prdp_PrintSimple(
                                DCIData,
                                USE_GLOBAL_TABLE,
                                EST_SET_PAGE_LENGTH,
                                (PBYTE)&PDBIData->LengthLines) ) != OK )
        {
           return( return_value );
        }
    }


    /******************************************************************/
    /* PD00743: move to before manual message prompt                  */
    /******************************************************************/
    /* Set the text line spacing to 12/72, i.e.  to 6 lines per inch. */
    /******************************************************************/
    if ( pDDT->DDTInitFlags & DDT_INIT_TEXT_SPACING )
    {
        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SET_T_LINE_SPACING,
                               (PBYTE)&pDDT->DDTRasterMode->
                                                  LineSpacing) ) != OK )
        {
           return( return_value );
        }
    }


    /******************************************************************/
    /* PD00744: prompt on all pages if not IBM4019                    */
    /******************************************************************/
    /* Prompt the user to load a form if necessary and we're in a     */
    /* Direct DC.                                                     */
    /******************************************************************/
    if ( (DCIData->Flags & DIRECT                              ) &&
         (PDBIData->PPMInfo[FormNo].FeedTechnique == PFT_MANUAL) )
    {
        TRACE4(TFUNC, "Manual load reqd", FNULL, 0);

        /**************************************************************/
        /* Get first part of message string.                          */
        /**************************************************************/
        Result = WinLoadString( hab,
                                prdd_ModHandle,
                                IDS_INSERT_FORM_1,
                                SLEN_BOX_MESSAGE,
                                UserPrompt );

        /**************************************************************/
        /* Append form name to string.                                */
        /**************************************************************/
        FormName = PDBIData->PPMInfo[FormNo].FormName;

        StrPtr = UserPrompt + prdu_strlen( (PBYTE)UserPrompt);

        prdu_memcpy ( (PBYTE)StrPtr,
                      (PBYTE)FormName,
                      prdu_strlen( (PBYTE) FormName) );

        StrPtr += prdu_strlen( (PBYTE) FormName);

        /**************************************************************/
        /* Add second part of message string.                         */
        /**************************************************************/
        MaxRetLen = SLEN_BOX_MESSAGE -
                    prdu_strlen( (PBYTE) UserPrompt) -
                    prdu_strlen( (PBYTE) FormName);

        /* ... 42xx ... */
        /******************************************************************/
        /*  PD00533 : Changed the check for which printer is currently in */
        /*  use.  Nile/Tiber and 4226 are greater than IBM_4224_COLOR.    */
        /******************************************************************/
        if (( PDBIData->PrinterType != IBM_4224_COLOR ) &&
            ( PDBIData->PrinterType != IBM_4224_MONO ))
            MessageId = IDS_INSERT_FORM_2_PRO;
        else
            MessageId = IDS_INSERT_FORM_2_4224;

        Result = WinLoadString( hab,
                                prdd_ModHandle,
                                MessageId,
                                MaxRetLen,
                                StrPtr );

        /**************************************************************/
        /* Put up the SplMessageBox                                   */
        /**************************************************************/
        Result = (USHORT) SplMessageBox(
                            PDBIData->PDBLogAddress,
                            SPLINFO_DDERROR | SPLINFO_ERROR |
                                                    SPLINFO_USERINTREQD,
                            SPLDATA_FORMCHGREQD,
                            (PSZ)UserPrompt,
                            (PSZ)szCaption,
                            (USHORT)0,
                            MB_OKCANCEL | MB_ERROR |       /* PD00030 */
                            MB_SYSTEMMODAL);

        TRACE4(TFUNC, "SplMB returned", &Result, 1);

        if ( Result == (USHORT)MBID_CANCEL )
        {
            TRACE4(TFUNC, "Cancel ret from box", FNULL, 0);
            goto PURGE_JMP;
        }
    }
    /* .. need to prompt for manual form ........................     */


    if ( pDDT->DDTDialogFlags & DDT_DEF_OUTLN_FNT_PSZ )
    {
        /**************************************************************/
        /* PD00137                                                    */
        /* On RAW data, if default font is outline, force the         */
        /* line spacing   to correspond to the pointsize selected.    */
        /* Note: Change line spacing ONLY if user has selected a      */
        /* point size. If user selects "Program",                     */
        /* PDBIData->DfltPointSz is equal to zero.                    */
        /**************************************************************/
        if ( ((DCIData->State == RAW_EXPLICIT) ||
              (DCIData->State == RAW_IMPLICIT)) &&
              (pMetrics->fsDefn & FM_DEFN_OUTLINE) &&
              ( PDBIData->DfltFontPointSz ) )
        {
            VerticalUnits = PDBIData->DfltFontPointSz;

            if ( (return_value = prdp_PrintSimple(
                                   DCIData,
                                   USE_GLOBAL_TABLE,
                                   EST_SET_T_LINE_SPACING,
                                   (PBYTE)&VerticalUnits )) != OK )
            {
               return( return_value );
            }

        }

    }

    /******************************************************************/
    /* Set the Aspect Ratio if required                               */
    /******************************************************************/
    if  ( pDDT->DDTInitFlags & DDT_INIT_ASPECT_RATIO )
    {
        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SET_ASPECT_RATIO,
                               (PBYTE)&pDDT->DDTRasterMode->
                                              AspectRatio) ) != OK )
        {
           return( return_value );
        }
    }

    /******************************************************************/
    /* Send the Page Presentation Media command to select just the    */
    /* paper source.                                                  */
    /******************************************************************/
    if  ( pDDT->DDTInitFlags & DDT_INIT_PPM_SOURCE )
    {
        DCTParms[0] = PDBIData->PPMInfo[FormNo].FeedTechnique;
        DCTParms[1] = PDBIData->PPMInfo[FormNo].FormControl;
        DCTParms[2] = PDBIData->PPMInfo[FormNo].SourceDrawer;

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SELECT_SOURCE,
                               (PBYTE)DCTParms) ) != OK )
        {
           return( return_value );
        }

    }

    /******************************************************************/
    /* Send the Page Presentation Media command to select the paper   */
    /* source and the actual form. Used for printers that have pre-   */
    /* defined form sizes.                                            */
    /******************************************************************/
    if  ( pDDT->DDTInitFlags & DDT_INIT_PPM_SOURCE_FORM )
    {
        DCTParms[0] = PDBIData->PPMInfo[FormNo].FeedTechnique;
        DCTParms[1] = PDBIData->PPMInfo[FormNo].FormControl;
        DCTParms[2] = PDBIData->PPMInfo[FormNo].SourceDrawer;
        DCTParms[3] = PDBIData->PPMInfo[FormNo].FormId;

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SELECT_SOURCE_FORM,
                               (PBYTE)DCTParms) ) != OK )
        {
           return( return_value );
        }
    }

    /******************************************************************/
    /* Send the Page Presentation Media command to select the paper   */
    /* source and the actual form, and also simplex/duplex mode.      */
    /* Used for Heritage only.                                        */
    /******************************************************************/
    if  ( pDDT->DDTInitFlags & DDT_INIT_PPM_DUPLEX )
    {
        DCTParms[0] = PDBIData->PPMInfo[FormNo].FeedTechnique;
        DCTParms[1] = PDBIData->PPMInfo[FormNo].FormControl;
        DCTParms[2] = PDBIData->PPMInfo[FormNo].SourceDrawer;
        DCTParms[3] = PDBIData->PPMInfo[FormNo].FormId;
        if (PDBIData->DuplexControl & DUPLEX_FLAG)
        {
            DCTParms[4] = (BYTE)(PDBIData->DuplexControl & 0x03) + 1;
        }
        else
        {
            DCTParms[4] = 1; /* simplex */
        }

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SELECT_SOURCE_DUPLEX,
                               (PBYTE)DCTParms) ) != OK )
        {
           return( return_value );
        }
    }


    /******************************************************************/
    /* Set the page width to maximum for the printer - the driver     */
    /* handles all the clipping.                                      */
    /******************************************************************/
    if  ( pDDT->DDTInitFlags & DDT_INIT_MARGINS )
    {
        DCTParms[0] = 255;

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_MARGINS,
                               (PBYTE)DCTParms) ) != OK )
        {
           return( return_value );
        }
    }

    /******************************************************************/
    /* Set the paper orientation if the printer supports the command  */
    /* - i.e.  laser printer.                                         */
    /******************************************************************/
    if ( pDDT->DDTInitFlags & DDT_INIT_ORIENTATION )
    {
        if ( PDBIData->Orientation == PORTRAIT )
        {
            DCTParms[0] = ORIENT_PORTRAIT;
        }
        else
        {
            DCTParms[0] = ORIENT_LANDSCAPE;
        }

        TRACE6(TFUNC, "Orientation parm", DCTParms, 1);

        if ( (return_value = prdp_PrintSimple(
                               DCIData,
                               USE_GLOBAL_TABLE,
                               EST_SET_ORIENTATION,
                               (PBYTE)DCTParms) ) != OK )
        {
           return( return_value );
        }
    }

    return (OK); /* ERR_PURGE / ERR_ABORT / ERROR  */


ERROR_JMP:
    return( ERROR );

PURGE_JMP:
    /******************************************************************/
    /* User wants to purge. Note this is always DIRECT. So do same as */
    /* PrtWrite cancelling.                                           */
    /******************************************************************/
    prdn_our_PrtAbort( DCIData );
    prdn_AbortTidyUp( DCIData );
    DCIData->State = PURGE;
    return( ERR_PURGE );
}



