/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDODRAW
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdo_DrawBorder
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                   /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_GPIERRORS
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_GPIERRORS
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDICOMFLAGS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDICOMFLAGS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdoextf.h>



/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdo_DrawBorder                                        */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   ULONG  param1;                                                   */
/*     :      :  :                                                    */
/*   ULONG  param9;                                                   */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function is to draw a border in a rectangular frame.  It is */
/*   not supprted by the printer driver so returns an error.          */
/*                                                                    */
/**********************************************************************/
ULONG EXPENTRY prdo_DrawBorder(ULONG   param1,
                               ULONG   param2,
                               ULONG   param3,
                               ULONG   param4,
                               ULONG   param5,
                               ULONG   param6,
                               ULONG   param7,
                               lpDCI   param8,
                               ULONG   param9 )


{
#define TFUNC "prdo_DrawBorder"

    /******************************************************************/
    /* Fast frame drawing is not supported and therefore ZERO is      */
    /* returned to indicate failure.                                  */
    /******************************************************************/
    LOGERR(TFUNC, "Not supported", FNULL, 0,
                                           PMERR_DEVICE_DRIVER_ERROR_2);
    return(ERROR_ZERO);
}
#undef TFUNC





/**********************************************************************/
/*                                                                    */
/*   FUNCTION: LockDevice                                             */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC       DcH;                                                 */
/*   lpDCI       DCIData;                                             */
/*   ULONG       FunN;                                                */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Simply returns 1 ie TRUE.  This function must be hooked as       */
/*   there is no default engine function for it.                      */
/*                                                                    */
/**********************************************************************/
ULONG LockDevice(hanDC    DcH,
                 lpDCI    DCIData,
                 ULONG    FunN )


{
    return(OK);
}



/**********************************************************************/
/*   FUNCTION: UnlockDevice                                           */
/*   PARAMETERS:                                                      */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*   hanDC       DcH;                                                 */
/*   lpDCI       DCIData;                                             */
/*   ULONG       FunN;                                                */
/*   DESCRIPTION:                                                     */
/*   Simply returns 1 ie TRUE.  This function must be hooked as       */
/*   there is no default engine function for it.                      */
/**********************************************************************/
ULONG UnlockDevice(hanDC   DcH,
                   lpDCI   DCIData,
                   ULONG   FunN )


{
    return(OK);
}




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdo_ErasePS                                           */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC       DcH;                                                 */
/*   lpDCI       DCIData;                                             */
/*   ULONG       FunN;                                                */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/* Simply returns 1 ie TRUE.  This function must be hooked as there   */
/* is no default engine function for it.  Logs a warning to say the   */
/* function is unsupported                                            */
/*                                                                    */
/**********************************************************************/
ULONG prdo_ErasePS(hanDC  DcH,
                   lpDCI  DCIData,
                   ULONG  FunN )


{
#define TFUNC "prdo_ErasePS"

    LOGWARNING(TFUNC, "Unsupported function", FNULL, 0,
                                          PMERR_DEVICE_DRIVER_ERROR_2);
    return(OK);
}
#undef TFUNC

