/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDNGPIM
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdn_CheckDrawingState
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_32                        /* CON3201 */
#define INCL_DOSPROCESS                /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                       /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#define INCL_DDICOMFLAGS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC
#undef INCL_DDICOMFLAGS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define NO_SYS
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef PRDMTYPE_INCL
#undef NO_SYS
#undef INCL_32                            /* CON3201 */

#include <prdeextf.h>
#include <prdbtyp1.h>
#include <prdbextf.h>
#include <prdgextf.h>
#include <prdiextf.h>
#include <prdnextf.h>
#include <prdncone.h>


/**********************************************************************/
/*                                                                    */
/* FUNCTION: prdn_CheckDrawingState                                   */
/*                                                                    */
/* PARAMETERS:                                                        */
/*                                                                    */
/* PUSHORT      pCommand                                              */
/* lpDCI        DCIdata                                               */
/*                                                                    */
/* DESCRIPTION:                                                       */
/*                                                                    */
/* Function to go in all the drawing routine, just after the          */
/* EnterDriver call.                                                  */
/*                                                                    */
/*  called from:                                                      */
/* Polyline, PolyShortLines, PolyScanLines, BitBlt, SetPel,           */
/* CharString,CharStringPos, DrawLinesInPath, ImageData.              */
/*                                                                    */
/* If drawing is enabled (COM_DRAW) then :                            */
/* Return an error if the state is not WAIT_START.                    */
/* Otherwise set the Drawn flag, and continue on to the drawing code. */
/*                                                                    */
/**********************************************************************/
/* CON3201
USHORT pascal prdn_CheckDrawingState( pCommand, DCIData )

PUSHORT pCommand;
lpDCI   DCIData;
                */
SHORT  prdn_CheckDrawingState(PULONG pCommand,             /* CON3201 */
                              lpDCI   DCIData)

{
#define TFUNC "CheckDrawingState"
    /******************************************************************/
    /* Note, COM_DRAW bit is off for Q_STD - still want to detect     */
    /* drawing.                                                       */
    /* NOTE Enforce StartDoc for Q_STD.                               */
    /******************************************************************/

    if ( (DCIData->Flags & QUEUED_STD) &&
         (DCIData->State != EXPLICIT) )
    {
        LOGERR( TFUNC, "No startdoc", FNULL, 0,
            PMERR_STARTDOC_NOT_ISSUED);
        return( ERROR_ZERO ); /* for a Gpi call... */
    }

    if ( (*pCommand & COM_DRAW & DCIData->CommandMask) ||
          (DCIData->Flags & QUEUED_STD) )
    {
        switch (DCIData->State)
        {
            case WAIT_START:
                /******************************************************/
                /* Prevent drawing in PURGE or WAIT_START states.     */
                /******************************************************/
                LOGERR( TFUNC, "No startdoc", FNULL, 0,
                    PMERR_STARTDOC_NOT_ISSUED);
                return( ERROR_ZERO ); /* for a Gpi call... */

            case PURGE:
                /******************************************************/
                /* When purging, we stop any drawing, as there is no  */
                /* band. Return OK from Gpi call so that application  */
                /* may continue drawing/NewFraming/RawDataing until an*/
                /* EndDoc or Begin_close, when we leave PURGE state   */
                /*                                                    */
                /* NOTE turning off the COM_DRAW flag does not work   */
                /* for text calls (& possibly others?), so use this   */
                /* return code to indicate that drawing function      */
                /* should just exit OK.                               */
                /******************************************************/
                return( ERR_PURGE );

            case IMPLICIT:
            case EXPLICIT:
            case RAW_IMPLICIT:
            case RAW_EXPLICIT:
                DCIData->Flags |= DRAWN_INTO;
                break;
        }
    }

    /******************************************************************/
    /* Continue with drawing function.                                */
    /******************************************************************/
    return( OK );
}
#undef TFUNC

