/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMHELP
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_EnableHelp
 *             prdm_DisableHelp
 *             prdm_GetHelpPath
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES              /* Convert to C/SET2    CON3201       */
#define INCL_WINHELP
#define INCL_WINHOOKS
#define INCL_WININPUT
#define INCL_WINHEAP
#define INCL_GPIPRIMITIVES
#define INCL_GPIERRORS
#define INCL_GPIBITMAPS
#define INCL_DEV
#define INCL_WINSHELLDATA
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES               /* Convert to C/SET2    CON3201       */
#undef INCL_DEV
#undef INCL_GPIPRIMITIVES
#undef INCL_GPIERRORS
#undef INCL_GPIBITMAPS
#undef INCL_WINHEAP
#undef INCL_WININPUT
#undef INCL_WINHOOKS
#undef INCL_WINHELP
#undef INCL_WINSHELLDATA

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_HELP
#include <pmtktp.h>
#undef INCL_HELP
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prdmcone.h>

#define PRDMTYPE_INCL
#define MOCON_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef MOCON_INCL
#undef PRDMTYPE_INCL

/**********************************************************************/
/* Set up external accesses                                           */
/**********************************************************************/
#include <prdmhelp.h>
#include <prdmextf.h>
#include <prdyextf.h>
#include <prduextf.h>
#include <prdmtrcf.h>
#include <prdpcone.h>

extern PCHAR               InternalDriverName;
extern USHORT              DRIVER_TYPE;
extern CHAR                szMessage[SLEN_BOX_MESSAGE];
extern CHAR                szCaption[40];
extern HMODULE             prdd_ModHandle;
extern HELPTABLE           MainHelpTable[];
extern HELPSUBTABLE        TT_DUMMY[];

/**********************************************************************/
/* Declarations of global data structures.                            */
/**********************************************************************/
DModeDataType       DMData;
HWND                PPhwnd;       /* PD00364 : Global window handle   */

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_EnableHelp                                        */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
void pascal far prdm_EnableHelp( hwnd )

HWND      hwnd;                       /* Handle to dialog             */
#endif

void prdm_EnableHelp( HWND hwnd )                          /* CON3201 */

{
    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    HELPINIT   hmiHelpData;        /* Help initialization structure   */
    HWND       hwndDriverHelp;
    HWND       hwndCurrentHelp;
    MRESULT    Result;
    HHELP      HelpHandle;
    USHORT     Main_help_table;
    BOOL       ParmblockOK;
    PBYTE      lpPathBuffer;
    CHAR       szHelpLibraryName[15];

    /******************************************************************/
    /* Start off assuming that the parameter block is going to be set */
    /* up with no errors.                                             */
    /******************************************************************/
    ParmblockOK = TRUE;

    /******************************************************************/
    /* IPF Initialization Structure                                   */
    /******************************************************************/
    hmiHelpData.cb           = sizeof(HELPINIT);
    hmiHelpData.ulReturnCode = (ULONG)NULL;

    /******************************************************************/
    /* Null most of the fields                                        */
    /******************************************************************/
    hmiHelpData.hmodAccelActionBarModule = (HMODULE)NULL;
    hmiHelpData.pszTutorialName          = (PCHAR)NULL;
    hmiHelpData.idAccelTable             = (ULONG)NULL;
    hmiHelpData.idActionBar              = (ULONG)NULL;

    /******************************************************************/
    /* Window Title                                                   */
    /******************************************************************/
    WinLoadString( hab,
                   prdd_ModHandle,
                   IDS_HELP_PANEL_TITLE,
                   SLEN_BOX_MESSAGE,
                   (PSZ)szMessage );

    hmiHelpData.pszHelpWindowTitle = (PSZ)szMessage;

    /******************************************************************/
    /* The help resources are in our DLL.                             */
    /******************************************************************/
    hmiHelpData.hmodHelpTableModule = prdd_ModHandle;

    /******************************************************************/
    /* Store help table in initialisation data. Help tables are       */
    /* defined in PRDxxxxH.RC and are always called MAIN_HELP_TABLE   */
    /******************************************************************/
    hmiHelpData.phtHelpTable = (PVOID)(0xffff0000 | MAIN_HELP_TABLE);

    /******************************************************************/
    /* Display panel ids (used for debugging)                         */
    /******************************************************************/
/*  hmiHelpData.usShowPanelId = FALSE; CON3201 - HELPINIT changed in OS/2 2.0 */
    hmiHelpData.fShowPanelId = FALSE;

    /**************************************************************************/
    /*  PD00393 : Changed order of search for the .HLP file.  We now search   */
    /*  for the .HLP file first in the device driver directory and then       */
    /*  search the help path                                                  */
    /**************************************************************************/
    /**************************************************************************/
    /* PD00200 : Get the path of the driver. This may fail so be              */
    /* ready not to enable the help instance.                                 */
    /**************************************************************************/
    if ((lpPathBuffer = prdm_GetHelpPath( hwnd )) == FNULL)
    {
        ParmblockOK = FALSE;
    }
    else
    {
        hmiHelpData.pszHelpLibraryName = (PSZ)lpPathBuffer;
    }

    if (ParmblockOK)
    {
        DMData.hwndHelp = WinCreateHelpInstance(hab, &hmiHelpData);
    }

    /**************************************************************************/
    /*  Find out if the WinCreateHelpInstance worked                          */
    /**************************************************************************/
    if (DMData.hwndHelp)
    {
       if (hmiHelpData.ulReturnCode)
       {
           /**********************************************************/
           /* Help instance created but if there was an error return */
           /* code then disable help again.  The return codes are    */
           /* undocumented so assume that all of them are fatal.     */
           /**********************************************************/
           (VOID)prdm_DisableHelp();
       }
       else
       {
           /**********************************************************/
           /* PD00263 : Can go ahead and associate the help          */
           /* instance.  But always associate it with the printer    */
           /* properties dialog or the job properties dialog even if */
           /* the enable was called from a sub-dialog.               */
           /*                                                        */
           /* Do not set the active window either.                   */
           /**********************************************************/
           /* PD00364 : Associate help instance with a previously    */
           /* defined global variable.  PPhwnd is either the window  */
           /* handle of the main printer properties window or the    */
           /* job properties window.                                 */
           /**********************************************************/
           WinAssociateHelpInstance (DMData.hwndHelp,
                                     PPhwnd);
       }
    }
    else
    {
       /***********************************************************************/
       /*  PD00393 : Now check for the help file in the help path because you */
       /*  were not able to find it in the device driver directory.           */
       /***********************************************************************/
       /***********************************************************************/
       /* Help library name. This file contains the panels.                   */
       /***********************************************************************/
       WinLoadString( hab,
                      prdd_ModHandle,
                      IDS_HELP_FILE,
                      15,
                      (PSZ)szHelpLibraryName );

       hmiHelpData.pszHelpLibraryName = (PSZ)szHelpLibraryName;

       DMData.hwndHelp = WinCreateHelpInstance(hab, &hmiHelpData);

       if (hmiHelpData.ulReturnCode)
       {
           /**********************************************************/
           /* Help instance created but if there was an error return */
           /* code then disable help again.  The return codes are    */
           /* undocumented so assume that all of them are fatal.     */
           /**********************************************************/
           (VOID)prdm_DisableHelp();
       }
       else
       {
           /**********************************************************/
           /* PD00263 : Can go ahead and associate the help          */
           /* instance.  But always associate it with the printer    */
           /* properties dialog or the job properties dialog even if */
           /* the enable was called from a sub-dialog.               */
           /*                                                        */
           /* Do not set the active window either.                   */
           /**********************************************************/
           /* PD00364 : Associate help instance with a previously    */
           /* defined global variable.  PPhwnd is either the window  */
           /* handle of the main printer properties window or the    */
           /* job properties window.                                 */
           /**********************************************************/
           WinAssociateHelpInstance (DMData.hwndHelp,
                                     PPhwnd);
       }
    }   /* if DMData.hwndHelp */
}


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_DisableHelp                                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
void pascal far prdm_DisableHelp ()
#endif

void prdm_DisableHelp ()                                   /* CON3201 */

{

  if (DMData.hwndHelp)
  {
      WinDestroyHelpInstance (DMData.hwndHelp);
      DMData.hwndHelp = (HWND)NULL;
  }

}

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_GetHelpPath                                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
PBYTE pascal far prdm_GetHelpPath( hwnd )

HWND      hwnd;                       /* Handle to dialog             */
#endif

PBYTE prdm_GetHelpPath( HWND hwnd )                        /* CON3201 */

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    CHAR       szHelpLibraryName[15];
    PSZ        szHelpPathName;
    PBYTE      lpPathBuffer;
    USHORT     Result;
    ULONG      PathLength;
    CHAR       IniDirPath[250];

    /******************************************************************/
    /* Get the library name.                                          */
    /******************************************************************/
    WinLoadString( hab,
                   prdd_ModHandle,
                   IDS_HELP_FILE,
                   15,
                   (PSZ)szHelpLibraryName );

    /******************************************************************/
    /* Get help path name                                             */
    /******************************************************************/
//  szHelpPathName = "c:\\";

    /******************************************************************/
    /* Get the length of the path of the library                      */
    /******************************************************************/
    PathLength = 40;

    /******************************************************************/
    /* Allocate memory for the concatenation of this string           */
    /******************************************************************/
  /* CON3201 **************************************************/
  /*Result = SSALLOCSEG ( (USHORT)PathLength,                 */
  /*                      &SELECTOROF(lpPathBuffer), 0);      */
  /************************************************************/
    Result = SafeSSALLOCMEM ( &lpPathBuffer,
                              (USHORT)PathLength, 0);

/*  OFFSETOF(lpPathBuffer) = 0;                                       CON3201 */

    if ( Result != DOS_OK )
    {
        /**************************************************************/
        /* Error                                                      */
        /**************************************************************/
        Ring3LOGDOSERR(TFUNC, "SSALLOCSEG Fail", &Result, 1, Result);
        lpPathBuffer = FNULL;
    }
    else
    {
        /**************************************************************/
        /* Now concatenate the two strings and return to the calling  */
        /* routine.                                                   */
        /**************************************************************/
        /******************************************************************/
        /* PD00200 :                                                      */
        /* Read data from OS2.INI and store in the buffer.                */
        /******************************************************************/
        PathLength = PrfQueryProfileString( HINI_USERPROFILE,
                                            "PM_DEVICE_DRIVERS",
                                            InternalDriverName,
                                            "C:\\",
                                            IniDirPath,
                                            40L );
        szHelpPathName = IniDirPath;

        /**********************************************************/
        /* PD00200 :                                              */
        /* Manipulate szDirectory to delete the file name on the  */
        /* end of the string.  Place a NULL character at the end  */
        /* of the directory path string.                          */
        /**********************************************************/
        --PathLength;
        while ((PathLength >= 1) && (*(szHelpPathName+PathLength) != '\\'))
        {
          *(szHelpPathName+PathLength) = ' ';
          --PathLength;
        }
        *(szHelpPathName+PathLength+1) = '\0';

        prdu_strcpy ( (PBYTE) lpPathBuffer,
                      (PBYTE) szHelpPathName);

        /**************************************************************/
        /* Append the path and the name                               */
        /**************************************************************/
        prdu_strcpy ( (PBYTE) (lpPathBuffer+PathLength+1),
                      (PBYTE) szHelpLibraryName);
    }

    /******************************************************************/
    /* Finished                                                       */
    /******************************************************************/
    return( lpPathBuffer );

}

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_HelpMessageProcessing                             */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
VOID pascal far prdm_HelpMessageProcessing( hwnd,
                                            msg,
                                            lparam1,
                                            lparam2)

HWND      hwnd;
USHORT    msg;
MPARAM    lparam1;
MPARAM    lparam2;
#endif

VOID prdm_HelpMessageProcessing( HWND   hwnd,              /* CON3201 */
                                 USHORT msg,               /* CON3201 */
                                 MPARAM lparam1,           /* CON3201 */
                                 MPARAM lparam2)           /* CON3201 */

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    PBYTE        lpMessage;
    PSZ          szDirectory;
    USHORT       Result;
    ULONG        DirPathSize;
    CHAR         IniDirPath[250];


    /******************************************************************/
    /* Help not enabled, so try again.                                */
    /******************************************************************/
    if (!DMData.hwndHelp)
    {
        /**************************************************************/
        /* Enable help.                                               */
        /**************************************************************/
        (void) prdm_EnableHelp (hwnd);

        if (!DMData.hwndHelp)
        {
            /**********************************************************/
            /* Get the first part of the message                      */
            /**********************************************************/
            lpMessage = (PBYTE)szMessage;

            Result = WinLoadString (hab,
                                    prdd_ModHandle,
                                    IDS_HELP_NOT_AVAIL_3A,
                                    MESSAGE_LENGTH,
                                    (PSZ)lpMessage );

            /**********************************************************/
            /* Get the directory of the driver.                       */
            /**********************************************************/
/*          szDirectory = "c:\\"; */

            /******************************************************************/
            /* PD00200 :                                                      */
            /* Read data from OS2.INI and store in the buffer.                */
            /******************************************************************/
            DirPathSize= PrfQueryProfileString( HINI_USERPROFILE,
                                                "PM_DEVICE_DRIVERS",
                                                InternalDriverName,
                                                "C:\\",
                                                IniDirPath,
                                                40L );

            szDirectory = IniDirPath;

            /**********************************************************/
            /* PD00200 :                                              */
            /* Manipulate szDirectory to delete the file name on the  */
            /* end of the string.  Place a NULL character at the end  */
            /* of the directory path string.                          */
            /**********************************************************/
            --DirPathSize;
            while ((DirPathSize >= 1) && (*(szDirectory+DirPathSize) != '\\'))
            {
              *(szDirectory+DirPathSize) = ' ';
              --DirPathSize;
            }
            *(szDirectory+DirPathSize) = '\0';

            (VOID) prdu_strcat (szMessage, szDirectory);

            /**********************************************************/
            /* Get the second part of the message                     */
            /**********************************************************/
            lpMessage = (PBYTE)szMessage + prdu_strlen(szMessage);

            Result = WinLoadString (hab,
                                    prdd_ModHandle,
                                    IDS_HELP_NOT_AVAIL_3B,
                                    40,
                                    (PSZ)lpMessage );

            /**********************************************************/
            /* The help file was not found, so warn the user.         */
            /**********************************************************/
            WinMessageBox( HWND_DESKTOP,
                           hwnd,
                           (PSZ)szMessage,
                           (PSZ)szCaption,
                           0,
                           MB_OK | MB_ICONEXCLAMATION );
        }
    }

    /******************************************************************/
    /* All finished...                                                */
    /******************************************************************/
}
