/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMCPGE
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_CodePageDlgProc
 *             prdm_EnterCodePageValues
 *             prdm_AddCodePage
 *             prdm_DisplayCodePage
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_WINHELP
#define INCL_DOSSEMAPHORES
#define INCL_GPIERRORS
#define INCL_DOSERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSMODULEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINERRORS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINENTRYFIELDS
#define INCL_WINMESSAGEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINWINDOWMGR
#define INCL_WINPOINTERS
#define INCL_DOSMISC
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSMISC
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIERRORS
#undef INCL_DOSERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSMODULEMGR
#undef INCL_WINFRAMEMGR
#undef INCL_WINLISTBOXES
#undef INCL_WINBUTTONS
#undef INCL_WINERRORS
#undef INCL_WINDIALOGS
#undef INCL_WINSHELLDATA
#undef INCL_WINENTRYFIELDS
#undef INCL_WINMESSAGEMGR
#undef INCL_WININPUT
#undef INCL_WINMENUS
#undef INCL_WINWINDOWMGR
#undef INCL_WINPOINTERS
#undef INCL_WINHELP

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_WINSHELLDATA
/* #include <pmshlp.h>                                              DLM01 */
#define INCL_WINSHELLDATA
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdmcone.h>
#include <prdtcone.h>

#define NO_SYS
#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP
#undef PRDMTYPE_INCL

#include <prdmextf.h>
#include <prduextf.h>
#include <prdyextf.h>

extern lpDDTType        DDT [];
extern DModeDataType    DMData;
extern lpDMSettings     pDMSettings;
extern DMIniEntryType   DMIniEntry[LARGEST_NO_OF_PRINTERS];
extern DVTCPListType    DVTCodePageList [];
extern lpDVTCPSource    DVTCodePageCaps [];

extern CHAR        szCaption[40];
extern CHAR        szMessage[SLEN_BOX_MESSAGE];
extern BYTE        SrcDirBuffer[80];
extern BYTE        TrgDirBuffer[80];
extern BYTE        SrcFileName[80];
extern BYTE        TrgFileName[80];

extern PCHAR            InternalDriverName;




/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_CodePageDlgProc                                   */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   Standard dialog box control procedure parameter block            */
/*                                                                    */
/*   HWND    hwnd;                                                    */
/*   USHORT  msg;                                                     */
/*   MPARAM  lparam1;                                                 */
/*   MPARAM  lparam2;                                                 */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function puts up a list of the downloadable code pages.     */
/*   It enables a user to add or delete a code page.  It also         */
/*   enables a user to select an initial code page and set the        */
/*   reload type for this initial code page.                          */
/*                                                                    */
/**********************************************************************/
#if 0
MRESULT pascal far _loadds prdm_CodePageDlgProc( hwnd,
                                                 msg,
                                                 lparam1,
                                                 lparam2)

HWND    hwnd;
USHORT  msg;
MPARAM  lparam1;
MPARAM  lparam2;
#endif

MRESULT prdm_CodePageDlgProc( HWND   hwnd,                 /* CON3201 */
                              USHORT msg,                  /* CON3201 */
                              MPARAM lparam1,              /* CON3201 */
                              MPARAM lparam2)              /* CON3201 */

{
#define TFUNC "prdm_CdePgeDlg"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT      Result;         /* Function call return values ..     */
 /* MRESULT     DlgResult; */   /*                               .... */
    ULONG       DlgResult;      /* CON3201 : change for 32 bit conv.. */
    USHORT      ListIndex;      /* Index of selected item in list box */
    USHORT      DVTCPListIndex; /* Index of selected item in          */
                                /* DVTCodePageList array.             */
    USHORT      PrinterType;    /* Type of the current printer        */
    BOOL        EnableState;    /* Used to grey and ungrey buttons    */
    BOOL        FoundCP;        /* Found a code page to add flag      */
    USHORT      i;              /* Loop variable                      */
    USHORT      Count;          /* Count variable                     */
    USHORT      BoxId;          /* ID for selecting items in the      */
                                /* dialog box                         */
    USHORT      WndId;          /* ID used to set the focus           */
    USHORT      NoOfDispCPs;    /* ID used to set the focus           */
    lpDMCPInfo      pCPInfo;    /* Code page info in DMData           */
    lpDVTCPSource   CodePageCaps;
                                /* Code Page info for this printer    */
    USHORT       FirstIndex;    /* Index of item in list box          */
    USHORT       SecondIndex;   /*     ...........                    */
    USHORT       DeselectIndex; /*                ..............      */
    USHORT       Index;         /*                                    */
    BYTE         Dstname[13];   /* Code page binary file dest name    */
    PSZ          pDstname;      /* temp pointer to dst name           */
    PSZ          pSrcname;      /* temp pointer to src name           */
    CHAR     String[MAX_PATH+1];/* PD00666                            */
    CHAR     DriveLetter[2];    /* PD00666                            */


    /******************************************************************/
    /* First set up some useful variables.                            */
    /******************************************************************/
    PrinterType  = pDMSettings->PrinterType;
    CodePageCaps = DVTCodePageCaps[PrinterType];
    pCPInfo      = &DMData.CPInfo;

    /******************************************************************/
    /* Switch according to the type of message.                       */
    /******************************************************************/
    switch (msg)
    {
        case WM_HELP:
            /**********************************************************/
            /* PD00199 : The message is always going to go to the     */
            /* default handler, but give the driver a chance to do    */
            /* a little bit of processing first.                      */
            /**********************************************************/
            (VOID) prdm_HelpMessageProcessing ( hwnd, msg, lparam1, lparam2 );

            /**********************************************************/
            /* Now pass message to the default message handler.       */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));

        case WM_CLOSE:
            /**********************************************************/
            /* Trap Close from system menu                            */
            /* Note: this will fall into WM_COMMAND with CANCEL set   */
            /**********************************************************/
         /* SHORT1FROMMP(lparam1) = DB_PSH_CANCEL; */
            lparam1 = MPFROM2SHORT( DB_PSH_CANCEL,           /*CON3201*/
                                    SHORT2FROMMP(lparam1) ); /*CON3201*/

        case WM_COMMAND:
            /**********************************************************/
            /* The message is a command (ie a button) so switch       */
            /* depending on which button was pressed.                 */
            /**********************************************************/
            switch ( SHORT1FROMMP(lparam1) )
            {
                case DB_PSH_ENTER:
                    /**************************************************/
                    /* If ENTER handled succesfully then dismiss the  */
                    /* dialog box with TRUE.                          */
                    /**************************************************/
                    if ( prdm_EnterCodePageValues( hwnd ) )
                        WinDismissDlg( hwnd, TRUE );
                    prdm_ReleaseFontTableMemory();
                    break;

                case DB_PSH_CANCEL:
                case DID_CANCEL:
                    /**************************************************/
                    /* If this is the main code page list box we may  */
                    /* need to update the size of the code page data. */
                    /**************************************************/
                    switch ( DMData.DialogId )
                    {
                        case DB_CODE_PAGE_LIST:
                            /******************************************/
                            /* Check the change flag.                 */
                            /******************************************/
                            if ( DMIniEntry[PrinterType].DataChange &
                                                CODE_PAGE_LIST_CHANGE )
                            {
                                prdm_ReleaseFontTableMemory();
                                pDMSettings->CodePageDataSize = 0;

                                for ( i = 0; i < NO_OF_ADDABLE_CPS; i++ )
                                {
                                    if ( pCPInfo->CPList[i].PathName )
                                    {
                                        pDMSettings->CodePageDataSize +=
                                            NO_CODE_PAGE_DIGITS +
                                            PATHNAME_SIZE_LENGTH +
                                            pCPInfo->
                                                CPList[i].PathNameSize;
                                    }
                                }
                            }
                    }

                    /**************************************************/
                    /* Dismiss the dialog box with FALSE.             */
                    /**************************************************/
                    WinDismissDlg( hwnd, FALSE );
                    break;

                case DB_PSH_ADD:
                    /**************************************************/
                    /* Can only use this push button if there is      */
                    /* added code page support and enough memory is   */
                    /* available                                      */
                    /*                                                */
                    /* DIAL/NILE : Check for partial download area.   */
                    /**************************************************/
                    if (!(DDT[PrinterType]->DDTFontFlags &
                                  DDT_ADD_CODE_PAGE_SUPPORT) ||
                         ( (pDMSettings->DownCPMemAvail !=
                                              DOWN_CP_MEM_AVAIL) &&
                            !(DDT[PrinterType]->DDTFontFlags &
                                       DDT_DOWN_CP_MEM_SUBSET_AVAIL) ) )
                    {
                        (void)prdm_DispMessageBox(
                                   hwnd,
                                   IDS_ADD_NOT_SUPPORTED,
                                   SLEN_BOX_MESSAGE,
                                   DB_LST_CPF_AVAIL,
                                   MB_OK | MB_ICONEXCLAMATION );
                       break;
                    }


                    /**************************************************/
                    /* Check if there are any code pages which can be */
                    /* added.                                         */
                    /**************************************************/
                    FoundCP = FALSE;
                    for ( i = 0; i < NO_OF_ADDABLE_CPS; i++ )
                    {
                        if ( !pCPInfo->CPList[i].PathName &&
                             CodePageCaps[i+2].CPSource == CP_DOWNLOAD )
                        {
                            FoundCP = TRUE;
                            break;
                        }
                    }

                    /**************************************************/
                    /* Bring up the Code Page Source Path box if list */
                    /* of addable code pages is not empty.            */
                    /**************************************************/
                    if ( FoundCP )
                    {
                        DMData.DialogId = DB_ADD_CODE_PAGE;
                        DMData.hwndOwner = hwnd;

                        DlgResult =  WinDlgBox(
                                           HWND_DESKTOP,
                                           hwnd,
                                           (PFNWP)prdm_CodePageDlgProc,
                                           DMData.HModule,
                                           DMData.DialogId,
                                           (PVOID)NULL );

                        /**********************************************/
                        /* PD00151 : Finished with the dialog box,    */
                        /* reset the active help window.              */
                        /* PD00263 : Remove set active window, now    */
                        /* window always appears in the same place.   */
                        /**********************************************/
#if 0
//                      WinSendMsg( DMData.hwndHelp,
//                                  HM_SET_ACTIVE_WINDOW,
//                                  hwnd,
//                                  hwnd );
#endif
                    }

                    /**************************************************/
                    /* If the number of added code pages is positive  */
                    /* then enable the Remove button.                 */
                    /**************************************************/
                    if ( pDMSettings->NoOfAddedCPs )
                    {
                        DlgResult = WinEnableWindow(
                            WinWindowFromID( hwnd, DB_PSH_REMOVE ),
                            TRUE );
                    }

                    /**************************************************/
                    /* Now back in the main code page box.            */
                    /**************************************************/
                    DMData.DialogId = DB_CODE_PAGE_LIST;
                    break;

                case DB_PSH_REMOVE:
                    /**************************************************/
                    /* Call dialog box to display the the list of     */
                    /* added code pages so these can be selected to   */
                    /* be removed.                                    */
                    /**************************************************/
                    DMData.DialogId = DB_REMOVE_CODE_PAGE;
                    DMData.hwndOwner = hwnd;

                    DlgResult =  WinDlgBox( HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)prdm_CodePageDlgProc,
                                            DMData.HModule,
                                            DMData.DialogId,
                                            (PVOID)NULL );

                    /**************************************************/
                    /* PD00151 : Finished with the dialog box, reset  */
                    /* the active help window.                        */
                    /* PD00263 : Remove set active window. Now window */
                    /* always appears in the same place.              */
                    /**************************************************/
#if 0
//                  WinSendMsg( DMData.hwndHelp,
//                              HM_SET_ACTIVE_WINDOW,
//                              hwnd,
//                              hwnd );
#endif

                    /**************************************************/
                    /* If the number of added code pages is now       */
                    /* zero then disable the Remove button and put    */
                    /* the focus on the ENTER button.                 */
                    /**************************************************/
                    if ( pDMSettings->NoOfAddedCPs == 0 )
                    {
                        DlgResult = WinEnableWindow(
                                      WinWindowFromID( hwnd, DB_PSH_REMOVE ),
                                      FALSE );

                        DlgResult = WinSetFocus(
                                      HWND_DESKTOP,
                                      WinWindowFromID( hwnd, DB_PSH_ENTER ));
                    }

                    /**************************************************/
                    /* The initial code page may have been removed -  */
                    /* if so we should disable the Reload button.     */
                    /**************************************************/
                    ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                              hwnd,
                                              DB_LST_CPF_AVAIL,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT(LIT_FIRST),
                                              FNULL) );

                    if ( ListIndex == (USHORT)LIT_NONE )
                    {
                        DlgResult = WinEnableWindow(
                                       WinWindowFromID( hwnd,
                                                        DB_PSH_CPF_RELOAD ),
                                                        FALSE );
                    }

                    /**************************************************/
                    /* Now back in the main code page dialog box.     */
                    /**************************************************/
                    DMData.DialogId = DB_CODE_PAGE_LIST;
                    break;

                case DB_PSH_CPF_RELOAD:
                    /**************************************************/
                    /* Call the Reload Code Page dialog box.          */
                    /**************************************************/
                    DMData.DialogId = DB_RELOAD_CODE_PAGE;
                    DMData.hwndOwner = hwnd;

                    DlgResult =  WinDlgBox( HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)prdm_CodePageDlgProc,
                                            DMData.HModule,
                                            DMData.DialogId,
                                            (PVOID)NULL );

                    /**************************************************/
                    /* PD00151 : Finished with the dialog box, reset  */
                    /* the active help window.                        */
                    /* PD00263 : Remove set active window. Now window */
                    /* always appears in the same place.              */
                    /**************************************************/
#if 0
//                  WinSendMsg( DMData.hwndHelp,
//                              HM_SET_ACTIVE_WINDOW,
//                              hwnd,
//                              hwnd );
#endif

                    /**************************************************/
                    /* Now back in the main code page dialog box.     */
                    /**************************************************/
                    DMData.DialogId = DB_CODE_PAGE_LIST;
                    break;

                case DB_PSH_CPF_ADD_CNF:
                    /**************************************************/
                    /* Find out the index into the DVTCodePageList    */
                    /* array for the code page selected as the one to */
                    /* add.                                           */
                    /**************************************************/
                    ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                      hwnd,
                                      DB_LST_CPF_ADDLIST,
                                      LM_QUERYSELECTION,
                                      MPFROMSHORT(LIT_FIRST),
                                      FNULL) );

                    if ( ListIndex == (USHORT)LIT_NONE )
                    {
                        /**********************************************/
                        /* Display error message and set the focus    */
                        /* back to the initial state.                 */
                        /**********************************************/
                        (void)prdm_DispMessageBox(
                                            hwnd,
                                            IDS_CP_NOT_SELECTED,
                                            SLEN_BOX_MESSAGE,
                                            DB_LST_CPF_ADDLIST,
                                            MB_OK | MB_ICONEXCLAMATION);

                        WndId = DB_LST_CPF_ADDLIST;

                        DlgResult = WinSetFocus(
                                           HWND_DESKTOP,
                                           WinWindowFromID(hwnd,WndId));
                        break;
                    }
                    else
                    {
                        pCPInfo->AddCPIndex =
                                      pCPInfo->CPList[ListIndex].Alter;

                        /**********************************************/
                        /* Bring up the Code Page Source Path box.    */
                        /**********************************************/
                        DMData.DialogId = DB_CODE_PAGE_SOURCE;

                        DlgResult =  WinDlgBox(
                                            HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)prdm_CodePageDlgProc,
                                            DMData.HModule,
                                            DMData.DialogId,
                                            (PVOID)NULL );

                        /**********************************************/
                        /* PD00151 : Finished with the dialog box,    */
                        /* reset the active help window.              */
                        /* PD00263 : Remove set active window. Now    */
                        /* window always appears in the same place.   */
                        /**********************************************/
#if 0
//                      WinSendMsg( DMData.hwndHelp,
//                                  HM_SET_ACTIVE_WINDOW,
//                                  hwnd,
//                                  hwnd );
#endif

                        /**********************************************/
                        /* If valid source path was found and it      */
                        /* contains the required BIN file bring up    */
                        /* the Code Page Target Path path.            */
                        /**********************************************/
                        if ( DlgResult )
                        {
                            DMData.DialogId = DB_CODE_PAGE_TARGET;

                            DlgResult =  WinDlgBox(
                                            HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)prdm_CodePageDlgProc,
                                            DMData.HModule,
                                            DMData.DialogId,
                                            (PVOID)NULL);

                            /******************************************/
                            /* PD00151 : Finished with the dialog     */
                            /* box, reset the active help window.     */
                            /* PD00263 : Remove set active window,    */
                            /* now window always appears in the same  */
                            /* place.                                 */
                            /******************************************/
#if 0
//                          WinSendMsg( DMData.hwndHelp,
//                                      HM_SET_ACTIVE_WINDOW,
//                                      hwnd,
//                                      hwnd );
#endif

                            /******************************************/
                            /* If the code page was added successfuly */
                            /* then display the new code page and     */
                            /* remove it from the Add a Code Page     */
                            /* box.                                   */
                            /******************************************/
                            if ( DlgResult )
                            {
                                prdm_DisplayCodePage(
                                                  DMData.hwndOwner,
                                                  DB_LST_CPF_AVAIL,
                                                  pCPInfo->AddCPIndex );

                                (void)SHORT1FROMMR( WinSendDlgItemMsg(
                                                 hwnd,
                                                 DB_LST_CPF_ADDLIST,
                                                 LM_DELETEITEM,
                                                 MPFROMSHORT(ListIndex),
                                                 FNULL) );
                            }
                        }

                        /**********************************************/
                        /* Now back in the Add a Code Page box        */
                        /**********************************************/
                        DMData.DialogId = DB_ADD_CODE_PAGE;
                        break;
                    }

                case DB_PSH_CPF_COPY:
                    /**************************************************/
                    /* Read the target directory name from the box.   */
                    /**************************************************/
                    WinQueryDlgItemText( hwnd,
                                         DB_TXT_CPF_TPATH,
                                         MAX_PATH,
                                         (PSZ)TrgDirBuffer );

                    TrgDirBuffer[MAX_PATH] = '\0';

                    /**************************************************/
                    /* Check if the target directory exists first.    */
                    /**************************************************/
                    DMData.SearchDirHandle = 0xFFFF;

                    Result = prdm_CheckFileExists(
                                             TrgDirBuffer,
                                             ANY_FILENAME,
                                             FNULL,
                                             &DMData.SearchDirHandle,
                                             &DMData.FileInfoBuf );

                    if ( Result != FILE_FOUND )
                    {
#if 0
//                      /**********************************************/
//                      /* Display error message and set the focus    */
//                      /* back to the path entry box.                */
//                      /**********************************************/
//                      (void)prdm_DispMessageBox( hwnd,
//                                                 IDS_PATH_NOT_FOUND,
//                                                 SLEN_BOX_MESSAGE,
//                                                 DB_TXT_CPF_TPATH,
//                                                 MB_OK | MB_ICONEXCLAMATION );
//
//                      WndId = DB_TXT_CPF_TPATH;
//                      DlgResult = WinSetFocus(
//                                        HWND_DESKTOP,
//                                        WinWindowFromID(hwnd,WndId));
#endif
                        /**********************************************/
                        /* Auto make directory if requested.  PD00666 */
                        /**********************************************/
                        if ( prdm_DispMessageBox( hwnd,
                                             IDS_CREATE_NEW_DIR,
                                             SLEN_BOX_MESSAGE,
                                             DB_TXT_CPF_TPATH,
                                             MB_YESNO | MB_ICONQUESTION )
                                             == MBID_NO )
                        {
                            WndId = DB_TXT_CPF_TPATH;
                            DlgResult = WinSetFocus( HWND_DESKTOP,
                                          WinWindowFromID(hwnd,WndId));
                            break;
                        }

                        /**********************************************/
                        /* DosError(0) disables hard error pop-ups    */
                        /* DosError(1) enables hard error pop-ups     */
                        /**********************************************/
                        (void)DosError( 0x00L );

                        if (DosMkDir ( TrgDirBuffer, 0L ) )
                        {
                            (void)DosError( 0x01L );
                            TRACE4( TFUNC, "DosMkDir failed", TrgDirBuffer, 3);
                            (void)prdm_DispMessageBox( hwnd,
                                           IDS_INVALID_DIRNAME,
                                           SLEN_BOX_MESSAGE,
                                           DB_TXT_CPF_TPATH,
                                           MB_OK | MB_ICONEXCLAMATION );

                            WndId = DB_TXT_CPF_TPATH;
                            DlgResult = WinSetFocus( HWND_DESKTOP,
                                          WinWindowFromID(hwnd,WndId));
                            break;
                        }
                        (void)DosError( 0x01L );

                    }
#if 0
//                  else
//                  {
#endif
                        /**********************************************/
                        /* For copying code page binary files set up  */
                        /* a destination filename which equals:       */
                        /* - the first four characters of the source  */
                        /*   name                                     */
                        /* - the codepage number in decimal.          */
                        /*                                            */
                        /* This is because for the X24 proprinter the */
                        /* binary files for each codepage have the    */
                        /* same names.                                */
                        /*                                            */
                        /* Note that this naming condition will       */
                        /* the original source name fr the other pros.*/
                        /**********************************************/
                        Index    = pCPInfo->AddCPIndex;
                        pDstname = (PSZ)Dstname;
                        pSrcname = CodePageCaps[Index].BINFileName;

                        for (i=0; i<4; i++)
                        {
                            *pDstname++ = *pSrcname++;
                        }

                        prdm_WriteTextFromWord(
                                      DVTCodePageList[Index].Number,
                                      3,
                                      pDstname);

                        *pDstname = (BYTE)'\0';

                        /**********************************************/
                        /* Copy the file from the source directory    */
                        /* to the target directory.                   */
                        /**********************************************/
                        Result = prdm_CopyFile(
                                        SrcDirBuffer,
                                        TrgDirBuffer,
                                        CodePageCaps[Index].BINFileName,
                                        Dstname,
                                        BIN_EXTENSION );

                        if (Result != DOS_OK)
                        {
                            /******************************************/
                            /* Display error message and set the      */
                            /* focus back to the path entry box.      */
                            /******************************************/
                            (void)prdm_DispMessageBox(
                                                 hwnd,
                                                 Result,
                                                 SLEN_BOX_MESSAGE,
                                                 DB_TXT_CPF_TPATH,
                                                 MB_OK | MB_ICONEXCLAMATION );

                            WndId = DB_TXT_CPF_TPATH;
                            DlgResult = WinSetFocus(
                                          HWND_DESKTOP,
                                          WinWindowFromID(hwnd,WndId));
                        }
                        else
                        {
                            /******************************************/
                            /* Add new code page and return to the    */
                            /* Add a Code Page Box if successful.     */
                            /******************************************/
                            Result = prdm_AddCodePage( hwnd,
                                                       TrgDirBuffer );
                            if ( Result )
                                WinDismissDlg( hwnd, TRUE );
                        }
/*                  } */
                    break;

                case DB_PSH_CPF_NOCOPY:
                    /**************************************************/
                    /* Add new code page and return to the            */
                    /* Add a Code Page Box if successful.             */
                    /**************************************************/
                    Result = prdm_AddCodePage( hwnd,
                                               SrcDirBuffer );

                    if ( Result )
                        WinDismissDlg( hwnd, TRUE );
                    break;

                default:
                    break;
            }
            /*.. switch (SHORT1FROMMP(lparam1)) ......................*/

            break;

        case WM_INITDLG:
            /**********************************************************/
            /* Turn off 'Close' and 'Task Manager' options on the     */
            /* system menu.                                           */
            /**********************************************************/
/*          prdm_RemoveMenuOptions( hwnd ); */

            switch (DMData.DialogId)
            {
            case DB_CODE_PAGE_LIST:
                /******************************************************/
                /* DIAL/NILE : X24E's have 850 in resident, so need   */
                /* to display the code pages accordingly.             */
                /******************************************************/
                if ( (PrinterType == IBM_PRO_PRINTER_X24E) ||
                     (PrinterType == IBM_PRO_PRINTER_XL24E) )
                {
                    /**************************************************/
                    /* Code page 850 is a resident code page for      */
                    /* the X24E's so we want to display it above      */
                    /* the downloadable code pages listbox.           */
                    /**************************************************/
                    Result = WinSetDlgItemText(
                                          hwnd,
                                          DB_TXT_CPF_850,
                                          "850" );
                    WinLoadString( hab,
                                   DMData.HModule,
                                   IDS_CODE_PAGE_850_RES,
                                   SLEN_BOX_MESSAGE,
                                   (PSZ)szMessage );

                    Result = WinSetDlgItemText(
                                          hwnd,
                                          DB_TXT_CPF_850_DESC,
                                          (PSZ)szMessage );

                }
                else
                {
                    /**************************************************/
                    /* Display list of downloadable code pages:       */
                    /* - code page 850 (this is always available      */
                    /*   as a resource code page)                     */
                    /* - any added code pages.                        */
                    /**************************************************/
                    prdm_DisplayCodePage( hwnd,
                                          DB_LST_CPF_AVAIL,
                                          CP_850_INDEX );
                }

                /******************************************************/
                /* Only display the added code pages if there enough  */
                /* memory available.                                  */
                /******************************************************/
                if ( (pDMSettings->DownCPMemAvail == DOWN_CP_MEM_AVAIL) ||
                     (DDT[PrinterType]->DDTFontFlags &
                                          DDT_DOWN_CP_MEM_SUBSET_AVAIL) )

                    NoOfDispCPs = pDMSettings->NoOfAddedCPs;
                else
                    NoOfDispCPs = 0;

                for ( i = 0; i < NoOfDispCPs; i++ )
                {
                    prdm_DisplayCodePage( hwnd,
                                          DB_LST_CPF_AVAIL,
                                          pCPInfo->CPList[i].Added );
                }

                /******************************************************/
                /* Hilight any code page selected as initial.         */
                /******************************************************/
                TRACE4(TFUNC, "Init CP", &pDMSettings->InitCodePage, 1);

                if ( pDMSettings->InitCodePage != NO_INDEX_SELECTED )
                {
                    if ( pDMSettings->InitCodePage == CP_850_INDEX )
                    {
                        /**********************************************/
                        /* Code page 850 is always displayed first.   */
                        /**********************************************/
                        ListIndex = 0;
                    }
                    else
                    {
                        /**********************************************/
                        /* Get index to hilight from CPList info.     */
                        /**********************************************/
                        for ( i = 0; i < pDMSettings->NoOfAddedCPs; i++ )
                        {
                            if ( pCPInfo->CPList[i].Added ==
                                            pDMSettings->InitCodePage )
                            {
                                /**************************************/
                                /* DIAL/NILE: Adjust for X24E's as    */
                                /* code page 850 is resident.         */
                                /**************************************/
                                if ( (PrinterType == IBM_PRO_PRINTER_X24E) ||
                                     (PrinterType == IBM_PRO_PRINTER_XL24E) )
                                    ListIndex=i;
                                else
                                    ListIndex = i + 1;
                                break;
                            }
                         }
                    }

                    TRACE4(TFUNC, "ListIndex", &ListIndex, 1);

                    /**************************************************/
                    /* DIAL/NILE :                                    */
                    /* Make sure we dont hilight any code page other  */
                    /* than 850 if no memory is available.            */
                    /**************************************************/
                    if ( (pDMSettings->DownCPMemAvail
                                              == DOWN_CP_MEM_AVAIL) ||
                         (DDT[PrinterType]->DDTFontFlags &
                                      DDT_DOWN_CP_MEM_SUBSET_AVAIL) ||
                         (ListIndex == 0) )
                    {
                        (void)WinSendDlgItemMsg( hwnd,
                                                 DB_LST_CPF_AVAIL,
                                                 LM_SELECTITEM,
                                                 MPFROMSHORT(ListIndex),
                                                 (MPARAM)(ULONG)TRUE );
                    }
                }

                /******************************************************/
                /* Add button is always valid. But the driver checks  */
                /* if add_code_page_support and memory available.     */
                /******************************************************/
                DlgResult = WinEnableWindow(
                                        WinWindowFromID( hwnd, DB_PSH_ADD ),
                                        TRUE );

                /******************************************************/
                /* Set the enabled state of the REMOVE button - note  */
                /* that NoOfAddedCPs does not include code page 850.  */
                /******************************************************/
                EnableState =
                 ( (DDT[PrinterType]->DDTFontFlags &
                                         DDT_ADD_CODE_PAGE_SUPPORT) &&
                   (pDMSettings->NoOfAddedCPs != 0) );

                DlgResult = WinEnableWindow(
                                    WinWindowFromID( hwnd, DB_PSH_REMOVE ),
                                    EnableState );

                /******************************************************/
                /* DIAL/NILE : Set the enabled state of the RELOAD    */
                /* button.                                            */
                /******************************************************/
                if ( (pDMSettings->DownCPMemAvail == DOWN_CP_MEM_AVAIL ) ||
                     (DDT[PrinterType]->DDTFontFlags &
                          DDT_DOWN_CP_MEM_SUBSET_AVAIL) )
                    EnableState = ( pDMSettings->InitCodePage !=
                                                   NO_INDEX_SELECTED );
                else
                    EnableState = ( pDMSettings->InitCodePage ==
                                                        CP_850_INDEX );

                DlgResult = WinEnableWindow(
                                        WinWindowFromID( hwnd, DB_PSH_CPF_RELOAD ),
                                        EnableState );

                /******************************************************/
                /* Set the initial focus.                             */
                /******************************************************/
                WndId = DB_PSH_ENTER;
                break;

              case DB_ADD_CODE_PAGE:
                /******************************************************/
                /* Display list of downloadable code pages which can  */
                /* be added; i.e. those in DVTCodePageCaps which      */
                /* are marked as downloadable and which have not      */
                /* already been added.                                */
                /******************************************************/
                for ( Count = 0, i = 0; i < NO_OF_ADDABLE_CPS; i++ )
                {
                    if ( !pCPInfo->CPList[i].PathName &&
                         CodePageCaps[i+2].CPSource == CP_DOWNLOAD )
                    {
                        pCPInfo->CPList[Count++].Alter = i + 2;

                        prdm_DisplayCodePage( hwnd,
                                              DB_LST_CPF_ADDLIST,
                                              i + 2 );
                    }
                }

                /******************************************************/
                /* Select the first code page - this ensures one is   */
                /* always selected.                                   */
                /******************************************************/
                (void)WinSendDlgItemMsg( hwnd,
                                         DB_LST_CPF_ADDLIST,
                                         LM_SELECTITEM,
                                         MPFROMSHORT(0),
                                         (MPARAM)(ULONG)TRUE );

                /******************************************************/
                /* Set the initial focus.                             */
                /******************************************************/
                WndId = DB_LST_CPF_ADDLIST;
                break;

              case DB_REMOVE_CODE_PAGE:
                /******************************************************/
                /* Display list of added downloadable code pages.     */
                /******************************************************/
                for ( i = 0; i < pDMSettings->NoOfAddedCPs; i++ )
                {
                    ListIndex = pCPInfo->CPList[i].Added;

                    prdm_DisplayCodePage( hwnd,
                                          DB_LST_CPF_RLIST,
                                          ListIndex );

                    pCPInfo->CPList[i].Alter = ListIndex;
                }

                /******************************************************/
                /* Set the initial focus.                             */
                /******************************************************/
                WndId = DB_PSH_ENTER;
                break;

              case DB_RELOAD_CODE_PAGE:
                /******************************************************/
                /* Get the index of the code page selected as         */
                /* initial from the Code Page List box and display    */
                /* in the Reload code page box - there will always be */
                /* a selected code page as otherwise the Reload       */
                /* button is greyed out.                              */
                /******************************************************/
                ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                              DMData.hwndOwner,
                                              DB_LST_CPF_AVAIL,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT(LIT_FIRST),
                                              FNULL) );

                TRACE6(TFUNC, "Selected ListIndex", &ListIndex, 1);

                /******************************************************/
                /* Calculate index into DVTCodePageList array for     */
                /* the selected code page.                            */
                /*                                                    */
                /* DIAL/NILE : Must special case for X24E's as 850    */
                /* is not in the listbox anymore.                     */
                /*                                                    */
                /* Display and highlight the code page.               */
                /******************************************************/
                if ( (PrinterType == IBM_PRO_PRINTER_X24E) ||
                     (PrinterType == IBM_PRO_PRINTER_XL24E) )
                    DVTCPListIndex = pCPInfo->
                                          CPList[ListIndex].Added;
                else
                {
                     if ( ListIndex == 0 )
                         DVTCPListIndex = CP_850_INDEX;
                     else
                         DVTCPListIndex = pCPInfo->
                                               CPList[ListIndex - 1].Added;

                }

                TRACE6(TFUNC, "DVT ListIndex", &DVTCPListIndex, 1);

                prdm_DisplayCodePage( hwnd,
                                      DB_LST_CPF_INITIAL,
                                      DVTCPListIndex );

                (void) WinSendDlgItemMsg( hwnd,
                                          DB_LST_CPF_INITIAL,
                                          LM_SELECTITEM,
                                          MPFROMSHORT(0),
                                          (MPARAM)(ULONG)TRUE );

                /******************************************************/
                /* Select the current initial code page reload type.  */
                /******************************************************/
                if ( pDMSettings->InitCPReloadType == RELOAD_EACH_JOB )
                    BoxId = DB_RAD_CPF_PERJOB_ON;
                else
                    BoxId = DB_RAD_CPF_PERJOB_OFF;

             /* DlgResult = WinSendDlgItemMsg( hwnd, */
                WinSendDlgItemMsg( hwnd,                   /* CON3201 */
                                               BoxId,
                                               BM_SETCHECK,
                                               (MPARAM)TRUE,
                                               FNULL );

                /******************************************************/
                /* Set the initial focus.                             */
                /******************************************************/
                WndId = DB_PSH_CANCEL;
                break;

              case DB_CODE_PAGE_SOURCE:
                /******************************************************/
                /* Display the required diskette Part Numbers.        */
                /******************************************************/
                Result = WinSetDlgItemText(
                        hwnd,
                        DB_TXT_CPF_CRISPY,
                        CodePageCaps
                          [pCPInfo->AddCPIndex].NLSDiskName->CrispyNo );

                Result = WinSetDlgItemText(
                        hwnd,
                        DB_TXT_CPF_FLOPPY,
                        CodePageCaps
                          [pCPInfo->AddCPIndex].NLSDiskName->FloppyNo );

                /******************************************************/
                /* Set maximum length of entry field for path         */
                /******************************************************/
                WinSendDlgItemMsg( hwnd,
                                   DB_TXT_CPF_SPATH,
                                   EM_SETTEXTLIMIT,
                                   MPFROM2SHORT(MAX_PATH, 0),
                                   (MPARAM)0 );

                /******************************************************/
                /* Set the focus to the entry field for the           */
                /* drive/directory.                                   */
                /******************************************************/
                WndId = DB_TXT_CPF_SPATH;
                break;

              case DB_CODE_PAGE_TARGET:
                /**************************************************/
                /* Update drive to match where driver is. PD00666 */
                /**************************************************/
                WinQueryDlgItemText( hwnd,
                                     DB_TXT_CPF_TPATH,
                                     MAX_PATH,
                                     (PSZ)String );
                String[ MAX_PATH] = '\0';

                (VOID)PrfQueryProfileString( HINI_USERPROFILE,
                                             "PM_DEVICE_DRIVERS",
                                             InternalDriverName,
                                             "C:\\",
                                             DriveLetter,
                                             2L );
                String[0] = DriveLetter[0];

                Result = WinSetDlgItemText( hwnd,
                                            DB_TXT_CPF_TPATH,
                                            String );

                /******************************************************/
                /* Set maximum length of entry field for path         */
                /******************************************************/
                WinSendDlgItemMsg( hwnd,
                                   DB_TXT_CPF_TPATH,
                                   EM_SETTEXTLIMIT,
                                   MPFROM2SHORT(MAX_PATH, 0),
                                   (MPARAM)0 );

                /******************************************************/
                /* Set the focus to the entry field for the           */
                /* drive/directory.                                   */
                /******************************************************/
                WndId = DB_TXT_CPF_TPATH;
                break;

              default:
                break;
            }

            /**********************************************************/
            /* Set the active window                                  */
            /* PD00263 : Remove set active window. Now window always  */
            /* appears in the same place.                             */
            /**********************************************************/
#if 0
//          WinSendMsg( DMData.hwndHelp,
//                      HM_SET_ACTIVE_WINDOW,
//                      hwnd,
//                      hwnd );
#endif

            /**********************************************************/
            /* Set the initial focus                                  */
            /**********************************************************/
            DlgResult = WinSetFocus( HWND_DESKTOP,
                                     WinWindowFromID(hwnd, WndId));
            break;

        case WM_CONTROL:
            switch ( DMData.DialogId )
            {
              case DB_CODE_PAGE_LIST:
                /******************************************************/
                /* Trap selection of an initial code page.            */
                /******************************************************/
                if ( SHORT1FROMMP(lparam1) == DB_LST_CPF_AVAIL &&
                     SHORT2FROMMP(lparam1) == LN_SELECT )
                {
                    /**************************************************/
                    /* For this case, we are making a multiple        */
                    /* selection list box look as if it is single     */
                    /* selection.  This arises because we need to be  */
                    /* able to select and deselect downloadable       */
                    /* codepages as the initial code page.            */
                    /**************************************************/
                    /**************************************************/
                    /* Get index of first selected item in list box - */
                    /* if no item is selected there is nothing        */
                    /* to do.                                         */
                    /**************************************************/
                    FirstIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                            hwnd,
                                            DB_LST_CPF_AVAIL,
                                            LM_QUERYSELECTION,
                                            MPFROMSHORT(LIT_FIRST),
                                            FNULL ) );

                    if ( FirstIndex != (USHORT)LIT_NONE )
                    {
                        SecondIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                            hwnd,
                                            DB_LST_CPF_AVAIL,
                                            LM_QUERYSELECTION,
                                            MPFROMSHORT(FirstIndex),
                                            FNULL ) );

                        /**********************************************/
                        /* If there is more than one item selected    */
                        /* then we need to deselect the old one and   */
                        /* store the index of the new one.            */
                        /**********************************************/
                        if ( SecondIndex != (USHORT)LIT_NONE )
                        {
                            /******************************************/
                            /* Decide which item is to be deselected. */
                            /******************************************/
                            if ( FirstIndex == DMData.PrevIndex )
                            {
                                DeselectIndex    = FirstIndex;
                                DMData.PrevIndex = SecondIndex;
                            }
                            else
                            {
                                DeselectIndex    = SecondIndex;
                                DMData.PrevIndex = FirstIndex;
                            }

                            /******************************************/
                            /* Deselect the the old one.              */
                            /******************************************/
                            (void) SHORT1FROMMR( WinSendDlgItemMsg(
                                           hwnd,
                                           DB_LST_CPF_AVAIL,
                                           LM_SELECTITEM,
                                           MPFROMSHORT(DeselectIndex),
                                           MPFROMSHORT(FALSE) ) );
                        }
                        else
                        {
                            /******************************************/
                            /* Only one item is selected - store its  */
                            /* index for use next time a form is      */
                            /* selected.                              */
                            /******************************************/
                            DMData.PrevIndex = FirstIndex;
                        }
                    }

                    /**************************************************/
                    /* The initial code page may have been removed -  */
                    /* if so we should disable the Reload button.     */
                    /**************************************************/
                    EnableState = ( FirstIndex != (USHORT)LIT_NONE );

                    DlgResult = WinEnableWindow(
                                      WinWindowFromID( hwnd, DB_PSH_CPF_RELOAD ),
                                      EnableState );

                    /**************************************************/
                    /* Make sure the printerdata gets changed so      */
                    /* that the default font processing works right.  */
                    /**************************************************/
#if 0
//                  DMIniEntry[PrinterType].DataChange |=
//                                                 CODE_PAGE_LIST_CHANGE;
#endif
                }

                break;

              default:
                break;
            }
            /*.. switch (SHORT1FROMMP(lparam1)) ......................*/

            break;

        default:
            /**********************************************************/
            /* Pass any other messages to the default handler         */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));
            break;
    }
    /*.. switch (msg) ................................................*/

}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_EnterCodePageValues                               */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND    hwnd;                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prdm_EnterCodePageValues( hwnd )

HWND   hwnd;
#endif

USHORT prdm_EnterCodePageValues( HWND hwnd )               /* CON3201 */

{
#define TFUNC "prdm_EntrCdePge"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    SHORT       Result;        /* Function call return value ...      */
 /* MRESULT     DlgResult; */  /*                               ....  */
    ULONG       DlgResult;     /* CON3201                       ....  */
    USHORT      PrinterType;   /* Type of the current printer         */
    SHORT       ListIndex;     /* Index of selected item in list box  */
    USHORT      i;             /* Loop control variable               */
    USHORT      Count;         /* Count variable                      */
    USHORT      SearchCount;   /* Parameter for DosFindFirst          */
    USHORT      CPIndex;       /* Index of code page into             */
                               /* DVTCodePageList (array of length 9) */
    USHORT      MessageId;     /* For WinMessageBox                   */
    USHORT      WndId;         /* ID used to set the focus            */
                               /* dialog box                          */
    BOOL        RetCode;       /* Value returned to calling fn.       */
    lpDMCPInfo      pCPInfo;   /* Ptr to code page info in DMData     */
    lpDVTCPSource   CodePageCaps;
                               /* Code Page info for this printer     */


    /******************************************************************/
    /* First set up some useful variables.                            */
    /******************************************************************/
    PrinterType  = pDMSettings->PrinterType;
    CodePageCaps = DVTCodePageCaps[PrinterType];
    pCPInfo      = &DMData.CPInfo;

    /******************************************************************/
    /* Switch according to which dialog box it is.                    */
    /******************************************************************/
    switch ( DMData.DialogId )
    {
        case DB_CODE_PAGE_LIST:
            /**********************************************************/
            /* Check if any code page is selected as initial.         */
            /*                                                        */
            /* InitCodePage can take the following values:            */
            /*   -1 : no code page is selected as initial             */
            /*   >0 : use InitCodePage as index into DVTCodePageCaps  */
            /*        - note that 437 will never be selected so       */
            /*        InitCodePage will never be zero                 */
            /*                                                        */
            /* ListIndex will take the following values:              */
            /*   -1 : no code page is selected as initial             */
            /*    0 : this is always code page 850 for all            */
            /*        Pros except X24Es, where it is an added         */
            /*        code page                                       */
            /*   >0 : this is an added code page - check the Added    */
            /*        code page list in DMData to get the             */
            /*        corresponding index into the DVTCodePageCaps    */
            /*        array.                                          */
            /*                                                        */
            /* The DVTCodePageCaps array has 9 entries starting with  */
            /* 437 as the 0th and then 850 as the 1st; the code page  */
            /* list in DMData is an array with 7 entries starting     */
            /* with 851 as the 0th.                                   */
            /**********************************************************/
            ListIndex = SHORT1FROMMR(WinSendDlgItemMsg(
                                                hwnd,
                                                DB_LST_CPF_AVAIL,
                                                LM_QUERYSELECTION,
                                                MPFROMSHORT(LIT_FIRST),
                                                FNULL) );

            /**********************************************************/
            /* DIAL/NILE : ListIndex == 0 is not CP_850 for the X24Es */
            /**********************************************************/
            if ( (PrinterType == IBM_PRO_PRINTER_X24E) ||
                 (PrinterType == IBM_PRO_PRINTER_XL24E) )
            {
                if ( ListIndex >= 0 )
                    pDMSettings->InitCodePage = pCPInfo->
                                             CPList[ListIndex].Added;
                else
                    pDMSettings->InitCodePage = NO_INDEX_SELECTED;

            }
            else
            {
                if ( ListIndex > 0 )
                    pDMSettings->InitCodePage = pCPInfo->
                                             CPList[ListIndex - 1].Added;
                else if ( ListIndex == 0 )
                    pDMSettings->InitCodePage = CP_850_INDEX;
                else
                    pDMSettings->InitCodePage = NO_INDEX_SELECTED;
            }

            /**********************************************************/
            /* Calculate the size of the entry in the INI body data   */
            /* for the added code pages if the information has        */
            /* changed.                                               */
            /**********************************************************/
            if ( DMIniEntry[PrinterType].DataChange &
                                                CODE_PAGE_LIST_CHANGE )
            {
                pDMSettings->CodePageDataSize = 0;

                for ( i = 0; i < NO_OF_ADDABLE_CPS; i++ )
                {
                    if ( pCPInfo->CPList[i].PathName )
                    {
                        pDMSettings->CodePageDataSize +=
                                         NO_CODE_PAGE_DIGITS +
                                         PATHNAME_SIZE_LENGTH +
                                         pCPInfo->CPList[i].PathNameSize;
                    }
                }
            }

            /**********************************************************/
            /* Return TRUE so dialog box will be dismissed in         */
            /* prdm_CodePageDlgProc.                                  */
            /**********************************************************/
            return TRUE;
            break;

        case DB_ADD_CODE_PAGE:
            /**********************************************************/
            /* Return TRUE so dialog box will be dismissed in         */
            /* prdm_CodePageDlgProc.                                  */
            /**********************************************************/
            return TRUE;
            break;

        case DB_CODE_PAGE_SOURCE:
            /**********************************************************/
            /* Read the directory name from the entry box             */
            /**********************************************************/
            WinQueryDlgItemText( hwnd,
                                 DB_TXT_CPF_SPATH,
                                 MAX_PATH,
                                 (PSZ)SrcDirBuffer );

            /**********************************************************/
            /* Check if the directory exists and contains the         */
            /* correct BIN file.                                      */
            /**********************************************************/
            TRACE4(TFUNC, "Look for BIN", FNULL, 0);

            DMData.SearchDirHandle = 0xFFFF;

            Result = prdm_CheckFileExists(
                          SrcDirBuffer,
                          CodePageCaps[pCPInfo->AddCPIndex].BINFileName,
                          BIN_EXTENSION,
                          &DMData.SearchDirHandle,
                          &DMData.FileInfoBuf );

            /**********************************************************/
            /* Report absence of BIN file back to user.               */
            /**********************************************************/
            if ( Result != FILE_FOUND )
            {
                if ( Result == PATH_NOT_FOUND )
                    MessageId = IDS_PATH_NOT_FOUND;
                else
                    MessageId = IDS_FILE_NOT_FOUND;

                (void)prdm_DispMessageBox( hwnd,
                                           MessageId,
                                           SLEN_BOX_MESSAGE,
                                           DB_TXT_CPF_SPATH,
                                           MB_OK | MB_ICONEXCLAMATION );

                /******************************************************/
                /* Set focus back to path entry box                   */
                /******************************************************/
                WndId = DB_TXT_CPF_SPATH,
                DlgResult = WinSetFocus( HWND_DESKTOP,
                                         WinWindowFromID(hwnd, WndId));

                RetCode = FALSE;
            }
            else
            {
                /******************************************************/
                /* Return TRUE so dialog box will be dismissed in     */
                /* prdm_CodePageDlgProc.                              */
                /******************************************************/
                RetCode = TRUE;
            }

            return (RetCode);
            break;

        case DB_REMOVE_CODE_PAGE:
            /**********************************************************/
            /* Remove all the code pages which have been selected.    */
            /**********************************************************/
            do
            {
                /******************************************************/
                /* Query the index of first selected item in listbox  */
                /* - we query the first since what was previously     */
                /* the first will have been deleted.                  */
                /******************************************************/
                ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                              hwnd,
                                              DB_LST_CPF_RLIST,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT(LIT_FIRST),
                                              FNULL) );

                TRACE6(TFUNC, "Remove ListIndex", &ListIndex, 1);

                /******************************************************/
                /* If an item has been selected...                    */
                /******************************************************/
                if ( ListIndex != LIT_NONE )
                {
                    /**************************************************/
                    /* Remove the entry for the code page from the    */
                    /* list in DMData.                                */
                    /* CPList in CPInfo does not contain entries for  */
                    /* 437 and 850 (since these code pages cannot be  */
                    /* added or removed) and so has length 7.         */
                    /* The values held in the Alter and Added fields  */
                    /* are into the full CP array of length 9.        */
                    /**************************************************/
                    CPIndex = pCPInfo->CPList[ListIndex].Alter;

                 /* SSFREESEG( SELECTOROF(                                */
                 /*             pCPInfo->CPList[CPIndex - 2].PathName) ); */
                    SSFREEMEM(pCPInfo->CPList[CPIndex - 2].PathName);/*CON3201*/

                    pCPInfo->CPList[CPIndex - 2].PathName     = FNULL;
                    pCPInfo->CPList[CPIndex - 2].PathNameSize = 0;

                    /**************************************************/
                    /* Reset the Added and Alter lists.               */
                    /**************************************************/
                    for ( i = ListIndex;
                          i < NO_OF_ADDABLE_CPS - 1;
                          i++ )
                    {
                        pCPInfo->CPList[i].Alter =
                                            pCPInfo->CPList[i+1].Alter;
                        pCPInfo->CPList[i].Added =
                                            pCPInfo->CPList[i+1].Added;
                    }

                    /**************************************************/
                    /* Remove the entry for the code page from the    */
                    /* list boxes.                                    */
                    /**************************************************/
                 /* DlgResult = SHORT1FROMMR( WinSendDlgItemMsg( */
                    WinSendDlgItemMsg(                     /* CON3201 */
                                           hwnd,
                                           DB_LST_CPF_RLIST,
                                           LM_DELETEITEM,
                                           MPFROMSHORT(ListIndex),
                                        /* FNULL) ); */
                                           FNULL);         /* CON3201 */

                    /**************************************************/
                    /* DIAL/NILE :                                    */
                    /* Must adjust for 850 being resident in the      */
                    /* X24E's.                                        */
                    /**************************************************/
                    if ( (PrinterType == IBM_PRO_PRINTER_X24E) ||
                         (PrinterType == IBM_PRO_PRINTER_XL24E) )
                    {
                     /* DlgResult = SHORT1FROMMR( WinSendDlgItemMsg( */
                        WinSendDlgItemMsg(                 /* CON3201 */
                                               DMData.hwndOwner,
                                               DB_LST_CPF_AVAIL,
                                               LM_DELETEITEM,
                                               MPFROMSHORT(ListIndex),
                                            /* FNULL) ); */
                                               FNULL);     /* CON3201 */
                    }
                    else
                    {
                     /* DlgResult = SHORT1FROMMR( WinSendDlgItemMsg( */
                        WinSendDlgItemMsg(                 /* CON3201 */
                                               DMData.hwndOwner,
                                               DB_LST_CPF_AVAIL,
                                               LM_DELETEITEM,
                                               MPFROMSHORT(ListIndex + 1),
                                            /* FNULL) ); */
                                               FNULL);     /* CON3201 */
                    }

                    /**************************************************/
                    /* Decrement the number of added code pages and   */
                    /* set the Change flag to ensure the code page    */
                    /* list hanging off the PDB instance data is      */
                    /* updated at the start of the next job.          */
                    /**************************************************/
                    pDMSettings->NoOfAddedCPs--;

                    DMIniEntry[PrinterType].DataChange |=
                                                   CODE_PAGE_LIST_CHANGE;

                    /***************************************************/
                    /* If the user has removed the code page           */
                    /* containing the default font then warn them      */
                    /* and revert to a resident font.                  */
                    /***************************************************/
                    if ( CPIndex == DMData.DfltFontInfo.Info.CodePageNo )
                    {
                        (void) prdm_DispMessageBox(
                                         hwnd,
                                         IDS_CODE_PAGE_REMOVED,
                                         SLEN_BOX_MESSAGE,
                                         DB_REMOVE_CODE_PAGE,
                                         MB_OK | MB_ICONASTERISK );

                        DMData.DfltFontInfo.Info.Type = FT_RESIDENT;
                        pDMSettings->DfltFontInfoSize  =
                                                 DFLTFONT_RESIDENT_LEN;
                        DMData.DfltFontInfo.Info.Index  =
                                       DDT[PrinterType]->DDTDfltFontNo;
                    }

                    if (CPIndex == pDMSettings->InitCodePage)
                    {
                        /**********************************************/
                        /* We are deleting the initial download code- */
                        /* page so mark that there is no longer an    */
                        /* initial download codepage.                 */
                        /**********************************************/
                        pDMSettings->InitCodePage = NO_INDEX_SELECTED;
                    }

                }
                /* .... if ( ListIndex != LIT_NONE ) ................ */

            } while ( ListIndex != LIT_NONE );

            /**********************************************************/
            /* Return TRUE so dialog box will be dismissed in         */
            /* prdm_CodePageDlgProc.                                  */
            /**********************************************************/
            return TRUE;
            break;

        case DB_RELOAD_CODE_PAGE:
            /**********************************************************/
            /* Store the initial code page reload type setting and    */
            /* set the Reload flag in DMIniEntry.                     */
            /**********************************************************/
            if ( WinSendDlgItemMsg( hwnd,
                                    DB_RAD_CPF_PERJOB_ON,
                                    BM_QUERYCHECK,
                                    FNULL,
                                    FNULL) )
                pDMSettings->InitCPReloadType = RELOAD_EACH_JOB;
            else
                pDMSettings->InitCPReloadType = DONT_RELOAD_EACH_JOB;

            DMIniEntry[PrinterType].DataChange |= CODE_PAGE_INIT_RELOAD;

            /**********************************************************/
            /* Return TRUE so dialog box will be dismissed in         */
            /* prdm_CodePageDlgProc.                                  */
            /**********************************************************/
            return TRUE;
            break;
    }
    /*.. switch ( DMData.DialogId ) ..................................*/

}
#undef TFUNC





/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_AddCodePage                                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND          hwnd;                                              */
/*   PSZ           CodePagePath;                                      */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   Adjusts the Code Page list to add a new code page.               */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prdm_AddCodePage( hwnd,
                                CodePagePath )

HWND             hwnd;
PSZ              CodePagePath;
#endif

USHORT prdm_AddCodePage( HWND hwnd,                        /* CON3201 */
                         PSZ  CodePagePath )               /* CON3201 */

{
#define TFUNC "prdm_AddCP"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT       Result;       /* Function call return values ..      */
    MRESULT      DlgResult;    /*                               ....  */
    USHORT       CPIndex;      /* Index of new code page in list in   */
                               /* DMData                              */
    USHORT       i;            /* Loop variable                       */
    USHORT       Count;        /* Count variable                      */
    USHORT       PathNameSize;
    lpDMCPInfo   pCPInfo;
    USHORT       PrinterType;  /* Type of the current printer         */


    TRACE8(TFUNC, "Entry", FNULL, 0);
    TRACE4(TFUNC, "Path",  CodePagePath, 4);

    /******************************************************************/
    /* First set up some useful variables.                            */
    /******************************************************************/
    PrinterType  = pDMSettings->PrinterType;
    pCPInfo      = &DMData.CPInfo;

    /******************************************************************/
    /* Allow for no 850 entry in code page list in DMData.            */
    /******************************************************************/
    CPIndex = pCPInfo->AddCPIndex - 2;
    TRACE4(TFUNC, "CPIndex", &CPIndex, 1);

    PathNameSize = prdu_strlen( CodePagePath );
    TRACE4(TFUNC, "Pathname size", &PathNameSize, 1);

    /******************************************************************/
    /* Allocate memory for the new path and copy it across.           */
    /******************************************************************/
 /* Result = SSALLOCSEG( PathNameSize,                                    */
 /*                       &SELECTOROF(pCPInfo->CPList[CPIndex].PathName), */
 /*                       0 );                                            */
    Result = SafeSSALLOCMEM( &(pCPInfo->CPList[CPIndex].PathName), /*CON3201*/
                             PathNameSize,                         /*CON3201*/
                             0 );                                  /*CON3201*/

    if ( Result != DOS_OK )
    {
        TRACE8(TFUNC, "DosAlloc failed", FNULL, 0);
        return (ERROR_ZERO);
    }

/*  OFFSETOF(pCPInfo->CPList[CPIndex].PathName) = 0;              CON3201 */

    for ( i = 0; i < PathNameSize; i++ )
        pCPInfo->CPList[CPIndex].PathName[i] = CodePagePath[i];

    pCPInfo->CPList[CPIndex].PathNameSize = PathNameSize;

    /******************************************************************/
    /* Reset the Added and Alter lists.                               */
    /******************************************************************/
    for ( i = 0; pCPInfo->CPList[i].Alter != pCPInfo->AddCPIndex; i++ );

    for ( ; i < NO_OF_ADDABLE_CPS - 1; i++ )
        pCPInfo->CPList[i].Alter = pCPInfo->CPList[i+1].Alter;

    Count = 0;
    for ( i = 0; i < NO_OF_ADDABLE_CPS; i++ )
    {
        if ( pCPInfo->CPList[i].PathName )
            pCPInfo->CPList[Count++].Added = i + 2;
    }

    /******************************************************************/
    /* Increment the number of added CPs and set the CP change flag.  */
    /******************************************************************/
    pDMSettings->NoOfAddedCPs++;
    DMIniEntry[PrinterType].DataChange |= CODE_PAGE_LIST_CHANGE;

    return (OK);
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_DisplayCodePage                                   */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND       hwnd;                                                 */
/*   USHORT     ListBoxId;                                            */
/*   USHORT     CodePageNo;                                           */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
void prdm_DisplayCodePage( hwnd,
                           ListBoxId,
                           CodePageNo )

HWND       hwnd;
USHORT     ListBoxId;         /* List box in which code page entry is */
                              /* displayed                            */
USHORT     CodePageNo;        /* Index into the DVTCodePageList array */
                              /* (not the DVTCodePageCaps array)      */
#endif

void prdm_DisplayCodePage( HWND   hwnd,                    /* CON3201 */
                           USHORT ListBoxId,               /* CON3201 */
                           USHORT CodePageNo )             /* CON3201 */

{

#define TFUNC "prdm_DispCdePge"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT   i;               /* Loop variable                        */
    PBYTE    pDest;           /* Working pointer                      */
    MRESULT  DlgResult;       /* Function call result                 */

    TRACE4(TFUNC, "CodePageNo", &CodePageNo, 1);

    /******************************************************************/
    /* Build the entry as follows:                                    */
    /*   space, code page number,                                     */
    /*   space, code page name.                                       */
    /******************************************************************/
    pDest = szMessage;
    for ( i = 0; i < 6; i++ )
        *pDest++ = ' ';

    /******************************************************************/
    /* Write the code page number.                                    */
    /******************************************************************/
    prdm_WriteTextFromWord( DVTCodePageList[CodePageNo].Number,
                            3,
                            pDest );

    /******************************************************************/
    /* Add some more space.                                           */
    /******************************************************************/
    for ( i = 0; i < 10; i++ )
        *pDest++ = ' ';

    /******************************************************************/
    /* Add the code page name.                                        */
    /******************************************************************/
    WinLoadString( hab,
                   DMData.HModule,
                   IDS_CODE_PAGE_437 + CodePageNo,
                   SLEN_BOX_MESSAGE,
                   (PSZ)pDest );

    TRACE4(TFUNC, "szMessage", szMessage, 20);

    /******************************************************************/
    /* Display the new entry.                                         */
    /******************************************************************/
    DlgResult = WinSendDlgItemMsg( hwnd,
                                   ListBoxId,
                                   LM_INSERTITEM,
                                   (MPARAM)(ULONG)LIT_SORTASCENDING,
                                   MPFROMP(szMessage) );

    TRACE4(TFUNC, "Display entry result", &DlgResult, 1);
}
#undef TFUNC

