/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMCONN
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdm_ConnDlgProc
 *             prdm_EnterConnections
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_WINHELP
#define INCL_DOSSEMAPHORES
#define INCL_GPIERRORS
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_DOSMODULEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINERRORS
#define INCL_WINDIALOGS
#define INCL_WINSHELLDATA
#define INCL_WINENTRYFIELDS
#define INCL_WINMESSAGEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIERRORS
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_DOSMODULEMGR
#undef INCL_WINFRAMEMGR
#undef INCL_WINLISTBOXES
#undef INCL_WINBUTTONS
#undef INCL_WINERRORS
#undef INCL_WINDIALOGS
#undef INCL_WINSHELLDATA
#undef INCL_WINENTRYFIELDS
#undef INCL_WINMESSAGEMGR
#undef INCL_WININPUT
#undef INCL_WINMENUS
#undef INCL_WINPOINTERS
#undef INCL_WINHELP

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELSERVER
#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELSERVER
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI

#define INCL_WINSHELLDATA
/* #include <pmshlp.h>                                              DLM01 */
#define INCL_WINSHELLDATA
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdmcone.h>

#define NO_SYS
#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP
#undef PRDMTYPE_INCL

#include <prdmextf.h>
#include <prduextf.h>
#include <prdmtrcf.h>

extern DModeDataType  DMData;
extern lpDMSettings   pDMSettings;
extern lpDDTType      DDT [];

extern CHAR           szMessage[SLEN_BOX_MESSAGE];






/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_ConnDlgProc                                       */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   Standard dialog box control procedure parameter block            */
/*                                                                    */
/*   HWND    hwnd;                                                    */
/*   USHORT  msg;                                                     */
/*   MPARAM  lparam1;                                                 */
/*   MPARAM  lparam2;                                                 */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function allows the user to specify the forms which are     */
/*   mounted in each of the available paper sources.                  */
/*                                                                    */
/**********************************************************************/
#if 0
MRESULT pascal far _loadds prdm_ConnDlgProc( hwnd,
                                             msg,
                                             lparam1,
                                             lparam2 )

HWND    hwnd;
USHORT  msg;
MPARAM  lparam1;
MPARAM  lparam2;
#endif

MRESULT prdm_ConnDlgProc( HWND   hwnd,                     /* CON3201 */
                          USHORT msg,                      /* CON3201 */
                          MPARAM lparam1,                  /* CON3201 */
                          MPARAM lparam2 )                 /* CON3201 */

{
#define TFUNC "prdm_ConnDlgPrc"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    MRESULT  DlgResult;        /* Returned result from dialog fn.     */
    USHORT   FirstIndex;       /* Index of item in list box           */
    USHORT   SecondIndex;      /*     ...........                     */
    USHORT   DeselectIndex;    /*                ..............       */
    USHORT   Result;           /* Function call return values         */
    lpDVTSourceList    pSourceInfo;
                               /* Sources list for the current        */
                               /* printer                             */
    lpDVTSourceTray    pTrayInfo;
                               /* Tray list for the current source    */
    USHORT   CurrentFormIndex; /* Index of form assoc. with source    */
    USHORT   NoOfForms;        /* Number of forms assoc. with source  */
    PUSHORT  pFormIndices;     /* Form indices for source             */
    USHORT   i;                /* Loop variable                       */
#if 0
    sForm far *  Form;         /* Pointer to form data structure for  */
                               /* stepping through the forms          */
    char far *   cp;           /* Pointer for accessing the text      */
#endif
                                                           /* CON3201 */
    sForm     *  Form;         /* Pointer to form data structure for  */
                               /* stepping through the forms          */
    char     *   cp;           /* Pointer for accessing the text      */
    BYTE     SourceType;       /* Paper or Envelope                   */
    PUSHORT  pManualForms;     /* Indexes of the manual forms         */
    USHORT   FormCnt;          /* Count of forms processed in loop    */
    USHORT   EnvelCnt;         /* Count of envelope forms in loop     */
    USHORT   MultiCnt;         /* Count of envelope and default forms */
    USHORT   PaperCnt;         /* Count of paper forms in loop        */
    USHORT   ManEnvCnt;        /* Count of manual paper forms in loop */
    USHORT   ManPaperCnt;      /* Count of manual envelope forms loop */
    BOOL     PaperTrayConv[MAX_NO_OF_PAPER_TRAYS + 1];
                               /* Whether forms in the paper trays    */
                               /* have converted to real form indices */
    BOOL     EnvelTrayConv;    /* Whether forms in the envelope tray  */
                               /* have converted to real form index   */
    BOOL     MultiTrayConv;    /* Whether forms in the multi tray     */
                               /* have converted to real form index   */
    lpDDTType    pDDT;         /* Pointer to DDT for this printer     */
    USHORT   MsgId;            /* INKJET : Holds the resource ID of   */
                               /* the strings identifying the form    */
    USHORT   FormIndex;        /* Index of the highlighted form       */
    USHORT   SourceIndex;      /* Index of the highlighted source     */


    pDDT = DDT[pDMSettings->PrinterType];

    switch (msg)
    {
        case WM_HELP:
            /**********************************************************/
            /* PD00199 : The message is always going to go to the     */
            /* default handler, but give the driver a chance to do    */
            /* a little bit of processing first.                      */
            /**********************************************************/
            (VOID) prdm_HelpMessageProcessing ( hwnd, msg, lparam1, lparam2 );

            /**********************************************************/
            /* Now pass message to the default message handler.       */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));


        case WM_CONTROL:
            /**********************************************************/
            /* Trap a selection in the available forms list box.      */
            /**********************************************************/
            if ( (SHORT1FROMMP(lparam1) == DB_LST_AVAILABLE_FORMS) &&
                 (SHORT2FROMMP(lparam1) == LN_SELECT))
            {
                /******************************************************/
                /* See if we are making a multiple selection list     */
                /* box look as if it is single selection.  This       */
                /* arises since manual sources can have multiple      */
                /* forms associated with them while automatic         */
                /* sources can only have one.                         */
                /******************************************************/
                if ( DMData.SingleSelection )
                {
                    /**************************************************/
                    /* Get index of first selected item in list box - */
                    /* if no item is selected there is nothing        */
                    /* to do.                                         */
                    /**************************************************/
                    FirstIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                            hwnd,
                                            DB_LST_AVAILABLE_FORMS,
                                            LM_QUERYSELECTION,
                                            MPFROMSHORT(LIT_FIRST),
                                            FNULL ) );


                    if ( FirstIndex != (USHORT)LIT_NONE )
                    {
                        SecondIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                            hwnd,
                                            DB_LST_AVAILABLE_FORMS,
                                            LM_QUERYSELECTION,
                                            MPFROMSHORT(FirstIndex),
                                            FNULL ) );

                        /**********************************************/
                        /* If there is more than one item selected    */
                        /* then we need to deselect the old one and   */
                        /* store the index of the new one.            */
                        /**********************************************/
                        if ( SecondIndex != (USHORT)LIT_NONE )
                        {
                            /******************************************/
                            /* Decide which item is to be deselected. */
                            /******************************************/
                            if ( FirstIndex == DMData.PrevIndex )
                            {
                                DeselectIndex    = FirstIndex;
                                DMData.PrevIndex = SecondIndex;
                            }
                            else
                            {
                                DeselectIndex    = SecondIndex;
                                DMData.PrevIndex = FirstIndex;
                            }

                            /******************************************/
                            /* Deselect the the old one.              */
                            /******************************************/
                            (void) SHORT1FROMMR( WinSendDlgItemMsg(
                                           hwnd,
                                           DB_LST_AVAILABLE_FORMS,
                                           LM_SELECTITEM,
                                           MPFROMSHORT(DeselectIndex),
                                           MPFROMSHORT(FALSE) ) );
                        }
                        else
                        {
                            /******************************************/
                            /* Only one item is selected - store its  */
                            /* index for use next time a form is      */
                            /* selected.                              */
                            /******************************************/
                            DMData.PrevIndex = FirstIndex;
                        }
                    }
                    else
                    {
                        /**********************************************/
                        /* Reselect the the old one.                  */
                        /**********************************************/
                        (void) SHORT1FROMMR( WinSendDlgItemMsg(
                                       hwnd,
                                       DB_LST_AVAILABLE_FORMS,
                                       LM_SELECTITEM,
                                       MPFROMSHORT(DMData.PrevIndex),
                                       MPFROMSHORT(TRUE) ) );
                    }
                    /* .... if ( FirstIndex != LIT_NONE )............. */

                }
            }
            /*......... if available form selected.................... */


            /**********************************************************/
            /* Trap a selection in the source tray list box.          */
            /**********************************************************/
            if ( (SHORT1FROMMP(lparam1) == DB_LST_PAPER_SOURCES) &&
                 (SHORT2FROMMP(lparam1) == LN_SELECT))
            {
                /******************************************************/
                /* Store the form associations for the previous       */
                /* source tray.                                       */
                /******************************************************/
                Result = prdm_EnterConnections( hwnd );

                /******************************************************/
                /* Get the index of the selected source tray.         */
                /******************************************************/
                FirstIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                               hwnd,
                                               DB_LST_PAPER_SOURCES,
                                               LM_QUERYSELECTION,
                                               MPFROMSHORT(LIT_FIRST),
                                               FNULL ) );

                /******************************************************/
                /* Pick up a pointer to the data for the newly        */
                /* selected source tray.  This is done as follows:    */
                /* - Get the pointer to the source list for the       */
                /*     current printer                                */
                /* - Adjust the pointer according to the current      */
                /*     source index                                   */
                /* - Allow for the special case of the dual tray      */
                /*     sources on the Qs                              */
                /* - Get the pointer to the tray list for the         */
                /*     current source                                 */
                /* - Adjust the pointer according to the (newly       */
                /*     selected) current tray index                   */
                /* Got that?                                          */
                /******************************************************/
                pSourceInfo = pDDT->DDTSourceList;
                pSourceInfo += pDMSettings->SourceIndex;

                /******************************************************/
                /* Allow for added sources.  On Quiet/Quick printers  */
                /* and 4019Laser this is just the Envelope feed.  On  */
                /* the Heritage this may be Envelope or MultiMedia.   */
                /* The pSourceInfo is an index into the DVTSourceList */
                /* tables defined in prdd????.c                       */
                /******************************************************/
                if ( pDMSettings->AddedFeed == FD_ENVELOPE )
                    pSourceInfo += 1;
                else if (pDMSettings->AddedFeed == FD_MULTIMEDIA)
                    pSourceInfo += 2;
                else if (pDMSettings->AddedFeed == FD_100_SHEET)
                    pSourceInfo += 3;

                pTrayInfo  = pSourceInfo->SourceTrayList;
                pTrayInfo += FirstIndex;

                /******************************************************/
                /* Set the following depending on the source tray     */
                /* just selected:                                     */
                /*  - SourceType (paper/envelope)                     */
                /*  - Current Source (a CS_ constant)                 */
                /*  - Single or multiple selection mode               */
                /*  - Current Form Index (for single selection)       */
                /*  - Pointer to form list and number of forms (for   */
                /*      multiple selection)                           */
                /******************************************************/
                SourceType = pTrayInfo->SourceType;

                DMData.CurrentSource = pTrayInfo->DMTrayUsage;
                DMData.SingleSelection =
                               ( pTrayInfo->FeedType == DDT_AUTO_FEED );

                switch ( DMData.CurrentSource )
                {
                    case CS_PAPER_TRAY_1:
                    case CS_PAPER_TRAY_2:
                    case CS_PAPER_TRAY_3:
                    case CS_TRACTOR_FEED:
                    case CS_ENVELOPE_TRAY:
                        CurrentFormIndex =
                                DMData.TmpConnsInfo.AutoTrayForm
                                               [DMData.CurrentSource];
                        break;

                    case CS_MANUAL_PAPER:
                        NoOfForms = DMData.TmpConnsInfo.NoOfManualPaper;
                        pFormIndices = DMData.TmpConnsInfo.pManualPaper;
                        break;

                    case CS_MANUAL_ENVELOPE:
                        NoOfForms = DMData.TmpConnsInfo.NoOfManualEnv;
                        pFormIndices = DMData.TmpConnsInfo.pManualEnvelope;
                        break;
                }

                /******************************************************/
                /* We need to re-initialise the list of forms.        */
                /* Check if the type of form to be selected is the    */
                /* same as the type of form currently displayed in    */
                /* the list of available forms.                       */
                /******************************************************/
                if ( DMData.SourceType != SourceType )
                {
                    /**************************************************/
                    /* Sweep back all the forms currently displayed.  */
                    /**************************************************/
                    FirstIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                                 hwnd,
                                                 DB_LST_AVAILABLE_FORMS,
                                                 LM_QUERYITEMCOUNT,
                                                 MPFROMSHORT(0),
                                                 FNULL ) );
                    while ( FirstIndex != 0 )
                    {
                        FirstIndex--;
                     /* DlgResult = SHORT1FROMMR( WinSendDlgItemMsg( */
                        DlgResult = WinSendDlgItemMsg(     /* CON3201 */
                                              hwnd,
                                              DB_LST_AVAILABLE_FORMS,
                                              LM_DELETEITEM,
                                              MPFROMSHORT(FirstIndex),
                                           /* FNULL ) ); */
                                              FNULL );     /* CON3201 */
                    }

                    /**************************************************/
                    /* Loop through all the forms and display those   */
                    /* of the correct type (paper/envelope).          */
                    /**************************************************/
                    for ( Form = DMData.Forms;
                          Form;
                          Form = Form->NextForm )
                    {
                        /******************************************************/
                        /* Ignore it if it is not the same type.              */
                        /*  INKJET : The 4072 displays all of the forms for   */
                        /*  paper tray 1 which has a SourceType of Paper or   */
                        /*  Envelope available.                               */
                        /******************************************************/

                        if ( SourceType == DDT_DEFAULT_OR_ENV_FORM )
                        {
                           if (( Form->FormType != SourceType ) &&
                               ( Form->FormType != DDT_ENVELOPE_FORM))
                           {
                              continue;
                           }
                        }
                        else if (( Form->FormType != SourceType ) &&
                                 ( SourceType != (DDT_PAPER_FORM |
                                                  DDT_ENVELOPE_FORM) ) )
                        {
                           continue;
                        }

                        /**********************************************/
                        /* Replace the form name delimiter with a     */
                        /* null terminator in order to display it.    */
                        /**********************************************/
                     /* for ( cp = (char far *)Form->FormData; */
                        for ( cp = (char *)Form->FormData; /* CON3201 */
                              *cp != '\1';
                              cp++ )
                        ;
                        *cp = '\0';

                        DlgResult = WinSendDlgItemMsg(
                                             hwnd,
                                             DB_LST_AVAILABLE_FORMS,
                                             LM_INSERTITEM,
                                             (MPARAM)(ULONG)LIT_END,
                                             MPFROMP(Form->FormData) );
                        *cp = '\1';
                    }

                    /**************************************************/
                    /* Store the new source type.                     */
                    /**************************************************/
                    DMData.SourceType = SourceType;
                }
                else
                {
                    /**************************************************/
                    /* Clear the selected forms - the loop always     */
                    /* breaks from the middle.                        */
                    /**************************************************/
                    FirstIndex = LIT_NONE;

                    while ( TRUE )
                    {
                        FirstIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                           hwnd,
                                           DB_LST_AVAILABLE_FORMS,
                                           LM_QUERYSELECTION,
                                           MPFROMSHORT(FirstIndex),
                                           FNULL ) );

                        /**********************************************/
                        /* If no more items selected break out of     */
                        /* loop.                                      */
                        /**********************************************/
                        if ( FirstIndex == (USHORT)LIT_NONE )
                            break;

                        /**********************************************/
                        /* Deselect the item in the list box.         */
                        /**********************************************/
                     /* DlgResult = SHORT1FROMMR( WinSendDlgItemMsg( */
                        DlgResult = WinSendDlgItemMsg(     /* CON3201 */
                                             hwnd,
                                             DB_LST_AVAILABLE_FORMS,
                                             LM_SELECTITEM,
                                             MPFROMSHORT(FirstIndex),
                                          /* MPFROMSHORT(FALSE) ) ); */
                                             MPFROMSHORT(FALSE) );/*CON3201*/
                    }
                }

                /******************************************************/
                /* Having redrawn the list of forms we need to        */
                /* hilite/select those associated with the new        */
                /* source tray.                                       */
                /******************************************************/
                if ( DMData.SingleSelection )
                {
                    /**************************************************/
                    /* Highlight the form currently associated with   */
                    /* the selected source.                           */
                    /**************************************************/
                    DlgResult = WinSendDlgItemMsg(
                                         hwnd,
                                         DB_LST_AVAILABLE_FORMS,
                                         LM_SELECTITEM,
                                         MPFROMSHORT(CurrentFormIndex),
                                         (MPARAM)(ULONG)TRUE );
                }
                else
                {
                    /**************************************************/
                    /* Source tray can have multiple forms mounted.   */
                    /* Display the currently associated forms.        */
                    /**************************************************/
                    for ( i = 0; i < NoOfForms; i++ )
                    {
                        DlgResult = WinSendDlgItemMsg(
                                          hwnd,
                                          DB_LST_AVAILABLE_FORMS,
                                          LM_SELECTITEM,
                                          MPFROMSHORT(pFormIndices[i]),
                                          (MPARAM)(ULONG)TRUE );
                    }
                }
            }  /*...............if paper source selected..............*/

            break;

        case WM_CLOSE:
            /**********************************************************/
            /* Trap Close from system menu                            */
            /* Note: this will fall into WM_COMMAND with CANCEL set   */
            /**********************************************************/
         /* SHORT1FROMMP(lparam1) = DB_PSH_CANCEL; */
            lparam1 = MPFROM2SHORT( DB_PSH_CANCEL,           /*CON3201*/
                                    SHORT2FROMMP(lparam1) ); /*CON3201*/

        case WM_COMMAND:
            /**********************************************************/
            /* The message is a command (ie a button) so switch       */
            /* depending on which button it was.                      */
            /**********************************************************/
            switch (SHORT1FROMMP(lparam1))
            {
                case DB_PSH_ENTER:
                    /**************************************************/
                    /* Get the connections currently displayed in the */
                    /* connections list box.                          */
                    /**************************************************/
                    if ( !(Result = prdm_EnterConnections( hwnd )) )
                        break;

                    /**************************************************/
                    /* Free the buffers holding previous current state*/
                    /**************************************************/
                    if ( DMData.ConnsInfo.pManualEnvelope )
                     /* SSFREESEG(SELECTOROF(                            */
                     /*             DMData.ConnsInfo.pManualEnvelope )); */
                        SSFREEMEM( DMData.ConnsInfo.pManualEnvelope );/*CON3201*/

                    if ( DMData.ConnsInfo.pManualPaper )
                     /* SSFREESEG(SELECTOROF(                         */
                     /*             DMData.ConnsInfo.pManualPaper )); */
                        SSFREEMEM( DMData.ConnsInfo.pManualPaper );/*CON3201*/

                    /**************************************************/
                    /* Update the current state of the connections    */
                    /* to the state that the user has selected.       */
                    /**************************************************/
                    DMData.ConnsInfo = DMData.TmpConnsInfo;

                    /**************************************************/
                    /* Convert from indices for a particular form     */
                    /* back to a true form number                     */
                    /**************************************************/
                    FormCnt = 0;
                    EnvelCnt = 0;
                    MultiCnt = 0;
                    PaperCnt = 0;
                    ManPaperCnt = 0;
                    ManEnvCnt = 0;

                    for ( i = 0; i < MAX_NO_OF_PAPER_TRAYS + 1; i++ )
                        PaperTrayConv[i] = FALSE;

                    /**********************************************************/
                    /* PD00145 : Do not allow form connection to tray 2 if the*/
                    /*           printer does not have three trays or a multi-*/
                    /*           media.                                       */
                    /* PD00354 : Add the pDMSettings->SourceIndex before      */
                    /*           checking the number of paper trays.          */
                    /**********************************************************/
                    if (((pDDT->DDTSourceList + pDMSettings->SourceIndex)->
                          NoOfPaperTrays < 3) &&
                        !(pDDT->DDTSourceFlags & DDT_MULTIMEDIA_TRAY_SUPPORT))
                        PaperTrayConv[2] = TRUE;

                    EnvelTrayConv = FALSE;
                    MultiTrayConv = FALSE;

                    /**************************************************/
                    /* Loop through each form                         */
                    /**************************************************/
                    /* Convert dialog indices (which cover just forms */
                    /* or just envelopes) into combined form+envelope */
                    /* index.                                         */
                    /* For the multi-media tray on Heritage printers, */
                    /* skip this conversion, as both forms and        */
                    /* envelopes are available.                       */
                    /**************************************************/
                    /**********************************************************/
                    /*  INKJET : Don't do this if the form list is a          */
                    /*  combination of both paper and envelope.               */
                    /**********************************************************/
                    if ((pDDT->DDTSourceList+pDMSettings->SourceIndex)->
                                             SourceTrayList->SourceType !=
                        (DDT_PAPER_FORM | DDT_ENVELOPE_FORM))
                    {
                       for ( Form = DMData.Forms;
                             Form;
                             Form = Form->NextForm )
                       {
                           /**********************************************/
                           /* See if its a paper form                    */
                           /**********************************************/
                           if ( Form->FormType == DDT_PAPER_FORM )
                           {
                               /******************************************/
                               /* Check for the paper trays and the      */
                               /* tractor feed.                          */
                               /******************************************/
                               for ( i = 0;
                                     i < MAX_NO_OF_PAPER_TRAYS + 1;
                                     i++ )
                               {
                                   /**********************************************/
                                   /* If tray is Heritage multi-media then skip  */
                                   /* the conversion.                            */
                                   /**********************************************/
                                   if ( (DMData.ConnsInfo.AutoTrayForm[i]
                                                            == PaperCnt) &&
                                        ( !PaperTrayConv[i] ) )
                                   {
                                        DMData.ConnsInfo.AutoTrayForm[i] =
                                                                   FormCnt;
                                        PaperTrayConv[i] = TRUE;
                                   }
                               }

                               if ( ManPaperCnt <
                                         DMData.ConnsInfo.NoOfManualPaper )
                               {
                                   if ( DMData.ConnsInfo.
                                            pManualPaper[ManPaperCnt] ==
                                                                 PaperCnt )
                                   {
                                       DMData.ConnsInfo.
                                           pManualPaper[ManPaperCnt] =
                                                                   FormCnt;
                                       ManPaperCnt++;
                                   }
                               }

                               PaperCnt++;
                           }
                           else
                           {
                               /******************************************/
                               /* It must be an envelope form. Note that */
                               /* the flag is to stop the form number    */
                               /* from being converted twice.            */
                               /******************************************/
                               if ( (DMData.ConnsInfo.AutoTrayForm
                                     [CS_ENVELOPE_TRAY] == EnvelCnt) &&
                                    ( !EnvelTrayConv ) &&
                                    (Form->FormType == DDT_ENVELOPE_FORM) )
                               {
                                   DMData.ConnsInfo.AutoTrayForm
                                              [CS_ENVELOPE_TRAY] = FormCnt;
                                   EnvelTrayConv = TRUE;
                               }
                               /*************************************************/
                               /* PD00354 : Make sure that the printer supports */
                               /*           Multimedia before assigning a form  */
                               /*           to it.                              */
                               /*************************************************/
                               if ( (DMData.ConnsInfo.AutoTrayForm
                                    [CS_MULTIMEDIA] == MultiCnt) &&
                                    ( !MultiTrayConv ) &&
                                    (pDDT->DDTSourceFlags &
                                     DDT_MULTIMEDIA_TRAY_SUPPORT) )
                               {
                                  DMData.ConnsInfo.AutoTrayForm
                                             [CS_MULTIMEDIA] = FormCnt;
                                  MultiTrayConv = TRUE;
                               }

                               /*************************************************/
                               /*  PD00243 - If the machine has the potential of*/
                               /*            multimedia, then treat the manual  */
                               /*            envelope feed as a envelope+ feed  */
                               /*            as far as which forms are available*/
                               /*************************************************/

                               if (pDDT->DDTSourceFlags &
                                    DDT_MULTIMEDIA_TRAY_SUPPORT)
                               {
                                  if ( ManEnvCnt <
                                             DMData.ConnsInfo.NoOfManualEnv )
                                  {
                                      if (DMData.ConnsInfo.
                                             pManualEnvelope[ManEnvCnt]
                                                               == MultiCnt )
                                      {
                                          DMData.ConnsInfo.
                                              pManualEnvelope[ManEnvCnt] =
                                                                      FormCnt;
                                          ManEnvCnt++;
                                      }
                                  }
                               }
                               else
                               {
                                  if ( ManEnvCnt <
                                             DMData.ConnsInfo.NoOfManualEnv )
                                  {
                                      if (DMData.ConnsInfo.
                                             pManualEnvelope[ManEnvCnt]
                                                               == EnvelCnt )
                                      {
                                          DMData.ConnsInfo.
                                              pManualEnvelope[ManEnvCnt] =
                                                                      FormCnt;
                                          ManEnvCnt++;
                                      }
                                  }
                               }
                               MultiCnt++;
                               if (Form->FormType == DDT_ENVELOPE_FORM)
                               {
                                  EnvelCnt++;
                               }
                           }

                           FormCnt++;
                       }
                    }
                    else
                    {
                       /*******************************************************/
                       /*  INKJET : We must make sure paper tray 2 connects   */
                       /*  extra added paper forms.                           */
                       /*******************************************************/
                       PaperCnt = 0;
                       FormCnt = 0;

                       for (Form = DMData.Forms;
                            Form;
                            Form = Form->NextForm )
                       {
                          if ( Form->FormType == DDT_PAPER_FORM )
                          {
                             if (DMData.ConnsInfo.AutoTrayForm[CS_PAPER_TRAY_2]
                                                                   == PaperCnt )
                             {
                                DMData.ConnsInfo.AutoTrayForm[CS_PAPER_TRAY_2]
                                                                     = FormCnt;
                             }

                             /*************************************************/
                             /*  PD00750:Convert indices of manual paper and  */
                             /*  manual envelopes on the 4072.                */
                             /*************************************************/
                             if ( ManPaperCnt <
                                       DMData.ConnsInfo.NoOfManualPaper )
                             {
                                 if ( DMData.ConnsInfo.
                                          pManualPaper[ManPaperCnt] ==
                                                               PaperCnt )
                                 {
                                     DMData.ConnsInfo.
                                         pManualPaper[ManPaperCnt] =
                                                                 FormCnt;
                                     ManPaperCnt++;
                                 }
                             }

                             PaperCnt++;
                          }
                          else
                          {
                              if ( ManEnvCnt <
                                         DMData.ConnsInfo.NoOfManualEnv )
                              {
                                  if (DMData.ConnsInfo.
                                         pManualEnvelope[ManEnvCnt]
                                                           == EnvelCnt )
                                  {
                                      DMData.ConnsInfo.
                                          pManualEnvelope[ManEnvCnt] =
                                                                  FormCnt;
                                      ManEnvCnt++;
                                  }
                              }

                              if (Form->FormType == DDT_ENVELOPE_FORM)
                              {
                                 EnvelCnt++;
                              }
                          }
                          FormCnt++;
                       }
                    }

                    /**************************************************/
                    /* End the dialog routine.                        */
                    /**************************************************/
                    WinDismissDlg( hwnd, TRUE);
                    break;

                case DID_CANCEL:
                case DB_PSH_CANCEL:
                    /**************************************************/
                    /* Free the buffers containing new connections    */
                    /**************************************************/
                    if ( DMData.TmpConnsInfo.pManualEnvelope )
                     /* SSFREESEG(SELECTOROF(                           */
                     /*         DMData.TmpConnsInfo.pManualEnvelope )); */
                        SSFREEMEM( DMData.TmpConnsInfo.pManualEnvelope );/*CON3201*/

                    if ( DMData.TmpConnsInfo.pManualPaper )
                     /* SSFREESEG(SELECTOROF(                        */
                     /*         DMData.TmpConnsInfo.pManualPaper )); */
                        SSFREEMEM( DMData.TmpConnsInfo.pManualPaper );/*CON3201*/

                    /**************************************************/
                    /* End the dialog routine.                        */
                    /**************************************************/
                    WinDismissDlg( hwnd, TRUE);
                    break;

                default:
                    break;
            }
            /*.. switch (SHORT1FROMMP(lparam1)) ......................*/

            break;

        case WM_INITDLG:
            /**********************************************************/
            /* Turn off 'Close' and 'Task Manager' options on the     */
            /* system menu.                                           */
            /**********************************************************/
/*          prdm_RemoveMenuOptions( hwnd ); */

            /**********************************************************/
            /* We make a copy of the current state which the user can */
            /* then alter by making selections in the list box. This  */
            /* copy of the state only becomes the new state when the  */
            /* enter button is pressed.  The copy of the current      */
            /* state is held in TmpConnsInfo.                         */
            /**********************************************************/

            /**********************************************************/
            /* Make a copy of the manual paper forms list             */
            /**********************************************************/
            if ( DMData.ConnsInfo.pManualPaper )
            {
             /* Result = SSALLOCSEG (                                */
             /*              (2 * DMData.ConnsInfo.NoOfManualPaper), */
             /*              &SELECTOROF(pManualForms),              */
             /*              0 );                                    */
                Result = SafeSSALLOCMEM (                           /*CON3201*/
                             &pManualForms,                         /*CON3201*/
                             (2 * DMData.ConnsInfo.NoOfManualPaper),/*CON3201*/
                             0 );                                   /*CON3201*/

                if ( Result != DOS_OK )
                {
                 /* Ring3LOGDOSERR (TFUNC, "SSALLOCSEG failed", */
                    Ring3LOGDOSERR (TFUNC, "SSALLOCMEM failed", /*CON3201*/
                                                   &Result, 1, Result);
                    return(FNULL);
                }

/*              OFFSETOF(pManualForms) = 0;                          CON3201 */

                prdu_memcpy( (PBYTE)pManualForms,
                             (PBYTE) DMData.ConnsInfo.pManualPaper,
                             (2 * DMData.ConnsInfo.NoOfManualPaper) );

                DMData.TmpConnsInfo.pManualPaper = pManualForms;
            }
            else
            {
                DMData.TmpConnsInfo.pManualPaper = FNULL;
            }

            DMData.TmpConnsInfo.NoOfManualPaper =
                                     DMData.ConnsInfo.NoOfManualPaper;

            /**********************************************************/
            /* Make a copy of the manual envelope forms list          */
            /**********************************************************/
            if ( DMData.ConnsInfo.pManualEnvelope )
            {
             /* Result = SSALLOCSEG (                                 */
             /*                 (2 * DMData.ConnsInfo.NoOfManualEnv), */
             /*                 &SELECTOROF(pManualForms),            */
             /*                 0 );                                  */
                Result = SafeSSALLOCMEM (                            /*CON3201*/
                                &pManualForms,                       /*CON3201*/
                                (2 * DMData.ConnsInfo.NoOfManualEnv),/*CON3201*/
                                0 );                                 /*CON3201*/

                if ( Result != DOS_OK )
                {
                 /* Ring3LOGDOSERR (TFUNC, "SSALLOCSEG failed", */
                    Ring3LOGDOSERR (TFUNC, "SSALLOCMEM failed", /*CON3201*/
                                                   &Result, 1, Result);
                    return(FNULL);
                }

/*              OFFSETOF(pManualForms) = 0;                          CON3201 */

                prdu_memcpy( (PBYTE) pManualForms,
                             (PBYTE) DMData.ConnsInfo.pManualEnvelope,
                             (2 * DMData.ConnsInfo.NoOfManualEnv) );

                DMData.TmpConnsInfo.pManualEnvelope = pManualForms;
            }
            else
            {
                DMData.TmpConnsInfo.pManualEnvelope = FNULL;
            }

            DMData.TmpConnsInfo.NoOfManualEnv =
                                       DMData.ConnsInfo.NoOfManualEnv;

            /**********************************************************/
            /* Copy the other fields                                  */
            /**********************************************************/
            for ( i = 0; i < NO_OF_AUTO_TRAYS; i++ )
                DMData.TmpConnsInfo.AutoTrayForm[i] =
                                      DMData.ConnsInfo.AutoTrayForm[i];

            /**********************************************************/
            /* Convert the form numbers to indices of forms of that   */
            /* type eg 2nd paper form                                 */
            /**********************************************************/
            FormCnt     = 0;
            EnvelCnt    = 0;
            MultiCnt    = 0;
            PaperCnt    = 0;
            ManPaperCnt = 0;
            ManEnvCnt   = 0;

            /**********************************************************/
            /* Loop through each form                                 */
            /* Convert full form indices (which cover forms+envelopes */
            /* together) into form or envelope - specific indices.    */
            /* For the multi-media tray on Heritage printers, skip    */
            /* this conversion, as both forms and envelopes are       */
            /* available.                                             */
            /**********************************************************/
            /**********************************************************/
            /*  INKJET : Don't do this if the form list is a          */
            /*  combination of both paper and envelope.               */
            /**********************************************************/
            if ((pDDT->DDTSourceList+pDMSettings->SourceIndex)->
                                     SourceTrayList->SourceType !=
                (DDT_PAPER_FORM | DDT_ENVELOPE_FORM))
            {
                for ( Form = DMData.Forms; Form; Form = Form->NextForm )
                {
                    /******************************************************/
                    /* If it is a paper form                              */
                    /******************************************************/
                    if ( Form->FormType == DDT_PAPER_FORM )
                    {
                        for ( i = 0; i < MAX_NO_OF_PAPER_TRAYS + 1; i++ )
                        {
                            /**********************************************/
                            /* If tray is Heritage multi-media then skip  */
                            /* the conversion.                            */
                            /**********************************************/
                            if ( DMData.TmpConnsInfo.AutoTrayForm[i] ==
                                                        FormCnt )
                                DMData.TmpConnsInfo.AutoTrayForm[i] =
                                                               PaperCnt;
                        }

                        /**************************************************/
                        /* See if it corresponds to a manual paper form   */
                        /**************************************************/
                        if ( ManPaperCnt <
                                       DMData.TmpConnsInfo.NoOfManualPaper )
                        {
                            if ( DMData.TmpConnsInfo.
                                     pManualPaper[ManPaperCnt] == FormCnt )
                            {
                                DMData.TmpConnsInfo.
                                    pManualPaper[ManPaperCnt] = PaperCnt;

                                ManPaperCnt++;
                            }
                        }

                        PaperCnt++;
                    }
                    else
                    {
                        /**************************************************/
                        /* It must be an envelope form                    */
                        /**************************************************/
                        if ( DMData.TmpConnsInfo.AutoTrayForm
                                             [CS_ENVELOPE_TRAY] == FormCnt)
                            DMData.TmpConnsInfo.AutoTrayForm
                                            [CS_ENVELOPE_TRAY] = EnvelCnt;
                        if ( (pDDT->DDTSourceFlags &
                              DDT_MULTIMEDIA_TRAY_SUPPORT) )
                        {
                           if  (DMData.TmpConnsInfo.AutoTrayForm
                                           [CS_MULTIMEDIA] == FormCnt)
                           {
                              DMData.TmpConnsInfo.AutoTrayForm
                                         [CS_MULTIMEDIA] = MultiCnt;
                           }

                           /*************************************************/
                           /*  PD00243 - If the machine has the potential of*/
                           /*            multimedia, then treat the manual  */
                           /*            envelope feed as a envelope+ feed  */
                           /*            as far as which forms are available*/
                           /*************************************************/

                           if ( ManEnvCnt < DMData.TmpConnsInfo.NoOfManualEnv )
                           {
                               if ( DMData.TmpConnsInfo.
                                        pManualEnvelope[ManEnvCnt] == FormCnt )
                               {
                                   DMData.TmpConnsInfo.
                                       pManualEnvelope[ManEnvCnt] = MultiCnt;


                                   ManEnvCnt++;
                               }
                           }
                        }
                        else
                        {
                           if ( ManEnvCnt < DMData.TmpConnsInfo.NoOfManualEnv )
                           {
                               if ( DMData.TmpConnsInfo.
                                        pManualEnvelope[ManEnvCnt] == FormCnt )
                               {
                                   DMData.TmpConnsInfo.
                                       pManualEnvelope[ManEnvCnt] = EnvelCnt;

                                   ManEnvCnt++;
                               }
                           }

                        }

                        if (Form->FormType == DDT_ENVELOPE_FORM)
                        {
                           EnvelCnt++;
                        }

                        MultiCnt++;
                    }

                    FormCnt++;
                }
            }
            else
            {
               /*******************************************************/
               /*  INKJET : We must make sure paper tray 2 highlights */
               /*  any of the extra added paper forms.                */
               /*******************************************************/
               PaperCnt = 0;
               FormCnt = 0;

               for (Form = DMData.Forms;
                    Form;
                    Form = Form->NextForm )
               {
                  if ( Form->FormType == DDT_PAPER_FORM )
                  {
                     if (DMData.TmpConnsInfo.AutoTrayForm[CS_PAPER_TRAY_2]
                                                                   == FormCnt )
                     {
                        DMData.TmpConnsInfo.AutoTrayForm[CS_PAPER_TRAY_2]
                                                                    = PaperCnt;
                     }

                     /*************************************************/
                     /*  PD00747:Convert indices of manual paper and  */
                     /*  manual envelopes on the 4072.                */
                     /*************************************************/
                     if ( ManPaperCnt <
                               DMData.TmpConnsInfo.NoOfManualPaper )
                     {
                         if ( DMData.TmpConnsInfo.
                                  pManualPaper[ManPaperCnt] ==
                                                       FormCnt )
                         {
                             DMData.TmpConnsInfo.
                                 pManualPaper[ManPaperCnt] =
                                                         PaperCnt;
                             ManPaperCnt++;
                         }
                     }

                     PaperCnt++;
                  }
                  else
                  {
                      if ( ManEnvCnt <
                                 DMData.TmpConnsInfo.NoOfManualEnv )
                      {
                          if (DMData.TmpConnsInfo.
                                 pManualEnvelope[ManEnvCnt]
                                                   == FormCnt )
                          {
                              DMData.TmpConnsInfo.
                                  pManualEnvelope[ManEnvCnt] =
                                                          EnvelCnt;
                              ManEnvCnt++;
                          }
                      }

                      if (Form->FormType == DDT_ENVELOPE_FORM)
                      {
                         EnvelCnt++;
                      }
                  }
                  FormCnt++;
               }
            }


            /**********************************************************/
            /* Pick up a pointer to the tray list for the currently   */
            /* selected source.  This is done as follows:             */
            /* - Get the pointer to the source list for the           */
            /*     current printer                                    */
            /* - Adjust the pointer according to the current          */
            /*     source index                                       */
            /* - Allow for the special case of the dual tray          */
            /*     sources on the Qs                                  */
            /* - Get the pointer to the tray list for the             */
            /*     current source                                     */
            /**********************************************************/
            pSourceInfo  = DDT[pDMSettings->PrinterType]->DDTSourceList;
            pSourceInfo += pDMSettings->SourceIndex;

            /**********************************************************/
            /* Allow for added sources.  On Quiet/Quick printers and  */
            /* 4019Laser this is just the Envelope feed.  On the      */
            /* Heritage this may be Envelope or MultiMedia.  The      */
            /* pSourceInfo is an index into the DVTSourceList tables  */
            /* defined in prdd????.c                                  */
            /**********************************************************/
            if ( pDMSettings->AddedFeed == FD_ENVELOPE )
                pSourceInfo += 1;
            else if (pDMSettings->AddedFeed == FD_MULTIMEDIA)
                pSourceInfo += 2;
            else if (pDMSettings->AddedFeed == FD_100_SHEET)
                pSourceInfo += 3;

            pTrayInfo = pSourceInfo->SourceTrayList;

            /**********************************************************/
            /* Display the list of source trays.                      */
            /**********************************************************/
            for ( i = 0; i < pSourceInfo->NoOfLogicalTrays; i++ )
            {
                WinLoadString( hab,
                               DMData.HModule,
                               (pTrayInfo + i)->ResourceId,
                               SLEN_BOX_MESSAGE,
                               (PSZ)szMessage );

                DlgResult = WinSendDlgItemMsg(
                                        hwnd,
                                        DB_LST_PAPER_SOURCES,
                                        LM_INSERTITEM,
                                        MPFROMSHORT(LIT_END),
                                        MPFROMP(szMessage) );
            }

            /**********************************************************/
            /* Highlight the first source tray in the list.           */
            /* SourceType is set to a value which is neither paper or */
            /* envelope to ensure that the list of forms is           */
            /* initialised.  This works since when the first source   */
            /* tray is selected below this action is trapped as a     */
            /* WM_CONTROL and the form list is initialised then.      */
            /* Until then the Current Source is set to none.          */
            /**********************************************************/
            DMData.SourceType    = 0;
            DMData.CurrentSource = CS_NONE;

            DMData.SingleSelection =
                               ( pTrayInfo->FeedType == DDT_AUTO_FEED );

            DlgResult = WinSendDlgItemMsg( hwnd,
                                           DB_LST_PAPER_SOURCES,
                                           LM_SELECTITEM,
                                           MPFROMSHORT(0),
                                           (MPARAM)(ULONG)TRUE );

            /**********************************************************/
            /* Set the active window                                  */
            /* PD00263 : Remove set active window. Now window always  */
            /* appears in the same place.                             */
            /**********************************************************/
#if 0
//          WinSendMsg( DMData.hwndHelp,
//                      HM_SET_ACTIVE_WINDOW,
//                      hwnd,
//                      hwnd );
#endif

            /**********************************************************/
            /* Set the initial focus                                  */
            /**********************************************************/
         /* DlgResult = WinSetFocus( HWND_DESKTOP, */
            WinSetFocus( HWND_DESKTOP,                     /* CON3201 */
                                     WinWindowFromID(hwnd, DB_PSH_ENTER) );

            break;

        default:
            /**********************************************************/
            /* Pass any other messages to the default handler         */
            /**********************************************************/
            return(WinDefDlgProc( hwnd, msg, lparam1, lparam2 ));
            break;
    }
    /*.. switch (msg) ................................................*/
}
#undef TFUNC


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdm_EnterConnections                                  */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   HWND    hwnd;                                                    */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prdm_EnterConnections( hwnd )

HWND   hwnd;
#endif

USHORT prdm_EnterConnections( HWND hwnd )                  /* CON3201 */

{
#define TFUNC "prdm_EnterConns"

    /******************************************************************/
    /* Local Variables                                                */
    /******************************************************************/
    USHORT   ListIndex;        /* Index of selected item in list box  */
    USHORT   NoOfManualForms;  /* Number of forms in manual source    */
    PUSHORT  pManualForms;     /* Indexes of the manual forms         */
    USHORT   i;                /* Loop variable                       */
    USHORT   Result;           /* Function call return values         */

    /******************************************************************/
    /* Get index of first selected form in the list box.              */
    /******************************************************************/
    ListIndex = SHORT1FROMMR( WinSendDlgItemMsg( hwnd,
                                                 DB_LST_AVAILABLE_FORMS,
                                                 LM_QUERYSELECTION,
                                                  MPFROMSHORT(LIT_FIRST),
                                                 FNULL ) );

    /******************************************************************/
    /* Switch according to which source we are setting up - the       */
    /* handling is different for automatic and manual sources.        */
    /******************************************************************/
    switch ( DMData.CurrentSource )
    {
        case CS_PAPER_TRAY_1:
        case CS_PAPER_TRAY_2:
        case CS_PAPER_TRAY_3:
        case CS_TRACTOR_FEED:
        case CS_ENVELOPE_TRAY:
            DMData.TmpConnsInfo.AutoTrayForm[DMData.CurrentSource] =
                                                              ListIndex;
            return(TRUE);
            break;

        case CS_MANUAL_PAPER:
        case CS_MANUAL_ENVELOPE:
            /**********************************************************/
            /* Loop through and find out how many forms are           */
            /* associated with this manual source.                    */
            /**********************************************************/
            NoOfManualForms = 0;

            while ( ListIndex != (USHORT)LIT_NONE )
            {
                NoOfManualForms++;

                ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                               hwnd,
                                               DB_LST_AVAILABLE_FORMS,
                                               LM_QUERYSELECTION,
                                               MPFROMSHORT(ListIndex),
                                               FNULL ) );
            }

            /**********************************************************/
            /* Allocate memory for the list of manual forms.          */
            /**********************************************************/
            if ( NoOfManualForms != 0 )
            {
             /* Result = SSALLOCSEG ( (2 * NoOfManualForms),     */
             /*                       &SELECTOROF(pManualForms), */
             /*                       0 );                       */
                Result = SafeSSALLOCMEM ( &pManualForms,     /*CON3201*/
                                      (2 * NoOfManualForms), /*CON3201*/
                                      0 );                   /*CON3201*/

                if ( Result != DOS_OK )
                {
                 /* Ring3LOGDOSERR (TFUNC, "SSALLOCSEG failed", */
                    Ring3LOGDOSERR (TFUNC, "SSALLOCMEM failed", /*CON3201*/
                                                   &Result, 1, Result);
                    return(FALSE);
                }

/*              OFFSETOF(pManualForms) = 0;                           CON3201 */

                /******************************************************/
                /* Retrieve the indexes of the manual forms and       */
                /* themin the memory just acquired.                   */
                /******************************************************/
                ListIndex = LIT_NONE;

                for ( i = 0; i < NoOfManualForms; i++ )
                {
                    ListIndex = SHORT1FROMMR( WinSendDlgItemMsg(
                                                 hwnd,
                                                 DB_LST_AVAILABLE_FORMS,
                                                 LM_QUERYSELECTION,
                                                 MPFROMSHORT(ListIndex),
                                                 FNULL ) );
                    pManualForms[i] = ListIndex;
                }
            }
            else
            {
                /******************************************************/
                /* No forms are associated with this source.          */
                /******************************************************/
                pManualForms = FNULL;
            }

            /**********************************************************/
            /* Update the DMData data structure                       */
            /**********************************************************/
            if ( DMData.CurrentSource == CS_MANUAL_PAPER )
            {
                /******************************************************/
                /* Replace the previous list of manual paper forms.   */
                /******************************************************/
                if ( DMData.TmpConnsInfo.pManualPaper )
                 /* SSFREESEG(SELECTOROF(                               */
                 /*                DMData.TmpConnsInfo.pManualPaper )); */
                    SSFREEMEM( DMData.TmpConnsInfo.pManualPaper ); /*CON3201*/

                DMData.TmpConnsInfo.NoOfManualPaper = NoOfManualForms;
                DMData.TmpConnsInfo.pManualPaper    = pManualForms;
            }
            else
            {
                /******************************************************/
                /* Replace the previous list of manual envelope       */
                /* forms.                                             */
                /******************************************************/
                if ( DMData.TmpConnsInfo.pManualEnvelope )
                 /* SSFREESEG(SELECTOROF(                                */
                 /*              DMData.TmpConnsInfo.pManualEnvelope )); */
                    SSFREEMEM( DMData.TmpConnsInfo.pManualEnvelope );/*CON3201*/

                DMData.TmpConnsInfo.NoOfManualEnv   = NoOfManualForms;
                DMData.TmpConnsInfo.pManualEnvelope = pManualForms;
            }

            return(TRUE);
            break;

        case CS_NONE:
            /**********************************************************/
            /* Nothing to do - this only happens when the dialog box  */
            /* is being initialised.                                  */
            /**********************************************************/
            return(TRUE);
            break;

    }
    /* ..... switch ( DMData.CurrentSource )......................... */
}
#undef TFUNC

