/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDLGETO
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdl_GetLineOrigin
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define INCL_32                   /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef  INCL_32                   /* CON3201 */

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdltypt.h>
#include <prdlextf.h>


/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prdl_GetLineOrigin                                     */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*                                                                    */
/*   hanDC          DcH;                                              */
/*   PPOINTL        CurrPos;                                          */
/*   lpDCI          DCIData;                                          */
/*   ULONG          FunN;                                             */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function returns the current style state taken from the DC  */
/*   Instance data and also returns the current world coordinates     */
/*   from the DC Instance data in CurrPos.                            */
/*   The high byte of the style state is the current style error      */
/*   value and the low byte is the style mask.                        */
/*                                                                    */
/**********************************************************************/
ULONG EXPENTRY prdl_GetLineOrigin ( hanDC     DcH,
                                    PPOINTL   CurrPos,
                                    lpDCI     DCIData,
                                    ULONG     FunN)

{
#define TFUNC "prdl_GetLineOrigin"
    ULONG      ReturnedStyle;

    prdm_EnterDriver(DCIData);
    TRACE8(TFUNC, "FunN", &(FunN), 1);
    TRACE8(TFUNC, "DcH", &(DcH), 1);
    TRACE8(TFUNC, "CurrPos", &CurrPos, 1);
    TRACE8(TFUNC, "DCIData address", &DCIData, 1);

    /******************************************************************/
    /* Set up CurrPos and return the Style Number                     */
    /* if the style high word is non zero, indicating the first pel   */
    /* is drawn, retuen 1 in DX, otherwise return DX = 0              */
    /******************************************************************/
    (*CurrPos).x = DCIData->DCICurrPosWcs.X;
    (*CurrPos).y = DCIData->DCICurrPosWcs.Y;

    ReturnedStyle = DCIData->StyleNumber;

    if (ReturnedStyle & 0xffff0000L)
        ReturnedStyle |= 0x00010000L;

    prdm_LeaveDriver(DCIData);
    return (ReturnedStyle & 0x0001ffffL);

} /* prdl_GetLineOrigin */
#undef TFUNC


