/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDLGETC
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prdl_GetCurrentPosition
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                   /* CON3201 */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_DDIMISC
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDICOMFLAGS
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDICOMFLAGS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                    /* CON3201 */

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdltypt.h>
#include <prdlextf.h>
#include <prdyextf.h>

#define COMBITS(A) ((PUSHORT)(&A))[1]

/**********************************************************************/
/*   FUNCTION: prdl_GetCurrentPosition                                */
/*   PARAMETERS:                                                      */
/*   See "OS/2 Technical Reference: I/O Subsytems and Device Drivers" */
/*   hanDC         DcH;                                               */
/*   WcsPoint     *ArgNewXY;                                          */
/*   lpDCI         DCIData;                                           */
/*   ULONG         FunN;                                              */
/*   DESCRIPTION:                                                     */
/*   Returns the current position, from DC Instance data, in world    */
/*   coordinates.                                                     */
/**********************************************************************/
ULONG prdl_GetCurrentPosition ( hanDC      DcH,
                                WcsPoint  *ArgNewXY,
                                lpDCI      DCIData,
                                ULONG      FunN)

{
#define TFUNC "prdl_GetCurrPos"

#ifdef PRD_TIMING
    DEKHOOK0(A,8,0B)
#endif

    prdm_EnterDriver(DCIData);

    /******************************************************************/
    /* Trace the parameters.                                          */
    /******************************************************************/
    TRACE8(TFUNC, "FunN", &(FunN), 1);
    TRACE8(TFUNC, "DcH", &(DcH), 1);
    TRACE8(TFUNC, "ArgNewXY", ArgNewXY, 1);
    TRACE8(TFUNC, "DCIData", &DCIData, 1);
    TRACE4(TFUNC, "ArgNewXY", (ArgNewXY), 2);

    /******************************************************************/
    /* Get current position into NewXY (in world coordinates)         */
    /******************************************************************/
/******************************************************************************/
/* CON3201 - COM_TRANSFORM is a ULONG now with the command bits in the high   */
/*           2 bytes so we do not need to do the COMBITS                      */
/******************************************************************************/
/*  if (!(COMBITS(FunN) & COM_TRANSFORM))                                     */
    if (!(FunN & COM_TRANSFORM))
    {
        /**************************************************************/
        /* Transform is reset so return device coords                 */
        /**************************************************************/
        ArgNewXY->X = (LONG)DCIData->DCICurrPosDev.X;
        ArgNewXY->Y = (LONG)DCIData->DCICurrPosDev.Y;
    }
    else
    {
        *(ArgNewXY) = DCIData->DCICurrPosWcs;
    }

    /******************************************************************/
    /* Trace the values recovered                                     */
    /******************************************************************/
    TRACE4(TFUNC, "NewXY", (ArgNewXY), 2);
    TRACE4(TFUNC, "Returned OK", NULL, 0);

    prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,8,8B)
#endif
    return(OK);
}
#undef TFUNC

