/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Lexmark Corporation, 1989                                   */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDERSET
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prde_ResetDC
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define ENCON_INCL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIMISC
#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_GRE_DEVSUPPORT
#include <pmddi.h>
#undef INCL_DDIMISC
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_GRE_DEVSUPPORT

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconse.h>
#include <prddcone.h>
#include <prdecone.h>

#define NO_SYS
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS

#include <prdmtypt.h>

#include <prdeextf.h>
#include <prdgextf.h>
#include <prdcextf.h>
#include <prdnextf.h>
#include <prdncone.h>

/**********************************************************************/
/* Set up access to default text attributes.                          */
/**********************************************************************/
extern DCHARBUNDLE      prda_DefTxtAts;


/******************************************************************************/
/*                                                                            */
/*   File           = PRDERSET                                                */
/*                                                                            */
/*   Function       = prde_ResetDC                                            */
/*                                                                            */
/*   Reference      = Winthorn Functional Specification                       */
/*                    Device Driver Interface Specification                   */
/*                    Printer Device Driver Design                            */
/*                                                                            */
/*                                                                            */
/******************************************************************************/


/**********************************************************************/
/* Set up access to default text attributes.                          */
/**********************************************************************/
extern DCHARBUNDLE      prda_DefTxtAts;

/**********************************************************************/
/*                                                                    */
/*   FUNCTION: prde_ResetDC                                           */
/*                                                                    */
/*   PARAMETERS:                                                      */
/*                                                                    */
/*   lpDCI   DCIData;    Pointer to DC Instance data                  */
/*   ULONG   Options;    Unused parameter                             */
/*                                                                    */
/*   DESCRIPTION:                                                     */
/*                                                                    */
/*   This function deletes (and frees) all the items referenced by    */
/*   pointers from the DC Instance data and then uses                 */
/*   prde_GetAttrsSizeMemory and prde_SetDCIDefaults to set default   */
/*   values.                                                          */
/*                                                                    */
/*   CHANGES:                                                         */
/*                                                                    */
/*   This routine should not require changes to cope with additional  */
/*   fields in the DC Instance data as long as the functions it calls */
/*   have been adapted to allow for these.                            */
/*                                                                    */
/*   Slightly altered for new framework.                              */
/*                                                                    */
/**********************************************************************/
#if 0
USHORT pascal prde_ResetDC (DCIData, Options)

lpDCI   DCIData;
ULONG   Options;
#endif

USHORT prde_ResetDC ( lpDCI   DCIData,                     /* CON3201 */
                      ULONG   Options )                    /* CON3201 */

{
#define TFUNC "prde_ResetDC"

    /******************************************************************/
    /* Do entry processing                                            */
    /******************************************************************/
#ifdef PRD_TIMING
    DEKHOOK0(A,7,4C)
#endif
    prdm_EnterDriver(DCIData);

#ifdef DEBUG_FSM
    OutputString("Enter ResetDC");
#endif

    TRACE4(TFUNC, "Entry", FNULL, 0);
    TRACE8(TFUNC, "Options", &Options, 1);

    /******************************************************************/
    /* First free all heap items 'hanging off' the DC Instance data   */
    /* structure.                                                     */
    /******************************************************************/
    TRACE4(TFUNC, "Free DC Items", FNULL, 0);
    (void) prde_FreeDCItems (DCIData);

    /******************************************************************/
    /* Now allocate space for the default attributes ie the fixed     */
    /* size items.                                                    */
    /******************************************************************/
    TRACE4(TFUNC, "Get Attributes Mem", FNULL, 0);
    (void)prde_GetAttrsMemory (DCIData);

    /******************************************************************/
    /* Now allocate space for the clip rectangles and font tables ie  */
    /* the variable size items.                                       */
    /******************************************************************/
    TRACE4(TFUNC, "Get Variable Mem", FNULL, 0);
    (void)prde_GetVarSizeMemory (DCIData);

    /******************************************************************/
    /* Initialise the DC Instance data to defaults; FALSE indicates   */
    /* that this is not the start of a document/picture, and that     */
    /* only attributes, color tables etc.  should be set.             */
    /******************************************************************/
    TRACE4(TFUNC, "Init DC Defaults", FNULL, 0);

    /******************************************************************/
    /* reset the DC info. Changed for new framework.                  */
    /******************************************************************/
    (void)prdn_SetResetDCDCIDefaults( DCIData );

    prdm_LeaveDriver(DCIData);
#ifdef PRD_TIMING
    DEKHOOK0(A,7,CC)
#endif
    return (OK);

}
#undef TFUNC

