/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDDATA
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver data
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES              /* Convert to C/SET2    CON3201       */
#define INCL_GREALL
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES               /* Convert to C/SET2    CON3201       */
#undef INCL_GREALL
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdacone.h>
#include <prdconse.h>
#include <prdlcone.h>
#include <prdtcone.h>

#define NO_SYS
#define INCL_HELP
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef NO_SYS
#undef INCL_HELP

/******************************************************************************/
/*  HeapHandle and HeapSelector together identify the global Device Driver    */
/*  Heap, used for non-DC (ie global) Heap items.                             */
/******************************************************************************/
/* CON3201 ************************************************************/
/*HHEAP           HeapHandle;    Replace HHEAP with pbGlobalHeap      */
/*unsigned        HeapSelector;                                       */
/**********************************************************************/
PBYTE pbGlobalHeap;     /* Global Heap */

/******************************************************************************/
/*  The increment for huge segments - this is constant for a given release.   */
/******************************************************************************/
/* CON3201 ******************/
/*USHORT prdd_HugeInc;      */
/****************************/

/******************************************************************************/
/*  Module handle for use in WinLoadString.  Filled in at initialization by   */
/*  loadproc.                                                                 */
/******************************************************************************/
HMODULE prdd_ModHandle;

/******************************************************************************/
/*  prd_DDState records the global state of the Device Driver.  It must be    */
/*  initialised to Reset state so that the first call to Enable Fill          */
/*  lDeviceBlock subfunction performs required initialisation.                */
/******************************************************************************/
enum DDState    prd_DDState = prd_Reset;

/******************************************************************************/
/*  DC counter: initialized to zero and incremented each time a dc is opened, */
/*  decremented each time a dc is close.  when it is decremented to zero, the */
/*  process is terminating and the exitlist termination function is taken off */
/*  the list.                                                                 */
/******************************************************************************/
USHORT DCCounter = 0;

/******************************************************************************/
/*  1024 bytes set to zero.  Used when an AbortDoc is issued.  If the printer */
/*  is in graphics mode when the abort doc occured it will be expecting more  */
/*  graphics and not implement a form feed, initialisation and may print data */
/*  incorrectly at the start of the next file.  The maximum amount of graphics*/
/*  data that can be send is 64k, so this buffer needs sending 64 times to    */
/*  ensure sucess.                                                            */
/******************************************************************************/
ULONG prdd_Zeroes[] =
    { 0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,

      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,

      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,

      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,
      0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L };

/******************************************************************************/
/*  This is allocated area in the data segment for our local copy of the      */
/*  engine's dispatch table.  Each function that we support has an entry in   */
/*  this table.                                                               */
/******************************************************************************/
PFNL  da_ErasePS;
PFNL  da_GetDCOrigin;
PFNL  da_Convert;
PFNL  da_ConvertWithMatrix;
PFNL  da_NotifyTransformChange;
PFNL  da_AccumulateBounds;
PFNL  da_PolyLine;
PFNL  da_DrawLinesInPath;
PFNL  da_PolyShortLine;
PFNL  da_GetCurrentPosition;
PFNL  da_SetCurrentPosition;
PFNL  da_PolyScanLine;
PFNL  da_DeviceCreateBitmap;
PFNL  da_DeviceDeleteBitmap;
PFNL  da_DeviceSelectBitmap;
PFNL  da_GetPel;
PFNL  da_SetPel;
PFNL  da_ImageData;
PFNL  da_BitBlt;
PFNL  da_GetBitmapBits;
PFNL  da_SetBitmapBits;
PFNL  da_CharStringPos;
PFNL  da_QueryTextBox;
PFNL  da_QueryWidthTable;
PFNL  da_QueryCharPositions;
PFNL  da_CharString;
PFNL  da_GetKerningPairTable;
PFNL  da_DeviceSetAttributes;
PFNL  da_DeviceGetAttributes;
PFNL  da_DeviceSetGlobalAttribute;
PFNL  da_NotifyClipChange;
PFNL  da_RealizeFont;
PFNL  da_DeviceQueryFontAttributes;
PFNL  da_DeviceQueryFonts;
PFNL  da_GetCodePage;
PFNL  da_SetCodePage;
PFNL  da_QueryColorData;
PFNL  da_QueryLogColorTable;
PFNL  da_CreateLogColorTable;
PFNL  da_RealizeColorTable;
PFNL  da_UnrealizeColorTable;
PFNL  da_QueryRealColors;
PFNL  da_QueryNearestColor;
PFNL  da_QueryColorIndex;
PFNL  da_QueryRGBColor;
PFNL  da_QueryDeviceBitmaps;
PFNL  da_QueryDeviceCaps;
PFNL  da_Escape;
PFNL  da_QueryHardcopyCaps;
PFNL  da_QueryDevResource;
PFNL  da_PolyMarker;
PFNL  da_ResetBounds;
PFNL  da_GetBoundsData;
PFNL  da_GetStyleRatio;
PFNL  da_SetStyleRatio;
PFNL  da_DrawBorder;
PFNL  da_SetDCOrigin;
PFNL  da_GetLineOrigin;
PFNL  da_SetLineOrigin;
PFNL  da_LockDevice;
PFNL  da_UnLockDevice;

/******************************************************************************/
/* PD00769 : Added following line                                             */
/******************************************************************************/
PFNL  da_FillPath;

/******************************************************************************/
/*  Default marker set                                                        */
/******************************************************************************/
#define OFFSET_START    sizeof(FOCAFONT) + 48
#define OFFSET_INC      8

MarkerFontType MarkerDefaultFont [] =
{
    { 0, 20, "",                       /* FONTSIGNATURE                       */
      1, 168, "", "", 0,               /* FOCAMETRICS                         */
      0, 0, 0, 0, 0,
      0, 0, 0, 0,
      7,                               /* xAveCharWidth                       */
      7,                               /* xMaxCharInc - Used for Mode2 markers*/
      7,                               /* xEmInc                              */
      0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0,
                                       /* FONTDEFINITIONHEADER                */
      2,                               /* ulIdentity;                         */
      28,                              /* ulSize;                             */
      0x3,                             /* fsFontdef;                          */
      0x80,                            /* fsChardef;                          */
      4,                               /* usCellSize;                         */
      8,                               /* xCellWidth;                         */
      8,                               /* yCellHeight;                        */
      0, 0, 0, 0,                      /* xCellIncrement, A, B, C             */
      8,                               /* pCellBaseOffset;                    */
      OFFSET_START,
      OFFSET_START +  1 * OFFSET_INC,
      OFFSET_START +  2 * OFFSET_INC,
      OFFSET_START +  3 * OFFSET_INC,
      OFFSET_START +  4 * OFFSET_INC,
      OFFSET_START +  5 * OFFSET_INC,
      OFFSET_START +  6 * OFFSET_INC,
      OFFSET_START +  7 * OFFSET_INC,
      OFFSET_START +  8 * OFFSET_INC,
      OFFSET_START +  9 * OFFSET_INC,
      OFFSET_START + 10 * OFFSET_INC,
      OFFSET_START + 11 * OFFSET_INC,
      0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, /* cross (dflt)         */
      0x00, 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, /* cross                */
      0x00, 0x10, 0x10, 0x10, 0xFE, 0x10, 0x10, 0x10, /* plus                 */
      0x00, 0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10, /* diamond              */
      0x00, 0xFE, 0x82, 0x82, 0x82, 0x82, 0x82, 0xFE, /* square               */
      0x00, 0x44, 0x28, 0x10, 0xFE, 0x10, 0x28, 0x44, /* 6-point star         */
      0x00, 0x10, 0x7C, 0x6C, 0xC6, 0x6C, 0x7C, 0x10, /* 8-point star         */
      0x00, 0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x10, /* filled diamond       */
      0x00, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, /* filled square        */
      0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, /* dot                  */
      0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, /* small circle         */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  /* blank (sym 64)       */
    }
};


/******************************************************************************/
/*  Default Attribute bundles                                                 */
/******************************************************************************/

/******************************************************************************/
/*  Text bundle of attributes                                                 */
/******************************************************************************/
DCHARBUNDLE prda_DefTxtAts = {
       76,                             /* attribute count (bytes)    70,52    */
       16,                             /* definition count (bytes)    8       */
       DEFAULT_FOREGROUND_COL,         /* foreground colour                   */
       DEFAULT_BACKGROUND_COL,         /* background colour                   */
       DEFAULT_FOREGROUND_MIX,         /* mix                                 */
       DEFAULT_BACKGROUND_MIX,         /* background mix                      */
       0,                              /* set                                 */
       0x1,                            /* precision mode - 1                  */
       {0x0L,0x0L},                    /* cell width, height                  */
       {0x1L,0x0L},                    /* Angle                               */
       {0x0L,0x1L},                    /* Shear                               */
       0x1,                            /* Direction - left to right           */
       0x0101,                         /* Text Align    CON3201  normal       */
       0L,                             /* fxExtra       CON3201               */
       0L,                             /* fxBreakExtra  CON3201               */
       FNULL,                          /* pointer to current set              */
       0L,                             /* flags                               */
       0L,                             /* codepage                            */
       0L                              /* spacing                             */
   };

/******************************************************************************/
/*  Line bundle of attributes                                                 */
/******************************************************************************/
DLINEBUNDLE     prda_DefLinAts = {
       28,                            /* attribute count (bytes)   26        */
       4,                             /* definition count (bytes)   4        */
        DEFAULT_FOREGROUND_COL,        /* foreground color                    */
        DEFAULT_BACKGROUND_COL,        /* background color                    */
        DEFAULT_FOREGROUND_MIX,        /* foreground mix                      */
        DEFAULT_BACKGROUND_MIX,        /* background mix                      */
        0x00010000L,                   /* width - normal                      */
        0xFFFFFFFFL,                   /* geometric width - cosmetic          */
        0x7,                           /* type - solid                        */
        0x1,                           /* end - flat                          */
        0x1,                           /* joint - bevel                       */
        0,                             /* reserved CON3201                    */
        0L                             /* def type                            */
   };

/******************************************************************************/
/*  Marker bundle of attributes                                               */
/******************************************************************************/
DMARKERBUNDLE prda_DefMrkAts = {
       24,                            /* attribute count (bytes)    24       */
       12,                            /* definition count (bytes)    8       */
       DEFAULT_FOREGROUND_COL,         /* foreground colour                   */
       DEFAULT_BACKGROUND_COL,         /* background colour                   */
       DEFAULT_FOREGROUND_MIX,         /* mix                                 */
       DEFAULT_BACKGROUND_MIX,         /* background mix                      */
       0,                              /* set                                 */
       0,                              /* symbol (cross)                      */
       0x00080000,                     /* box x dimension                     */
       0x00080000,                     /* box y dimension                     */
       FNULL,                          /* pointer to current set              */
       0,                             /* flags                               */
       0                              /* codepage                            */
   };

/******************************************************************************/
/*  Pattern bundle of attributes                                              */
/******************************************************************************/
DAREABUNDLE     prda_DefPtnAts = {
       24,                             /* attribute count (bytes)     24      */
       12,                             /* definition count (bytes)     8      */
        DEFAULT_FOREGROUND_COL,        /* foreground color                    */
        DEFAULT_BACKGROUND_COL,        /* background color                    */
        DEFAULT_FOREGROUND_MIX,        /* foreground mix                      */
        DEFAULT_BACKGROUND_MIX,        /* background mix                      */
        0x00,                          /* set - BASE?                         */
        0x10,                          /* symbol - solid shading              */
        {0x0L,0x0L},
       FNULL,                          /* pointer to current set              */
       0,                             /* flags                               */
       0                              /* codepage                            */

   };

/******************************************************************************/
/*  Image bundle of attributes                                                */
/******************************************************************************/
DIMAGEBUNDLE  prda_DefImgAts = {
       12,                             /* attribute count (bytes)       12    */
       0,                              /* definition count (bytes)       0    */
        DEFAULT_FOREGROUND_COL,        /* foreground color                    */
        DEFAULT_BACKGROUND_COL,        /* background color                    */
        DEFAULT_FOREGROUND_MIX,        /* foreground mix                      */
        DEFAULT_BACKGROUND_MIX         /* background mix                      */
   };


/******************************************************************************/
/*  The Default Color Table contains the RGB values of the default logical    */
/*  color table.                                                              */
/******************************************************************************/
DefaultColorTableType DefaultColorTable =
                     { 0x00FFFFFF,     /* Background                          */
                       0x000000FF,     /* Blue                                */
                       0x00FF0000,     /* Red                                 */
                       0x00FF00FF,     /* Pink                                */
                       0x0000FF00,     /* Green                               */
                       0x0000FFFF,     /* Cyan                                */
                       0x00FFFF00,     /* Yellow                              */
                       0x00000000,     /* Neutral                             */
                       0x00404040,     /* Dark gray                           */
                       0x00000080,     /* Dark blue                           */
                       0x00800000,     /* Dark red                            */
                       0x00800080,     /* Dark pink                           */
                       0x00008000,     /* Dark green                          */
                       0x00008080,     /* Dark cyan                           */
                       0x00808000,     /* Brown                               */
                       0x00808080 };   /* Light gray                          */

/******************************************************************************/
/*  The Line Type Table defines the line types used by OutputLine function    */
/*  handlers.                                                                 */
/******************************************************************************/
USHORT LineTypeTable [NUMBER_LINETYPES] =
                   { 0x0000,           /* default                             */
                     0xCCCC,           /* dotted                              */
                     0xF0F0,           /* short dashed                        */
                     0xFF18,           /* dash dot                            */
                     0xCC00,           /* double dot                          */
                     0xFFF0,           /* long dash                           */
                     0xFCCC,           /* dash, double dot                    */
                     0xFFFF,           /* solid                               */
                     0x0000,           /* invisible                           */
                     0xAAAA };         /* dotted (alternate pel)              */


/******************************************************************************/
/*  _acrtused is required in a Dynamic Link Library to nullify automatic      */
/*  loading of C runtime support.  It must be initialised to 1 or 0.  See OS/2*/
/*  programming Guide Chapter 6.                                              */
/******************************************************************************/
SHORT           __acrtused = 1;

/******************************************************************************/
/*  Semaphores.  If any entries are added to this table then the value of     */
/*  RAM_SEMAPHORE_TABLE_SIZE declared in PRDCONSE.H must be changed.  The     */
/*  first 4 entries in the table are always used as is the last one Those in  */
/*  the middle are only used when using semaphores for each port address, so  */
/*  sometimes the last one is actually the 5th one                            */
/******************************************************************************/
/* CON3201 ********************************************************************/
/* Renamed RAMSemaphoreTable to MutexSemTable.  We will have to initialize the*/
/* the table in a routine and cannot be initialized at definintion as         */
/* previously done.                                                           */
/* The table will be initialized during the execution of OS2_PM_DRV_ENABLE    */
/*                                                                            */
/******************************************************************************/

HMTX                MutexSemTable[MUTEX_SEMAPHORE_TABLE_SIZE];
/* CON3201 ********************************************************************/
/* The following 5 semaphores will be initialized in PRDINIT.C                */
/******************************************************************************/
HMTX    hmtxCreateHeapSem;
HMTX    hmtxGlobalHeapSem;
HMTX    hmtxJournalNameSem;  /* CON3201 - This variable is not referenced */
HMTX    hmtxBMLockSem;
HMTX    hmtxDeviceModeSem;

#if 0
/* CON3201 -- Start of if'd out code */
FSRSEM RAMSemaphoreTable[RAM_SEMAPHORE_TABLE_SIZE] =
    { sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,           /* LPT1 PORT          */
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,           /* LPT9 PORT          */
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,           /* COM1 PORT          */
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L,           /* COM9 PORT          */
      sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L            /* LAST Semaphore     */


};

PFSRSEM    lpCreateHeapSem    = (PFSRSEM) &RAMSemaphoreTable[0];
PFSRSEM    lpGlobalHeapSem    = (PFSRSEM) &RAMSemaphoreTable[1];
PFSRSEM    lpJournalNameSem   = (PFSRSEM) &RAMSemaphoreTable[2];
PFSRSEM    pBMLockSem         = (PFSRSEM) &RAMSemaphoreTable[3];
PFSRSEM    lpDeviceModeSem    = (PFSRSEM)
                               &RAMSemaphoreTable[RAM_SEMAPHORE_TABLE_SIZE - 1];
/* CON3201 -- End of if'd out code */
#endif

#ifdef PRD_TRACE
#if (PRD_TRACE != 0)

FSRSEM        TraceFileSem = { sizeof(FSRSEM), 0, 0, 0, 0, 0, -1L, 0L};
PFSRSEM       lpTraceFileSem = (PFSRSEM) &TraceFileSem;

BOOL          prdz_On = TRUE;

#endif
#endif

/******************************************************************************/
/*  Pointer to the printer data structure.  This is originally NULL is added  */
/*  to in FillPhysicalDeviceBlock every time a new printer added              */
/******************************************************************************/
lpPrtDataEntry  PrinterStateData = FNULL;

/******************************************************************************/
/*  Pointer to the global card data structure.  It is originally NULL but is  */
/*  added to in FillPhysicalDeviceBlock every time a new card is added.       */
/******************************************************************************/
lpGlobalCard GlobalCardData = FNULL;

/******************************************************************************/
/*  Device semaphores table.  If additional devices are added to this table   */
/*  then the definition of NO_OF_PRINTER_DEVICES in PRDCONSE.h must be        */
/*  updated.  PD00636                                                         */
/******************************************************************************/
/* CON3201 ********************************************************************/
/* First create the DeviceSemTable with the names of the ports and a null     */
/* semaphore.  We will later initialize the semaphores with the function      */
/* prde_InitSemaphores                                                        */
/******************************************************************************/
DeviceSemTableEntry DevSemTable[] =
    { "LPT1",                          /* Device name                         */
      (HMTX)0,                         /* Control semaphore                   */
      "LPT2",
      (HMTX)0,
      "LPT3",
      (HMTX)0,
      "LPT4",
      (HMTX)0,
      "LPT5",
      (HMTX)0,
      "LPT6",
      (HMTX)0,
      "LPT7",
      (HMTX)0,
      "LPT8",
      (HMTX)0,
      "LPT9",
      (HMTX)0,
      "COM1",
      (HMTX)0,
      "COM2",
      (HMTX)0,
      "COM3",
      (HMTX)0,
      "COM4",
      (HMTX)0,
      "COM5",
      (HMTX)0,
      "COM6",
      (HMTX)0,
      "COM7",
      (HMTX)0,
      "COM8",
      (HMTX)0,
      "COM9",
      (HMTX)0,
      }; /* entry for a File Write           */

DeviceSemTable lpDevSemTable = (DeviceSemTableEntry *) DevSemTable;
#if 0
/* CON3201 -- Start if'd out code */
DeviceSemTableEntry DevSemTable[] =
    { "LPT1",                          /* Device name                         */
      (PFSRSEM) &RAMSemaphoreTable[4], /* Control semaphore                   */
      "LPT2",
      (PFSRSEM) &RAMSemaphoreTable[5],
      "LPT3",
      (PFSRSEM) &RAMSemaphoreTable[6],
      "LPT4",
      (PFSRSEM) &RAMSemaphoreTable[7],
      "LPT5",
      (PFSRSEM) &RAMSemaphoreTable[8],
      "LPT6",
      (PFSRSEM) &RAMSemaphoreTable[9],
      "LPT7",
      (PFSRSEM) &RAMSemaphoreTable[10],
      "LPT8",
      (PFSRSEM) &RAMSemaphoreTable[11],
      "LPT9",
      (PFSRSEM) &RAMSemaphoreTable[12],
      "COM1",
      (PFSRSEM) &RAMSemaphoreTable[13],
      "COM2",
      (PFSRSEM) &RAMSemaphoreTable[14],
      "COM3",
      (PFSRSEM) &RAMSemaphoreTable[15],
      "COM4",
      (PFSRSEM) &RAMSemaphoreTable[16],
      "COM5",
      (PFSRSEM) &RAMSemaphoreTable[17],
      "COM6",
      (PFSRSEM) &RAMSemaphoreTable[18],
      "COM7",
      (PFSRSEM) &RAMSemaphoreTable[19],
      "COM8",
      (PFSRSEM) &RAMSemaphoreTable[20],
      "COM9",
      (PFSRSEM) &RAMSemaphoreTable[21]

      }; /* entry for a File Write           */
#endif /* CON3201 -- end of if'd out code */

/* CON3201 Moved to PRDINIT.C where the table is actually created */
/* DeviceSemTable lpDevSemTable = (DeviceSemTableEntry far *) DevSemTable; */




//DeviceSemTableEntry DevSemQueuedDCTable =
//    { FNULL,
//      (PFSRSEM) &RAMSemaphoreTable[23] };

/******************************************************************************/
/*  String definitions for the spool file formats                             */
/******************************************************************************/
CHAR szIBMQSTD[] = "PM_Q_STD";
CHAR szIBMQESC[] = "PM_Q_ESC";
CHAR szIBMQRAW[] = "PM_Q_RAW";

/******************************************************************************/
/*  Strings for NLS enabled face name/quality.  Filled in by FillPdb.         */
/******************************************************************************/
CHAR szBoldString[] = "bbbbbbbbbbbbbbbbbbbbbbbbbbb";
CHAR szDWideString[] = "wwwwwwwwwwwwwwwwwwwwwwwwwww";
CHAR szDHighString[] = "hhhhhhhhhhhhhhhhhhhhhhhhhhh";

CHAR szQualityString1[] =  "q1qq2qq1qqqqqqqqqqqqqqqqqqq";
CHAR szQualityString2[] =  "q2qq2qq2qqqqqqqqqqqqqqqqqqq";
CHAR szQualityString3[] =  "q3qq3qq3qqqqqqqqqqqqqqqqqqq";
CHAR szQualityString2a[] = "q2qq2qq2qqqqqqqqqqqqqqqqqqq";

/******************************************************************************/
/*  Process ID of the process which loaded the driver                         */
/******************************************************************************/
/* USHORT  LoadingProcId;                                             CON3201 */
ULONG   LoadingProcId;
USHORT  GlobalHeapSegCount = 0;
/* CON3201 *****************************/
/*HHEAP   GlobalHeapArray [10];        */
/*USHORT  GlobalSelectorArray [10];    */
/***************************************/

PBYTE GlobalHeapArray [10]; /* CON3201 */

/******************************************************************************/
/*  The version of PM currently running.  This is initialised in Fill Logical */
/*  Device Block.                                                             */
/*                                                                            */
/*  PMVersion == 1 -> PM version 1.1                                          */
/*  PMVersion == 2 -> PM version 1.2                                          */
/******************************************************************************/
/* USHORT PMVersion; CON3201 -  No longer needed */
/* USHORT OS2Version; CON3201 - No longer needed */

/******************************************************************************/
/*  prdz_Trace...  variables are used by the Trace module, or by Trace calls  */
/*  spread through the code.  They should not be used by non-Trace code.      */
/******************************************************************************/

#ifdef PRD_TRACE
#if (PRD_TRACE != 0)

USHORT          prdz_TraceFile = NULL;
USHORT          prdz_TraceLvl  = 8;

typedef union
    {
        ULONG   dw;
        USHORT  wd[2];
    } Zlong;

Zlong   eddz_TraceLong = {0L};

#endif
#endif

/******************************************************************************/
/*  Escape sequences for recognition by the raw data parser for formfeed      */
/*  handling.                                                                 */
/******************************************************************************/
struct EscapeSequence EscapeStrings[] =
    {
        { "-",prdg_ActConstIgnore, 1},
        { "0",prdg_ActNull,0},
        { "1",prdg_ActNull,0},
        { "2",prdg_ActNull,0},
        { "3",prdg_ActConstIgnore, 1},
        { "4",prdg_ActNull,0},
        { "5",prdg_ActConstIgnore, 1},
        { "6",prdg_ActNull,0},
        { "7",prdg_ActNull,0},
        { ":",prdg_ActNull,0},
        { "=",prdg_ActNull,0},
        { "A",prdg_ActConstIgnore, 1},
        { "B",prdg_ActDelimited, '\0'},
        { "C\0",prdg_ActConstIgnore, 1},
        { "D",prdg_ActDelimited, '\0'},
        { "E",prdg_ActNull,0},
        { "F",prdg_ActNull,0},
        { "G",prdg_ActNull,0},
        { "H",prdg_ActNull,0},
        { "I",prdg_ActConstIgnore, 1},
        { "J",prdg_ActConstIgnore, 1},
        { "K",prdg_ActCountIgnore, 0},
        { "L",prdg_ActCountIgnore, 0},
        { "N",prdg_ActConstIgnore, 1},
        { "O",prdg_ActNull,0},
        { "P",prdg_ActConstIgnore, 1},
        { "Q",prdg_ActConstIgnore, 1},
        { "R",prdg_ActNull,0},
        { "S",prdg_ActConstIgnore, 1},
        { "T",prdg_ActNull,0},
        { "U",prdg_ActConstIgnore, 1},
        { "W",prdg_ActConstIgnore, 1},
        { "X",prdg_ActConstIgnore, 2},
        { "Y",prdg_ActCountIgnore, 0},
        { "Z",prdg_ActCountIgnore, 0},
        { "[@",prdg_ActCountIgnore, 0},
        { "[C",prdg_ActCountIgnore, 0},
        { "[F",prdg_ActCountIgnore, 0},
        { "[I",prdg_ActCountIgnore, 0},
        { "[S",prdg_ActCountIgnore, 0},
        { "[T",prdg_ActCountIgnore, 0},
        { "[\\",prdg_ActCountIgnore, 0},
        { "[g",prdg_ActCountIgnore, 0},
        { "\\",prdg_ActCountIgnore, 0},
        { "]",prdg_ActNull,0},
        { "^",prdg_ActNull,0},
        { "_",prdg_ActConstIgnore, 1},
        { "d",prdg_ActConstIgnore, 2},
        { "e",prdg_ActConstIgnore, 2},
        { "j",prdg_ActNull,0},
        { "n",prdg_ActNull,0},
        { "\x6f", prdg_ActFF, 0}
    };

USHORT MaxEscapeStrings = (sizeof(EscapeStrings)/sizeof(struct EscapeSequence));

/******************************************************************************/
/*  Default document name.  Note that this is not displayed but when this is  */
/*  in use the spooler default name is in use.  Since it is not displayed it  */
/*  does need to be in the RC file for NLS translation.                       */
/*                                                                            */
/*  FIX : AK 5/03/91 - this string is displayed on the 1.3 spooler, so set it */
/*  to be null.                                                               */
/******************************************************************************/
CHAR szDefaultString[] = "\0";

/******************************************************************************/
/*  Dummy Dwords to enable tracing of last data items in segment.  This must  */
/*  be at the end of this file, and assumes that this module is the last of   */
/*  the prdd...  files in the link list.                                      */
/******************************************************************************/
#ifdef PRD_TRACE
#if (PRD_TRACE != 0)

ULONG           Dummy1 = 0;
ULONG           Dummy2 = 0;
ULONG           Dummy3 = 0;
ULONG           Dummy4 = 0;

#endif
#endif

/******************************************************************************/
/*  Code Page Use Table - entries contain a code page that can be simulated by*/
/*  the driver followed by the root code pages that can be used to simulate   */
/*  it.  Entry 0 is the default entry.                                        */
/******************************************************************************/
CPTUseTableEntry CPTUseTable [2] =
{
       0,    850, 437,   0
};

/******************************************************************************/
/*  Code Point Mapping Table for code page 437                                */
/*                                                                            */
/*  PD00511 : Change entry 0 from 0 to 32 so that the 42XX printers will      */
/*  print spaces instead of slashed 0's.                                      */
/******************************************************************************/
#define CPT_MAP_SIZE    332

SHORT CPTRoot_Table_437 [CPT_MAP_SIZE] =
{
      32,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,
      16,  17,  18,  19,  20,  21,  22,  23,
      24,  25,  26,  27,  28,  29,  30,  31,
      32,  33,  34,  35,  36,  37,  38,  39,
      40,  41,  42,  43,  44,  45,  46,  47,
      48,  49,  50,  51,  52,  53,  54,  55,
      56,  57,  58,  59,  60,  61,  62,  63,
      64,  65,  66,  67,  68,  69,  70,  71,
      72,  73,  74,  75,  76,  77,  78,  79,
      80,  81,  82,  83,  84,  85,  86,  87,
      88,  89,  90,  91,  92,  93,  94,  95,
      96,  97,  98,  99, 100, 101, 102, 103,
     104, 105, 106, 107, 108, 109, 110, 111,
     112, 113, 114, 115, 116, 117, 118, 119,
     120, 121, 122, 123, 124, 125, 126, 127,
     128, 129, 130, 131, 132, 133, 134, 135,
     136, 137, 138, 139, 140, 141, 142, 143,
     144, 145, 146, 147, 148, 149, 150, 151,
     152, 153, 154,  -1, 156,  -1,  -1, 159,
     160, 161, 162, 163, 164, 165, 166, 167,
     168,  -1, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180,  -1,  -1,  -1,
      -1, 185, 186, 187, 188,  -1,  -1, 191,
     192, 193, 194, 195, 196, 197,  -1,  -1,
     200, 201, 202, 203, 204, 205, 206,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1, 217, 218, 219, 220,  -1,  -1, 223,
      -1, 225,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1, 241, 242, 243,  20,  21, 246,  -1,
     248,  -1, 250,  -1,  -1, 253, 254, 255,
      -1, 169, 181, 182, 183, 184, 189, 190,
     198, 199, 207, 208, 209, 210, 211, 212,
     213, 214, 215, 216, 221, 222, 224, 226,
     227, 228, 229, 231, 232, 233, 234, 235,
     236, 237, 238, 239, 240, 242, 243, 244,
     245, 247, 249, 251, 252,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1

} ;

/******************************************************************************/
/*  Code Point Mapping Table for code page 850                                */
/*                                                                            */
/*  PD00511 : Change entry 0 from 0 to 32 so that the 42XX printers will      */
/*  print spaces instead of slashed 0's.                                      */
/******************************************************************************/
SHORT CPTRoot_Table_850[CPT_MAP_SIZE] =
{
      32,   1,   2,   3,   4,   5,   6,   7,
       8,   9,  10,  11,  12,  13,  14,  15,
      16,  17,  18,  19,  20,  21,  22,  23,
      24,  25,  26,  27,  28,  29,  30,  31,
      32,  33,  34,  35,  36,  37,  38,  39,
      40,  41,  42,  43,  44,  45,  46,  47,
      48,  49,  50,  51,  52,  53,  54,  55,
      56,  57,  58,  59,  60,  61,  62,  63,
      64,  65,  66,  67,  68,  69,  70,  71,
      72,  73,  74,  75,  76,  77,  78,  79,
      80,  81,  82,  83,  84,  85,  86,  87,
      88,  89,  90,  91,  92,  93,  94,  95,
      96,  97,  98,  99, 100, 101, 102, 103,
     104, 105, 106, 107, 108, 109, 110, 111,
     112, 113, 114, 115, 116, 117, 118, 119,
     120, 121, 122, 123, 124, 125, 126, 127,
     128, 129, 130, 131, 132, 133, 134, 135,
     136, 137, 138, 139, 140, 141, 142, 143,
     144, 145, 146, 147, 148, 149, 150, 151,
     152, 153, 154, 155, 156, 157, 158, 159,
     160, 161, 162, 163, 164, 165, 166, 167,
     168, 169, 170, 171, 172, 173, 174, 175,
     176, 177, 178, 179, 180, 181, 182, 183,
     184, 185, 186, 187, 188, 189, 190, 191,
     192, 193, 194, 195, 196, 197, 198, 199,
     200, 201, 202, 203, 204, 205, 206, 207,
     208, 209, 210, 211, 212, 213, 214, 215,
     216, 217, 218, 219, 220, 221, 222, 223,
     224, 225, 226, 227, 228, 229, 230, 231,
     232, 233, 234, 235, 236, 237, 238, 239,
     240, 241, 242, 243, 244, 245, 246, 247,
     248, 249, 250, 251, 252, 253, 254, 255,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
      -1,  -1,  -1,  -1

};

/******************************************************************************/
/*  Code Page Map Table -                                                     */
/******************************************************************************/
#define CPT_ROOT_SIZE_850    332
#define CPT_ROOT_SIZE_437    332

CPTMappingTableEntry CPTMapTable [CPT_MAP_TABLE_SIZE] =
{
      850, CPT_ROOT_SIZE_850, CPTRoot_Table_850,
      437, CPT_ROOT_SIZE_437, CPTRoot_Table_437
};

/******************************************************************************/
/*  Default outline fonts point sizes PD00137                                 */
/******************************************************************************/
PCHAR DfltFontPSzTable[] =
    {
        {"Program"},
        {"06.0"},
        {"08.0"},
        {"09.0"},
        {"10.0"},
        {"12.0"},
        {"14.0"},
        {"16.0"},
        {"18.0"},
        {"20.0"},
        {"24.0"},
        {"30.0"},
        {"36.0"},
        {"48.0"},
        {"60.0"},
        {"72.0"},
        {"96.0"},
        {"\0"}
    };

#include <prdftab.h>
