/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDD42XX
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION  Printer Device Driver DDT Tables
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                  /* CON3201 */
#define INCL_DOSPROCESS          /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS           /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_WINPOINTERS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                    /* CON3201 */

#include <prdbcone.h>
#include <prdconse.h>
#include <prdmcone.h>
#include <prdtcone.h>
#include <prdecone.h>

#define INCL_HELP
#define PRDMTYPE_INCL
#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL
#undef INCL_HELP
#undef PRDMTYPE_INCL

/******************************************************************************/
/*  MUST INCLUDE PRDD42XX.H FIRST SO THAT THE INI VARIABLES OCCUR AT THE SAME */
/*  ADDRESS IN EACH DRIVER : PS 16/01/90                                      */
/******************************************************************************/
#include <prdd42xx.h>

/******************************************************************************/
/*  Include Driver and PrinterType constants.                                 */
/******************************************************************************/
#include <prddcone.h>

/******************************************************************************/
/*  Include Printer Number Constants                                          */
/******************************************************************************/
#include <prdfcone.h>

/******************************************************************************/
/*  Include global tables.                                                    */
/******************************************************************************/
#include <prddtab.c>

/******************************************************************************/
/*  Include Code Page tables and lists                                        */
/******************************************************************************/
#include <prddcpge.c>

/******************************************************************************/
/*  Include Device Mode default settings                                      */
/******************************************************************************/
#include <prddmode.c>

/******************************************************************************/
/*  External references.                                                      */
/******************************************************************************/
extern lpFontListType       DVTFontListProI [];
extern lpFontListType       DVTFontListProXL [];
extern lpFontListType       DVTFontListProII [];
extern lpFontListType       DVTFontListProIII [];
extern lpFontListType       DVTFontListProX24 [];
extern lpFontListType       DVTFontListProX24E [];
extern lpFontListType       DVTFontList4224 [];
extern lpFontListType       DVTFontList9Wire [];
extern lpFontListType       DVTFontList9WireNLS [];
extern lpFontListType       DVTFontList24Wire [];
extern lpFontListType       DVTFontList24WireNLS [];
extern lpFontListType       DVTFontList4226 [];

/******************************************************************************/
/*  PD00447 : moved defined forms here to reduce data segment requirements.   */
/******************************************************************************/
DVTFormsType  DVTDefinedFormsWide [] =
    {
        { DDT_PAPER_FORM, 1, IDS_FORM_0,
          "I 8*50 11*00 0*00 8*50 0*00 11*00                   " },
        { DDT_PAPER_FORM, 2, IDS_FORM_1,
          "I 8*50 14*00 0*00 8*50 0*00 14*00                   " },
        { DDT_PAPER_FORM, 3, IDS_FORM_2,
          "M 182*0 257*0 0*0 182*0 0*0 257*0                   " },
        { DDT_PAPER_FORM, 4, IDS_FORM_3,
          "M 210*0 297*0 0*0 210*0 0*0 297*0                   " },
        { DDT_PAPER_FORM, 5, IDS_FORM_4,
          "I 7*25 10*50 0*00 7*25 0*00 10*50                   " },
        { DDT_PAPER_FORM, 6, IDS_FORM_5,
          "M 148*0 210*0 0*0 148*0 0*0 210*0                   " },
        { DDT_PAPER_FORM, 7, IDS_FORM_6,
          "I 8*00 12*00 0*00 8*00 0*00 12*00                   " },
        { DDT_ENVELOPE_FORM, 1, IDS_FORM_7,
          "I 7*50 3*87 0*00 7*50 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 2, IDS_FORM_8,
          "I 8*87 3*87 0*00 8*87 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 3, IDS_FORM_9,
          "I 9*50 4*12 0*00 9*50 0*00 4*12                     " },
        { DDT_ENVELOPE_FORM, 4, IDS_FORM_10,
          "M 220*0 110*0 0*0 220*0 0*0 110*0                   " },
        { DDT_ENVELOPE_FORM, 5, IDS_FORM_11,
          "M 229*0 162*0 0*0 229*0 0*0 162*0                   " },
        { DDT_ENVELOPE_FORM, 6, IDS_FORM_12,
          "M 250*0 176*0 0*0 250*0 0*0 176*0                   " }
    };

DVTFormsType  DVTDefinedFormsWide2 [] =
    {
        { DDT_PAPER_FORM, 1, IDS_FORM_0,
          "I 8*50 11*00 0*00 8*50 0*00 11*00                   " },
        { DDT_PAPER_FORM, 2, IDS_FORM_1,
          "I 8*50 14*00 0*00 8*50 0*00 14*00                   " },
        { DDT_PAPER_FORM, 3, IDS_FORM_2,
          "M 182*0 257*0 0*0 182*0 0*0 257*0                   " },
        { DDT_PAPER_FORM, 4, IDS_FORM_3,
          "M 210*0 297*0 0*0 210*0 0*0 297*0                   " },
        { DDT_PAPER_FORM, 5, IDS_FORM_4,
          "I 7*25 10*50 0*00 7*25 0*00 10*50                   " },
        { DDT_PAPER_FORM, 6, IDS_FORM_5,
          "M 148*0 210*0 0*0 148*0 0*0 210*0                   " },
        { DDT_PAPER_FORM, 7, IDS_FORM_6,
          "I 8*00 12*00 0*00 8*00 0*00 12*00                   " },
        { DDT_PAPER_FORM, 8, IDS_FORM_13,
          "I 14*87 11*00 0*00 13*60 0*00 11*00                 " },
        { DDT_PAPER_FORM, 9, IDS_FORM_14,
          "I 11*00 8*50 0*00 11*00 0*00 8*50                   " },
        { DDT_PAPER_FORM, 10, IDS_FORM_15,
          "M 297*0 210*0 0*0 297*0 0*0 210*0                   " },
        { DDT_ENVELOPE_FORM, 1, IDS_FORM_7,
          "I 7*50 3*87 0*00 7*50 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 2, IDS_FORM_8,
          "I 8*87 3*87 0*00 8*87 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 3, IDS_FORM_9,
          "I 9*50 4*12 0*00 9*50 0*00 4*12                     " },
        { DDT_ENVELOPE_FORM, 4, IDS_FORM_10,
          "M 220*0 110*0 0*0 220*0 0*0 110*0                   " },
        { DDT_ENVELOPE_FORM, 5, IDS_FORM_11,
          "M 229*0 162*0 0*0 229*0 0*0 162*0                   " },
        { DDT_ENVELOPE_FORM, 6, IDS_FORM_12,
          "M 250*0 176*0 0*0 250*0 0*0 176*0                   " }
    };


DVTFormsType  DVTDefinedFormsWide3 [] =
    {
        { DDT_PAPER_FORM, 1, IDS_FORM_0,
          "I 8*50 11*00 0*25 8*25 0*00 11*00                   " },
        { DDT_PAPER_FORM, 2, IDS_FORM_1,
          "I 8*50 14*00 0*25 8*25 0*00 14*00                   " },
        { DDT_PAPER_FORM, 3, IDS_FORM_2,
          "M 182*0 257*0 10*0 172*0 0*0 257*0                  " },
        { DDT_PAPER_FORM, 4, IDS_FORM_3,
          "M 210*0 297*0 3*4 206*6 0*0 297*0                   " },
        { DDT_PAPER_FORM, 5, IDS_FORM_4,
          "I 7*25 10*50 0*25 7*00 0*00 10*50                   " },
        { DDT_PAPER_FORM, 6, IDS_FORM_5,
          "M 148*0 210*0 3*4 144*6 0*0 210*0                   " },
        { DDT_PAPER_FORM, 7, IDS_FORM_6,
          "I 8*00 12*00 0*25 7*75 0*00 12*00                   " },
        { DDT_PAPER_FORM, 8, IDS_FORM_13,
          "I 14*87 11*00 0*25 13*85 0*00 11*00                 " },
        { DDT_PAPER_FORM, 9, IDS_FORM_14,
          "I 11*00 8*50 0*25 10*75 0*00 8*50                   " },
        { DDT_PAPER_FORM, 10, IDS_FORM_15,
          "M 297*0 210*0 3*4 293*6 0*0 210*0                   " },
        { DDT_PAPER_FORM, 11, IDS_FORM_16,
          "M 257*0 364*0 10*0 247*0 0*0 364*0                  " },
        { DDT_ENVELOPE_FORM, 1, IDS_FORM_7,
          "I 7*50 3*87 0*25 7*25 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 2, IDS_FORM_8,
          "I 8*87 3*87 0*25 8*62 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 3, IDS_FORM_9,
          "I 9*50 4*12 0*25 9*25 0*00 4*12                     " },
        { DDT_ENVELOPE_FORM, 4, IDS_FORM_10,
          "M 220*0 110*0 6*4 213*6 0*0 110*0                   " },
        { DDT_ENVELOPE_FORM, 5, IDS_FORM_11,
          "M 229*0 162*0 6*4 222*6 0*0 162*0                   " },
        { DDT_ENVELOPE_FORM, 6, IDS_FORM_12,
          "M 250*0 176*0 6*4 243*6 0*0 176*0                   " }
    };

DVTFormsType  DVTDefinedFormsNarrow [] =
    {
        { DDT_PAPER_FORM, 1, IDS_FORM_0,
          "I 8*50 11*00 0*00 8*00 0*00 11*00                   " },
        { DDT_PAPER_FORM, 2, IDS_FORM_1,
          "I 8*50 14*00 0*00 8*00 0*00 14*00                   " },
        { DDT_PAPER_FORM, 3, IDS_FORM_2,
          "M 182*0 257*0 0*0 182*0 0*0 257*0                   " },
        { DDT_PAPER_FORM, 4, IDS_FORM_3,
          "M 210*0 297*0 0*0 203*2 0*0 297*0                   " },
        { DDT_PAPER_FORM, 5, IDS_FORM_4,
          "I 7*25 10*50 0*00 7*25 0*00 10*50                   " },
        { DDT_PAPER_FORM, 6, IDS_FORM_5,
          "M 148*0 210*0 0*0 148*0 0*0 210*0                   " },
        { DDT_PAPER_FORM, 7, IDS_FORM_6,
          "I 8*00 12*00 0*00 8*00 0*00 12*00                   " },
        { DDT_ENVELOPE_FORM, 1, IDS_FORM_7,
          "I 7*50 3*87 0*00 7*50 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 2, IDS_FORM_8,
          "I 8*87 3*87 0*00 8*00 0*00 3*87                     " },
        { DDT_ENVELOPE_FORM, 3, IDS_FORM_9,
          "I 9*50 4*12 0*00 8*00 0*00 4*12                     " },
        { DDT_ENVELOPE_FORM, 4, IDS_FORM_10,
          "M 220*0 110*0 0*0 203*2 0*0 110*0                   " },
        { DDT_ENVELOPE_FORM, 5, IDS_FORM_11,
          "M 229*0 162*0 0*0 203*2 0*0 162*0                   " },
        { DDT_ENVELOPE_FORM, 6, IDS_FORM_12,
          "M 250*0 176*0 0*0 203*2 0*0 176*0                   " }
    };

/******************************************************************************/
/*  Define global variables that are driver-specific, and initialise them.    */
/******************************************************************************/
USHORT  DEFAULT_PRINTER          = IBM_PRO_PRINTER_II;
USHORT  NO_OF_PRINTERS           = NO_OF_42XX;
USHORT  DRIVER_TYPE              = DDT_IBM42XX_DRV;
PCHAR   INITIAL_METRICS_FILENAME = (PCHAR)"IBM42XX.PMF";
PCHAR   DriverNameString         = (PCHAR)"DDK42XX"; /* Copy DriverName here  */
PCHAR   InternalDriverName       = (PCHAR)"DDK42XX"; /* Constant              */

/******************************************************************************/
/*  The following patterns are in the default set.  The pattern width and     */
/*  height and the actual patterns to use depend on the resolution - an index */
/*  into the pattern table is held in the raster data entry for the particular*/
/*  resolution.                                                               */
/*                                                                            */
/*  Note:  Bytes within DWORDs in the following patterns are reversed!  For   */
/*  example, DWORD 1 has bytes 1, 2, 3 and 4 in that order.  When the pattern */
/*  code produces a pattern with this pattern, the bytes within the DWORD are */
/*  printed in 4, 3, 2 and 1 order instead!                                   */
/*                                                                            */
/*  PD00447 : Moved patterns into individual driver modules to reduce size of */
/*  drivers where possible.  Altered low-res patterns to avoid vertical and/or*/
/*  horizontal white lines - this to eliminate failures in engine line        */
/*  simulations for lines in paths which employ PolyScanlines and the default */
/*  patterns.  Also activated the low res patterns for < 150 x 150            */
/*  resolutions.                                                              */
/******************************************************************************/
ULONG      Pattern01Res00 [] =         /* Dense 1                             */
              { 0x55555555, 0xffffffff, 0x77777777, 0xffffffff,
                0x55555555, 0xffffffff, 0xdddddddd, 0xffffffff,
                0x55555555, 0xffffffff, 0x77777777, 0xffffffff,
                0x55555555, 0xffffffff, 0xdddddddd, 0xffffffff,
                0x55555555, 0xffffffff, 0x77777777, 0xffffffff,
                0x55555555, 0xffffffff, 0xdddddddd, 0xffffffff,
                0x55555555, 0xffffffff, 0x77777777, 0xffffffff,
                0x55555555, 0xffffffff, 0xdddddddd, 0xffffffff };

ULONG      Pattern02Res00 [] =         /* Dense 2                             */
              { 0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff,
                0x55555555, 0xffffffff, 0x55555555, 0xffffffff };

ULONG      Pattern03Res00 [] =         /* Dense 3                             */
              { 0x55555555, 0xfefefefe, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xfefefefe, 0x55555555, 0xafafafaf,
                0x55555555, 0xfefefefe, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xfefefefe, 0x55555555, 0xafafafaf,
                0x55555555, 0xfefefefe, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xfefefefe, 0x55555555, 0xafafafaf,
                0x55555555, 0xfefefefe, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xfefefefe, 0x55555555, 0xafafafaf };

ULONG      Pattern04Res00 [] =         /* Dense 4                             */
              { 0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb,
                0x55555555, 0xeeeeeeee, 0x55555555, 0xbbbbbbbb };

ULONG      Pattern05Res00 [] =         /* Dense 5                             */
              { 0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb,
                0x44444444, 0xeeeeeeee, 0x11111111, 0xbbbbbbbb };

ULONG      Pattern06Res00 [] =         /* Dense 6                             */
              { 0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999,
                0x44444444, 0x66666666, 0x11111111, 0x99999999 };

ULONG      Pattern07Res00 [] =         /* Dense 7                             */
              { 0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999,
                0x00000000, 0x66666666, 0x00000000, 0x99999999 };

ULONG      Pattern08Res00 [] =         /* Dense 8                             */
              { 0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111,
                0x00000000, 0x44444444, 0x00000000, 0x11111111 };

ULONG      Pattern09Res00 [] =         /* Vertical lines                      */
              { 0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808 };

ULONG      Pattern0ARes00 [] =         /* Horizontal lines                    */
              { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000 };

ULONG      Pattern0BRes00 [] =         /* Diagonal 1                          */
              { 0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101 };

ULONG      Pattern0CRes00 [] =         /* Diagonal 2                          */
              { 0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606 };

ULONG      Pattern0DRes00 [] =         /* Diagonal 3                          */
              { 0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080 };

ULONG      Pattern0ERes00 [] =         /* Diagonal 4                          */
              { 0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060 };

ULONG      Pattern0FRes00 [] =         /* White                               */
              { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000 };

ULONG      Pattern10Res00 [] =         /* Black                               */
              { 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
                0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff };

PBYTE   PatternTabRes00 [] =
              { (PBYTE)Pattern01Res00,
                (PBYTE)Pattern02Res00,
                (PBYTE)Pattern03Res00,
                (PBYTE)Pattern04Res00,
                (PBYTE)Pattern05Res00,
                (PBYTE)Pattern06Res00,
                (PBYTE)Pattern07Res00,
                (PBYTE)Pattern08Res00,
                (PBYTE)Pattern09Res00,
                (PBYTE)Pattern0ARes00,
                (PBYTE)Pattern0BRes00,
                (PBYTE)Pattern0CRes00,
                (PBYTE)Pattern0DRes00,
                (PBYTE)Pattern0ERes00,
                (PBYTE)Pattern0FRes00,
                (PBYTE)Pattern10Res00,
              };

ULONG      Pattern01Res01 [] =         /* Dense 1 - ok                        */
              { 0xffffffff, 0x3e3e3e3e, 0x7e7e7e7e, 0xffffffff,
                0xffffffff, 0xe3e3e3e3, 0xe7e7e7e7, 0xffffffff,
                0xffffffff, 0x3e3e3e3e, 0x7e7e7e7e, 0xffffffff,
                0xffffffff, 0xe3e3e3e3, 0xe7e7e7e7, 0xffffffff,
                0xffffffff, 0x3e3e3e3e, 0x7e7e7e7e, 0xffffffff,
                0xffffffff, 0xe3e3e3e3, 0xe7e7e7e7, 0xffffffff,
                0xffffffff, 0x3e3e3e3e, 0x7e7e7e7e, 0xffffffff,
                0xffffffff, 0xe3e3e3e3, 0xe7e7e7e7, 0xffffffff };

ULONG      Pattern02Res01 [] =         /* Dense 2 - ok                        */
              { 0x7e7e7e7e, 0x3c3c3c3c, 0x7e7e7e7e, 0xffffffff,
                0xe7e7e7e7, 0xc3c3c3c3, 0xe7e7e7e7, 0xffffffff,
                0x7e7e7e7e, 0x3c3c3c3c, 0x7e7e7e7e, 0xffffffff,
                0xe7e7e7e7, 0xc3c3c3c3, 0xe7e7e7e7, 0xffffffff,
                0x7e7e7e7e, 0x3c3c3c3c, 0x7e7e7e7e, 0xffffffff,
                0xe7e7e7e7, 0xc3c3c3c3, 0xe7e7e7e7, 0xffffffff,
                0x7e7e7e7e, 0x3c3c3c3c, 0x7e7e7e7e, 0xffffffff,
                0xe7e7e7e7, 0xc3c3c3c3, 0xe7e7e7e7, 0xffffffff };

ULONG      Pattern03Res01 [] =         /* Dense 3 - ok                        */
              { 0x3e3e3e3e, 0x3c3c3c3c, 0x3e3e3e3e, 0xbfbfbfbf,
                0xe3e3e3e3, 0xc3c3c3c3, 0xe3e3e3e3, 0xfbfbfbfb,
                0x3e3e3e3e, 0x3c3c3c3c, 0x3e3e3e3e, 0xbfbfbfbf,
                0xe3e3e3e3, 0xc3c3c3c3, 0xe3e3e3e3, 0xfbfbfbfb,
                0x3e3e3e3e, 0x3c3c3c3c, 0x3e3e3e3e, 0xbfbfbfbf,
                0xe3e3e3e3, 0xc3c3c3c3, 0xe3e3e3e3, 0xfbfbfbfb,
                0x3e3e3e3e, 0x3c3c3c3c, 0x3e3e3e3e, 0xbfbfbfbf,
                0xe3e3e3e3, 0xc3c3c3c3, 0xe3e3e3e3, 0xfbfbfbfb };

ULONG      Pattern04Res01 [] =         /* Dense 4 - ok                        */
              { 0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c, 0x3e3e3e3e,
                0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3, 0xe3e3e3e3,
                0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c, 0x3e3e3e3e,
                0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3, 0xe3e3e3e3,
                0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c, 0x3e3e3e3e,
                0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3, 0xe3e3e3e3,
                0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c, 0x3e3e3e3e,
                0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3, 0xe3e3e3e3 };

ULONG      Pattern05Res01 [] =         /* Dense 5 - ok                        */
              { 0x38383838, 0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c,
                0x83838383, 0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3,
                0x38383838, 0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c,
                0x83838383, 0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3,
                0x38383838, 0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c,
                0x83838383, 0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3,
                0x38383838, 0x3c3c3c3c, 0x3c3c3c3c, 0x3c3c3c3c,
                0x83838383, 0xc3c3c3c3, 0xc3c3c3c3, 0xc3c3c3c3 };

ULONG      Pattern06Res01 [] =         /* Dense 6 - ok                        */
              { 0x18181818, 0x3c3c3c3c, 0x3c3c3c3c, 0x10101010,
                0x81818181, 0xc3c3c3c3, 0xc3c3c3c3, 0x01010101,
                0x18181818, 0x3c3c3c3c, 0x3c3c3c3c, 0x10101010,
                0x81818181, 0xc3c3c3c3, 0xc3c3c3c3, 0x01010101,
                0x18181818, 0x3c3c3c3c, 0x3c3c3c3c, 0x10101010,
                0x81818181, 0xc3c3c3c3, 0xc3c3c3c3, 0x01010101,
                0x18181818, 0x3c3c3c3c, 0x3c3c3c3c, 0x10101010,
                0x81818181, 0xc3c3c3c3, 0xc3c3c3c3, 0x01010101 };

ULONG      Pattern07Res01 [] =         /* Dense 7 - ok                        */
              { 0x10101010, 0x38383838, 0x30303030, 0x00000000,
                0x01010101, 0x83838383, 0x03030303, 0x00000000,
                0x10101010, 0x38383838, 0x30303030, 0x00000000,
                0x01010101, 0x83838383, 0x03030303, 0x00000000,
                0x10101010, 0x38383838, 0x30303030, 0x00000000,
                0x01010101, 0x83838383, 0x03030303, 0x00000000,
                0x10101010, 0x38383838, 0x30303030, 0x00000000,
                0x01010101, 0x83838383, 0x03030303, 0x00000000 };

ULONG      Pattern08Res01 [] =         /* Dense 8 - ok                        */
              { 0x00000000, 0x20202020, 0x00000000, 0x00000000,
                0x00000000, 0x02020202, 0x00000000, 0x00000000,
                0x00000000, 0x20202020, 0x00000000, 0x00000000,
                0x00000000, 0x02020202, 0x00000000, 0x00000000,
                0x00000000, 0x20202020, 0x00000000, 0x00000000,
                0x00000000, 0x02020202, 0x00000000, 0x00000000,
                0x00000000, 0x20202020, 0x00000000, 0x00000000,
                0x00000000, 0x02020202, 0x00000000, 0x00000000 };

ULONG      Pattern09Res01 [] =         /* Vertical lines - ok                 */
              { 0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808,
                0x08080808, 0x08080808, 0x08080808, 0x08080808 };

ULONG      Pattern0ARes01 [] =         /* Horizontal lines - ok               */
              { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000 };

ULONG      Pattern0BRes01 [] =         /* Diagonal 1 - ok                     */
              { 0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101,
                0x80808080, 0x40404040, 0x20202020, 0x10101010,
                0x08080808, 0x04040404, 0x02020202, 0x01010101 };

ULONG      Pattern0CRes01 [] =         /* Diagonal 2 - ok                     */
              { 0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606,
                0x81818181, 0x60606060, 0x18181818, 0x06060606 };

ULONG      Pattern0DRes01 [] =         /* Diagonal 3 - ok                     */
              { 0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080,
                0x01010101, 0x02020202, 0x04040404, 0x08080808,
                0x10101010, 0x20202020, 0x40404040, 0x80808080 };

ULONG      Pattern0ERes01 [] =         /* Diagonal 4 - ok                     */
              { 0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060,
                0x81818181, 0x06060606, 0x18181818, 0x60606060 };

ULONG      Pattern0FRes01 [] =         /* White - ok                          */
              { 0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000 };

ULONG      Pattern10Res01 [] =         /* Black - ok                          */
              { 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF };

PBYTE   PatternTabRes01 [] =
              { (PBYTE)Pattern01Res01,
                (PBYTE)Pattern02Res01,
                (PBYTE)Pattern03Res01,
                (PBYTE)Pattern04Res01,
                (PBYTE)Pattern05Res01,
                (PBYTE)Pattern06Res01,
                (PBYTE)Pattern07Res01,
                (PBYTE)Pattern08Res01,
                (PBYTE)Pattern09Res01,
                (PBYTE)Pattern0ARes01,
                (PBYTE)Pattern0BRes01,
                (PBYTE)Pattern0CRes01,
                (PBYTE)Pattern0DRes01,
                (PBYTE)Pattern0ERes01,
                (PBYTE)Pattern0FRes01,
                (PBYTE)Pattern10Res01,
              };

PatternInfoType   PatternInfoTable[2] =
    {

        /**********************************************************************/
        /*  This table is in the following format:                            */
        /*                                                                    */
        /*  - Pointer to pattern table array - index to get individual pattern*/
        /*  - Width of pattern in pels (bits)                                 */
        /*  - Height of pattern in lines (scan lines)                         */
        /*  - Number of bytes per line (scan line)                            */
        /*    Note that this value is the offset in memory to the nth byte    */
        /*    which is the beginning of the next scan line.                   */
        /**********************************************************************/
        {PatternTabRes00, 32, 32, 4},  /* New high res patterns for  75 x  75 */
        {PatternTabRes01, 32, 32, 4}   /* New high res patterns for 300 x 300 */
    };

/******************************************************************************/
/*  DVT Raster Modes                                                          */
/*                                                                            */
/*  PD00447 : Changed pattern selection to altered low and high res patterns. */
/******************************************************************************/
DVTRasterModeType  DVTRasterModeProI [] =
    {
        {  60,  72,  8,  8, 24, 24, 1, 216, 12, 0, 255, 0, 0, "  60 x   72" },
        { 120,  72,  8,  8, 24, 24, 1, 216, 12, 0, 255, 0, 0,  "120 x   72" },
        { 240,  72,  8,  8, 24, 24, 1, 216, 12, 0, 255, 1, 1,  "240 x   72" }
    };


/******************************************************************************/
/*  PD00578 : Add a new table for the 4224s.                                  */
/******************************************************************************/
DVTRasterModeType  DVTRasterMode4224 [] =
    {
        {  60,  72,  8,  8, 24, 24, 2, 216, 12, 0, 255, 0, 0, "  60 x   72" },
        { 120,  72,  8,  8, 24, 24, 2, 216, 12, 0, 255, 0, 0,  "120 x   72" },
        { 240,  72,  8,  8, 24, 24, 2, 216, 12, 0, 255, 1, 1,  "240 x   72" }
    };
/******************************************************************************/
/*  PD00333: New table for 9 wire N/T's which support esc d, allowing a       */
/*  smaller value for rough horizontal right moves.                           */
/******************************************************************************/
DVTRasterModeType  DVTRasterMode2380 [] =
    {
        {  60,  72,  8,  8, 24, 2, 1, 216, 12, 0, 255, 0, 0, "  60 x   72" },
        { 120,  72,  8,  8, 24, 2, 1, 216, 12, 0, 255, 0, 0,  "120 x   72" },
        { 240,  72,  8,  8, 24, 2, 1, 216, 12, 0, 255, 1, 1,  "240 x   72" }
    };

/******************************************************************************/
/*  PD00229 : Changed fifth column below to 36, for number of pels moved in a */
/*  rough move left command.  (ie, 360 pels/in divided by 10 cpi = 36 pels per*/
/*  each backspace character)                                                 */
/*                                                                            */
/*  PD00484 : Changed 7th col below to 3 as finest movement that works is     */
/*  ESC d                                                                     */
/******************************************************************************/
DVTRasterModeType  DVTRasterModeProX24 [] =
    {
        {  60,  72,  8, 24, 36, 3, 3, 216, 12, 0, 255, 0, 0, "  60 x   72" },
        { 120,  72,  8, 24, 36, 3, 3, 216, 12, 0, 255, 0, 0,  "120 x   72" },
        { 180, 180, 24, 24, 36, 3, 3, 180, 12, 0, 255, 1, 1,  "180 x 180" },
        { 360, 180, 24, 24, 36, 3, 3, 180, 12, 0, 255, 1, 1,  "360 x 180" }
    };

/******************************************************************************/
/*  PD00484 : Need to have separate raster table for 2390 because of fine     */
/*  moves right.                                                              */
/*                                                                            */
/*  PD00587 : Add 360x360 resolution for 239X's.                              */
/******************************************************************************/
DVTRasterModeType  DVTRasterMode2390 [] =
    {
        {  60,  72,  8, 24, 36, 3, 3, 216, 12, 0, 255, 0, 0, "  60 x   72" },
        { 120,  72,  8, 24, 36, 3, 3, 216, 12, 0, 255, 0, 0,  "120 x   72" },
        { 180, 180, 24, 24, 36, 3, 3, 180, 12, 0, 255, 1, 1,  "180 x 180" },
        { 360, 180, 24, 24, 36, 3, 3, 180, 12, 0, 255, 1, 1,  "360 x 180" },
        { 360, 360, 24, 24, 36, 3, 3, 360, 12, 0, 255, 1, 1,  "360 x 360" }
    };

/******************************************************************************/
/*  DVT Source Tray configuration arrays                                      */
/*                                                                            */
/*  The options used in flags are (with the default first):                   */
/*  - Automatic or Manual feed                                                */
/*  - Paper or Envelope forms                                                 */
/*  - Sheet or Tractor feed (only used for paper sources)                     */
/*                                                                            */
/*  The default source tray is the first one.  The ordering of the trays      */
/*  matches the CS_ constants declared in PRDMCONE.H.  Note that manual trays */
/*  always come in pairs; both paper and envelope.                            */
/******************************************************************************/
DVTSourceTrayType  DVTSourceTrayPro [] =
    {
        {   IDS_TRACTOR_FEED,
              CS_TRACTOR_FEED,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_TRACTOR_FEED },
        {   IDS_MANUAL_PAPER,
              CS_MANUAL_PAPER,
              DDT_PAPER_FORM,     DDT_MANUAL_FEED,  DDT_DUMMY_VALUE },
        {   IDS_MANUAL_ENVELOPE,
              CS_MANUAL_ENVELOPE,
              DDT_ENVELOPE_FORM,  DDT_MANUAL_FEED,  DDT_DUMMY_VALUE }
    };

/******************************************************************************/
/*  PD00221 : 4226 just has a pinwheel feed.                                  */
/******************************************************************************/
DVTSourceTrayType  DVTSourceTray4226 [] =
    {
        {   IDS_PINWHEEL_FEED,
              CS_TRACTOR_FEED,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_TRACTOR_FEED },
    };

DVTSourceTrayType  DVTSourceTray4224F1 [] =
    {
        {   IDS_CONTINUOUS_FORMS,
              CS_TRACTOR_FEED,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_TRACTOR_FEED }
    };

DVTSourceTrayType  DVTSourceTray4224F2 [] =
    {
        {   IDS_DOC_ON_DEMAND,
              CS_TRACTOR_FEED,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_TRACTOR_FEED }
    };

/******************************************************************************/
/*  PD00307 : Remove manual envelope source.                                  */
/******************************************************************************/
DVTSourceTrayType  DVTSourceTray4224F3 [] =
    {
        {   IDS_DOC_INS_PAPER,
              CS_MANUAL_PAPER,
              DDT_PAPER_FORM,     DDT_MANUAL_FEED,  DDT_DUMMY_VALUE }
    };

/******************************************************************************/
/*  PD00307 : Remove manual envelope source.                                  */
/******************************************************************************/
DVTSourceTrayType  DVTSourceTray4224F4 [] =
    {
        {   IDS_BIN_1,
              CS_PAPER_TRAY_1,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_SHEET_FEED },
        {   IDS_BIN_2,
              CS_PAPER_TRAY_2,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_SHEET_FEED },
        {   IDS_BIN_3,
              CS_PAPER_TRAY_3,
              DDT_PAPER_FORM,     DDT_AUTO_FEED,    DDT_SHEET_FEED },
        {   IDS_BIN_4_PAPER,
              CS_MANUAL_PAPER,
              DDT_PAPER_FORM,     DDT_MANUAL_FEED,  DDT_DUMMY_VALUE }
    };

/******************************************************************************/
/*  DVT Source configuration arrays.  The default source configeration is the */
/*  first one.                                                                */
/******************************************************************************/
DVTSourceListType  DVTSourceListPro [] =
    {
        {  3,   0,  1,  0,  1,  1, DVTSourceTrayPro }
    };

/******************************************************************************/
/*  PD00221 : 4226 paper sources                                              */
/******************************************************************************/
DVTSourceListType  DVTSourceList4226 [] =
    {
        {  1,   0,  1,  0,  0,  0, DVTSourceTray4226 }
    };

DVTSourceListType  DVTSourceList4224Color [] =
    {
        {  1,   0,  1,  0,  0,  0, DVTSourceTray4224F1 }
    };
/******************************************************************************/
/* PD00307 : Remove manual envelope source from F3 and F4.                    */
/******************************************************************************/
DVTSourceListType  DVTSourceList4224Mono [] =
    {
        {  1,   0,  1,  0,  0,  0, DVTSourceTray4224F1 },
        {  1,  62,  1,  0,  0,  0, DVTSourceTray4224F2 },
        {  1,  50,  0,  0,  1,  0, DVTSourceTray4224F3 },
        {  4,  50,  3,  0,  1,  0, DVTSourceTray4224F4 }
    };

/******************************************************************************/
/*  INIT flag combinations                                                    */
/******************************************************************************/
#define DDT_FLAGS_1   DDT_INIT_PAGE_LENGTH      |                              \
                      DDT_INIT_TEXT_SPACING     |                              \
                      DDT_INIT_MARGINS

#define DDT_FLAGS_2   DDT_INIT_PAGE_LENGTH      |                              \
                      DDT_INIT_TEXT_SPACING     |                              \
                      DDT_INIT_VERTICAL_UNITS   |                              \
                      DDT_INIT_MARGINS

#define DDT_FLAGS_3   DDT_INIT_PAGE_LENGTH      |                              \
                      DDT_INIT_TEXT_SPACING     |                              \
                      DDT_INIT_VERTICAL_UNITS   |                              \
                      DDT_INIT_MARGINS          |                              \
                      DDT_SCP_SUPPORT

#define DDT_FLAGS_4   DDT_INIT_PAGE_LENGTH      |                              \
                      DDT_INIT_TEXT_SPACING     |                              \
                      DDT_INIT_MARGINS          |                              \
                      DDT_SCP_4224_SUPPORT

#define DDT_FLAGS_5   DDT_INIT_PAGE_LENGTH      |                              \
                      DDT_INIT_TEXT_SPACING     |                              \
                      DDT_INIT_PPM_SOURCE       |                              \
                      DDT_INIT_MARGINS          |                              \
                      DDT_SCP_4224_SUPPORT

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter I                           */
/******************************************************************************/
DDTType  DDTProI =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontListProI,               /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        5,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        5,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        20,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter II                          */
/******************************************************************************/
DDTType  DDTProII =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontListProII,              /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        10,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT |
          DDT_DOWN_CP_MEM_SUBSET_AVAIL,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter III                         */
/******************************************************************************/
DDTType  DDTProIII =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontListProIII,             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        13,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT |
          DDT_DOWN_CP_MEM_SUBSET_AVAIL,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter XL                          */
/******************************************************************************/
DDTType  DDTProXL =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontListProXL,              /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        7,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        7,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT |
          DDT_CODE_PAGE_NOTOPTION,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        28,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter II XL                       */
/******************************************************************************/
DDTType  DDTProIIXL =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontListProII,              /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        10,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT |
          DDT_DOWN_CP_MEM_SUBSET_AVAIL,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter III XL                      */
/******************************************************************************/
DDTType  DDTProIIIXL =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterModeProI,             /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontListProIII,             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        13,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT |
          DDT_DOWN_CP_MEM_SUBSET_AVAIL,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_1,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter X24                         */
/******************************************************************************/
DDTType  DDTProX24 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterModeProX24,           /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontListProX24,             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType                       */
        7,                             /* FontsInCodePage                     */
        4,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        7,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_2,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        28,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter X24E                        */
/******************************************************************************/
DDTType  DDTProX24E =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterModeProX24,           /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontListProX24E,            /* FontList      PD00290               */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType                       */
        7,                             /* FontsInCodePage                     */
        4,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        14,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_3,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        28,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter XL24                        */
/******************************************************************************/
DDTType  DDTProXL24 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterModeProX24,           /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontListProX24,             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType                       */
        7,                             /* FontsInCodePage                     */
        4,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        7,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_2,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        28,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for ProPrinter XL24E                       */
/******************************************************************************/
DDTType  DDTProXL24E =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterModeProX24,           /* RasterMode                          */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontListProX24E,            /* FontList      PD00290               */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType                       */
        7,                             /* FontsInCodePage                     */
        4,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        14,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_ADD_CODE_PAGE_OPTION |     /* FontFlags                           */
          DDT_ADD_CODE_PAGE_SUPPORT,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_3,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        0,                             /* ItalicSlopeIndex                    */
        28,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PPPROS,                 /* DDTPP_DialogId                      */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  DIAL/NILE : DDT for IBM2380 (Nile 9 wire)                                 */
/******************************************************************************/
DDTType  DDT2380 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterMode2380,             /* RasterMode PD00333                  */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        0,                             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT_RAST,      /* HorizMoveType PD00484               */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        13,                            /* NoOfDefinedForms                    */
        0,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags   PD00278                 */
        DDT_NLS_FONTS_OPTIONAL |       /* FontFlags                           */
             DDT_CARTRIDGE_OPTION,
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
             DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  DIAL/NILE : DDT for IBM2381 (Tiber 9 wire)                                */
/******************************************************************************/
DDTType  DDT2381 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterMode2380,             /* RasterMode   PD00333                */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide2,          /* DefinedForms                        */
        0,                             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT_RAST,      /* HorizMoveType PD00484               */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        16,                            /* NoOfDefinedForms                    */
        0,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags    PD00278                */
        DDT_NLS_FONTS_OPTIONAL |       /* FontFlags                           */
             DDT_CARTRIDGE_OPTION,
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
           DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  DIAL/NILE : DDT for IBM2390 (Nile 24 wire)                                */
/******************************************************************************/
DDTType  DDT2390 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterMode2390,             /* RasterMode               PD00587    */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        0,                             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType PD00547               */
        0,                             /* FontsInCodePage                     */
        5,                             /* NoOfRasterModes        PD00587      */
        13,                            /* NoOfDefinedForms                    */
        0,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags                           */
        DDT_NLS_FONTS_OPTIONAL |       /* FontFlags    PD00278                */
             DDT_CARTRIDGE_OPTION,
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
           DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  INKJET : DDT for IBM2390_PS1                                              */
/******************************************************************************/
DDTType  DDT2390_PS1 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        80,                            /* MaxPrintWidth                       */
        DVTRasterMode2390,             /* RasterMode               PD00587    */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsNarrow,         /* DefinedForms                        */
        DVTFontList24Wire,             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType PD00547               */
        0,                             /* FontsInCodePage                     */
        5,                             /* NoOfRasterModes        PD00587      */
        13,                            /* NoOfDefinedForms                    */
        US_24WIRE,                     /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags                           */
        DDT_CARTRIDGE_OPTION,          /* FontFlags                           */
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
           DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  DIAL/NILE : DDT for IBM2391 (Tiber 24 wire)                               */
/******************************************************************************/
DDTType  DDT2391 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterMode2390,             /* RasterMode              PD00587     */
        DVTSourceListPro,              /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide2,          /* DefinedForms                        */
        0,                             /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT,           /* HorizMoveType PD00547               */
        0,                             /* FontsInCodePage                     */
        5,                             /* NoOfRasterModes         PD00587     */
        16,                            /* NoOfDefinedForms                    */
        0,                             /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags    PD00278                */
        DDT_NLS_FONTS_OPTIONAL |       /* FontFlags    PD00278                */
             DDT_CARTRIDGE_OPTION,
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
           DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  PD00221 : DDT for IBM4226 (Dakota)                                        */
/******************************************************************************/
DDTType  DDT4226 =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        136,                           /* MaxPrintWidth                       */
        DVTRasterMode2380,             /* RasterMode    PD00333               */
        DVTSourceList4226,             /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide2,          /* DefinedForms                        */
        DVTFontList4226,               /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_STEP_RIGHT_RAST,      /* HorizMoveType PD00484               */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        10,                            /* NoOfDefinedForms PD00330            */
        117,                           /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_NONE,                      /* SourceFlags                         */
        DDT_NONE,                      /* FormFlags    PD00278                */
        DDT_CARTRIDGE_OPTION,          /* FontFlags                           */
        DDT_NLS_VERSION |              /* DialogFlags  PD00295                */
               DDT_LIMIT_FONTS,        /* PD00604                             */
        DDT_FLAGS_2 |                  /* InitFlags                           */
           DDT_SFG_SUPPORT,
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        3,                             /* ItalicSlopeIndex                    */
        0,                             /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP2300_2,               /* DDTPP_DialogId PD00266              */
        DB_DLG_JPSINGLE,               /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS_NO_CP,        /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_PROS,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD137             */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for 4224 - Colour                          */
/******************************************************************************/
DDTType  DDT4224Color =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        132,                           /* MaxPrintWidth                       */
        DVTRasterMode4224,             /* RasterMode            PD00578       */
        DVTSourceList4224Color,        /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontList4224,               /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        7,                             /* NoOfDefinedForms PD00307            */
        22,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_VAR_PAPER_SOURCE_SUPPORT | /* SourceFlags                         */
              DDT_SOURCE_GREYED,       /* PD00251                             */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_CARTRIDGE_OPTION |         /* FontFlags                           */
          DDT_ITALIC_SLOPE_VARIES,
        DDT_NONE,                      /* DialogFlags                         */
        DDT_FLAGS_4,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        1,                             /* ItalicSlopeIndex                    */
        36,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP4224,                 /* DDTPP_DialogId                      */
        DB_DLG_JPDUAL,                 /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS,              /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_4224,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD00137           */
    };

/******************************************************************************/
/*  Device Description Table (DDT) for 4224 - Mono                            */
/******************************************************************************/
DDTType  DDT4224Mono =
    {
        DDT_IBM42XX_DRV,               /* DriverType                          */
        132,                           /* MaxPrintWidth                       */
        DVTRasterMode4224,             /* RasterMode           PD00578        */
        DVTSourceList4224Mono,         /* SourceList                          */
        &DVTEightColorTable,           /* DevColorTable                       */
        &DVT14Format,                  /* Format                              */
        DVTDefinedFormsWide,           /* DefinedForms                        */
        DVTFontList4224,               /* FontList                            */
        1,                             /* BandsPerPage                        */
        RESOLUTION_1,                  /* DefResolution                       */
        PORTRAIT,                      /* DefOrientation                      */
        DDT_MOVE_NO_STEP,              /* HorizMoveType                       */
        0,                             /* FontsInCodePage                     */
        3,                             /* NoOfRasterModes                     */
        7,                             /* NoOfDefinedForms PD00307            */
        22,                            /* NoOfResidentFonts                   */
        0,                             /* DfltFontNo                          */
        DDT_VAR_PAPER_SOURCE_SUPPORT,  /* SourceFlags                         */
        DDT_VAR_FORM_FEED_CONTROL,     /* FormFlags                           */
        DDT_CARTRIDGE_OPTION |         /* FontFlags                           */
          DDT_ITALIC_SLOPE_VARIES,
        DDT_DUAL_FORM_JOB_SOME,        /* DialogFlags                         */
        DDT_FLAGS_5,                   /* InitFlags                           */
        DDT_EIGHT_COLORS,              /* MaxColors                           */
        1,                             /* ItalicSlopeIndex                    */
        36,                            /* AttrFontsInCP                       */
        0,                             /* NoOfCardSlots                       */
        0,                             /* NoOfMemOpts                         */
        0,                             /* MemOptsText                         */
        0,                             /* MemOptsTable                        */
        0,                             /* CardImageNumAttrs                   */
        0,                             /* CardImageAttrs                      */
        0,                             /* CardOutlineNumAttrs                 */
        0,                             /* CardOutlineAttrs                    */
        0,                             /* DownImageAttrs                      */
        DB_DLG_PP4224,                 /* DDTPP_DialogId                      */
        DB_DLG_JPDUAL,                 /* DDTJSU_DialogId                     */
        DB_DEFAULT_FONTS,              /* DDTDEFNT_DialogId                   */
        DB_FORM_CONN_4224,             /* DDTFORMC_DialogId                   */
        0,                             /* DDTPrinterFonts                     */
        0                              /* DDTDefFontPointSz PD00137           */
    };

/******************************************************************************/
/*  DDT array for 42XX driver.                                                */
/******************************************************************************/
lpDDTType  DDT [] =
    {
        &DDTProI,                      /* IBM_PRO_PRINTER_I                   */
        &DDTProII,                     /* IBM_PRO_PRINTER_II                  */
        &DDTProIII,                    /* IBM_PRO_PRINTER_III                 */
        &DDTProXL,                     /* IBM_PRO_PRINTER_XL                  */
        &DDTProIIXL,                   /* IBM_PRO_PRINTER_II_XL               */
        &DDTProIIIXL,                  /* IBM_PRO_PRINTER_III_XL              */
        &DDTProX24,                    /* IBM_PRO_PRINTER_X24                 */
        &DDTProX24E,                   /* IBM_PRO_PRINTER_X24E                */
        &DDTProXL24,                   /* IBM_PRO_PRINTER_XL24                */
        &DDTProXL24E,                  /* IBM_PRO_PRINTER_XL24E               */
        &DDT4224Color,                 /* IBM_4224_COLOR                      */
        &DDT4224Mono,                  /* IBM_4224_MONO                       */
        &DDT2380,                      /* IBM_2380                            */
        &DDT2381,                      /* IBM_2381                            */
        &DDT2390,                      /* IBM_2390                            */
        &DDT2391,                      /* IBM_2391                            */
        &DDT4226,                      /* IBM_4226                            */
        &DDT2390_PS1                   /* IBM_2390_PS1                        */
    };

/******************************************************************************/
/*  Note: the 1st field below (NoOfDescriptions) cannot be initialised here   */
/*  since it should be set to the variable NO_OF_PRINTERS.  We now set it to  */
/*  this in the code in prdqname.c and prdmdlg.c, the only places where it is */
/*  used.  ( MJB 13/11/90 )                                                   */
/******************************************************************************/
DVTDevDescriptionType  DVTDevDescription =
    {
        2,
        DVTDataTypes
    };

/******************************************************************************/
/* PD00556 Space for a fifth resolution was added so that support can be added*/
/* for 360x360.                                                               */
/******************************************************************************/
/******************************************************************************/
/*  DCT tables for ProPrinters.                                               */
/******************************************************************************/
DCTEntryType  DCTProII [DCT_NUMBER_ENTRIES] =
    {
        EST_PRO_INIT_1,                /* DCT_PRINTER_INIT_1                  */
        EST_PRO_INIT_2,                /* DCT_PRINTER_INIT_2                  */
        EST_PRO_INIT_3,                /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_3,           /* DCT_RASTER_MODE_3                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_SPACE,                     /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_GRAPHICS_MODE_3,           /* DCT_FINE_MOVE_RIGHT                 */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_NOT_USED,                  /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCTProIII [DCT_NUMBER_ENTRIES] =
    {
        EST_SIC_PRO_X24,               /* DCT_PRINTER_INIT_1                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_2                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_3,           /* DCT_RASTER_MODE_3                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_SPACE,                     /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_GRAPHICS_MODE_3,           /* DCT_FINE_MOVE_RIGHT                 */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_NOT_USED,                  /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCTProX24 [DCT_NUMBER_ENTRIES] =
    {
        EST_PRO_INIT_1,                /* DCT_PRINTER_INIT_1                  */
        EST_PRO_INIT_2,                /* DCT_PRINTER_INIT_2                  */
        EST_PRO_INIT_3,                /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_11,          /* DCT_RASTER_MODE_3                   */
        EST_GRAPHICS_MODE_12,          /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_MOVE_RIGHT,                /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_MOVE_RIGHT,               /*  DCT_FINE_MOVE_RIGHT PD00484 */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_NOT_USED,                  /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCTProX24E [DCT_NUMBER_ENTRIES] =
    {
        EST_SIC_PRO_X24,               /* DCT_PRINTER_INIT_1                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_2                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_11,          /* DCT_RASTER_MODE_3                   */
        EST_GRAPHICS_MODE_12,          /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_MOVE_RIGHT,                /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_MOVE_RIGHT,               /*  DCT_FINE_MOVE_RIGHT PD00484 */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_NOT_USED,                  /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

/******************************************************************************/
/*  DIAL/NILE : New DCT's for Nile/Tiber.                                     */
/******************************************************************************/
DCTEntryType  DCT2380 [DCT_NUMBER_ENTRIES] =
    {
        EST_BEGIN_NT_SIC,              /* DCT_PRINTER_INIT_1                  */
        EST_BEGIN_NT_SIC_2,            /* DCT_PRINTER_INIT_2 PD00222          */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_3,           /* DCT_RASTER_MODE_3                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_MOVE_RIGHT,                /* DCT_ROUGH_MOVE_RIGHT PD00333        */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_GRAPHICS_MODE_3,           /* DCT_FINE_MOVE_RIGHT                 */
        EST_SET_FONT_GLOBAL_NT,        /* DCT_SELECT_FONT                     */
        EST_END_NT_SIC,                /* DCT_END_OF_JOB                      */
        EST_SELECT_ITALIC,             /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCT2390 [DCT_NUMBER_ENTRIES] =
    {
        EST_BEGIN_NT_SIC,              /* DCT_PRINTER_INIT_1                  */
        EST_BEGIN_NT_SIC_2,            /* DCT_PRINTER_INIT_2 PD00222          */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_11,          /* DCT_RASTER_MODE_3                   */
        EST_GRAPHICS_MODE_12,          /* DCT_RASTER_MODE_4                   */
        EST_GRAPHICS_MODE_12,          /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_MOVE_RIGHT,                /* DCT_ROUGH_MOVE_RIGHT PD00333        */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_MOVE_RIGHT,               /*  DCT_FINE_MOVE_RIGHT PD00547 */
        EST_SET_FONT_GLOBAL_NT,        /* DCT_SELECT_FONT                     */
        EST_END_NT_SIC,                /* DCT_END_OF_JOB                      */
        EST_SELECT_ITALIC,             /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCT4224Color [DCT_NUMBER_ENTRIES] =
    {
        EST_SIC_SET_MODE,              /* DCT_PRINTER_INIT_1                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_2                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_3,           /* DCT_RASTER_MODE_3                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_SPACE,                     /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_GRAPHICS_MODE_1,           /* DCT_FINE_MOVE_RIGHT   PD00578       */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_SELECT_ITALIC,             /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

DCTEntryType  DCT4224Mono [DCT_NUMBER_ENTRIES] =
    {
        EST_SIC_SET_MODE,              /* DCT_PRINTER_INIT_1                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_2                  */
        EST_NOT_USED,                  /* DCT_PRINTER_INIT_3                  */
        EST_GRAPHICS_MODE_0,           /* DCT_RASTER_MODE_1                   */
        EST_GRAPHICS_MODE_1,           /* DCT_RASTER_MODE_2                   */
        EST_GRAPHICS_MODE_3,           /* DCT_RASTER_MODE_3                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_4                   */
        EST_NOT_USED,                  /* DCT_RASTER_MODE_5                   */
        EST_BACKSPACE,                 /* DCT_ROUGH_MOVE_LEFT                 */
        EST_SPACE,                     /* DCT_ROUGH_MOVE_RIGHT                */
        EST_NOT_USED,                  /* DCT_FINE_MOVE_LEFT                  */
        EST_GRAPHICS_MODE_1,           /* DCT_FINE_MOVE_RIGHT  PD00578        */
        EST_SELECT_FONT,               /* DCT_SELECT_FONT                     */
        EST_FORM_FEED,                 /* DCT_END_OF_JOB                      */
        EST_SELECT_ITALIC,             /* DCT_SELECT_ITALIC                   */
        EST_NOT_USED                   /* DCT_START_DUPLEX                    */
    };

lpDCTEntryType  DCT [] =
    {
        DCTProII,                      /* IBM_PRO_PRINTER_I                   */
        DCTProII,                      /* IBM_PRO_PRINTER_II                  */
        DCTProIII,                     /* IBM_PRO_PRINTER_III                 */
        DCTProII,                      /* IBM_PRO_PRINTER_XL                  */
        DCTProII,                      /* IBM_PRO_PRINTER_II_XL               */
        DCTProIII,                     /* IBM_PRO_PRINTER_III_XL              */
        DCTProX24,                     /* IBM_PRO_PRINTER_X24                 */
        DCTProX24E,                    /* IBM_PRO_PRINTER_X24E                */
        DCTProX24,                     /* IBM_PRO_PRINTER_XL24                */
        DCTProX24E,                    /* IBM_PRO_PRINTER_XL24E               */
        DCT4224Color,                  /* IBM_4224_COLOR                      */
        DCT4224Mono,                   /* IBM_4224_MONO                       */
        DCT2380,                       /* IBM_2380                            */
        DCT2380,                       /* IBM_2381                            */
        DCT2390,                       /* IBM_2390                            */
        DCT2390,                       /* IBM_2391                            */
        DCT2380,                       /* IBM_4226           PD00221          */
        DCT2390                        /* IBM_2390_PS1                        */
    };

USHORT MatchNoProI [] =
    {
       0x0273,
       0x0273,
       0x0023,
       0x0273,
       0x0273
    };

USHORT MatchNoProXL [] =
    {
       0x0273,
       0x0273,
       0x0023,
       0x0273,
       0x03FF,
       0x0273,
       0x0273
    };

USHORT MatchNoProII [] =
    {
       0x0273,
       0x0273,
       0x0023,
       0x0273,
       0x0273,
       0x03FF,
       0x0273,
       0x0273,
       0x0231,
       0x0621
    };

USHORT MatchNoProIII [] =
    {
       0x0273,
       0x0273,
       0x0663,
       0x0663,
       0x0273,
       0x0273,
       0x03FF,
       0x0273,
       0x0273,
       0x0231,
       0x0621,
       0x0231,
       0x0621
    };

USHORT MatchNoPro24 [] =
    {
       0x03FF,
       0x03FF,
       0x0663,
       0x03FF,
       0x03FF,
       0x0663,
       0x03FF
    };

/* PD00516 */
/* Make the value in the array a negative one (0xFF) if the printer is not to */
/*  be installed but is still in the list.                                    */
USHORT PrinterOrder [] =
    {
       0x0C,                                 /* 12 - IBM2380                  */
       0x0D,                                 /* 13 - IBM2381                  */
       0x0E,                                 /* 14 - IBM2390                  */
       0x11,                                 /* 17 - IBM2390 PS/1             */
       0x0F,                                 /* 15 - IBM2391                  */
       0x00,                                 /* 00 - Proprinter               */
       0x01,                                 /* 01 - Proprinter II            */
       0x02,                                 /* 02 - Proprinter III           */
       0x03,                                 /* 03 - Proprinter XL            */
       0x04,                                 /* 04 - Proprinter II XL         */
       0x05,                                 /* 05 - Proprinter III XL        */
       0x06,                                 /* 06 - Proprinter X24           */
       0x07,                                 /* 07 - Proprinter X24E          */
       0x08,                                 /* 08 - Proprinter XL24          */
       0x09,                                 /* 09 - Proprinter XL24E         */
       0x0B,                                 /* 11 - IBM4224 Mono             */
       0x0A,                                 /* 10 - IBM4224 Color            */
       0x10                                  /* 16 - IBM4226                  */
    };
