/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDD42FT
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS                 /* Convert to C/SET2    CON3201       */
#define INCL_DOSSEMAPHORES
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_WINPOINTERS
#include <os2.h>
#undef INCL_DOSPROCESS                  /* Convert to C/SET2    CON3201       */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_WINPOINTERS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#define INCL_WINP_FSRS
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_WINP_FSRS
#undef INCL_32                          /* Convert to C/SET2    CON3201       */

#include <prdconty.h>
#include <prdttypt.h>
#include <prddcone.h>
#include <prdtcone.h>
#include <prdconse.h>
#include <prddtypt.h>
#include <prdetypt.h>

/******************************************************************************/
/*  Resident fonts for the ProPrinters                                        */
/******************************************************************************/
FontListType   Draft9SansSerif10 =
    {
        IDR_9_DRAFT_10,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft9SansSerif12 =
    {
        IDR_9_DRAFT_12,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft9SansSerif17ProI =
    {
        IDR_9_DRAFT_17,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE,              /* Attribute control                   */
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft9SansSerif17ProIII =
    {
        IDR_9_DRAFT_17,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft9SansSerif20 =
    {
        IDR_9_DRAFT_20,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_20_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft9SansSerifPS =
    {
        IDR_9_DRAFT_PS,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_PROP_SPACING_ON,           /* PreDCTCmd                           */
        EST_PROP_SPACING_OFF,          /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft24SansSerif10 =
    {
        IDR_24_DRAFT_10,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft85024SansSerif10 =
    {
        IDR_24_DRAFT_10,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft24SansSerif12 =
    {
        IDR_24_DRAFT_12,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft85024SansSerif12 =
    {
        IDR_24_DRAFT_12,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft24SansSerif17 =
    {
        IDR_24_DRAFT_17,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Draft85024SansSerif17 =
    {
        IDR_24_DRAFT_17,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DRAFT,                     /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   FastFont12 =
    {
        IDR_9_FASTFONT_12,             /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_FASTFONT,                  /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQSansSerif10ProI =
    {
        IDR_9_NLQ_10,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ,                       /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQSansSerif10ProXL =
    {
        IDR_9_NLQ_10,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ,                       /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQSansSerif12 =
    {
        IDR_9_NLQ_12,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ,                       /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQSansSerifPS =
    {
        IDR_9_NLQ_PS,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ,                       /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_PROP_SPACING_ON,           /* PreDCTCmd                           */
        EST_PROP_SPACING_OFF,          /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQIISansSerif10 =
    {
        IDR_9_NLQII_10,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_II,                    /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQIISansSerif12 =
    {
        IDR_9_NLQII_12,                /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_II,                    /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Italic10 =
    {
        IDR_9_ITALIC_10,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_ITALIC,                    /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,  /* PD00132                             */
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   Italic12 =
    {
        IDR_9_ITALIC_12,               /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_ITALIC,                    /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQCourier10 =
    {
        IDR_24_LQ_10,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER10,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQ850Courier10 =
    {
        IDR_24_LQ_10,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER10,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQCourier12 =
    {
        IDR_24_LQ_12,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER12,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQ850Courier12 =
    {
        IDR_24_LQ_12,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER12,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQCourier17 =
    {
        IDR_24_LQ_17,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER17,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQ850Courier17 =
    {
        IDR_24_LQ_17,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIER17,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_17_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_DS,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQCourierPS =
    {
        IDR_24_LQ_PS,                  /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIERPS,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_PROP_SPACING_ON,           /* PreDCTCmd                           */
        EST_PROP_SPACING_OFF,          /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        437,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   LQ850CourierPS =
    {
        IDR_850_24_LQ_PS,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_LQ_COURIERPS,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_PROP_SPACING_ON,           /* PreDCTCmd                           */
        EST_PROP_SPACING_OFF,          /* PostDCTCmd                          */
        4,                             /* NumAttrs                            */
        FATT_BOTH                      /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP,
        850,                           /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

/******************************************************************************/
/*  DVTFontList for ProPrinters                                               */
/******************************************************************************/
lpFontListType   DVTFontListProI [] =
    {
        &Draft9SansSerif10,
        &Draft9SansSerif12,
        &Draft9SansSerif17ProI,
        &NLQSansSerif10ProI,
        &NLQSansSerif12
    };

lpFontListType   DVTFontListProXL [] =
    {
        &Draft9SansSerif10,
        &Draft9SansSerif12,
        &Draft9SansSerif17ProI,
        &Draft9SansSerifPS,
        &NLQSansSerif10ProXL,
        &NLQSansSerif12,
        &NLQSansSerifPS
    };

lpFontListType   DVTFontListProII [] =
    {
        &Draft9SansSerif10,
        &Draft9SansSerif12,
        &Draft9SansSerif17ProI,
        &Draft9SansSerifPS,
        &FastFont12,
        &NLQSansSerif10ProXL,
        &NLQSansSerif12,
        &NLQSansSerifPS,
        &NLQIISansSerif10,
        &NLQIISansSerif12
    };

lpFontListType   DVTFontListProIII [] =
    {
        &Draft9SansSerif10,
        &Draft9SansSerif12,
        &Draft9SansSerif17ProIII,
        &Draft9SansSerif20,
        &Draft9SansSerifPS,
        &FastFont12,
        &NLQSansSerif10ProXL,
        &NLQSansSerif12,
        &NLQSansSerifPS,
        &NLQIISansSerif10,
        &NLQIISansSerif12,
        &Italic10,
        &Italic12
    };

lpFontListType   DVTFontListProX24 [] =
    {
        &Draft24SansSerif10,
        &Draft24SansSerif12,
        &Draft24SansSerif17,
        &LQCourier10,
        &LQCourier12,
        &LQCourier17,
        &LQCourierPS
    };

lpFontListType   DVTFontListProX24E [] =
    {
        &Draft24SansSerif10,
        &Draft24SansSerif12,
        &Draft24SansSerif17,
        &LQCourier10,
        &LQCourier12,
        &LQCourier17,
        &LQCourierPS,
        &Draft85024SansSerif10,
        &Draft85024SansSerif12,
        &Draft85024SansSerif17,
        &LQ850Courier10,
        &LQ850Courier12,
        &LQ850Courier17,
        &LQ850CourierPS
    };

/******************************************************************************/
/*  Resident fonts for 4224                                                   */
/******************************************************************************/
FontListType   DPGothic10 =
    {
        IDR_42_DPGOTH_10,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850Gothic10 =
    {
        IDR_850_42_DPGOTH_10,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPGothic12 =
    {
        IDR_42_DPGOTH_12,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850Gothic12 =
    {
        IDR_850_42_DPGOTH_12,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPGothic15 =
    {
        IDR_42_DPGOTH_15,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850Gothic15 =
    {
        IDR_850_42_DPGOTH_15,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_GOTHIC,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPTextCourier10 =
    {
        IDR_42_DPCOUR_10,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850TextCourier10 =
    {
        IDR_850_42_DPCOUR_10,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPTextCourier12 =
    {
        IDR_42_DPCOUR_12,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850TextCourier12 =
    {
        IDR_850_42_DPCOUR_12,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPTextCourier15 =
    {
        IDR_42_DPCOUR_15,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DP850TextCourier15 =
    {
        IDR_850_42_DPCOUR_15,          /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_FP,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   DPTextCourierPS =
    {
        IDR_42_DPCOUR_PS,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_DP_COURIER_PS,             /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQCourier10 =
    {
        IDR_42_NLQ_10,                 /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQ850Courier10 =
    {
        IDR_850_42_NLQ_10,             /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_NULL,                      /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQCourier12 =
    {
        IDR_42_NLQ_12,                 /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQ850Courier12 =
    {
        IDR_850_42_NLQ_12,             /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQCourier15 =
    {
        IDR_42_NLQ_15,                 /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQ850Courier15 =
    {
        IDR_850_42_NLQ_15,             /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_COURIER_FP,            /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_15_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   NLQEssayPS =
    {
        IDR_42_NLQESSAY_PS,            /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_NLQ_ESSAY_PS,              /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_12_CPI,                    /* PreDCTCmd                           */
        EST_10_CPI,                    /* PostDCTCmd                          */
        2,                             /* NumAttrs                            */
        FATT_DOUBLE_WIDE               /* Attribute control                   */
          | FATT_BOLD | FATT_BOLD_EMP
          | FATT_ITALIC,
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

/******************************************************************************/
/*  For OCRs, select code page 340 OCR and then select OCR 876/877 as DCT     */
/*  command.  If the printer is a 4224-3E3, the second command will override  */
/*  the first, otherwise the second command will be ignored a page 340 OCR    */
/*  will be used instead of 876/877 as a 'second best'.                       */
/******************************************************************************/
FontListType   OcrA_876 =
    {
        IDR_42_OCR_A_876,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_OCR_A_340,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_SEL_OCR_A_876,             /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE,                     /* Attribute control                   */
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

FontListType   OcrB_877 =
    {
        IDR_42_OCR_B_877,              /* ResourceId                          */
        FNULL,                         /* pFMFData (set up in EFPDB)          */
        FNULL,                         /* pMultiCp                            */
        FNULL,                         /* pEngAttrs                           */
        SEL_OCR_B_340,                 /* SelectionId                         */
        VALUE_NOT_SET,                 /* GlobalId                            */
        EST_SEL_OCR_B_877,             /* PreDCTCmd                           */
        EST_NULL,                      /* PostDCTCmd                          */
        1,                             /* NumAttrs                            */
        FATT_NONE,                     /* Attribute control                   */
        0,                             /* PD00220: Code Page                  */
        FNULL                          /* Italic metrics                      */
    };

/******************************************************************************/
/*  DVTFontList for the 4224                                                  */
/******************************************************************************/
lpFontListType   DVTFontList4224 [] =
    {
        &DPGothic10,
        &DPGothic12,
        &DPGothic15,
        &DPTextCourier10,
        &DPTextCourier12,
        &DPTextCourier15,
        &NLQCourier10,
        &NLQCourier12,
        &NLQCourier15,
        &DPTextCourierPS,
        &NLQEssayPS,
        &DP850Gothic10,
        &DP850Gothic12,
        &DP850Gothic15,
        &DP850TextCourier10,
        &DP850TextCourier12,
        &DP850TextCourier15,
        &NLQ850Courier10,
        &NLQ850Courier12,
        &NLQ850Courier15,
        &OcrA_876,
        &OcrB_877
    };

/******************************************************************************/
/*  DVTItalicSlopeList contains the different slopes to use with attri Italic */
/*  fonts - these are used to tweak the font metrics before the returned by   */
/*  DeviceQueryFonts.                                                         */
/*                                                                            */
/*  Note - now only used for the 4224 printer.  The first field is used - no  */
/*  DW,DH scaling is done.                                                    */
/******************************************************************************/
DVTItalicSlopeType  DVTItalicSlopeList [] =
    {
        {     0 },                     /* ProPrinters                         */
        { 29199 },                     /* 4224 - non NLQ fonts                */
        {  1038 },                     /* 4224 - NLQ fonts                    */
        {    17 },                     /* 23XX, 4226         PD00220          */
    };

/******************************************************************************/
/*  Outline Codepage Global table for 4019 Heritage printer driver            */
/******************************************************************************/

USHORT  OutlineCodepageEntries = 0;    /* Number of entries in global outline */
                                       /* codepage table. This value is       */
                                       /* caluclated in prde_SetUpOutlineTable*/

lpOutlineCodepages OutlineCodepages=0L;/* declare a pointer to the global     */
                                       /* outline code page table.            */
                                       /* This pointer is initialized in      */
                                       /* prde_SetUpOutlineCodePageTable      */

/******************************************************************************/
/*  The following is a list of all the Heritage printer resident code pages.  */
/*  This list is checked prior to downloading a code page BIN file to add     */
/*  support for a non-resident code page.  NOTE: If any code pages are added  */
/*  to this array the constant HERITAGE_RESIDENT_CODEPAGES must also be       */
/*  changed.                                                                  */
/******************************************************************************/

USHORT  HeritageResidentCodePageCount = 5; /* Number of entries in array      */

USHORT HeritageResidentCodePages[] =
    {
        437,
        819,
        850,
        863,
       1004
    };

USHORT NonOS2HeritageCodePageCount = 2;/* Number of entries in following      */
                                       /* structure                           */

NonOS2CodePageType NonOS2HeritageCodePages[] =
    {
        {
            819,
            IDR_4019_CPV_FILE_CP819    /* Code Page Vector resource ID        */
        },
        {
            861,
            IDR_4019_CPV_FILE_CP861    /* Code Page Vector resource ID        */
        }
    };
