/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDASETG
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS   prda_DeviceSetGlobalAttribute
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_32                         /* Convert to C/SET2    CON3201       */
#define INCL_DOSPROCESS           /* CON3201 */
#define INCL_DOSSEMAPHORES
#define INCL_GPILOGCOLORTABLE
#define INCL_GPIPRIMITIVES
#define INCL_WINHEAP
#define INCL_GPIBITMAPS
#define INCL_GPIERRORS
#include <os2.h>
#undef INCL_DOSPROCESS            /* CON3201 */
#undef INCL_DOSSEMAPHORES
#undef INCL_GPILOGCOLORTABLE
#undef INCL_GPIPRIMITIVES
#undef INCL_WINHEAP
#undef INCL_GPIBITMAPS
#undef INCL_GPIERRORS

#define INCL_DDIBUNDLES
#define INCL_DDIFONTSTRUCS
#define INCL_DDIDEFS
#define INCL_DDIMISC
#include <pmddi.h>
#undef INCL_DDIBUNDLES
#undef INCL_DDIFONTSTRUCS
#undef INCL_DDIDEFS
#undef INCL_DDIMISC

#define INCL_WINP_SELECTIVE
#define INCL_WINP_SEI
#include <pmwinx.h>
#undef INCL_WINP_SELECTIVE
#undef INCL_WINP_SEI
#undef INCL_32                    /* CON3201 */

#include <prdacone.h>
#include <prdccone.h>

#define NO_CONSTANT_INCL
#include <prdinclt.h>
#undef NO_CONSTANT_INCL

#include <prdaextf.h>

/******************************************************************************/
/*  FUNCTION: prda_DeviceSetGlobalAttributes                                  */
/*                                                                            */
/*  PARAMETERS:                                                               */
/*                                                                            */
/*  See "OS/2 Technical Reference: I/O Subsytems and Device Drivers"          */
/*                                                                            */
/*  HDC    DcH;                                                               */
/*  ULONG  ArgAttrType;                                                       */
/*  ULONG  ArgAttrValue;                                                      */
/*  ULONG  ArgOptions;                                                        */
/*  lpDCI  DCIData;                                                           */
/*  ULONG  FunN;                                                              */
/*                                                                            */
/*  DESCRIPTION:                                                              */
/*                                                                            */
/*  This function sets attributes in the line, character, marker, pattern and */
/*  image attribute bundles.  If ArgOptions & GATTR_DEFAULT is true then      */
/*  default values are be used.  Note that if defaults are specified for      */
/*  foreground or background mix then the engine will intercept the call and  */
/*  set ArgAttrValue to the appopriate default value and clear the            */
/*  GATTR_DEFAULT flag.                                                       */
/******************************************************************************/
/*   CON3201  Convert to C/SET2                                               */
ULONG EXPENTRY prda_DeviceSetGlobalAttribute( HDC    DcH,
                                              ULONG  ArgAttrType,
                                              ULONG  ArgAttrValue,
                                              ULONG  ArgOptions,
                                              lpDCI  DCIData,
                                              ULONG  FunN )

{
#define TFUNC "prda_DevSetGlAt"

    /**************************************************************************/
    /*  Local variables                                                       */
    /**************************************************************************/
    PDLINEBUNDLE    LineBundle;
    PDCHARBUNDLE    TextBundle;
    PDAREABUNDLE    PattBundle;
    PDMARKERBUNDLE  MarkBundle;
    PDIMAGEBUNDLE   ImagBundle;

    /******************************************************************/
    /* Lock the DC                                                    */
    /******************************************************************/
    prdm_EnterDriver(DCIData);

    /******************************************************************/
    /* PD00474 : The cached value of the pattern is now invalid.      */
    /******************************************************************/
    DCIData->usPatValid = FALSE;

    /**************************************************************************/
    /*  Select according to desired attribute type.  If ArgOptions equals     */
    /*  GATTR_DEFAULT then the desired attribute is set to its default value. */
    /*  For attribute types 3 and 4 the engine sets the default and passes to */
    /*  the driver the default value as well as clearing the option flag      */
    /**************************************************************************/
    LineBundle = DCIData->DCICurLinAts;
    TextBundle = DCIData->DCICurTxtAts;
    MarkBundle = DCIData->DCICurMrkAts;
    PattBundle = DCIData->DCICurPtnAts;
    ImagBundle = DCIData->DCICurImgAts;

    switch ((USHORT)ArgAttrType)
    {
        case ATYPE_COLOR :

            /******************************************************************/
            /*  Foreground color                                              */
            /******************************************************************/
            if (ArgOptions & GATTR_DEFAULT)
            {
                ArgAttrValue = (ULONG)DEFAULT_FOREGROUND_COL;
            }
            else
            {

                /**************************************************************/
                /*  PD00124 : Need to handle the different checks for RGB-mode*/
                /*  colors too.                                               */
                /*                                                            */
                /*  PD00446 : Rats... we can't check RGB values without mondo */
                /*  problems, so we'll just check indexed values instead      */
                /*  (since we ignore the high byte of the high word of the    */
                /*  RGB values anyway, it's probably dumb to validate it so   */
                /*  we won't).                                                */
                /**************************************************************/
                if (DCIData->DCIColFormat != LCOLF_RGB)
                {
                    /**********************************************************/
                    /*  PD00124 : Check for valid values...                   */
                    /**********************************************************/
                    switch ((SHORT)ArgAttrValue)
                    {
                        case DEFAULT_FOREGROUND_COL : /* PD00444...           */
                        case CLR_FALSE :
                        case CLR_TRUE :
                        case CLR_DEFAULT :
                        case CLR_WHITE :
                        case CLR_BLACK :
                        case CLR_BACKGROUND :
                        case CLR_BLUE :
                        case CLR_RED :
                        case CLR_PINK :
                        case CLR_GREEN :
                        case CLR_CYAN :
                        case CLR_YELLOW :
                        case CLR_NEUTRAL :
                        case CLR_DARKGRAY :
                        case CLR_DARKBLUE :
                        case CLR_DARKRED :
                        case CLR_DARKPINK :
                        case CLR_DARKGREEN :
                        case CLR_DARKCYAN :
                        case CLR_BROWN :
                        case CLR_PALEGRAY :
                            break;
                        default :
                            /**************************************************/
                            /* PD00781 : Check for other valid values before  */
                            /* reporting an error.                            */
                            /**************************************************/
                            if ((SHORT)ArgAttrValue < CLR_FALSE ||
                                (SHORT)ArgAttrValue > MAX_COLOR_INDEX )
                            {
                                LOGERR(TFUNC, "Invalid Color Attribute", FNULL,
                                       0, PMERR_INV_COLOR_ATTR);
                                return(ERROR_ZERO);
                            }
                    }
                }
            }
            LineBundle->lbnd.lColor = ArgAttrValue;
            TextBundle->cbnd.lColor = ArgAttrValue;
            MarkBundle->mbnd.lColor = ArgAttrValue;
            PattBundle->abnd.lColor = ArgAttrValue;
            ImagBundle->ibnd.lColor = ArgAttrValue;
            break;
        case ATYPE_BACK_COLOR :

            /******************************************************************/
            /*  Background color                                              */
            /******************************************************************/
            if (ArgOptions & GATTR_DEFAULT)
            {
                ArgAttrValue = (ULONG)DEFAULT_BACKGROUND_COL;
            }
            else
            {

                /**************************************************************/
                /*  PD00124 : Need to handle the different checks for RGB-mode*/
                /*  colors too.                                               */
                /*                                                            */
                /*  PD00446 : Rats... we can't check RGB values without mondo */
                /*  problems, so we'll just check indexed values instead      */
                /*  (since we ignore the high byte of the high word of the    */
                /*  RGB values anyway, it's probably dumb to validate it so   */
                /*  we won't).                                                */
                /**************************************************************/
                if (DCIData->DCIColFormat != LCOLF_RGB)
                {

                    /**********************************************************/
                    /*  PD00124 : Check for valid values...                   */
                    /**********************************************************/
                    switch ((SHORT)ArgAttrValue)
                    {
                        case DEFAULT_BACKGROUND_COL : /* PD00444...           */
                        case CLR_FALSE :
                        case CLR_TRUE :
                        case CLR_DEFAULT :
                        case CLR_WHITE :
                        case CLR_BLACK :
                        case CLR_BACKGROUND :
                        case CLR_BLUE :
                        case CLR_RED :
                        case CLR_PINK :
                        case CLR_GREEN :
                        case CLR_CYAN :
                        case CLR_YELLOW :
                        case CLR_NEUTRAL :
                        case CLR_DARKGRAY :
                        case CLR_DARKBLUE :
                        case CLR_DARKRED :
                        case CLR_DARKPINK :
                        case CLR_DARKGREEN :
                        case CLR_DARKCYAN :
                        case CLR_BROWN :
                        case CLR_PALEGRAY :
                            break;
                        default :

                            /**************************************************/
                            /* PD00781 : Check for other valid values before  */
                            /* reporting an error.                            */
                            /**************************************************/
                            if ((SHORT)ArgAttrValue < CLR_FALSE ||
                                (SHORT)ArgAttrValue > MAX_COLOR_INDEX )
                            {
                                LOGERR(TFUNC,
                                       "Invalid Background Color Attribute",
                                       FNULL, 0, PMERR_INV_BACKGROUND_COL_ATTR);
                                return(ERROR_ZERO);
                            }
                    }
                }
            }
            TextBundle->cbnd.lBackColor = ArgAttrValue;
            MarkBundle->mbnd.lBackColor = ArgAttrValue;
            PattBundle->abnd.lBackColor = ArgAttrValue;
            ImagBundle->ibnd.lBackColor = ArgAttrValue;
            break;
        case ATYPE_MIX_MODE :

            /******************************************************************/
            /*  Foreground mix                                                */
            /*                                                                */
            /*  PD00124 : Check for valid values...                           */
            /******************************************************************/
            switch ((SHORT)ArgAttrValue)
            {
                case FM_DEFAULT :
                case FM_OR :
                case FM_OVERPAINT :
                case FM_LEAVEALONE :
                case FM_XOR :
                case FM_AND :
                case FM_SUBTRACT :
                case FM_MASKSRCNOT :
                case FM_ZERO :
                case FM_NOTMERGESRC :
                case FM_NOTXORSRC :
                case FM_INVERT :
                case FM_MERGESRCNOT :
                case FM_NOTCOPYSRC :
                case FM_MERGENOTSRC :
                case FM_NOTMASKSRC :
                case FM_ONE :
                    break;
                default :
                    LOGERR(TFUNC, "Invalid Mix Attribute", FNULL, 0,
                           PMERR_INV_MIX_ATTR);
                    return(ERROR_ZERO);
            }
            LineBundle->lbnd.usMixMode = (USHORT)ArgAttrValue;
            TextBundle->cbnd.usMixMode = (USHORT)ArgAttrValue;
            MarkBundle->mbnd.usMixMode = (USHORT)ArgAttrValue;
            PattBundle->abnd.usMixMode = (USHORT)ArgAttrValue;
            ImagBundle->ibnd.usMixMode = (USHORT)ArgAttrValue;
            break;
        case ATYPE_BACK_MIX_MODE :

            /******************************************************************/
            /*  Background mix                                                */
            /*                                                                */
            /*  PD00124 : Check for valid values...                           */
            /******************************************************************/
            switch ((SHORT)ArgAttrValue)
            {
                case BM_DEFAULT :
                case BM_OVERPAINT :
                case BM_LEAVEALONE :
                case BM_OR :
                case BM_XOR :
                    break;
                default :
                    LOGERR(TFUNC, "Invalid Background Mix Attribute", FNULL, 0,
                           PMERR_INV_BACKGROUND_MIX_ATTR);
                    return(ERROR_ZERO);
            }
            TextBundle->cbnd.usBackMixMode = (USHORT)ArgAttrValue;
            MarkBundle->mbnd.usBackMixMode = (USHORT)ArgAttrValue;
            PattBundle->abnd.usBackMixMode = (USHORT)ArgAttrValue;
            ImagBundle->ibnd.usBackMixMode = (USHORT)ArgAttrValue;
            break;
    }
    prdm_LeaveDriver(DCIData);
    return (OK);
}
#undef TFUNC
