/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDTEXTF
 *
 * DESCRIPTIVE NAME = Printer Device Driver external files for
 *                    Text routines
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* Hooked functions                                                   */
/**********************************************************************/
ULONG EXPENTRY prdt_CharStringPos (
            HDC,
            PPOINTL,                   /* Start position              */
            PRECTL,                    /* Opaque rectangle            */
            ULONG,                     /* Options                     */
            LONG,                      /* Charnum                     */
            PCH,                       /* CodePoints                  */
            PLONG,                     /* PosVector                   */
            PCSP_INFO,                 /* Attributes                  */
            lpDCI,
            ULONG );

ULONG EXPENTRY prdt_CharString (
            HDC,
            LONG,                      /* Charnum                     */
            PCH,                       /* CodePoints                  */
            lpDCI,
            ULONG );

ULONG EXPENTRY prdt_QueryWidthTable (
            HDC,
            LONG,
            LONG,
            PLONG,
            lpDCI,
            ULONG );

ULONG EXPENTRY prdt_QueryTextBox (
            HDC,
            LONG,                      /* Charnum                     */
            PCH,                       /* CodePoints                  */
            LONG,                      /* Count                       */
            PPOINTL,                   /* TextBox                     */
            lpDCI,
            ULONG );

ULONG EXPENTRY prdt_QueryCharPositions (
            HDC,
            PPOINTL,                   /* StartXY                     */
            ULONG,                     /* Options                     */
            LONG,                      /* Charnum                     */
            PCH,                       /* CodePoints                  */
            PLONG,                     /* PosVector                   */
            PPOINTL,                   /* XY                          */
            lpDCI,
            ULONG );


/**********************************************************************/
/* Internal functions                                                 */
/**********************************************************************/
USHORT prdt_LocateFont (
            lpFontDataType,
            lpDCI );

USHORT prdt_EstablishFont (
            lpFontDataType,
            lpDCI );

VOID prdt_NextCodePoint (
            USHORT,
            lpFontDataType,
            lpDCI );


USHORT prdt_OutlineFontSize (
            lpFontDataType ,
            lpDCI );
/* CON3201
USHORT prdt_SetOpaqueRect (
            HDC,
            PRECTL,
            USHORT,
            USHORT,
            lpDCI,
            PBYTE );  */          /* PD00076  */


USHORT prdt_SetOpaqueRect (
            HDC,
            PRECTL,
            USHORT,
            ULONG,                /* CON3201  */
            lpDCI,
            PBYTE );              /* PD00076  */

USHORT prdt_XformFontValue (
            USHORT,
            USHORT,
            lpFontDataType );


LONG prdt_GetStringWidth(
           LONG,
           PCH,
           PLONG,
           lpDCI );

USHORT prdt_GetStartPos(
           HDC,
           PPOINTL,
           ULONG,
           PPOINTL,
           USHORT,
/*         USHORT, CON3201 - changed Command parameter to ULONG */
           ULONG,
           lpDCI );


VOID prdt_ChainTextBand (
            lpGTBEntry,                /* NewGTB Entry                */
            lpDCI );                   /* DC instance data            */

USHORT prdt_TextOutDevFont (
            HDC,
/*          USHORT,                CON3201 Command change to ULONG    */
            ULONG,                     /* Command parameter           */
            PPOINTL,                   /* Start position              */
            PRECTL,                    /* Opaque rectangle            */
            ULONG,                     /* Options                     */
            LONG,                      /* No of characters            */
            PCH,                       /* CodePoints                  */
            PLONG,                     /* PosVector                   */
            lpTextAttrsType,           /* Attributes                  */
            lpDCI,
            lpFontDataType );

SHORT prdt_TextOutDevOutlineFont (
            HDC,
/*          USHORT,                       CON3201 - command changed   */
            ULONG,                     /* Command parameter           */
            PPOINTL,                   /* Start position              */
            PRECTL,                    /* Opaque rectangle            */
            ULONG,                     /* Options                     */
            LONG,                      /* No of characters            */
            PCH,                       /* CodePoints                  */
            PLONG,                     /* PosVector                   */
            lpTextAttrsType,           /* Attributes                  */
            lpDCI,
            lpFontDataType );


USHORT prdt_TextOutEngFont (
            HDC,
/*          USHORT,                CON3201 Command change to ULONG    */
            ULONG,                     /* Command parameter           */
            PPOINTL,                   /* Start position              */
            PRECTL,                    /* Opaque rectangle            */
            ULONG,                     /* Options                     */
            LONG,                      /* No of characters            */
            PCH,                       /* CodePoints                  */
            PLONG,                     /* PosVector                   */
            lpTextAttrsType,           /* Attributes                  */
            lpDCI,
            lpFontDataType,
            ULONG);                    /* PD00462                     */

VOID prdt_ImageChar (
            PBYTE,
            DevRect *,
            POINTS,
            USHORT,
            USHORT,
            pBMListEntry,
            lpTextAttrsType );

VOID prdt_ImageCharGrey (            /* PD00462 */
            PBYTE,
            DevRect *,
            POINTS,
            USHORT,
            USHORT,
            pBMListEntry,
            lpTextAttrsType,
            PBYTE           );


ULONG far_get_vector_length( PPOINTL );

ULONG far_get_sqr_determinant( ULONG,
                                      ULONG,
                                      ULONG,
                                      ULONG );


USHORT prdt_SetUpFMF( BYTE,
                             lpFMFFileStruc,
                             lpMultiCpType,
                             lpFMFFileStruc);

USHORT prdt_ExpandMultiCpFMF( BYTE,
                                     lpFMFFileStruc,
                                     lpMultiCpType,
                                     lpFMFFileStruc);


SHORT prdt_TranslateChar   (
           BYTE,
           PUSHORT,
           USHORT );

VOID prdt_SimulateFont (
           lpFontDataType,
           USHORT );

VOID prdt_TranslateWidthTable (
           PUSHORT,
           PUSHORT,
           PUSHORT,
           USHORT,
           USHORT );

SHORT prdt_GetMultiCpFMFIndex( USHORT,
                                      lpMultiCpType);

USHORT prdt_GetCellInfo(                           /* PD00073 */
           lpDCI,
           lpFontDataType,
           USHORT,
           lpCellInfoType );

ULONG prdt_ScaleXMetricToDevice(                   /* PD00073 */
           lpDCI,
           lpFontDataType,
           LONG );

ULONG prdt_ScaleYMetricToDevice(                   /* PD00073 */
           lpDCI,
           lpFontDataType,
           LONG );

VOID prdt_RescaleCharBox(                          /* PD00073 */
           lpDCI,
           XFORM,
           XFORM );

BYTE prdt_ValidateCodePoint (                      /* PD00073 */
           BYTE,
           lpFontDataType,
           lpDCI );

VOID prdt_GetStrikeoutRect (                       /* PD00073 */
           POINTL,
           USHORT,
           USHORT,
           LONG,
           LONG,
           USHORT,
           PFOURPOINTL );

USHORT prdt_FillRectangle(                         /* PD00073 */
           HDC,
           DevRect *,
           BYTE,
/*         USHORT,    CON3201 changed Command parameter to ULONG */
           ULONG,
           lpDCI );

USHORT prdt_SetupStringInfoMemory(                 /* PD00073 */
           lpStringInfoType,
           USHORT,
           LONG,
           lpDCI );

USHORT prdt_GetStringInfoDevice(                   /* PD00073 */
           HDC,
           lpDCI,
           lpFontDataType,
           LONG,
           PBYTE,
           lpStringInfoType,
           lpCellInfoType,
           USHORT,
           USHORT,
           USHORT,
           lpStringInfoType);

USHORT prdt_GetStringInfoWorld(                    /* PD00073 */
           lpDCI,
           PPOINTL,                                       /* PD00790 */
           ULONG,
           LONG,
           PBYTE,
           PLONG,
           lpFontDataType,
           lpStringInfoType,
           lpCellInfoType,
           USHORT );

USHORT prdt_GetPrinterParameters(                  /* PD00073 */
           HDC,
           lpDCI,
           PSHORT,
           PSHORT );

USHORT prdt_AdjustForAngles(                       /* PD00073 */
           USHORT,
           POINTL,
           lpDCI,
           PPOINTL,
           lpFontDataType);                               /* PD00559 */
