/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDTCONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Text Constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* Font Types.                                                        */
/**********************************************************************/
#define FT_RESIDENT              1     /* resident font               */
#define FT_CODE_PAGE             2     /* code page font              */
#define FT_CARD                  3     /* card/cartridge font         */
#define FT_DOWNLOAD              4     /* download font               */
#define FT_ENGINE                5     /* engine font                 */
#define FT_MARKER                6     /* marker font                 */
#define FT_PRINTER_CODES         7     /* Printer Control codes only  */

#define DEVICE_FONT              1     /* device font                 */
#define NON_DEVICE_FONT          0     /* engine or dflt marker font  */
#define ENG_DOWNLD_FONT          2     /* engine download font        */

/**********************************************************************/
/* Constant for the default marker font.                              */
/**********************************************************************/
#define DFLT_MARKER_FONT         0x1000

/**********************************************************************/
/* Attributed font types                                              */
/**********************************************************************/
//#define MAX_FONT_ATTRIBUTE      12

//#define FATT_NONE                0
//#define FATT_DOUBLE_WIDE         1
//#define FATT_DOUBLE_HIGH         2
//#define FATT_D_WIDE_D_HIGH       3
//#define FATT_EMPHASIZE           4
//#define FATT_UNDERSCORE          5
//#define FATT_EMPH_D_WIDE         6
//#define FATT_EMPH_D_HIGH         7
//#define FATT_EMPH_D_WIDE_D_HIGH  8
//#define FATT_EMPH_UNDERSCORE     9
//#define FATT_DS_D_WIDE          10
//#define FATT_DS_UNDERSCORE      11
//#define FATT_DS                 12

/**********************************************************************/
/* FONT ATTRIBUTE FLAGS.  Used to set up the attributes supported by  */
/* each resident font.  First the device attributes ...               */
/**********************************************************************/
#define FATT_NONE           0x0000
#define FATT_DOUBLE_WIDE    0x0001
#define FATT_DOUBLE_HIGH    0x0002
#define FATT_BOTH           0x0003

/**********************************************************************/
/* FONT ATTRIBUTE FLAGS continued ... now the availablity of engine   */
/* attributes. If these flags are set then the bold and italic        */
/* escape sequences are issued.                                       */
/**********************************************************************/
#define FATT_BOLD           0x4000
#define FATT_ITALIC         0x8000

/**********************************************************************/
/* FONT ATTRIBUTE FLAGS continued ... several ways to get bold on a   */
/* font basis; EMPHASIZE or DOUBLE_STRIKE. One bit controls this.     */
/**********************************************************************/
#define FATT_BOLD_EMP       0x0800
#define FATT_BOLD_DS        0x0000

/**********************************************************************/
/* Constant used for prompting for putting cards in slots.            */
/**********************************************************************/
#define NO_CARD_IN_SLOT         -1

/**********************************************************************/
/* Code Page capabity types                                           */
/**********************************************************************/
#define CP_RESIDENT              0
#define CP_PSEU_RES              1
#define CP_DOWNLOAD              2
#define CP_RESOURCE              3
#define CP_NOT_AVAIL             4

/**********************************************************************/
/* Indices into the Code Page Caps and List arrays.                   */
/**********************************************************************/
#define CP_437_INDEX             0
#define CP_850_INDEX             1

/**********************************************************************/
/* Downloaded code page constants.                                    */
/**********************************************************************/
#define NO_CODE_PAGE            -1
#define DRAFT_CODE_PAGE          1
#define FASTFONT_CODE_PAGE       2

/**********************************************************************/
/* Use of FMF file flags.                                             */
/**********************************************************************/
#define DUMMY_FMF                0
#define VALID_FMF                1

/**********************************************************************/
/* Offsets for info in FMF files and value used in FMF file to        */
/* indicate that it is a dummy.                                       */
/**********************************************************************/
#define DUMMY_FMF_CHECK_BYTE     0
#define DUMMY_FMF_RES_INDEX      1
#define DUMMY_FMF_NO_OF_PAIRS    2
#define DUMMY_FMF_NO_OF_PAIRS_FC 3

#define DUMMY_FMF_CHECK_VALUE_FF    0xFF
#define DUMMY_FMF_CHECK_VALUE_FE    0xFE
#define DUMMY_FMF_CHECK_VALUE_FC    0xFC

/**********************************************************************/
/* Sizes of FMF files.                                                */
/* 4019 Merge Note : Different sizes for 4019.                        */
/**********************************************************************/
#define FMF_SIZE_FIXED_PITCH   184
#define FMF_SIZE_PROP_SPACED   724

/**********************************************************************/
/* Sizes of the initial part of 4019 FMFs and CDFs that matches       */
/* Pro & Q FMFs and CDFs, and of the final part of 4019 FMF for       */
/* PS fonts.                                                          */
/**********************************************************************/
#define FMF_SIZE_4019_COMMON   182
#define CDF_SIZE_4019_COMMON   13
#define FMF_SIZE_4019_RESIDUE    FMF_SIZE_PROP_SPACED                  \
                               - FMF_SIZE_FIXED_PITCH


/**********************************************************************/
/* Selection codes used for the size modifer in the Set Font Global   */
/* command.                                                           */
/**********************************************************************/
#define FIXED_PITCH              1
#define PROPORTIONAL             2
#define TYPOGRAPHIC              3

/**********************************************************************/
/* The top bit of the width field in the FMF indicates whether        */
/* this is an FMF for the 4019 or not - this mask takes out the top    */
/* bit so the width field can be used to give the real width value.   */
/**********************************************************************/
#define FMF_WIDTH_MASK           0x7FFF

/**********************************************************************/
/* Constants used in text xform functions.                            */
/**********************************************************************/
#define FONT_TO_DEVICE           0x0001
#define DEVICE_TO_FONT           0x0002

#define FONT_TO_WORLD            0x0010
#define WORLD_TO_FONT            0x0020
#define DEVICE_TO_WORLD          0x0040
#define WORLD_TO_DEVICE          0x0080

#define CONV_X_VALUE             0x0100
#define CONV_Y_VALUE             0x0200

#define KEEP_ORIGIN_SHIFT        0x1000
#define IGNORE_ORIGIN_SHIFT      0x2000
#define IGNORE_SHEAR             0x4000
/**********************************************************************/
/* PD00081 : new constant for getXformMatrix                          */
/**********************************************************************/
#define DIAGONALIZE              0x8000

/**********************************************************************/
/* Map table constants.                                               */
/**********************************************************************/
#define CPT_ROOT_SIZE_850    332
#define CPT_ROOT_SIZE_437    332
#define CPT_ROOT_SIZE_500    332
#define CPT_MAP_TABLE_SIZE   3
#define CPT_MAP_SIZE         332

/**********************************************************************/
/* Constants for outline fonts string Info      PD00073               */
/**********************************************************************/
#define GSI_CHARPOS   0x0001  /* return start positions of each character */
#define GSI_PRINTPOS  0x0002  /* return print positions of each character */
#define GSI_CELL      0x0004  /* return character cells                   */
#define GSI_TEXTBOX   0x0008  /* return string box                        */
#define GSI_STRIKEOUT 0x0010  /* return strikeout rectangles              */
#define GSI_UNDERLINE 0x0020  /* return underline rectangle               */
#define GSI_RELATIVE  0x0040  /* return points relative to StartPos       */
#define GSI_ALL       0x007F  /* all options                              */


