/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDSTYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver ScanLine types and constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/**********************************************************************/
/* Values if the flags field                                          */
/**********************************************************************/
#define    SCAN_ROW_IN_SEG       0x0001
#define    SCAN_MIXES_SAME       0x0002
#define    SCAN_MIXES_OVERPAINT  0x0004

typedef struct
{
    /******************************************************************/
    /* 1. These 16 bytes define the row that is being written to and  */
    /* how it should be written.                                      */
    /******************************************************************/
    ULONG        ulStart;
    ULONG        ulEnd;
    USHORT       usBytes;
    USHORT       usFlags;
    USHORT       usFGMix;
    USHORT       usBGMix;

    /******************************************************************/
    /* 2. The remaining bytes define the pel co-ordinates of a scan   */
    /* line and the first and last DWORD masks.                       */
    /******************************************************************/
    POINTS       ptsStart;
    POINTS       ptsEnd;
    ULONG        ulTrgRow;
    USHORT       usTrgInc;
    PBYTE        pBMBaseAddr;
/*  USHORT       usBMSelector;  The above line will replace this line CON3201 */
    USHORT       usXOrigin;
    USHORT       usYOrigin;
} ScanType;

typedef ScanType * pScanType;

