/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDMCONE
 *
 * DESCRIPTIVE NAME = Printer Device Driver Device Mode constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <prdmdlgs.h>

/******************************************************************************/
/*  Define ID's for strings in message table - these are used to indicate     */
/*  printer error conditions to the user with SplMessageBox.                  */
/******************************************************************************/
#define IDM_PAPEROUT             1
#define IDM_NOT_RESPONDING       2
#define IDM_IO_ERROR             3
#define IDM_DEF_MSG              4
#define IDM_PAPEROUT_2           5
#define IDM_NOT_RESPONDING_2     6
#define IDM_IO_ERROR_2           7
#define IDM_DEF_MSG_2            8

/******************************************************************************/
/*  Define ID's for strings in used in WinMessgaeBox calls.  The corresponding*/
/*  strings are declared in the resources (.RC) file so that they can be      */
/*  translated.                                                               */
/******************************************************************************/
#define IDS_SMB_CAPTION            1
#define IDS_JOB_SETUP_CAPTION      2
#define IDS_PP_SETUP_CAPTION       3
#define IDS_FIRST_PRINTER         10   /* #1 These values must match          */
#define IDS_SMB_PRO_I             10   /* #1 These values must match          */
#define IDS_SMB_PRO_II            11
#define IDS_SMB_PRO_III           12
#define IDS_SMB_PRO_XL            13
#define IDS_SMB_PRO_II_XL         14
#define IDS_SMB_PRO_III_XL        15
#define IDS_SMB_PRO_X24           16
#define IDS_SMB_PRO_X24E          17
#define IDS_SMB_PRO_XL24          18
#define IDS_SMB_PRO_XL24E         19
#define IDS_SMB_4224_COLOR        20
#define IDS_SMB_4224_MONO         21
#define IDS_SMB_2380              22
#define IDS_SMB_2381              23
#define IDS_SMB_2390              24
#define IDS_SMB_2391              25
#define IDS_SMB_4226              26
#define IDS_SMB_2390_PS1          27   /* INKJET                              */
#define IDS_SMB_EXECJET           28   /* INKJET                              */
#define IDS_SMB_PRONTO            29   /* INKJET                              */
#define IDS_SMB_QUIET_III         10   /* #1 These values must match          */
#define IDS_SMB_QUICK             11
#define IDS_SMB_3816_SIMPLEX      12
#define IDS_SMB_3816_DUPLEX       13
#define IDS_SMB_4019LASER         10   /* #1 These values must match          */
#define IDS_SMB_4019LASER_E       11
#define IDS_SMB_HERITAGE          12
#define IDS_SMB_HERITAGE_E        13
#define IDS_SMB_HERITAGE_L        14   /* PD00157...                          */
#define IDS_SMB_HERITAGE_P        15   /* PD00157...                          */
#define IDS_SMB_HERITAGE_6P       16   /* PD00640...                          */
#define IDS_SMB_HERITAGE_10P      17   /* PD00640...                          */
#define IDS_IN_PROGRESS           32   /* INKJET ID number conflicted with    */
                                       /* PRONTO_PS1-changed from 30 to 32    */
#define IDS_CONFIRM_CANCEL        31
#define IDS_CANT_COPY             35
#define IDS_PATH_NOT_FOUND        36
#define IDS_FILE_NOT_FOUND        37
#define IDS_DRIVE_NOT_FOUND       38
#define IDS_GENERAL_FILE_ERROR    39
#define IDS_DELETE_PRE            40
#define IDS_CONFIRM_DELETE        41
#define IDS_CHANGE_PREDEF         42
#define IDS_FORM_SIZES            43
#define IDS_INV_FORM_NAME         51
#define IDS_SAME_NAME             52
#define IDS_NO_DIMENSION          53
#define IDS_INVALID_INPUT         54
#define IDS_INVALID_CLIP          55
#define IDS_HORZ_CLIP_OVERLAP     56
#define IDS_VERT_CLIP_OVERLAP     57
#define IDS_TOP_MARGIN_OVERLAP    58
#define IDS_TOP_MARGIN_OVERLAP2   59
#define IDS_INCHES                60
#define IDS_MILLIMETERS           61
#define IDS_RIGHT_MARG_OVERLAP    62
#define IDS_RIGHT_MARG_OVERLAP2   63
#define IDS_CLIP_IN_UNPRINT       64
#define IDS_INSERT_FORM_1         65
#define IDS_INSERT_FORM_2_PRO     66
#define IDS_INSERT_FORM_2_4224    67
#define IDS_INSERT_FORM_2_Q       68
#define IDS_INSERT_FORM_2_4070    69   /* PD00743                             */
#define IDS_FORM_0                70
#define IDS_FORM_1                71
#define IDS_FORM_2                72
#define IDS_FORM_3                73
#define IDS_FORM_4                74
#define IDS_FORM_5                75
#define IDS_FORM_6                76
#define IDS_FORM_7                77
#define IDS_FORM_8                78
#define IDS_FORM_9                79
#define IDS_FORM_10               80
#define IDS_FORM_11               81
#define IDS_FORM_12               82
#define IDS_FORM_13               83
#define IDS_FORM_14               84
#define IDS_FORM_15               85
#define IDS_FORM_16               86
#define IDS_FORM_17               87
#define IDS_PAPER_TRAY            90
#define IDS_PAPER_TRAY_1          91
#define IDS_PAPER_TRAY_2          92
#define IDS_TRACTOR_FEED          93
#define IDS_PINWHEEL_FEED         94
#define IDS_ENVELOPE              95
#define IDS_MANUAL_PAPER          96
#define IDS_MANUAL_ENVELOPE       97
#define IDS_MULTIMEDIA            98
#define IDS_100_SHEET             99
#define IDS_CONTINUOUS_FORMS     100
#define IDS_DOC_ON_DEMAND        101
#define IDS_DOC_INS_PAPER        102
#define IDS_DOC_INS_ENVELOPE     103
#define IDS_BIN_1                104
#define IDS_BIN_2                105
#define IDS_BIN_3                106
#define IDS_BIN_4_PAPER          107
#define IDS_BIN_4_ENVELOPE       108
#define IDS_CARD_DFLT_GONE_1     110
#define IDS_CARD_DFLT_GONE_2     111
#define IDS_CARD_DFLT_GONE_3     112
#define IDS_SYS_FONT             113
#define IDS_OUTLINE_GONE1        114   /* PD00136...                          */
#define IDS_OUTLINE_GONE2        115   /* PD00136...                          */
#define IDS_CODE_PAGE_437        120
#define IDS_CODE_PAGE_850        121
#define IDS_CODE_PAGE_851        122
#define IDS_CODE_PAGE_852        123
#define IDS_CODE_PAGE_853        124
#define IDS_CODE_PAGE_855        125
#define IDS_CODE_PAGE_862        126
#define IDS_CODE_PAGE_863        127
#define IDS_CODE_PAGE_864        128
#define IDS_CODE_PAGE_850_RES    129
#define IDS_DUP_CARD_NAME        131
#define IDS_NO_CDF               132
#define IDS_NO_PRINTER_CDF       133
#define IDS_INSERT_CARD          135
#define IDS_INTO_SLOT_1          136
#define IDS_INTO_SLOT_2          137
#define IDS_CARDFONT_PATH        138
#define IDS_DOWNFONT_PATH        139
#define IDS_INSUF_MEM            140
#define IDS_DOWN_REMOVED         141
#define IDS_CANT_NO_COPY_FMF     142
#define IDS_NO_DOWN_PAIR         143
#define IDS_NO_PRINTER_FMF       144
#define IDS_NO_FMF               145
#define IDS_CANT_COPY_FMF        146
#define IDS_CANT_COPY_DLF        147
#define IDS_CREATE_NEW_DIR       148
#define IDS_INVALID_DIRNAME      149
#define IDS_FATT_DOUBLE_WIDE     150
#define IDS_FATT_DOUBLE_HIGH     151
#define IDS_FATT_BOLD            152
#define IDS_QUALITY_PRINT_ALT    159
#define IDS_PRINT_MODE_OFFSET    160   /* The difference between the print    */
#define IDS_DRAFT_PRINT          161   /* quality values and the offset is    */
#define IDS_QUALITY_PRINT        162   /* used in the code                    */
#define IDS_ENHANCED_PRINT       163
#define IDS_SPOOL_FILE_STD       165
#define IDS_SPOOL_FILE_RAW       166
#define IDS_SPOOL_FILE_FORCED    167
#define IDS_SPOOL_FILE_PREVIOUS  168
#define IDS_CP_NOT_SELECTED      170
#define IDS_ADD_NOT_SUPPORTED    171
#define IDS_CP_NOT_SUPPORTED     172
#define IDS_CODE_PAGE_GONE       173
#define IDS_CODE_PAGE_REMOVED    174
#define IDS_FORM_IN_SOURCE       180
#define IDS_LEFT_IN_MARG         181
#define IDS_LEFT_IN_MARG_2       182
#define IDS_PAPER_TEXT           183
#define IDS_ENV_TEXT             184
#define IDS_NO_DFLT_FONT_MEM     185
#define IDS_FONTS_NOT_LOCATED    186
#define IDS_DFLT_PT_SIZE         187   /* PD00128                             */
#define IDS_UNPACK_FAIL          188   /* PD00329                             */
#define IDS_PRINTER_PATTERNS     189   /* PD00769                             */

/******************************************************************************/
/*  DRV_INSTALL return codes.  Define ID's for strings in used in             */
/*  WinMessgaeBox calls.                                                      */
/******************************************************************************/

#define IDS_INV_DEVICENAME       190
#define IDS_CONVERSION_DONE      191
#define IDS_CONVERSION_ERR       192
#define IDS_INV_DEVICE_CONV      193
#define IDS_CONVERSION_DONE1     194
#define IDS_CONVERSION_NO_BUFFER 195
#define IDS_CONVERSION_ERR_OLD   196
#define IDS_CONVERSION_COMP      197
#define IDS_INV_DFLT_PRINTER     198
#define IDS_CONVERSION_ERR_OLD2  199

/******************************************************************************/
/*  Memory option strings for listbox - must be consecutive                   */
/******************************************************************************/
#define IDS_MOH_OPT_0            200
#define IDS_MOH_OPT_1            201
#define IDS_MOH_OPT_2            202
#define IDS_MOH_OPT_3            203
#define IDS_MOH_OPT_4            204
#define IDS_MOH_OPT_5            205
#define IDS_MOH_OPT_6            206
#define IDS_MOH_OPT_8            207
#define IDS_MOH_OPT_35           208

/******************************************************************************/
/*  Help Error Messages                                                       */
/******************************************************************************/
#define IDS_HELP_NOT_AVAILABLE   220
#define IDS_HELP_NOT_AVAILABLE2  221
#define IDS_HELP_NOT_AVAIL_3A    218
#define IDS_HELP_NOT_AVAIL_3B    219

/******************************************************************************/
/*  Help titles defined                                                       */
/******************************************************************************/
#define IDS_HELP_PANEL_TITLE     223
#define IDS_HELP_FILE            224

/******************************************************************************/
/*  Maximum path length for a file - this is an OS/2 restriction.             */
/******************************************************************************/
#define MAX_PATH                  64

/******************************************************************************/
/*  Menu constant used in resources file.                                     */
/******************************************************************************/
#define PMENU                    100

/******************************************************************************/
/*  Constants used in DMSettings structure                                    */
/******************************************************************************/
#define NO_INDEX_SELECTED       0xFFFF /* e.g. initial code page or cartridge */
                                       /* in slot                             */
#define PORTRAIT_MODE            0
#define LANDSCAPE_MODE           1
#define FF_NONE_MODE             0
#define FF_COMPULSORY_MODE       1
#define FF_CONDITIONAL_MODE      2
#define RESOLUTION_0             0
#define RESOLUTION_1             1
#define RESOLUTION_2             2
#define RESOLUTION_3             3
#define RESOLUTION_4             4                 /* 600DPI */
#define FD_NONE                  0
#define FD_ENVELOPE              1
#define FD_MULTIMEDIA            2
#define FD_100_SHEET             3
#define DOWN_CP_MEM_NOT_AVAIL    0
#define DOWN_CP_MEM_AVAIL        1
#define DEV_FONTS_AVAIL          0
#define DEV_FONTS_NOT_AVAIL      1
#define DEV_FONTS_AVAIL_2        2                                 /* PD00604 */
#define DEV_FONTS_LIMITED        0                                 /* PD00604 */
#define DONT_RELOAD_EACH_JOB     0
#define RELOAD_EACH_JOB          1

/******************************************************************************/
/*  flag - stored in INI file.  NB DriverData has new field.                  */
/******************************************************************************/
#define DUPLEX_FLAG             0x10
#define DUPLEX_MODE_SIMPLEX        0
#define DUPLEX_MODE_NORMAL         1
#define DUPLEX_MODE_TUMBLE         2

/******************************************************************************/
/*  Values used and returned by prdm_CheckFileOKForPrinter                    */
/******************************************************************************/
#define FILE_OK_FOR_PRINTER      1
#define FILE_NOT_FOR_PRINTER     2
#define FILE_NOT_OLD_STYLE_CARSON    0x80
#define FILE_FOR_PRO             0
#define FILE_FOR_Q               1
#define FILE_FOR_4019            2
#define FILE_FOR_9_WIRE          0
#define FILE_FOR_24_WIRE         1
#define FILE_FOR_4224            2
#define FILE_FOR_4072            6                        /*  INKJET  */
#define FILE_FOR_LASER           0
#define FILE_FOR_HERITAGE        1
#define FMF_CHECK_BYTE         181
#define CDF_CHECK_BYTE          12

/******************************************************************************/
/*  Masks used when reading FMF and CDF files.                                */
/******************************************************************************/
#define FMF_WIDTH_FLAG_MASK      0x7F
#define CDF_NO_OF_FMFS_MASK      0x7F
#define DRIVER_TYPE_MASK         0x0F
#define PRINTER_TYPE_MASK        0x0F
#define FMF_ENHANCED_FONT        0x80
#define FMF_QUALITY_FONT         0x40
#define FMF_DRAFT_FONT           0x20
#define FMF_NAME_LENGTH          12
#define FMF_STYLE_CHECK_BYTE     181
#define CDF_STYLE_CHECK_BYTE     12

/******************************************************************************/
/*  Return values from CheckFileExists.                                       */
/******************************************************************************/
#define FILE_FOUND               1
#define FILE_NOT_FOUND           2
#define PATH_NOT_FOUND           3

/******************************************************************************/
/*  Return values from CopyDownFontFiles                                      */
/******************************************************************************/
#define FMF_COPY_FAILED          2
#define DLF_COPY_FAILED          3

/******************************************************************************/
/*  Maximum size of chunk moved in a file copy.                               */
/******************************************************************************/
#define MAX_READ_LENGTH          0xFFF0

/******************************************************************************/
/*  Search strings.                                                           */
/******************************************************************************/
#define CDF_EXTENSION             (PSZ)".CDF"
#define FMF_EXTENSION             (PSZ)".FMF"
#define DLF_EXTENSION             (PSZ)".DLF"
#define BIN_EXTENSION             (PSZ)".BIN"
#define ANY_FILENAME              (PSZ)"*.*"

/******************************************************************************/
/*  Constants associated with search strings.                                 */
/******************************************************************************/
#define CARD_NAME_LENGTH         7
#define EXTENSION_LENGTH         5

/******************************************************************************/
/*  Constants used to indicate refresh action used for card lists             */
/******************************************************************************/
#define OWNED_ADDED              0
#define OWNED_DELETED            1

/******************************************************************************/
/*  Constants used to flag changes in data to prde_FillPdb                    */
/******************************************************************************/
#define OWNED_LIST_CHANGE        0x0001
#define DFLT_FONT_CHANGE         0x0002
#define DOWN_FONT_ADDED          0x0010
#define DOWN_FONT_REMOVED        0x0020
#define DOWN_FONT_RELOAD         0x0040                      /* PD00443 */
#define CODE_PAGE_LIST_CHANGE    0x0100
#define FIRST_DIRECT_DC          0x0200
#define CODE_PAGE_INIT_RELOAD    0x1000
#define INITIAL_DOWN_FONT_LOAD   0x2000

/******************************************************************************/
/*  Flags to identify which source is current.  The values for automatic trays*/
/*  are used as indices into an array and so must start at 0.                 */
/******************************************************************************/
#define CS_NONE                 -1
#define CS_PAPER_TRAY_1          0     /* Automatic trays                     */
#define CS_PAPER_TRAY_2          1
#define CS_PAPER_TRAY_3          2
#define CS_MULTIMEDIA            2     /* NB same as paper tray 3             */
#define CS_TRACTOR_FEED          3
#define CS_100_SHEET             3
#define CS_ENVELOPE_TRAY         4
#define CS_MANUAL_PAPER          5     /* Manual "trays"                      */
#define CS_MANUAL_ENVELOPE       6

/******************************************************************************/
/*  Form numbers of the default forms                                         */
/******************************************************************************/
#define DEFAULT_PAPER_FORM_US             0
#define DEFAULT_PAPER_FORM_NONUS          3
#define DEFAULT_ENVELOPE_FORM_US          9
#define DEFAULT_ENVELOPE_FORM_NONUS      10
#define DEFAULT_ENVELOPE_FORM_US_4019     8
#define DEFAULT_ENVELOPE_FRM_NONUS_4019   9

/******************************************************************************/
/*  Define field lengths used in the INI file header data.  Any change to     */
/*  these values, or to the DMSettings structure which "maps onto" the header */
/*  data, must be reflected in HEADER_LENGTH and the offset constants declared*/
/*  below.                                                                    */
/******************************************************************************/
#define PRINTER_TYPE_LENGTH      2
#define ORIENTATION_LENGTH       1
#define RESOLUTION_LENGTH        1
#define FORM_FEED_LENGTH         1
#define SPOOL_INDEX_LENGTH       1
#define NO_FORM_CNT_DIGITS       3
#define NO_FONT_CNT_DIGITS       3
#define NO_CODE_PAGE_DIGITS      2
#define NO_MEM_OPT_DIGITS        2
#define NO_DEF_SOURCE_DIGITS     1
#define PADDING_LENGTH           24    /* for future expansion                */
                                       /* PD00137                             */
                                       /* PD00277                             */
                                       /* PD00304  correct for previous       */
                                       /*          blunder, should be 4       */
                                       /* PD00285 add 21 to padding length    */
                                       /* PD00769 Reduced padding to 24     */
#define PATHNAME_SIZE_LENGTH     2
#define NO_DATA_SIZE_DIGITS      5
#define NO_INFO_SIZE_DIGITS      2
#define NO_SOURCE_CNT_DIGITS     2
#define NO_INDEX_DIGITS          3
#define NO_POINTSIZE_DIGITS      2     /* PD00137                             */

/******************************************************************************/
/*  DMSettings / INI file values for compression (4019)                       */
/******************************************************************************/
#define COMPRESS_NONE            0
#define COMPRESS_G4              1
#define COMPRESS_BYTE            2

/******************************************************************************/
/*  Byte sent to 4019 for compression modes.                                  */
/******************************************************************************/
#define COMPRESS_CODE_NONE       0
#define COMPRESS_CODE_G4         2
#define COMPRESS_CODE_BYTE       17

/******************************************************************************/
/*  Offsets to get information out of INI file                                */
/******************************************************************************/
#define HEADER_LENGTH           98     /* Total length of header.  That is, in*/
                                       /* effect, the body data offset.       */
                                       /* PD00285 Added 21 bytes to header len*/
#define OFF_SOURCE_INDEX        12
#define OFF_SELECTED_FORM       15
#define OFF_NUMBER_OF_FORMS     18
#define OFF_SOURCE_DATA_SIZE    74     /* PD00285: increase from 53           */
#define OFF_OWNED_CARD_COUNT    24

/******************************************************************************/
/*  Length constants for the default font entry in the INI file body data.    */
/******************************************************************************/
#define DFLTFONT_SOURCE_LEN      1
#define DFLTFONT_INDEX_LEN       5
#define DFLTFONT_POS_IN_SRC_LEN  3
#define DFLTFONT_CARDNAME_LEN    8
#define DFLTFONT_ENGINE_LEN      DFLTFONT_SOURCE_LEN
#define DFLTFONT_RESIDENT_LEN    ( DFLTFONT_SOURCE_LEN  +              \
                                   DFLTFONT_INDEX_LEN )
#define DFLTFONT_CODE_PAGE_LEN   ( DFLTFONT_SOURCE_LEN  +              \
                                   DFLTFONT_INDEX_LEN   +              \
                                   DFLTFONT_POS_IN_SRC_LEN )
#define DFLTFONT_CARD_LEN        ( DFLTFONT_SOURCE_LEN     +           \
                                   DFLTFONT_POS_IN_SRC_LEN +           \
                                   DFLTFONT_CARDNAME_LEN )

/******************************************************************************/
/*  Length constants for the download font entry in the INI file body data.   */
/******************************************************************************/
#define TYPEFACE_LENGTH         32
#define CODEPAGE_LENGTH          5
#define POINTSIZE_LENGTH         5
#define DOWNTYPE_LENGTH          1
#define DOWNFILE_SIZE_HI_LEN     3
#define DOWNFILE_SIZE_LO_LEN     5
#define INI_DOWN_FXD_LENGTH      ( PATHNAME_SIZE_LENGTH +              \
                                   TYPEFACE_LENGTH      +              \
                                   CODEPAGE_LENGTH      +              \
                                   POINTSIZE_LENGTH     +              \
                                   DOWNTYPE_LENGTH      +              \
                                   DOWNFILE_SIZE_HI_LEN +              \
                                   DOWNFILE_SIZE_LO_LEN )
#define DM_DOWN_FXD_LENGTH       ( PATHNAME_SIZE_LENGTH +              \
                                   TYPEFACE_LENGTH      +              \
                                   CODEPAGE_LENGTH      +              \
                                   POINTSIZE_LENGTH )

/******************************************************************************/
/*  Download font load types                                                  */
/******************************************************************************/
#define INITIAL_DOWNLOAD         (BYTE)'I'
#define DYNAMIC_DOWNLOAD         (BYTE)'D'

/******************************************************************************/
/*  Decimal Point value used in INI file                                      */
/******************************************************************************/
#define ALT_POINT                (BYTE)'*'

/******************************************************************************/
/*  Other constants used to handle INI file entry.                            */
/******************************************************************************/
#define INCHES                   'I'
#define MM                       'M'
#define MAX_DEC_PLACES_INCHES    2
#define MAX_DEC_PLACES_MM        1
#define ENTER_BUF_LENGTH      1024
#define INVALID_INPUT            1

/******************************************************************************/
/*  Current INI file entry search mode.                                       */
/******************************************************************************/
#define S_GLOBAL                 0
#define S_NAME                   1
#define S_DATA                   2
#define S_PATH                   3

/******************************************************************************/
/*  Constants used when unpacking the initial metrics.                        */
/******************************************************************************/
#define WIDTH_INFO_SIZE         (512 + sizeof(FONTDEFINITIONHEADER))
#define CDF_FILE                 0
#define FMF_FILE                 1
#define MULTICP_FMF_FILE         2
#define METRICS_BUFFER_SIZE   2000     /* PD00288...                          */

/******************************************************************************/
/*  Constants for memory option listboxes (4019 only).  Note that 0.25 Mb is  */
/*  inbuilt.                                                                  */
/******************************************************************************/
#define MO_NONE_SIZE             0x040000  /* None                            */
#define MO_LBOX_MEM_1            0x140000  /* 1.00 Mbyte                      */
#define MO_LBOX_MEM_2            0x240000  /* 2.00 Mbyte                      */
#define MO_LBOX_MEM_35           0x3C0000  /* 3.50 Mbyte                      */
/******************************************************************************/
/*  Constants for memory option listboxes (4029 only).  Note that 0.50 Mb is  */
/*  inbuilt.  PD00087                                                         */
/******************************************************************************/
#define MO_4029_NONE_SIZE        0x080000  /* None                            */
#define MO_4029_LBOX_MEM_1       0x180000  /* 1.00 Mbyte                      */
#define MO_4029_LBOX_MEM_2       0x280000  /* 2.00 Mbyte                      */
#define MO_4029_LBOX_MEM_3       0x380000  /* 3.00 Mbyte                      */
#define MO_4029_LBOX_MEM_4       0x480000  /* 4.00 Mbyte                      */
#define MO_4029_LBOX_MEM_5       0x580000  /* 5.00 Mbyte                      */
#define MO_4029_LBOX_MEM_6       0x680000  /* 6.00 Mbyte                      */
#define MO_4029_LBOX_MEM_8       0x880000  /* 8.00 Mbyte                      */

/******************************************************************************/
/*  Constants for IniVersionType.                                             */
/******************************************************************************/
#define INI_VERSION_CURRENT      1
#define INI_VERSION_PREVIOUS     2
#define INI_VERSION_DONT_USE     3
#define INI_VERSION_4019_22X     4         /* PD00436                         */

/******************************************************************************/
/*  Default Font dialog error messages                                        */
/******************************************************************************/
#define FATAL_MEMORY_ALLOCATION_ERROR      1
#define SOME_FONTS_NOT_LOCATED             2

/******************************************************************************/
/*  Number of quality levels for Quiet III cartridge fonts.                   */
/******************************************************************************/
#define QUALITY_LEVELS                     3

/******************************************************************************/
/*  Number of Default Font Table entries to get when allocating memory        */
/******************************************************************************/
#define FONT_TABLE_INCREMENT               100

/******************************************************************************/
/*  Constant describing the max printer name length.  Must be as long as the  */
/*  longest printer name (in any language).  But this goes in in ArgDriverName*/
/*  parm in DEVQNAME.C which is 32 characters long.                           */
/******************************************************************************/
#define MAX_PRNTR_NAME      32
#define DRIVER_NAME_LEN      7

/******************************************************************************/
/*  DRV_INSTALL return codes.                                                 */
/******************************************************************************/

/******************************************************************************/
/*  Down load eng fonts.                                                      */
/******************************************************************************/
#define DL_SYS_FONTS         1
#define NO_DL_SYS_FONTS      0

/******************************************************************************/
/*  PD00136 : Disable Outline Fonts                                           */
/******************************************************************************/
#define DIS_OUTLINE_FONTS    1
#define EN_OUTLINE_FONTS     0

/******************************************************************************/
/*  DIAL/NILE : Constants for Extended NLS settings.                          */
/******************************************************************************/
#define NLS_MACHINE          1
#define US_MACHINE           2

/******************************************************************************/
/* PD00307 : Constants for old and new numbers of 4224 pre-defined forms      */
/******************************************************************************/
#define OLD_NO_OF_4224_FORMS  13
#define NEW_NO_OF_4224_FORMS  7

/******************************************************************************/
/* PD00769 :  Added constants for laser printer performance option            */
/******************************************************************************/
#define PRINTER_PATTERNS          2       /* ON or Checked                    */
#define NO_PRINTER_PATTERNS       1       /* OFF or UnChecked                 */

/******************************************************************************/
/* PD00769 :                                                                  */
/* The following constant is used at enable time when no driver data is       */
/* passed to enable or disable the use of printer patterns.  This constant    */
/* is also used in the printer properties and job properties dialogs to       */
/* check or uncheck the box for printer patterns when a value of 0 is read    */
/* from the ini for printer patterns.                                         */
/******************************************************************************/
#define PRINTER_PATTERNS_DEFAULT  2
