/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDETYPT
 *
 * DESCRIPTIVE NAME = Printer Device Driver Enable function Types
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


typedef long   ( *PFNL)();



/**********************************************************************/
/* Card Name and FMF name types.                                      */
/**********************************************************************/
typedef BYTE tCard[CARD_DATA_LENGTH];

typedef tCard *lpCard;

typedef BYTE FMFNameType[FILENAME_SIZE];

typedef FMFNameType *lpFMFName;


/**********************************************************************/
/* Types for CDF files.                                               */
/**********************************************************************/
typedef struct
    {
        BYTE            SelIndex;
        FMFNameType     FMFName;
    } FMFEntryType;

typedef FMFEntryType *lpFMFEntry;

typedef struct
    {
        BYTE            CDFName[FILENAME_SIZE];
        BYTE            FMFCount;
        BYTE            DriverType;
        BYTE            PrinterType;
        FMFEntryType    FMFEntryArray[1];
    } CDFFileStrucType;

typedef CDFFileStrucType *lpCDFFileStruc;


/**********************************************************************/
/* Types for old CDF files.                                           */
/**********************************************************************/
typedef struct
    {
        FMFNameType     FMFName;
    } OldFMFEntryType;

typedef OldFMFEntryType *lpOldFMFEntry;

typedef struct
    {
        BYTE               CDFName[FILENAME_SIZE];
        BYTE               FMFCount;
        OldFMFEntryType    FMFEntryArray[1];
    } OldCDFFileStrucType;

typedef OldCDFFileStrucType *lpOldCDFFileStruc;


/**********************************************************************/
/* Card Font List Type.                                               */
/**********************************************************************/
typedef struct
    {
        PSZ             pCardName;       /* Pointer to the Card Name  */
                                         /* which contains the font   */
        lpFMFFileStruc  pFMFData;        /* Pointer to the FMF data   */
                                         /* for this font             */
        USHORT          SelIndex;        /* Index of the font in the  */

                                         /* card (counted from 0)     */
        USHORT          QualityLevel;    /* Draft/Quality/Enhanced -  */
                                         /* the metrics for diff.     */
                                         /* quality levels could be   */
                                         /* identical                 */
        lpMultiCpType  pMultiCp;         /* MultiCp FMF pointer       */
        lpEngAttrsType   pEngAttrs;   /* Pointer to Engine Attributes */
    } CardFontListType;

typedef CardFontListType *lpCardFontListType;


/**********************************************************************/
/* Card/Cartridge Slot Info type.                                     */
/**********************************************************************/
typedef struct
    {
        USHORT      OwnedCardIndex;    /* Index into list of owned    */
                                       /* cards (i.e. into CardData)  */
                                       /* for this card               */
        USHORT      FontIndex;         /* Index of the first font in  */
                                       /* this card into the list of  */
                                       /* all fonts in all owned      */
                                       /* cards - so in the range     */
                                       /*  ( 0, CardFontCount - 1 )   */
    } SlotIndexType;


/**********************************************************************/
/* Download Font List Type.                                           */
/**********************************************************************/
typedef struct
    {
        PSZ            pFontPath;      /* Path for font + metrics     */
                                       /*   files                     */
        PSZ            pFontName;      /* Filename for font + metrics */
                                       /*   files                     */
        lpFMFFileStruc pFMFData;       /* Pointer to FMF data         */
        BYTE           DownloadType;   /* Initial or Dynamic          */
        BYTE           FontId;         /*                             */
    } DownFontListType;

typedef DownFontListType *lpDownFontListType;




/**********************************************************************/
/* Type for Logical Printer Entry.                                    */
/**********************************************************************/
typedef struct PrtDtag
    {
        struct PrtDtag * PrtNextEntry;   /* Pointer to next entry */

        BYTE                 LPName[32];
        USHORT               PrinterType;    /* Current printer type  */
        lpDCTEntryType       lpDCT;          /* DCT for the current   */
                                             /* printer type          */
        USHORT               DataChange;     /* Bit flags for changes */

        USHORT               CardFontCount;  /* No. of card fonts -   */
                                             /* incl. quality levels  */
                                             /* excl. attributes      */
        lpCardFontListType   CardData;       /* Array of length       */
                                             /* CardFontCount with    */
                                             /* data for each font in */
                                             /* an owned card.        */
        SlotIndexType        SlotInfo[MAX_NO_OF_CARD_SLOTS];
                                             /* Info on cards in the  */
                                             /* slots                 */

        USHORT               DownFontCount;
        lpDownFontListType   DownFontData;

        USHORT               CodePageCount;  /* No of downloaded      */
                                             /* Code Pages - includes */
                                             /* 850 but not 437       */
        PSZ                  CPPathList[NO_OF_ADDABLE_CPS + 1];
                                             /* Path for BIN file -   */
                                             /* null if CP not added  */
                                             /* - dummy entry for 850 */
        USHORT               CPCurrent;      /* Current Code Page     */
        USHORT               CPQuality;      /* Code Page Quality     */
                                             /* (Draft or FastFont)   */
        USHORT               CPMemAvail;     /* Copy of the flag from */
                                             /* DMSettings used when  */
                                             /* changing code pages   */
        BYTE                 DfltMetricsPath[64];
                                             /* Default target path   */
                                             /* when copying metrics  */

        ULONG                Reserved;       /* For future expansion  */
   } PrtDataEntryType;

typedef PrtDataEntryType *lpPrtDataEntry;


/**********************************************************************/
/* Types for Global Card List.                                        */
/**********************************************************************/
typedef struct
    {
        USHORT           SelIndex;    /* Index of FMF in CDF          */
        lpFMFFileStruc   pFMFData;    /* FMF contents                 */
        lpMultiCpType    pMultiCp;    /* Multi-codepage FMF           */
        lpEngAttrsType   pEngAttrs;   /* Pointer to Engine Attributes */
    } FMFInfoType;

typedef FMFInfoType *lpFMFInfo;

typedef struct GCrdTag
    {
        struct GCrdTag *  GCrdNextEntry; /* Pointer to next entry */
        tCard                 CardName;      /* The name of the CDF   */
                                             /* file (with '\0' as    */
                                             /* terminator)           */
        BYTE                  NumberOfFonts; /* The number of FMFs in */
                                             /* the CDF               */
        FMFInfoType           FMFInfo[1];    /* Array of index and    */
                                             /* metrics pairs for     */
                                             /* each FMF              */
    } GlobalCardType;

typedef GlobalCardType *lpGlobalCard;


/**********************************************************************/
/* Global MultiCp Outline Codepage table type for Heritage printer    */
/**********************************************************************/
typedef struct
    {
        SHORT            cp;         /* Codepage number               */
        SHORT            CpType;     /* -1 = Resident in printer      */
                                     /*  0 = Non Resident in printer  */
        SHORT            CPVResId;   /* >0 CodePage Vector Resource ID*/
                                     /* =-1 for OS/2 supported pages  */
    } OutlineCodepageType;

typedef OutlineCodepageType *lpOutlineCodepages;

/**********************************************************************/
/* CPVType Sturcture used to read the CodePageVector data             */
/**********************************************************************/
typedef struct
   {
      USHORT            CodePage;      /* Codepage number (eg 437)    */
      BYTE              UWLType;       /* Reserved                    */
      USHORT            Index[256];    /* Indices into the UWL for    */
                                       /* building the width table    */
   } CPVType;
/**********************************************************************/
/* Global Non OS2 Heritage Code page table for code pages that        */
/* the Heritage printer supports that are not currently supported by  */
/* OS/2.                                                              */
/**********************************************************************/
typedef struct
    {
        SHORT            cp;         /* Codepage number               */
        SHORT            CPVResId;   /* CodePage Vector Resource ID   */
    } NonOS2CodePageType;
