/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *                            Lexmark Confidential
 *
 * SOURCE FILE NAME = PRDCONSE
 *
 * DESCRIPTIVE NAME = Printer Device Driver constants
 *
 *
 * VERSION
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/**********************************************************************/
/* FNULL is required for far pointer comparisons, so that the code is */
/* independent of memory model.                                       */
/**********************************************************************/
#define FNULL             0L

/**********************************************************************/
/* COORD_* are co-ordinate identifiers as used by convert.            */
/**********************************************************************/
#define COORD_WORLD            1       /* CVTC_WORLD                  */
#define COORD_MODEL            2       /* CVTC_MODEL                  */
#define COORD_DEFAULT_PAGE     3       /* CVTC_DEFAULTPAGE            */
#define COORD_PAGE             4       /* CVTC_PAGE                   */
#define COORD_DEVICE           5       /* CVTC_DEVICE                 */

#define COORD_FONT             6       /* internal to driver          */

#define COORD_TYPE_MASK        0x0F
#define COORD_WORD             0x10    /* modifier for 16 bit coords  */

#define COORD_DEVICE_WORD      (COORD_DEVICE | COORD_WORD)
#define COORD_WORLD_WORD       (COORD_WORLD | COORD_WORD)
#define COORD_FONT_WORD        (COORD_FONT | COORD_WORD)


/**********************************************************************/
/* Semaphore constants                                                */
/**********************************************************************/
#define AWAITCLEAR                 -1L
#define IMMEDIATE_RETURN            0L
#define UNOWNED                     0L

#define NO_OF_PRINTER_DEVICES        18       /* PD00636                */
#define MUTEX_SEMAPHORE_TABLE_SIZE   23       /* CON3201                */
/* CON3201 ***************************
#define RAM_SEMAPHORE_TABLE_SIZE   23
 *************************************/
/**********************************************************************/
/* Datatype codes                                                     */
/**********************************************************************/
#define IBMQSTD           0
#define IBMQRAW           2

/**********************************************************************/
/* Orientation codes                                                  */
/**********************************************************************/
#define PORTRAIT          0
#define LANDSCAPE         1

/**********************************************************************/
/* Dummy Parameter value                                              */
/**********************************************************************/
#define DUMMY_PARAMETER   0

/**********************************************************************/
/* Value used to indicate variable not initialised or set.            */
/**********************************************************************/
#define VALUE_NOT_SET    -1

/**********************************************************************/
/* Value used to indicate option not available                       */
/**********************************************************************/
#define NOT_AVAIL        -1

