/*
 *	fs/msdos/mmap.c
 *
 *	Written by Jacques Gelinas (jacques@solucorp.qc.ca)
 *	Inspired by fs/nfs/mmap.c (Jaon Tombs 15 Aug 1993)
 *
 *	msdos mmap handling
 */
#ifdef __IBMC__
#pragma strings(readonly)
#endif

#ifdef MODULE
#include <linux/module.h>
#endif

#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <string.h>                // Standard MS Visual C++ string.h

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/os2proto.h>
#endif

#include <linux/stat.h>
#include <linux/sched.h>
#ifndef OS2
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/shm.h>
#endif
#include <linux/errno.h>
#ifndef OS2
#include <linux/mman.h>
#include <linux/string.h>
#include <linux/malloc.h>
#include <asm/segment.h>
#include <asm/system.h>
#endif
#ifdef OS2
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_proto.h>
#endif

#include <linux/xmsdos_fs.h>

/*
 * Fill in the supplied page for mmap
 */
static unsigned long xmsdos_file_mmap_nopage(
	struct vm_area_struct * area,
	unsigned long address,
	unsigned long page,
	int error_code)
{
	struct inode * inode = area->vm_inode;
	unsigned int clear;
	int pos;
	long gap;	/* distance from eof to pos */

	address &= PAGE_MASK;
	pos = address - area->vm_start + area->vm_offset;

	clear = 0;
	gap = inode->i_size - pos;
	if (gap <= 0){
		/* mmaping beyond end of file */
		clear = PAGE_SIZE;
	}else{
		int cur_read;
		int need_read;
		struct file filp;
		if (gap < PAGE_SIZE){
			clear = PAGE_SIZE - gap;
		}
		filp.f_reada = 0;
		filp.f_pos = pos;
		need_read = PAGE_SIZE - clear;
		{
			unsigned long cur_fs = get_fs();
			set_fs (KERNEL_DS);
			cur_read = xmsdos_file_read (inode,__StackToFlat(&filp),(char*)page
				,need_read);
			set_fs (cur_fs);
		}
		if (cur_read != need_read){
			printk ("MSDOS: Error while reading an mmap file %d <> %d\n"
				,cur_read,need_read);
		}
	}
	if (clear > 0){
		memset ((char*)page+PAGE_SIZE-clear,0,clear);
	}
	return page;
}

struct vm_operations_struct xmsdos_file_mmap = {
	NULL,			/* open */
	NULL,			/* close */
	NULL,			/* unmap */
	NULL,			/* protect */
	NULL,			/* sync */
	NULL,			/* advise */
	xmsdos_file_mmap_nopage,/* nopage */
	NULL,			/* wppage */
	NULL,			/* swapout */
	NULL,			/* swapin */
};

/*
 * This is used for a general mmap of an msdos file
 * Returns 0 if ok, or a negative error code if not.
 */
int xmsdos_mmap(struct inode * inode, struct file * file, struct vm_area_struct * vma)
{
	if (vma->vm_flags & VM_SHARED)	/* only PAGE_COW or read-only supported now */
		return -EINVAL;
	if (vma->vm_offset & (inode->i_sb->s_blocksize - 1))
		return -EINVAL;
	if (!inode->i_sb || !S_ISREG(inode->i_mode))
		return -EACCES;
	if (!IS_RDONLY(inode)) {
		inode->i_atime = CURRENT_TIME;
		inode->i_dirt = 1;
	}

	vma->vm_inode = inode;
	inode->i_count++;
	vma->vm_ops = &xmsdos_file_mmap;
	return 0;
}


