/*
 *  linux/fs/msdos/dir.c
 *
 *  Written 1992,1993 by Werner Almesberger
 *
 *  Windows95/Windows NT compatible extended MSDOS filesystem
 *    by Gordon Chaffee Copyright (C) 1995
 *
 *  MS-DOS directory handling functions
 */

#ifdef __IBMC__
#pragma strings(readonly)
#endif

#ifndef OS2
#ifdef MODULE
#include <linux/module.h>
#endif
#endif


#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <string.h>                // Standard MS Visual C++ string.h

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/fsh32.h>
#include <os2/os2proto.h>
#endif

#ifndef OS2
#include <asm/segment.h>
#endif

#ifndef OS2
#include <linux/kernel.h>
#endif

#include <linux/fs.h>

#ifdef OS2
#include <linux/ext2_fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_proto.h>
#endif

#include <linux/xmsdos_fs.h>
#include <linux/errno.h>
#include <linux/stat.h>

#ifndef OS2
#include <linux/string.h>
#endif

#include "msbuffer.h"

#ifdef DEBUG_LOG
extern char debug_com;
extern char debug_vfat_com;             // output VFAT debug info to COM port
#define KERNEL_PRINTF(x) { if (debug_vfat_com) kernel_printf(x);}
#else
#define KERNEL_PRINTF(x)
#endif

#define NAME_OFFSET(de) ((int) ((de)->d_name - (char *) (de)))
#define ROUND_UP(x) (((x)+3) & ~3)


#define PRINTK(x)

static int xmsdos_dir_read(struct inode * inode,struct file * filp, char * buf,int count)
{
	return -EISDIR;
}

static struct file_operations xmsdos_dir_operations = {
	NULL,			/* lseek - default */
	xmsdos_dir_read,	/* read */
	NULL,			/* write - bad */
	xmsdos_readdir,		/* readdir */
	NULL,			/* select - default */
	NULL,			/* ioctl - default */
	NULL,			/* mmap */
	NULL,			/* no special open code */
	NULL,			/* no special release code */
	file_fsync		/* fsync */
};

struct inode_operations xmsdos_dir_inode_operations = {
	&xmsdos_dir_operations,	/* default directory file-ops */
	xmsdos_create,		/* create */
	xmsdos_lookup,		/* lookup */
	NULL,			/* link */
	xmsdos_unlink,		/* unlink */
	NULL,			/* symlink */
	xmsdos_mkdir,		/* mkdir */
	xmsdos_rmdir,		/* rmdir */
	NULL,			/* mknod */
	xmsdos_rename,		/* rename */
	NULL,			/* readlink */
	NULL,			/* follow_link */
	xmsdos_bmap,		/* bmap */
	NULL,			/* truncate */
	NULL			/* permission */
};

static void dump_de(struct msdos_dir_entry *de)
{
	int i;
	unsigned char *p = (unsigned char *) de;
	printk("[");

	for (i = 0; i < 32; i++, p++) {
		printk("%02x ", *p);
	}
	printk("]\n");
}

int xmsdos_readdir(
	struct inode *inode,
	struct file *filp,
	struct dirent *dirent,	/* dirent in user space */
	int count)
{
	struct super_block *sb = inode->i_sb;
	int ino,i,i2,last;
	char c,*walk;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	struct msdos_dir_slot *ds;
	int is_long;
	int get_new_entry;
	char longname[256];
	unsigned char long_len = 0; /* Make compiler warning go away */
	unsigned char alias_checksum = 0; /* Make compiler warning go away */
	unsigned char offset;
	char conv;
#ifdef OS2
        int is_DosBox;
#endif
	if (!inode || !S_ISDIR(inode->i_mode)) return -EBADF;
KERNEL_PRINTF("xmsdos_readdir");
	conv = MSDOS_SB(sb)->name_check;
	if (inode->i_ino == MSDOS_ROOT_INO) {
/* Fake . and .. for the root directory. */
		if (filp->f_pos == 2) filp->f_pos = 0;
		else if (filp->f_pos < 2) {
			walk = filp->f_pos++ ? ".." : ".";
			for (i = 0; *walk; walk++)
#ifndef OS2
				put_fs_byte(*walk,dirent->d_name+i++);
			put_fs_long(MSDOS_ROOT_INO,&dirent->d_ino);
			put_fs_byte(0,dirent->d_name+i);
			put_fs_word(i,&dirent->d_reclen);
#else
                                *(dirent->d_name + i++) = *walk;
				dirent->d_ino = MSDOS_ROOT_INO;
                                *(dirent->d_name + i) = 0;
                                dirent->d_reclen   = i;
#endif
			return ROUND_UP(NAME_OFFSET(dirent) + i + 1);
		}
	}
	if (filp->f_pos & (sizeof(struct msdos_dir_entry)-1)) return -ENOENT;

#if 0
	{
		loff_t pos;
		for (bh = NULL, pos = 0; pos < 32;) {
			ino = xmsdos_get_entry(inode,&pos,&bh,&de);
			printk("pos: %d, ino: %d\n", pos-32, ino);
			dump_de(de);
		}
	}
#endif

	longname[0] = '\0';
	bh = NULL;
	is_long = 0;

#ifdef OS2
        is_DosBox = 0;
        {
                union  fsh32_qsysinfo_parms p;
                if (fsh32_qsysinfo(2, __StackToFlat(&p)) == NO_ERROR)
                        if (p.process_info.pdb)
                        {
                                is_DosBox = 1;
KERNEL_PRINTF("readdir called within DOS Box");                       
                        }

        }
#endif

	ino = xmsdos_get_entry(inode,&filp->f_pos,__StackToFlat(&bh),__StackToFlat(&de));
	while (ino > -1) {
if (de->attr & ATTR_VOLUME && debug_com) {
   int i;
   char bufname[13];
   char *ptname = bufname;

   for (i = 0; i < 13; i++) bufname[i] = 0;

   for (i = 0; i < 8; i++) {
     if (!(c = ptname[i] = de->name[i])) break;
     if (c >= 'A' && c <= 'Z') c += 32;
     ptname[i] = c;
   }
   kernel_printf("volume attribute found %s", __StackToFlat(bufname));
}

		/* Check for long filename entry */
		if (de->attr ==  ATTR_EXT) {
			unsigned char id;
			unsigned char slot;
			unsigned char slots = 0;
			int i;

			offset = 0;
			ds = (struct msdos_dir_slot *) de;
			id = ds->id;
			if (id & 0x40) {
				slots = id & ~0x40;
				is_long = 1;
				alias_checksum = ds->alias_checksum;
			}
			get_new_entry = 1;
			slot = slots;
			while (slot > 0) {
				PRINTK(("1. get_new_entry: %d\n", get_new_entry));
				if (ds->attr !=  ATTR_EXT) {
					is_long = 0;
					get_new_entry = 0;
					break;
				}
				if ((ds->id & ~0x40) != slot) {
					is_long = 0;
					break;
				}
				if (ds->alias_checksum != alias_checksum) {
					is_long = 0;
					break;
				}
				slot--;
				offset = slot * 13;
				PRINTK(("2. get_new_entry: %d\n", get_new_entry));

				for (i = 0; i < 10; i += 2) {
					if (ds->name0_4[i] == 0 && ds->name0_4[i] == 0) {
						goto found_end;
					}
					longname[offset++] = ds->name0_4[i];
				}
				for (i = 0; i < 12; i += 2) {
					if (ds->name5_10[i] == 0 && ds->name5_10[i] == 0) {
						goto found_end;
					}
					longname[offset++] = ds->name5_10[i];
				}
				for (i = 0; i < 4; i += 2) {
					if (ds->name11_12[i] == 0 && ds->name11_12[i] == 0) {
						goto found_end;
					}
					longname[offset++] = ds->name11_12[i];
				}
				found_end:

				PRINTK(("3. get_new_entry: %d\n", get_new_entry));
				if (ds->id & 0x40) {
					longname[offset] = '\0';
					long_len = offset;
				}

				if (slot > 0) {
					ino = xmsdos_get_entry(inode,&filp->f_pos,__StackToFlat(&bh),__StackToFlat(&de));
					PRINTK(("4. get_new_entry: %d\n", get_new_entry));
					if (ino == -1) {
						is_long = 0;
						get_new_entry = 0;
						break;
					}
					ds = (struct msdos_dir_slot *) de;
				}
				PRINTK(("5. get_new_entry: %d\n", get_new_entry));
			}
			PRINTK(("Long filename: %s, get_new_entry: %d\n", longname, get_new_entry));
#if 0
			if (!get_new_entry) {
				printk("Continuing\n");
				continue;
			}
#endif
		} else if (!IS_FREE(de->name) && !(de->attr & ATTR_VOLUME)) {
			char bufname[13];
			char *ptname = bufname;
			unsigned char sum;

			/* dump_de(de); */
			PRINTK(("msdos_readdir 1\n"));
			if (is_long) {
				for (sum = i = 0; i < 11; i++) {
					sum = (((sum&1)<<7)|((sum&0xfe)>>1)) + de->name[i];
				}

				if (sum != alias_checksum) {
					PRINTK(("Checksums don't match %d != %d\n", sum, alias_checksum));
					is_long = 0;
				}
			}
			for (i = last = 0; i < 8; i++) {
				if (!(c = de->name[i])) break;
				if (c >= 'A' && c <= 'Z') c += 32;
				if (c != ' ')
					last = i+1;
				ptname[i] = c;
			}
			i = last;
			ptname[i] = '.';
			i++;
			for (i2 = 0; i2 < 3; i2++) {
				if (!(c = de->ext[i2])) break;
				if (c >= 'A' && c <= 'Z') c += 32;
				if (c != ' ')
					last = i+1;
				ptname[i] = c;
				i++;
			}

			if ((i = last) != 0) {
				if (!strcmp(de->name,MSDOS_DOT))
					ino = inode->i_ino;
				else if (!strcmp(de->name,MSDOS_DOTDOT))
					ino = xmsdos_parent_ino(inode,0);

				bufname[i] = '\0';
#ifndef OS2
				put_fs_long(ino,&dirent->d_ino);
				if (!is_long) {
					memcpy_tofs(dirent->d_name,bufname,i+1);
					put_fs_word(i,&dirent->d_reclen);
#else
				dirent->d_ino = ino;
				if (is_DosBox || !is_long) {
					memcpy(dirent->d_name, bufname,i+1);
					dirent->d_reclen = i;
#endif
				} else {
#ifndef OS2
					memcpy_tofs(dirent->d_name,longname,long_len+1);
					put_fs_word(long_len,&dirent->d_reclen);
#else
					memcpy(dirent->d_name, longname,long_len+1);
#ifdef DEBUGLOG
if (debug_vfat_com) kernel_printf("short: %s\tlong: %s", __StackToFlat(bufname), __StackToFlat(longname));
#endif
					dirent->d_reclen = long_len;
#endif
				}
				PRINTK (("readdir avant brelse\n"));
				brelse(bh);

				PRINTK (("readdir retourne %d\n",i));
				return ROUND_UP(NAME_OFFSET(dirent) + i + 1);
			}
			is_long = 0;
		} else {
			is_long = 0;
			/* dump_de(de); */
		}
		ino = xmsdos_get_entry(inode,&filp->f_pos,__StackToFlat(&bh),__StackToFlat(&de));	
	}
	if (bh) brelse(bh);
	return 0;
}
