#ifdef __IBMC__
#pragma strings(readonly)
#endif

#ifdef MODULE
#include <linux/module.h>
#endif

#ifdef OS2
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <string.h>                // Standard MS Visual C++ string.h

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/os2proto.h>
#endif

#ifndef OS2
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/string.h>
#endif
#include <linux/fs.h>

#ifdef OS2
#include <linux/fs_proto.h>
#endif

#include <linux/xmsdos_fs.h>

#ifdef DEBUG_LOG
extern char debug_com;
extern char debug_vfat_com;
#define KERNEL_PRINTF(x) {if (debug_vfat_com) kernel_printf(x);}
#else
#define KERNEL_PRINTF(x)
#endif

struct buffer_head *xmsdos_bread (
	struct super_block *sb,
	int block)
{
	struct buffer_head *ret = NULL;
KERNEL_PRINTF("xmsdos_bread 1");

	if (sb->s_blocksize == 512){
KERNEL_PRINTF("xmsdos_bread 2");
		ret = bread (sb->s_dev,block,512);
KERNEL_PRINTF("xmsdos_bread 3");
	}else{
		struct buffer_head *real = bread (sb->s_dev,block>>1,1024);
KERNEL_PRINTF("xmsdos_bread 4");
		if (real != NULL){
#ifndef OS2
			ret = (struct buffer_head *)kmalloc (sizeof(struct buffer_head)
				,GFP_KERNEL);
			if (ret != NULL){
#else
KERNEL_PRINTF("xmsdos_bread 5");
      if (DevHlp32_VMAlloc(sizeof(struct buffer_head), VMDHA_NOPHYSADDR, VMDHA_SWAP, (void **)(__StackToFlat(&ret))) == NO_ERROR) {
KERNEL_PRINTF("xmsdos_bread 6");
#endif

				/* #Specification: msdos / strategy / special device / dummy blocks
					Many special device (Scsi optical disk for one) use
					larger hardware sector size. This allows for higher
					capacity.

					Most of the time, the MsDOS file system that sit
					on this device is totally unaligned. It use logically
					512 bytes sector size, with logical sector starting
					in the middle of a hardware block. The bad news is
					that a hardware sector may hold data own by two
					different files. This means that the hardware sector
					must be read, patch and written almost all the time.

					Needless to say that it kills write performance
					on all OS.

					Internally the linux msdos fs is using 512 bytes
					logical sector. When accessing such a device, we
					allocate dummy buffer cache blocks, that we stuff
					with the information of a real one (1k large).

					This strategy is used to hide this difference to
					the core of the msdos fs. The slowdown is not
					hidden though!
				*/
				/*
					The memset is there only to catch errors. The msdos
					fs is only using b_data
				*/
				memset (ret,0,sizeof(*ret));
				ret->b_data = real->b_data;
				if (block & 1) ret->b_data += 512;
				ret->b_next = real;
			}else{
KERNEL_PRINTF("xmsdos_bread 7");
				brelse (real);
KERNEL_PRINTF("xmsdos_bread 8");
			}
		}
	}
KERNEL_PRINTF("xmsdos_bread 9");
	return ret;
}

struct buffer_head *xmsdos_getblk (
	struct super_block *sb,
	int block)
{
	struct buffer_head *ret = NULL;

	if (sb->s_blocksize == 512){
		ret = getblk (sb->s_dev,block,512);
	}else{
		/* #Specification: msdos / special device / writing
			A write is always preceded by a read of the complete block
			(large hardware sector size). This defeat write performance.
			There is a possibility to optimize this when writing large
			chunk by making sure we are filling large block. Volunteer ?
		*/
		ret = xmsdos_bread (sb,block);
	}
	return ret;
}

void xmsdos_brelse (
	struct super_block *sb,
	struct buffer_head *bh)
{

	if (bh != NULL){
		if (sb->s_blocksize == 512){
			brelse (bh);
		}else{
			brelse (bh->b_next);
			/* We can free the dummy because a new one is allocated at
				each xmsdos_getblk() and xmsdos_bread().
			*/
#ifndef OS2
			kfree (bh);
#else
			DevHlp32_VMFree(bh);
#endif
		}
	}
}
	
void xmsdos_mark_buffer_dirty (
	struct super_block *sb,
	struct buffer_head *bh,
	int dirty_val)
{
	if (sb->s_blocksize != 512){
		bh = bh->b_next;
	}
	mark_buffer_dirty (bh,dirty_val);
}

void xmsdos_set_uptodate (
	struct super_block *sb,
	struct buffer_head *bh,
	int val)
{
	if (sb->s_blocksize != 512){
		bh = bh->b_next;
	}
	bh->b_uptodate = val;
}
int xmsdos_is_uptodate (
	struct super_block *sb,
	struct buffer_head *bh)
{
	if (sb->s_blocksize != 512){
		bh = bh->b_next;
	}
	return bh->b_uptodate;
}

void xmsdos_ll_rw_block (
	struct super_block *sb,
	int opr,
	int nbreq,
	struct buffer_head *bh[32])
{
	if (sb->s_blocksize == 512){
		ll_rw_block(opr,nbreq,bh);
	}else{
		struct buffer_head *tmp[32];
		int i;
		for (i=0; i<nbreq; i++){
			tmp[i] = bh[i]->b_next;
		}
		ll_rw_block(opr,nbreq,tmp);
	}
}

