//
// $Header: i:/ifs/RCS/32BITS/IFS-OS2/console/stdout.c,v 1.4 1998/02/07 14:16:02 STEINER Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOS
#define INCL_WIN
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <os2/ifsdbg.h>
#include <os2/types.h>
#include <os2/errors.h>

HEV         hev;

static char Buf[4096];
static char Buf2[4096];

extern HWND hwnd_output;

void stdout_thread(void *parm) {
    ULONG  dataio;
    ULONG  parmio;
    APIRET rc;
    unsigned short *Tmp;
    char           *tmp;

    DosWaitEventSem(hev, SEM_INDEFINITE_WAIT);
    for (;;) {
        dataio = 0;
        parmio = 0;
        memset(Buf, 0, 8192);
        if ((rc = DosFSCtl (
                            Buf, 4096, &dataio,
                            NULL, 0, &parmio,
                            IFSDBG_READ,
#ifndef VFATOS2_VER
                            "ext2",
#else
                            "vfat",
#endif
                            -1,  FSCTL_FSDNAME)) != NO_ERROR) {
            abort();
        } else {
            tmp = Buf;
            while ((tmp[0] != '\0') && (tmp[1] != '\0')){
                Tmp = (USHORT *)tmp;
                switch(Tmp[0]) {

                    case LOG_FS_ERR :
                        {
                            err_record *err_rec = (err_record *)Tmp;
                            sprintf(
                                   Buf2,
                                   "===> ERROR : %s() called from %s() (%s - line %d) - rc = 0x%04X\n",
                                   func[err_rec->errfunction],
                                   func[err_rec->infunction],
                                   sourcefile[err_rec->sourcefile],
                                   err_rec->sourceline,
                                   err_rec->retcode
                                  );
                            tmp += sizeof(err_record);
                        }
                        break;

                    default :
                        sprintf(Buf2, "%s\n", tmp);
                        tmp += strlen(tmp) + 1;
                        break;
                } /* end switch */
                WinPostMsg(hwnd_output, MLM_INSERT, Buf2, MPFROMLONG(0));
printf(Buf2);
            }
        }
    }

}

static void _System terminate_output(void) {
    APIRET rc;
    ULONG  dataio;
    ULONG  parmio;

    dataio = 0;
    parmio = 0;
    DosFSCtl ( NULL,  0, &dataio,
               NULL,  0, &parmio,
               IFSDBG_CLOSE,
#ifndef VFATOS2_VER
               "ext2",
#else
               "vfat",
#endif
              -1,  FSCTL_FSDNAME);
    DosExitList(EXLST_EXIT, terminate_output);

}

int init_output(void) {
    APIRET rc;
    ULONG  dataio;
    ULONG  parmio;

    dataio = 0;
    parmio = 0;
    if ((rc = DosFSCtl ( NULL,  0, &dataio,
                         NULL,  0, &parmio,
                         IFSDBG_OPEN,
#ifndef VFATOS2_VER
                         "ext2",
#else
                         "vfat",
#endif
                         -1,  FSCTL_FSDNAME)) == NO_ERROR) {
        if ((rc = DosExitList(EXLST_ADD, terminate_output)) == NO_ERROR) {
            if ((rc = DosCreateEventSem(0, &hev, 0, 0)) == NO_ERROR) {
                _beginthread(stdout_thread, 0, 16384, 0);
            }
        }
    }
    return rc;
}
