#ifndef SAMPLE_DEF
#define SAMPLE_DEF

/*******************  Machine-dependant data types  *******************/
#define FLOAT                 double
#define PFLOAT                FLOAT *
#define DOUBLE                double
#define PDOUBLE               DOUBLE *

/*******************  Position and size at startup  *******************/
#define STARTPOS_XL           100
#define STARTPOS_YB           100
#define STARTPOS_CX           400
#define STARTPOS_CY           400

/***********************  Machine-dependant constants  **********************/
#define VS_MAX_X             1023  /* video: hor. resolution */
#define VS_MAX_Y              768  /* video: ver. resolution */

/********************************  CONSTANTS  *******************************/
/****** General ******/
#define MESSAGELEN             80  /* size of text buffer */
#define RETURN_SUCCESS          0  /* return values for main thread */
#define RETURN_ERROR            1
#define BEEP_WARN_FREQ         60  /* beep codes for early return */
#define BEEP_WARN_DUR          80
#define M_TRUE        (MRESULT)1L  /* return values for window procedures */
#define M_FALSE       (MRESULT)0L
#define Pi           3.1415926536
#define fEps        (FLOAT)1.0E-5  /* almost zero */

/****** Program level ******/
#define PROGNAME    (PSZ)"sample"  /* name of this program */
#define TITLELEN               12  /* length of title string body */

/****** Module level ******/
/* command.c */
#define DEF_COLOR            TRUE

/* func.c */
#define MSGBOXID                2

/* window.c */
#define DEF_REALSTART        -1.6
#define DEF_REALEND           1.6
#define DEF_IMAGSTART        -1.0
#define DEF_IMAGEND           1.0
#define DEF_REALCONST       -0.77
#define DEF_IMAGCONST       0.105

/**************************  TP SYSTEM  INTERFACE  *************************/
#define TP_BUFFER_SIZE      12288  /* bytes, must be >= occ\root.inc\MAX.HOST.BUFSIZ */
#define SRV_TIMEOUT           200  /*  x 10 ms */
#define ID_TPTIMER  TID_USERMAX-1  /* polling interval timer for long TP commands */
#define SRV_POLLINTERVAL      50L  /* polling interval time [msec] for long TP commands */

/* commands to the TP */
#define TP_ITERATE              1
#define TP_TEST_WR              2
#define TP_TEST_RD              3

/* commands from the TP */
#define HCMD_ACK                1
#define HCMD_NAK                2
#define HCMD_ENDTIMER           3
#define HCMD_PIXEL              4
#define HCMD_TESTDATA           5

/*******************************  LINK TEST  ********************************/
#define TEST_N_BLOCKS          100  /* number of blocks to be transferred */
#define TEST_BLOCK_LENGTH_1    300  /* block size 1 in bytes */
#define TEST_BLOCK_LENGTH_2    2000  /* block size 2 in bytes, max 10000 */
#define MAX_TEST_BLOCK_LENGTH  TEST_BLOCK_LENGTH_2  /* max. block size */

/*******************************  STRUCTURES  *******************************/
#ifndef INCL_GPIBITMAPS
typedef struct _RGB2 {
    BYTE bBlue;
    BYTE bGreen;
    BYTE bRed;
    BYTE fcOptions;
} RGB2;
#endif

/* Window structure */
typedef struct {
  HWND   hwnd;                     /* frame window handle */
  HWND   hwndMenu;                 /* menu handle (optional) */
  HWND   hwndClient;               /* client window handle (optional) */
  HDC    hdcMem;                   /* memory device context (optional) */
  HPS    hpsMem;                   /* memory presentation space (optional) */
  SIZEL  sizel;                    /* size of client area (optional) */
  } WIN;
typedef WIN *PWIN ;

/* iteration paramters */
#pragma pack(1)
typedef struct {
  ULONG  lDataLength;              /* this not included */
  ULONG  lcx;
  ULONG  lcy;
  ULONG  MaxIt;
  FLOAT  RealConst;
  FLOAT  ImagConst;
  FLOAT  RealStart;
  FLOAT  RealEnd;
  FLOAT  ImagStart;
  FLOAT  ImagEnd;
  } PARAMS;
#pragma pack()
#define PPARAMS PARAMS FAR *

/******************************  PM MESSAGES  *******************************/
#define WMU_ENDTIMER  WM_USER + 1

/************************  FUNCTION PREDECLARATIONS  ************************/
/* command.c */
VOID Command (HWND, MPARAM);
BOOL CmdStart (HWND);

/* func.c */
BOOL  OpenFunc (void);
VOID  CloseFunc (void);
HDC  CreateMemDC (HDC *);
VOID  About (HWND);
BOOL  ErrorMsg (HWND, SHORT);
VOID  FillBoxLong (HWND, USHORT, LONG);
VOID  FillBoxDouble (HWND, USHORT, DOUBLE);
LONG  GetBoxLong (HWND, USHORT);
DOUBLE  GetBoxDouble (HWND, USHORT);
VOID  EnableMenu (HWND, USHORT, BOOL);
VOID  SetWindowText (HWND);
BOOL    PutError (HWND hwnd, PSZ psz, ...);

/* main.c */
int main (void);

/* window.c */
MRESULT EXPENTRY WndProc (HWND, USHORT, MPARAM, MPARAM);
VOID  SetParamDefaults (void);

/********************************  MACROS  ********************************/
#define GETPOINTERPOS(pptl,mp) {pptl->x = (LONG)LOUSHORT (mp); pptl->y = (LONG)HIUSHORT (mp);}

#endif  /* SAMPLE_DEF */
