/*****************************************************************************
* SAMPLE (C) D. FRIEAUFF, 1991                                               *
******************************************************************************/

#define  INCL_PM
#define  INCL_DOS
#include <os2.h>

#include "rc.h"
#include "sample.h"

/*******************
* Global variables *
********************/
HAB			hab;    /* anchor block handle */
WIN                     w;	/* window */
HMQ                     hmq;    /* message queue handle */
QMSG	 		qmsg;	/* current message retrieved from queue */

/*******
* Main *
********/
int main (void)
{
ULONG	flCtlData;

/* initialize application */
if (!(hab = WinInitialize (0))) goto Error;

/* create the message queue */
if (!(hmq = WinCreateMsgQueue (hab, 10))) goto Error;

/* create buffer for misc. functions */
if (OpenFunc ()) goto Error;

/*  register top window class  */
if (!WinRegisterClass (hab, PROGNAME, (PFNWP)WndProc,
                       CS_SIZEREDRAW | CS_SAVEBITS | CS_SYNCPAINT, 0)) {
   CloseFunc ();
   goto Error; }

/* create the top window */
flCtlData = FCF_STANDARD & ~FCF_ICON & ~FCF_ACCELTABLE;
w.hwnd = WinCreateStdWindow (HWND_DESKTOP, 0L, &flCtlData, PROGNAME, NULL, 0L,
                             (HMODULE)0L, IDR_MAIN, (PHWND)&(w.hwndClient));
if ((w.hwnd == 0) || (w.hwndClient == 0)) {
   CloseFunc ();
   goto Error; }
w.hwndMenu = WinWindowFromID (w.hwnd, (USHORT)FID_MENU);
SetWindowText (WinWindowFromID (w.hwnd, (USHORT)FID_TITLEBAR));
WinSetWindowPos (w.hwnd, HWND_TOP, STARTPOS_XL, STARTPOS_YB,
                 STARTPOS_CX, STARTPOS_CY,
                 SWP_ACTIVATE | SWP_SIZE | SWP_MOVE | SWP_SHOW);

/* main loop */
while (WinGetMsg (hab, (PQMSG)&qmsg, 0L, 0, 0))
  WinDispatchMsg (hab, (PQMSG)&qmsg);

/* terminate application */
WinDestroyWindow (w.hwnd);
WinDestroyMsgQueue (hmq);
WinTerminate (hab);

/* close GenFunc module and return */
CloseFunc ();
return (RETURN_SUCCESS);

Error:
  WinTerminate (hab);
  DosBeep (BEEP_WARN_FREQ, BEEP_WARN_DUR);
  return (RETURN_ERROR);
}
