#define  INCL_PM
#define  INCL_DOS
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>
#include <string.h>
#include <os2.h>

#include "sample.h"
#include "rc.h"

extern HAB   hab;
static PCHAR szText; /* buffer for misc. string handling */

/************************************
* OpenFunc ***                      *
*                                   *
* Start-Up function for this module *
*************************************/
BOOL OpenFunc (void)
{
if (DosAllocMem ((void *)&szText, MESSAGELEN, fALLOC)) return (TRUE);
return (FALSE);
}

/**************************************
* CloseFunc                           *
*                                     *
* Close-Down function for this module *
***************************************/
VOID CloseFunc (void)
{
DosFreeMem (szText);
}

/*********************
* CreateMemDC        *
*   Create memory DC *
**********************/
HDC CreateMemDC (HDC *phdc)
{
static DEVOPENSTRUC dop;

dop.pszLogAddress = NULL;
dop.pszDriverName = (PSZ)"DISPLAY";
dop.pdriv = NULL;
dop.pszDataType = NULL;
*phdc = DevOpenDC (hab, OD_MEMORY, "*", 4L, (PDEVOPENDATA)&dop, (HDC)0L);
return (*phdc);
}

/********
* About *
*********/
VOID About (HWND hwnd)
{
WinLoadString (hab, (HMODULE)0L, IDS_ABOUT_TEXT, MESSAGELEN, szText);
WinMessageBox (HWND_DESKTOP, hwnd, szText, (PSZ)"About...", 0, MB_NOICON | MB_OK);
}

/***********
* ErrorMsg *
************/
BOOL ErrorMsg (HWND hwndOwner, SHORT idMsg)
{
if (!WinLoadString (hab, (HMODULE)0L, idMsg, MESSAGELEN, (PSZ)szText)) {
   WinAlarm (HWND_DESKTOP, WA_ERROR);
   return (TRUE); }
return (WinMessageBox (HWND_DESKTOP, hwndOwner, szText, NULL, MSGBOXID,
                       MB_OK | MB_ICONHAND | MB_APPLMODAL));
}

/**************
* FillBoxLong *
***************/
VOID FillBoxLong (HWND hDlg, USHORT usItem, LONG l)
{
sprintf (szText, "%.ld", l);
WinSetDlgItemText (hDlg, usItem, szText);
}

/****************
* FillBoxDouble *
*****************/
VOID FillBoxDouble (HWND hDlg, USHORT usItem, DOUBLE fVal)
{
sprintf (szText, "%.3f", fVal);
WinSetDlgItemText (hDlg, usItem, szText);
}

/*************
* GetBoxLong *
**************/
LONG GetBoxLong (HWND hDlg, USHORT usItem)
{
WinQueryDlgItemText (hDlg, usItem, MESSAGELEN, szText);
return (atol (szText));
}

/***************
* GetBoxDouble *
****************/
DOUBLE GetBoxDouble (HWND hDlg, USHORT usItem)
{
WinQueryDlgItemText (hDlg, usItem, MESSAGELEN, szText);
return (atof (szText));
}

/*************
* EnableMenu *
**************/
VOID EnableMenu (HWND hwndMenu, USHORT usId, BOOL fEnable)
{
WinSendMsg (hwndMenu, MM_SETITEMATTR, MPFROM2SHORT (usId, TRUE),
            MPFROM2SHORT (MIA_DISABLED, fEnable ? 0 : MIA_DISABLED));
}

/****************
* SetWindowText *
*****************/
VOID SetWindowText (HWND hwnd)
{
/* set the main window text */
WinLoadString (hab, (HMODULE)0L, IDS_WINDOW_TEXT, MESSAGELEN, szText);
WinSetWindowText (hwnd, szText);
}

/***********
* PutError *
************/
BOOL PutError (HWND hwnd, PSZ psz, ...)
{
va_list vList;

va_start (vList, psz);
vsprintf (szText, psz, vList);
WinMessageBox (HWND_DESKTOP, hwnd, szText, "Error", 0, MB_ICONHAND | MB_OK);
va_end (vList);
return (TRUE);
}
