#include "includes.h"



#pragma argsused

APIRET EXPENTRY FS_WRITE (
    struct sffsi *psffsi,
    struct sffsd *psffsd,
    PCHAR	pData,
    PUSHORT	pLen,
    USHORT	IOflag )	/* not used */
{
  int       rc;
  POPENFILE pOpenfile;
  ULONG     cbNewPos;
  BLOCK     blkFile;

  UtilEnterRamfs();
  DEBUG_PRINTF2 ("FS_WRITE  sfn=%d *pLen=%u", psffsi->sfi_selfsfn, *pLen);

  pOpenfile = psffsd->pOpenfile;
  VMReadBlk (&blkFile, pOpenfile->flatEntry + FIELDOFFSET(DIRENTRY,blkFile));

#ifdef DEBUG
  if (blkFile.cbSize != psffsi->sfi_size)
  {
    debugging = TRUE;
    DEBUG_PRINTF2 ("\r\n!!! blkFile.cbSize = %lu, sfi_size = %lu\r\n",
		   blkFile.cbSize, psffsi->sfi_size);
    INT3;
  }
#endif

  cbNewPos = psffsi->sfi_position + *pLen;
  if (cbNewPos > psffsi->sfi_size)
  {
    rc = BlockRealloc (&blkFile, cbNewPos);
    if (rc)
      goto end;
    VMWriteBlk (pOpenfile->flatEntry + FIELDOFFSET(DIRENTRY,blkFile), &blkFile);
    psffsi->sfi_size = cbNewPos;
  }
  VMWrite (blkFile.flatAddr + psffsi->sfi_position, pData, *pLen);
  psffsi->sfi_position = cbNewPos;
  psffsi->sfi_tstamp |= (ST_SWRITE | ST_PWRITE);

  rc = NO_ERROR;

end:

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
