#include "includes.h"



#pragma argsused

APIRET EXPENTRY FS_NEWSIZE (
    struct sffsi *psffsi,
    struct sffsd *psffsd,
    ULONG	len,
    USHORT	IOflag )	/* not used */
{
  int       rc;
  POPENFILE pOpenfile;
  BLOCK     blkFile;

  UtilEnterRamfs();
  DEBUG_PRINTF2 ("FS_NEWSIZE  sfn=%d, len=%lu", psffsi->sfi_selfsfn, len);

  pOpenfile = psffsd->pOpenfile;
  VMReadBlk (&blkFile, pOpenfile->flatEntry + FIELDOFFSET(DIRENTRY,blkFile));

#ifdef DEBUG
  if (blkFile.cbSize != psffsi->sfi_size)
  {
    debugging = TRUE;
    DEBUG_PRINTF2 ("\r\n!!! blkFile.cbSize = %lu, sfi_size = %lu\r\n",
		  blkFile.cbSize, psffsi->sfi_size);
    INT3;
  }
#endif

  rc = BlockRealloc (&blkFile, len);
  if (rc == NO_ERROR)
  {
    VMWriteBlk (pOpenfile->flatEntry + FIELDOFFSET(DIRENTRY,blkFile), &blkFile);
    psffsi->sfi_size = len;
  }

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
