#include "includes.h"



#pragma argsused

APIRET EXPENTRY FS_CHGFILEPTR (
    struct sffsi *psffsi,
    struct sffsd *psffsd,	/* not used in retail */
    LONG	offset,
    USHORT	type,
    USHORT	IOflag )	/* not used */
{
  int rc;

  UtilEnterRamfs();
  DEBUG_PRINTF3 ("FS_CHGFILEPTR  sfn=%d, offset=%ld, type=%d",
		 psffsi->sfi_selfsfn, offset, type);

#ifdef DEBUG
  {
    BLOCK blkFile;

    VMReadBlk (&blkFile, psffsd->pOpenfile->flatEntry + FIELDOFFSET(DIRENTRY,blkFile));
    if (blkFile.cbSize != psffsi->sfi_size)
    {
      debugging = TRUE;
      DEBUG_PRINTF2 ("\r\n!!! blkFile.cbSize = %lu, sfi_size = %lu\r\n",
		     blkFile.cbSize, psffsi->sfi_size);
      INT3;
    }
  }
#endif

  switch (type)
  {
    case 0: /* relative to beginning of file */
	    psffsi->sfi_position = offset;
	    break;

    case 1: /* relative to current position */
	    psffsi->sfi_position += offset;
	    break;

    case 2: /* relative to end of file */
	    psffsi->sfi_position = psffsi->sfi_size + offset;
	    break;
  }

  rc = NO_ERROR;

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
