/******************************************************************************
 *
 *  QCAMDD.H - Header file for the QuickCam device driver.
 *
 *****************************************************************************/

/*
 *  Return codes.
 */
#define QCAM_OK                 0
#define QCAM_ERROR              -1

/*
 *  Camera defaults.
 */
#define QCAM_DEF_CONTRAST       104
#define QCAM_DEF_BRIGHT         210

/*
 *  Bounds for camera image.
 */
#define QCAM_MIN_LEFT           1
#define QCAM_MIN_TOP            1
#define QCAM_MAX_WIDTH          320
#define QCAM_MAX_HEIGHT         240
#define QCAM_MAX_PALETTE        64

/*
 *  Category to use when making IOCTL calls.
 */
#define QCAM_IOCTL_CATEGORY   0xA0      // Should not conflict with others

/*
 *  IOCTL functions supported by this driver.
 */
#define QCAM_IOCTL_ALLOC_BUF    1       // Get 32-bit pointer to image buffer
#define QCAM_IOCTL_FREE_BUF     2       // Free the allocated buffer
#define QCAM_IOCTL_GET_FRAME    3       // Fill buffer with camera image
#define QCAM_IOCTL_SET_CAMERA   4       // Make adjustments to camera settings

/*
 *  Main structure used to communicate camera settings to the driver.
 */
typedef struct
        {
        USHORT  left;           // Frame within CCD window to view
        USHORT  top;
        USHORT  right;
        USHORT  bottom;
        UCHAR   depth;          // Pixel depth: either 4-bit or 6-bit
        UCHAR   transfer_mode;  // Capture every 1, 2, or 4 pixels
        UCHAR   contrast;       // Camera image adjustments
        UCHAR   exposure;
        UCHAR   balance;
        UCHAR   camera_version; // Version of the camera firmware
        UCHAR   port_number;    // Printer port to connect to (1-3, 0 for auto)
        USHORT  port_address;   // Base address for printer port
        UCHAR   port_mode;      // 0=unidirectional  1=bidirectional
        UCHAR   delay_factor;   // Set the "settling" delays within the driver
        } QCAM_SETTINGS;

/*
 *  Things that can be requested in the IOCTL Setup call.  Requests can be
 *  combined in a single call.
 */
#define QCAM_GET_SETTINGS       0x0000  // Just return the current settings
#define QCAM_INITIALIZE         0x0001  // Initialize the camera
#define QCAM_AUTO_CALIBRATE     0x0002  // Determines the white balance
#define QCAM_SET_CONTRAST       0x0004  // Contrast
#define QCAM_SET_EXPOSURE       0x0008  // Exposure time
#define QCAM_SET_DEPTH          0x0010  // Pixel depth
#define QCAM_SET_TRANS_MODE     0x0020  // Every 1, 2, or 4th pixel
#define QCAM_SET_FRAME          0x0040  // Frame within CCD window
#define QCAM_SET_BALANCE        0x0080  // White balance
#define QCAM_SET_PORT           0x0100  // Setup the printer port
#define QCAM_SET_DELAY          0x0200  // Change the delay factor

/*
 *  Parameters used when "opening" the camera for use.
 */
#define QCAM_OPEN_NAME          "QCAM$" // Device driver name
#define QCAM_OPEN_SIZE          0L      // Logical file size (not required)
#define QCAM_OPEN_ATTRIBUTE     0L      // Normal file (not required)
#define QCAM_OPEN_FLAG          0x01    // Open device
#define QCAM_OPEN_MODE          0x2042  // Fail on error, deny none, read-write
#define QCAM_OPEN_EABUF         0L      // No extended attributes

/*
 *  Parameters used when "reading" images from the camera.
 */
#define QCAM_READ_MAXBUF        57600   // Maximum size required for buffer

/*
 *  Valid values for Transfer Modes.
 */
#define QCAM_EVERY_PIXEL        1
#define QCAM_EVERY_2ND_PIXEL    2
#define QCAM_EVERY_4TH_PIXEL    4
                                        
/*
 *  Valid values for bit depth (gray levels).
 */
#define QCAM_DEPTH_16GRAYS      4
#define QCAM_DEPTH_64GRAYS      6
